jQuery(function($){
	$("#edificios_filter_div").toggle();
	
	$("#GRID_edificios").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 1012,
		url: "../edificios",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "idedificio",
		ondblClickRow : fncDetalleEdificio,
		colNames: [
		    $.rup.i18n.app.GRID_cabeceras.codigo,
		    $.rup.i18n.app.GRID_cabecerasEdificios.territorio,
		    $.rup.i18n.app.GRID_cabecerasEdificios.edificio,
		    $.rup.i18n.app.GRID_cabecerasEdificios.edificio,
		    $.rup.i18n.app.GRID_cabeceras.dRed,
		    $.rup.i18n.app.GRID_cabecerasEdificios.feini,
		    $.rup.i18n.app.GRID_cabecerasEdificios.baja,
		    $.rup.i18n.app.GRID_cabecerasEdificios.gestCentra
		],
		colModel: [
			{ name: "idedificio",
				label: "Código",
				index: "idedificio",
				width: "20",
				editable: true,
				edittype: "text"
			},
			{ name: "idterri",
				label: "idterri",
				index: "idterri",
				width: "50",
				editable: true,
				edittype: "text",
				formatter :
			    	masiveIconFormatter = function(cellval, el, opts)
			    	{
						var html = '';
				    	html = eval("$.rup.i18n.app.territorios.p" + cellval);
						return html;
			    	}
			},
			{ name: "cedificio",
				label: "Edificio",
				index: "cedificio",
				width: "150",
				editable: true,
				edittype: "text",
				hidden: $.rup_utils.capitalizedLang() =="Es"?false:true
			},
			{ name: "eedificio",
				label: "Edificio",
				index: "eedificio",
				width: "150",
				editable: true,
				edittype: "text",
				hidden: $.rup_utils.capitalizedLang() =="Es"?true:false
			},
			{ name: "redificio",
				label: "rdificio",
				index: "redificio",
				width: "25",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "feini",
				label: "feini",
				index: "feini",
				width: "60",
				editable: true,
				edittype: "text",
				rupType: "datepicker",
				formatter: "date"
					
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: true,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			},
			{ name: "gestCentra",
				label: "gestCentra",
				index: "gestCentra",
				width: "40",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	

	$("#edificios").rup_maint({
		jQueryGrid: "GRID_edificios",
		primaryKey: "idedificio",
		modelObject: "Edificios",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		onafterDetailShow: function(){
			$("#edificios").rup_maint("search");
		},
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [/*{
					obj: {
						id:"MiNuevo",
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncNuevoEdificio
					},*/
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleEdificio
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.sincronizar,
							css: "rup-maint_sincronizar"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncSubirEdificiosGmao
					}
					]
			}
	});
	

	//Si el usuario que accede no es adiministrado se oculta el botón de nuevo
	if ($("#usuarioEsAdministrador").val()!="true"){
		$("#rup-maint_toolbar-edificios button:nth-child(1)").hide();	
	}else{
		$("#rup-maint_toolbar-edificios button:nth-child(1)").show();
	}
	
	
	
	//Se Crea el combo de seleccion de territorios
	$('#territorioCombo').rup_combo({
		source : [
				{i18nCaption: $.rup.i18n.app.territorios._blank, value:""},
				{i18nCaption: $.rup.i18n.app.territorios.p1, value:"1"},
				{i18nCaption: $.rup.i18n.app.territorios.p20, value:"20"},
				{i18nCaption: $.rup.i18n.app.territorios.p48, value:"48"}
		         ],
		width: 100,
		select: function(){
			//asignar el valor seleccionado al campo del formulario que actualiza el valor
			$("#idterri_search").val($("#territorioCombo").rup_combo("value"));
		},
		orderedByValue: true,
		style : "dropdown"	
	});
	
	
	//Dialogo con el mensaje y barra de sincronizar con gmao...
	$("#dialogoSincronizar").rup_dialog(
	{
		type : $.rup.dialog.DIV,
		height : 200,
		width : 500,
		modal : true,
		showLoading : true,
		autoOpen : false,
		title : $.rup.i18n.app.mensajesEdificios.sincronizando
	});

	
	$("#feini_search").rup_date();
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_edificios").unbind("click");
	$("#clean_search_edificios").bind("click",limpiarFormBusqueda);
	
	$("#edificios").rup_maint("search");
});

function fncNuevoEdificio(){
	//alert("Nuevo Edificio");
	window.location = "/aa20bMaqPartesWar/edificios/nuevoEdificio";
}
function fncDetalleEdificio(){
	var id= $("#GRID_edificios").rup_grid('getGridParam','selrow');
	 //alert(id);
	 var ret = $("#GRID_edificios").rup_grid('getRowData',id); 
	 var idEdificio =ret.idedificio;
	 
	    // enviamos el form alternativo con el idEdificio para la busqueda
		buscaEdificioForm.idEdificioBusc.value = idEdificio;
		buscaEdificioForm.submit();
	return false; 		
}

function fncSubirEdificiosGmao(){
	var propertiesOK = {
				type: "ok",
				fadeSpeed: 600,
				gotoTop: false,
				block: false,
				closeLink: false
		};
	
	var propertiesError = {
				type: "error",
				fadeSpeed: 600,
				gotoTop: false,
				block: true,
				closeLink: false
		};
	
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificios.sincronizar"),			
		message: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificios.msjSincronizarGmao"),
		OKFunction: function(){
			var respuesta = '';
			$.ajax({
				type: "POST",
				url: "../procesosGmao/subirTodosEdificiosGmao",
				dataType: "json",
				beforeSend : function(data) {
					//Mostrar div de sincronizando
					$("#dialogoSincronizar").rup_dialog("open");
				},
				success: function(data){
					$("#dialogoSincronizar").rup_dialog("close");
					
					respuesta = data;
					if(respuesta == "OK"){
						$("#feedback_edificios").rup_feedback (propertiesOK);
						$("#feedback_edificios").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.okSincronizar + "</strong></p>");
						$("#feedback_edificios").rup_feedback("show");
					}else if (respuesta == ""){
					
					}else{
						$("#feedback_edificios").rup_feedback (propertiesError);
						$("#feedback_edificios").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + ": " + respuesta + "</strong></p>");
						$("#feedback_edificios").rup_feedback("show");
					}
						  
				},
				error: function(data) {
					$("#dialogoSincronizar").rup_dialog("close");
			 		$("#feedback_edificios").rup_feedback (propertiesError);
			 		$("#feedback_edificios").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + "</strong></p>");
			 		$("#feedback_edificios").rup_feedback("show");
					  
				}
			});
			
			
		},
		CANCELFunction : function(){
		}
		});
}

function asignarValor(){
	// Convertimos los checkbox a 0 y 1 en funcion de si están seleccionados o no
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function limpiarFormBusqueda() {
	$("#baja_search").prop('checked', false);
	$("#gestCentra_search").prop('checked', false);
	
	$("#edificios").rup_maint("cleanSearchForm");
	$("#edificios").rup_maint("search");
}
function buscar(){
	$("#edificios").rup_maint("search");
}
function activarCheck(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}
$(window).load(function() {
	$('#territorioCombo').rup_combo("setRupValue",$("#idterri_search").val());
});

function ocultarBusqueda(){
	
	$("#edificios_filter_div").toggle("slow",function(){
		
	});
}