jQuery(function($){
	$("#codigos_filter_div").toggle();
			
	$("#GRID_codigos").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../codigo",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "idcodigo",
		ondblClickRow : fncDetalleCodigo,
		colNames: [
		    $.rup.i18n.app.GRID_cabeceras.codigo,
			$.rup.i18n.app.GRID_cabeceras.descCas,
			$.rup.i18n.app.GRID_cabeceras.descEus,		
			$.rup.i18n.app.mensajesServicio.servicio,
			$.rup.i18n.app.mensajesClase.clase,		
		    $.rup.i18n.app.GRID_cabeceras.feini,
		    $.rup.i18n.app.GRID_cabeceras.baja,
		    $.rup.i18n.app.GRID_cabeceras.usupubli,
		    $.rup.i18n.app.GRID_cabeceras.recibeinci,
		    $.rup.i18n.app.GRID_cabeceras.contrata,
		    $.rup.i18n.app.GRID_cabeceras.urgente
		],
		colModel: [
			{ name: "idcodigo",
				label: "idcodigo",
				index: "idcodigo",
				width: "50",
				editable: true,
				edittype: "text"
			},
			{ name: "ccodigo",
				label: "ccodigo",
				index: "ccodigo",
				width: "150",
				editable: true,
				edittype: "text",
				hidden: $.rup_utils.capitalizedLang() =="Es"?false:true
			},
			{ name: "ecodigo",
				label: "ecodigo",
				index: "ecodigo",
				width: "150",
				editable: true,
				edittype: "text",
				hidden: $.rup_utils.capitalizedLang() =="Es"?true:false
			},
			{ name: "servicio." + obtenerIdioma() + "servicio",
				label: "servicio." + obtenerIdioma() + "servicio",
				index: obtenerIdioma() + "servicio",
				width: "100",
				editable: true,
				edittype: "text"
			},
			{ name: "clase." + obtenerIdioma() + "clase",
				label: "clase." + obtenerIdioma() + "clase",
				index: "idclase",
				width: "100",
				editable: true,
				edittype: "text"
			},
			{ name: "feini",
				label: "feini",
				index: "feini",
				width: "70",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			},
			{ name: "usupubli",
				label: "usupubli",
				index: "usupubli",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			},
			{ name: "recibeinci",
				label: "recibeinci",
				index: "recibeinci",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			},
			{ name: "contrata",
				label: "contrata",
				index: "contrata",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			},
			{ name: "urgente",
				label: "urgente",
				index: "urgente",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	

	$("#codigos").rup_maint({
		jQueryGrid: "GRID_codigos",
		primaryKey: "idcodigo",
		modelObject: "Codigo",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: nuevoCodigo
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleCodigo
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.sincronizar,
							css: "rup-maint_sincronizar"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncSubirCodigosGmao
					}
	
					]
			}
				
	});
	
	//Dialogo con el mensaje y barra de sincronizar con gmao...
	$("#dialogoSincronizar").rup_dialog(
	{
		type : $.rup.dialog.DIV,
		height : 200,
		width : 500,
		modal : true,
		showLoading : true,
		autoOpen : false,
		title : $.rup.i18n.app.mensajesEdificios.sincronizando
	});
	
	
/*DIÁLOGO NUEVO TIPO INI*/
	
	var ventanaDialogoNuevoCodigo= $("#dialogoEditarCodigo").rup_dialog({
		type: jQuery.rup.dialog.DIV,
		autoOpen: false,
		id:"nuevoCodigo",
		modal: true,
		height: 700,
		resizable: false,
		minWidth: 880,
		showLoading:true,
		title: $.rup.i18n.app.mensajesCodigo.codigo,
		close: function(event, ui) { $("#GRID_codigos").rup_grid("reloadGrid"); }
	});
	
	function nuevoCodigo() {
		//Para abrirlo en el diálogo con un iFrame
		var ventanaIFrame ='../codigo/nuevo';
		document.getElementById("iframeEditarCodigo").src = ventanaIFrame;
		$("#dialogoEditarCodigo").rup_dialog("open");
	}
	
	
	$("#iframeNuevoCodigo").load(function (){ ;});	
	/*DIÁLOGO NUEVO Codigo FIN*/
	
	
	function fncDetalleCodigo(){
		var id= $("#GRID_codigos").rup_grid('getGridParam','selrow');
		 //alert(id);
		 var ret = $("#GRID_codigos").rup_grid('getRowData',id); 
		 var idCodigo =ret.idcodigo;	 
		 
		 
		    // enviamos el form alternativo con el idEdificio para la busqueda
			buscaCodigoForm.idCodigoBusc.value = idCodigo;
			buscaCodigoForm.submit();
		return false; 		
	}
	
	/* DIALOGO DETALLE */
	function fncDetalleCodigo_all() {
	
		var ventanaDialogoDetalleCodigo = $("#dialogoEditarCodigo").rup_dialog({
			type: jQuery.rup.dialog.DIV,
			autoOpen: false,
			id:"detalleCodigo",
			modal: true,
			resizable: false,
			height: 750,
			minWidth: 880,
			showLoading:true,
			title: $.rup.i18n.app.nuevo.Codigo,
			close: function(event, ui) { $("#GRID_codigos").rup_grid("reloadGrid"); }
		});
		
		 var id= $("#GRID_codigos").rup_grid('getGridParam','selrow');
		 //alert(id);
		 var ret = $("#GRID_codigos").rup_grid('getRowData',id); 
		 var idCodigo =ret.idcodigo;	 
		 var ventanaIFrame ="../codigo/modificar?idCodigo="+idCodigo;
	
		  document.getElementById("iframeEditarCodigo").src = ventanaIFrame;
			$("#dialogoEditarCodigo").rup_dialog("open");
		
		  $("#iframeEditarCodigo").load(function (){ ;});
	
		return false;
	}
	/* FIN DIALOGO DETALLE */
	
	$("#feini_search").rup_date();
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_codigos").unbind("click");
	$("#clean_search_codigos").bind("click",limpiarFormBusqueda);
	
	$("#codigos").rup_maint("search");

});

function cerrarIFrameNuevoCodigo() {
	if ($("#dialogoEditarCodigo").rup_dialog('isOpen')) {
		$("#dialogoEditarCodigo").rup_dialog('close');
		document.getElementById("iframeEditarCodigo").src = '';
	}
}


function obtenerIdioma(){
    var idioma="";       
    if ($.rup_utils.capitalizedLang() =="Es") {    
          idioma = "c";
    } else idioma="e";
    return idioma;
}

function asignarValor(){
	// Convertimos los checkbox a 0 y 1 en funcion de si están seleccionados o no
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function limpiarFormBusqueda() {
	$("#baja_search").prop('checked', false);
	$("#usupubli_search").prop('checked', false);
	$("#recibeinci_search").prop('checked', false);
	$("#contrata_search").prop('checked', false);
	$("#urgente_search").prop('checked', false);
	
	$("#codigos").rup_maint("cleanSearchForm");
	$("#codigos").rup_maint("search");

}
function activarCheck(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function fncSubirCodigosGmao(){
	var propertiesOK = {
				type: "ok",
				fadeSpeed: 1500,
				gotoTop: false,
				block: false,
				closeLink: false
		};
	
	var propertiesError = {
				type: "error",
				fadeSpeed: 1500,
				gotoTop: false,
				block: true,
				closeLink: false
		};
	
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificios.sincronizar"),			
		message: $.rup.i18nParse($.rup.i18n.app,"mensajesCodigo.msjSincronizarGmao"),
		OKFunction: function(){
			var respuesta = '';
			$.ajax({
				type: "POST",
				url: "../procesosGmao/subirTodosCodigosGmao",
				dataType: "json",
				beforeSend : function(data) {
					//Mostrar div de sincronizando
					$("#dialogoSincronizar").rup_dialog("open");
				},
				success: function(data){
					$("#dialogoSincronizar").rup_dialog("close");
					
					respuesta = data;
					if(respuesta == "OK"){
						$("#feedback_codigos").rup_feedback (propertiesOK);
						$("#feedback_codigos").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.okSincronizar + "</strong></p>");
						$("#feedback_codigos").rup_feedback("show");
					}else if (respuesta == ""){
					
					}else{
						$("#feedback_codigos").rup_feedback (propertiesError);
						$("#feedback_codigos").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + ": " + respuesta + "</strong></p>");
						$("#feedback_codigos").rup_feedback("show");
					}
						  
				},
				error: function(data) {
					$("#dialogoSincronizar").rup_dialog("close");
			 		$("#feedback_codigos").rup_feedback (propertiesError);
			 		$("#feedback_codigos").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + "</strong></p>");
			 		$("#feedback_codigos").rup_feedback("show");
					  
				}
			});
			
			
		},
		CANCELFunction : function(){
		}
		});
}

function ocultarBusqueda(){
	
	$("#codigos_filter_div").toggle("slow",function(){
		
	});
}