jQuery(function($){
	$("#clases_filter_div").toggle();
	$("#GRID_clases").rup_grid({
		
		loadOnStartUp:false,
		hasMaint: true,
		width: 865,
		url: "../clase",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "asc",
		sortname: "idclase",
		ondblClickRow : fncDetalleClase,
		colNames: [
		    $.rup.i18n.app.GRID_cabeceras.codigo,
			$.rup.i18n.app.GRID_cabeceras.descCas,
			$.rup.i18n.app.GRID_cabeceras.descEus,		
		    $.rup.i18n.app.GRID_cabeceras.feini,
		    $.rup.i18n.app.GRID_cabeceras.baja,
		    $.rup.i18n.app.GRID_cabeceras.usupubli
		],
		colModel: [
			{ name: "idclase",
				label: "idclase",
				index: "idclase",
				width: "50",
				editable: true,
				edittype: "text"
			},
			{ name: "cclase",
				label: "cclase",
				index: "cclase",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "eclase",
				label: "eclase",
				index: "eclase",
				width: "150",
				editable: true,
				edittype: "text"
			},
			{ name: "feini",
				label: "feini",
				index: "feini",
				width: "70",
				editable: true,
				edittype: "text",
				align: 'center'
			},
			{ name: "baja",
				label: "baja",
				index: "baja",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			},
			{ name: "usupubli",
				label: "usupubli",
				index: "usupubli",
				width: "30",
				editable: false,
				edittype: "checkbox",
				formatter: "checkbox",
				align: 'center'
			}
        ]
		
	});
	

	$("#clases").rup_maint({
		jQueryGrid: "GRID_clases",
		primaryKey: "idclase",
		modelObject: "Clase",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		searchForm: "searchForm",
		showMessages: true,
		toolbar: {
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.nuevo,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncNuevoClase
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.editar,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleClase
					},
					{
						obj: {
							i18nCaption: $.rup.i18n.app.botones.sincronizar,
							css: "rup-maint_sincronizar"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncSubirClasesGmao
					}
	
					]
			}
				
	});
	
	
	/* FIN DIALOGO DETALLE */
	
	//Dialogo con el mensaje y barra de sincronizar con gmao...
	$("#dialogoSincronizar").rup_dialog(
	{
		type : $.rup.dialog.DIV,
		height : 200,
		width : 500,
		modal : true,
		showLoading : true,
		autoOpen : false,
		title : $.rup.i18n.app.mensajesEdificios.sincronizando
	});
	

	function fncNuevoClase(){
		window.location = "/aa20bMaqPartesWar/clase/nuevoClase";
	}

	function fncDetalleClase(){
		var id= $("#GRID_clases").rup_grid('getGridParam','selrow');
		 var ret = $("#GRID_clases").rup_grid('getRowData',id); 
		 var idClase =ret.idclase;
		 
		    // enviamos el form alternativo con el idClase para la busqueda
			buscaClaseForm.idClaseBusc.value = idClase;
			buscaClaseForm.submit();
		return false; 		
	}
	
	$("#feini_search").rup_date();
	
	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_clases").unbind("click");
	$("#clean_search_clases").bind("click",limpiarFormBusqueda);
	
	$("#clases").rup_maint("search");

});

function activarCheck(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}

function limpiarFormBusqueda() {
	$("#baja_search").prop('checked', false);
	$("#usupubli_search").prop('checked', false);
	
	$("#clases").rup_maint("cleanSearchForm");
	$("#clases").rup_maint("search");
}

function fncSubirClasesGmao(){
	var propertiesOK = {
				type: "ok",
				fadeSpeed: 1500,
				gotoTop: false,
				block: false,
				closeLink: false
		};
	
	var propertiesError = {
				type: "error",
				fadeSpeed: 1500,
				gotoTop: false,
				block: true,
				closeLink: false
		};
	
	$.rup_messages("msgConfirm", {
		title: $.rup.i18nParse($.rup.i18n.app,"mensajesEdificios.sincronizar"),			
		message: $.rup.i18nParse($.rup.i18n.app,"mensajesClase.msjSincronizarGmao"),
		OKFunction: function(){
			var respuesta = '';
			$.ajax({
				type: "POST",
				url: "../procesosGmao/subirTodosClasesGmao",
				dataType: "json",
				beforeSend : function(data) {
					//Mostrar div de sincronizando
					$("#dialogoSincronizar").rup_dialog("open");
				},
				success: function(data){
					$("#dialogoSincronizar").rup_dialog("close");
					
					respuesta = data;
					if(respuesta == "OK"){
						$("#feedback_clases").rup_feedback (propertiesOK);
						$("#feedback_clases").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.okSincronizar + "</strong></p>");
						$("#feedback_clases").rup_feedback("show");
					}else if (respuesta == ""){
					
					}else{
						$("#feedback_clases").rup_feedback (propertiesError);
						$("#feedback_clases").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + ": " + respuesta + "</strong></p>");
						$("#feedback_clases").rup_feedback("show");
					}
						  
				},
				error: function(data) {
					$("#dialogoSincronizar").rup_dialog("close");
			 		$("#feedback_clases").rup_feedback (propertiesError);
			 		$("#feedback_clases").rup_feedback("set", "<p><strong>" +  $.rup.i18n.app.accionesRegistros.errorSincronizar + "</strong></p>");
			 		$("#feedback_clases").rup_feedback("show");
					  
				}
			});
			
			
		},
		CANCELFunction : function(){
		}
		});
}

function ocultarBusqueda(){
	
	$("#clases_filter_div").toggle("slow",function(){
		
	});
}