jQuery(function($){
	
	/**
	 * Inicializacion
	 */

	
	$('#loaderdiv').css({left:$("#iframeagenda").position().left,position:'absolute',width:$("#iframeagenda").width(),height:$("#iframeagenda").height()});
	
	$("#agenda_filter_div").toggle();
	
	//Si el usuario es tiene acceso a todos los servicios (idServicio=0) se podrá filtrar por cualquier Servicio.
	//En el resto de casos se filtrara por el Servicio al que pertenece para que solo salgan los partes asociados a ese servico
	$.ajax({
		  type: "POST",
		  url: "../usuarios/usuarioTodosServicios",
		  success: function(data){
				  if (data){
					  $("#filtroServicio").show();
				  }else{
					  $("#filtroServicio").hide();
				  }
			  },
			 error: function(data){
				 alert( "Error al comprobar el servicio al que pertenece el usuario");
			 },
		  dataType: "json"
		});
	
	$("#fechaplanif_search").rup_date();
	
	if ($("#actualesTodos").val()==1){
		//Se cargan todos los departamentos y direcciones, actuales y de baja
		//Departamento
		$("#comboDepartamentos").rup_combo({
			source: "../partes/departamentos/combo/remote",
			sourceParam: {label:obtenerIdiomaCombo()+"depar", value:"iddepar"},
			width: 200,
			menuWidth:350,
			ordered: false,
			blank: "",
			select: function(){
				//asignar el valor seleccionado al campo del formulario que actualiza el valor
				$("#iddepar_search").val($("#comboDepartamentos").rup_combo("value"));

			},
			style : "dropdown"										
		});
		//Direccion
		$("#comboDirecciones").rup_combo({
			parent: [ "comboDepartamentos"],
			source: "../partes/direcciones/combo/remote",
			sourceParam: {label:obtenerIdiomaCombo()+"dir", value:"iddir"},
			width: 200,
			menuWidth:350,
			ordered: false,
			blank: "",
			select: function(){
				//asignar el valor seleccionado al campo del formulario que actualiza el valor
				$("#iddir_search").val($("#comboDirecciones").rup_combo("value"));
			},
			style : "dropdown"										
		});

		$("input:radio[name=rbActTodos]", "#searchForm").filter("[value=1]").prop("checked", true);
		
	}else{
		//Solo se cargan departamentos y direcciones que esten de alta actualmente
		//Departamento
		$("#comboDepartamentos").rup_combo({
			source: "../partes/departamentosAlta/combo/remote",
			sourceParam: {label:obtenerIdiomaCombo()+"depar", value:"iddepar"},
			width: 200,
			menuWidth:350,
			ordered: false,
			blank: "",
			select: function(){
				//asignar el valor seleccionado al campo del formulario que actualiza el valor
				$("#iddepar_search").val($("#comboDepartamentos").rup_combo("value"));

			},
			style : "dropdown"										
		});
		//Direccion
		$("#comboDirecciones").rup_combo({
			parent: [ "comboDepartamentos"],
			source: "../partes/direccionesAlta/combo/remote",
			sourceParam: {label:obtenerIdiomaCombo()+"dir", value:"iddir"},
			width: 200,
			menuWidth:350,
			ordered: false,
			blank: "",
			select: function(){
				//asignar el valor seleccionado al campo del formulario que actualiza el valor
				$("#iddir_search").val($("#comboDirecciones").rup_combo("value"));
			},
			style : "dropdown"										
		});
		
		$("input:radio[name=rbActTodos]", "#searchForm").filter("[value=0]").prop("checked", true);
	}
	//Edificio
	$("#comboEdificios").rup_combo({
		source: "../partes/edificiosUsuario/combo/remote",
		sourceParam: {label:obtenerIdiomaCombo()+"edificio", value:"idedificio"},
		width: 200,
		menuWidth:350,
		blank: "",
		select: function(){
			//asignar el valor seleccionado al campo del formulario que actualiza el valor
			$("#idedificio_search").val($("#comboEdificios").rup_combo("value"));
		},
		style : "dropdown"										
	});
	
	//Se Crea el combo de Con Tecnicos 
	$('#comboEstados').rup_combo({
		width: 200,
		menuWidth:350,
		source : [
				{i18nCaption: $.rup.i18n.app.comboEstados._blank, value:""},
				{i18nCaption: $.rup.i18n.app.parteTecnicos.estadogmaoasig, value:"ASIG"},
				{i18nCaption: $.rup.i18n.app.parteTecnicos.estadogmaocurs, value:"CURS"},
				{i18nCaption: $.rup.i18n.app.parteTecnicos.estadogmaopausa, value:"PAUSA"},
				{i18nCaption: $.rup.i18n.app.parteTecnicos.estadogmaoterm, value:"TERM"}
		         ],
		select: function(){
			//asignar el valor seleccionado al campo del formulario que actualiza el valor
			$("#estado_search").val($("#comboEstados").rup_combo("value"));
		},
		orderedByValue: true,
		style : "dropdown"	
	});
	
	//Combo multiselección Tecnicos para posterior búsqueda
	$("#comboTecnicos").rup_combo(
	{
		source: "../usutecnicos/comboTecnicosUsuario?idUsuario="+$("#idUsuario").val(),
		sourceParam : {
			label : "nombre",
			value : "idtecnico"
		},
		width : 300,
		showValue: false,
		submitAsString : true,
		method : 'GET',
		multiselect: true,
		multiOptgroupIconText: true,
		filterMultiple:true,
		onLoadSuccess: function(){
			seleccionarTodosTecnicosCombo();
		}
	});
	
	
	
	$("#btnLimpiar").bind("click",limpiarFormBusqueda);
	$("#btnBuscar").click(function(){
		if($("#rbPreventivos").prop("checked")){
			buscar('prev');
		}else if($("#rbCorrectivos").prop("checked")){
			buscar('corr');
		}else{
			buscar('todos');
		}
		
	});
	
	
	
	
	
	if($("#fechaAgenda").val() != ""){
		$("#iframeagenda").attr("src","../agenda/maint?fechaActualStr="+$("#fechaAgenda").val());
	}else{
		$("#iframeagenda").attr("src","../agenda/maint");
	}
	
	
	
	
    $("#btnAnterior").click(function(){
    	var fechaActual = $("#iframeagenda").contents().find("#fechaActualStr");
    	var from = fechaActual.val().split("-");
    	if($.rup_utils.capitalizedLang() == "Eu"){
    		var oneWeekAgo = new Date(from[0], from[1] - 1, from[2]);
    		oneWeekAgo.setDate(oneWeekAgo.getDate() - 7);
    		fechaActual.val(oneWeekAgo.getFullYear()+"-"+(oneWeekAgo.getMonth() + 1)+"-"+oneWeekAgo.getDate());
    	}else{
    		var oneWeekAgo = new Date(from[2], from[1] - 1, from[0]);
    		oneWeekAgo.setDate(oneWeekAgo.getDate() - 7);
    		fechaActual.val(oneWeekAgo.getDate()+"-"+(oneWeekAgo.getMonth() + 1)+"-"+oneWeekAgo.getFullYear());
    	}	
    	var fechaplanif = $("#iframeagenda").contents().find("#fechaplanif");
    	fechaplanif.val(fechaActual.val());
    	
    	var tipoBusqueda = $("#iframeagenda").contents().find("#tipoBusqueda");
    	var tipo = "";
    	if($("#rbCorrectivos").prop("checked")){
    		tipo = "corr";
    	}else if($("#rbPreventivos").prop("checked")){
    		tipo = "prev";
    	}
    	
    	rellenarCriteriosFormulario(tipo);
    	
    	$('#loaderdiv').show();
    	var filtroForm = $("#iframeagenda").contents().find("#filtroAgendaForm");
    	filtroForm.attr("method","GET");
    	filtroForm.attr("target","iframeagenda");
    	filtroForm.submit();
    	
    });
    
    
    $("#btnSiguiente").click(function(){
    	var fechaActual = $("#iframeagenda").contents().find("#fechaActualStr");
    	var from = fechaActual.val().split("-");
    	if($.rup_utils.capitalizedLang() == "Eu"){
    		var oneWeekAgo = new Date(from[0], from[1] - 1, from[2]);
        	oneWeekAgo.setDate(oneWeekAgo.getDate() +7);
    		fechaActual.val(oneWeekAgo.getFullYear()+"-"+(oneWeekAgo.getMonth() + 1)+"-"+oneWeekAgo.getDate());
    	}else{
    		var oneWeekAgo = new Date(from[2], from[1] - 1, from[0]);
        	oneWeekAgo.setDate(oneWeekAgo.getDate() +7);
    		fechaActual.val(oneWeekAgo.getDate()+"-"+(oneWeekAgo.getMonth() + 1)+"-"+oneWeekAgo.getFullYear());
    	}	
    	var fechaplanif = $("#iframeagenda").contents().find("#fechaplanif");
    	fechaplanif.val(fechaActual.val());
    	
    	var tipoBusqueda = $("#iframeagenda").contents().find("#tipoBusqueda");
    	var tipo = "";
    	if($("#rbCorrectivos").prop("checked")){
    		tipo = "corr";
    	}else if($("#rbPreventivos").prop("checked")){
    		tipo = "prev";
    	}
    	
    	rellenarCriteriosFormulario(tipo);
    	
    	$('#loaderdiv').show();
    	var filtroForm = $("#iframeagenda").contents().find("#filtroAgendaForm");
    	filtroForm.attr("method","GET");
    	filtroForm.attr("target","iframeagenda");
    	filtroForm.submit();
    });
    


    window.setInterval(function(){
      /// call your function here
    	$("#btnRecargar").click();
    }, 900000);


    
    $("#btnRecargar").click(function(){
    	//var fechaActual = $("#iframeagenda").contents().find("#fechaActualStr");
    	
    	//$('#loaderdiv').show();
    	$("#btnBuscar").click();
    	//var filtroForm = $("#iframeagenda").contents().find("#filtroAgendaForm");
    	//filtroForm.attr("method","GET");
    	//filtroForm.attr("target","iframeagenda");
    	//filtroForm.submit();
    });
    
    $("#btnHoy").click(function(){
    	var fechaActualDate = new Date();
    	var fechaActual = "";
    	if($.rup_utils.capitalizedLang() == "Eu"){
    		fechaActual = fechaActualDate.getFullYear();+"-"+(fechaActualDate.getMonth() + 1)+"-"+fechaActualDate.getDate();
    	}else{
    		fechaActual = fechaActualDate.getDate()+"-"+(fechaActualDate.getMonth() + 1)+"-"+fechaActualDate.getFullYear();
    	}
    		
    	var fechaplanif = $("#iframeagenda").contents().find("#fechaplanif");
    	fechaplanif.val(fechaActual);
    	//$("#fechaplanif_search").rup_date("setRupValue",fechaActual);
    	$('#loaderdiv').show();
    	var filtroForm = $("#iframeagenda").contents().find("#filtroAgendaForm");
    	filtroForm.attr("method","GET");
    	filtroForm.attr("target","iframeagenda");
    	filtroForm.submit();
    });
    
    
    
    
    $('#iframeagenda').on('load', function () {
        $('#loaderdiv').hide();
    });
    	
    
    
    $("#leyendaAgenda").qtip({
		content: {
			text: $("#toolleyendaagenda")
		},
		position: {
	        my: 'right top',  // Position my top left...
	        at: 'top left', // at the bottom right of...
	        target: $("#leyendaAgenda"), // my target
	        adjust: {
	        	//x: 10,
	        	//y: -12,
	        	resize:false,
	        	scroll:false
	        }
	    },
	    style: { 
	    	widget:true,
	    	def:false,
	    	width:true
	    	
	    }
	});
    
    
    
    
    /**
     * Fin inicializacion
     */
	
});


/*************************************************************/
/***********************SERVICIOS*****************************/
/*************************************************************/

$("#imgBuscarServicios").rup_tooltip({
	content: {
	text: $.rup.i18n.app.nuevo.ventanaSeleccion
	}
});

function btn_BuscarServicios(){
	var urlServicios="../servicios/obtenerServicios";
	
	$("#idTablaServicios").empty();
	var textoBaja="";
	//Obtener la lista de Servicios
	$.ajax({
		type: "POST",
		url: urlServicios,
		success: function(data){
			var miselect=$("#idTablaServicios");
			$("#idTablaServicios").empty();
            for (var i=0; i<data.length; i++) {
            	var descripcion = "";
            	if (data[i].baja=="1"){
            		textoBaja="(" + $.rup.i18n.app.GRID_cabeceras.baja  + ") ";
            	}else{
            		textoBaja= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            	}
              	if ($.rup_utils.capitalizedLang() =="Es") {	
              		descripcion =  textoBaja + data[i].cservicio;
              	} else {
              		descripcion = textoBaja + data[i].eservicio;
              	}
              	miselect.append('<option value="' + data[i].idservicio + '">' + descripcion + '</option>');
             	}								  
			},
		  dataType: "json"
		});

	
	//Mostrar la ventana de lupa Servicios
	$("#lupaServicios").rup_dialog({      
		type: jQuery.rup.dialog.DIV,
		modal:true,
        height:300,
        width:450,  
        resizable:false,
        title:$.rup.i18n.app.comun.serviciosVigentes,
        autoOpen:true,
        showLoading:true,
        async:false, 
        zIndex: -1,
        buttons:[{
	        	id: "aceptarlupaServicios",
	        	text: $.rup.i18n.base.rup_global.aceptar,
	        	click: function() {
		        		//Pintar el texto de servicio 
		        		$("#idServicio").val($("#idTablaServicios option:selected").val());
		        		var texto = $("#idTablaServicios option:selected").html();
		        		texto = texto.replace(/&nbsp;/g, "");
		        		$("#textoServicio").val(texto);
		        		$("#lupaServicios").rup_dialog("close");
	        		}
        	},
	        {
	    		id: "cerrarlupaServicios",
	    		text: $.rup.i18n.base.rup_global.cancelar,
	        	click: function() {
	        		$("#lupaServicios").rup_dialog("close");
	        	},
	        	btnType:$.rup.dialog.LINK
        	}]
      });
   

}

/**************************************************************/

function buscar(tipo){
	var filtroForm = $("#iframeagenda").contents().find("#filtroAgendaForm");
	var fechaplanif = $("#iframeagenda").contents().find("#fechaplanif");
	fechaplanif.val($("#fechaplanif_search").val());
	rellenarCriteriosFormulario(tipo);

	if($("#agenda_filter_div").css("display") == "block"){
		ocultarBusqueda();
	}	
	$('#loaderdiv').show();
	filtroForm.attr("method","GET");
	filtroForm.attr("target","iframeagenda");
	filtroForm.submit();
}

function rellenarCriteriosFormulario(tipo){
	
	//Comunes
	var tecnicos = $("#iframeagenda").contents().find("#tecnicos");
	tecnicos.val($("#comboTecnicos").rup_combo("value"));
	$("#tecnicos_search").val($("#comboTecnicos").rup_combo("value"));
	var idedificio = $("#iframeagenda").contents().find("#idedificio");
	idedificio.val($("#idedificio_search").val());
	var zona = $("#iframeagenda").contents().find("#zona");
	zona.val($("#idzona_search").val());
	var planta = $("#iframeagenda").contents().find("#planta");
	planta.val($("#idplanta_search").val());
	var ejecutado = $("#iframeagenda").contents().find("#ejecutado");
	ejecutado.val($("#ejecutado_search").val());
	var parado = $("#iframeagenda").contents().find("#parado");
	parado.val($("#parado_search").val());
	var estado = $("#iframeagenda").contents().find("#estado");
	
	
	
	var tipoEnvio = $("#iframeagenda").contents().find("#tipoEnvio");
	if($("#rbMovil").prop("checked")){
		estado.val($("#estado_search").val());
		tipoEnvio.val($("#rbMovil").val());
	}else if($("#rbSinMovil").prop("checked")){
		estado.val('');
		tipoEnvio.val($("#rbSinMovil").val());
	}else if($("#rbTodosEnv").prop("checked")){
		estado.val('');
		tipoEnvio.val($("#rbTodosEnv").val());
	}	
	if(tipo == "prev"){
		var mcodigo = $("#iframeagenda").contents().find("#mcodigo");
		mcodigo.val($("#mcodigo_search").val());
		var maquina = $("#iframeagenda").contents().find("#maquina");
		maquina.val($("#maquina_search").val());
		var gama = $("#iframeagenda").contents().find("#gama");
		gama.val($("#gama_search").val());
		var pendEjec = $("#iframeagenda").contents().find("#pendEjec");
		pendEjec.val($("#pendEjec_search").val());
		var tipoBusqueda = $("#iframeagenda").contents().find("#tipoBusqueda");
		tipoBusqueda.val("P");
		
	}else if(tipo == "corr"){
		var nombre = $("#iframeagenda").contents().find("#nombre");
		nombre.val($("#nombre_search").val());
		var iddepar = $("#iframeagenda").contents().find("#iddepar");
		iddepar.val($("#iddepar_search").val());
		var iddir = $("#iframeagenda").contents().find("#iddir");
		iddir.val($("#iddir_search").val());
		var clase = $("#iframeagenda").contents().find("#clase");
		clase.val($("#idclase_search").val());
		var codigo = $("#iframeagenda").contents().find("#codigo");
		codigo.val($("#idcodigo_search").val());
		var strServicio = $("#iframeagenda").contents().find("#strServicio");
		strServicio.val($("#textoServicio").val());
		var urgente = $("#iframeagenda").contents().find("#urgente");
		urgente.val($("#urgente_search").val());
		var vip = $("#iframeagenda").contents().find("#vip");
		vip.val($("#vip_search").val());
		var noProcede = $("#iframeagenda").contents().find("#noProcede");
		noProcede.val($("#noProcede_search").val());
		
		var tipoBusqueda = $("#iframeagenda").contents().find("#tipoBusqueda");
		tipoBusqueda.val("C");
	}else{
		var tipoBusqueda = $("#iframeagenda").contents().find("#tipoBusqueda");
		tipoBusqueda.val("T");
	}
	
}


function limpiarFormBusqueda() {
	$("#ejecutado_search").prop('checked', false);
	$("#parado_search").prop('checked', false);
	$("#averiaRepe_search").prop('checked', false);
	$("#urgente_search").prop('checked', false);
	$("#vip_search").prop('checked', false);
	$("#noProcede_search").prop('checked', false);
	$('#comboDepartamentos').rup_combo("setRupValue","");
	$('#comboDirecciones').rup_combo("setRupValue","");
	$('#comboEstados').rup_combo("setRupValue","");
	
	cargarCombosDptoDir(0);

	$("#rbActTodos1").attr('checked', true);
	$("#rbActTodos1").val(0);
	$("#rbActTodos2").val(1);
	
	
	
	$(':input','#searchForm')
	  .not(':button, :submit, :reset, :checkbox')
	  .val('');
	
	var filtroForm = $("#iframeagenda").contents().find("#filtroAgendaForm");
	
	$(':input',filtroForm)
	  .not(':button, :submit, :reset')
	  .val('');
	
	$("#rbCorrectivos").val(0);
	$("#rbPreventivos").val(1);
	$("#rbTodos").val(2);
	$("#rbTodos").prop("checked", true);
	$("#rbCorrectivos").prop("checked", false);
	$("#rbPreventivos").prop("checked", false);
	$("#filtroCorrectivas").hide();
	$("#filtroPreventivas").hide();
	
	$("#rbMovil").val(1);
	$("#rbSinMovil").val(0);
	$("#rbTodosEnv").val(2);
	$("#rbTodosEnv").prop("checked", true);
	$("#rbMovil").prop("checked", false);
	$("#rbMovil").prop("checked", false);
	$("#optEstadosMovil").hide();
	
	
	seleccionarTodosTecnicosCombo();
}

function seleccionarTodosTecnicosCombo(){
	var numTecCombo = $("#comboTecnicos").children().size();
	var arrayCombo = [];
	for(var i=0;i<=numTecCombo;i++){
		arrayCombo.push(i);
	}
	$("#comboTecnicos").rup_combo("select",arrayCombo);
}



function ocultarBusqueda(){
		$("#agenda_filter_div").toggle("slow",function(){
			
		});

	
}

function obtenerIdiomaCombo(){
	var idioma="c";		
	if ($.rup_utils.capitalizedLang() =="Es") {	
		idioma = "c";
	} else idioma="e";
	return idioma;
}

function cargarCombosDptoDir(valor){
	if (valor==1){
		$("#comboDepartamentos").rup_combo().data("settings").source="../partes/departamentos/combo/remote";
		$("#comboDirecciones").rup_combo().data("settings").source="../partes/direcciones/combo/remote";
		$("#actualesTodos").val(1);
	}else{
		$("#comboDepartamentos").rup_combo().data("settings").source="../partes/departamentosAlta/combo/remote";
		$("#comboDirecciones").rup_combo().data("settings").source="../partes/direccionesAlta/combo/remote";
		$("#actualesTodos").val(0);
	}
	$('#comboDepartamentos').rup_combo("reload");
	//vaciar el campo del formulario que actualiza el valor
	$("#iddepar_search").val("");
	$("#iddir_search").val("");
	
}


function btn_BuscarCodigos(){
	$("#idTablaClases").empty();
	var textoBaja="";
	//Obtener la lista de Clases
	$.ajax({
		type: "POST",
		url: "../clase/clases/obtenerClasesServicio",
		success: function(data){
			var miselect=$("#idTablaClases");
			$("#idTablaClases").empty();
            for (var i=0; i<data.length; i++) {
            	var descripcion = "";
            	if (data[i].baja=="1"){
            		textoBaja="(" + $.rup.i18n.app.GRID_cabeceras.baja  + ") ";
            	}else{
            		textoBaja= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            	}
              	if ($.rup_utils.capitalizedLang() =="Es") {	
              		descripcion =  textoBaja + data[i].cclase;
              	} else {
              		descripcion = textoBaja + data[i].eclase;
              	}
              	miselect.append('<option value="' + data[i].idclase + '">' + descripcion + '</option>');
             	}								  
			},
		  dataType: "json"
		});

	textoBaja="";
	//Obtener la lista de activos
	$.ajax({
		type: "POST",
		url: "../codigo/codigos/obtenerCodigosServicio",
		success: function(data){
			var miselect=$("#idTablaCodigos");
			$("#idTablaCodigos").empty();
            for (var i=0; i<data.length; i++) {
            	var descripcion = "";
            	if (data[i].baja=="1"){
            		textoBaja="(" + $.rup.i18n.app.GRID_cabeceras.baja  + ") ";
            	}else{
            		textoBaja= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            	}
              	if ($.rup_utils.capitalizedLang() =="Es") {	
              		descripcion = textoBaja + data[i].ccodigo;
              	} else {
              		descripcion = textoBaja + data[i].ecodigo;
              	}
              	miselect.append('<option value="' + data[i].idclase + '@' + data[i].idcodigo + '">' + descripcion + '</option>');
             	}								  
			},
		  dataType: "json"
		});

	
	//Mostrar la ventana de lupa
	$("#lupa").rup_dialog({      
		type: jQuery.rup.dialog.DIV,
		modal:true,
        height:300,
        width:649,  
        resizable:false,
        title:"",
        autoOpen:true,
        showLoading:true,
        async:false, 
        zIndex: -1,
        buttons:[{
	        	id: "aceptarLupa",
	        	text: $.rup.i18n.base.rup_global.aceptar,
	        	click: function() {
	        		//$("#comboClasesActivo_label").rup_autocomplete("search", sClase);
	        		//$("#comboActivos_label").rup_autocomplete("search", sCodigo);
	        		sClase = sClase.replace(/&nbsp;/g, "");
	        		$("#idclase_search").val(sClase);
	        		sCodigo = sCodigo.replace(/&nbsp;/g, "");
	        		$("#idcodigo_search").val(sCodigo);
	        		$("#lupa").rup_dialog("close");
	        		}
        	},
	        {
	    		id: "cerrarLupa",
	    		text: $.rup.i18n.base.rup_global.cancelar,
	        	click: function() {
	        		$("#lupa").rup_dialog("close");
	        	},
	        	btnType:$.rup.dialog.LINK
        	}]
      });
   
}
function obtenerCodigosClase(valor){
	textoBaja="";
	//Obtener la lista de activos
	$.ajax({
		type: "POST",
		url: "../codigo/codigos/obtenerCodigosClaseServicio",
		  data:  { claseSel:valor },
		success: function(data){
			var miselect=$("#idTablaCodigos");
			$("#idTablaCodigos").empty();
            for (var i=0; i<data.length; i++) {
            	var descripcion = "";
            	if (data[i].baja=="1"){
            		textoBaja="(" + $.rup.i18n.app.GRID_cabeceras.baja  + ") ";
            	}else{
            		textoBaja= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            	}
              	if ($.rup_utils.capitalizedLang() =="Es") {	
              		descripcion = textoBaja + data[i].ccodigo;
              	} else {
              		descripcion = textoBaja + data[i].ecodigo;
              	}
              	miselect.append('<option value="' + data[i].idclase + '@' + data[i].idcodigo + '">' + descripcion + '</option>');
             	}								  
			},
		  dataType: "json"
		});

	sClase=$("#idTablaClases option:selected").html();;
}
function obtenerClaseCodigo(valor){
	var claseCodigo= valor; //Original Text

	var partes= claseCodigo.split('@');
	var clase = partes[0];
	var codigo= partes[1];
	
	sCodigo=$("#idTablaCodigos option:selected").html();;
	//Marcar clase asociada al activo	
	$("#idTablaClases option[value="+ clase +"]").attr("selected",true);
	sClase=$("#idTablaClases option:selected").html();
}

/*function activarCheck(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
	
}*/

function mostrarFiltro(valor){
	
	if(valor == 0){
		//Correctivos
		//limpiarFormBusqueda();
		$("#rbCorrectivos").prop("checked", true);
		$("#rbPreventivos").prop("checked", false);
		$("#rbTodos").prop("checked", false);
		$("#filtroPreventivas").hide();
		$("#filtroCorrectivas").show();
	}else if(valor == 1){
		//limpiarFormBusqueda();
		//Preventivos
		$("#rbCorrectivos").prop("checked", false);
		$("#rbPreventivos").prop("checked", true);
		$("#rbTodos").prop("checked", false);
		$("#filtroCorrectivas").hide();
		$("#filtroPreventivas").show();
	}else if(valor == 2){
		//limpiarFormBusqueda();
		//Todos
		$("#rbCorrectivos").prop("checked", false);
		$("#rbPreventivos").prop("checked", false);
		$("#rbTodos").prop("checked", true);
		$("#filtroCorrectivas").hide();
		$("#filtroPreventivas").hide();
	}
	
}

function mostrarFiltroEnv(valor){
		if(valor == 1){
			$("#optEstadosMovil").show();
			$("#optEstadosMovil").css("display","flex");
			$("#rbMovil").prop("checked", true);
			$("#rbSinMovil").prop("checked", false);
			$("#rbTodosEnv").prop("checked", false);
		}else if(valor == 0){
			$("#rbMovil").prop("checked", false);
			$("#rbSinMovil").prop("checked", true);
			$("#rbTodosEnv").prop("checked", false);
			$("#optEstadosMovil").hide();
		}else if(valor == 2){
			$("#rbMovil").prop("checked", false);
			$("#rbSinMovil").prop("checked", false);
			$("#rbTodosEnv").prop("checked", true);
			$("#optEstadosMovil").hide();
		}
	
}

function comprobarCheckEjecutado(valor){

	if($('#ejecutado_search').is(":checked")) {
		$('#ejecutado_search').prop("checked", true);
		$('#ejecutado_search').val("1");
    }else{
    	$('#ejecutado_search').prop("checked", false);
    	$('#ejecutado_search').val("0");
    }
}

function comprobarCheckParado(valor){

    if($('#parado_search').is(":checked")) {
    	$('#parado_search').prop("checked", true);
    	$('#parado_search').val("1");
    }else{
    	$('#parado_search').prop("checked", false);
    	$('#parado_search').val("0");
    }
}

function comprobarCheckUrgente(valor){
    if($('#urgente_search').is(":checked")) {
    	$('#urgente_search').prop("checked", true);
    	$('#urgente_search').val("1");
    }else{
    	$('#urgente_search').prop("checked", false);
    	$('#urgente_search').val("0");
    }
}

function comprobarCheckVip(valor){
    if($('#vip_search').is(":checked")) {
    	$('#vip_search').prop("checked", true);
    	$('#vip_search').val("1");
    }else{
    	$('#vip_search').prop("checked", false);
    	$('#vip_search').val("0");
    }
}

function comprobarCheckNoprocede(valor){
    if($('#noProcede_search').is(":checked")) {
    	$('#noProcede_search').prop("checked", true);
    	$('#noProcede_search').val("1");
    }else{
    	$('#noProcede_search').prop("checked", false);
    	$('#noProcede_search').val("0");
    }
}

function comprobarCheckPendejec(valor){
    if($('#pendEjec_search').is(":checked")) {
    	$('#pendEjec_search').prop("checked", true);
    	$('#pendEjec_search').val("1");
    }else{
    	$('#pendEjec_search').prop("checked", false);
    	$('#pendEjec_search').val("0");
    }
}