jQuery(function($){
	
	$("#aa20bMaqPartesWar_menu").hide();
	$("#contentMV").css("margin-left", "0px");
	$("#aa20bMaqPartesWar_migas").hide();
	$("#tituloAplicacion").html($.rup.i18n.app.nuevo.titulo);
	
	$("#consultarPartesUsuNormal_filter_div").toggle();
	
	var sClase="";
	var sCodigo="";
	$("#GRID_consultarPartesUsuNormal").rup_grid({
		
		//hasMaint: true,
		loadOnStartUp:false,
		width: 1012,
		url: "../partes/gridPartesUsuarioNormal",
		pagerName: "pager",
		rowNum: "30",
		sortorder: "desc",
		sortname: "idparte",
		ondblClickRow : fncDetalleParte,
		colNames: [
			$.rup.i18n.app.nuevo.idparte,
			$.rup.i18n.app.nuevo.fechare,
			$.rup.i18n.app.nuevo.zona,
			$.rup.i18n.app.nuevo.planta,
			$.rup.i18n.app.nuevo.clase,
			$.rup.i18n.app.nuevo.codigo,
			$.rup.i18n.app.nuevo.observ,
			$.rup.i18n.app.nuevo.repetida
		],
		colModel: [
			{ name: "idparte",
				label: "idparte",
				index: "idparte",
				width: "30",
				editable: false,
				edittype: "text"
			},
			{ name: "fechare",
				label: "fechare",
				index: "fechare",
				width: "100",
				editable: false,
				edittype: "text"
			},
			{ name: "zona." + obtenerIdioma() + "zona",
				label: "zona." + obtenerIdioma() + "zona",
				index: "idzona",
				width: "75",
				editable: true,
				edittype: "text"
			},
			{ name: "planta." + obtenerIdioma() + "planta",
				label: "planta." + obtenerIdioma() + "planta",
				index: "idplanta",
				width: "60",
				editable: true,
				edittype: "text"
			},
			{ name: "clase." + obtenerIdioma() + "clase",
				label: "clase." + obtenerIdioma() + "clase",
				index: "idclase",
				width: "75",
				editable: false,
				edittype: "text"
			},
			{ name: "codigo." + obtenerIdioma() + "codigo",
				label: "codigo." + obtenerIdioma() + "codigo",
				index: "idcodigo",
				width: "140",
				editable: false,
				edittype: "text"
			},
			{ name: "observ",
				label: "observ",
				index: "observ",
				width: "130",
				editable: false,
				edittype: "text"
			},
			{ name: "averiaRepe",
				label: "averiaRepe",
				index: "averiaRepe",
				width: "35",
				editable: false,
				edittype: "text",
			    formatter :
                	masiveIconFormatter = function(cellval, el, opts) 
                	{
			    		var html = '';
			    		var src = $.rup.RUP+"/basic-theme/images/rup.ok.png";
                		if (cellval && cellval != 0){
                        	html = '<img width="20" height="20" src='+src+' id="idDescAR-'+cellval+'"  title="'+$.rup.i18n.app.nuevo.averiaRepe+'">';
                        }
                        return html;
                	}
			}
        ]
		
	});
	
	$("#consultarPartesUsuNormal").rup_maint({
		jQueryGrid: "GRID_consultarPartesUsuNormal",
		primaryKey: "idparte",
		modelObject: "Partes",
		detailButtons: $.rup.maint.detailButtons.SAVE,
		onafterDetailShow: function(){
			$("#consultarPartesUsuNormal").rup_maint("search");
		},
		searchForm: "searchForm",
		showMessages: true,
		toolbar:{
			createDefaultToolButtons:false,
			newButtons: [{
					obj: {
						i18nCaption: $.rup.i18n.app.aa20bMaqPartesWar_migas.nuevoParte,
						css: "rup-maint_new"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncNuevoParte
					},
					{
					obj: {
						i18nCaption: $.rup.i18n.app.botones.ver,
						css: "rup-maint_edit"
						},
						json_i18n: $.rup.i18n.app.simpelMaint,
						click: fncDetalleParte
					}
					]
			}
	});

	
	
	function fncNuevoParte() {
		window.location = "/aa20bMaqPartesWar/partes/nuevo";
	}
	
	function fncDetalleParte() {
		if($("#GRID_consultarPartesUsuNormal").rup_grid("getSelectedRows") != ""){
			$("#miPagina").val($("#GRID_consultarPartesUsuNormal").rup_grid("getGridParam").page);
			
			var id= $("#GRID_consultarPartesUsuNormal").rup_grid('getGridParam','selrow');
			 //alert(id);
			 var ret = $("#GRID_consultarPartesUsuNormal").rup_grid('getRowData',id); 
			 var idparte =ret.idparte;
			 
			    // enviamos el form alternativo con el idparte
				buscaParteForm.idparte.value = idparte;
				buscaParteForm.submit();
		}else{
			$.rup_messages("msgAlert", { 
	 			title: $.rup.i18n.app.comun.control,
		 		message: $.rup.i18n.app.mensajesPartes.avisoNoSeleccion
		 	});
		}
		return false;
	}
	
	//Busqueda por fecha de recepcion.
	$.rup_date({
		from: "fechareD_search",
		to: "fechareH_search",
		independientes: true,
		independientes: true
		});
	

	// Limpiar no deschequea automaticamente los chekbox.  
	$("#clean_search_consultarPartesUsuNormal").unbind("click");
	$("#clean_search_consultarPartesUsuNormal").bind("click",limpiarFormBusqueda);

	$("#consultarPartesUsuNormal").rup_maint("search");
});



/**************************************************************/


function buscar(){
	$("#consultarPartesUsuNormal").rup_maint("search");
}
function limpiarFormBusqueda() {
	$("#ejecutado_search").prop('checked', false);
	$("#urgente_search").prop('checked', false);
	

	$("#consultarPartesUsuNormal").rup_maint("cleanSearchForm");
	$("#consultarPartesUsuNormal").rup_maint("search");
}


function activarCheck(e){
	$("input[type=checkbox]").each (function() {						
		$(this).val(this.checked ? "1" : "0");
	});
}
function obtenerIdioma(){
    var idioma="";       
    if ($.rup_utils.capitalizedLang() =="Es") {    
          idioma = "c";
    } else idioma="e";
    return idioma;
}


function btn_BuscarCodigos(){
	$("#idTablaClases").empty();
	var textoBaja="";
	//Obtener la lista de Clases
	$.ajax({
		type: "POST",
		url: "../clase/clases/obtenerClasesServicio",
		success: function(data){
			var miselect=$("#idTablaClases");
			$("#idTablaClases").empty();
            for (var i=0; i<data.length; i++) {
            	var descripcion = "";
            	if (data[i].baja=="1"){
            		textoBaja="(" + $.rup.i18n.app.GRID_cabeceras.baja  + ") ";
            	}else{
            		textoBaja= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            	}
              	if ($.rup_utils.capitalizedLang() =="Es") {	
              		descripcion =  textoBaja + data[i].cclase;
              	} else {
              		descripcion = textoBaja + data[i].eclase;
              	}
              	miselect.append('<option value="' + data[i].idclase + '">' + descripcion + '</option>');
             	}								  
			},
		  dataType: "json"
		});

	textoBaja="";
	//Obtener la lista de activos
	$.ajax({
		type: "POST",
		url: "../codigo/codigos/obtenerCodigosServicio",
		success: function(data){
			var miselect=$("#idTablaCodigos");
			$("#idTablaCodigos").empty();
            for (var i=0; i<data.length; i++) {
            	var descripcion = "";
            	if (data[i].baja=="1"){
            		textoBaja="(" + $.rup.i18n.app.GRID_cabeceras.baja  + ") ";
            	}else{
            		textoBaja= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            	}
              	if ($.rup_utils.capitalizedLang() =="Es") {	
              		descripcion = textoBaja + data[i].ccodigo;
              	} else {
              		descripcion = textoBaja + data[i].ecodigo;
              	}
              	miselect.append('<option value="' + data[i].idclase + '@' + data[i].idcodigo + '">' + descripcion + '</option>');
             	}								  
			},
		  dataType: "json"
		});

	
	//Mostrar la ventana de lupa
	$("#lupa").rup_dialog({      
		type: jQuery.rup.dialog.DIV,
		modal:true,
        height:300,
        width:649,  
        resizable:false,
        title:"",
        autoOpen:true,
        showLoading:true,
        async:false, 
        zIndex: -1,
        buttons:[{
	        	id: "aceptarLupa",
	        	text: $.rup.i18n.base.rup_global.aceptar,
	        	click: function() {
	        		//$("#comboClasesActivo_label").rup_autocomplete("search", sClase);
	        		//$("#comboActivos_label").rup_autocomplete("search", sCodigo);
	        		sClase = sClase.replace(/&nbsp;/g, "");
	        		$("#idclase_search").val(sClase);
	        		sCodigo = sCodigo.replace(/&nbsp;/g, "");
	        		$("#idcodigo_search").val(sCodigo);
	        		$("#lupa").rup_dialog("close");
	        		}
        	},
	        {
	    		id: "cerrarLupa",
	    		text: $.rup.i18n.base.rup_global.cancelar,
	        	click: function() {
	        		$("#lupa").rup_dialog("close");
	        	},
	        	btnType:$.rup.dialog.LINK
        	}]
      });
   
}
function obtenerCodigosClase(valor){
	textoBaja="";
	//Obtener la lista de activos
	$.ajax({
		type: "POST",
		url: "../codigo/codigos/obtenerCodigosClaseServicio",
		  data:  { claseSel:valor },
		success: function(data){
			var miselect=$("#idTablaCodigos");
			$("#idTablaCodigos").empty();
            for (var i=0; i<data.length; i++) {
            	var descripcion = "";
            	if (data[i].baja=="1"){
            		textoBaja="(" + $.rup.i18n.app.GRID_cabeceras.baja  + ") ";
            	}else{
            		textoBaja= "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;";
            	}
              	if ($.rup_utils.capitalizedLang() =="Es") {	
              		descripcion = textoBaja + data[i].ccodigo;
              	} else {
              		descripcion = textoBaja + data[i].ecodigo;
              	}
              	miselect.append('<option value="' + data[i].idclase + '@' + data[i].idcodigo + '">' + descripcion + '</option>');
             	}								  
			},
		  dataType: "json"
		});

	sClase=$("#idTablaClases option:selected").html();;
}
function obtenerClaseCodigo(valor){
	var claseCodigo= valor; //Original Text

	var partes= claseCodigo.split('@');
	var clase = partes[0];
	var codigo= partes[1];
	
	sCodigo=$("#idTablaCodigos option:selected").html();;
	//Marcar clase asociada al activo	
	$("#idTablaClases option[value="+ clase +"]").attr("selected",true);
	sClase=$("#idTablaClases option:selected").html();
}


function ocultarBusqueda(){
	
	$("#consultarPartesUsuNormal_filter_div").toggle("slow",function(){
		
	});
}

/******************************* AYUDA ***************************************/
function openHelp(){
	abrirAyudaInicio();
}
/******************************* AYUDA ***************************************/