<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format">
	<!-- ESTILOS REPORT -->
	<xsl:attribute-set name="ReportHeader">
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="padding-bottom">10pt</xsl:attribute>
		<xsl:attribute name="padding-top">7pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-family">sans-serif</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="HorizontalReport">
		<xsl:attribute name="page-width">297mm</xsl:attribute>
		<xsl:attribute name="page-height">210mm</xsl:attribute>
		<xsl:attribute name="margin-top">10mm</xsl:attribute>
		<xsl:attribute name="margin-bottom">0mm</xsl:attribute>
		<xsl:attribute name="margin-left">10mm</xsl:attribute>
		<xsl:attribute name="margin-right">10mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="VerticalReport">
		<xsl:attribute name="page-width">210mm</xsl:attribute>
		<xsl:attribute name="page-height">297mm</xsl:attribute>
		<xsl:attribute name="margin-top">10mm</xsl:attribute>
		<xsl:attribute name="margin-bottom">0mm</xsl:attribute>
		<xsl:attribute name="margin-left">15mm</xsl:attribute>
		<xsl:attribute name="margin-right">10mm</xsl:attribute>
	</xsl:attribute-set>
	<!-- ESTILOS TITULOS -->
	<xsl:attribute-set name="TitleStyle">
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-size">16.0pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="text-decoration">underline</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="SubtitleStyle">
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="SubtitleStyleSmall">
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-size">6.0pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="PageStyle">
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	</xsl:attribute-set>
	<!-- ESTILOS CRITERIOS -->
	<xsl:attribute-set name="ParameterCell">
		<xsl:attribute name="line-height">3mm</xsl:attribute>
		<xsl:attribute name="space-after">0.5pt</xsl:attribute>
		<xsl:attribute name="space-before">0.0pt</xsl:attribute>
		<xsl:attribute name="text-align">start</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<!-- ESTILOS CABECERAS -->
	<!-- Celdas -->
	<xsl:attribute-set name="CabeceraGris">
		<xsl:attribute name="line-height">3mm</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
		<xsl:attribute name="background-color">#B4B4B4</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="padding-top">1mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="HeaderCell">
		<xsl:attribute name="line-height">5mm</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
		<xsl:attribute name="background-color">#B0C8E6</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="HeaderCellMedium">
		<xsl:attribute name="line-height">4mm</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
		<xsl:attribute name="background-color">#B0C8E6</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="HeaderCellSmall">
		<xsl:attribute name="line-height">2mm</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
		<xsl:attribute name="background-color">#B0C8E6</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="HeaderCellXSmall">
		<xsl:attribute name="line-height">2mm</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
		<xsl:attribute name="background-color">#B0C8E6</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="LeftHeaderCell">
		<xsl:attribute name="line-height">5mm</xsl:attribute>
		<xsl:attribute name="space-after">3.0pt</xsl:attribute>
		<xsl:attribute name="space-before">3.0pt</xsl:attribute>
		<xsl:attribute name="text-align">left</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
		<xsl:attribute name="background-color">#4a79a5</xsl:attribute>
	</xsl:attribute-set>
	<!-- Tipo de letra -->
	<xsl:attribute-set name="HeaderCellLetterItalic">
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
		<xsl:attribute name="font-style">italic</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="HeaderCellLetter">
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="HeaderCellLetterSmall">
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-size">6.0pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="HeaderCellLetterLarge">
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-size">12.0pt</xsl:attribute>
		<xsl:attribute name="font-weight">bold</xsl:attribute>
	</xsl:attribute-set>
	<!-- ESTILOS CELDAS -->
	<!-- Tipo de letra -->
	<xsl:attribute-set name="CellLetter">
		<xsl:attribute name="font-family">arial</xsl:attribute>
		<xsl:attribute name="font-size">10.0pt</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="CellLetterSmall">
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-size">6.0pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="CellLetterMedium">
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-size">8.0pt</xsl:attribute>
	</xsl:attribute-set>
	<!-- Tipo de celda -->
	<!-- Altura normal -->
	<xsl:attribute-set name="CenterCell">
		<xsl:attribute name="line-height">4mm</xsl:attribute>
		<xsl:attribute name="space-after">3.0pt</xsl:attribute>
		<xsl:attribute name="space-before">3.0pt</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="RightCell">
		<xsl:attribute name="line-height">5mm</xsl:attribute>
		<xsl:attribute name="space-after">3.0pt</xsl:attribute>
		<xsl:attribute name="space-before">3.0pt</xsl:attribute>
		<xsl:attribute name="text-align">end</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="LeftCell">
		<xsl:attribute name="line-height">5mm</xsl:attribute>
		<xsl:attribute name="space-after">3.0pt</xsl:attribute>
		<xsl:attribute name="space-before">3.0pt</xsl:attribute>
		<xsl:attribute name="text-align">start</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<!-- Altura media -->
	<xsl:attribute-set name="CenterCellMedium">
		<xsl:attribute name="line-height">4mm</xsl:attribute>
		<xsl:attribute name="space-after">1.5pt</xsl:attribute>
		<xsl:attribute name="space-before">1.5pt</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="RightCellMedium">
		<xsl:attribute name="line-height">4mm</xsl:attribute>
		<xsl:attribute name="space-after">1.5pt</xsl:attribute>
		<xsl:attribute name="space-before">1.5pt</xsl:attribute>
		<xsl:attribute name="text-align">end</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="LeftCellMedium">
		<xsl:attribute name="line-height">4mm</xsl:attribute>
		<xsl:attribute name="space-after">1.5pt</xsl:attribute>
		<xsl:attribute name="space-before">1.5pt</xsl:attribute>
		<xsl:attribute name="text-align">start</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<!-- Altura pequeña -->
	<xsl:attribute-set name="CenterCellSmall">
		<xsl:attribute name="line-height">2mm</xsl:attribute>
		<xsl:attribute name="space-after">3.0pt</xsl:attribute>
		<xsl:attribute name="space-before">3.0pt</xsl:attribute>
		<xsl:attribute name="text-align">center</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="RightCellSmall">
		<xsl:attribute name="line-height">2mm</xsl:attribute>
		<xsl:attribute name="space-after">3.0pt</xsl:attribute>
		<xsl:attribute name="space-before">3.0pt</xsl:attribute>
		<xsl:attribute name="text-align">end</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="LeftCellSmall">
		<xsl:attribute name="line-height">2mm</xsl:attribute>
		<xsl:attribute name="space-after">3.0pt</xsl:attribute>
		<xsl:attribute name="space-before">3.0pt</xsl:attribute>
		<xsl:attribute name="text-align">start</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<!-- Altura muy pequeña -->
	<xsl:attribute-set name="RightCellXSmall">
		<xsl:attribute name="line-height">2mm</xsl:attribute>
		<xsl:attribute name="space-after">1.5pt</xsl:attribute>
		<xsl:attribute name="space-before">1pt</xsl:attribute>
		<xsl:attribute name="text-align">end</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="LeftCellXSmall">
		<xsl:attribute name="line-height">2mm</xsl:attribute>
		<xsl:attribute name="space-after">1.5pt</xsl:attribute>
		<xsl:attribute name="space-before">1pt</xsl:attribute>
		<xsl:attribute name="text-align">start</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<!-- Padding -->
	<xsl:attribute-set name="CellPadLeft">
		<xsl:attribute name="padding-left">2mm</xsl:attribute>
		<xsl:attribute name="padding-top">0mm</xsl:attribute>
		<xsl:attribute name="padding-bottom">0mm</xsl:attribute>
		<xsl:attribute name="padding-before">0mm</xsl:attribute>
		<xsl:attribute name="padding-end">0mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="CellPadRight">
		<xsl:attribute name="padding-right">2mm</xsl:attribute>
		<xsl:attribute name="padding-top">0mm</xsl:attribute>
		<xsl:attribute name="padding-bottom">0mm</xsl:attribute>
		<xsl:attribute name="padding-before">0mm</xsl:attribute>
		<xsl:attribute name="padding-end">0mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="CellNoPad">
		<xsl:attribute name="padding-right">0mm</xsl:attribute>
		<xsl:attribute name="padding-top">0mm</xsl:attribute>
		<xsl:attribute name="padding-bottom">0mm</xsl:attribute>
		<xsl:attribute name="padding-before">0mm</xsl:attribute>
		<xsl:attribute name="padding-end">0mm</xsl:attribute>
		<xsl:attribute name="space-after">0mm</xsl:attribute>
		<xsl:attribute name="space-before">0mm</xsl:attribute>
		<xsl:attribute name="space-end">0mm</xsl:attribute>
		<xsl:attribute name="space-start">0mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="CellStyle">
		<xsl:attribute name="padding">2mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="CellStyle1">
		<xsl:attribute name="padding">1mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="CellStyle0">
		<xsl:attribute name="padding">0mm</xsl:attribute>
	</xsl:attribute-set>
	<xsl:attribute-set name="CellStyle1LeftRight">
		<xsl:attribute name="padding-left">1mm</xsl:attribute>
		<xsl:attribute name="padding-right">1mm</xsl:attribute>
		<xsl:attribute name="padding-top">0mm</xsl:attribute>
		<xsl:attribute name="padding-bottom">0mm</xsl:attribute>
	</xsl:attribute-set>
	<!-- ESPACIO -->
	<xsl:attribute-set name="Space">
		<xsl:attribute name="line-height">5mm</xsl:attribute>
		<xsl:attribute name="white-space-collapse">false</xsl:attribute>
	</xsl:attribute-set>
	<!-- BORDES -->
	<xsl:variable name="border1.0" select="'1.0pt solid black'">
	</xsl:variable>
	<xsl:variable name="border1.5" select="'1.5pt solid black'">
	</xsl:variable>
	<xsl:variable name="border0.5" select="'0.5pt solid black'">
	</xsl:variable>
	<xsl:variable name="border0.1" select="'0.1pt solid black'">
	</xsl:variable>
	<!-- FUENTE -->
	<xsl:attribute-set name="Fuente">
		<xsl:attribute name="font-family">serif</xsl:attribute>
		<xsl:attribute name="font-size">6.0pt</xsl:attribute>
	</xsl:attribute-set>
	<xsl:template name="string-replace-all">
		<xsl:param name="text"/>
		<xsl:param name="replace"/>
		<xsl:param name="by"/>
		<xsl:choose>
			<xsl:when test="contains($text, $replace)">
				<xsl:value-of select="substring-before($text,$replace)"/>
				<xsl:value-of select="$by"/>
				<xsl:call-template name="string-replace-all">
					<xsl:with-param name="text" select="substring-after($text,$replace)"/>
					<xsl:with-param name="replace" select="$replace"/>
					<xsl:with-param name="by" select="$by"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="string-replace-all-by-element">
		<xsl:param name="text"/>
		<xsl:param name="replace"/>
		<xsl:param name="by"/>
		<xsl:choose>
			<xsl:when test="contains($text, $replace)">
				<xsl:value-of select="substring-before($text,$replace)"/>
				<xsl:copy-of select="$by"/>
				<xsl:call-template name="string-replace-all-by-element">
					<xsl:with-param name="text" select="substring-after($text,$replace)"/>
					<xsl:with-param name="replace" select="$replace"/>
					<xsl:with-param name="by">
						<xsl:copy-of select="$by"/>
					</xsl:with-param>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$text"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
