<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="reportStyle.xsl"/>
	<xsl:output encoding="UTF-8"/>
	<xsl:template name="plantillaHeader">
		<xsl:param name="literalTitulo"/>
		<xsl:param name="rutaImag"/>
		<fo:table table-layout="fixed" width="250mm">
			<fo:table-column column-width="60mm"/>
			<fo:table-column column-width="150mm"/>
			<fo:table-column column-width="40mm"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell>
						<fo:block/>
					</fo:table-cell>
					<fo:table-cell text-align="center" padding-top="2mm">
						<fo:block text-align="center">
							<fo:external-graphic src="{$rutaImag}ejgv_main.gif" text-align="center" height="2cm" width="8cm" content-height="scale-to-fit" content-width="scale-to-fit"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="plantillaHeaderIncidencia">
		<xsl:param name="literalTitulo1"/>
		<xsl:param name="literalTitulo2"/>
		<xsl:param name="rutaImag"/>
		<fo:table table-layout="fixed" width="190mm">
			<fo:table-column column-width="5mm"/>
			<fo:table-column column-width="40mm"/>
			<fo:table-column column-width="145mm"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell>
						<fo:block/>
					</fo:table-cell>
					<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}" text-align="center" padding-top="2mm" number-rows-spanned="2">
						<fo:block text-align="center">
							<fo:external-graphic src="{$rutaImag}marcagv3.gif" text-align="center" height="1.4cm" width="3.8cm" content-height="scale-to-fit" content-width="scale-to-fit"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" border-top="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
						<fo:block text-align="center">
							<fo:inline>
								<xsl:value-of select="$literalTitulo1"/>
							</fo:inline>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell>
						<fo:block/>
					</fo:table-cell>
					<fo:table-cell text-align="center" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
						<fo:block text-align="center">
							<fo:inline>
								<xsl:value-of select="$literalTitulo2"/>
							</fo:inline>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell text-align="center" number-columns-spanned="3">
						<fo:block text-align="center">
							<xsl:text>&#160;</xsl:text>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="plantillaHeaderIncidenciaHorizontal">
		<xsl:param name="literalTitulo1"/>
		<xsl:param name="literalTitulo2"/>
		<xsl:param name="rutaImag"/>
		<fo:table table-layout="fixed" width="250mm">
			<fo:table-column column-width="45mm"/>
			<fo:table-column column-width="40mm"/>
			<fo:table-column column-width="145mm"/>
			<fo:table-column column-width="47mm"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell>
						<fo:block/>
					</fo:table-cell>
					<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}" text-align="center" padding-top="2mm" number-rows-spanned="2">
						<fo:block text-align="center">
							<fo:external-graphic src="{$rutaImag}marcagv3.gif" text-align="center" height="1.4cm" width="3.8cm" content-height="scale-to-fit" content-width="scale-to-fit"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" border-top="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
						<fo:block text-align="center">
							<fo:inline>
								<xsl:value-of select="$literalTitulo1"/>
							</fo:inline>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell>
						<fo:block/>
					</fo:table-cell>
					<fo:table-cell text-align="center" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
						<fo:block text-align="center">
							<fo:inline>
								<xsl:value-of select="$literalTitulo2"/>
							</fo:inline>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
				<fo:table-row>
					<fo:table-cell text-align="center" number-columns-spanned="3">
						<fo:block text-align="center">
							<xsl:text>&#160;</xsl:text>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell>
						<fo:block/>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="plantillaHeaderPlanificacionHorizontal">
		<xsl:param name="literalTitulo1"/>
		<xsl:param name="literalTitulo2"/>
		<xsl:param name="rutaImag"/>
		<fo:table table-layout="fixed" width="250mm">
			<fo:table-column column-width="60mm"/>
			<fo:table-column column-width="130mm"/>
			<fo:table-column column-width="60mm"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell text-align="center">
						<fo:block text-align="center">
							<xsl:text>&#160;</xsl:text>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" padding-top="2mm">
						<fo:block text-align="center">
							<fo:external-graphic src="{$rutaImag}ejgv_main.gif" text-align="center" height="2cm" width="8cm" content-height="scale-to-fit" content-width="scale-to-fit"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center">
						<fo:block text-align="center">
							<xsl:text>&#160;</xsl:text>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="plantillaFooter">
		<xsl:param name="literalPagina"/>
		<xsl:param name="fecha"/>
		<fo:table table-layout="fixed" width="277mm">
			<fo:table-column column-width="130mm"/>
			<fo:table-column column-width="147mm"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell text-align="left">
						<fo:block text-align="start" white-space-collapse="false">
							<fo:inline xsl:use-attribute-sets="PageStyle">
								<xsl:value-of select="$fecha"/>
							</fo:inline>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="right">
						<fo:block text-align="end" white-space-collapse="false">
							<fo:inline xsl:use-attribute-sets="PageStyle">
								<xsl:value-of select="$literalPagina"/>&#160;<fo:page-number/>
							</fo:inline>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="plantillaHeaderVertical">
		<xsl:param name="literalTitulo"/>
		<xsl:param name="rutaImag"/>
		<fo:table table-layout="fixed" width="190mm">
			<fo:table-column column-width="30mm"/>
			<fo:table-column column-width="130mm"/>
			<fo:table-column column-width="30mm"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell text-align="center">
						<fo:block text-align="center">
							<xsl:text>&#160;</xsl:text>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center" padding-top="2mm">
						<fo:block text-align="center">
							<fo:external-graphic src="{$rutaImag}ejgv_main.gif" text-align="center" height="2cm" width="8cm" content-height="scale-to-fit" content-width="scale-to-fit"/>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="center">
						<fo:block text-align="center">
							<xsl:text>&#160;</xsl:text>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="plantillaFooterVertical">
		<xsl:param name="literalPagina"/>
		<xsl:param name="fecha"/>
		<fo:table table-layout="fixed" width="190mm">
			<fo:table-column column-width="95mm"/>
			<fo:table-column column-width="95mm"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell text-align="left">
						<fo:block text-align="start" white-space-collapse="false">
							<fo:inline xsl:use-attribute-sets="PageStyle">
								<xsl:value-of select="$fecha"/>
							</fo:inline>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="right">
						<fo:block text-align="end" white-space-collapse="false">
							<fo:inline xsl:use-attribute-sets="PageStyle">
								<xsl:value-of select="$literalPagina"/>&#160;<fo:page-number/>
							</fo:inline>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
	<xsl:template name="plantillaFooterVerticalIncidencia">
		<xsl:param name="literalPagina"/>
		<xsl:param name="fecha"/>
		<fo:table table-layout="fixed" width="190mm">
			<fo:table-column column-width="95mm"/>
			<fo:table-column column-width="95mm"/>
			<fo:table-body>
				<fo:table-row>
					<fo:table-cell text-align="left">
						<fo:block text-align="start" white-space-collapse="false">
							<fo:inline xsl:use-attribute-sets="PageStyle">
								<xsl:value-of select="$fecha"/>
							</fo:inline>
						</fo:block>
					</fo:table-cell>
					<fo:table-cell text-align="right">
						<fo:block text-align="end" white-space-collapse="false">
							<fo:inline xsl:use-attribute-sets="PageStyle">
								<xsl:value-of select="$literalPagina"/>&#160;<fo:page-number/>
							</fo:inline>
						</fo:block>
					</fo:table-cell>
				</fo:table-row>
			</fo:table-body>
		</fo:table>
	</xsl:template>
</xsl:stylesheet>
