<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="reportStyle.xsl"/>
	<xsl:include href="reportHeader.xsl"/>
	<xsl:output encoding="UTF-8"/>
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master xsl:use-attribute-sets="VerticalReport" master-name="pm1">
					<fo:region-body margin-bottom="12mm" margin-top="15mm" region-name="region-body" margin-left="0mm"/>
					<fo:region-before display-align="before" extent="15mm" overflow="visible" region-name="header"/>
					<fo:region-after display-align="after" extent="8mm" overflow="visible" region-name="footer"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pm1">
				<fo:static-content flow-name="header">
					<xsl:variable name="titulo">AA</xsl:variable>
					<xsl:call-template name="plantillaHeaderVertical">
						<xsl:with-param name="literalTitulo"/>
						<xsl:with-param name="rutaImag">/datos/aa20b/file/informes/images/</xsl:with-param>
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<xsl:call-template name="plantillaFooterVertical">
						<xsl:with-param name="fecha" select="//report/fechaHoy"/>
					</xsl:call-template>
				</fo:static-content>
				<fo:flow flow-name="region-body">
					<!-- ****************************************************************  -->
					<!-- ** 					TABLA   	   **  -->
					<!-- ****************************************************************  -->
					<fo:table>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="34%"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="3">
									<fo:block text-align="center">
										<fo:inline xsl:use-attribute-sets="TitleStyle">PREVENTIVOS - PENDIENTES DE ASIGNAR</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Nro. Ficha: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroNFicha"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Fecha desde: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFDesde"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Fecha hasta: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFHasta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Fecha planificación desde: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFplanifDesde"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Fecha planificación hasta: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFplanifHasta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
										</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Edificio: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroEdificio"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Zona: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroZona"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Planta: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroPlanta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Código de equipo: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroMCodigo"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Equipo: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroEquipo"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Gama: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroGama"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					<xsl:if test="//report/numFilas= 0">
						<fo:block text-align="center">
							<fo:inline xsl:use-attribute-sets="CellLetter">
								NO HAY DATOS
							</fo:inline>
						</fo:block>
					</xsl:if>
					<xsl:if test="//report/numFilas> 0">
						<fo:table table-layout="fixed" width="185mm">
							<fo:table-column column-width="15mm"/>
							<!-- PARTE -->
							<fo:table-column column-width="30mm"/>
							<!-- FECHA REGISTRO -->
							<fo:table-column column-width="30mm"/>
							<!-- FECHA EJECUCION -->
							<fo:table-column column-width="30mm"/>
							<!-- TIEMPO -->
							<fo:table-column column-width="40mm"/>
							<!-- CLASE-CODIGO -->
							<fo:table-column column-width="40mm"/>
							<!-- OBSERVACIONES -->
							<fo:table-header>
								<fo:table-row>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Nº Ficha</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>F. Prevista</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Edificio</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Zona/Planta</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Equipo</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Gama</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-header>
							<!-- ****************************************************************  -->
							<!-- ** 					CUERPO		   **  -->
							<!-- ****************************************************************  -->
							<fo:table-body>
								<xsl:for-each select="//report/listado/row">
									<fo:table-row>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./FICHA"/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="CenterCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./FECHAPREVISTA"/>
													<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./EDIFICIO"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./ZONAPLANTA"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./EQUIPO"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./GAMA"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:for-each>
								<fo:table-row>
									<fo:table-cell padding="0.0pt" padding-left="1mm">
										<fo:block xsl:use-attribute-sets="LeftCell">
											<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</xsl:if>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
