<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="reportStyle.xsl"/>
	<xsl:include href="reportHeader.xsl"/>
	<xsl:output encoding="UTF-8"/>
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master xsl:use-attribute-sets="VerticalReport" master-name="pm1">
					<fo:region-body margin-bottom="12mm" margin-top="15mm" region-name="region-body" margin-left="0mm"/>
					<fo:region-before display-align="before" extent="15mm" overflow="visible" region-name="header"/>
					<fo:region-after display-align="after" extent="8mm" overflow="visible" region-name="footer"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pm1">
				<fo:static-content flow-name="header">
					<xsl:variable name="titulo">AA</xsl:variable>
					<xsl:call-template name="plantillaHeaderVertical">
						<xsl:with-param name="literalTitulo"/>
						<xsl:with-param name="rutaImag">/datos/s71/file/informes/images/</xsl:with-param>
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<xsl:call-template name="plantillaFooterVertical">
						<!--<xsl:with-param name="literalPagina" select="//report/literales/row[ID='rep001_PAGINA']/TEXT"/>-->
						<xsl:with-param name="fecha" select="//report/fechaHoy"/>
					</xsl:call-template>
				</fo:static-content>
				<fo:flow flow-name="region-body">
					<!-- ****************************************************************  -->
					<!-- ** 					TABLA   	   **  -->
					<!-- ****************************************************************  -->
					<fo:table>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="34%"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="3">
									<fo:block text-align="center">
										<fo:inline xsl:use-attribute-sets="TitleStyle">E-PARTES ASIGNADOS AUTOMATICAMENTE PENDIENTES DE EJECUTAR</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Parte: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroNParte"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Noiztik data: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFDesde"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Noiz arte data: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFHasta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Plangintza-data noiztik: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFplanifDesde"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Plangintza-data noiz arte: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFplanifHasta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Izena: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroNombre"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Saila: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroDpto"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Adm. Egit. Atala: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroDir"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Eraikina: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroEdificio"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Zonaldea: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroZona"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Solairua: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroPlanta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Klasea: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroClase"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Codigo: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroCodigo"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Presakoa: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroUrgente"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					<xsl:if test="//report/numFilas= 0">
						<fo:block text-align="center">
							<fo:inline xsl:use-attribute-sets="CellLetter">
								EZ DAGO DATURIK
							</fo:inline>
						</fo:block>
					</xsl:if>
					<xsl:if test="//report/numFilas> 0">
						<fo:table table-layout="fixed" width="150mm">
							<fo:table-column column-width="30mm"/>
							<!-- TECNICOS -->
							<fo:table-column column-width="10mm"/>
							<!-- PARTE -->
							<fo:table-column column-width="25mm"/>
							<!-- FECHA REGISTRO -->
							<fo:table-column column-width="25mm"/>
							<!-- FECHA EJECUCION -->
							<fo:table-column column-width="15mm"/>
							<!-- TIEMPO -->
							<fo:table-column column-width="40mm"/>
							<!-- CLASParte-kodea -->
							<fo:table-column column-width="40mm"/>
							<!-- OBSERVACIONES -->
							<fo:table-header>
								<fo:table-row>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Teknikarias</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Parte zk.</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Erregistro data</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Gauzapena data</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Denbora</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Klasea/parte-kodea</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>Oharrak</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-header>
							<!-- ****************************************************************  -->
							<!-- ** 					CUERPO		   **  -->
							<!-- ****************************************************************  -->
							<fo:table-body>
								<xsl:for-each select="//report/listado/row">
									<fo:table-row>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./NOMBRE"/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./PARTE"/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="CenterCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./FECHARE"/>
													<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./FECHAEJ"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="RightCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./TIEMPO"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="RightCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./CLASECODIGO"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="RightCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./OBSERV"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:for-each>
								<fo:table-row>
									<fo:table-cell padding="0.0pt" padding-left="1mm">
										<fo:block xsl:use-attribute-sets="LeftCell">
											<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</xsl:if>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
