<?xml version="1.0" encoding="UTF-8"?>
<!-- editado con XMLSpy v2015 (http://www.altova.com) por EJIE, S.A. (EJIE, S.A.) -->
<xsl:stylesheet version="2.0" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="reportStyle.xsl"/>
	<xsl:include href="reportHeader.xsl"/>
	<xsl:output encoding="UTF-8"/>
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master xsl:use-attribute-sets="VerticalReport" master-name="pm1">
					<fo:region-body margin-bottom="12mm" margin-top="15mm" region-name="region-body" margin-left="0mm"/>
					<fo:region-before display-align="before" extent="15mm" overflow="visible" region-name="header"/>
					<fo:region-after display-align="after" extent="8mm" overflow="visible" region-name="footer"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pm1">
				<fo:static-content flow-name="header">
					<xsl:variable name="titulo">AA</xsl:variable>
					<xsl:call-template name="plantillaHeaderVertical">
						<xsl:with-param name="literalTitulo"/>
						<xsl:with-param name="rutaImag">/datos/aa20b/file/informes/images/</xsl:with-param>
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<xsl:call-template name="plantillaFooterVertical">
						<xsl:with-param name="fecha" select="//report/fechaHoy"/>
					</xsl:call-template>
				</fo:static-content>
				<fo:flow flow-name="region-body">
					<!-- ****************************************************************  -->
					<!-- ** 					TABLA   	   **  -->
					<!-- ****************************************************************  -->
					<fo:table>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="34%"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="3">
									<fo:block text-align="center">
										<fo:inline xsl:use-attribute-sets="TitleStyle">FICHAS DETALLADAS</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Fitxa zk.: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroNFicha"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Aurreikusitako data noiz arte: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFDesde"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Aurreikusitako data noiz arte: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFHasta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Plangintza-data noiztik: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFplanifDesde"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Plangintza-data noiz arte: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFplanifHasta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Eraikina: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroEdificio"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Zonaldea: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroZona"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Solairua: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroPlanta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Ekipo-kodea: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroMCodigo"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Ekipo: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroEquipo"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Gama: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroGama"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Teknikaria: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroTecnico"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Gauzatuak: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroEjecutados"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Parados: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroParados"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Gauzatzeko zain: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroPendEjecutar"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					<xsl:if test="//report/numFilas= 0">
						<fo:block text-align="center">
							<fo:inline xsl:use-attribute-sets="CellLetter">
								EZ DAGO DATURIK
							</fo:inline>
						</fo:block>
					</xsl:if>
					<xsl:if test="//report/numFilas> 0">
						<fo:table table-layout="fixed" width="185mm">
							<!-- FECHA EJ -->
							<fo:table-column column-width="20mm"/>
							<!-- NOMBRE -->
							<fo:table-column column-width="30mm"/>
							<!-- NUMERO -->
							<fo:table-column column-width="20mm"/>
							<!-- CODIGO -->
							<fo:table-column column-width="20mm"/>
							<!-- DESCRIPCION -->
							<fo:table-column column-width="55mm"/>
							<!-- TIEMPO -->
							<fo:table-column column-width="20mm"/>
							<!-- EJECUTADO -->
							<fo:table-column column-width="20mm"/>
							<fo:table-header>
								<fo:table-row>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>GAUZATU DATA.</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>IZENA</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>ZENBAKIA</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>KODEA</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>DESKRIBAPENA</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>DENBORA</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>GAUZATU</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-header>
							<!-- ****************************************************************  -->
							<!-- ** 					CUERPO		   **  -->
							<!-- ****************************************************************  -->
							<fo:table-body>
								<xsl:for-each select="//report/listado/FECHASEJECUCION">
									<fo:table-row>
										<fo:table-cell number-columns-spanned="6" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select='@FEEJECTECNICO'/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<xsl:for-each select="FICHA">
										<fo:table-row>
											<fo:table-cell>
												<fo:block xsl:use-attribute-sets="LeftCell">
													<fo:inline xsl:use-attribute-sets="CellLetter">
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./TECNICO"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select='@NUMERO'/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./MCODIGO"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./EQUIPO"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./TIEMPOTECFICHA"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./EJECUTADO"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</xsl:for-each>
									<fo:table-row>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													GUZTIRA:
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select='@CONTFICHAS'/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select='@TIEMPOTECNICO'/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0.0pt" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:for-each>
								<fo:table-row>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
											<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
											<fo:inline xsl:use-attribute-sets="CellLetter">
													BATURA GUZTIRA:
												</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
										<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
											<fo:inline xsl:use-attribute-sets="CellLetter">
												<xsl:value-of select='//report/numFilas'/>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
											<fo:inline xsl:use-attribute-sets="CellLetter">
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
											<fo:inline xsl:use-attribute-sets="CellLetter">
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
											<fo:inline xsl:use-attribute-sets="CellLetter">
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell>
										<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
											<fo:inline xsl:use-attribute-sets="CellLetter">
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-body>
						</fo:table>
					</xsl:if>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
