<?xml version="1.0" encoding="UTF-8"?>
<!-- editado con XMLSpy v2015 (http://www.altova.com) por EJIE, S.A. (EJIE, S.A.) -->
<xsl:stylesheet version="2.0" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="reportStyle.xsl"/>
	<xsl:include href="reportHeader.xsl"/>
	<xsl:output encoding="UTF-8"/>
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master xsl:use-attribute-sets="VerticalReport" master-name="pm1">
					<fo:region-body margin-bottom="12mm" margin-top="15mm" region-name="region-body" margin-left="0mm"/>
					<fo:region-before display-align="before" extent="15mm" overflow="visible" region-name="header"/>
					<fo:region-after display-align="after" extent="8mm" overflow="visible" region-name="footer"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pm1">
				<fo:static-content flow-name="header">
					<xsl:variable name="titulo">AA</xsl:variable>
					<xsl:call-template name="plantillaHeaderVertical">
						<xsl:with-param name="literalTitulo"/>
						<xsl:with-param name="rutaImag">/datos/aa20b/file/informes/images/</xsl:with-param>
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<xsl:call-template name="plantillaFooterVertical">
						<xsl:with-param name="fecha" select="//report/fechaHoy"/>
					</xsl:call-template>
				</fo:static-content>
				<fo:flow flow-name="region-body">
					<!-- ****************************************************************  -->
					<!-- ** 					TABLA   	   **  -->
					<!-- ****************************************************************  -->
					<fo:table>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="34%"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="3">
									<fo:block text-align="center">
										<fo:inline xsl:use-attribute-sets="TitleStyle">TOTALES EJECUTADOS POR TÉCNICO</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Fecha ej. max. desde: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFDesde"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Fecha ej. max. hasta: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFHasta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Servicio: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroServicio"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Fecha planificación desde: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFplanifDesde"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Fecha planificación hasta: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFplanifHasta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Nombre: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroNombre"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Departamento: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroDpto"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Centro Orgánico: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroDir"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Edificio: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroEdificio"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Zona: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroZona"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Planta: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroPlanta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Clase: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroClase"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Codigo: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroCodigo"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Técnico: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroTecnicos"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Urgente: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroUrgente"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
										Nro. Parte:
										</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroIdparte"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
										Envio mail:
										</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroEnviomail"/>	
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>							
						</fo:table-body>
					</fo:table>
					<xsl:if test="//report/numFilas= 0">
						<fo:block text-align="center">
							<fo:inline xsl:use-attribute-sets="CellLetter">
								NO HAY DATOS
							</fo:inline>
						</fo:block>
					</xsl:if>
					<xsl:if test="//report/numFilas> 0">
						<fo:table table-layout="fixed" width="185mm">
							<!-- NOMBRE -->
							<fo:table-column column-width="30mm"/>
							<!-- NUMERO -->
							<fo:table-column column-width="20mm"/>
							<!-- CODIGO -->
							<fo:table-column column-width="55mm"/>
							<!-- FECHARE -->
							<fo:table-column column-width="20mm"/>
							<!-- FECHAEJ -->
							<fo:table-column column-width="20mm"/>
							<!-- TIEMPO -->
							<fo:table-column column-width="20mm"/>
							<!-- EJECUTADO -->
							<fo:table-column column-width="20mm"/>
							<fo:table-header >
								<fo:table-row>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>NOMBRE</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>NÚMERO</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>CÓDIGO</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>FECHARE</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>FECHAEJ</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>TIEMPO</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
									<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
										<fo:block>
											<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												<xsl:text>EJEC.</xsl:text>
											</fo:inline>
										</fo:block>
									</fo:table-cell>
								</fo:table-row>
							</fo:table-header>
							<!-- ****************************************************************  -->
							<!-- ** 					CUERPO		   **  -->
							<!-- ****************************************************************  -->
							<fo:table-body>
								<xsl:for-each select="//report/listado/TECNICOS">
									<fo:table-row>
										<fo:table-cell number-columns-spanned="7" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select='@NOMBRE'/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<xsl:for-each select="PARTE">
										<fo:table-row>
											<fo:table-cell>
												<fo:block xsl:use-attribute-sets="LeftCell">
													<fo:inline xsl:use-attribute-sets="CellLetter">
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select='@NUMERO'/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./CODIGO"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./FECHARE"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./FECHAEJ"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./TIEMPOREAL"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./EJECUTADO"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</xsl:for-each>
									<fo:table-row>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													TOTAL:
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select='@CONTPARTES'/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select='@TIEMPOTECNICO'/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="center">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0.0pt" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</xsl:for-each>
							</fo:table-body>
						</fo:table>
					</xsl:if>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
