<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="reportStyle.xsl"/>
	<xsl:include href="reportHeader.xsl"/>
	<xsl:output encoding="UTF-8"/>
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master xsl:use-attribute-sets="VerticalReport" master-name="pm1">
					<fo:region-body margin-bottom="12mm" margin-top="15mm" region-name="region-body" margin-left="0mm"/>
					<fo:region-before display-align="before" extent="15mm" overflow="visible" region-name="header"/>
					<fo:region-after display-align="after" extent="8mm" overflow="visible" region-name="footer"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pm1">
				<fo:static-content flow-name="header">
					<xsl:variable name="titulo">AA</xsl:variable>
					<xsl:call-template name="plantillaHeaderVertical">
						<xsl:with-param name="literalTitulo"/>
						<xsl:with-param name="rutaImag">/datos/aa20b/file/informes/images/</xsl:with-param>
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<xsl:call-template name="plantillaFooterVertical">
						<xsl:with-param name="fecha" select="//report/fechaHoy"/>
					</xsl:call-template>
				</fo:static-content>
				<fo:flow flow-name="region-body">
					<!-- ****************************************************************  -->
					<!-- ** 					TABLA   	   **  -->
					<!-- ****************************************************************  -->
					<fo:table>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="34%"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="3">
									<fo:block text-align="center">
										<fo:inline xsl:use-attribute-sets="TitleStyle">FITXA EGUNEROKOA</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					<xsl:if test="//report/numFilas= 0">
						<fo:block text-align="center">
							<fo:inline xsl:use-attribute-sets="CellLetter">
								EZ DAGO DATURIK
							</fo:inline>
						</fo:block>
					</xsl:if>
					<xsl:if test="//report/numFilas> 0">
						<xsl:for-each select="//report/listado/TECNICO">
							<fo:table>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell>
											<fo:block text-align="left">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													TEKNIKARIA: <xsl:value-of select="@dTecnico"/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<xsl:for-each select="FICHA">
								<fo:table table-layout="fixed" keep-together.within-page="always">
									<fo:table-column column-width="20%"/>
									<fo:table-column column-width="30%"/>
									<fo:table-column column-width="20%"/>
									<fo:table-column column-width="30%"/>
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Aurreikusitako data:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./FECHAPREVISTA"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Fitxaren deskribapena:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./DESCRIPCIONFICHA"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Zenbakia:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="@dFicha"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Eraikina:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./EDIFICIO"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Ekipoko-kodea:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./MCODIGO"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Zonaldea/Solairua:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./ZONAPLANTA"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Ekipoko deskribapena:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./EQUIPO"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Gauzatze-data:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./FECHAEJEC"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Gama:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./GAMA"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Gauzatze-denbora:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./TIEMPOREAL"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Klasea:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./CLASE"/>													
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Gauzatua:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./EJECUTADO"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="right">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
												Oharrak:
												</fo:inline>
												</fo:block>
											</fo:table-cell>
											<fo:table-cell number-columns-spanned="3">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell number-columns-spanned="4" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:value-of select="./OBSERVACIONES"/>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell>
												<fo:block text-align="left">
													<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</xsl:for-each>
							<fo:block text-align="left" break-after="page">
							</fo:block>
						</xsl:for-each>
					</xsl:if>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
