<?xml version="1.0" encoding="UTF-8"?>
<!-- editado con XMLSpy v2015 (http://www.altova.com) por EJIE, S.A. (EJIE, S.A.) -->
<xsl:stylesheet version="2.0" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="reportStyle.xsl"/>
	<xsl:include href="reportHeader.xsl"/>
	<xsl:output encoding="UTF-8"/>
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master xsl:use-attribute-sets="VerticalReport" master-name="pm1">
					<fo:region-body margin-bottom="12mm" margin-top="15mm" region-name="region-body" margin-left="0mm"/>
					<fo:region-before display-align="before" extent="15mm" overflow="visible" region-name="header"/>
					<fo:region-after display-align="after" extent="8mm" overflow="visible" region-name="footer"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pm1">
				<fo:static-content flow-name="header">
					<xsl:variable name="titulo">AA</xsl:variable>
					<xsl:call-template name="plantillaHeaderVertical">
						<xsl:with-param name="literalTitulo"/>
						<xsl:with-param name="rutaImag">/datos/aa20b/file/informes/images/</xsl:with-param>
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<xsl:call-template name="plantillaFooterVertical">
						<xsl:with-param name="fecha" select="//report/fechaHoy"/>
					</xsl:call-template>
				</fo:static-content>
				<fo:flow flow-name="region-body">
					<!-- ****************************************************************  -->
					<!-- ** 					TABLA   	   **  -->
					<!-- ****************************************************************  -->
					<fo:table>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="34%"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="3">
									<fo:block text-align="center">
										<fo:inline xsl:use-attribute-sets="TitleStyle">PARTEAK ZERRENDA</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Harrera-data noiztik: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFDesde"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Harrera-data noiz arte: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFHasta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Zerbitzua: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroServicio"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Plangintza-data noiztik: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFplanifDesde"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Plangintza-data noiz arte: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroFplanifHasta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Izena: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroNombre"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Saila: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroDpto"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Adm. Egit. Atala: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroDir"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
										Parte-zk.:
										</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroIdparte"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Eraikina: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroEdificio"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Zonaldea: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroZona"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Solairua: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroPlanta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Klasea: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroClase"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Parte-kodea: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroCodigo"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Gauzatua: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroEjecutados"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Egiteko, teknikaririk gabe: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroPendSinT"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Egiteko, teknikariarekin:  
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroPendConT"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Teknikaria: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroTecnicos"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Presakoa: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroUrgente"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
										Email bidalketa:
										</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroEnviomail"/>	
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					<xsl:if test="//report/numFilas= 0">
						<fo:block text-align="center">
							<fo:inline xsl:use-attribute-sets="CellLetter">
								EZ DAGO DATURIK
							</fo:inline>
						</fo:block>
					</xsl:if>
					<xsl:if test="//report/numFilas> 0">
						<xsl:for-each select="//report/listado/row">
							<fo:table break-after="page" keep-together.within-page="always">
								<fo:table-column column-width="20%"/>
								<fo:table-column column-width="30%"/>
								<fo:table-column column-width="20%"/>
								<fo:table-column column-width="30%"/>
								<fo:table-body>
									<fo:table-row >
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell number-columns-spanned="2" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="left">
												<fo:inline xsl:use-attribute-sets="CellLetter">TEKNIKARIA: 
													<xsl:value-of select="./TECNICOS"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="4" padding="0.0pt" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Harrera-data:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./FECHARE"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Eskatzatilea:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./SOLICIT"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Zenbakia:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./PARTE"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Telefonoa:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./TELEFO"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Klasea:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./CLASE"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Eraikina:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./EDIF"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Parte-kodea:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./CODIGO"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle" text-align="right">Zonaldea:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./ZONA"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Saila:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./DEPAR"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Solairu/Egonlekua:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./PLANTA"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Adm. Egit. Atala:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell number-columns-spanned="3" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./DIRECCION"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Amaiera-data:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./FECHAEJ"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Gauzatutako orduak guztira:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./TIEMPOREAL"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="SubtitleStyle">Oharrak:</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
											</fo:block>
										</fo:table-cell>
										<fo:table-cell>
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="4" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:value-of select="./OBSERV"/>
												</fo:inline>
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="4" padding="0.0pt" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="4" padding="0.0pt" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
						</xsl:for-each>
					</xsl:if>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
