<?xml version="1.0" encoding="UTF-8"?>
<!-- editado con XMLSpy v2015 (http://www.altova.com) por EJIE, S.A. (EJIE, S.A.) -->
<xsl:stylesheet version="2.0" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:import href="reportStyle.xsl"/>
	<xsl:include href="reportHeader.xsl"/>
	<xsl:output encoding="UTF-8"/>
	<xsl:template match="/">
		<fo:root>
			<fo:layout-master-set>
				<fo:simple-page-master xsl:use-attribute-sets="HorizontalReport" master-name="pm1">
					<fo:region-body margin-bottom="12mm" margin-top="15mm" region-name="region-body" margin-left="0mm"/>
					<fo:region-before display-align="before" extent="15mm" overflow="visible" region-name="header"/>
					<fo:region-after display-align="after" extent="8mm" overflow="visible" region-name="footer"/>
				</fo:simple-page-master>
			</fo:layout-master-set>
			<fo:page-sequence master-reference="pm1">
				<fo:static-content flow-name="header">
					<xsl:variable name="titulo">AA</xsl:variable>
					<xsl:call-template name="plantillaHeaderPlanificacionHorizontal">
						<xsl:with-param name="rutaImag">/datos/aa20b/file/informes/images/</xsl:with-param>
					</xsl:call-template>
				</fo:static-content>
				<fo:static-content flow-name="footer">
					<xsl:call-template name="plantillaFooterVerticalIncidencia">
						<xsl:with-param name="fecha" select="//report/fechaHoy"/>
					</xsl:call-template>
				</fo:static-content>
				<fo:flow flow-name="region-body">
					<!-- ****************************************************************  -->
					<!-- ** 					TABLA   	   **  -->
					<!-- ****************************************************************  -->
					<fo:table>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="33%"/>
						<fo:table-column column-width="34%"/>
						<fo:table-body>
							<fo:table-row>
								<fo:table-cell number-columns-spanned="3">
									<fo:block text-align="center">
										<fo:inline xsl:use-attribute-sets="TitleStyle">Actuaciones Realizadas en el año <xsl:value-of select="//report/Anio"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell padding="0.0pt" padding-left="1mm">
									<fo:block xsl:use-attribute-sets="LeftCell">
										<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Territorio: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroTerritorio"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Zona: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroZona"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Planta: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroPlanta"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Situación: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroSituacion"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Nº Ficha: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroNumFicha"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Gama: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroGama"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Maquina: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroMaquina"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Para contrata: 
											</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroContrata"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
											Incluir equipos de baja: 
										</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
											<xsl:value-of select="//report/filtroInclBaja"/>
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
							
							<fo:table-row>
								<fo:table-cell>
									<fo:block text-align="left">
										<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
										</fo:inline>
										<fo:inline xsl:use-attribute-sets="CellLetter">
										</fo:inline>
									</fo:block>
								</fo:table-cell>
							</fo:table-row>
						</fo:table-body>
					</fo:table>
					<xsl:if test="//report/numFilas= 0">
						<fo:block text-align="center">
							<fo:inline xsl:use-attribute-sets="CellLetter">
								NO HAY DATOS
							</fo:inline>
						</fo:block>
					</xsl:if>
					<xsl:if test="//report/numFilas> 0">
						<xsl:for-each select="//report/listado/GAMA">
							<fo:table>
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell>
											<fo:block text-align="left">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													Gama: <xsl:value-of select="@dGama"/>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<xsl:for-each select="EDIFICIO">
								<xsl:for-each select="ZONA">
									<xsl:for-each select="PLANTA">
										<fo:table>
											<fo:table-column column-width="50%"/>
											<fo:table-column column-width="25%"/>
											<fo:table-column column-width="25%"/>
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell>
														<fo:block text-align="left">
															<fo:inline xsl:use-attribute-sets="CellLetter">
													Edificio: <xsl:value-of select="../../@dEdificio"/>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<fo:block text-align="left">
															<fo:inline xsl:use-attribute-sets="CellLetter">
													Zona: <xsl:value-of select="../@dZona"/>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell>
														<fo:block text-align="left">
															<fo:inline xsl:use-attribute-sets="CellLetter">
													Planta: <xsl:value-of select="@dPlanta"/>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<fo:table table-layout="fixed" width="250mm" table-omit-header-at-break="true">
											<fo:table-column column-width="20mm"/>
											<fo:table-column column-width="40mm"/>
											<!-- PARTE -->
											<!--<xsl:for-each select="0 to 53">-->
											<xsl:for-each select="//report/SEM">
												<fo:table-column column-width="4mm"/>
											</xsl:for-each>
											<fo:table-header>
												<fo:table-row>
													<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
														<fo:block>
															<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
																<xsl:text>--</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
														<fo:block>
															<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
																<xsl:text>--</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<xsl:for-each select="//report/MES">
														<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}"   padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
															<fo:block>
																<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
																	<xsl:value-of select="."/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</xsl:for-each>
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
														<fo:block>
															<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
																<xsl:text>Código</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
														<fo:block>
															<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
																<xsl:text>Equipo</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<!--<xsl:for-each select="0 to 53">-->
													<xsl:for-each select="//report/SEM">
														<fo:table-cell xsl:use-attribute-sets="CabeceraGris" border-top="{$border1.0}" border-bottom="{$border1.0}"   padding="0.5pt" border-left="{$border1.0}" border-right="{$border1.0}">
															<fo:block>
																<fo:inline xsl:use-attribute-sets="HeaderCellLetter">
																	<xsl:value-of select="."/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</xsl:for-each>
												</fo:table-row>
											</fo:table-header>
											<!-- ****************************************************************  -->
											<!-- ** 					CUERPO		   **  -->
											<!-- ****************************************************************  -->
											<fo:table-body>
												<xsl:for-each select="MAQUINA">
													<fo:table-row>
														<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
															<fo:block xsl:use-attribute-sets="LeftCell">
																<fo:inline xsl:use-attribute-sets="CellLetter">
																	<xsl:value-of select="CODIGO"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
															<fo:block xsl:use-attribute-sets="LeftCell">
																<fo:inline xsl:use-attribute-sets="CellLetter">
																	<xsl:value-of select="NOMBRE"/>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
														<!--<xsl:for-each select="semana">-->
														<xsl:variable name="semanas" select="SEMANA"/>
														<!--<xsl:for-each select="0 to 53">-->
														<xsl:for-each select="//report/SEM">
															<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="0mm">
																<xsl:variable name="offset" select="format-number(position()-1,'#')"/>
																<fo:block xsl:use-attribute-sets="CenterCell" line-height="0.5">
																	<fo:inline xsl:use-attribute-sets="CellLetter" font-size="5">
																		<xsl:choose>
																			<xsl:when test="$semanas[@numero=$offset]">
																				<xsl:value-of select="$semanas[@numero=$offset]/valor"/>
																			</xsl:when>
																			<xsl:otherwise/>
																		</xsl:choose>
																	</fo:inline>
																</fo:block>
															</fo:table-cell>
														</xsl:for-each>
														<!--</xsl:for-each>-->
													</fo:table-row>
												</xsl:for-each>
												<fo:table-row>
													<fo:table-cell padding="0.0pt" padding-left="1mm">
														<fo:block xsl:use-attribute-sets="LeftCell">
															<fo:inline xsl:use-attribute-sets="CellLetter"/>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
										<!-- ****************************************************************  -->
										<!-- ** 					TOTALES POR PLANTA  		           **  -->
										<!-- ****************************************************************  -->
										<fo:table table-layout="fixed" width="250mm" table-omit-header-at-break="true">
											<fo:table-column column-width="20mm"/>
											<fo:table-column column-width="40mm"/>
											<!-- PARTE -->
											<!--<xsl:for-each select="0 to 53">-->
											<xsl:for-each select="//report/SEM">
												<fo:table-column column-width="4mm"/>
											</xsl:for-each>
											<!-- ****************************************************************  -->
											<!-- ** 					CUERPO		   **  -->
											<!-- ****************************************************************  -->
											<fo:table-body>
												<fo:table-row>
													<fo:table-cell number-columns-spanned="2" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
														<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
															<fo:inline xsl:use-attribute-sets="CellLetter">
																<xsl:text>TOTAL PLANTA</xsl:text>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
													<!--<xsl:for-each select="semana">-->
													<xsl:variable name="totalSemanas" select="TOTALPLANTA"/>
													<!--<xsl:for-each select="0 to 53">-->
													<xsl:for-each select="//report/SEM">
														<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="0mm">
															<xsl:variable name="offset" select="format-number(position()-1,'#')"/>
															<fo:block xsl:use-attribute-sets="CenterCell" line-height="0.5">
																<fo:inline xsl:use-attribute-sets="CellLetter" font-size="5">
																	<xsl:choose>
																		<xsl:when test="$totalSemanas[@numero=$offset]">
																			<xsl:value-of select="$totalSemanas[@numero=$offset]/valor"/>
																		</xsl:when>
																		<xsl:otherwise/>
																	</xsl:choose>
																</fo:inline>
															</fo:block>
														</fo:table-cell>
													</xsl:for-each>
													<!--</xsl:for-each>-->
												</fo:table-row>
												<fo:table-row>
													<fo:table-cell padding="0.0pt" padding-left="1mm">
														<fo:block xsl:use-attribute-sets="LeftCell">
															<fo:inline xsl:use-attribute-sets="CellLetter"/>
														</fo:block>
													</fo:table-cell>
												</fo:table-row>
											</fo:table-body>
										</fo:table>
									</xsl:for-each>
									<!-- ****************************************************************  -->
									<!-- ** 					TOTALES POR ZONA  		           **  -->
									<!-- ****************************************************************  -->
									<fo:table table-layout="fixed" width="250mm" table-omit-header-at-break="true">
										<fo:table-column column-width="20mm"/>
										<fo:table-column column-width="40mm"/>
										<!-- PARTE -->
										<!--<xsl:for-each select="0 to 53">-->
										<xsl:for-each select="//report/SEM">
											<fo:table-column column-width="4mm"/>
										</xsl:for-each>
										<!-- ****************************************************************  -->
										<!-- ** 					CUERPO		   **  -->
										<!-- ****************************************************************  -->
										<fo:table-body>
											<fo:table-row>
												<fo:table-cell number-columns-spanned="2" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
													<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
														<fo:inline xsl:use-attribute-sets="CellLetter">
															<xsl:text>TOTAL ZONA</xsl:text>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
												<!--<xsl:for-each select="semana">-->
												<xsl:variable name="totalSemanas" select="TOTALZONA"/>
												<!--<xsl:for-each select="0 to 53">-->
												<xsl:for-each select="//report/SEM">
													<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="0mm">
														<xsl:variable name="offset" select="format-number(position()-1,'#')"/>
														<fo:block xsl:use-attribute-sets="CenterCell" line-height="0.5">
															<fo:inline xsl:use-attribute-sets="CellLetter" font-size="5">
																<xsl:choose>
																	<xsl:when test="$totalSemanas[@numero=$offset]">
																		<xsl:value-of select="$totalSemanas[@numero=$offset]/valor"/>
																	</xsl:when>
																	<xsl:otherwise/>
																</xsl:choose>
															</fo:inline>
														</fo:block>
													</fo:table-cell>
												</xsl:for-each>
												<!--</xsl:for-each>-->
											</fo:table-row>
											<fo:table-row>
												<fo:table-cell padding="0.0pt" padding-left="1mm">
													<fo:block xsl:use-attribute-sets="LeftCell">
														<fo:inline xsl:use-attribute-sets="CellLetter"/>
													</fo:block>
												</fo:table-cell>
											</fo:table-row>
										</fo:table-body>
									</fo:table>
								</xsl:for-each>
								<!-- ****************************************************************  -->
								<!-- ** 					TOTALES POR EDIFICIO  		           **  -->
								<!-- ****************************************************************  -->
								<fo:table table-layout="fixed" width="250mm" table-omit-header-at-break="true">
									<fo:table-column column-width="20mm"/>
									<fo:table-column column-width="40mm"/>
									<!-- PARTE -->
									<!--<xsl:for-each select="0 to 53">-->
									<xsl:for-each select="//report/SEM">
										<fo:table-column column-width="4mm"/>
									</xsl:for-each>
									<!-- ****************************************************************  -->
									<!-- ** 					CUERPO		   **  -->
									<!-- ****************************************************************  -->
									<fo:table-body>
										<fo:table-row>
											<fo:table-cell number-columns-spanned="2" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
													<fo:inline xsl:use-attribute-sets="CellLetter">
														<xsl:text>TOTAL EDIFICIO</xsl:text>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
											<!--<xsl:for-each select="semana">-->
											<xsl:variable name="totalSemanas" select="TOTALEDIFICIO"/>
											<!--<xsl:for-each select="0 to 53">-->
											<xsl:for-each select="//report/SEM">
												<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="0mm">
													<xsl:variable name="offset" select="format-number(position()-1,'#')"/>
													<fo:block xsl:use-attribute-sets="CenterCell" line-height="0.5">
														<fo:inline xsl:use-attribute-sets="CellLetter" font-size="5">
															<xsl:choose>
																<xsl:when test="$totalSemanas[@numero=$offset]">
																	<xsl:value-of select="$totalSemanas[@numero=$offset]/valor"/>
																</xsl:when>
																<xsl:otherwise/>
															</xsl:choose>
														</fo:inline>
													</fo:block>
												</fo:table-cell>
											</xsl:for-each>
											<!--</xsl:for-each>-->
										</fo:table-row>
										<fo:table-row>
											<fo:table-cell padding="0.0pt" padding-left="1mm">
												<fo:block xsl:use-attribute-sets="LeftCell">
													<fo:inline xsl:use-attribute-sets="CellLetter"/>
												</fo:block>
											</fo:table-cell>
										</fo:table-row>
									</fo:table-body>
								</fo:table>
							</xsl:for-each>
							<!-- ****************************************************************  -->
							<!-- ** 					TOTALES POR GAMA  		           **  -->
							<!-- ****************************************************************  -->
							<fo:table table-layout="fixed" width="250mm" table-omit-header-at-break="true">
								<fo:table-column column-width="20mm"/>
								<fo:table-column column-width="40mm"/>
								<!-- PARTE -->
								<!--<xsl:for-each select="0 to 53">-->
								<xsl:for-each select="//report/SEM">
									<fo:table-column column-width="4mm"/>
								</xsl:for-each>
								<!-- ****************************************************************  -->
								<!-- ** 					CUERPO		   **  -->
								<!-- ****************************************************************  -->
								<fo:table-body>
									<fo:table-row>
										<fo:table-cell number-columns-spanned="2" border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell" text-align="right">
												<fo:inline xsl:use-attribute-sets="CellLetter">
													<xsl:text>TOTAL GAMA</xsl:text>
												</fo:inline>
											</fo:block>
										</fo:table-cell>
										<!--<xsl:for-each select="semana">-->
										<xsl:variable name="totalSemanas" select="TOTALSEMANA"/>
										<!--<xsl:for-each select="0 to 53">-->
										<xsl:for-each select="//report/SEM">
											<fo:table-cell border-top="{$border1.0}" border-bottom="{$border1.0}" padding="0.0pt" border-left="{$border1.0}" border-right="{$border1.0}" padding-left="0mm">
												<xsl:variable name="offset" select="format-number(position()-1,'#')"/>
												<fo:block xsl:use-attribute-sets="CenterCell" line-height="0.5">
													<fo:inline xsl:use-attribute-sets="CellLetter" font-size="5">
														<xsl:choose>
															<xsl:when test="$totalSemanas[@numero=$offset]">
																<xsl:value-of select="$totalSemanas[@numero=$offset]/valor"/>
															</xsl:when>
															<xsl:otherwise/>
														</xsl:choose>
													</fo:inline>
												</fo:block>
											</fo:table-cell>
										</xsl:for-each>
										<!--</xsl:for-each>-->
									</fo:table-row>
									<fo:table-row>
										<fo:table-cell padding="0.0pt" padding-left="1mm">
											<fo:block xsl:use-attribute-sets="LeftCell">
												<fo:inline xsl:use-attribute-sets="CellLetter">&#160;</fo:inline>
											</fo:block>
										</fo:table-cell>
									</fo:table-row>
								</fo:table-body>
							</fo:table>
							<fo:block text-align="left" break-after="page">
							</fo:block>
						</xsl:for-each>
					</xsl:if>
				</fo:flow>
			</fo:page-sequence>
		</fo:root>
	</xsl:template>
</xsl:stylesheet>
