package com.ejie.aa20b.control;

import com.ejie.aa20b.service.ZonasService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.model.Zonas;

/**
 * ZonasController generated by UDA, 28-nov-2014 11:32:27.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/zonas")
public class ZonasController {

	private static final Logger logger = LoggerFactory
			.getLogger(ZonasController.class);

	@Autowired
	private ZonasService zonasService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ZonasController.logger.info("[GET - View] : zonas");
		return "zonas";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idzona
	 *            Integer
	 * @param czona
	 *            String
	 * @param ezona
	 *            String
	 * @param baja
	 *            String
	 * @param feini
	 *            Date
	 * @return zonas Zonas
	 */
	@RequestMapping(value = "/{idzona}/{czona}/{ezona}/{baja}/{feini}", method = RequestMethod.GET)
	public @ResponseBody
	Zonas getById(@PathVariable Integer idzona, @PathVariable String czona,
			@PathVariable String ezona, @PathVariable String baja,
			@PathVariable Date feini) {
		Zonas zonas = new Zonas();
		zonas.setIdzona(idzona);
		zonas.setCzona(czona);
		zonas.setEzona(ezona);
		zonas.setBaja(baja);
		zonas.setFeini(feini);
		zonas = this.zonasService.find(zonas);
		ZonasController.logger.info("[GET - findBy_PK] : Obtener Zonas por PK");
		return zonas;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterZonas
	 *            Zonas
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Zonas> getAll(@ModelAttribute Zonas filterZonas) {
		ZonasController.logger
				.info("[GET - find_ALL] : Obtener Zonas por filtro");
		return this.zonasService.findAll(filterZonas, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Zonas
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Zonas edit(@RequestBody Zonas zonas) {
		Zonas zonasAux = this.zonasService.update(zonas);
		ZonasController.logger.info("[PUT] : Zonas actualizado correctamente");
		return zonasAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param zonas
	 *            Zonas
	 * @return Zonas
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Zonas add(@RequestBody Zonas zonas) {
		Zonas zonasAux = this.zonasService.add(zonas);
		ZonasController.logger.info("[POST] : Zonas insertado correctamente");
		return zonasAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idzona
	 *            Integer
	 * @param czona
	 *            String
	 * @param ezona
	 *            String
	 * @param baja
	 *            String
	 * @param feini
	 *            Date
	 * @return zonas
	 */
	@RequestMapping(value = "/{idzona}/{czona}/{ezona}/{baja}/{feini}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Zonas remove(@PathVariable Integer idzona, @PathVariable String czona,
			@PathVariable String ezona, @PathVariable String baja,
			@PathVariable Date feini) {
		Zonas zonas = new Zonas();
		zonas.setIdzona(idzona);
		zonas.setCzona(czona);
		zonas.setEzona(ezona);
		zonas.setBaja(baja);
		zonas.setFeini(feini);
		this.zonasService.remove(zonas);
		ZonasController.logger.info("[DELETE] : Zonas borrado correctamente");
		return zonas;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param zonasIds
	 *            List
	 * @return zonasList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> zonasIds) {
		List<Zonas> zonasList = new ArrayList<Zonas>();
		for (List<String> zonasId : zonasIds) {
			Iterator<String> iterator = zonasId.iterator();
			Zonas zonas = new Zonas(); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			zonas.setIdzona(ObjectConversionManager.convert(iterator.next(),
					java.lang.Integer.class));
			zonas.setCzona(ObjectConversionManager.convert(iterator.next(),
					String.class));
			zonas.setEzona(ObjectConversionManager.convert(iterator.next(),
					String.class));
			zonas.setBaja(ObjectConversionManager.convert(iterator.next(),
					String.class));
			zonas.setFeini(ObjectConversionManager.convert(iterator.next(),
					java.util.Date.class));
			zonasList.add(zonas);
		}
		this.zonasService.removeMultiple(zonasList);
		ZonasController.logger
				.info("[POST - DELETE_ALL] : Zonas borrados correctamente");
		return zonasIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterZonas
	 *            Zonas
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Zonas filterZonas,
			@ModelAttribute Pagination pagination) {
		List<Zonas> zonass = this.zonasService.findAllLike(filterZonas,
				pagination, false);
		Long recordNum = this.zonasService.findAllLikeCount(filterZonas, false);
		ZonasController.logger.info("[GET - jqGrid] : Obtener Zonas");
		return new JQGridJSONModel(pagination, recordNum, zonass);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idzona
	 *            Integer
	 * @return zona Zonas
	 */
	@RequestMapping(value = "/{idzona}", method = RequestMethod.GET)
	public @ResponseBody
	Zonas getById(@PathVariable Integer idzona) {
		Zonas zona = new Zonas();
		zona.setIdzona(idzona);
		zona = this.zonasService.find(zona);
		ZonasController.logger.info("[GET - findBy_PK] : Obtener Zonas por PK");
		return zona;
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/modificar", method = RequestMethod.GET)
	public String getCreateFormModficar(Model model, HttpServletRequest request) {
		ZonasController.logger.info("[GET - View] : modificar zona");

		Integer idZona = Integer.parseInt(request.getParameter("idZona"));

		ZonasController.logger.info("[GET - View] : modificar Zonas : zona: "
				+ idZona);

		Zonas zona = this.getById(idZona);

		ZonasController.logger.info("[GET - View] : modificar zona : "
				+ zona.toString());

		/*
		 * ZonasIncidenciasController.logger
		 * .info("[zona INCIDENCIA EN MODIFICAR : " +
		 * zonaIncidencia.getCodZonas());
		 */
		model.addAttribute("Zona", zona);

		request.setAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		return "editarZona";
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param zona
	 *            Zonas
	 * @return Zonas
	 */
	@RequestMapping(value = "/modificaZona", method = RequestMethod.POST)
	public @ResponseBody
	Zonas modificaZonas(@RequestBody Zonas zona) {

		ZonasController.logger.info("[POST] : MODIFY : Valor de Baja : "
				+ zona.getBaja());

		if (zona.getBaja() == null)
			zona.setBaja("0");
		else
			zona.setBaja("1");

		ZonasController.logger.info("[PUT] : Zonas antes de modificar : "
				+ zona.toString());
		Zonas zonaAux = this.zonasService.update(zona);
		ZonasController.logger.info("[PUT] : Zonas actualizado correctamente");
		return zonaAux;

	}

	@RequestMapping(value = "/addNuevaZona", method = RequestMethod.POST)
	public @ResponseBody
	Zonas addNuevaZonas(@RequestBody Zonas zona, Model model) {

		ZonasController.logger.info("[POST] : ENTRAMOS EN ADD zona");

		ZonasController.logger.info("[POST] : ADD : zona : " + zona.toString());
		Zonas zonaAux = this.zonasService.add(zona);
		ZonasController.logger.info("[POST] : zona insertado correctamente");

		return zonaAux;
	}

	/**
	 * Method 'getCreateForm2'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "nuevo", method = RequestMethod.GET)
	public String getCreateForm2(Model model, HttpServletRequest request) {
		ZonasController.logger.info("[GET - View] : nuevaZona");
		model.addAttribute("accion", Aa20bConstantes.ACCION_NUEVO);

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);
		return "editarZona";
	}

	/**
	 * Method 'zonasEdifConPlanos'. Obtiene las zonas asociadas a un edificio.
	 * 
	 * @param codEdif
	 *            String
	 * 
	 * @return List
	 */
	@RequestMapping(value = "zonasEdifConPlanos/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Zonas> zonasEdifConPlanos(
			@RequestParam(value = "comboEdificios", required = false) String codEdif) {
		ZonasController.logger.info("[GET - View] : zonasEdifConPlanos");

		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		return this.zonasService.obtenerZonasEdifConPlanos(codEdif);
	}

}
