package com.ejie.aa20b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.model.Presencia;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Usutecnicos;
import com.ejie.aa20b.service.PresenciaService;
import com.ejie.aa20b.service.UsutecnicosService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;

/**
 * UsutecnicosController generated by UDA, 11-mar-2015 9:15:04.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/usutecnicos")
public class UsutecnicosController {

	private static final Logger logger = LoggerFactory
			.getLogger(UsutecnicosController.class);

	@Autowired
	private UsutecnicosService usutecnicosService;

	@Autowired
	private PresenciaService presenciaService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		UsutecnicosController.logger.info("[GET - View] : usutecnicos");
		return "usutecnicos";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param uidPer
	 *            String
	 * @param idtecnico
	 *            Long
	 * @return usutecnicos Usutecnicos
	 */
	@RequestMapping(value = "/{uidPer}/{idtecnico}", method = RequestMethod.GET)
	public @ResponseBody
	Usutecnicos getById(@PathVariable String uidPer,
			@PathVariable Long idtecnico) {
		Usutecnicos usutecnicos = new Usutecnicos();
		usutecnicos.setUidPer(uidPer);
		usutecnicos.setIdtecnico(idtecnico);
		usutecnicos = this.usutecnicosService.find(usutecnicos);
		UsutecnicosController.logger
				.info("[GET - findBy_PK] : Obtener Usutecnicos por PK");
		return usutecnicos;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterUsutecnicos
	 *            Usutecnicos
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Usutecnicos> getAll(@ModelAttribute Usutecnicos filterUsutecnicos) {
		UsutecnicosController.logger
				.info("[GET - find_ALL] : Obtener Usutecnicos por filtro");
		return this.usutecnicosService.findAll(filterUsutecnicos, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Usutecnicos
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Usutecnicos edit(@RequestBody Usutecnicos usutecnicos) {
		Usutecnicos usutecnicosAux = this.usutecnicosService
				.update(usutecnicos);
		UsutecnicosController.logger
				.info("[PUT] : Usutecnicos actualizado correctamente");
		return usutecnicosAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param usutecnicos
	 *            Usutecnicos
	 * @return Usutecnicos
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Usutecnicos add(@RequestBody Usutecnicos usutecnicos) {
		Usutecnicos usutecnicosAux = this.usutecnicosService.add(usutecnicos);
		UsutecnicosController.logger
				.info("[POST] : Usutecnicos insertado correctamente");
		return usutecnicosAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param uidPer
	 *            String
	 * @param idtecnico
	 *            Long
	 * @return usutecnicos
	 */
	@RequestMapping(value = "/{uidPer}/{idtecnico}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Usutecnicos remove(@PathVariable String uidPer, @PathVariable Long idtecnico) {
		Usutecnicos usutecnicos = new Usutecnicos();
		usutecnicos.setUidPer(uidPer);
		usutecnicos.setIdtecnico(idtecnico);
		this.usutecnicosService.remove(usutecnicos);
		UsutecnicosController.logger
				.info("[DELETE] : Usutecnicos borrado correctamente");
		return usutecnicos;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param usutecnicosIds
	 *            List
	 * @return usutecnicosList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> usutecnicosIds) {
		List<Usutecnicos> usutecnicosList = new ArrayList<Usutecnicos>();
		for (List<String> usutecnicosId : usutecnicosIds) {
			Iterator<String> iterator = usutecnicosId.iterator();
			Usutecnicos usutecnicos = new Usutecnicos(); // NOPMD - Objeto nuevo
															// en la lista
															// (parametro del
															// servicio)
			usutecnicos.setUidPer(ObjectConversionManager.convert(
					iterator.next(), String.class));
			usutecnicos.setIdtecnico(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			usutecnicosList.add(usutecnicos);
		}
		this.usutecnicosService.removeMultiple(usutecnicosList);
		UsutecnicosController.logger
				.info("[POST - DELETE_ALL] : Usutecnicos borrados correctamente");
		return usutecnicosIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterUsutecnicos
	 *            Usutecnicos
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Usutecnicos filterUsutecnicos,
			@ModelAttribute Pagination pagination) {
		List<Usutecnicos> usutecnicoss = this.usutecnicosService.findAllLike(
				filterUsutecnicos, pagination, false);
		Long recordNum = this.usutecnicosService.findAllLikeCount(
				filterUsutecnicos, false);
		UsutecnicosController.logger
				.info("[GET - jqGrid] : Obtener Usutecnicos");
		return new JQGridJSONModel(pagination, recordNum, usutecnicoss);
	}

	/**
	 * Method 'obtenerTecnicosUsuarioAsignados'.
	 * 
	 * @param idUsuario
	 *            Integer
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosUsuarioAsignados", method = RequestMethod.POST)
	public @ResponseBody
	List<Usutecnicos> obtenerTecnicosUsuarioAsignados(String idUsuario) {
		UsutecnicosController.logger
				.info("[GET - obtenerTecnicosParteAsignados] : Obtener Tecnicos asignados al usuario");
		List<Usutecnicos> listaTecnicos = this.usutecnicosService
				.obtenerTecnicosUsuarioAsignados(idUsuario);

		List<Usutecnicos> listaTecnicosPresentes = new ArrayList<Usutecnicos>();
		for (Usutecnicos usutec : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(usutec.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				usutec.setPresente(true);
				listaTecnicosPresentes.add(usutec);
			} else {
				usutec.setPresente(false);
				listaTecnicosPresentes.add(usutec);
			}
		}

		return listaTecnicosPresentes;
	}

	/**
	 * Method 'obtenerTecnicosUsuarioLibres'.
	 * 
	 * @param idUsuario
	 *            Integer
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosUsuarioLibres", method = RequestMethod.POST)
	public @ResponseBody
	List<Usutecnicos> obtenerTecnicosUsuarioLibres(String idUsuario,
			Integer idServicio) {

		// Tecnicos que esten libres que pertenezcan a Edificios del Usuario y
		// al mismo Servicio
		// Primero se obtienen los edificios asociados al Usuario
		// Y luego los tecnicos asociados a esos edificios

		UsutecnicosController.logger
				.info("[GET - obtenerTecnicosUsuarioLibres] : Obtener Tecnicos no asignados al usuario");
		List<Usutecnicos> listaTecnicos = this.usutecnicosService
				.obtenerTecnicosUsuarioLibres(idUsuario, idServicio);

		List<Usutecnicos> listaTecnicosPresentes = new ArrayList<Usutecnicos>();
		for (Usutecnicos usutec : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(usutec.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				usutec.setPresente(true);
				listaTecnicosPresentes.add(usutec);
			} else {
				usutec.setPresente(false);
				listaTecnicosPresentes.add(usutec);
			}
		}

		return listaTecnicosPresentes;
	}

	@RequestMapping(value = "/sumaTecnicos", method = RequestMethod.POST)
	public @ResponseBody
	Usutecnicos sumaTecnicos(@RequestParam String idUsuario,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Usutecnicos usutecnicosAux = new Usutecnicos();
		Usutecnicos elUsutecnicos = new Usutecnicos();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elUsutecnicos.setUidPer(idUsuario);
			elUsutecnicos.setIdtecnico(tecnicosSeleccionados.get(i));
			UsutecnicosController.logger
					.info("[GET - findBy_PK] : Grabando tecnicos usuario : "
							+ elUsutecnicos.getIdtecnico());

			usutecnicosAux = this.usutecnicosService.add(elUsutecnicos);
		}

		UsutecnicosController.logger.info("[GET - SUMA TECNICOS] : TECNICOS: "
				+ tecnicosSeleccionados.size());

		return usutecnicosAux;
	}

	@RequestMapping(value = "/restaTecnicos", method = RequestMethod.POST)
	public @ResponseBody
	Usutecnicos restaEdificios(@RequestParam String idUsuario,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Usutecnicos UsutecnicosAux = new Usutecnicos();
		Usutecnicos elUsutecnicos = new Usutecnicos();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elUsutecnicos.setUidPer(idUsuario);
			elUsutecnicos.setIdtecnico(tecnicosSeleccionados.get(i));

			/* execute */
			this.usutecnicosService.remove(elUsutecnicos);
		}

		UsutecnicosController.logger.info("[GET - RESTA TECNICOS] : TECNICOS: "
				+ tecnicosSeleccionados.size());

		return UsutecnicosAux;
	}

	@RequestMapping(value = "/restaTodosTecnicos", method = RequestMethod.POST)
	public @ResponseBody
	Usutecnicos restaTodosTecnicos(@RequestParam String idUsuario, Model model,
			HttpServletRequest request) {

		Usutecnicos usutecnicos = new Usutecnicos();
		usutecnicos.setUidPer(idUsuario);

		/* execute */
		this.usutecnicosService.restaTodosTecnicosUsu(usutecnicos);

		UsutecnicosController.logger
				.info("[GET - RESTA TECNICOS] : TECNICOS: ");

		return usutecnicos;
	}

	/**
	 * Method 'comprobarTecnicosEdificio'.
	 * 
	 * @param idUsuario
	 *            Integer
	 * @param edificiosSeleccionados
	 *            ArrayList<String>
	 * 
	 * @return List
	 */
	@RequestMapping(value = "comprobarTecnicosEdificio", method = RequestMethod.POST)
	public @ResponseBody
	List<Usutecnicos> comprobarTecnicosEdificio(String idUsuario,
			@RequestParam ArrayList<String> edificiosSeleccionados,
			@RequestParam ArrayList<String> edificiosNOSeleccionados) {

		// Obtiene tecnicos asociados al usuario que pertenecen al edificio que
		// se
		// va a desasociar Y que no están en los edificios que todavía mantiene

		UsutecnicosController.logger
				.info("[GET - comprobarTecnicosEdificio] : obtener tecnicos asociados a los edificios a desasignar y que no están en los edificios que mantiene el usuario");
		List<Usutecnicos> listaTecnicos = this.usutecnicosService
				.comprobarTecnicosEdificio(idUsuario, edificiosSeleccionados,
						edificiosNOSeleccionados);

		return listaTecnicos;
	}

	/**
	 * Method 'getComboServiciosResponsables'.
	 * 
	 * @return List<Aa21b13s01>
	 */
	@RequestMapping(value = "/comboTecnicosUsuario", method = RequestMethod.GET)
	public @ResponseBody
	List<Tecnicos> getComboTecnicosUsuario(@RequestParam String idUsuario) {
		List<Tecnicos> tecnicosUsuario = new ArrayList<Tecnicos>();

		List<Usutecnicos> listaTecnicos = this.usutecnicosService
				.obtenerTecnicosUsuarioAsignados(idUsuario);

		for (Usutecnicos usutec : listaTecnicos) {
			Tecnicos tecnicoAux = new Tecnicos();
			tecnicoAux.setIdtecnico(usutec.getIdtecnico());
			tecnicoAux.setNombre(usutec.getTecnico().getNombre());
			tecnicosUsuario.add(tecnicoAux);
		}
		return tecnicosUsuario;
	}

}
