package com.ejie.aa20b.control;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.RolesMovil;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.UsuariosMovil;
import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.RolesMovilService;
import com.ejie.aa20b.service.TecnicosService;
import com.ejie.aa20b.service.UsuariosMovilService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.json.JSONArray;
import com.ejie.x38.json.JSONObject;

/**
 * UsuariosRolesMovilController
 * 
 * @author VDIAZSAN
 */

@Controller
@RequestMapping(value = "/usuariosRolesMovil")
public class UsuariosRolesMovilController {

	private static final Logger logger = LoggerFactory
			.getLogger(UsuariosRolesMovilController.class);

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private UsuariosMovilService usuariosMovilService;

	@Autowired
	private RolesMovilService rolesMovilService;

	@Autowired
	private Aa20bProcesosJMSService procesosJMSService;

	@Autowired
	private TecnicosService tecnicosService;

	/**
	 * Method 'getMaintGestionUsuarios'
	 * 
	 * @param model
	 * @return String
	 */
	@RequestMapping(value = "maintGestionUsuarios", method = RequestMethod.GET)
	public String getMaintGestionUsuarios(Model model) {
		UsuariosRolesMovilController.logger
				.info("[GET - View]: procesosGmao - Gestión usuarios");

		this.sincronizarDatosUsuariosRolesTablas();

		return "gestionUsuariosMovil";
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterUsuarios
	 *            Usuarios
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridUsuariosMovil", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute UsuariosMovil filterUsuariosMovil, Locale locale,
			@ModelAttribute Pagination pagination, HttpServletRequest request) {
		List<UsuariosMovil> usuariosMovil = this.usuariosMovilService
				.findAllLike(filterUsuariosMovil, pagination, false);
		Long recordNum = this.usuariosMovilService.findAllLikeCount(
				filterUsuariosMovil, false);
		UsuariosRolesMovilController.logger
				.info("[GET - jqGrid] : Obtener Usuarios móvil");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterUsuariosMovil.getFechaUltimaSincD() != null) {
			try {
				filterUsuariosMovil.setStrFechaUltimaSincD(Aa20bFecha
						.getFechaFormateada(
								filterUsuariosMovil.getFechaUltimaSincD(),
								locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (filterUsuariosMovil.getFechaUltimaSincH() != null) {
			try {
				filterUsuariosMovil.setStrFechaUltimaSincH(Aa20bFecha
						.getFechaFormateada(
								filterUsuariosMovil.getFechaUltimaSincH(),
								locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		request.getSession()
				.setAttribute("FiltroUsuarios", filterUsuariosMovil);

		return new JQGridJSONModel(pagination, recordNum, usuariosMovil);
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterUsuariosMovil
	 *            UsuariosMovil
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<UsuariosMovil> getAll(@ModelAttribute UsuariosMovil filterUsuariosMovil) {
		UsuariosRolesMovilController.logger
				.info("[GET - find_ALL] : Obtener Usuarios móvil por filtro");
		return this.usuariosMovilService.findAll(filterUsuariosMovil, null);
	}

	@RequestMapping(value = "/buscarUsuarioMovil", method = RequestMethod.POST)
	public String getById(@RequestParam String idUsuarioMovilBusc,
			@RequestParam String ventanaOrigen, Model model,
			HttpServletRequest request) {

		UsuariosRolesMovilController.logger.info("[GET - findBy_PK] : Usuario");

		UsuariosMovil usuarioMovil = new UsuariosMovil();

		usuarioMovil.setIdUsuarioMovil(Integer.valueOf(idUsuarioMovilBusc));
		usuarioMovil = this.usuariosMovilService.find(usuarioMovil);

		UsuariosRolesMovilController.logger
				.info("[GET - findBy_PK] : Usuario móvil: "
						+ usuarioMovil.toString());

		model.addAttribute("UsuarioMovil", usuarioMovil);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		return "editarUsuarioMovil";
	}

	@RequestMapping(value = "nuevoUsuarioMovil", method = RequestMethod.GET)
	public String getNuevoUsuarioMovil(Model model, HttpServletRequest request) {
		UsuariosRolesMovilController.logger
				.info("[GET - View] : nuevoUsuarioMovil");
		model.addAttribute("accion", Aa20bConstantes.ACCION_NUEVO);

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);
		model.addAttribute("ventanaOrigen", "mantUsuariosMovil");
		return "editarUsuarioMovil";
	}

	@RequestMapping(value = "maintVolver", method = RequestMethod.GET)
	public String maintVolver(Model model, HttpServletRequest request) {
		UsuariosRolesMovilController.logger
				.info("[GET - View] : usuarios móvil");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		UsuariosMovil usuarioMovilFiltro = (UsuariosMovil) request.getSession()
				.getAttribute("FiltroUsuariosMovil");

		model.addAttribute("FiltroUsuariosMovil", usuarioMovilFiltro);

		return "gestionUsuariosMovil";
	}

	@RequestMapping(value = "/comprobarExistenciaUsuarioMovil", method = RequestMethod.POST)
	public @ResponseBody
	boolean comprobarExistenciaUsuarioMovil(@RequestParam String loginUsuario,
			Model model, HttpServletRequest request) {

		boolean existeUsuario = false;
		UsuariosRolesMovilController.logger
				.info("[POST] : ENTRAMOS EN comprobar existencia usuario móvil");

		UsuariosRolesMovilController.logger
				.info("[POST] : ADD : usuario login: " + loginUsuario);

		UsuariosMovil usuarioMovilAux = new UsuariosMovil();
		usuarioMovilAux.setLogin(loginUsuario);
		usuarioMovilAux = this.usuariosMovilService
				.findByLogin(usuarioMovilAux);
		if (usuarioMovilAux != null
				&& usuarioMovilAux.getIdUsuarioMovil() != null) {
			existeUsuario = true;
		}

		return existeUsuario;
	}

	@RequestMapping(value = "/addNuevoUsuarioMovil", method = RequestMethod.POST)
	public @ResponseBody
	UsuariosMovil addNuevoUsuarioMovil(@RequestBody UsuariosMovil usuarioMovil,
			Model model) throws SecurityHelpperException {

		/**
		 * Creamos el usuario en MovilGmao
		 */
		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject usuario = new JSONObject();
		usuario.put("login", usuarioMovil.getLogin());
		usuario.put("pass", usuarioMovil.getPasswordHash());
		usuario.put("rol", usuarioMovil.getRol());
		usuario.put("CodOperario", usuarioMovil.getIdTecnico());

		String url = urlConfig + Aa20bConstantes.URL_NUEVO_USUARIO;
		String respuesta = this.procesosJMSService
				.sincronizarGmao(usuario, url);

		UsuariosRolesMovilController.logger
				.info("[POST] : ENTRAMOS EN ADD usuario móvil");

		UsuariosRolesMovilController.logger
				.info("[POST] : ADD : usuario móvil: "
						+ usuarioMovil.toString());

		/*
		 * UsuariosMovil usuarioMovilAux = this.usuariosMovilService
		 * .add(usuarioMovil);
		 */
		UsuariosRolesMovilController.logger
				.info("[POST] : usuario insertado correctamente");

		return usuarioMovil;
	}

	@RequestMapping(value = "/modificaPassUsuarioMovil", method = RequestMethod.POST)
	public @ResponseBody
	UsuariosMovil modificaPassUsuarioMovil(
			@RequestBody UsuariosMovil usuarioMovil)
			throws SecurityHelpperException {

		/**
		 * Cambiamos la pass del usuario de movil gmao
		 */
		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject usuario = new JSONObject();
		usuario.put("login", usuarioMovil.getLogin());
		usuario.put("pass", usuarioMovil.getPasswordHash());

		String url = urlConfig + Aa20bConstantes.URL_CAMBIAR_PASS_USUARIO;
		String respuesta = this.procesosJMSService
				.sincronizarGmao(usuario, url);

		UsuariosRolesMovilController.logger
				.info("[PUT] : Usuario movil cambiado pass correctamente");
		return usuarioMovil;

	}

	@RequestMapping(value = "/eliminaUsuarioMovil", method = RequestMethod.POST)
	public @ResponseBody
	UsuariosMovil eliminaUsuarioMovil(@RequestBody UsuariosMovil usuarioMovil)
			throws SecurityHelpperException {

		/**
		 * Eliminamos el usuario de movil gmao
		 */
		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject usuario = new JSONObject();
		usuario.put("login", usuarioMovil.getLogin());

		String url = urlConfig + Aa20bConstantes.URL_BORRAR_USUARIO;
		String respuesta = this.procesosJMSService
				.sincronizarGmao(usuario, url);

		if (respuesta.equals("OK")) {
			// Una vez eliminado, lo eliminamos de nuestra BBDD
			UsuariosRolesMovilController.logger
					.info("[PUT] : Usuario móvil antes de eliminar : "
							+ usuarioMovil.toString());
			this.usuariosMovilService.remove(usuarioMovil);
		}
		UsuariosRolesMovilController.logger
				.info("[PUT] : Usuario movil eliminado correctamente");
		return usuarioMovil;

	}

	@RequestMapping(value = "/desloguearUsuarioMovil", method = RequestMethod.POST)
	public @ResponseBody
	String desloguearUsuarioMovil(@RequestParam String loginUsuario) {

		/**
		 * Deslogueamos el usuario de movil gmao
		 */
		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject usuario = new JSONObject();
		usuario.put("login", loginUsuario);

		String url = urlConfig + Aa20bConstantes.URL_DESVINCULAR_USUARIO;
		String respuesta = this.procesosJMSService
				.sincronizarGmao(usuario, url);

		if (respuesta != null
				&& (respuesta.equals("OK") || respuesta.equals(""))) {
			this.sincronizarDatosUsuariosRolesTablas();
		}

		return respuesta;
	}

	@RequestMapping(value = "obtenerRoles", method = RequestMethod.POST)
	public @ResponseBody
	List<RolesMovil> obtenerRoles(@ModelAttribute RolesMovil filterRolMovil) {
		UsuariosRolesMovilController.logger
				.info("[GET - obtenerRoles] : Obtener Roles ");
		return this.rolesMovilService.findAll(filterRolMovil, null);
	}

	@RequestMapping(value = "obtenerTecnicos", method = RequestMethod.POST)
	public @ResponseBody
	List<Tecnicos> obtenerTecnicos(@ModelAttribute Tecnicos filterTecnicos) {
		UsuariosRolesMovilController.logger
				.info("[GET - obtenerTecnicos] : Obtener Técnicos ");
		filterTecnicos.setBaja("0");
		filterTecnicos.setMovilgmao("1");

		/**
		 * Comprobamos que no esté ya creado ese técnico en otro usuario
		 */
		List<Tecnicos> tecnicosAux = this.tecnicosService.findAll(
				filterTecnicos, null);

		List<Tecnicos> tecnicosAuxNoAsignados = new ArrayList<Tecnicos>();
		for (Tecnicos tecnicoAux : tecnicosAux) {
			UsuariosMovil usuMovilAux = new UsuariosMovil();
			usuMovilAux.setIdTecnico(tecnicoAux.getIdtecnico().toString());
			if (this.usuariosMovilService.findAll(usuMovilAux, null).size() == 0) {
				tecnicosAuxNoAsignados.add(tecnicoAux);
			}
		}

		return tecnicosAuxNoAsignados;
	}

	private void sincronizarDatosUsuariosRolesTablas() {

		String respuestaJSON = "";
		/**
		 * Obtenemos la información de los usuarios y actualizamos nuestra tabla
		 * de BBDD
		 */
		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}
		respuestaJSON = this.procesosJMSService.sincronizarGmaoGET(urlConfig
				+ Aa20bConstantes.URL_BAJAR_USUARIOS);

		if (respuestaJSON != null && !respuestaJSON.equals("")) {
			JSONArray resp = new JSONArray(respuestaJSON);

			if (resp.length() > 0) {
				for (int i = 0; i < resp.length(); i++) {
					UsuariosMovil usuarioModel = new UsuariosMovil();
					JSONObject usuarioMovil = resp.getJSONObject(i);
					if (usuarioMovil.get("Login") != JSONObject.NULL) {
						usuarioModel.setLogin(usuarioMovil.getString("Login"));
					}
					boolean existe = false;
					if (usuarioModel.getLogin() != null
							&& !usuarioModel.getLogin().equals("")) {
						UsuariosMovil usuMovilAux = new UsuariosMovil();
						usuMovilAux = this.usuariosMovilService
								.findByLogin(usuarioModel);
						if (usuMovilAux != null) {
							existe = true;
							usuarioModel.setIdUsuarioMovil(usuMovilAux
									.getIdUsuarioMovil());
						}
					}
					if (usuarioMovil.get("IDRol") != JSONObject.NULL) {
						usuarioModel.setRol(usuarioMovil.getString("IDRol"));
					}
					if (usuarioMovil.get("NombreBD") != JSONObject.NULL) {
						usuarioModel.setNombreBD(usuarioMovil
								.getString("NombreBD"));
					}
					if (usuarioMovil.get("PasswordHash") != JSONObject.NULL) {
						usuarioModel.setPasswordHash(usuarioMovil
								.getString("PasswordHash"));
					}
					if (usuarioMovil.get("IMEI") != JSONObject.NULL) {
						usuarioModel.setImei(usuarioMovil.getString("IMEI"));
					}
					if (usuarioMovil.get("CodOperario") != JSONObject.NULL) {
						usuarioModel.setIdTecnico(usuarioMovil
								.getString("CodOperario"));
					}
					if (usuarioMovil.get("UltimaFechaSinc") != JSONObject.NULL) {
						String fechaStr = usuarioMovil
								.getString("UltimaFechaSinc");
						SimpleDateFormat sdf = new SimpleDateFormat(
								"yyyy-MM-dd HH:mm:ss");
						Date ultimaFechaSinc = new Date();
						try {
							ultimaFechaSinc = sdf.parse(fechaStr);
							usuarioModel.setFechaUltimaSinc(ultimaFechaSinc);
						} catch (ParseException e) {
							UsuariosRolesMovilController.logger
									.error("[MOVILGMAO] : formatear fecha ultima sinc usuario maintGestionUsuarios: "
											+ e.getMessage());
						}
					}
					if (usuarioMovil.get("IdIdioma") != JSONObject.NULL) {
						usuarioModel.setIdIdioma(usuarioMovil
								.getString("IdIdioma"));
					}
					if (usuarioMovil.get("email") != JSONObject.NULL) {
						usuarioModel.setEmail(usuarioMovil.getString("email"));
					}
					if (usuarioMovil.get("VersionAplicacion") != JSONObject.NULL) {
						usuarioModel.setVersionApp(usuarioMovil
								.getString("VersionAplicacion"));
					}
					if (usuarioMovil.get("DeviceName") != JSONObject.NULL) {
						usuarioModel.setDeviceName(usuarioMovil
								.getString("DeviceName"));
					}
					if (usuarioMovil.get("DeviceVersion") != JSONObject.NULL) {
						usuarioModel.setDeviceVersion(usuarioMovil
								.getString("DeviceVersion"));
					}
					if (usuarioMovil.get("DevicePlatform") != JSONObject.NULL) {
						usuarioModel.setDevicePlatform(usuarioMovil
								.getString("DevicePlatform"));
					}

					if (existe) {
						/**
						 * Actualizamos los datos
						 */
						this.usuariosMovilService.update(usuarioModel);
					} else {
						/**
						 * Insertamos el usuario nuevo
						 */
						this.usuariosMovilService.add(usuarioModel);
					}
				}
			}
		}

		/**
		 * Obtenemos los roles existentes en MovilGmao
		 */
		respuestaJSON = "";
		respuestaJSON = this.procesosJMSService.sincronizarGmaoGET(urlConfig
				+ Aa20bConstantes.URL_BAJAR_ROLES);

		if (respuestaJSON != null && !respuestaJSON.equals("")) {
			JSONArray resp = new JSONArray(respuestaJSON);

			if (resp.length() > 0) {
				for (int i = 0; i < resp.length(); i++) {
					RolesMovil rolModel = new RolesMovil();
					JSONObject rolMovil = resp.getJSONObject(i);
					if (rolMovil.get("IDRol") != JSONObject.NULL) {
						rolModel.setIdRolGmao(rolMovil.getString("IDRol"));
					}
					boolean existe = false;
					if (rolModel.getIdRolGmao() != null
							&& !rolModel.getIdRolGmao().equals("")) {
						RolesMovil rolMovilAux = new RolesMovil();
						rolMovilAux = this.rolesMovilService
								.findByRolGmao(rolModel);
						if (rolMovilAux != null) {
							existe = true;
							rolModel.setIdRol(rolMovilAux.getIdRol());
						}
					}
					if (rolMovil.get("DescRol") != JSONObject.NULL) {
						rolModel.setDescRol(rolMovil.getString("DescRol"));
					}
					if (rolMovil.get("Sistema") != JSONObject.NULL) {
						rolModel.setSistema(rolMovil.getString("Sistema"));
					}

					if (existe) {
						/**
						 * Actualizamos los datos
						 */
						this.rolesMovilService.update(rolModel);
					} else {
						/**
						 * Insertamos el rol nuevo en nuestra tabla
						 */
						this.rolesMovilService.add(rolModel);
					}
				}
			}
		}

	}

}