package com.ejie.aa20b.control;

import com.ejie.aa20b.service.Aa20bUsuarioXLNETService;
import com.ejie.aa20b.service.UsuariosService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.Aa20bUsuarioXLNET;
import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Usuarios;

/**
 * UsuariosController generated by UDA, 10-mar-2015 14:56:21.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/usuarios")
public class UsuariosController {

	private static final Logger logger = LoggerFactory
			.getLogger(UsuariosController.class);

	@Autowired
	private UsuariosService usuariosService;

	@Autowired
	private Aa20bUsuarioXLNETService usuarioXLNETService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		UsuariosController.logger.info("[GET - View] : usuarios");

		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroUsuarios");

		return "usuarios";
	}

	/**
	 * Method 'maintVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintVolver", method = RequestMethod.GET)
	public String maintVolver(Model model, HttpServletRequest request) {
		UsuariosController.logger.info("[GET - View] : usuarios");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Usuarios usuarioFiltro = (Usuarios) request.getSession().getAttribute(
				"FiltroUsuarios");

		model.addAttribute("FiltroUsuario", usuarioFiltro);

		return "usuarios";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param uidPer
	 *            String
	 * @return usuarios Usuarios
	 */
	@RequestMapping(value = "/{uidPer}", method = RequestMethod.GET)
	public @ResponseBody
	Usuarios getById(@PathVariable String uidPer) {
		Usuarios usuarios = new Usuarios();
		usuarios.setUidPer(uidPer);
		usuarios = this.usuariosService.find(usuarios);
		UsuariosController.logger
				.info("[GET - findBy_PK] : Obtener Usuarios por PK");
		return usuarios;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterUsuarios
	 *            Usuarios
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Usuarios> getAll(@ModelAttribute Usuarios filterUsuarios) {
		UsuariosController.logger
				.info("[GET - find_ALL] : Obtener Usuarios por filtro");
		return this.usuariosService.findAll(filterUsuarios, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @return Usuarios
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Usuarios edit(@RequestBody Usuarios usuarios) {
		Usuarios usuariosAux = this.usuariosService.update(usuarios);
		UsuariosController.logger
				.info("[PUT] : Usuarios actualizado correctamente");
		return usuariosAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param usuarios
	 *            Usuarios
	 * @return Usuarios
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Usuarios add(@RequestBody Usuarios usuarios) {
		Usuarios usuariosAux = this.usuariosService.add(usuarios);
		UsuariosController.logger
				.info("[POST] : Usuarios insertado correctamente");
		return usuariosAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param uidPer
	 *            String
	 * @return usuarios
	 */
	@RequestMapping(value = "/{uidPer}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Usuarios remove(@PathVariable String uidPer) {
		Usuarios usuarios = new Usuarios();
		usuarios.setUidPer(uidPer);
		this.usuariosService.remove(usuarios);
		UsuariosController.logger
				.info("[DELETE] : Usuarios borrado correctamente");
		return usuarios;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param usuariosIds
	 *            List
	 * @return usuariosList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> usuariosIds) {
		List<Usuarios> usuariosList = new ArrayList<Usuarios>();
		for (List<String> usuariosId : usuariosIds) {
			Iterator<String> iterator = usuariosId.iterator();
			Usuarios usuarios = new Usuarios(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			usuarios.setUidPer(ObjectConversionManager.convert(iterator.next(),
					String.class));
			usuariosList.add(usuarios);
		}
		this.usuariosService.removeMultiple(usuariosList);
		UsuariosController.logger
				.info("[POST - DELETE_ALL] : Usuarios borrados correctamente");
		return usuariosIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterUsuarios
	 *            Usuarios
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Usuarios filterUsuarios,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {
		List<Usuarios> usuarioss = this.usuariosService.findAllLike(
				filterUsuarios, pagination, false);
		Long recordNum = this.usuariosService.findAllLikeCount(filterUsuarios,
				false);
		UsuariosController.logger.info("[GET - jqGrid] : Obtener Usuarios");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterUsuarios.getFeini() != null) {
			try {
				filterUsuarios.setStrFeini(Aa20bFecha.getFechaFormateada(
						filterUsuarios.getFeini(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroUsuarios", filterUsuarios);

		return new JQGridJSONModel(pagination, recordNum, usuarioss);
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/modificar", method = RequestMethod.GET)
	public String getCreateFormModficar(Model model, HttpServletRequest request) {
		UsuariosController.logger.info("[GET - View] : modificar usuario");

		String idUsuario = request.getParameter("idUsuario");

		UsuariosController.logger
				.info("[GET - View] : modificar Usuario : usuario: "
						+ idUsuario);

		Usuarios usuario = this.getById(idUsuario);

		UsuariosController.logger.info("[GET - View] : modificar usuario : "
				+ usuario.toString());

		/*
		 * UsuarioIncidenciasController.logger
		 * .info("[TIPO INCIDENCIA EN MODIFICAR : " +
		 * usuarioIncidencia.getCodUsuario());
		 */
		model.addAttribute("Usuario", usuario);

		request.setAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		return "editarUsuario";
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param usuario
	 *            Usuario
	 * @return Usuario
	 */
	@RequestMapping(value = "/modificaUsuario", method = RequestMethod.POST)
	public @ResponseBody
	Usuarios modificaUsuario(@RequestBody Usuarios usuario)
			throws SecurityHelpperException {

		UsuariosController.logger.info("[POST] : MODIFY : Valor de Baja : "
				+ usuario.getBaja());

		if (usuario.getBaja() == null)
			usuario.setBaja("0");
		else
			usuario.setBaja("1");

		if (usuario.getResponsable() == null)
			usuario.setResponsable(0);
		else
			usuario.setResponsable(1);

		Aa20bUsuarioXLNET usuarioXLNET = this.usuarioXLNETService
				.obtenerUsuarioIntroducido(null, usuario.getUidPer());

		if (usuarioXLNET != null && usuarioXLNET.getEmail() != null
				&& !usuarioXLNET.getEmail().equals("")) {
			usuario.setEmail(usuarioXLNET.getEmail());
		}

		UsuariosController.logger.info("[PUT] : Usuario antes de modificar : "
				+ usuario.toString());
		Usuarios usuarioAux = this.usuariosService.update(usuario);

		UsuariosController.logger
				.info("[PUT] : Usuario actualizado correctamente");
		return usuarioAux;

	}

	@RequestMapping(value = "/addNuevaUsuario", method = RequestMethod.POST)
	public @ResponseBody
	Usuarios addNuevaUsuario(@RequestBody Usuarios usuario, Model model)
			throws SecurityHelpperException {

		UsuariosController.logger.info("[POST] : ENTRAMOS EN ADD usuario");

		UsuariosController.logger.info("[POST] : ADD : usuario : "
				+ usuario.toString());
		usuario.setBaja("0");

		if (usuario.getUidPer() != null && !usuario.getUidPer().equals("")) {
			Aa20bUsuarioXLNET usuarioXLNET = this.usuarioXLNETService
					.obtenerUsuarioIntroducido(null, usuario.getUidPer());

			if (usuarioXLNET != null && usuarioXLNET.getEmail() != null
					&& !usuarioXLNET.getEmail().equals("")) {
				usuario.setEmail(usuarioXLNET.getEmail());
			}
		}

		Usuarios usuarioAux = this.usuariosService.add(usuario);
		UsuariosController.logger
				.info("[POST] : usuario insertado correctamente");

		return usuarioAux;
	}

	/**
	 * Method 'getCreateForm2'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "nuevo", method = RequestMethod.GET)
	public String getCreateForm2(Model model, HttpServletRequest request) {
		UsuariosController.logger.info("[GET - View] : nuevUsuario");
		model.addAttribute("accion", Aa20bConstantes.ACCION_NUEVO);

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);
		return "editarUsuario";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idUsuarioBusc
	 *            String
	 * @param ventanaOrigen
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return editarUsuario String
	 */
	@RequestMapping(value = "/buscarUsuario", method = RequestMethod.POST)
	public String getById(@RequestParam String idUsuarioBusc,
			@RequestParam String ventanaOrigen, Model model,
			HttpServletRequest request) {

		UsuariosController.logger.info("[GET - findBy_PK] : Usuario");

		Usuarios usuario = new Usuarios();

		usuario.setUidPer(idUsuarioBusc);
		usuario = this.usuariosService.find(usuario);

		UsuariosController.logger.info("[GET - findBy_PK] : Usuario: "
				+ usuario.toString());

		model.addAttribute("Usuario", usuario);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		return "editarUsuario";
	}

	@RequestMapping(value = "obtenerServicioUsuario", method = RequestMethod.POST)
	public @ResponseBody
	Integer obtenerServicioUsuario(HttpServletRequest request)
			throws SecurityHelpperException {

		/*
		 * Esto es por si no queremos acceder a base de datos continuamente para
		 * coger el servicio asociado al usuario Pero el problema está en que de
		 * esa forma cualquier cambio de asociacion de un servicio a un usuario
		 * solo se reflejaría cuando cerrara sesion ese usuario Integer
		 * servicioUsuario = (Integer) request.getSession().getAttribute(
		 * "servicioUsuario");
		 * 
		 * if (servicioUsuario == null) { try {
		 */

		String usuarioXLNET = (String) request.getSession().getAttribute(
				"sUIDUsuario");
		if (usuarioXLNET == null) {
			usuarioXLNET = this.usuarioXLNETService.obtenerUIDUsuario();
			request.getSession().setAttribute("sUIDUsuario", usuarioXLNET);
		}

		Usuarios usuario = new Usuarios();
		usuario.setUidPer(usuarioXLNET);
		usuario = this.usuariosService.find(usuario);

		logger.info("[GET - View] : obtenerServicioUsuario");

		if (usuario != null && usuario.getIdservicio() != null) {
			return usuario.getIdservicio();
		} else {
			return null;
		}
		/*
		 * if (usuario != null && usuario.getIdservicio() != null) {
		 * servicioUsuario = usuario.getIdservicio();
		 * request.getSession().setAttribute("servicioUsuario",
		 * servicioUsuario); }
		 * 
		 * } catch (SecurityHelpperException e) { // TODO Auto-generated catch
		 * block e.printStackTrace(); }
		 */
	}

	@RequestMapping(value = "usuarioTodosServicios", method = RequestMethod.POST)
	public @ResponseBody
	Boolean usuarioTodosServicios(HttpServletRequest request)
			throws SecurityHelpperException {

		logger.info("[GET - View] : usuarioTodosServicios");
		Integer existePuesto = this.obtenerServicioUsuario(request);
		if (existePuesto != null && existePuesto == 0) {
			return true;
		}

		return false;
	}

	@RequestMapping(value = "obtenerClaseUsuario", method = RequestMethod.POST)
	public @ResponseBody
	Clase obtenerClaseUsuario(HttpServletRequest request)
			throws SecurityHelpperException {

		/*
		 * Esto es por si no queremos acceder a base de datos continuamente para
		 * coger el servicio asociado al usuario Pero el problema está en que de
		 * esa forma cualquier cambio de asociacion de un servicio a un usuario
		 * solo se reflejaría cuando cerrara sesion ese usuario Integer
		 * servicioUsuario = (Integer) request.getSession().getAttribute(
		 * "servicioUsuario");
		 * 
		 * if (servicioUsuario == null) { try {
		 */

		String usuarioXLNET = (String) request.getSession().getAttribute(
				"sUIDUsuario");
		if (usuarioXLNET == null) {
			usuarioXLNET = this.usuarioXLNETService.obtenerUIDUsuario();
			request.getSession().setAttribute("sUIDUsuario", usuarioXLNET);
		}

		Usuarios usuario = new Usuarios();
		usuario.setUidPer(usuarioXLNET);
		usuario = this.usuariosService.find(usuario);

		logger.info("[GET - View] : obtenerClaseUsuario");

		if (usuario != null && usuario.getIdClase() != null) {

			return usuario.getClase();
		} else {
			Clase clase = new Clase();
			clase.setIdclase(new Integer(-1));
			return clase;
		}
		/*
		 * if (usuario != null && usuario.getIdservicio() != null) {
		 * servicioUsuario = usuario.getIdservicio();
		 * request.getSession().setAttribute("servicioUsuario",
		 * servicioUsuario); }
		 * 
		 * } catch (SecurityHelpperException e) { // TODO Auto-generated catch
		 * block e.printStackTrace(); }
		 */
	}

	@RequestMapping(value = "obenerClaseUsuario", method = RequestMethod.POST)
	public @ResponseBody
	Clase usuarioTodasClases(HttpServletRequest request)
			throws SecurityHelpperException {

		logger.info("[GET - View] : usuarioTodasClases");
		Clase clase = this.obtenerClaseUsuario(request);
		return clase;
	}
}
