package com.ejie.aa20b.control;

import java.util.Date;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;

import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.Aa20bUsuarioXLNET;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.Zonas;
import com.ejie.aa20b.service.Aa20bUsuarioXLNETService;
import com.ejie.aa20b.service.EdificiosService;
import com.ejie.aa20b.service.PlantasService;
import com.ejie.aa20b.service.ZonasService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.util.DateTimeManager;

/**
 * PersonalController generated by UDA, 08-jul-2013 12:05:23.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/usuarioXLNET")
public class UsuarioXLNETController {

	private static final Logger logger = LoggerFactory
			.getLogger(UsuarioXLNETController.class);

	@Autowired
	private Aa20bUsuarioXLNETService usuarioXLNETService;

	@Autowired
	private PlantasService plantasService;
	@Autowired
	private ZonasService zonasService;
	@Autowired
	private EdificiosService edificiosService;

	@InitBinder
	protected void initBinder(HttpServletRequest request,
			ServletRequestDataBinder binder) throws ServletException {
		binder.registerCustomEditor(byte[].class,
				new ByteArrayMultipartFileEditor());
		binder.registerCustomEditor(
				Date.class,
				new CustomDateEditor(DateTimeManager
						.getDateTimeFormat(LocaleContextHolder.getLocale()),
						true));
	}

	@RequestMapping(value = "obtenerDatosUsuarioXLNET", method = RequestMethod.POST)
	public @ResponseBody
	Aa20bUsuarioXLNET obtenerDatosUsuarioXLNET()
			throws SecurityHelpperException {

		Aa20bUsuarioXLNET usuarioXLNET = this.usuarioXLNETService
				.obtenerDatosUsuarioXLNET();
		if (usuarioXLNET != null) {
			// Si el edificio no está dado de alta en la tabla Edificios (09T00)
			// no podrá dar de alta averías
			if (usuarioXLNET.getCodEdificio() != null) {
				Edificios edificio = this.edificiosService
						.obtenerEdificio(usuarioXLNET.getCodEdificio());
				if (edificio == null) {
					// Devolvemos como codigo de edificio "000000" para que en
					// el fichero .js saque el mensaje de Edificio no válido
					usuarioXLNET.setCodEdificio("000000");
				}
			}

			// Si viene codigo de Planta buscar la descripción en la tabla de
			// Plantas
			if (usuarioXLNET.getCodPlanta() != null
					&& !usuarioXLNET.getCodPlanta().equals("")) {

				Plantas planta = new Plantas();
				// Si el código de planta no es numerico metemos "sin planta"
				try {
					Integer.parseInt(usuarioXLNET.getCodPlanta());

					planta.setCodPlanta(Integer.parseInt(usuarioXLNET
							.getCodPlanta()));

					// planta.setIdplanta(new
					// Integer(usuarioXLNET.getCodPlanta()));
					planta.setIdplanta(this.plantasService
							.obtenerPlantaDesdeXlnets(planta).getIdplanta());
					usuarioXLNET.setCodPlanta(Integer.toString(planta
							.getIdplanta()));
				} catch (NumberFormatException nfe) {
					logger.error("[GET datos XLNETS VIC] : el código de planta no es númerico, se pone sin planta");
					planta.setIdplanta(Aa20bConstantes.SIN_PLANTAS);
				}
				Plantas plantaAux = this.plantasService.obtenerPlanta(planta);

				usuarioXLNET.setPlantaCas(plantaAux.getCplanta());
				usuarioXLNET.setPlantaEus(plantaAux.getEplanta());
			} else {
				/**
				 * BUG producción a veces no se guarda la planta Se mete una
				 * comprobación para que si no se ha obtenido la planta
				 * correctamente volver a buscar
				 */
				logger.error("[GET datos XLNETS VIC] : no viene planta, se vuelve a buscar");
				usuarioXLNET = this.usuarioXLNETService
						.obtenerDatosUsuarioXLNET();
				if (usuarioXLNET != null && usuarioXLNET.getCodPlanta() != null
						&& !usuarioXLNET.getCodPlanta().equals("")) {
					Plantas planta = new Plantas();
					// Si el código de planta no es numerico metemos
					// "sin planta"
					try {
						Integer.parseInt(usuarioXLNET.getCodPlanta());
						planta.setCodPlanta(Integer.parseInt(usuarioXLNET
								.getCodPlanta()));
						/*
						 * planta.setIdplanta(new Integer(usuarioXLNET
						 * .getCodPlanta()));
						 */
						planta.setIdplanta(this.plantasService
								.obtenerPlantaDesdeXlnets(planta).getIdplanta());
						usuarioXLNET.setCodPlanta(Integer.toString(planta
								.getIdplanta()));
					} catch (NumberFormatException nfe) {
						logger.error("[GET datos XLNETS VIC 2º busqueda] : el código de planta no es númerico, se pone sin planta");
						planta.setIdplanta(Aa20bConstantes.SIN_PLANTAS);
						usuarioXLNET.setCodPlanta(Integer
								.toString(Aa20bConstantes.SIN_PLANTAS));
					}
					Plantas plantaAux = this.plantasService
							.obtenerPlanta(planta);

					usuarioXLNET.setPlantaCas(plantaAux.getCplanta());
					usuarioXLNET.setPlantaEus(plantaAux.getEplanta());
				} else {
					logger.error("[GET datos XLNETS VIC] : no viene planta en dos intentos");
					Plantas planta = new Plantas();
					planta.setIdplanta(Aa20bConstantes.SIN_PLANTAS);
					Plantas plantaAux = this.plantasService
							.obtenerPlanta(planta);
					usuarioXLNET.setCodPlanta(Integer
							.toString(Aa20bConstantes.SIN_PLANTAS));
					usuarioXLNET.setPlantaCas(plantaAux.getCplanta());
					usuarioXLNET.setPlantaEus(plantaAux.getEplanta());
				}

			}
			// Si viene codigo de Zona buscar la descripción en la tabla de
			// Zonas
			if (usuarioXLNET.getCodZona() != null
					&& !usuarioXLNET.getCodZona().equals("")) {
				Zonas zona = new Zonas();
				// Si el código de zona no es numerico metemos "sin zona"
				try {
					Integer.parseInt(usuarioXLNET.getCodZona());
					zona.setCodZona(Integer.parseInt(usuarioXLNET.getCodZona()));

					// zona.setIdzona(new Integer(usuarioXLNET.getCodZona()));
					zona.setIdzona(this.zonasService.obtenerZonaDesdeXlnets(
							zona).getIdzona());
					usuarioXLNET.setCodZona(Integer.toString(zona.getIdzona()));
				} catch (NumberFormatException nfe) {
					usuarioXLNET.setCodZona(Integer
							.toString(Aa20bConstantes.SIN_ZONAS));
					zona.setIdzona(Aa20bConstantes.SIN_ZONAS);
				}
				Zonas zonaAux = this.zonasService.obtenerZona(zona);
				usuarioXLNET.setZonaCas(zonaAux.getCzona());
				usuarioXLNET.setZonaEus(zonaAux.getEzona());
			} else {
				Zonas zona = new Zonas();
				zona.setIdzona(Aa20bConstantes.SIN_ZONAS);

				Zonas zonaAux = this.zonasService.obtenerZona(zona);
				usuarioXLNET.setZonaCas(zonaAux.getCzona());
				usuarioXLNET.setZonaEus(zonaAux.getEzona());
				usuarioXLNET.setCodZona(Integer
						.toString(Aa20bConstantes.SIN_ZONAS));
			}
		}
		logger.info("[GET - View] : obtenerDatosUsuarioXLNET");

		return usuarioXLNET;
	}

	@RequestMapping(value = "obtenerUsuarioXLNET", method = RequestMethod.POST)
	public @ResponseBody
	String obtenerUsuarioXLNET(HttpServletRequest request)
			throws SecurityHelpperException {

		String usuarioXLNET = (String) request.getSession().getAttribute(
				"sUIDUsuario");

		if (usuarioXLNET == null) {
			usuarioXLNET = this.usuarioXLNETService.obtenerUIDUsuario();
			request.getSession().setAttribute("sUIDUsuario", usuarioXLNET);
		}

		logger.info("[GET - View] : obtenerUsuarioXLNET");

		return usuarioXLNET;
	}

	@RequestMapping(value = "existePuestoXLNET", method = RequestMethod.POST)
	public @ResponseBody
	Boolean existePuestoXLNET(String puestoIntroducido)
			throws SecurityHelpperException {

		Boolean existePuesto = this.usuarioXLNETService
				.existePuestoXLNET(puestoIntroducido);
		logger.info("[GET - View] : obtenerUsuarioXLNET");

		return existePuesto;
	}

	@RequestMapping(value = "obtenerUsuarioIntroducido", method = RequestMethod.POST)
	public @ResponseBody
	Aa20bUsuarioXLNET obtenerUsuarioIntroducido(String usuarioIntroducido)
			throws SecurityHelpperException {

		Aa20bUsuarioXLNET usuarioXLNET = this.usuarioXLNETService
				.obtenerUsuarioIntroducido(usuarioIntroducido, null);
		if (usuarioXLNET != null) {
			// Si el edificio no está dado de alta en la tabla Edificios (09T00)
			// no podrá dar de alta averías
			if (usuarioXLNET.getCodEdificio() != null) {
				Edificios edificio = this.edificiosService
						.obtenerEdificio(usuarioXLNET.getCodEdificio());
				if (edificio == null) {
					// Devolvemos como codigo de edificio "000000" para que en
					// el fichero .js saque el mensaje de Edificio no válido
					usuarioXLNET.setCodEdificio("000000");
				}
			}

			// Si viene codigo de Planta buscar la descripción en la tabla de
			// Plantas
			if (usuarioXLNET.getCodPlanta() != null
					&& !usuarioXLNET.getCodPlanta().equals("")) {
				Plantas planta = new Plantas();
				// Si el código de planta no es numerico metemos "sin planta"
				try {

					planta.setCodPlanta(new Integer(usuarioXLNET.getCodPlanta()));

					// planta.setIdplanta(new
					// Integer(usuarioXLNET.getCodPlanta()));

					/*
					 * planta = this.plantasService
					 * .obtenerPlantaDesdeXlnets(planta);
					 */
					planta.setIdplanta(this.plantasService
							.obtenerPlantaDesdeXlnets(planta).getIdplanta());
					usuarioXLNET.setCodPlanta(Integer.toString(planta
							.getIdplanta()));
				} catch (NumberFormatException nfe) {
					planta.setIdplanta(Aa20bConstantes.SIN_PLANTAS);
					usuarioXLNET.setCodPlanta(Integer
							.toString(Aa20bConstantes.SIN_PLANTAS));
				}
				Plantas plantaAux = this.plantasService.obtenerPlanta(planta);

				usuarioXLNET.setPlantaCas(plantaAux.getCplanta());
				usuarioXLNET.setPlantaEus(plantaAux.getEplanta());
			} else {
				Plantas planta = new Plantas();
				planta.setIdplanta(Aa20bConstantes.SIN_PLANTAS);
				Plantas plantaAux = this.plantasService.obtenerPlanta(planta);

				usuarioXLNET.setPlantaCas(plantaAux.getCplanta());
				usuarioXLNET.setPlantaEus(plantaAux.getEplanta());
				usuarioXLNET.setCodPlanta(Integer
						.toString(Aa20bConstantes.SIN_PLANTAS));
			}
			// Si viene codigo de Zona buscar la descripción en la tabla de
			// Zonas
			if (usuarioXLNET.getCodZona() != null
					&& !usuarioXLNET.getCodZona().equals("")) {
				Zonas zona = new Zonas();
				// Si el código de zona no es numerico metemos "sin zona"
				try {
					Integer.parseInt(usuarioXLNET.getCodZona());
					zona.setCodZona(new Integer(usuarioXLNET.getCodZona()));
					// zona.setIdzona(new Integer(usuarioXLNET.getCodZona()));
					zona.setIdzona(this.zonasService.obtenerZonaDesdeXlnets(
							zona).getIdzona());
					usuarioXLNET.setCodZona(Integer.toString(zona.getIdzona()));
				} catch (NumberFormatException nfe) {
					zona.setIdzona(Aa20bConstantes.SIN_ZONAS);
					usuarioXLNET.setCodZona(Integer
							.toString(Aa20bConstantes.SIN_ZONAS));
				} catch (Exception e) {
					zona.setIdzona(Aa20bConstantes.SIN_ZONAS);
					usuarioXLNET.setCodZona(Integer
							.toString(Aa20bConstantes.SIN_ZONAS));
				}
				Zonas zonaAux = this.zonasService.obtenerZona(zona);
				usuarioXLNET.setZonaCas(zonaAux.getCzona());
				usuarioXLNET.setZonaEus(zonaAux.getEzona());
			} else {
				Zonas zona = new Zonas();
				zona.setIdzona(Aa20bConstantes.SIN_ZONAS);
				Zonas zonaAux = this.zonasService.obtenerZona(zona);
				usuarioXLNET.setZonaCas(zonaAux.getCzona());
				usuarioXLNET.setZonaEus(zonaAux.getEzona());
				usuarioXLNET.setCodZona(Integer
						.toString(Aa20bConstantes.SIN_ZONAS));
			}
		}

		logger.info("[GET - View] : obtenerUsuarioIntroducido");

		return usuarioXLNET;
	}
}
