package com.ejie.aa20b.control;

import com.ejie.aa20b.service.TipopresenciaService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa20b.model.Tipopresencia;

/**
 * TipopresenciaController generated by UDA, 05-may-2015 13:24:43.
 * @author UDA
 */
 
@Controller
@RequestMapping (value = "/tipopresencia")

public class TipopresenciaController  {

	private static final Logger logger = LoggerFactory.getLogger(TipopresenciaController.class);

	@Autowired
	private TipopresenciaService tipopresenciaService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TipopresenciaController.logger.info("[GET - View] : tipopresencia");
		return "tipopresencia";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param tipopre String
	 * @param ctipopre String
	 * @param etipopre String
	 * @return tipopresencia Tipopresencia
	 */
	@RequestMapping(value = "/{tipopre}/{ctipopre}/{etipopre}", method = RequestMethod.GET)
	public @ResponseBody Tipopresencia getById(@PathVariable String tipopre, @PathVariable String ctipopre, @PathVariable String etipopre) {
        Tipopresencia tipopresencia = new Tipopresencia();
		tipopresencia.setTipopre(tipopre);
		tipopresencia.setCtipopre(ctipopre);
		tipopresencia.setEtipopre(etipopre);
        tipopresencia = this.tipopresenciaService.find(tipopresencia);
        TipopresenciaController.logger.info("[GET - findBy_PK] : Obtener Tipopresencia por PK");
        return tipopresencia;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterTipopresencia Tipopresencia
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Tipopresencia> getAll(@ModelAttribute Tipopresencia filterTipopresencia) {
		TipopresenciaController.logger.info("[GET - find_ALL] : Obtener Tipopresencia por filtro");
	    return this.tipopresenciaService.findAll(filterTipopresencia, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param tipopresencia Tipopresencia 
	 * @return Tipopresencia
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Tipopresencia edit(@RequestBody Tipopresencia tipopresencia) {		
        Tipopresencia tipopresenciaAux = this.tipopresenciaService.update(tipopresencia);
		TipopresenciaController.logger.info("[PUT] : Tipopresencia actualizado correctamente");
        return tipopresenciaAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param tipopresencia Tipopresencia 
	 * @return Tipopresencia
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Tipopresencia add(@RequestBody Tipopresencia tipopresencia) {		
        Tipopresencia tipopresenciaAux = this.tipopresenciaService.add(tipopresencia);
        TipopresenciaController.logger.info("[POST] : Tipopresencia insertado correctamente");
    	return tipopresenciaAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param tipopre String
	 * @param ctipopre String
	 * @param etipopre String
	 * @return tipopresencia
	 */
	@RequestMapping(value = "/{tipopre}/{ctipopre}/{etipopre}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Tipopresencia remove(@PathVariable String tipopre, @PathVariable String ctipopre, @PathVariable String etipopre) {
        Tipopresencia tipopresencia = new Tipopresencia();
        tipopresencia.setTipopre(tipopre);
        tipopresencia.setCtipopre(ctipopre);
        tipopresencia.setEtipopre(etipopre);
        this.tipopresenciaService.remove(tipopresencia);
       	TipopresenciaController.logger.info("[DELETE] : Tipopresencia borrado correctamente");
       	return tipopresencia;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param tipopresenciaIds List
	 * @return tipopresenciaList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> tipopresenciaIds) {
        List<Tipopresencia> tipopresenciaList = new ArrayList<Tipopresencia>();
        for (List<String> tipopresenciaId:tipopresenciaIds) {
		    Iterator<String> iterator = tipopresenciaId.iterator();
		    Tipopresencia tipopresencia = new Tipopresencia(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        tipopresencia.setTipopre(ObjectConversionManager.convert(iterator.next(), String.class));
	        tipopresencia.setCtipopre(ObjectConversionManager.convert(iterator.next(), String.class));
	        tipopresencia.setEtipopre(ObjectConversionManager.convert(iterator.next(), String.class));
		    tipopresenciaList.add(tipopresencia);
	    }
        this.tipopresenciaService.removeMultiple(tipopresenciaList);
		TipopresenciaController.logger.info("[POST - DELETE_ALL] : Tipopresencia borrados correctamente");
		return tipopresenciaIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterTipopresencia Tipopresencia
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Tipopresencia filterTipopresencia, @ModelAttribute Pagination pagination) {
        List<Tipopresencia> tipopresencias = this.tipopresenciaService.findAll(filterTipopresencia, pagination);
        Long recordNum = this.tipopresenciaService.findAllCount(filterTipopresencia);
        TipopresenciaController.logger.info("[GET - jqGrid] : Obtener Tipopresencia");
		return new JQGridJSONModel(pagination, recordNum, tipopresencias);
	}
	
}	
