package com.ejie.aa20b.control;

import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.Aa20bUsuarioXLNETService;
import com.ejie.aa20b.service.ActuacionService;
import com.ejie.aa20b.service.ClasecontrataService;
import com.ejie.aa20b.service.DepartamentosService;
import com.ejie.aa20b.service.DireccionesService;
import com.ejie.aa20b.service.EdificiosService;
import com.ejie.aa20b.service.EspacioService;
import com.ejie.aa20b.service.FichaService;
import com.ejie.aa20b.service.FichaejecucionService;
import com.ejie.aa20b.service.FichatecnicoService;
import com.ejie.aa20b.service.FichatecnicosgmaoService;
import com.ejie.aa20b.service.MaquinasService;
import com.ejie.aa20b.service.ParteejecucionService;
import com.ejie.aa20b.service.PartepdfService;
import com.ejie.aa20b.service.ParteplanoService;
import com.ejie.aa20b.service.PartesService;
import com.ejie.aa20b.service.PartetecnicosService;
import com.ejie.aa20b.service.PartetecnicosgmaoService;
import com.ejie.aa20b.service.PlantasService;
import com.ejie.aa20b.service.PresenciaService;
import com.ejie.aa20b.service.TecnicoEdifService;
import com.ejie.aa20b.service.TecnicosService;
import com.ejie.aa20b.service.ZonasService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;

import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.ldap.SecurityHelpperXLNets;
import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Clasecontrata;
import com.ejie.aa20b.model.Departamentos;
import com.ejie.aa20b.model.Direcciones;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Espacio;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Fichaejecucion;
import com.ejie.aa20b.model.Fichatecnico;
import com.ejie.aa20b.model.Fichatecnicosgmao;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.Parteejecucion;
import com.ejie.aa20b.model.Partepdf;
import com.ejie.aa20b.model.Parteplano;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.Partetecnicos;
import com.ejie.aa20b.model.Partetecnicosgmao;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.Presencia;
import com.ejie.aa20b.model.TecnicoEdif;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Zonas;

/**
 * TecnicosController generated by UDA, 22-dic-2014 10:12:00.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/tecnicos")
public class TecnicosController {

	private static final Logger logger = LoggerFactory
			.getLogger(TecnicosController.class);

	@Autowired
	private TecnicosService tecnicosService;

	@Autowired
	private TecnicoEdifService tecnicoEdifService;

	@Autowired
	private PartetecnicosService partetecnicosService;

	@Autowired
	private PartetecnicosgmaoService partetecnicosgmaoServices;

	@Autowired
	private FichatecnicosgmaoService fichatecnicosgmaoServices;

	@Autowired
	private ParteejecucionService parteejecucionService;

	@Autowired
	private UsuarioXLNETController usuarioXLNETController;

	@Autowired
	private ClasecontrataService claseContrataService;

	@Autowired
	private MaquinasService maquinasService;

	@Autowired
	private FichatecnicoService fichatecnicosService;

	@Autowired
	private FichaejecucionService fichaejecucionService;

	@Autowired
	private Aa20bProcesosJMSService procesosJMSService;

	@Autowired
	private PartesService partesService;

	@Autowired
	private FichaService fichaService;

	@Autowired
	private EdificiosService edificiosService;

	@Autowired
	private ParteplanoService parteplanoService;

	@Autowired
	private ActuacionService actuacionService;

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private DepartamentosService departamentosService;

	@Autowired
	private DireccionesService direccionesService;

	@Autowired
	private PlantasService plantasService;

	@Autowired
	private ZonasService zonasService;

	@Autowired
	private EspacioService espaciosService;

	@Autowired
	private PresenciaService presenciaService;

	@Autowired
	private PartepdfService partepdfService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		TecnicosController.logger.info("[GET - View] : tecnicos");

		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroTecnicos");

		return "tecnicos";
	}

	/**
	 * Method 'maintVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintVolver", method = RequestMethod.GET)
	public String maintVolver(Model model, HttpServletRequest request) {
		TecnicosController.logger.info("[GET - View] : tecnicos");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Tecnicos tecnicoFiltro = (Tecnicos) request.getSession().getAttribute(
				"FiltroTecnicos");

		model.addAttribute("FiltroTecnico", tecnicoFiltro);

		return "tecnicos";
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "tecnicosDelParte", method = RequestMethod.GET)
	public String getCreateForm2(Model model) {
		TecnicosController.logger.info("[GET - View] : tecnicos parte");

		// return "tecnicosParte";
		return "tecnicosParte";
	}

	@RequestMapping(value = "tecnicosDelParteSoloLectura", method = RequestMethod.GET)
	public String getCreateFormSoloLectura(Model model) {
		TecnicosController.logger.info("[GET - View] : tecnicos parte");

		// return "tecnicosParte";
		return "tecnicosParteSoloLectura";
	}

	/**
	 * Method 'tecnicosDelaFicha'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return ModelAndView
	 */
	@RequestMapping(value = "tecnicosDelaFicha", method = RequestMethod.GET)
	public String tecnicosDelaFicha(Model model) {
		TecnicosController.logger.info("[GET - View] : tecnicos parte");

		return "tecnicosFicha";
	}

	@RequestMapping(value = "tecnicosDelaFichaSoloLectura", method = RequestMethod.GET)
	public String tecnicosDelaFichaSoloLectura(Model model) {
		TecnicosController.logger.info("[GET - View] : tecnicos parte");

		return "tecnicosFichaSoloLectura";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idtecnico
	 *            Long
	 * @return tecnicos Tecnicos
	 */
	@RequestMapping(value = "/{idtecnico}", method = RequestMethod.GET)
	public @ResponseBody
	Tecnicos getById(@PathVariable Long idtecnico) {
		Tecnicos tecnicos = new Tecnicos();
		tecnicos.setIdtecnico(idtecnico);
		tecnicos = this.tecnicosService.find(tecnicos);
		TecnicosController.logger
				.info("[GET - findBy_PK] : Obtener Tecnicos por PK");
		return tecnicos;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTecnicos
	 *            Tecnicos
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Tecnicos> getAll(@ModelAttribute Tecnicos filterTecnicos) {
		TecnicosController.logger
				.info("[GET - find_ALL] : Obtener Tecnicos por filtro");
		return this.tecnicosService.findAll(filterTecnicos, null);
	}

	/**
	 * Method 'obtenerTecnicosLibres'.
	 * 
	 * @param idtecnico
	 *            String
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosLibres", method = RequestMethod.POST)
	public @ResponseBody
	List<Tecnicos> obtenerTecnicosLibres(String idedificio) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosLibres] : Obtener Tecnicos no asociados a un edificio");
		List<Tecnicos> listaTecnicos = this.tecnicosService
				.obtenerTecnicosNOAsociados(idedificio);

		List<Tecnicos> listaTecnicosPresentes = new ArrayList<Tecnicos>();
		for (Tecnicos tecnico : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(tecnico.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				tecnico.setPresente(true);
				listaTecnicosPresentes.add(tecnico);
			} else {
				tecnico.setPresente(false);
				listaTecnicosPresentes.add(tecnico);
			}
		}

		return listaTecnicosPresentes;
	}

	/**
	 * Method 'obtenerTecnicosParteLibres' Obtener Tecnicos asociados al Usuario
	 * identificado en XLNET y asociados al edificio y no asociados al parte.
	 * 
	 * @param idEdificio
	 *            String
	 * @param idParte
	 *            Integer
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosParteLibres", method = RequestMethod.POST)
	public @ResponseBody
	List<Tecnicos> obtenerTecnicosParteLibres(HttpServletRequest request,
			String idEdificio, Integer idParte) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosParteLibres] : Obtener Tecnicos asociados al Usuario identificado en XLNET y asociados al edificio y no asociados al parte");

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		List<Tecnicos> listaTecnicos = this.tecnicosService
				.obtenerTecnicosParteLibres(idEdificio, sUIDUsuario, idParte);

		boolean usuarioLogueadoEsRespCorrectivos = false;
		usuarioLogueadoEsRespCorrectivos = new SecurityHelpperXLNets()
				.usuarioLogueadoEsRespCorrectivos();

		List<Tecnicos> listaTecnicosPresentes = new ArrayList<Tecnicos>();
		if (!usuarioLogueadoEsRespCorrectivos) {
			/**
			 * MOVILGMAO Comprobamos si está presente y solo pasamos lista con
			 * técnicos presentes
			 */
			for (Tecnicos tecnico : listaTecnicos) {
				Presencia presenciaAux = new Presencia();
				presenciaAux.setIdtecnico(tecnico.getIdtecnico());
				if (this.presenciaService
						.comprobarTecnicoEstaPresente(presenciaAux)) {
					tecnico.setPresente(true);
					listaTecnicosPresentes.add(tecnico);
				} else {
					tecnico.setPresente(false);
					listaTecnicosPresentes.add(tecnico);
				}
			}
			return listaTecnicosPresentes;
		} else {
			for (Tecnicos tecnico : listaTecnicos) {
				Presencia presenciaAux = new Presencia();
				presenciaAux.setIdtecnico(tecnico.getIdtecnico());
				if (this.presenciaService
						.comprobarTecnicoEstaPresente(presenciaAux)) {
					tecnico.setPresente(true);
					listaTecnicosPresentes.add(tecnico);
				} else {
					tecnico.setPresente(false);
					listaTecnicosPresentes.add(tecnico);
				}
			}
			return listaTecnicosPresentes;
		}

	}

	/**
	 * Method 'obtenerTecnicosParteAsignados'.
	 * 
	 * @param idParte
	 *            Integer
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosParteAsignados", method = RequestMethod.POST)
	public @ResponseBody
	List<Partetecnicos> obtenerTecnicosParteAsignados(Integer idParte) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosParteAsignados] : Obtener Tecnicos asignados al parte");
		List<Partetecnicos> listaTecnicos = this.partetecnicosService
				.obtenerTecnicosParteAsociados(idParte);

		List<Partetecnicos> listaTecnicosPresentes = new ArrayList<Partetecnicos>();
		for (Partetecnicos partetec : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(partetec.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				partetec.setPresente(true);
				listaTecnicosPresentes.add(partetec);
			} else {
				partetec.setPresente(false);
				listaTecnicosPresentes.add(partetec);
			}
		}

		return listaTecnicosPresentes;
	}

	/**
	 * Method 'obtenerTecnicosOcupados'.
	 * 
	 * @param idedificio
	 *            String
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosOcupados", method = RequestMethod.POST)
	public @ResponseBody
	List<Tecnicos> obtenerTecnicosOcupados(String idedificio) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosOcupados] : Obtener Tecnicos asociados a un edificio");
		List<Tecnicos> listaTecnicos = this.tecnicosService
				.obtenerTecnicosAsociados(idedificio);

		List<Tecnicos> listaTecnicosPresentes = new ArrayList<Tecnicos>();
		for (Tecnicos tecnico : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(tecnico.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				tecnico.setPresente(true);
				listaTecnicosPresentes.add(tecnico);
			} else {
				tecnico.setPresente(false);
				listaTecnicosPresentes.add(tecnico);
			}
		}

		return listaTecnicosPresentes;
	}

	@RequestMapping(value = "/sumaTecnicos", method = RequestMethod.POST)
	public @ResponseBody
	TecnicoEdif sumaTecnicos(@RequestParam String idedificio,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		TecnicoEdif tecnicoEdifAux = new TecnicoEdif();
		TecnicoEdif elTecnicoEdif = new TecnicoEdif();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoEdif.setIdedificio(idedificio);
			elTecnicoEdif.setIdtecnico(tecnicosSeleccionados.get(i));
			elTecnicoEdif.setBaja("0");
			TecnicosController.logger
					.info("[GET - findBy_PK] : Grabando tecnicos edificio : "
							+ elTecnicoEdif.getIdtecnico());

			tecnicoEdifAux = this.tecnicoEdifService.add(elTecnicoEdif);
		}

		TecnicosController.logger.info("[GET - SUMA TECNICOS] : TECNICOS: "
				+ tecnicosSeleccionados.size());

		return tecnicoEdifAux;
	}

	@RequestMapping(value = "/restaTecnicos", method = RequestMethod.POST)
	public @ResponseBody
	TecnicoEdif restaEdificios(@RequestParam String idedificio,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		TecnicoEdif TecnicoEdifAux = new TecnicoEdif();
		TecnicoEdif elTecnicoEdif = new TecnicoEdif();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoEdif.setIdedificio(idedificio);
			elTecnicoEdif.setIdtecnico(tecnicosSeleccionados.get(i));

			/* execute */
			this.tecnicoEdifService.quitarEdificioATecnico(elTecnicoEdif);
		}

		TecnicosController.logger.info("[GET - RESTA TECNICOS] : TECNICOS: "
				+ tecnicosSeleccionados.size());

		return TecnicoEdifAux;
	}

	@RequestMapping(value = "/sumaTecnicosParte", method = RequestMethod.POST)
	public @ResponseBody
	Partetecnicos sumaTecnicosParte(@RequestParam Integer idParte,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Partetecnicos tecnicoParteAux = new Partetecnicos();
		Partetecnicos elTecnicoParte = new Partetecnicos();

		Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
		Partetecnicosgmao elTecnicoParteGmao = new Partetecnicosgmao();

		Partes parteAux = new Partes();
		parteAux.setIdparte(idParte);
		parteAux = this.partesService.find(parteAux);

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoParte.setIdparte(idParte);
			elTecnicoParte.setIdtecnico(tecnicosSeleccionados.get(i));
			TecnicosController.logger
					.info("[GET - findBy_PK] : Grabando tecnicos en el parte : "
							+ elTecnicoParte.getIdtecnico());

			if (parteAux != null && parteAux.getUrgente() != null
					&& parteAux.getUrgente().equals("1")) {
				elTecnicoParte.setAceptada(null);
			} else {
				elTecnicoParte.setAceptada("1");
			}

			tecnicoParteAux = this.partetecnicosService.add(elTecnicoParte);

			/**
			 * MOVILGMAO Comprobamos si ya existe un parte en gmao para este
			 * idParte y técnico que se hubiera quedado huérfano
			 */

			Tecnicos tecnicoAux = new Tecnicos();
			tecnicoAux.setIdtecnico(tecnicosSeleccionados.get(i));
			tecnicoAux = this.tecnicosService.find(tecnicoAux);
			if (tecnicoAux != null && tecnicoAux.getMovilgmao() != null
					&& tecnicoAux.getMovilgmao().equals("1")) {
				tecnicoParteGmaoAux.setIdparte(idParte);
				tecnicoParteGmaoAux.setIdtecnico(tecnicosSeleccionados.get(i));
				tecnicoParteGmaoAux.setIdpartec(null);
				tecnicoParteGmaoAux = this.partetecnicosgmaoServices
						.findParteSinTecnico(tecnicoParteGmaoAux);

				elTecnicoParteGmao.setIdparte(idParte);
				elTecnicoParteGmao.setIdtecnico(tecnicosSeleccionados.get(i));
				elTecnicoParteGmao.setIdpartec(tecnicoParteAux.getIdpartec());
				if (tecnicoParteGmaoAux != null) {
					elTecnicoParteGmao.setGuidpartetecgmao(tecnicoParteGmaoAux
							.getGuidpartetecgmao());

					tecnicoParteGmaoAux = this.partetecnicosgmaoServices
							.update(elTecnicoParteGmao);
				} else {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					elTecnicoParteGmao.setGuidpartetecgmao(randomUUIDString);
					tecnicoParteGmaoAux = this.partetecnicosgmaoServices
							.add(elTecnicoParteGmao);

				}
			}

			/**
			 * FIN MOVILGMAO
			 */

			TecnicosController.logger
					.info("[GET - findBy_PK] : Grabando tecnicos en el parte de MovilGmao : "
							+ elTecnicoParteGmao.getIdtecnico());

			TecnicosController.logger.info("[GET - SUMA TECNICOS] : TECNICOS: "
					+ tecnicosSeleccionados.size());

			/**
			 * MOVILGMAO Cuando se asigna el parte a los técnicos se debe mandar
			 * a MovilGmao para que lo tengan en su BBDD y le llegue al técnico
			 * o técnicos correspondientes Se comprueba si el tecnico tiene
			 * aplicacion movilgmao
			 */
			if (tecnicoAux != null && tecnicoAux.getMovilgmao() != null
					&& tecnicoAux.getMovilgmao().equals("1")) {

				String urlConfig = "";
				String respuesta = "";
				try {
					urlConfig = this.appConfiguration.getObject().getProperty(
							"movilgmao.path");
				} catch (Exception e) {

				}

				if (parteAux != null) {
					/**
					 * Comprobamos si el parte esta finalizado para abrirlo
					 */
					if (parteAux.getEjecutado() != null
							&& parteAux.getEjecutado().equals("1")) {
						this.partesService.abrirParte(parteAux.getIdparte());
					}

					String idEdificio = parteAux.getIdedificio();

					Edificios edifAux = new Edificios();
					edifAux = this.edificiosService.obtenerEdificio(idEdificio);

					if (parteAux.getIddepar() != null) {
						Departamentos departamentoAux = new Departamentos();
						departamentoAux.setIddepar(parteAux.getIddepar());
						departamentoAux = this.departamentosService
								.find(departamentoAux);
						parteAux.setDepartamento(departamentoAux);
					}

					if (parteAux.getIddir() != null) {
						Direcciones direccionAux = new Direcciones();
						direccionAux.setIddir(parteAux.getIddir());
						direccionAux = this.direccionesService
								.find(direccionAux);
						parteAux.setDireccion(direccionAux);
					}

					if (parteAux.getIdplanta() != null) {
						Plantas plantaAux = new Plantas();
						plantaAux.setIdplanta(parteAux.getIdplanta());
						plantaAux = this.plantasService.find(plantaAux);
						parteAux.setPlanta(plantaAux);
					}

					if (parteAux.getIdzona() != null) {
						Zonas zonaAux = new Zonas();
						zonaAux.setIdzona(parteAux.getIdzona());
						zonaAux = this.zonasService.find(zonaAux);
						parteAux.setZona(zonaAux);

					}

					if (parteAux.getIdespacio() != null) {
						Espacio espacioAux = new Espacio();
						espacioAux.setIdespacio(parteAux.getIdespacio());
						espacioAux = this.espaciosService.find(espacioAux);
						parteAux.setEspacio(espacioAux);
					}

					// Obtener el plano si tiene
					Parteplano planoParte = new Parteplano();
					planoParte.setIdparte(parteAux.getIdparte());

					planoParte = this.parteplanoService.find(planoParte);

					Partepdf pdfParte = new Partepdf();
					pdfParte.setIdparte(parteAux.getIdparte());

					pdfParte = this.partepdfService.find(pdfParte);

					if (parteAux.getGuidparte() == null) {
						String randomUUIDString = "";
						UUID uuid = UUID.randomUUID();
						randomUUIDString = uuid.toString();
						parteAux.setGuidparte(randomUUIDString);
						parteAux = this.partesService
								.actualizarUUIDparte(parteAux);
					}

					if (planoParte != null) {

						String randomUUIDString = "";
						UUID uuid = UUID.randomUUID();
						randomUUIDString = uuid.toString();
						elTecnicoParteGmao
								.setGuidplanopartegmao(randomUUIDString);
						tecnicoParteGmaoAux = this.partetecnicosgmaoServices
								.update(elTecnicoParteGmao);
					}

					if (pdfParte != null) {

						String randomUUIDString = "";
						UUID uuid = UUID.randomUUID();
						randomUUIDString = uuid.toString();
						elTecnicoParteGmao
								.setGuidpdfpartegmao(randomUUIDString);
						tecnicoParteGmaoAux = this.partetecnicosgmaoServices
								.update(elTecnicoParteGmao);
					}

					// Obtener tecnicos asignados al parte (partetecnicos)
					tecnicoParteGmaoAux = new Partetecnicosgmao();
					tecnicoParteGmaoAux.setIdparte(idParte);
					List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
							.findAllnoAsignadosMovilGmao(tecnicoParteGmaoAux,
									null);

					byte[] blobAsBytes = null;
					byte[] blobAsBytesPDF = null;
					try {
						if (planoParte != null) {
							// Tiene plano
							int blobLeng = (int) planoParte.getDibujo()
									.length();
							blobAsBytes = planoParte.getDibujo().getBytes(1,
									blobLeng);
						}

						if (pdfParte != null) {
							// Tiene plano
							int blobLeng = (int) pdfParte.getPdf().length();
							blobAsBytesPDF = pdfParte.getPdf().getBytes(1,
									blobLeng);
						}

						respuesta = this.procesosJMSService
								.sincronizarParteCorrectivoGmao(parteAux,
										parteTecnicosGmao,
										edifAux.getGuidedificio(), blobAsBytes,
										blobAsBytesPDF, urlConfig);

						if (respuesta != null && respuesta.equals("OK")) {
							TecnicosController.logger
									.info("[MOVILGMAO] : sincronizarParteCorrectivo: "
											+ respuesta);
						} else {
							TecnicosController.logger
									.error("[MOVILGMAO] : sincronizarParteCorrectivo: "
											+ respuesta);
						}
					} catch (Exception e) {
						e.printStackTrace();
					}

				}
			}

			/**
			 * FIN MOVILGMAO
			 */
		}
		return tecnicoParteAux;
	}

	@RequestMapping(value = "/restaTecnicosParte", method = RequestMethod.POST)
	public @ResponseBody
	Partetecnicos restaTecnicosParte(@RequestParam Integer idParte,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Partetecnicos tecnicoParteAux = new Partetecnicos();
		Partetecnicos elTecnicoParte = new Partetecnicos();

		Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
		Partetecnicosgmao elTecnicoParteGmao = new Partetecnicosgmao();
		List<Partetecnicosgmao> parteTecnicosEliminar = new ArrayList<Partetecnicosgmao>();
		boolean tieneTecnicoGmao = false;

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoParte.setIdparte(idParte);
			elTecnicoParte.setIdtecnico(tecnicosSeleccionados.get(i));
			TecnicosController.logger
					.info("[GET - findBy_PK] : Eliminando tecnicos en el parte : "
							+ elTecnicoParte.getIdtecnico());
			/* execute */
			this.partetecnicosService.eliminaTecnicoParte(elTecnicoParte);

			/**
			 * MOVILGMAO
			 */
			tecnicoParteGmaoAux = new Partetecnicosgmao();
			elTecnicoParteGmao = new Partetecnicosgmao();
			tecnicoParteGmaoAux.setIdparte(idParte);
			tecnicoParteGmaoAux.setIdtecnico(tecnicosSeleccionados.get(i));
			tecnicoParteGmaoAux = this.partetecnicosgmaoServices
					.find(tecnicoParteGmaoAux);

			if (tecnicoParteGmaoAux != null) {
				/*
				 * elTecnicoParteGmao.setIdparte(idParte);
				 * elTecnicoParteGmao.setGuidpartetecgmao(tecnicoParteGmaoAux
				 * .getGuidpartetecgmao());
				 * elTecnicoParteGmao.setIdtecnico(tecnicosSeleccionados
				 * .get(i)); elTecnicoParteGmao.setIdpartec(null);
				 * tecnicoParteGmaoAux = this.partetecnicosgmaoServices
				 * .update(elTecnicoParteGmao);
				 * 
				 * parteTecnicosEliminar.add(tecnicoParteGmaoAux);
				 * tieneTecnicoGmao = true;
				 */

				elTecnicoParteGmao.setIdparte(idParte);
				elTecnicoParteGmao.setGuidpartetecgmao(tecnicoParteGmaoAux
						.getGuidpartetecgmao());
				elTecnicoParteGmao.setGuidplanopartegmao(tecnicoParteGmaoAux
						.getGuidplanopartegmao());
				elTecnicoParteGmao.setGuidpdfpartegmao(tecnicoParteGmaoAux
						.getGuidpdfpartegmao());
				elTecnicoParteGmao.setIdtecnico(null);
				elTecnicoParteGmao.setIdpartec(null);
				tecnicoParteGmaoAux = this.partetecnicosgmaoServices
						.update(elTecnicoParteGmao);

				parteTecnicosEliminar.add(tecnicoParteGmaoAux);
				tieneTecnicoGmao = true;
			}

			/**
			 * FIN MOVILGMAO
			 */

		}

		TecnicosController.logger.info("[GET - RESTA TECNICOS] : TECNICOS: "
				+ tecnicosSeleccionados.size());

		/**
		 * MOVILGMAO Cuando se asigna el parte a los técnicos se debe mandar a
		 * MovilGmao para que lo tengan en su BBDD y le llegue al técnico o
		 * técnicos correspondientes
		 */
		if (tieneTecnicoGmao) {
			String urlConfig = "";
			try {
				urlConfig = this.appConfiguration.getObject().getProperty(
						"movilgmao.path");
			} catch (Exception e) {

			}
			Partes parteAux = new Partes();
			parteAux.setIdparte(idParte);
			parteAux = this.partesService.find(parteAux);
			if (parteAux != null) {
				String idEdificio = parteAux.getIdedificio();

				Edificios edifAux = new Edificios();
				edifAux = this.edificiosService.obtenerEdificio(idEdificio);

				if (parteAux.getIddepar() != null) {
					Departamentos departamentoAux = new Departamentos();
					departamentoAux.setIddepar(parteAux.getIddepar());
					departamentoAux = this.departamentosService
							.find(departamentoAux);
					parteAux.setDepartamento(departamentoAux);
				}

				if (parteAux.getIddir() != null) {
					Direcciones direccionAux = new Direcciones();
					direccionAux.setIddir(parteAux.getIddir());
					direccionAux = this.direccionesService.find(direccionAux);
					parteAux.setDireccion(direccionAux);
				}

				if (parteAux.getIdplanta() != null) {
					Plantas plantaAux = new Plantas();
					plantaAux.setIdplanta(parteAux.getIdplanta());
					plantaAux = this.plantasService.find(plantaAux);
					parteAux.setPlanta(plantaAux);
				}

				if (parteAux.getIdzona() != null) {
					Zonas zonaAux = new Zonas();
					zonaAux.setIdzona(parteAux.getIdzona());
					zonaAux = this.zonasService.find(zonaAux);
					parteAux.setZona(zonaAux);

				}

				if (parteAux.getIdespacio() != null) {
					Espacio espacioAux = new Espacio();
					espacioAux.setIdespacio(parteAux.getIdespacio());
					espacioAux = this.espaciosService.find(espacioAux);
					parteAux.setEspacio(espacioAux);
				}

				// Obtener el plano si tiene
				Parteplano planoParte = new Parteplano();
				planoParte.setIdparte(parteAux.getIdparte());

				planoParte = this.parteplanoService.find(planoParte);

				Partepdf pdfParte = new Partepdf();
				pdfParte.setIdparte(parteAux.getIdparte());

				pdfParte = this.partepdfService.find(pdfParte);

				// Obtener tecnicos asignados al parte (partetecnicos)
				tecnicoParteGmaoAux = new Partetecnicosgmao();
				tecnicoParteGmaoAux.setIdparte(idParte);
				List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
						.findAllnoAsignadosMovilGmao(tecnicoParteGmaoAux, null);

				byte[] blobAsBytes = null;
				byte[] blobAsBytesPDF = null;
				try {
					if (planoParte != null) {
						// Tiene plano
						int blobLeng = (int) planoParte.getDibujo().length();
						blobAsBytes = planoParte.getDibujo().getBytes(1,
								blobLeng);
					}

					if (pdfParte != null) {
						// Tiene plano
						int blobLeng = (int) pdfParte.getPdf().length();
						blobAsBytesPDF = pdfParte.getPdf()
								.getBytes(1, blobLeng);
					}

					String respuesta = this.procesosJMSService
							.sincronizarParteCorrectivoGmao(parteAux,
									parteTecnicosGmao,
									edifAux.getGuidedificio(), blobAsBytes,
									blobAsBytesPDF, urlConfig);

					if (respuesta != null && respuesta.equals("OK")) {
						TecnicosController.logger
								.info("[MOVILGMAO] : sincronizarParteCorrectivo: "
										+ respuesta);

						/*
						 * for (Partetecnicosgmao parteGmaoEliminar :
						 * parteTecnicosEliminar) {
						 * this.partetecnicosgmaoServices
						 * .remove(parteGmaoEliminar); }
						 */

						/**
						 * Comprobamos si el parte tiene más técnicos asignados
						 * en ese caso no dejamos el parte sin asignar en el
						 * planner y lo eliminamos
						 */
						Partetecnicosgmao partetecgmaoBusqAux = new Partetecnicosgmao();
						partetecgmaoBusqAux.setIdparte(tecnicoParteGmaoAux
								.getIdparte());
						parteTecnicosGmao = new ArrayList<Partetecnicosgmao>();
						parteTecnicosGmao = this.partetecnicosgmaoServices
								.findAll(partetecgmaoBusqAux, null);

						if (parteTecnicosGmao.size() > 1) {
							int contadorTecnicos = parteTecnicosGmao.size();
							int contadorBorrados = 1;
							for (Partetecnicosgmao partetecgmaoAux : parteTecnicosGmao) {
								if (partetecgmaoAux != null
										&& (partetecgmaoAux.getIdtecnico() == null || partetecgmaoAux
												.getIdtecnico() == 0)
										&& contadorBorrados != contadorTecnicos) {
									this.procesosJMSService.eliminarOTpadre(
											partetecgmaoAux
													.getGuidpartetecgmao(),
											urlConfig);
									this.partetecnicosgmaoServices
											.remove(partetecgmaoAux);
									contadorBorrados++;
								}

							}
						}
					} else {
						TecnicosController.logger
								.error("[MOVILGMAO] : sincronizarParteCorrectivo: "
										+ respuesta);
					}

				} catch (Exception e) {
					e.printStackTrace();
				}
			}

			/**
			 * FIN MOVILGMAO
			 */
		}

		return tecnicoParteAux;
	}

	/**
	 * Method 'obtenerTecnicosUsuarioLibres'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosUsuarioLibres", method = RequestMethod.POST)
	public @ResponseBody
	List<Tecnicos> obtenerTecnicosUsuarioLibres(HttpServletRequest request) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosUsuarioLibres] : Obtener Tecnicos asociados al USUARIO no asociados en la planificacion");

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		List<Tecnicos> listaTecnicos = this.tecnicosService
				.obtenerTecnicosUsuarioLibres(sUIDUsuario);

		List<Tecnicos> listaTecnicosPresentes = new ArrayList<Tecnicos>();
		for (Tecnicos tecnico : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(tecnico.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				tecnico.setPresente(true);
				listaTecnicosPresentes.add(tecnico);
			} else {
				tecnico.setPresente(false);
				listaTecnicosPresentes.add(tecnico);
			}
		}

		return listaTecnicosPresentes;
	}

	/**
	 * Method 'obtenerTecnicosParteAsignados'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosUsuarioAsignados", method = RequestMethod.POST)
	public @ResponseBody
	List<Tecnicos> obtenerTecnicosUsuarioAsignados(HttpServletRequest request) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosUsuarioAsignados] : Obtener Tecnicos asignados al parte");
		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		List<Tecnicos> listaTecnicos = this.tecnicosService
				.obtenerTecnicosUsuarioAsignados(sUIDUsuario);

		List<Tecnicos> listaTecnicosPresentes = new ArrayList<Tecnicos>();
		for (Tecnicos tecnico : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(tecnico.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				tecnico.setPresente(true);
				listaTecnicosPresentes.add(tecnico);
			} else {
				tecnico.setPresente(false);
				listaTecnicosPresentes.add(tecnico);
			}
		}

		return listaTecnicosPresentes;
	}

	@RequestMapping(value = "/comprobarEjecucionesTecnico", method = RequestMethod.POST)
	public @ResponseBody
	Partetecnicos comprobarEjecucionesTecnico(@RequestParam Integer idParte,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Partetecnicos tecnicoParteAux = new Partetecnicos();
		Partetecnicos elTecnicoParte = new Partetecnicos();
		Parteejecucion filterParteejecucion = new Parteejecucion();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoParte.setIdparte(idParte);
			elTecnicoParte.setIdtecnico(tecnicosSeleccionados.get(i));

			// Comprobar que el tecnico no tenga ejecuciones asociadas a este
			// parte
			List<Partetecnicos> parteTecnicos = this.partetecnicosService
					.findAll(elTecnicoParte, null);

			filterParteejecucion
					.setIdpartec(parteTecnicos.get(0).getIdpartec());

			List<Parteejecucion> parteejecucions = this.parteejecucionService
					.findAll(filterParteejecucion, null);
			if (parteejecucions.size() > 0) {
				return null;
			} else {
				// Comprobamos si el parte ya se encuentra en curso
				Partetecnicosgmao partetecnicosgmaoAux = new Partetecnicosgmao();
				partetecnicosgmaoAux.setIdparte(idParte);
				partetecnicosgmaoAux.setIdtecnico(tecnicosSeleccionados.get(i));
				partetecnicosgmaoAux = this.partetecnicosgmaoServices
						.find(partetecnicosgmaoAux);

				if (partetecnicosgmaoAux != null
						&& partetecnicosgmaoAux.getEstadoGmao() != null) {
					if (partetecnicosgmaoAux.getEstadoGmao().equals("CURS")
							|| partetecnicosgmaoAux.equals("TERM")) {
						return null;
					}
				}
			}
		}

		TecnicosController.logger.info("[POST - comprobarEjecucionesTecnico] ");

		return tecnicoParteAux;
	}

	@RequestMapping(value = "/comprobarEjecucionesFichaTecnico", method = RequestMethod.POST)
	public @ResponseBody
	Fichatecnico comprobarEjecucionesFichaTecnico(
			@RequestParam Integer idFicha,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Fichatecnico tecnicoFichaAux = new Fichatecnico();
		Fichatecnico elTecnicoFicha = new Fichatecnico();
		Fichaejecucion filterFichaejecucion = new Fichaejecucion();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoFicha.setIdficha(idFicha);
			elTecnicoFicha.setIdtecnico(tecnicosSeleccionados.get(i));

			// Comprobar que el tecnico no tenga ejecuciones asociadas a esta
			// ficha
			List<Fichatecnico> fichaTecnicos = this.fichatecnicosService
					.findAll(elTecnicoFicha, null);

			filterFichaejecucion.setIdfitec(fichaTecnicos.get(0).getIdfitec());

			List<Fichaejecucion> fichaejecucions = this.fichaejecucionService
					.findAll(filterFichaejecucion, null);
			if (fichaejecucions.size() > 0) {
				return null;
			} else {
				// Comprobamos si la ficha ya se encuentra en curso o en un
				// estado
				// que no sea válido quitar al técnico
				Fichatecnicosgmao fichatecnicosgmaoAux = new Fichatecnicosgmao();
				fichatecnicosgmaoAux.setIdficha(idFicha);
				fichatecnicosgmaoAux.setIdtecnico(tecnicosSeleccionados.get(i));
				fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
						.find(fichatecnicosgmaoAux);

				if (fichatecnicosgmaoAux != null
						&& fichatecnicosgmaoAux.getEstadoGmao() != null) {
					if (fichatecnicosgmaoAux.getEstadoGmao().equals("CURS")
							|| fichatecnicosgmaoAux.equals("TERM")) {
						return null;
					}
				}
			}
		}

		TecnicosController.logger
				.info("[POST - comprobarEjecucionesFichaTecnico] ");

		return tecnicoFichaAux;
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Tecnicos edit(@RequestBody Tecnicos tecnicos) {
		Tecnicos tecnicosAux = this.tecnicosService.update(tecnicos);
		TecnicosController.logger
				.info("[PUT] : Tecnicos actualizado correctamente");
		return tecnicosAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Tecnicos add(@RequestBody Tecnicos tecnicos) {
		Tecnicos tecnicosAux = this.tecnicosService.add(tecnicos);
		TecnicosController.logger
				.info("[POST] : Tecnicos insertado correctamente");
		return tecnicosAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idtecnico
	 *            Long
	 * @return tecnicos
	 */
	@RequestMapping(value = "/{idtecnico}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Tecnicos remove(@PathVariable Long idtecnico) {
		Tecnicos tecnicos = new Tecnicos();
		tecnicos.setIdtecnico(idtecnico);
		this.tecnicosService.remove(tecnicos);
		TecnicosController.logger
				.info("[DELETE] : Tecnicos borrado correctamente");
		return tecnicos;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tecnicosIds
	 *            List
	 * @return tecnicosList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> tecnicosIds) {
		List<Tecnicos> tecnicosList = new ArrayList<Tecnicos>();
		for (List<String> tecnicosId : tecnicosIds) {
			Iterator<String> iterator = tecnicosId.iterator();
			Tecnicos tecnicos = new Tecnicos(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			tecnicos.setIdtecnico(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			tecnicosList.add(tecnicos);
		}
		this.tecnicosService.removeMultiple(tecnicosList);
		TecnicosController.logger
				.info("[POST - DELETE_ALL] : Tecnicos borrados correctamente");
		return tecnicosIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTecnicos
	 *            Tecnicos
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Tecnicos filterTecnicos,
			@ModelAttribute Pagination pagination, HttpServletRequest request) {
		List<Tecnicos> tecnicoss = this.tecnicosService.findAllLike(
				filterTecnicos, pagination, false);
		Long recordNum = this.tecnicosService.findAllLikeCount(filterTecnicos,
				false);
		TecnicosController.logger.info("[GET - jqGrid] : Obtener Tecnicos");

		request.getSession().setAttribute("FiltroTecnicos", filterTecnicos);

		return new JQGridJSONModel(pagination, recordNum, tecnicoss);
	}

	/**
	 * Method 'obtenerTecnicosClaseContrataLibres'.
	 * 
	 * @param idClase
	 *            Integer
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosClaseContrataLibres", method = RequestMethod.POST)
	public @ResponseBody
	List<Tecnicos> obtenerTecnicosClaseContrataLibres(Integer idClase) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosClaseContrataLibres] : Obtener Tecnicos de contratas no asociados a la clase");
		List<Tecnicos> listaTecnicos = this.tecnicosService
				.obtenerTecnicosClaseContrataLibres(idClase);

		List<Tecnicos> listaTecnicosPresentes = new ArrayList<Tecnicos>();
		for (Tecnicos tecnico : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(tecnico.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				tecnico.setPresente(true);
				listaTecnicosPresentes.add(tecnico);
			} else {
				tecnico.setPresente(false);
				listaTecnicosPresentes.add(tecnico);
			}
		}

		return listaTecnicosPresentes;
	}

	/**
	 * Method 'obtenerTecnicosClaseContrataAsignados'.
	 * 
	 * @param idClase
	 *            Integer
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosClaseContrataAsignados", method = RequestMethod.POST)
	public @ResponseBody
	List<Tecnicos> obtenerTecnicosClaseContrataAsignados(Integer idClase) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosClaseContrataAsignados] : Obtener Tecnicos de contratas no asociados a la clase");
		List<Tecnicos> listaTecnicos = this.tecnicosService
				.obtenerTecnicosClaseContrataAsignados(idClase);

		List<Tecnicos> listaTecnicosPresentes = new ArrayList<Tecnicos>();
		for (Tecnicos tecnico : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(tecnico.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				tecnico.setPresente(true);
				listaTecnicosPresentes.add(tecnico);
			} else {
				tecnico.setPresente(false);
				listaTecnicosPresentes.add(tecnico);
			}
		}

		return listaTecnicosPresentes;
	}

	/**
	 * Method 'obtenerTecnicosClaseCodigoContrataLibres'.
	 * 
	 * @param idClase
	 *            Integer
	 * @param idCodigo
	 *            Integer
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosClaseCodigoContrataLibres", method = RequestMethod.POST)
	public @ResponseBody
	List<Tecnicos> obtenerTecnicosClaseCodigoContrataLibres(Integer idClase,
			Integer idCodigo) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosClaseContrataLibres] : Obtener Tecnicos de contratas no asociados a la clase y codigo");
		List<Tecnicos> listaTecnicos = this.tecnicosService
				.obtenerTecnicosClaseCodigoContrataLibres(idClase, idCodigo);

		List<Tecnicos> listaTecnicosPresentes = new ArrayList<Tecnicos>();
		for (Tecnicos tecnico : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(tecnico.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				tecnico.setPresente(true);
				listaTecnicosPresentes.add(tecnico);
			} else {
				tecnico.setPresente(false);
				listaTecnicosPresentes.add(tecnico);
			}
		}

		return listaTecnicosPresentes;
	}

	/**
	 * Method 'obtenerTecnicosClaseCodigoContrataAsignados'.
	 * 
	 * @param idClase
	 *            Integer
	 * @param idCodigo
	 *            Integer
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosClaseCodigoContrataAsignados", method = RequestMethod.POST)
	public @ResponseBody
	List<Tecnicos> obtenerTecnicosClaseCodigoContrataAsignados(Integer idClase,
			Integer idCodigo) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosClaseContrataAsignados] : Obtener Tecnicos de contratas no asociados a la clase y codigo");
		List<Tecnicos> listaTecnicos = this.tecnicosService
				.obtenerTecnicosClaseCodigoContrataAsignados(idClase, idCodigo);

		List<Tecnicos> listaTecnicosPresentes = new ArrayList<Tecnicos>();
		for (Tecnicos tecnico : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(tecnico.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				tecnico.setPresente(true);
				listaTecnicosPresentes.add(tecnico);
			} else {
				tecnico.setPresente(false);
				listaTecnicosPresentes.add(tecnico);
			}
		}

		return listaTecnicosPresentes;
	}

	@RequestMapping(value = "/sumaTecnicosClaseContrata", method = RequestMethod.POST)
	public @ResponseBody
	Clasecontrata sumaTecnicosClaseContrata(@RequestParam Integer idClase,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Clasecontrata tecnicoClaseContrataAux = new Clasecontrata();
		Clasecontrata elTecnicoClaseContrata = new Clasecontrata();
		Date fechaHoy = new Date();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoClaseContrata.setIdclase(idClase);
			elTecnicoClaseContrata.setIdtecnico(tecnicosSeleccionados.get(i));
			elTecnicoClaseContrata.setFeini(fechaHoy);
			elTecnicoClaseContrata.setBaja("0");
			elTecnicoClaseContrata.setIdcodigo(0);
			TecnicosController.logger
					.info("[GET - findBy_PK] : Grabando tecnicos en Clase Contrata : "
							+ elTecnicoClaseContrata.getIdtecnico());

			tecnicoClaseContrataAux = this.claseContrataService
					.sumaTecnico(elTecnicoClaseContrata);
		}

		TecnicosController.logger.info("[GET - SUMA TECNICOS] : TECNICOS: "
				+ tecnicosSeleccionados.size());

		return tecnicoClaseContrataAux;
	}

	@RequestMapping(value = "/sumaTecnicosClaseCodigoContrata", method = RequestMethod.POST)
	public @ResponseBody
	Clasecontrata sumaTecnicosClaseContrata(@RequestParam Integer idClase,
			@RequestParam Integer idCodigo,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Clasecontrata tecnicoClaseContrataAux = new Clasecontrata();
		Clasecontrata elTecnicoClaseContrata = new Clasecontrata();
		Date fechaHoy = new Date();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {

			// Si ya existe registro para ese idclase, idtecnico e idCodigo será
			// porque está de baja. Ponerlo de alta.
			elTecnicoClaseContrata.setIdclase(idClase);
			elTecnicoClaseContrata.setIdtecnico(tecnicosSeleccionados.get(i));
			elTecnicoClaseContrata.setIdcodigo(idCodigo);

			tecnicoClaseContrataAux = this.claseContrataService
					.find(elTecnicoClaseContrata);
			if (tecnicoClaseContrataAux != null) {
				// Poner el registro de alta.
				elTecnicoClaseContrata.setBaja("0");
				elTecnicoClaseContrata.setFeini(fechaHoy);
				tecnicoClaseContrataAux = this.claseContrataService
						.update(elTecnicoClaseContrata);
			} else {
				// Comprobar si ya existe un registro para esa clase y tecnico
				// con idcodigo=0
				elTecnicoClaseContrata = new Clasecontrata();
				elTecnicoClaseContrata.setIdclase(idClase);
				elTecnicoClaseContrata.setIdtecnico(tecnicosSeleccionados
						.get(i));
				elTecnicoClaseContrata.setIdcodigo(0);
				tecnicoClaseContrataAux = this.claseContrataService
						.find(elTecnicoClaseContrata);
				if (tecnicoClaseContrataAux != null) {
					// Existe. hacer update con el idCodigo
					elTecnicoClaseContrata.setIdcodigo(idCodigo);
					elTecnicoClaseContrata.setFeini(fechaHoy);
					tecnicoClaseContrataAux = this.claseContrataService
							.cambiarCodigo(elTecnicoClaseContrata);
				} else {
					// hacer INSERT
					elTecnicoClaseContrata.setIdcodigo(idCodigo);
					elTecnicoClaseContrata.setFeini(fechaHoy);
					elTecnicoClaseContrata.setBaja("0");
					tecnicoClaseContrataAux = this.claseContrataService
							.add(elTecnicoClaseContrata);
				}
			}
			TecnicosController.logger
					.info("[GET - findBy_PK] : Grabando tecnicos en Clase Contrata : "
							+ elTecnicoClaseContrata.getIdtecnico());
		}

		TecnicosController.logger.info("[GET - SUMA TECNICOS] : TECNICOS: "
				+ tecnicosSeleccionados.size());

		return tecnicoClaseContrataAux;
	}

	@RequestMapping(value = "/restaTecnicosClaseContrata", method = RequestMethod.POST)
	public @ResponseBody
	Clasecontrata restaTecnicosClaseContrata(@RequestParam Integer idClase,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Clasecontrata tecnicoClaseContrataAux = new Clasecontrata();
		Clasecontrata elTecnicoClaseContrata = new Clasecontrata();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoClaseContrata.setIdclase(idClase);
			elTecnicoClaseContrata.setIdtecnico(tecnicosSeleccionados.get(i));
			TecnicosController.logger
					.info("[GET - findBy_PK] : Eliminando tecnicos en Clase Contrata  : "
							+ elTecnicoClaseContrata.getIdtecnico());
			/* execute */
			this.claseContrataService.eliminaTecnico(elTecnicoClaseContrata);

		}

		TecnicosController.logger
				.info("[GET - RESTA TECNICOS] : en Clase Contrata : "
						+ tecnicosSeleccionados.size());

		return tecnicoClaseContrataAux;
	}

	@RequestMapping(value = "/restaTecnicosClaseCodigoContrata", method = RequestMethod.POST)
	public @ResponseBody
	Clasecontrata restaTecnicosClaseCodigoContrata(
			@RequestParam Integer idClase, @RequestParam Integer idCodigo,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Boolean hacerDelete = false;
		Clasecontrata tecnicoClaseContrataAux = new Clasecontrata();
		Clasecontrata elTecnicoClaseContrata = new Clasecontrata();
		Date fechaHoy = new Date();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			// Si existe otro registro para ese tecnico y clase y con codigo<>0
			// hacemos delete del tecncio, clase y codigo seleccionado.
			elTecnicoClaseContrata.setIdclase(idClase);
			elTecnicoClaseContrata.setIdtecnico(tecnicosSeleccionados.get(i));
			List<Clasecontrata> claseContrata = this.claseContrataService
					.findAll(elTecnicoClaseContrata, null);
			for (int a = 0; a < claseContrata.size(); a++) {
				if (!claseContrata.get(a).getIdcodigo().equals(0)
						&& !claseContrata.get(a).getIdcodigo().equals(idCodigo)) {
					// El tecnico tiene esta asociado a otro codigo de la misma
					// clase
					// Hacemos delete
					hacerDelete = true;
				}
			}
			if (hacerDelete) {
				// El tecnico tiene esta asociado a otro codigo de la misma
				// clase
				// Hacemos delete
				elTecnicoClaseContrata.setIdcodigo(idCodigo);
				/* execute */
				this.claseContrataService.remove(elTecnicoClaseContrata);
			} else {
				// El tecnico NO esta asociado a otros códigos de la misma
				// clase. por lo tanto hacemos upadate idcodigo=0
				elTecnicoClaseContrata.setIdcodigo(idCodigo);
				elTecnicoClaseContrata.setFeini(fechaHoy);
				tecnicoClaseContrataAux = this.claseContrataService
						.ponerCodigoCero(elTecnicoClaseContrata);
			}

			TecnicosController.logger
					.info("[GET - findBy_PK] : Eliminando tecnicos en Clase Contrata  : "
							+ elTecnicoClaseContrata.getIdtecnico());
		}

		TecnicosController.logger
				.info("[GET - RESTA TECNICOS] : en Clase Contrata : "
						+ tecnicosSeleccionados.size());

		return tecnicoClaseContrataAux;
	}

	@RequestMapping(value = "/bajaTecnicosClaseCodigoContrata", method = RequestMethod.POST)
	public @ResponseBody
	Clasecontrata bajaTecnicosClaseCodigoContrata(
			@RequestParam Integer idClase, @RequestParam Integer idCodigo,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Clasecontrata tecnicoClaseContrataAux = new Clasecontrata();
		Clasecontrata elTecnicoClaseContrata = new Clasecontrata();
		Date fechaHoy = new Date();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			// Si existe otro registro para ese tecnico y clase y con codigo<>0
			// hacemos delete del tecncio, clase y codigo seleccionado.
			elTecnicoClaseContrata.setIdclase(idClase);
			elTecnicoClaseContrata.setIdtecnico(tecnicosSeleccionados.get(i));
			elTecnicoClaseContrata.setIdcodigo(idCodigo);
			elTecnicoClaseContrata.setFeini(fechaHoy);

			tecnicoClaseContrataAux = this.claseContrataService
					.ponerCodigoBaja(elTecnicoClaseContrata);

			TecnicosController.logger
					.info("[GET - findBy_PK] : Poniendo tecnicos de baja en Clase Contrata  : "
							+ elTecnicoClaseContrata.getIdtecnico());
		}

		TecnicosController.logger
				.info("[GET - RESTA TECNICOS] : en Clase Contrata : "
						+ tecnicosSeleccionados.size());

		return tecnicoClaseContrataAux;
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idTecnicoBusc
	 *            String
	 * @param ventanaOrigen
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/buscarTecnico", method = RequestMethod.POST)
	public String getById(@RequestParam String idTecnicoBusc,
			@RequestParam String ventanaOrigen, Model model,
			HttpServletRequest request) {

		TecnicosController.logger.info("[GET - findBy_PK] : Tecnico");

		Tecnicos tecnico = new Tecnicos();

		Long idTecnico = Long.parseLong(idTecnicoBusc);

		tecnico = this.getById(idTecnico);

		TecnicosController.logger.info("[GET - findBy_PK] : Tecnico: "
				+ tecnico.toString());

		model.addAttribute("Tecnico", tecnico);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		return "editarTecnico";
	}

	/**
	 * Method 'modificarTecnico'.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	@RequestMapping(value = "modificarTecnico", method = RequestMethod.POST)
	public @ResponseBody
	Tecnicos modificarTecnico(@RequestBody Tecnicos tecnicos) {

		/**
		 * GMAO Comprobaremos si el técnico no se encontraba de baja. Relleno el
		 * campo guid con el valor de la BBDD para no crear un duplicado en GMAO
		 */
		boolean sincronizarActivoGmao = false;
		boolean sincronizarClienteGmao = true;
		Tecnicos tecnicoBaja = this.tecnicosService.find(tecnicos);
		tecnicos.setGuidtecnico(tecnicoBaja.getGuidtecnico());

		if (tecnicos.getBaja() == null || tecnicos.getBaja().equals("0")) {
			/**
			 * GMAO Si estaba de baja significa que se ha puesto de alta ahora y
			 * hay que sincronizar con Gmao
			 */
			if (tecnicoBaja.getBaja() != null
					&& tecnicoBaja.getBaja().equals("1")) {
				sincronizarActivoGmao = true;
			}
			/***/
			tecnicos.setBaja("0");
		} else {

			/**
			 * GMAO Si no estaba de baja significa que se ha puesto de baja
			 * ahora y hay que sincronizar con Gmao
			 */
			if (tecnicoBaja.getBaja() == null
					|| (tecnicoBaja.getBaja() != null && tecnicoBaja.getBaja()
							.equals("0"))) {
				sincronizarActivoGmao = true;
			} else {
				// Si estaba de baja y sigue de baja no actualizamos GMAO
				sincronizarClienteGmao = false;
			}
			/***/

			tecnicos.setBaja("1");
		}

		Tecnicos tecnicosAux = this.tecnicosService.modificarTecnico(tecnicos);
		TecnicosController.logger
				.info("[PUT] : Tecnicos actualizado correctamente");

		/**
		 * GMAO - Si la actualización del tecnico ha ido bien generamos un
		 * mensaje en la cola para actualizar el tecnico y su activo en BBDD
		 * movilgmao. Se comprueba que el registro tengo guid y sino tiene se
		 * genera y guarda
		 */
		if (sincronizarActivoGmao) {
			if (tecnicos.getGuidtecnico() == null
					|| (tecnicos.getGuidtecnico() != null && tecnicos
							.getGuidtecnico().trim().equals(""))) {
				String randomUUIDString = "";
				UUID uuid = UUID.randomUUID();
				randomUUIDString = uuid.toString();
				tecnicos.setGuidtecnico(randomUUIDString);
				this.tecnicosService.actualizarUUIDtecnico(tecnicos);
			}
		}
		if (sincronizarClienteGmao) {
			TecnicosController.logger
					.info("[JMS] notificar modificación tecnico movilgmao");

			this.procesosJMSService.notificarCambioDatosJMS(
					Aa20bConstantes.OPER_MANT_TECNICO,
					Aa20bConstantes.CLASE_TECNICOS, tecnicos);
		}

		return tecnicosAux;
	}

	/**
	 * Method 'nuevoTecnico'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/nuevoTecnico", method = RequestMethod.GET)
	public String nuevoTecnico(Model model) {

		TecnicosController.logger.info("[GET - View] : nuevo tecnico");
		return "nuevoTecnico";
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tecnicos
	 *            Tecnicos
	 * @return Tecnicos
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.POST)
	public @ResponseBody
	Tecnicos alta(@RequestBody Tecnicos tecnicos) {

		tecnicos.setBaja("0");

		if (tecnicos.getTecnicoContrata() == null) {
			tecnicos.setTecnicoContrata("0");
		}

		/**
		 * Obtener codigo GUID
		 */
		String randomUUIDString = "";
		UUID uuid = UUID.randomUUID();
		randomUUIDString = uuid.toString();
		tecnicos.setGuidtecnico(randomUUIDString);

		Tecnicos tecnicosAux = this.tecnicosService.add(tecnicos);
		TecnicosController.logger
				.info("[POST] : Tecnicos insertado correctamente");

		TecnicosController.logger
				.info("[JMS] notificar creacion tecnico movilgmao");

		this.procesosJMSService.notificarCambioDatosJMS(
				Aa20bConstantes.OPER_MANT_TECNICO,
				Aa20bConstantes.CLASE_TECNICOS, tecnicos);

		return tecnicosAux;
	}

	/**
	 * Method 'obtenerTecnicosParteLibres' Obtener Tecnicos asociados al Usuario
	 * identificado en XLNET y asociados al edificio y no asociados al parte.
	 * 
	 * @param idEdificio
	 *            String
	 * @param idParte
	 *            Integer
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosFichaLibres", method = RequestMethod.POST)
	public @ResponseBody
	List<Tecnicos> obtenerTecnicosFichaLibres(HttpServletRequest request,
			Long idMaquina, Integer idFicha) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosFichaLibres] : Obtener Tecnicos asociados al Usuario identificado en XLNET y asociados al edificio al que pertenece la máquina y no asociados a la ficha");

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Obtener el edificio al que pertenece la máquina
		Maquinas maquina = new Maquinas();
		maquina.setIdmaquina(idMaquina);
		maquina = this.maquinasService.find(maquina);

		String idEdificio = maquina.getIdedificio();

		List<Tecnicos> listaTecnicos = this.tecnicosService
				.obtenerTecnicosFichaLibres(idEdificio, sUIDUsuario, idFicha);

		boolean usuarioLogueadoEsRespCorrectivos = false;
		usuarioLogueadoEsRespCorrectivos = new SecurityHelpperXLNets()
				.usuarioLogueadoEsRespCorrectivos();

		if (!usuarioLogueadoEsRespCorrectivos) {
			/**
			 * MOVILGMAO Comprobamos si está presente y solo pasamos lista con
			 * técnicos presentes
			 */
			List<Tecnicos> listaTecnicosPresentes = new ArrayList<Tecnicos>();
			for (Tecnicos tecnico : listaTecnicos) {
				Presencia presenciaAux = new Presencia();
				presenciaAux.setIdtecnico(tecnico.getIdtecnico());
				if (this.presenciaService
						.comprobarTecnicoEstaPresente(presenciaAux)) {
					tecnico.setPresente(true);
				} else {
					tecnico.setPresente(false);
				}
				listaTecnicosPresentes.add(tecnico);
			}
			return listaTecnicosPresentes;
		} else {
			List<Tecnicos> listaTecnicosPresentes = new ArrayList<Tecnicos>();
			for (Tecnicos tecnico : listaTecnicos) {
				Presencia presenciaAux = new Presencia();
				presenciaAux.setIdtecnico(tecnico.getIdtecnico());
				if (this.presenciaService
						.comprobarTecnicoEstaPresente(presenciaAux)) {
					tecnico.setPresente(true);
				} else {
					tecnico.setPresente(false);
				}
				listaTecnicosPresentes.add(tecnico);
			}
			return listaTecnicos;
		}

	}

	/**
	 * Method 'obtenerTecnicosParteAsignados'.
	 * 
	 * @param idParte
	 *            Integer
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerTecnicosFichaAsignados", method = RequestMethod.POST)
	public @ResponseBody
	List<Fichatecnico> obtenerTecnicosFichaAsignados(Integer idFicha) {
		TecnicosController.logger
				.info("[GET - obtenerTecnicosFichaAsignados] : Obtener Tecnicos asignados a una ficha");
		List<Fichatecnico> listaTecnicos = this.fichatecnicosService
				.obtenerTecnicosFichaAsociados(idFicha);

		List<Fichatecnico> listaTecnicosPresentes = new ArrayList<Fichatecnico>();
		for (Fichatecnico fichatec : listaTecnicos) {
			Presencia presenciaAux = new Presencia();
			presenciaAux.setIdtecnico(fichatec.getIdtecnico());
			if (this.presenciaService
					.comprobarTecnicoEstaPresente(presenciaAux)) {
				fichatec.setPresente(true);
			} else {
				fichatec.setPresente(false);
			}
			listaTecnicosPresentes.add(fichatec);
		}

		return listaTecnicosPresentes;
	}

	@RequestMapping(value = "/restaTecnicosFicha", method = RequestMethod.POST)
	public @ResponseBody
	Fichatecnico restaTecnicosFicha(@RequestParam Integer idFicha,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Fichatecnico tecnicoFichaAux = new Fichatecnico();
		Fichatecnico elTecnicoFicha = new Fichatecnico();

		Fichatecnicosgmao tecnicoFichaGmaoAux = new Fichatecnicosgmao();
		Fichatecnicosgmao elTecnicoFichaGmao = new Fichatecnicosgmao();
		boolean tieneTecnicoGmao = false;
		List<Fichatecnicosgmao> fichaTecnicosEliminar = new ArrayList<Fichatecnicosgmao>();
		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoFicha.setIdficha(idFicha);
			elTecnicoFicha.setIdtecnico(tecnicosSeleccionados.get(i));
			TecnicosController.logger
					.info("[GET - findBy_PK] : Eliminando tecnicos en la ficha : "
							+ elTecnicoFicha.getIdtecnico());
			/* execute */
			this.fichatecnicosService.eliminaTecnicoFicha(elTecnicoFicha);

			/**
			 * MOVILGMAO
			 */
			tecnicoFichaGmaoAux = new Fichatecnicosgmao();
			elTecnicoFichaGmao = new Fichatecnicosgmao();
			tecnicoFichaGmaoAux.setIdficha(idFicha);
			tecnicoFichaGmaoAux.setIdtecnico(tecnicosSeleccionados.get(i));
			tecnicoFichaGmaoAux = this.fichatecnicosgmaoServices
					.find(tecnicoFichaGmaoAux);

			if (tecnicoFichaGmaoAux != null) {
				/*
				 * elTecnicoFichaGmao.setIdficha(idFicha);
				 * elTecnicoFichaGmao.setGuidfichatecgmao(tecnicoFichaGmaoAux
				 * .getGuidfichatecgmao());
				 * elTecnicoFichaGmao.setIdtecnico(tecnicosSeleccionados
				 * .get(i)); elTecnicoFichaGmao.setIdfichac(null);
				 * tecnicoFichaGmaoAux = this.fichatecnicosgmaoServices
				 * .update(elTecnicoFichaGmao);
				 * 
				 * fichaTecnicosEliminar.add(tecnicoFichaGmaoAux);
				 * tieneTecnicoGmao = true;
				 */

				elTecnicoFichaGmao.setIdficha(idFicha);
				elTecnicoFichaGmao.setGuidfichatecgmao(tecnicoFichaGmaoAux
						.getGuidfichatecgmao());
				elTecnicoFichaGmao.setIdtecnico(null);
				elTecnicoFichaGmao.setIdfichac(null);
				tecnicoFichaGmaoAux = this.fichatecnicosgmaoServices
						.update(elTecnicoFichaGmao);

				fichaTecnicosEliminar.add(tecnicoFichaGmaoAux);
				tieneTecnicoGmao = true;
			}

			/**
			 * FIN MOVILGMAO
			 */

		}

		TecnicosController.logger.info("[GET - RESTA TECNICOS] : TECNICOS: "
				+ tecnicosSeleccionados.size());

		/**
		 * MOVILGMAO Cuando se asigna el parte a los técnicos se debe mandar a
		 * MovilGmao para que lo tengan en su BBDD y le llegue al técnico o
		 * técnicos correspondientes
		 */
		if (tieneTecnicoGmao) {
			String urlConfig = "";
			try {
				urlConfig = this.appConfiguration.getObject().getProperty(
						"movilgmao.path");
			} catch (Exception e) {

			}
			Ficha fichaAux = new Ficha();
			fichaAux.setIdficha(idFicha);
			fichaAux = this.fichaService.find(fichaAux);
			if (fichaAux != null) {
				String idEdificio = null;
				Maquinas maquinaAux = new Maquinas();
				if (fichaAux.getIdmaquina() != null) {

					maquinaAux.setIdmaquina(fichaAux.getIdmaquina());
					maquinaAux = this.maquinasService.find(maquinaAux);

					if (maquinaAux != null
							&& maquinaAux.getIdedificio() != null) {
						idEdificio = maquinaAux.getIdedificio();
					}

					if (maquinaAux.getIdzona() != null) {
						Zonas zonaAux = new Zonas();
						zonaAux.setIdzona(maquinaAux.getIdzona());
						zonaAux = this.zonasService.find(zonaAux);
						maquinaAux.setZona(zonaAux);

					}

					if (maquinaAux.getIdplanta() != null) {
						Plantas plantaAux = new Plantas();
						plantaAux.setIdplanta(maquinaAux.getIdplanta());
						plantaAux = this.plantasService.find(plantaAux);
						maquinaAux.setPlanta(plantaAux);
					}
				}

				Edificios edifAux = new Edificios();
				if (idEdificio != null) {
					edifAux = this.edificiosService.obtenerEdificio(idEdificio);
				}

				// Obtener tecnicos asignados al parte (partetecnicos)
				tecnicoFichaGmaoAux = new Fichatecnicosgmao();
				tecnicoFichaGmaoAux.setIdficha(idFicha);
				List<Fichatecnicosgmao> fichaTecnicosGmao = this.fichatecnicosgmaoServices
						.findAllnoAsignadosMovilGmao(tecnicoFichaGmaoAux, null);

				// Obtener actuaciones asociadas al parte preventivo
				Actuacion actuacionAux = new Actuacion();
				actuacionAux.setIdficha(idFicha);
				List<Actuacion> listaActuaciones = this.actuacionService
						.obtenerActuaciones(actuacionAux, null);

				String respuesta = this.procesosJMSService
						.sincronizarPartePreventivoGmao(fichaAux, maquinaAux,
								fichaTecnicosGmao, listaActuaciones,
								edifAux.getGuidedificio(), urlConfig);

				if (respuesta != null && respuesta.equals("OK")) {
					TecnicosController.logger
							.info("[MOVILGMAO] : sincronizarPartePreventivo: "
									+ respuesta);

					/*
					 * for (Fichatecnicosgmao fichaGmaoEliminar :
					 * fichaTecnicosEliminar) { this.fichatecnicosgmaoServices
					 * .remove(fichaGmaoEliminar); }
					 */

					/*
					 * fichaTecnicosGmao =
					 * this.fichatecnicosgmaoServices.findAll(
					 * tecnicoFichaGmaoAux, null);
					 */

					/*
					 * if (fichaTecnicosGmao.size() == 0) { respuesta =
					 * this.procesosJMSService.eliminarOTpadre(
					 * fichaAux.getGuidficha(), urlConfig); }
					 */

					/**
					 * Comprobamos si el parte tiene más técnicos asignados en
					 * ese caso no dejamos el parte sin asignar en el planner y
					 * lo eliminamos
					 */
					Fichatecnicosgmao fichatecgmaoBusqAux = new Fichatecnicosgmao();
					fichatecgmaoBusqAux.setIdficha(tecnicoFichaGmaoAux
							.getIdficha());
					fichaTecnicosGmao = new ArrayList<Fichatecnicosgmao>();
					fichaTecnicosGmao = this.fichatecnicosgmaoServices
							.findAllnoAsignadosMovilGmao(tecnicoFichaGmaoAux,
									null);

					if (fichaTecnicosGmao.size() > 1) {
						int contadorTecnicos = fichaTecnicosGmao.size();
						int contadorBorrados = 1;
						for (Fichatecnicosgmao fichatecgmaoAux : fichaTecnicosGmao) {
							if (fichatecgmaoAux != null
									&& (fichatecgmaoAux.getIdtecnico() == null || fichatecgmaoAux
											.getIdtecnico() == 0)
									&& contadorBorrados != contadorTecnicos) {
								this.procesosJMSService.eliminarOTpadre(
										fichatecgmaoAux.getGuidfichatecgmao(),
										urlConfig);

								this.fichatecnicosgmaoServices
										.remove(fichatecgmaoAux);
								contadorBorrados++;
							}
						}
					}

				} else {
					TecnicosController.logger
							.error("[MOVILGMAO] : sincronizarPartePreventivo: "
									+ respuesta);
				}

			}
		}

		/**
		 * FIN MOVILGMAO
		 */

		return tecnicoFichaAux;
	}

	@RequestMapping(value = "/sumaTecnicosFicha", method = RequestMethod.POST)
	public @ResponseBody
	Fichatecnico sumaTecnicosFicha(@RequestParam Integer idFicha,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Fichatecnico tecnicoFichaAux = new Fichatecnico();
		Fichatecnico elTecnicoFicha = new Fichatecnico();

		/**
		 * MOVILGMAO
		 */
		Fichatecnicosgmao tecnicoFichaGmaoAux = new Fichatecnicosgmao();
		Fichatecnicosgmao elTecnicoFichaGmao = new Fichatecnicosgmao();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoFicha.setIdficha(idFicha);
			elTecnicoFicha.setIdtecnico(tecnicosSeleccionados.get(i));
			TecnicosController.logger
					.info("[GET - findBy_PK] : Grabando tecnicos en la ficha  : "
							+ elTecnicoFicha.getIdtecnico());

			elTecnicoFicha.setAceptada("1");
			tecnicoFichaAux = this.fichatecnicosService.add(elTecnicoFicha);

			/**
			 * MOVILGMAO Comprobamos si ya existe una ficha (parte preventivo)
			 * en gmao para este idFicha que no tenga técnico
			 */
			Tecnicos tecnicoAux = new Tecnicos();
			tecnicoAux.setIdtecnico(tecnicosSeleccionados.get(i));
			tecnicoAux = this.tecnicosService.find(tecnicoAux);
			if (tecnicoAux != null && tecnicoAux.getMovilgmao() != null
					&& tecnicoAux.getMovilgmao().equals("1")) {
				tecnicoFichaGmaoAux.setIdficha(idFicha);
				tecnicoFichaGmaoAux.setIdtecnico(tecnicosSeleccionados.get(i));
				tecnicoFichaGmaoAux.setIdfichac(null);
				tecnicoFichaGmaoAux = this.fichatecnicosgmaoServices
						.findFichaSinTecnico(tecnicoFichaGmaoAux);

				elTecnicoFichaGmao.setIdficha(idFicha);
				elTecnicoFichaGmao.setIdtecnico(tecnicosSeleccionados.get(i));
				elTecnicoFichaGmao.setIdfichac(tecnicoFichaAux.getIdfitec());
				if (tecnicoFichaGmaoAux != null) {
					elTecnicoFichaGmao.setGuidfichatecgmao(tecnicoFichaGmaoAux
							.getGuidfichatecgmao());

					tecnicoFichaGmaoAux = this.fichatecnicosgmaoServices
							.update(elTecnicoFichaGmao);
				} else {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					elTecnicoFichaGmao.setGuidfichatecgmao(randomUUIDString);
					tecnicoFichaGmaoAux = this.fichatecnicosgmaoServices
							.add(elTecnicoFichaGmao);

				}
			}
			/**
			 * FIN MOVILGMAO
			 */

			TecnicosController.logger
					.info("[GET - findBy_PK] : Grabando tecnicos en el parte preventivo de MovilGmao : "
							+ elTecnicoFichaGmao.getIdtecnico());

			/**
			 * MOVILGMAO Cuando se asigna el parte preventivo a los técnicos se
			 * debe mandar a MovilGmao para que lo tengan en su BBDD y le llegue
			 * al técnico o técnicos correspondientes
			 */
			if (tecnicoAux != null && tecnicoAux.getMovilgmao() != null
					&& tecnicoAux.getMovilgmao().equals("1")) {
				String urlConfig = "";
				try {
					urlConfig = this.appConfiguration.getObject().getProperty(
							"movilgmao.path");
				} catch (Exception e) {

				}
				Ficha fichaAux = new Ficha();
				fichaAux.setIdficha(idFicha);
				fichaAux = this.fichaService.find(fichaAux);
				if (fichaAux != null) {

					/**
					 * Comprobamos si la ficha esta finalizada para abrirla
					 */
					if (fichaAux.getEjecutado() != null
							&& fichaAux.getEjecutado().equals("1")) {
						this.fichaService.abrirFicha(fichaAux.getIdficha());
					}

					String idEdificio = null;
					Maquinas maquinaAux = new Maquinas();
					if (fichaAux.getIdmaquina() != null) {

						maquinaAux.setIdmaquina(fichaAux.getIdmaquina());
						maquinaAux = this.maquinasService.find(maquinaAux);

						if (maquinaAux != null
								&& maquinaAux.getIdedificio() != null) {
							idEdificio = maquinaAux.getIdedificio();
						}

						if (maquinaAux.getIdzona() != null) {
							Zonas zonaAux = new Zonas();
							zonaAux.setIdzona(maquinaAux.getIdzona());
							zonaAux = this.zonasService.find(zonaAux);
							maquinaAux.setZona(zonaAux);

						}

						if (maquinaAux.getIdplanta() != null) {
							Plantas plantaAux = new Plantas();
							plantaAux.setIdplanta(maquinaAux.getIdplanta());
							plantaAux = this.plantasService.find(plantaAux);
							maquinaAux.setPlanta(plantaAux);
						}
					}

					if (fichaAux.getGuidficha() == null) {
						String randomUUIDString = "";
						UUID uuid = UUID.randomUUID();
						randomUUIDString = uuid.toString();
						fichaAux.setGuidficha(randomUUIDString);
						fichaAux = this.fichaService
								.actualizarUUIDficha(fichaAux);
					}

					Edificios edifAux = new Edificios();
					if (idEdificio != null) {
						edifAux = this.edificiosService
								.obtenerEdificio(idEdificio);
					}

					// Obtener tecnicos asignados al parte preventivo
					// (fichatecnicos)
					tecnicoFichaGmaoAux = new Fichatecnicosgmao();
					tecnicoFichaGmaoAux.setIdficha(idFicha);
					List<Fichatecnicosgmao> fichaTecnicosGmao = this.fichatecnicosgmaoServices
							.findAllnoAsignadosMovilGmao(tecnicoFichaGmaoAux,
									null);

					// Obtener actuaciones asociadas al parte preventivo
					Actuacion actuacionAux = new Actuacion();
					actuacionAux.setIdficha(idFicha);
					List<Actuacion> listaActuaciones = this.actuacionService
							.obtenerActuaciones(actuacionAux, null);

					String respuesta = this.procesosJMSService
							.sincronizarPartePreventivoGmao(fichaAux,
									maquinaAux, fichaTecnicosGmao,
									listaActuaciones,
									edifAux.getGuidedificio(), urlConfig);

					if (respuesta != null && respuesta.equals("OK")) {
						TecnicosController.logger
								.info("[MOVILGMAO] : sincronizarPartePreventivo: "
										+ respuesta);
					} else {
						TecnicosController.logger
								.error("[MOVILGMAO] : sincronizarPartePreventivo: "
										+ respuesta);
					}

				}
			}

			/**
			 * FIN MOVILGMAO
			 */

		}

		TecnicosController.logger.info("[GET - SUMA TECNICOS] : TECNICOS: "
				+ tecnicosSeleccionados.size());

		return tecnicoFichaAux;
	}

	/**
	 * 
	 * Method 'getRemoteAutocompleteTecnicosUsuario'.
	 * 
	 * 
	 * 
	 * @param model
	 * 
	 * 
	 * 
	 * @return List
	 */

	@RequestMapping(value = "tecnicosUsuario/autocomplete/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Tecnicos> getRemoteAutocompleteTecnicosUsuario(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c,
			HttpServletRequest request) {
		// Idioma
		// Filtro segÃƒÂºn idioma
		Tecnicos tecnicosUsu = new Tecnicos();
		tecnicosUsu.setNombre(q);

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return tecnicosService.obtenerTecnicosDelUsuario(tecnicosUsu,
				sUIDUsuario, c);
	}

	/**
	 * 
	 * Method 'UIDPUESTOduplicado'.
	 * 
	 * 
	 * puestoIntroducido String
	 * 
	 * @return List
	 */

	@RequestMapping(value = "/UIDPUESTOduplicado", method = RequestMethod.POST)
	public @ResponseBody
	Boolean UIDPUESTOduplicado(String puestoIntroducido, int idTecnico) {

		Boolean puestoDuplicado = false;
		puestoDuplicado = this.tecnicosService.UIDPUESTOduplicado(
				puestoIntroducido, idTecnico);

		TecnicosController.logger.info("[GET - UIDPUESTOduplicado] : ");

		return puestoDuplicado;
	}
}
