package com.ejie.aa20b.control;

import com.ejie.aa20b.service.TecnicoplanifService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.Tecnicoplanif;

/**
 * TecnicoplanifController generated by UDA, 01-abr-2015 12:44:36.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/tecnicoplanif")
public class TecnicoplanifController {

	private static final Logger logger = LoggerFactory
			.getLogger(TecnicoplanifController.class);

	@Autowired
	private TecnicoplanifService tecnicoplanifService;

	@Autowired
	private UsuarioXLNETController usuarioXLNETController;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		TecnicoplanifController.logger.info("[GET - View] : tecnicoplanif");
		return "tecnicoplanif";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param uidPer
	 *            String
	 * @param idtecnico
	 *            Long
	 * @return tecnicoplanif Tecnicoplanif
	 */
	@RequestMapping(value = "/{uidPer}/{idtecnico}", method = RequestMethod.GET)
	public @ResponseBody
	Tecnicoplanif getById(@PathVariable String uidPer,
			@PathVariable Long idtecnico) {
		Tecnicoplanif tecnicoplanif = new Tecnicoplanif();
		tecnicoplanif.setUidPer(uidPer);
		tecnicoplanif.setIdtecnico(idtecnico);
		tecnicoplanif = this.tecnicoplanifService.find(tecnicoplanif);
		TecnicoplanifController.logger
				.info("[GET - findBy_PK] : Obtener Tecnicoplanif por PK");
		return tecnicoplanif;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTecnicoplanif
	 *            Tecnicoplanif
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Tecnicoplanif> getAll(@ModelAttribute Tecnicoplanif filterTecnicoplanif) {
		TecnicoplanifController.logger
				.info("[GET - find_ALL] : Obtener Tecnicoplanif por filtro");
		return this.tecnicoplanifService.findAll(filterTecnicoplanif, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tecnicoplanif
	 *            Tecnicoplanif
	 * @return Tecnicoplanif
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Tecnicoplanif edit(@RequestBody Tecnicoplanif tecnicoplanif) {
		Tecnicoplanif tecnicoplanifAux = this.tecnicoplanifService
				.update(tecnicoplanif);
		TecnicoplanifController.logger
				.info("[PUT] : Tecnicoplanif actualizado correctamente");
		return tecnicoplanifAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tecnicoplanif
	 *            Tecnicoplanif
	 * @return Tecnicoplanif
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Tecnicoplanif add(@RequestBody Tecnicoplanif tecnicoplanif) {
		Tecnicoplanif tecnicoplanifAux = this.tecnicoplanifService
				.add(tecnicoplanif);
		TecnicoplanifController.logger
				.info("[POST] : Tecnicoplanif insertado correctamente");
		return tecnicoplanifAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param uidPer
	 *            String
	 * @param idtecnico
	 *            Long
	 * @return tecnicoplanif
	 */
	@RequestMapping(value = "/{uidPer}/{idtecnico}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Tecnicoplanif remove(@PathVariable String uidPer,
			@PathVariable Long idtecnico) {
		Tecnicoplanif tecnicoplanif = new Tecnicoplanif();
		tecnicoplanif.setUidPer(uidPer);
		tecnicoplanif.setIdtecnico(idtecnico);
		this.tecnicoplanifService.remove(tecnicoplanif);
		TecnicoplanifController.logger
				.info("[DELETE] : Tecnicoplanif borrado correctamente");
		return tecnicoplanif;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tecnicoplanifIds
	 *            List
	 * @return tecnicoplanifList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> tecnicoplanifIds) {
		List<Tecnicoplanif> tecnicoplanifList = new ArrayList<Tecnicoplanif>();
		for (List<String> tecnicoplanifId : tecnicoplanifIds) {
			Iterator<String> iterator = tecnicoplanifId.iterator();
			Tecnicoplanif tecnicoplanif = new Tecnicoplanif(); // NOPMD - Objeto
																// nuevo en la
																// lista
																// (parametro
																// del servicio)
			tecnicoplanif.setUidPer(ObjectConversionManager.convert(
					iterator.next(), String.class));
			tecnicoplanif.setIdtecnico(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			tecnicoplanifList.add(tecnicoplanif);
		}
		this.tecnicoplanifService.removeMultiple(tecnicoplanifList);
		TecnicoplanifController.logger
				.info("[POST - DELETE_ALL] : Tecnicoplanif borrados correctamente");
		return tecnicoplanifIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTecnicoplanif
	 *            Tecnicoplanif
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute Tecnicoplanif filterTecnicoplanif,
			@ModelAttribute Pagination pagination) {
		List<Tecnicoplanif> tecnicoplanifs = this.tecnicoplanifService.findAll(
				filterTecnicoplanif, pagination);
		Long recordNum = this.tecnicoplanifService
				.findAllCount(filterTecnicoplanif);
		TecnicoplanifController.logger
				.info("[GET - jqGrid] : Obtener Tecnicoplanif");
		return new JQGridJSONModel(pagination, recordNum, tecnicoplanifs);
	}

	@RequestMapping(value = "/sumaTecnicosPlanif", method = RequestMethod.POST)
	public @ResponseBody
	Tecnicoplanif sumaTecnicosPlanif(
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Tecnicoplanif usutecnicosAux = new Tecnicoplanif();
		Tecnicoplanif elTecnicoplanif = new Tecnicoplanif();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoplanif.setUidPer(sUIDUsuario);
			elTecnicoplanif.setIdtecnico(tecnicosSeleccionados.get(i));
			TecnicoplanifController.logger
					.info("[GET - suma Tecnicoplanif] : Grabando tecnicos usuario para Planificar : "
							+ elTecnicoplanif.getIdtecnico());

			usutecnicosAux = this.tecnicoplanifService.add(elTecnicoplanif);
		}

		TecnicoplanifController.logger
				.info("[GET - SUMA Tecnicoplanif] : Tecnicoplanif: "
						+ tecnicosSeleccionados.size());

		return usutecnicosAux;
	}

	@RequestMapping(value = "/restaTecnicosPlanif", method = RequestMethod.POST)
	public @ResponseBody
	Tecnicoplanif restaTecnicosPlanif(
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {
		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Tecnicoplanif TecnicoplanifAux = new Tecnicoplanif();
		Tecnicoplanif elTecnicoplanif = new Tecnicoplanif();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			elTecnicoplanif.setUidPer(sUIDUsuario);
			elTecnicoplanif.setIdtecnico(tecnicosSeleccionados.get(i));

			this.tecnicoplanifService.remove(elTecnicoplanif);
		}

		TecnicoplanifController.logger
				.info("[GET - RESTA Tecnicoplanif] : Elimina tecnico de la planificacion : "
						+ tecnicosSeleccionados.size());

		return TecnicoplanifAux;
	}

}
