package com.ejie.aa20b.control;

import com.ejie.aa20b.service.TecnicoEdifService;
import com.ejie.aa20b.service.ZonasService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.model.TecnicoEdif;
import com.ejie.aa20b.model.Zonas;

/**
 * TecnicoEdifController generated by UDA, 22-dic-2014 10:12:00.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/tecnicoedif")
public class TecnicoEdifController {

	private static final Logger logger = LoggerFactory
			.getLogger(TecnicoEdifController.class);

	@Autowired
	private TecnicoEdifService tecnicoEdifService;

	@Autowired
	private ZonasService zonasService;

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		TecnicoEdifController.logger.info("[GET - View] : tecnicoedif");
		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroTecnicosEdif");

		return "tecnicoedif";
	}

	/**
	 * Method 'maintVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintVolver", method = RequestMethod.GET)
	public String maintVolver(Model model, HttpServletRequest request) {
		TecnicoEdifController.logger.info("[GET - View] : tecnicoedif");
		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		TecnicoEdif tecnicoEdifFiltro = (TecnicoEdif) request.getSession()
				.getAttribute("FiltroTecnicosEdif");

		model.addAttribute("FiltroTecnicoEdif", tecnicoEdifFiltro);

		return "tecnicoedif";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idtecnico
	 *            Long
	 * @param idedificio
	 *            String
	 * @return tecnicoEdif TecnicoEdif
	 */
	@RequestMapping(value = "/{idtecnico}/{idedificio}", method = RequestMethod.GET)
	public @ResponseBody
	TecnicoEdif getById(@PathVariable Long idtecnico,
			@PathVariable String idedificio) {
		TecnicoEdif tecnicoEdif = new TecnicoEdif();
		tecnicoEdif.setIdtecnico(idtecnico);
		tecnicoEdif.setIdedificio(idedificio);
		tecnicoEdif = this.tecnicoEdifService.find(tecnicoEdif);
		TecnicoEdifController.logger
				.info("[GET - findBy_PK] : Obtener TecnicoEdif por PK");
		return tecnicoEdif;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterTecnicoEdif
	 *            TecnicoEdif
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<TecnicoEdif> getAll(@ModelAttribute TecnicoEdif filterTecnicoEdif) {
		TecnicoEdifController.logger
				.info("[GET - find_ALL] : Obtener TecnicoEdif por filtro");
		return this.tecnicoEdifService.findAll(filterTecnicoEdif, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return TecnicoEdif
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	TecnicoEdif edit(@RequestBody TecnicoEdif tecnicoEdif) {
		TecnicoEdif tecnicoEdifAux = this.tecnicoEdifService
				.update(tecnicoEdif);
		TecnicoEdifController.logger
				.info("[PUT] : TecnicoEdif actualizado correctamente");
		return tecnicoEdifAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param tecnicoEdif
	 *            TecnicoEdif
	 * @return TecnicoEdif
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	TecnicoEdif add(@RequestBody TecnicoEdif tecnicoEdif) {
		TecnicoEdif tecnicoEdifAux = this.tecnicoEdifService.add(tecnicoEdif);
		TecnicoEdifController.logger
				.info("[POST] : TecnicoEdif insertado correctamente");
		return tecnicoEdifAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idtecnico
	 *            Long
	 * @param idedificio
	 *            String
	 * @return tecnicoEdif
	 */
	@RequestMapping(value = "/{idtecnico}/{idedificio}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	TecnicoEdif remove(@PathVariable Long idtecnico,
			@PathVariable String idedificio) {
		TecnicoEdif tecnicoEdif = new TecnicoEdif();
		tecnicoEdif.setIdtecnico(idtecnico);
		tecnicoEdif.setIdedificio(idedificio);
		this.tecnicoEdifService.remove(tecnicoEdif);
		TecnicoEdifController.logger
				.info("[DELETE] : TecnicoEdif borrado correctamente");
		return tecnicoEdif;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param tecnicoEdifIds
	 *            List
	 * @return tecnicoEdifList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> tecnicoEdifIds) {
		List<TecnicoEdif> tecnicoEdifList = new ArrayList<TecnicoEdif>();
		for (List<String> tecnicoEdifId : tecnicoEdifIds) {
			Iterator<String> iterator = tecnicoEdifId.iterator();
			TecnicoEdif tecnicoEdif = new TecnicoEdif(); // NOPMD - Objeto nuevo
															// en la lista
															// (parametro del
															// servicio)
			tecnicoEdif.setIdtecnico(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			tecnicoEdif.setIdedificio(ObjectConversionManager.convert(
					iterator.next(), String.class));
			tecnicoEdifList.add(tecnicoEdif);
		}
		this.tecnicoEdifService.removeMultiple(tecnicoEdifList);
		TecnicoEdifController.logger
				.info("[POST - DELETE_ALL] : TecnicoEdif borrados correctamente");
		return tecnicoEdifIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterTecnicoEdif
	 *            TecnicoEdif
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute TecnicoEdif filterTecnicoEdif,
			@ModelAttribute Pagination pagination, HttpServletRequest request) {
		List<TecnicoEdif> tecnicoEdifs = this.tecnicoEdifService.findAllLike(
				filterTecnicoEdif, pagination, false);
		Long recordNum = this.tecnicoEdifService.findAllLikeCount(
				filterTecnicoEdif, false);
		TecnicoEdifController.logger
				.info("[GET - jqGrid] : Obtener TecnicoEdif");

		request.getSession().setAttribute("FiltroTecnicosEdif",
				filterTecnicoEdif);

		return new JQGridJSONModel(pagination, recordNum, tecnicoEdifs);
	}

	/**
	 * Method 'buscaZonasEdificioTecnicoLibres'.
	 * 
	 * @param codEdificio
	 *            String
	 * @return ArrayList<Zonas>
	 */
	@RequestMapping(value = "/buscaZonasEdificioTecnicoLibres", method = RequestMethod.POST)
	public @ResponseBody
	List<Zonas> buscaZonasEdificioTecnicoLibres(String codEdificio,
			Long idTecnico, Model model, HttpServletRequest request) {
		String language = "es";
		TecnicoEdifController.logger
				.info("[GET - BUSCA ZONAS] : BUSCA ZONAS DE ESTRUCTURA edificio no asignadas al tecnico: ");
		List<Zonas> zonasLibres = zonasService.buscaZonasEdificioTecnicoLibres(
				codEdificio, idTecnico, language);
		return zonasLibres;
	}

	/**
	 * Method 'buscaZonasEdificioTecnicoOcupadas'.
	 * 
	 * @param codEdificio
	 *            String
	 * @return ArrayList<Zonas>
	 */
	@RequestMapping(value = "/buscaZonasEdificioTecnicoOcupadas", method = RequestMethod.POST)
	public @ResponseBody
	List<Zonas> buscaZonasEdificioTecnicoOcupadas(String codEdificio,
			Long idTecnico, Model model, HttpServletRequest request) {
		String language = "es";
		TecnicoEdifController.logger
				.info("[GET - BUSCA ZONAS] : BUSCA ZONAS DE ESTRUCTURA edificio asignadas al tecnico: ");
		List<Zonas> zonasOcupadas = zonasService
				.buscaZonasEdificioTecnicoOcupadas(codEdificio, idTecnico,
						language);
		return zonasOcupadas;
	}

	@RequestMapping(value = "/sumaZonasEdifTec", method = RequestMethod.POST)
	public @ResponseBody
	TecnicoEdif sumaZonasEdifTec(@RequestParam String codEdificio,
			@RequestParam Long idTecnico,
			@RequestParam ArrayList<Integer> zonasSeleccionadas, Model model,
			HttpServletRequest request) {

		TecnicoEdif tecnicoEdif = new TecnicoEdif();
		TecnicoEdif tecnicoEdifAux = new TecnicoEdif();

		for (int i = 0; i < zonasSeleccionadas.size(); i++) {

			tecnicoEdif.setIdedificio(codEdificio);
			tecnicoEdif.setIdzona(zonasSeleccionadas.get(i));
			tecnicoEdif.setIdtecnico(idTecnico);
			tecnicoEdif.setBaja("0");

			TecnicoEdifController.logger
					.info("[GET - findBy_PK] : Grabando zona Edificio Tecnico: ");

			tecnicoEdifAux = this.tecnicoEdifService.add(tecnicoEdif);
		}
		if (zonasSeleccionadas.size() > 0) {
			// Como ya se ha asociado una zona concreta ya no puede existir un
			// registro para ese edificio y tecnico con IDZONA=0. Por lo tanto
			// se elimina ese registro si existe
			TecnicoEdif tecnicoEdifElim = new TecnicoEdif();
			tecnicoEdifElim.setIdedificio(codEdificio);
			tecnicoEdifElim.setIdtecnico(idTecnico);
			tecnicoEdifElim.setIdzona(Aa20bConstantes.SIN_ZONAS);
			this.tecnicoEdifService.remove(tecnicoEdifElim);
		}
		TecnicoEdifController.logger.info("[GET - SUMA ZONAS] : ZONAS: "
				+ zonasSeleccionadas.size());

		return tecnicoEdifAux;
	}

	@RequestMapping(value = "/restaZonasEdifTec", method = RequestMethod.POST)
	public @ResponseBody
	TecnicoEdif restaZonasEdifTec(@RequestParam String codEdificio,
			@RequestParam Long idTecnico,
			@RequestParam ArrayList<Integer> zonasSeleccionadas, Model model,
			HttpServletRequest request) {

		TecnicoEdif tecnicoEdifAux = new TecnicoEdif();
		TecnicoEdif laTecnicoEdif = new TecnicoEdif();

		for (int i = 0; i < zonasSeleccionadas.size(); i++) {

			laTecnicoEdif.setIdedificio(codEdificio);
			laTecnicoEdif.setIdzona(zonasSeleccionadas.get(i));
			laTecnicoEdif.setIdtecnico(idTecnico);
			TecnicoEdifController.logger
					.info("[GET - findBy_PK] : Borrando registro restaZonasEdifTec: ");

			this.tecnicoEdifService.remove(laTecnicoEdif);
		}

		// Si despues de eliminar las zonas seleccionadas ya no queda ninguna
		// debemos meter un registro con el edificio, tecnico y IDZONA=0
		// Para indicar que va a tener acceso a todas las zonas.
		TecnicoEdif tecnicoEdifElim = new TecnicoEdif();
		tecnicoEdifElim.setIdedificio(codEdificio);
		tecnicoEdifElim.setIdtecnico(idTecnico);

		List<TecnicoEdif> listaTecEdif = this.tecnicoEdifService.findAll(
				tecnicoEdifElim, null);
		if (listaTecEdif.size() == 0) {
			// Añadir registro
			tecnicoEdifElim.setIdzona(Aa20bConstantes.SIN_ZONAS);
			tecnicoEdifElim.setBaja("0");
			this.tecnicoEdifService.add(tecnicoEdifElim);
		}
		return tecnicoEdifAux;
	}

	@RequestMapping(value = "/comprobarEdificioTieneZonaTecnico", method = RequestMethod.POST)
	public @ResponseBody
	String comprobarEdificioTieneZonaTecnico(@RequestParam Long idTecnico,
			@RequestParam ArrayList<String> edificiosSeleccionados,
			Model model, HttpServletRequest request) {
		TecnicoEdifController.logger
				.info("[POST - comprobarEdificioTieneZonaTecnico] : Comprobar si el tecnico tiene asignadas zonas del edificio que se va a desasociar: ");

		for (int i = 0; i < edificiosSeleccionados.size(); i++) {
			List<TecnicoEdif> listaTecEdif = this.tecnicoEdifService
					.comprobarTecnicoZonasEdificio(idTecnico,
							edificiosSeleccionados.get(i));
			if (listaTecEdif.size() > 0) {
				return "Hay zonas";
			}
		}

		return "";
	}
}
