package com.ejie.aa20b.control;

import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.CodigoService;
import com.ejie.aa20b.service.ServiciosService;
import com.ejie.aa20b.service.TecnicosService;
import com.ejie.aa20b.service.UsuariosService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Servicios;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Usuarios;

/**
 * ServiciosController generated by UDA, 16-sep-2015 9:53:12.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/servicios")
public class ServiciosController {

	private static final Logger logger = LoggerFactory
			.getLogger(ServiciosController.class);

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private ServiciosService serviciosService;

	@Autowired
	private UsuariosService usuariosService;

	@Autowired
	private TecnicosService tecnicosService;

	@Autowired
	private CodigoService codigosService;

	@Autowired
	private Aa20bProcesosJMSService procesosJMSService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ServiciosController.logger.info("[GET - View] : servicios");
		return "servicios";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idservicio
	 *            Long
	 * @return servicios Servicios
	 */
	@RequestMapping(value = "/{idservicio}", method = RequestMethod.GET)
	public @ResponseBody
	Servicios getById(@PathVariable Long idservicio) {
		Servicios servicios = new Servicios();
		servicios.setIdservicio(idservicio);
		servicios = this.serviciosService.find(servicios);
		ServiciosController.logger
				.info("[GET - findBy_PK] : Obtener Servicios por PK");
		return servicios;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterServicios
	 *            Servicios
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Servicios> getAll(@ModelAttribute Servicios filterServicios) {
		ServiciosController.logger
				.info("[GET - find_ALL] : Obtener Servicios por filtro");
		return this.serviciosService.findAll(filterServicios, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param servicios
	 *            Servicios
	 * @return Servicios
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Servicios edit(@RequestBody Servicios servicios) {
		Servicios serviciosAux = this.serviciosService.update(servicios);
		ServiciosController.logger
				.info("[PUT] : Servicios actualizado correctamente");
		return serviciosAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param servicios
	 *            Servicios
	 * @return Servicios
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Servicios add(@RequestBody Servicios servicios) {
		Servicios serviciosAux = this.serviciosService.add(servicios);
		ServiciosController.logger
				.info("[POST] : Servicios insertado correctamente");
		return serviciosAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idservicio
	 *            Long
	 * @return servicios
	 */
	@RequestMapping(value = "/{idservicio}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Servicios remove(@PathVariable Long idservicio) {
		Servicios servicios = new Servicios();
		servicios.setIdservicio(idservicio);
		this.serviciosService.remove(servicios);
		ServiciosController.logger
				.info("[DELETE] : Servicios borrado correctamente");
		return servicios;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param serviciosIds
	 *            List
	 * @return serviciosList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> serviciosIds) {
		List<Servicios> serviciosList = new ArrayList<Servicios>();
		for (List<String> serviciosId : serviciosIds) {
			Iterator<String> iterator = serviciosId.iterator();
			Servicios servicios = new Servicios(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			servicios.setIdservicio(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			serviciosList.add(servicios);
		}
		this.serviciosService.removeMultiple(serviciosList);
		ServiciosController.logger
				.info("[POST - DELETE_ALL] : Servicios borrados correctamente");
		return serviciosIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterServicios
	 *            Servicios
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Servicios filterServicios,
			@ModelAttribute Pagination pagination) {
		List<Servicios> servicioss = this.serviciosService.findAll(
				filterServicios, pagination);
		Long recordNum = this.serviciosService.findAllCount(filterServicios);
		ServiciosController.logger.info("[GET - jqGrid] : Obtener Servicios");
		return new JQGridJSONModel(pagination, recordNum, servicioss);
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/modificar", method = RequestMethod.GET)
	public String getCreateFormModficar(Model model, HttpServletRequest request) {
		ServiciosController.logger.info("[GET - View] : modificar servicio");

		Long idServicio = Long.parseLong(request.getParameter("idServicio"));

		ServiciosController.logger
				.info("[GET - View] : modificar Servicio : servicio: "
						+ idServicio);

		Servicios servicio = this.getById(idServicio);

		ServiciosController.logger.info("[GET - View] : modificar servicio : "
				+ servicio.toString());

		/*
		 * TipoIncidenciasController.logger
		 * .info("[TIPO INCIDENCIA EN MODIFICAR : " +
		 * tipoIncidencia.getCodTipo());
		 */
		model.addAttribute("Servicio", servicio);

		request.setAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		return "editarServicio";
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param servicio
	 *            Servicio
	 * @return Servicio
	 */
	@RequestMapping(value = "/modificaServicio", method = RequestMethod.POST)
	public @ResponseBody
	Servicios modificaServicio(@RequestBody Servicios servicio) {

		ServiciosController.logger.info("[POST] : MODIFY : Valor de Baja : "
				+ servicio.getBaja());

		/**
		 * GMAO Comprobaremos si el espacio no se encontraba de baja. Relleno
		 */
		boolean sincronizarTodosServiciosGmao = false;
		boolean sincronizarServicioGmao = true;
		Servicios servicioBaja = this.getById(servicio.getIdservicio());
		/***/

		if (servicio.getBaja() == null) {

			/**
			 * GMAO Si estaba de baja significa que se ha puesto de alta ahora y
			 * hay que sincronizar con Gmao
			 */
			if (servicioBaja.getBaja() != null
					&& servicioBaja.getBaja().equals("1")) {
				sincronizarTodosServiciosGmao = true;
			}

			servicio.setBaja("0");
		} else {

			/**
			 * GMAO Si no estaba de baja significa que se ha puesto de baja
			 * ahora y hay que sincronizar con Gmao
			 */
			if (servicioBaja.getBaja() == null
					|| (servicioBaja.getBaja() != null && servicioBaja
							.getBaja().equals("0"))) {
				sincronizarTodosServiciosGmao = true;
			} else {
				// Si estaba de baja y sigue de baja no actualizamos GMAO
				sincronizarServicioGmao = false;
			}
			/***/

			servicio.setBaja("1");
		}

		ServiciosController.logger
				.info("[PUT] : Servicio antes de modificar : "
						+ servicio.toString());
		Servicios servicioAux = this.serviciosService.update(servicio);
		ServiciosController.logger
				.info("[PUT] : Servicio actualizado correctamente");

		/**
		 * GMAO - Si la actualización del servicio ha ido bien, generamos un
		 * mensaje en la cola para actualizar la entidad 'estancia' en BBDD
		 * movilgmao. Si se ha puesto de baja, se deben sincronizar todas las
		 * entidades 'estancia'
		 */
		if (sincronizarTodosServiciosGmao) {
			Servicios servicioFilter = new Servicios();
			servicioFilter.setBaja("0");
			List<Servicios> servicios = this.serviciosService.findAll(
					servicioFilter, null);

			/**
			 * GMAO Sincronizacion de todos los servicios
			 */
			String urlConfig = "";
			try {
				urlConfig = this.appConfiguration.getObject().getProperty(
						"movilgmao.path");
			} catch (Exception e) {

			}
			this.procesosJMSService.sincronizarTodosServiciosGmao(servicios,
					Aa20bConstantes.COLA, urlConfig);
		} else {

			if (sincronizarServicioGmao) {
				ServiciosController.logger
						.info("[JMS] notificar modificación servicio movilgmao");

				this.procesosJMSService.sincronizarServicioGmao(servicio);
			}

		}

		return servicioAux;

	}

	@RequestMapping(value = "/addNuevaServicio", method = RequestMethod.POST)
	public @ResponseBody
	Servicios addNuevaServicio(@RequestBody Servicios servicio, Model model) {

		ServiciosController.logger.info("[POST] : ENTRAMOS EN ADD servicio");

		ServiciosController.logger.info("[POST] : ADD : servicio : "
				+ servicio.toString());
		servicio.setBaja("0");
		Servicios servicioAux = this.serviciosService.add(servicio);
		ServiciosController.logger
				.info("[POST] : servicio insertado correctamente");

		return servicioAux;
	}

	/**
	 * Method 'getCreateForm2'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "nuevo", method = RequestMethod.GET)
	public String getCreateForm2(Model model, HttpServletRequest request) {
		ServiciosController.logger.info("[GET - View] : nuevo Servicio");
		model.addAttribute("accion", Aa20bConstantes.ACCION_NUEVO);

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);
		return "editarServicio";
	}

	/**
	 * Method 'obtenerServicios'.
	 * 
	 * @param filterServicio
	 *            Servicios
	 * @return List
	 */
	@RequestMapping(value = "obtenerServicios", method = RequestMethod.POST)
	public @ResponseBody
	List<Servicios> obtenerServicios(@ModelAttribute Servicios filterServicio) {
		ServiciosController.logger
				.info("[GET - obtenerServicios] : Obtener Servicios ");
		return this.serviciosService.findAll(filterServicio, null);
	}

	/**
	 * Method 'obtenerServiciosNoCero'.
	 * 
	 * @param filterServicio
	 *            Servicios
	 * @return List
	 */
	@RequestMapping(value = "obtenerServiciosNoCero", method = RequestMethod.POST)
	public @ResponseBody
	List<Servicios> obtenerServiciosNoCero(
			@ModelAttribute Servicios filterServicio) {
		ServiciosController.logger
				.info("[GET - obtenerServiciosNoCero] : Obtener Servicios ");
		return this.serviciosService.obtenerServiciosNoCero(filterServicio);
	}

	/**
	 * Method 'obtenerServiciosAlta'.
	 * 
	 * @param filterServicio
	 *            Servicios
	 * @return List
	 */
	@RequestMapping(value = "obtenerServiciosAlta", method = RequestMethod.POST)
	public @ResponseBody
	List<Servicios> obtenerServiciosAlta(
			@ModelAttribute Servicios filterServicio) {
		ServiciosController.logger
				.info("[GET - obtenerServicios] : Obtener Servicios ");
		filterServicio.setBaja("0");
		return this.serviciosService.findAll(filterServicio, null);
	}

	/**
	 * Method 'obtenerServiciosAltaGama'.
	 * 
	 * @param filterServicio
	 *            Servicios
	 * @return List
	 */
	@RequestMapping(value = "obtenerServiciosAltaNoCero", method = RequestMethod.POST)
	public @ResponseBody
	List<Servicios> obtenerServiciosAltaGama(
			@ModelAttribute Servicios filterServicio) {
		ServiciosController.logger
				.info("[GET - obtenerServiciosAltaGama] : Obtener Servicios ");
		filterServicio.setBaja("0");
		return this.serviciosService.obtenerServiciosNoCero(filterServicio);
	}

	/**
	 * 
	 * Method 'permitirBajaServicio'.
	 * 
	 * 
	 * puestoIntroducido String
	 * 
	 * @return List
	 */

	@RequestMapping(value = "/permitirBajaServicio", method = RequestMethod.POST)
	public @ResponseBody
	Boolean permitirBajaServicio(Integer idServicio) {

		// Comprobar si hay usuarios asociados al servicio
		Usuarios usuarioServicio = new Usuarios();
		usuarioServicio.setIdservicio(idServicio);
		if (this.usuariosService.findAll(usuarioServicio, null).size() > 0) {
			return false;
		}

		// Comprobar si hay tecnicos asociados al servicio
		Tecnicos tecnicos = new Tecnicos();
		tecnicos.setIdservicio(idServicio);
		if (this.tecnicosService.findAll(tecnicos, null).size() > 0) {
			return false;
		}

		// Comprobar si hay codigos de parte asociados al servicio
		Codigo codigos = new Codigo();
		codigos.setIdservicio(idServicio);
		if (this.codigosService.findAll(codigos, null).size() > 0) {
			return false;
		}

		ServiciosController.logger.info("[POST - permitirBajaServicio] : ");

		return true;
	}

}
