package com.ejie.aa20b.control;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;

import com.ejie.aa20b.classes.OtLogGmao;
import com.ejie.aa20b.model.Aa20bUsuarioXLNET;
import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Departamentos;
import com.ejie.aa20b.model.Direcciones;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Espacio;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Fichaejecucion;
import com.ejie.aa20b.model.Fichafirma;
import com.ejie.aa20b.model.Fichatecnico;
import com.ejie.aa20b.model.Fichatecnicosgmao;
import com.ejie.aa20b.model.Gamas;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.Parteejecucion;
import com.ejie.aa20b.model.Partefirma;
import com.ejie.aa20b.model.Partepdf;
import com.ejie.aa20b.model.Parteplano;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.Partetecgmaorechazo;
import com.ejie.aa20b.model.Partetecnicos;
import com.ejie.aa20b.model.Partetecnicosgmao;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.Presencia;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Usuarios;
import com.ejie.aa20b.model.Usutecnicos;
import com.ejie.aa20b.model.Zonas;
import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.Aa20bUsuarioXLNETService;
import com.ejie.aa20b.service.ActuacionService;
import com.ejie.aa20b.service.CodigoService;
import com.ejie.aa20b.service.DepartamentosService;
import com.ejie.aa20b.service.DireccionesService;
import com.ejie.aa20b.service.EdificiosService;
import com.ejie.aa20b.service.EspacioService;
import com.ejie.aa20b.service.FichaService;
import com.ejie.aa20b.service.FichaejecucionService;
import com.ejie.aa20b.service.FichafirmaService;
import com.ejie.aa20b.service.FichatecnicoService;
import com.ejie.aa20b.service.FichatecnicosgmaoService;
import com.ejie.aa20b.service.GamasService;
import com.ejie.aa20b.service.MaquinasService;
import com.ejie.aa20b.service.ParteejecucionService;
import com.ejie.aa20b.service.PartefirmaService;
import com.ejie.aa20b.service.PartepdfService;
import com.ejie.aa20b.service.ParteplanoService;
import com.ejie.aa20b.service.PartesService;
import com.ejie.aa20b.service.PartetecnicosService;
import com.ejie.aa20b.service.PartetecnicosgmaoService;
import com.ejie.aa20b.service.PlantasService;
import com.ejie.aa20b.service.PresenciaService;
import com.ejie.aa20b.service.TecnicosService;
import com.ejie.aa20b.service.UsuariosService;
import com.ejie.aa20b.service.UsutecnicosService;
import com.ejie.aa20b.service.ZonasService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.json.JSONArray;
import com.ejie.x38.json.JSONObject;
import com.ejie.x38.util.DateTimeManager;

@Component("ProcesosGmaoTareasController")
public class ProcesosGmaoTareasController {

	private static final Logger logger = LoggerFactory
			.getLogger(ProcesosGmaoTareasController.class);

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private Aa20bProcesosJMSService procesosJMSService;

	@Autowired
	private PartetecnicosgmaoService partetecnicosgmaoServices;

	@Autowired
	private ParteejecucionService parteejecucionServices;

	@Autowired
	private PartetecnicosService partetecnicosService;

	@Autowired
	private PartefirmaService partefirmaService;

	@Autowired
	private PartesService partesService;

	@Autowired
	private EdificiosService edificiosService;

	@Autowired
	private FichaService fichasService;

	@Autowired
	private FichafirmaService fichafirmaService;

	@Autowired
	private ActuacionService actuacionServices;

	@Autowired
	private FichatecnicoService fichatecnicosService;

	@Autowired
	private FichatecnicosgmaoService fichatecnicosgmaoServices;

	@Autowired
	private GamasService gamasService;

	@Autowired
	private CodigoService codigoService;

	@Autowired
	private MaquinasService maquinasService;

	@Autowired
	private UsuariosService usuariosService;

	@Autowired
	private FichaejecucionService fichaejecucionServices;

	@Autowired
	private DepartamentosService departamentosService;

	@Autowired
	private DireccionesService direccionesService;

	@Autowired
	private UsutecnicosService usuTecnicosService;

	@Autowired
	private PresenciaService presenciaService;

	@Autowired
	private TecnicosService tecnicosService;

	@Autowired
	private ParteplanoService parteplanoService;

	@Autowired
	private PlantasService plantasService;

	@Autowired
	private ZonasService zonasService;

	@Autowired
	private EspacioService espaciosService;

	@Autowired
	private CodigoService codigosService;

	@Autowired
	private ActuacionService actuacionService;

	@Autowired
	private PartepdfService partepdfService;

	@InitBinder
	protected void initBinder(HttpServletRequest request,
			ServletRequestDataBinder binder) throws ServletException {
		binder.registerCustomEditor(byte[].class,
				new ByteArrayMultipartFileEditor());
		binder.registerCustomEditor(
				Date.class,
				new CustomDateEditor(DateTimeManager
						.getDateTimeFormat(LocaleContextHolder.getLocale()),
						true));
	}

	public void tareaComprobarPartesUrgentes() {

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuesta = "OK";

		if (urlConfig != null && !urlConfig.equals("")
				&& urlConfig.indexOf("ejiedes") == -1) {
			ProcesosGmaoTareasController.logger
					.info("[tareaSincronizarTodasOTs] : procesosGmao - Comprobar partes urgentes- inicio");

			/**
			 * Obtenemos los partes urgentes que hayan sido enviados a
			 * dispositivo móvil y estén en un estado inicial y sin aceptar
			 */
			List<Partetecnicosgmao> listapartes = new ArrayList<Partetecnicosgmao>();
			listapartes = this.partetecnicosgmaoServices
					.obtenerPartesUrgentesPendientes();

			if (listapartes.size() > 0) {
				ProcesosGmaoTareasController.logger
						.info("Tenemos partes urgentes : " + listapartes.size());
				/**
				 * Comprobamos que en gmao no haya aceptado ya
				 */
				for (Partetecnicosgmao partetecnicosgmaoAux : listapartes) {
					JSONObject ot = new JSONObject();
					ot.put("UUIdOt", "{"
							+ partetecnicosgmaoAux.getGuidpartetecgmao()
									.toUpperCase() + "}");
					String respuestaOT = "";
					respuestaOT = this.procesosJMSService.bajarOtByGUID(ot,
							urlConfig + Aa20bConstantes.URL_BAJAR_OTS_GUID);

					JSONObject resp = new JSONObject(respuestaOT);
					JSONArray ots = new JSONArray();
					ots = resp.getJSONArray("ots");

					if (ots.length() > 0) {
						JSONObject otComprobar = ots.getJSONObject(0);
						String aceptada = "";
						if (otComprobar.get("Aceptada") != JSONObject.NULL) {
							aceptada = otComprobar.get("Aceptada").toString();
						}
						ProcesosGmaoTareasController.logger
								.info("valor de aceptada: " + aceptada);
						// Si no está aceptada comprobamos la fecha del parte
						// para saber si han pasado 2 minutos
						if (!aceptada.equals("1")) {

							/**
							 * Comprobamos el parte para saber si lo ha puesto
							 * en curso, pausa o finalizado sin haberlo aceptado
							 */
							String idEstadoActual = "";
							if (otComprobar.get("IdEstado") != JSONObject.NULL) {
								idEstadoActual = otComprobar
										.getString("IdEstado");
							}

							if (idEstadoActual.equals("")
									|| idEstadoActual
											.equals(Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO)) {
								boolean rechazado = false;
								if (aceptada.equals("0")) {
									// Se ha rechazado
									rechazado = true;
								}
								ProcesosGmaoTareasController.logger
										.info("Valor de rechazado: "
												+ rechazado);
								String fechaenviostr = "";
								double segundos = 0;
								if (otComprobar.get("FechaPlanificacion") != JSONObject.NULL) {
									fechaenviostr = otComprobar
											.getString("FechaPlanificacion");
									SimpleDateFormat sdf = new SimpleDateFormat(
											"yyyy-MM-dd HH:mm:ss");
									Date fechaenvioparte = null;
									Date fechaActual = new Date();
									try {
										fechaenvioparte = sdf
												.parse(fechaenviostr);
									} catch (ParseException e) {
										ProcesosGmaoTareasController.logger
												.error("[MOVILGMAO] : tareaComprobarPartesUrgentes - formatear fecha envio parte : "
														+ e.getMessage());
									}

									long fechaInicialMs = fechaenvioparte
											.getTime();
									long fechaFinalMs = fechaActual.getTime();
									long diferencia = fechaFinalMs
											- fechaInicialMs;
									segundos = Math.floor(diferencia / 1000);

								} else {
									if (otComprobar.get("FechaSolicitud") != JSONObject.NULL) {
										fechaenviostr = otComprobar
												.getString("FechaSolicitud");
										SimpleDateFormat sdf = new SimpleDateFormat(
												"yyyy-MM-dd HH:mm:ss");
										Date fechaenvioparte = null;
										Date fechaActual = new Date();
										try {
											fechaenvioparte = sdf
													.parse(fechaenviostr);
										} catch (ParseException e) {
											ProcesosGmaoTareasController.logger
													.error("[MOVILGMAO] : tareaComprobarPartesUrgentes - formatear fecha envio parte : "
															+ e.getMessage());
										}

										long fechaInicialMs = fechaenvioparte
												.getTime();
										long fechaFinalMs = fechaActual
												.getTime();
										long diferencia = fechaFinalMs
												- fechaInicialMs;
										segundos = Math
												.floor(diferencia / 1000);
									} else {
										segundos = Aa20bConstantes.SEGUNDOS_URGENTES_SUPERIOR; // tiene
																								// que
																								// ser
																								// mayor
										// al número siguiente
									}
								}
								/**
								 * Si han pasado 5 o más minutos o se ha
								 * rechazado el parte, se tiene que reasignar el
								 * parte
								 */

								// Comprobar que el parte no tiene más técnicos
								// asignados, y que alguno de los técnicos ya
								// haya
								// aceptado el parte

								if (segundos >= Aa20bConstantes.SEGUNDOS_URGENTES
										|| rechazado) {

									/**
									 * Eliminamos el técnico asociado al parte
									 * (PARTETEC)
									 */
									Partetecnicos parteTecQuitar = new Partetecnicos();
									parteTecQuitar
											.setIdtecnico(partetecnicosgmaoAux
													.getIdtecnico());
									parteTecQuitar
											.setIdparte(partetecnicosgmaoAux
													.getIdparte());
									this.partetecnicosService
											.eliminaTecnicoParte(parteTecQuitar);
									ProcesosGmaoTareasController.logger
											.info("Tecnico parte eliminado. Parte: "
													+ parteTecQuitar
															.getIdparte()
													+ " - Tecnico: "
													+ parteTecQuitar
															.getIdtecnico());

									/**
									 * Comprobamos si el técnico ya había
									 * rechazado o no aceptado el parte con
									 * anterioridad
									 */
									Partetecgmaorechazo partetecrechazoAux = new Partetecgmaorechazo();
									partetecrechazoAux
											.setIdparte(partetecnicosgmaoAux
													.getIdparte());
									partetecrechazoAux
											.setIdtecnico(partetecnicosgmaoAux
													.getIdtecnico());

									Partetecgmaorechazo partetecrechazoAuxBusq = this.partetecnicosgmaoServices
											.findRechazoTec(partetecrechazoAux);

									if (partetecrechazoAuxBusq == null) {
										/**
										 * Guardamos en la tabla de rechazos o
										 * no aceptaciones la info del parte y
										 * técnico para que no se le vuelva a
										 * asignar
										 */

										partetecrechazoAux = this.partetecnicosgmaoServices
												.addRechazoTec(partetecrechazoAux);
										ProcesosGmaoTareasController.logger
												.info("Rechazo anadido : "
														+ partetecrechazoAux
																.getIdparte());
									}

									/**
									 * Obtenemos tecnicos del servicio y
									 * edificio
									 */
									Partes parteAux = new Partes();
									parteAux.setIdparte(partetecnicosgmaoAux
											.getIdparte());
									parteAux = this.partesService
											.find(parteAux);
									List<Usutecnicos> tecnicosList = this.usuTecnicosService
											.obtenerTecnicosUsuServEdificio(
													parteAux.getIdcodigo(),
													parteAux.getIdedificio(),
													parteAux.getIdzona(), false);
									ArrayList<Long> arrayTecnicos = new ArrayList<Long>();
									Presencia presencia = new Presencia();
									for (Usutecnicos usuTecnicosAux : tecnicosList) {
										// Comprobar que esten presentes
										// y que sea diferente al técnico actual
										// además de que no lo haya rechazado o
										// no
										// aceptado
										// con anterioridad
										boolean rechazadoAnt = false;
										partetecrechazoAuxBusq = new Partetecgmaorechazo();
										partetecrechazoAuxBusq
												.setIdparte(parteAux
														.getIdparte());
										partetecrechazoAuxBusq
												.setIdtecnico(usuTecnicosAux
														.getIdtecnico());
										partetecrechazoAuxBusq = this.partetecnicosgmaoServices
												.findRechazoTec(partetecrechazoAuxBusq);
										if (partetecrechazoAuxBusq != null) {
											rechazadoAnt = true;
										}
										presencia.setIdtecnico(usuTecnicosAux
												.getIdtecnico());
										if (this.presenciaService
												.comprobarTecnicoEstaPresente(presencia)
												&& !usuTecnicosAux
														.getIdtecnico()
														.equals(partetecnicosgmaoAux
																.getIdtecnico())
												&& !rechazadoAnt) {
											// El tecnico esta presente
											// Recoger todos los tecnicos y
											// luego seleccionar uno
											// aleatoriamente

											/**
											 * Comprobamos que el técnico no
											 * este ya asignado al parte
											 * 
											 */
											Partetecnicosgmao partetecasigBusqAux = new Partetecnicosgmao();
											partetecasigBusqAux
													.setIdtecnico(usuTecnicosAux
															.getIdtecnico());
											partetecasigBusqAux
													.setIdparte(parteAux
															.getIdparte());
											partetecasigBusqAux = this.partetecnicosgmaoServices
													.findByIdParte(partetecasigBusqAux);
											if (partetecasigBusqAux == null) {
												arrayTecnicos
														.add(usuTecnicosAux
																.getIdtecnico());
											}
										}
									}

									if (arrayTecnicos.size() > 0) {
										// Se trabaja con el tecnico que ha sido
										// elegido
										// aleatoriamente entre los disponibles
										int numAleat = (int) Math.floor(Math
												.random()
												* (0 - arrayTecnicos.size())
												+ arrayTecnicos.size());
										Long idTecnicoAleat = arrayTecnicos
												.get(numAleat);

										Tecnicos tecnicos = new Tecnicos();
										tecnicos.setIdtecnico(idTecnicoAleat);
										Tecnicos tecnicoAux = this.tecnicosService
												.find(tecnicos);

										/**
										 * Comprobamos que no tenga ya registro
										 * en la tabla ParteTecnicos (Provocaba
										 * bucle)
										 */
										List<Partetecnicos> listadoTecnicosParte = new ArrayList<Partetecnicos>();

										listadoTecnicosParte = this.partetecnicosService
												.obtenerTecnicosParteAsociados(parteAux
														.getIdparte());
										boolean existeParteTec = false;
										Partetecnicos parteTecnicoAux = new Partetecnicos();
										for (Partetecnicos parteTecAux : listadoTecnicosParte) {
											if (parteTecAux != null
													&& parteTecAux
															.getIdtecnico() == tecnicoAux
															.getIdtecnico()) {
												existeParteTec = true;
												parteTecnicoAux = parteTecAux;
											}
										}

										if (!existeParteTec) {
											parteTecnicoAux = new Partetecnicos();
											// Insertar en la tabla de
											// ParteTecnicos
											Partetecnicos parteTecnico = new Partetecnicos();
											parteTecnico.setIdparte(parteAux
													.getIdparte());
											parteTecnico
													.setIdtecnico(tecnicoAux
															.getIdtecnico());
											parteTecnico.setFinalizado("0");
											parteTecnico.setAceptada(null);
											parteTecnicoAux = this.partetecnicosService
													.add(parteTecnico);
										}

										if (tecnicoAux.getMovilgmao() != null
												&& tecnicoAux.getMovilgmao()
														.equals("1")) {
											// Actualizar la tabla Partes
											// AUTOMATICA=1
											this.partesService
													.marcarAutomatica(parteAux);

											/**
											 * MOVILGMAO Se comprueba si el
											 * tecnico tiene aplicacion
											 * movilgmao. Si la tiene se crea la
											 * OT correspondiente
											 */
											if (tecnicoAux != null
													&& tecnicoAux
															.getMovilgmao() != null
													&& tecnicoAux
															.getMovilgmao()
															.equals("1")) {

												Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
												Partetecnicosgmao elTecnicoParteGmao = new Partetecnicosgmao();

												if (parteAux != null) {

													/**
													 * Actualizamos de la tabla
													 * para indicar el nuevo
													 * técnico
													 */
													// Nuevo valor partetec
													elTecnicoParteGmao
															.setIdpartec(parteTecnicoAux
																	.getIdpartec());
													elTecnicoParteGmao
															.setIdparte(partetecnicosgmaoAux
																	.getIdparte());
													// Nuevo valor técnico
													elTecnicoParteGmao
															.setIdtecnico(tecnicoAux
																	.getIdtecnico());
													elTecnicoParteGmao
															.setGuidplanopartegmao(partetecnicosgmaoAux
																	.getGuidplanopartegmao());
													elTecnicoParteGmao
															.setGuidpartetecgmao(partetecnicosgmaoAux
																	.getGuidpartetecgmao());

													tecnicoParteGmaoAux = this.partetecnicosgmaoServices
															.update(elTecnicoParteGmao);

													String idEdificio = parteAux
															.getIdedificio();

													Edificios edifAux = new Edificios();
													edifAux = this.edificiosService
															.obtenerEdificio(idEdificio);

													if (parteAux.getIddepar() != null) {
														Departamentos departamentoAux = new Departamentos();
														departamentoAux
																.setIddepar(parteAux
																		.getIddepar());
														departamentoAux = this.departamentosService
																.find(departamentoAux);
														parteAux.setDepartamento(departamentoAux);
													}

													if (parteAux.getIddir() != null) {
														Direcciones direccionAux = new Direcciones();
														direccionAux
																.setIddir(parteAux
																		.getIddir());
														direccionAux = this.direccionesService
																.find(direccionAux);
														parteAux.setDireccion(direccionAux);
													}

													if (parteAux.getIdplanta() != null) {
														Plantas plantaAux = new Plantas();
														plantaAux
																.setIdplanta(parteAux
																		.getIdplanta());
														plantaAux = this.plantasService
																.find(plantaAux);
														parteAux.setPlanta(plantaAux);
													}

													if (parteAux.getIdzona() != null) {
														Zonas zonaAux = new Zonas();
														zonaAux.setIdzona(parteAux
																.getIdzona());
														zonaAux = this.zonasService
																.find(zonaAux);
														parteAux.setZona(zonaAux);

													}

													if (parteAux.getIdespacio() != null) {
														Espacio espacioAux = new Espacio();
														espacioAux
																.setIdespacio(parteAux
																		.getIdespacio());
														espacioAux = this.espaciosService
																.find(espacioAux);
														parteAux.setEspacio(espacioAux);
													}

													// Obtener el plano si tiene
													Parteplano planoParte = new Parteplano();
													planoParte
															.setIdparte(parteAux
																	.getIdparte());

													planoParte = this.parteplanoService
															.find(planoParte);

													Partepdf pdfParte = new Partepdf();
													pdfParte.setIdparte(parteAux
															.getIdparte());

													pdfParte = this.partepdfService
															.find(pdfParte);

													// Obtener tecnicos
													// asignados al parte
													// (partetecnicos)
													tecnicoParteGmaoAux = new Partetecnicosgmao();
													tecnicoParteGmaoAux
															.setIdparte(parteAux
																	.getIdparte());
													List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
															.findAll(
																	tecnicoParteGmaoAux,
																	null);

													byte[] blobAsBytes = null;
													byte[] blobAsBytesPDF = null;
													try {
														if (planoParte != null) {
															// Tiene plano
															int blobLeng = (int) planoParte
																	.getDibujo()
																	.length();
															blobAsBytes = planoParte
																	.getDibujo()
																	.getBytes(
																			1,
																			blobLeng);
														}

														if (pdfParte != null) {
															// Tiene plano
															int blobLeng = (int) pdfParte
																	.getPdf()
																	.length();
															blobAsBytesPDF = pdfParte
																	.getPdf()
																	.getBytes(
																			1,
																			blobLeng);
														}

														respuesta = this.procesosJMSService
																.sincronizarParteCorrectivoGmao(
																		parteAux,
																		parteTecnicosGmao,
																		edifAux.getGuidedificio(),
																		blobAsBytes,
																		blobAsBytesPDF,
																		urlConfig);

														if (respuesta != null
																&& respuesta
																		.equals("OK")) {
															ProcesosGmaoTareasController.logger
																	.info("[MOVILGMAO] : sincronizarParteCorrectivo: "
																			+ respuesta);

														} else {
															ProcesosGmaoTareasController.logger
																	.error("[MOVILGMAO] : sincronizarParteCorrectivo: "
																			+ respuesta);
														}
													} catch (Exception e) {
														e.printStackTrace();
													}

												}
											}

											/**
											 * FIN MOVILGMAO
											 */
										} else {
											respuesta = "OK";
										}

										if (respuesta.equals("OK")) {
											// Eliminamos el técnico anterior de
											// la tabla parte tecnicos
											Partetecnicos partetecborrar = new Partetecnicos();
											partetecborrar
													.setIdparte(partetecnicosgmaoAux
															.getIdparte());
											partetecborrar
													.setIdtecnico(partetecnicosgmaoAux
															.getIdtecnico());
											this.partetecnicosService
													.eliminaTecnicoParte(partetecborrar);
										}
									} else {

										// Eliminamos el técnico anterior de
										// la tabla parte tecnicos
										Partetecnicos partetecborrar = new Partetecnicos();
										partetecborrar
												.setIdparte(partetecnicosgmaoAux
														.getIdparte());
										partetecborrar
												.setIdtecnico(partetecnicosgmaoAux
														.getIdtecnico());
										this.partetecnicosService
												.eliminaTecnicoParte(partetecborrar);

										Partetecnicosgmao parteGmaoEliminar = new Partetecnicosgmao();
										parteGmaoEliminar
												.setIdparte(partetecnicosgmaoAux
														.getIdparte());
										parteGmaoEliminar
												.setGuidpartetecgmao(partetecnicosgmaoAux
														.getGuidpartetecgmao());
										parteGmaoEliminar.setIdtecnico(null);
										parteGmaoEliminar.setIdpartec(null);
										parteGmaoEliminar.setUrgenteaviso("1");
										this.partetecnicosgmaoServices
												.update(parteGmaoEliminar);

										/**
										 * Dejamos sin operario en movil gmao
										 */
										this.procesosJMSService
												.subirOTcambioTecnico(
														partetecnicosgmaoAux
																.getGuidpartetecgmao(),
														null, urlConfig);

										/**
										 * Comprobamos si el parte tiene más
										 * técnicos asignados en ese caso no
										 * dejamos el parte sin asignar en el
										 * planner y lo eliminamos
										 */
										Partetecnicosgmao partetecgmaoBusqAux = new Partetecnicosgmao();
										partetecgmaoBusqAux
												.setIdparte(partetecnicosgmaoAux
														.getIdparte());
										List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
												.findAll(partetecgmaoBusqAux,
														null);

										if (parteTecnicosGmao.size() > 1) {
											int contadorTecnicos = parteTecnicosGmao
													.size();
											int contadorBorrados = 1;
											for (Partetecnicosgmao partetecgmaoAux : parteTecnicosGmao) {
												if (partetecgmaoAux != null
														&& (partetecgmaoAux
																.getIdtecnico() == null || partetecgmaoAux
																.getIdtecnico() == 0)
														&& contadorBorrados != contadorTecnicos) {
													this.procesosJMSService
															.eliminarOTpadre(
																	partetecgmaoAux
																			.getGuidpartetecgmao(),
																	urlConfig);
													this.partetecnicosgmaoServices
															.remove(partetecgmaoAux);
													contadorBorrados++;
												}

											}
										}

										/**
										 * Si no se ha asignado a ningún
										 * técnico, avisar al/los responsable
										 * del parte (servicio) para indicarselo
										 * con un email Inma - 28/07/2017 - Se
										 * modifica para que los mails los envíe
										 * siempre al responsable del territorio
										 */
										if (parteAux != null
												&& parteAux.getIdcodigo() != null) {
											Codigo codigoAux = new Codigo();
											codigoAux.setIdcodigo(parteAux
													.getIdcodigo());
											codigoAux = this.codigoService
													.find(codigoAux);
											if (codigoAux != null
													&& codigoAux
															.getIdservicio() != null) {
												/**
												 * Obtenemos los usuarios
												 * responsables de ese servicio
												 */
												List<Usuarios> listaUsuariosResp = new ArrayList<Usuarios>();
												Usuarios usuarioAux = new Usuarios();
												// usuarioAux
												// .setIdservicio(codigoAux
												// .getIdservicio());
												// usuarioAux.setResponsable(1);
												// usuarioAux.setBaja("0");
												// listaUsuariosResp =
												// this.usuariosService
												// .findAll(usuarioAux,
												// null);

												/** Mandamos correo para avisar **/
												// if (listaUsuariosResp.size()
												// > 0) {
												// for (Usuarios responsable :
												// listaUsuariosResp) {
												// String email = "";
												// if (responsable != null
												// && responsable
												// .getEmail() != null) {
												// email = responsable
												// .getEmail();
												//
												// try {
												// this.partesService
												// .enviarMailUsuResponsables(
												// parteAux,
												// email);
												//
												// respuesta = "OK";
												//
												// } catch (Exception e) {
												// ProcesosGmaoTareasController.logger
												// .error("[tareaSincronizarTodasOTs] : procesosGmao - Error obteniendo email usuario responsable - KO: "
												// + e.toString());
												// }
												//
												// }
												// }
												//
												// } else {
												// No hay ningún usuario
												// responsable del Servicio
												// o no tiene mail
												/**
												 * Obtendremos de la tabla
												 * usuarios los usuarios que
												 * tengan la marca emailurgente
												 * y les corresponda por
												 * territorio para mandarles el
												 * correo
												 */
												// A traves del edificio
												// obtenemos el territorio
												// del parte
												Edificios edificioAuxTerritorio = new Edificios();
												edificioAuxTerritorio = this.edificiosService
														.obtenerEdificio(parteAux
																.getIdedificio());

												listaUsuariosResp = new ArrayList<Usuarios>();
												usuarioAux = new Usuarios();
												usuarioAux.setEmailurgente("1");
												if (edificioAuxTerritorio != null
														&& edificioAuxTerritorio
																.getIdterri() != null) {
													ProcesosGmaoTareasController.logger
															.info("Territorio para buscar el responsable para enviar email : "
																	+ edificioAuxTerritorio
																			.getIdterri());
													usuarioAux
															.setIdterritorio(edificioAuxTerritorio
																	.getIdterri()
																	.toString());
												}
												usuarioAux.setBaja("0");
												listaUsuariosResp = this.usuariosService
														.findAll(usuarioAux,
																null);

												for (Usuarios responsable : listaUsuariosResp) {
													String email = "";
													if (responsable != null
															&& responsable
																	.getEmail() != null) {
														email = responsable
																.getEmail();

														try {
															ProcesosGmaoTareasController.logger
																	.info("Enviando mail a usuario responsable : "
																			+ email);
															this.partesService
																	.enviarMailUsuResponsables(
																			parteAux,
																			email);

														} catch (Exception e) {
															ProcesosGmaoTareasController.logger
																	.error("[tareaSincronizarTodasOTs] : procesosGmao - Error obteniendo email usuario responsable - KO: "
																			+ e.toString());
														}
													}
												}
												respuesta = "OK";
											}
											// }
										}
									}
								}
							}
						}
					}
				}
			}

			if (respuesta != null && respuesta.equals("OK")) {
				ProcesosGmaoTareasController.logger
						.info("[tareaSincronizarTodasOTs] : procesosGmao - Comprobar partes urgentes - correcta");
			} else {
				ProcesosGmaoTareasController.logger
						.error("[tareaSincronizarTodasOTs] : procesosGmao - Comprobar partes urgentes - KO");
			}

			ProcesosGmaoTareasController.logger
					.info("[tareaSincronizarTodasOTs] : procesosGmao - Comprobar partes urgentes - fin");
		} else {
			respuesta = "OK";
		}

	}

	public void tareaSincronizarPresenciasTecnicos() {

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuestaJSON = "";
		String respuesta = "";

		if (urlConfig != null && !urlConfig.equals("")
				&& urlConfig.indexOf("ejiedes") == -1) {
			ProcesosGmaoTareasController.logger
					.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización presencia técnicos - inicio");
			respuestaJSON = this.procesosJMSService
					.sincronizarGmaoGET(urlConfig
							+ Aa20bConstantes.URL_BAJAR_USUARIOS);

			// Si la respuesta no es nula o blancos traerá el objeto JSON
			if (respuestaJSON != null && !respuestaJSON.equals("")) {
				respuesta = actualizarPresenciaTecnicos(respuestaJSON,
						urlConfig);
			}

			if (respuesta != null && respuesta.equals("OK")) {
				ProcesosGmaoTareasController.logger
						.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización presencia técnicos - correcta");
			} else {
				ProcesosGmaoTareasController.logger
						.error("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización presencia técnicos - KO");
			}

			ProcesosGmaoTareasController.logger
					.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización presencia técnicos - fin");
		} else {
			respuesta = "OK";
		}

	}

	public void tareaSincronizarTodasOTsCorrectivas() {

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuestaJSON = "";
		String respuesta = "";

		if (urlConfig != null && !urlConfig.equals("")
				&& urlConfig.indexOf("ejiedes") == -1) {
			ProcesosGmaoTareasController.logger
					.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización partes correctivos - inicio");
			respuestaJSON = this.procesosJMSService
					.sincronizarGmaoGET(urlConfig
							+ Aa20bConstantes.URL_BAJAR_OTS);

			// Si la respuesta no es nula o blancos traerá el objeto JSON
			if (respuestaJSON != null && !respuestaJSON.equals("")) {
				respuesta = actualizarPartes(respuestaJSON, urlConfig,
						Aa20bConstantes.TIPO_OT_GMAO_CORRECTIVA);
			}

			if (respuesta != null && respuesta.equals("OK")) {
				ProcesosGmaoTareasController.logger
						.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización partes correctivos - correcta");
			} else {
				ProcesosGmaoTareasController.logger
						.error("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización partes correctivos - KO");
			}

			ProcesosGmaoTareasController.logger
					.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización partes correctivos - fin");
		} else {
			respuesta = "OK";
		}

	}

	public void tareaSincronizarTodasOTsPreventivas() {

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuestaJSON = "";
		String respuesta = "";

		if (urlConfig != null && !urlConfig.equals("")
				&& urlConfig.indexOf("ejiedes") == -1) {
			ProcesosGmaoTareasController.logger
					.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización partes preventivos - inicio");
			respuestaJSON = this.procesosJMSService
					.sincronizarGmaoGET(urlConfig
							+ Aa20bConstantes.URL_BAJAR_OTS);

			// Si la respuesta no es nula o blancos traerá el objeto JSON
			if (respuestaJSON != null && !respuestaJSON.equals("")) {
				respuesta = actualizarPartes(respuestaJSON, urlConfig,
						Aa20bConstantes.TIPO_OT_GMAO_PREVENTIVA);
			}

			if (respuesta != null && respuesta.equals("OK")) {
				ProcesosGmaoTareasController.logger
						.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización partes preventivos - correcta");
			} else {
				ProcesosGmaoTareasController.logger
						.error("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización partes preventivos - KO");
			}

			ProcesosGmaoTareasController.logger
					.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización partes preventivos - fin");
		} else {
			respuesta = "OK";
		}

	}

	private String actualizarPartes(String respuestaJSON, String urlConfig,
			String tipo) {

		String respuesta = "";

		JSONObject resp = new JSONObject(respuestaJSON);

		JSONArray ots = new JSONArray();
		JSONArray otmods = new JSONArray();
		JSONArray revisiones = new JSONArray();
		JSONArray operarios = new JSONArray();
		JSONArray logs = new JSONArray();
		JSONArray campos = new JSONArray();
		ots = resp.getJSONArray("ots");
		otmods = resp.getJSONArray("otmod");
		if (resp.get("revisiones") != JSONObject.NULL) {
			revisiones = resp.getJSONArray("revisiones");
		}
		operarios = resp.getJSONArray("operarios");
		logs = resp.getJSONArray("log");
		campos = resp.getJSONArray("campos");

		if (ots.length() > 0) {
			for (int i = 0; i < ots.length(); i++) {
				JSONObject ot = ots.getJSONObject(i);

				String guidpartehija = ot.get("UUIdOt").toString()
						.toLowerCase();
				String guidpartehijaFormateado = ot.getString("UUIdOt")
						.replace("{", "");
				guidpartehijaFormateado = guidpartehijaFormateado.replace("}",
						"");
				guidpartehijaFormateado = guidpartehijaFormateado.toLowerCase();

				// Distinguir si se trata de un parte correctivo o preventivo
				String tipoParte = "";
				if (ot.get("IdTipo") != JSONObject.NULL) {
					tipoParte = ot.getString("IdTipo");
				}

				if (tipoParte.equals(Aa20bConstantes.TIPO_OT_GMAO_CORRECTIVA)) {
					respuesta = this.tratamientoPartesCorrectivos(ot,
							operarios, otmods, logs, campos,
							guidpartehijaFormateado, urlConfig, guidpartehija);

				} else if (tipoParte
						.equals(Aa20bConstantes.TIPO_OT_GMAO_PREVENTIVA)) {
					respuesta = this.tratamientoPartesPreventivos(ot,
							operarios, otmods, revisiones, logs, campos,
							guidpartehijaFormateado, guidpartehija, urlConfig);
				}

			}
		} else {
			respuesta = "OK";
		}

		return respuesta;
	}

	private void asignarParteCorrectivoAutomatico(Partes parteAux,
			Partetecnicos partetecnicosAux, String urlConfig) {

		// Primero buscamos solo técnicos que tengan aplicación MovilGmao
		List<Usutecnicos> tecnicosList = this.usuTecnicosService
				.obtenerTecnicosUsuServEdificio(parteAux.getIdcodigo(),
						parteAux.getIdedificio(), parteAux.getIdzona(), true);
		ArrayList<Long> arrayTecnicos = new ArrayList<Long>();
		Presencia presencia = new Presencia();
		for (Usutecnicos usuTecnicosAux : tecnicosList) {
			// Comprobar que esten presentes
			// Buscar en la tabla Presencia los
			// tecnicos que tengan con
			// THASTA a 0
			presencia.setIdtecnico(usuTecnicosAux.getIdtecnico());
			if (this.presenciaService.comprobarTecnicoEstaPresente(presencia)) {
				// El tecnico esta presente
				// Recoger todos los tecnicos y
				// luego seleccionar uno
				// aleatoriamente

				// Se comprueba que el técnico
				// es diferente al que
				// actualmente
				// ha rechazado el parte
				if (usuTecnicosAux.getIdtecnico().compareTo(
						partetecnicosAux.getIdtecnico()) != 0) {
					arrayTecnicos.add(usuTecnicosAux.getIdtecnico());
				}
			}
		}
		// Si no ha encontrado ningún técnico con aplicación móvil
		// se buscará en los demás que corresponda
		if (arrayTecnicos.size() == 0) {
			tecnicosList = this.usuTecnicosService
					.obtenerTecnicosUsuServEdificio(parteAux.getIdcodigo(),
							parteAux.getIdedificio(), parteAux.getIdzona(),
							false);
			arrayTecnicos = new ArrayList<Long>();
			presencia = new Presencia();
			for (Usutecnicos usuTecnicosAux : tecnicosList) {
				// Comprobar que esten presentes
				// Buscar en la tabla Presencia los
				// tecnicos que tengan con
				// THASTA a 0
				presencia.setIdtecnico(usuTecnicosAux.getIdtecnico());
				if (this.presenciaService
						.comprobarTecnicoEstaPresente(presencia)) {
					// El tecnico esta presente
					// Recoger todos los tecnicos y
					// luego seleccionar uno
					// aleatoriamente

					// Se comprueba que el técnico
					// es diferente al que
					// actualmente
					// ha rechazado el parte
					if (usuTecnicosAux.getIdtecnico().compareTo(
							partetecnicosAux.getIdtecnico()) != 0) {
						arrayTecnicos.add(usuTecnicosAux.getIdtecnico());
					}
				}
			}
		}

		if (arrayTecnicos.size() > 0) {
			// Se trabaja con el tecnico que ha
			// sido elegido
			// aleatoriamente.
			int numAleat = (int) Math.floor(Math.random()
					* (0 - arrayTecnicos.size()) + arrayTecnicos.size());
			Long idTecnicoAleat = arrayTecnicos.get(numAleat);

			Tecnicos tecnicos = new Tecnicos();
			tecnicos.setIdtecnico(idTecnicoAleat);
			Tecnicos tecnicoAux = this.tecnicosService.find(tecnicos);

			// Insertar en la tabla de
			// ParteTecnicos
			Partetecnicos parteTecnico = new Partetecnicos();
			parteTecnico.setIdparte(parteAux.getIdparte());
			parteTecnico.setIdtecnico(tecnicoAux.getIdtecnico());
			parteTecnico.setFinalizado("0");
			Partetecnicos parteTecnicoAux = this.partetecnicosService
					.add(parteTecnico);

			/**
			 * Victor GMAO Se no tiene email y si no es movilgmao, se deja como
			 * asignacion manual Se comprueba también si tiene gmao además de
			 * email
			 */
			// Si no tiene email se deja como
			// ASIGNACION MANUAL

			/**
			 * MOVILGMAO Se comprueba si el tecnico tiene aplicacion movilgmao.
			 * Si la tiene se crea la OT correspondiente
			 * 
			 */
			if (tecnicoAux != null && tecnicoAux.getMovilgmao() != null
					&& tecnicoAux.getMovilgmao().equals("1")) {
				this.partesService.marcarAutomatica(parteAux);
				Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
				Partetecnicosgmao elTecnicoParteGmao = new Partetecnicosgmao();

				if (parteAux != null) {

					elTecnicoParteGmao.setIdparte(parteAux.getIdparte());
					elTecnicoParteGmao.setIdtecnico(tecnicoAux.getIdtecnico());
					elTecnicoParteGmao.setIdpartec(parteTecnicoAux
							.getIdpartec());
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					elTecnicoParteGmao.setGuidpartetecgmao(randomUUIDString);
					tecnicoParteGmaoAux = this.partetecnicosgmaoServices
							.add(elTecnicoParteGmao);

					String idEdificio = parteAux.getIdedificio();

					Edificios edifAux = new Edificios();
					edifAux = this.edificiosService.obtenerEdificio(idEdificio);

					if (parteAux.getIddepar() != null) {
						Departamentos departamentoAux = new Departamentos();
						departamentoAux.setIddepar(parteAux.getIddepar());
						departamentoAux = this.departamentosService
								.find(departamentoAux);
						parteAux.setDepartamento(departamentoAux);
					}

					if (parteAux.getIddir() != null) {
						Direcciones direccionAux = new Direcciones();
						direccionAux.setIddir(parteAux.getIddir());
						direccionAux = this.direccionesService
								.find(direccionAux);
						parteAux.setDireccion(direccionAux);
					}

					if (parteAux.getIdplanta() != null) {
						Plantas plantaAux = new Plantas();
						plantaAux.setIdplanta(parteAux.getIdplanta());
						plantaAux = this.plantasService.find(plantaAux);
						parteAux.setPlanta(plantaAux);
					}

					if (parteAux.getIdzona() != null) {
						Zonas zonaAux = new Zonas();
						zonaAux.setIdzona(parteAux.getIdzona());
						zonaAux = this.zonasService.find(zonaAux);
						parteAux.setZona(zonaAux);

					}

					if (parteAux.getIdespacio() != null) {
						Espacio espacioAux = new Espacio();
						espacioAux.setIdespacio(parteAux.getIdespacio());
						espacioAux = this.espaciosService.find(espacioAux);
						parteAux.setEspacio(espacioAux);
					}

					// Obtener el plano si
					// tiene
					Parteplano planoParte = new Parteplano();
					planoParte.setIdparte(parteAux.getIdparte());

					planoParte = this.parteplanoService.find(planoParte);

					Partepdf pdfParte = new Partepdf();
					pdfParte.setIdparte(parteAux.getIdparte());

					pdfParte = this.partepdfService.find(pdfParte);

					if (parteAux.getGuidparte() == null) {
						randomUUIDString = "";
						uuid = UUID.randomUUID();
						randomUUIDString = uuid.toString();
						parteAux.setGuidparte(randomUUIDString);
						parteAux = this.partesService
								.actualizarUUIDparte(parteAux);
					}

					if (planoParte != null) {

						randomUUIDString = "";
						uuid = UUID.randomUUID();
						randomUUIDString = uuid.toString();
						elTecnicoParteGmao.setIdparte(parteAux.getIdparte());
						elTecnicoParteGmao.setIdtecnico(tecnicoAux
								.getIdtecnico());
						elTecnicoParteGmao.setIdpartec(parteTecnicoAux
								.getIdpartec());
						elTecnicoParteGmao
								.setGuidplanopartegmao(randomUUIDString);
						tecnicoParteGmaoAux = this.partetecnicosgmaoServices
								.update(elTecnicoParteGmao);
					}

					if (pdfParte != null) {

						randomUUIDString = "";
						uuid = UUID.randomUUID();
						randomUUIDString = uuid.toString();
						elTecnicoParteGmao.setIdparte(parteAux.getIdparte());
						elTecnicoParteGmao.setIdtecnico(tecnicoAux
								.getIdtecnico());
						elTecnicoParteGmao.setIdpartec(parteTecnicoAux
								.getIdpartec());
						elTecnicoParteGmao
								.setGuidpdfpartegmao(randomUUIDString);
						tecnicoParteGmaoAux = this.partetecnicosgmaoServices
								.update(elTecnicoParteGmao);
					}

					// Obtener tecnicos
					// asignados al parte
					// (partetecnicos)
					tecnicoParteGmaoAux = new Partetecnicosgmao();
					tecnicoParteGmaoAux.setIdparte(parteAux.getIdparte());
					List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
							.findAll(tecnicoParteGmaoAux, null);

					byte[] blobAsBytes = null;
					byte[] blobAsBytesPDF = null;
					try {
						if (planoParte != null) {
							// Tiene plano
							int blobLeng = (int) planoParte.getDibujo()
									.length();
							blobAsBytes = planoParte.getDibujo().getBytes(1,
									blobLeng);
						}

						if (pdfParte != null) {
							// Tiene plano
							int blobLeng = (int) pdfParte.getPdf().length();
							blobAsBytesPDF = pdfParte.getPdf().getBytes(1,
									blobLeng);
						}

						String respuesta = this.procesosJMSService
								.sincronizarParteCorrectivoGmao(parteAux,
										parteTecnicosGmao,
										edifAux.getGuidedificio(), blobAsBytes,
										blobAsBytesPDF, urlConfig);

						if (respuesta != null && respuesta.equals("OK")) {
							ProcesosGmaoTareasController.logger
									.info("[MOVILGMAO] : sincronizarParteCorrectivo: "
											+ respuesta);
						} else {
							ProcesosGmaoTareasController.logger
									.error("[MOVILGMAO] : sincronizarParteCorrectivo: "
											+ respuesta);
						}
					} catch (Exception e) {
						e.printStackTrace();
					}

				}
			} else if (tecnicoAux.getMail() != null) {
				// Actualizar la tabla Partes
				// AUTOMATICA=1
				this.partesService.marcarAutomatica(parteAux);

				// Actualizar la tabla
				// Partes ENVIOMAIL=1
				this.partesService.marcarEnvioMail(parteAux);

				// Enviar email
				try {
					String retorno = this.partesService.enviarMailTecnico(
							parteAux, tecnicoAux);
					if ("true".equals(retorno)) {
						// Si ha ido bien el
						// envío de mail se
						// marca
						// enviomail =1 en
						// la tabla
						// TecnicoPartes
						this.partetecnicosService.marcarEnvioMail(
								parteAux.getIdparte(),
								tecnicoAux.getIdtecnico());
					}
					ProcesosGmaoTareasController.logger
							.info("[POST] : email enviado" + retorno);
					// return partesAux;
				} catch (Exception e) {
					// TODO Auto-generated
					// catch block
					e.printStackTrace();
				}

			}
			ProcesosGmaoTareasController.logger
					.info("[POST] : Tecnicos encontrados: "
							+ parteTecnicoAux.getIdpartec());
		}
	}

	private void eliminarTecnicoRechazada(Partes parteAux,
			Partetecnicos partetecnicosAux,
			Partetecnicosgmao partetecnicosgmaoAux, String urlConfig) {

		ProcesosGmaoTareasController.logger
				.info("[GET - findBy_PK] : Eliminando tecnico en el parte : "
						+ partetecnicosAux.getIdtecnico());
		/* execute */
		this.partetecnicosService.eliminaTecnicoParte(partetecnicosAux);

		Partetecnicosgmao elTecnicoParteGmao = new Partetecnicosgmao();
		elTecnicoParteGmao.setIdparte(parteAux.getIdparte());
		elTecnicoParteGmao.setGuidpartetecgmao(partetecnicosgmaoAux
				.getGuidpartetecgmao());
		elTecnicoParteGmao.setIdtecnico(partetecnicosgmaoAux.getIdtecnico());
		elTecnicoParteGmao.setIdpartec(null);
		partetecnicosgmaoAux = this.partetecnicosgmaoServices
				.update(elTecnicoParteGmao);

		List<Partetecnicosgmao> parteTecnicosEliminar = new ArrayList<Partetecnicosgmao>();
		parteTecnicosEliminar.add(partetecnicosgmaoAux);

		if (parteAux != null) {
			String idEdificio = parteAux.getIdedificio();

			Edificios edifAux = new Edificios();
			edifAux = this.edificiosService.obtenerEdificio(idEdificio);

			if (parteAux.getIddepar() != null) {
				Departamentos departamentoAux = new Departamentos();
				departamentoAux.setIddepar(parteAux.getIddepar());
				departamentoAux = this.departamentosService
						.find(departamentoAux);
				parteAux.setDepartamento(departamentoAux);
			}

			if (parteAux.getIddir() != null) {
				Direcciones direccionAux = new Direcciones();
				direccionAux.setIddir(parteAux.getIddir());
				direccionAux = this.direccionesService.find(direccionAux);
				parteAux.setDireccion(direccionAux);
			}

			if (parteAux.getIdplanta() != null) {
				Plantas plantaAux = new Plantas();
				plantaAux.setIdplanta(parteAux.getIdplanta());
				plantaAux = this.plantasService.find(plantaAux);
				parteAux.setPlanta(plantaAux);
			}

			if (parteAux.getIdzona() != null) {
				Zonas zonaAux = new Zonas();
				zonaAux.setIdzona(parteAux.getIdzona());
				zonaAux = this.zonasService.find(zonaAux);
				parteAux.setZona(zonaAux);

			}

			if (parteAux.getIdespacio() != null) {
				Espacio espacioAux = new Espacio();
				espacioAux.setIdespacio(parteAux.getIdespacio());
				espacioAux = this.espaciosService.find(espacioAux);
				parteAux.setEspacio(espacioAux);
			}

			// Obtener el plano si tiene
			Parteplano planoParte = new Parteplano();
			planoParte.setIdparte(parteAux.getIdparte());

			planoParte = this.parteplanoService.find(planoParte);

			Partepdf pdfParte = new Partepdf();
			pdfParte.setIdparte(parteAux.getIdparte());

			pdfParte = this.partepdfService.find(pdfParte);

			// Obtener tecnicos asignados al parte
			// (partetecnicos)
			Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
			tecnicoParteGmaoAux.setIdparte(parteAux.getIdparte());
			List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
					.findAll(tecnicoParteGmaoAux, null);

			byte[] blobAsBytes = null;
			byte[] blobAsBytesPDF = null;
			try {
				if (planoParte != null) {
					// Tiene plano
					int blobLeng = (int) planoParte.getDibujo().length();
					blobAsBytes = planoParte.getDibujo().getBytes(1, blobLeng);
				}

				if (pdfParte != null) {
					// Tiene plano
					int blobLeng = (int) pdfParte.getPdf().length();
					blobAsBytesPDF = pdfParte.getPdf().getBytes(1, blobLeng);
				}

				String respuesta = this.procesosJMSService
						.sincronizarParteCorrectivoGmao(parteAux,
								parteTecnicosGmao, edifAux.getGuidedificio(),
								blobAsBytes, blobAsBytesPDF, urlConfig);

				if (respuesta != null && respuesta.equals("OK")) {
					ProcesosGmaoTareasController.logger
							.info("[MOVILGMAO] : sincronizarParteCorrectivo: "
									+ respuesta);

					for (Partetecnicosgmao parteGmaoEliminar : parteTecnicosEliminar) {
						this.partetecnicosgmaoServices
								.remove(parteGmaoEliminar);
					}

					// Comprobamos si el parte sigue teniendo técnicos con
					// gmao
					// Si ya no tiene, eliminamos la OT de movilgmao
					parteTecnicosGmao = this.partetecnicosgmaoServices.findAll(
							tecnicoParteGmaoAux, null);

					if (parteTecnicosGmao.size() == 0) {
						this.procesosJMSService.eliminarOTpadre(
								parteAux.getGuidparte(), urlConfig);
					}

				} else {
					ProcesosGmaoTareasController.logger
							.error("[MOVILGMAO] : sincronizarParteCorrectivo: "
									+ respuesta);
				}

			} catch (Exception e) {
				e.printStackTrace();
			}

		}

	}

	private boolean crearParteCorrectivoNuevoDesdeMovilGmao(
			String guidpartehijaFormateado, String urlConfig, JSONObject ot) {

		boolean parteNuevoBienCreado = true;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		// Si el parte es nuevo debemos crearlo en nuestra
		// aplicación
		Partes parteNuevo = new Partes();
		JSONObject otNueva = new JSONObject();
		otNueva.put("UUIdOt", "{" + guidpartehijaFormateado + "}");

		String idTecnicoParteNuevo = "";
		if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
			idTecnicoParteNuevo = ot.getString("IdOperarioResponsable");
		}

		boolean tieneTecnico = false;
		if (idTecnicoParteNuevo != null && !idTecnicoParteNuevo.equals("")) {
			tieneTecnico = true;
		}

		// Nos bajamos todos los datos del nuevo parte
		// desde
		// MovilGMAO
		String respuestaOTnueva = "";
		respuestaOTnueva = this.procesosJMSService.bajarOtByGUID(otNueva,
				urlConfig + Aa20bConstantes.URL_BAJAR_OTS_GUID);

		// Procesamos el JSON que nos hemos bajado con
		// los
		// campos
		JSONObject respNuevaOT = new JSONObject(respuestaOTnueva);
		JSONArray camposNuevaOT = new JSONArray();
		camposNuevaOT = respNuevaOT.getJSONArray("campos");
		String observacionesTecnico = "";
		for (int z = 0; z < camposNuevaOT.length(); z++) {
			JSONObject campo = camposNuevaOT.getJSONObject(z);
			String nombreCampo = "";
			nombreCampo = campo.getString("IdCampo");
			if (nombreCampo.equals("DEPAR")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					try {
						Integer.parseInt(campo.getString("Valor"));
						parteNuevo.setIddepar(Long.valueOf(campo
								.getString("Valor")));
					} catch (NumberFormatException nfe) {
						parteNuevo.setIddepar(null);
					}

				}
			} else if (nombreCampo.equals("DIR")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					try {
						Integer.parseInt(campo.getString("Valor"));
						parteNuevo.setIddir(Integer.valueOf(campo
								.getString("Valor")));
					} catch (NumberFormatException nfe) {
						parteNuevo.setIddir(null);
					}

				}
			} else if (nombreCampo.equals("IDPLANTA")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					String plantaSinFormatear = campo.getString("Valor");
					String zona = plantaSinFormatear
							.substring(plantaSinFormatear.indexOf("_") + 1);
					zona = zona.substring(0, zona.indexOf("_"));
					String planta = plantaSinFormatear
							.substring(plantaSinFormatear.indexOf("_") + 1);
					planta = planta.substring(planta.indexOf("_") + 1);
					parteNuevo.setIdzona(Integer.valueOf(zona));
					parteNuevo.setIdplanta(Integer.valueOf(planta));
				} else {
					parteNuevo.setIdzona(Aa20bConstantes.SIN_ZONAS);
					parteNuevo.setIdplanta(Aa20bConstantes.SIN_PLANTAS);
				}
			} else if (nombreCampo.equals("IDCLASE")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setIdclase(Integer.valueOf(campo
							.getString("Valor")));
				}
			} else if (nombreCampo.equals("IDCODIGO")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setIdcodigo(Integer.valueOf(campo
							.getString("Valor")));
				}
			} else if (nombreCampo.equals("IDESTANCIA")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setIdespacio(Long.valueOf(campo
							.getString("Valor")));
				}
			} else if (nombreCampo.equals("MAIL")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setMail(campo.getString("Valor"));
				}
			} else if (nombreCampo.equals("NOMBRE")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setNombre(campo.getString("Valor"));
				}
			} else if (nombreCampo.equals("TELEFONO")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setTelefo(campo.getString("Valor"));
				}
			} else if (nombreCampo.equals("NOTASTEC")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					observacionesTecnico = campo.getString("Valor");
				}
			}
		}
		if (ot.get("DescLarga") != JSONObject.NULL) {
			parteNuevo.setObserv(ot.getString("DescLarga"));
		} else {
			if (ot.get("DescCorta") != JSONObject.NULL) {
				parteNuevo.setObserv(ot.getString("DescCorta"));
			}
		}
		String observacionesInternas = "";
		if (ot.get("ObsInternas") != JSONObject.NULL) {
			observacionesInternas = ot.getString("ObsInternas");
		}

		boolean crearParteNuevo = true;
		boolean otnuevacorrecta = true;
		/**
		 * Si viene con el campo de ot de seguimiento significa que quiere
		 * traspasar el parte a otro técnico y que se quede guardado su trabajo.
		 */
		Integer parteBusqueda = 0;
		String partePadreGuid = "";
		String parteSeguidoGuid = "";
		String otTraspaso = "";
		String otAyuda = "";
		Parteplano planoParte = new Parteplano();
		Partepdf pdfParte = new Partepdf();
		if (ot.get("UUIdOtSeguida") != JSONObject.NULL) {
			crearParteNuevo = false;
			otTraspaso = ot.getString("UUIdOtSeguida").replace("{", "");
			otTraspaso = otTraspaso.replace("}", "");
			Partetecnicosgmao partetecpadregmaoAux = new Partetecnicosgmao();
			partetecpadregmaoAux.setGuidpartetecgmao(otTraspaso.toLowerCase());
			partetecpadregmaoAux = this.partetecnicosgmaoServices
					.findByGUID(partetecpadregmaoAux);

			if (partetecpadregmaoAux != null) {
				/**
				 * El parte existe en nuestro sistema. Debemos crear un parte
				 * nuevo en movil gmao asignandoselo al nuevo técnico para
				 * después finalizar el parte anterior que se quiere traspasar.
				 * En nuestra aplicación se asignará al mismo parte.
				 */
				parteBusqueda = partetecpadregmaoAux.getIdparte();
				parteSeguidoGuid = partetecpadregmaoAux.getGuidpartetecgmao();
				String tecnicoNuevo = "";
				if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
					tecnicoNuevo = ot.getString("IdOperarioResponsable");
					// Si ha elegido un técnico diferente a el
					if (!tecnicoNuevo.equals(partetecpadregmaoAux
							.getIdtecnico())) {

						/**
						 * Se comprueba el estado actual del parte para marcarlo
						 * como finalizado en movilgmao
						 */
						if (partetecpadregmaoAux.getEstadoGmao() == null
								|| (partetecpadregmaoAux.getEstadoGmao() != null && partetecpadregmaoAux
										.getFechaEstadoGmao() != null)) {
							if (partetecpadregmaoAux.getEstadoGmao() == null
									|| (partetecpadregmaoAux.getEstadoGmao() != null && !partetecpadregmaoAux
											.getEstadoGmao()
											.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO))) {

								// Obtener el plano si tiene
								planoParte.setIdparte(partetecpadregmaoAux
										.getIdparte());
								planoParte = this.parteplanoService
										.find(planoParte);

								pdfParte.setIdparte(partetecpadregmaoAux
										.getIdparte());
								pdfParte = this.partepdfService.find(pdfParte);

								String respuestaCambioEstado = this.procesosJMSService
										.subirOTcambioEstado(
												partetecpadregmaoAux
														.getGuidpartetecgmao(),
												Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO,
												urlConfig);

								/**
								 * Quitamos el tecnico de la OT (como hace
								 * movilgmao al finalizar)
								 */
								if (respuestaCambioEstado.equals("OK")) {
									this.procesosJMSService
											.subirOTcambioTecnico(
													partetecpadregmaoAux
															.getGuidpartetecgmao(),
													null, urlConfig);
								}
							}
						}
					} else {
						// Si se ha elegido a el como técnico no creamos el
						// parte
						otnuevacorrecta = false;
					}
				}
			}

		} else if (ot.get("UUIdOtPadre") != JSONObject.NULL) {
			/**
			 * Si viene con el campo de ot hija significa que quiere ayuda para
			 * el parte. Se deberá crear un parte nuevo hijo y asignarselo al
			 * técnico nuevo, manteniendo el parte anterior igual
			 */
			crearParteNuevo = false;
			otAyuda = ot.getString("UUIdOtPadre").replace("{", "");
			otAyuda = otAyuda.replace("}", "");
			Partetecnicosgmao partetecpadregmaoAux = new Partetecnicosgmao();
			partetecpadregmaoAux.setGuidpartetecgmao(otAyuda.toLowerCase());
			partetecpadregmaoAux = this.partetecnicosgmaoServices
					.findByGUID(partetecpadregmaoAux);
			if (partetecpadregmaoAux != null) {
				partePadreGuid = partetecpadregmaoAux.getGuidpartetecgmao();
				parteBusqueda = partetecpadregmaoAux.getIdparte();
				String tecnicoNuevo = "";
				if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
					tecnicoNuevo = ot.getString("IdOperarioResponsable");
					// Si se ha elegido a el como técnico no creamos el parte
					if (tecnicoNuevo
							.equals(partetecpadregmaoAux.getIdtecnico())) {
						otnuevacorrecta = false;
					}
				}
				/**
				 * Comprobamos si el parte al que hace referencia el nuevo tiene
				 * plano. Si lo tiene, creamos una copia del mismo para este
				 * nuevo parte
				 */
				// Obtener el plano si tiene
				planoParte.setIdparte(partetecpadregmaoAux.getIdparte());
				planoParte = this.parteplanoService.find(planoParte);

				pdfParte.setIdparte(partetecpadregmaoAux.getIdparte());
				pdfParte = this.partepdfService.find(pdfParte);
				/*
				 * byte[] blobAsBytes = null; if (planoParte != null) { try { //
				 * Tiene plano int blobLeng = (int)
				 * planoParte.getDibujo().length(); blobAsBytes =
				 * planoParte.getDibujo().getBytes(1, blobLeng); } catch
				 * (Exception e) { e.printStackTrace(); }
				 * parteNuevo.setPlanoMarca(blobAsBytes); }
				 */
			}
		}
		Partes parteNuevoAux = new Partes();
		String guidedificioFormateado = ot.getString("UUIdactivo").replace("{",
				"");
		guidedificioFormateado = guidedificioFormateado.replace("}", "");
		if (crearParteNuevo) {

			// Id edificio
			Edificios edificioAux = new Edificios();
			edificioAux.setGuidedificio(guidedificioFormateado.toLowerCase());
			edificioAux = this.edificiosService.findByGUID(edificioAux);

			if (edificioAux != null) {
				parteNuevo.setIdedificio(edificioAux.getIdedificio());
			}

			// Fecha
			String fechaParteNuevo = "";
			if (ot.get("FechaPlanificacion") != JSONObject.NULL) {
				fechaParteNuevo = ot.getString("FechaPlanificacion");
			}
			Date fechaPlanifParteNuevo = null;

			try {
				fechaPlanifParteNuevo = sdf.parse(fechaParteNuevo);

			} catch (ParseException e) {
				ProcesosGmaoTareasController.logger
						.error("[MOVILGMAO] : bajarOTs - formatear fecha planif parte nuevo: "
								+ e.getMessage());
			}
			parteNuevo.setFechare(fechaPlanifParteNuevo);

			// Prioridad
			String prioridad = "";
			if (ot.get("IdPrioridad") != JSONObject.NULL) {
				prioridad = ot.getString("IdPrioridad");
			}
			parteNuevo.setUrgente(prioridad);

			// Al crear el parte en nuestra aplicación
			// le asignamos un UUID nuevo ya que el UUID de MovilGmao irá
			// asociado
			// en
			// la tabla de partes gmao de nuestra aplicación
			String randomUUIDString = "";
			UUID uuid = UUID.randomUUID();
			randomUUIDString = uuid.toString();
			parteNuevo.setGuidparte(randomUUIDString);

			parteNuevoAux = this.partesService.add(parteNuevo);
		} else {
			Partes parteBusAux = new Partes();
			parteBusAux.setIdparte(parteBusqueda);
			parteNuevoAux = this.partesService.find(parteBusAux);
		}
		if (parteNuevoAux != null && otnuevacorrecta) {
			/**
			 * Si en el parte nuevo no viene información del técnico asociado
			 * significa que quiere cambiar de técnico
			 */
			Partetecnicosgmao elTecnicoParteGmao = new Partetecnicosgmao();
			Partetecnicosgmao parteNuevoTecnicoGmaoAux = new Partetecnicosgmao();
			if (idTecnicoParteNuevo != null && !idTecnicoParteNuevo.equals("")) {
				Partetecnicos parteTecnico = new Partetecnicos();
				parteTecnico.setIdparte(parteNuevoAux.getIdparte());
				parteTecnico.setIdtecnico(Long.valueOf(idTecnicoParteNuevo));
				parteTecnico.setFinalizado("0");
				if (ot.get("IdPrioridad") != JSONObject.NULL
						&& ot.getString("IdPrioridad").equals("1")) {
					parteTecnico.setAceptada("0");
				} else {
					parteTecnico.setAceptada("1");
				}

				if (!observacionesTecnico.trim().equals("")) {
					parteTecnico.setNotasTec(observacionesTecnico);
				}

				Partetecnicos parteTecnicoAux = this.partetecnicosService
						.add(parteTecnico);

				elTecnicoParteGmao.setIdparte(parteNuevoAux.getIdparte());
				elTecnicoParteGmao.setIdtecnico(Long
						.valueOf(idTecnicoParteNuevo));
				elTecnicoParteGmao.setIdpartec(parteTecnicoAux.getIdpartec());
				elTecnicoParteGmao.setGuidpartetecgmao(guidpartehijaFormateado);
				if (!partePadreGuid.equals("")) {
					elTecnicoParteGmao.setGuidpartepadreayuda(partePadreGuid);
				}
				if (!parteSeguidoGuid.equals("")) {
					elTecnicoParteGmao.setGuidparteseguido(parteSeguidoGuid);
				}
				if (planoParte != null) {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					elTecnicoParteGmao.setGuidplanopartegmao(randomUUIDString);
				}

				if (pdfParte != null) {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					elTecnicoParteGmao.setGuidpdfpartegmao(randomUUIDString);
				}

				parteNuevoTecnicoGmaoAux = this.partetecnicosgmaoServices
						.add(elTecnicoParteGmao);

			} else {

				/**
				 * No tiene técnico, habrá que buscar uno si es automático Se
				 * crea el registro en la tabla de partes gmao sin incluir ni el
				 * técnico ni el código del parte técnico
				 */

				elTecnicoParteGmao.setIdparte(parteNuevoAux.getIdparte());
				elTecnicoParteGmao.setIdtecnico(null);
				elTecnicoParteGmao.setIdpartec(null);
				elTecnicoParteGmao.setGuidpartetecgmao(guidpartehijaFormateado);

				if (planoParte != null) {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					elTecnicoParteGmao.setGuidplanopartegmao(randomUUIDString);
				}

				if (pdfParte != null) {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					elTecnicoParteGmao.setGuidpdfpartegmao(randomUUIDString);
				}

				parteNuevoTecnicoGmaoAux = this.partetecnicosgmaoServices
						.add(elTecnicoParteGmao);
			}
			Tecnicos tecnicoAux = new Tecnicos();
			if (tieneTecnico) {
				tecnicoAux.setIdtecnico(Long.valueOf(idTecnicoParteNuevo));
				tecnicoAux = this.tecnicosService.find(tecnicoAux);
			} else {
				/**
				 * No tiene técnico, buscaremos uno si es automático
				 */

				Codigo codigo = new Codigo();
				codigo.setIdcodigo(parteNuevoAux.getIdcodigo());
				codigo = this.codigosService.find(codigo);
				if (codigo != null && codigo.getRecibeinci() != null
						&& codigo.getRecibeinci().equals("1")) {
					if (codigo != null && codigo.getContrata() != null
							&& codigo.getContrata().equals("1")) {

						// Obtener los tecnicos de contratas cuya clase y
						// edificio
						// coincidan con los del parte
						List<Tecnicos> tecnicosContrataList = this.tecnicosService
								.obtenerTecnicosClaseContrataEdificio(
										codigo.getIdclase(),
										codigo.getIdservicio(),
										codigo.getIdcodigo(),
										parteNuevoAux.getIdedificio(),
										parteNuevoAux.getIdzona());

						if (tecnicosContrataList.size() > 0) {
							// Hay tecnicos asociados al edificio y clase
							// se asigna automáticamente el parte.
							for (Tecnicos tecnicoContrataAux : tecnicosContrataList) {

								// Insertar en la tabla de ParteTecnicos
								Partetecnicos parteTecnico = new Partetecnicos();
								parteTecnico.setIdparte(parteNuevoAux
										.getIdparte());
								parteTecnico.setIdtecnico(tecnicoContrataAux
										.getIdtecnico());
								parteTecnico.setFinalizado("0");

								if (!observacionesInternas.trim().equals("")) {
									parteTecnico
											.setObservaciones(observacionesInternas);
								}

								Partetecnicos parteTecnicoAux = this.partetecnicosService
										.add(parteTecnico);

								// Si no tiene email se deja como ASIGNACION
								// MANUAL

								/**
								 * MOVILGMAO Se comprueba si el tecnico tiene
								 * aplicacion movilgmao. Si la tiene se crea la
								 * OT correspondiente
								 * 
								 */
								if (tecnicoContrataAux != null
										&& tecnicoContrataAux.getMovilgmao() != null
										&& tecnicoContrataAux.getMovilgmao()
												.equals("1")) {
									this.partesService
											.marcarAutomatica(parteNuevoAux);
									if (parteNuevoAux != null) {
										Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
										elTecnicoParteGmao
												.setIdparte(parteNuevoAux
														.getIdparte());
										elTecnicoParteGmao
												.setIdtecnico(tecnicoAux
														.getIdtecnico());
										elTecnicoParteGmao
												.setIdpartec(parteTecnicoAux
														.getIdpartec());
										String randomUUIDString = "";
										UUID uuid = UUID.randomUUID();
										randomUUIDString = uuid.toString();
										elTecnicoParteGmao
												.setGuidpartetecgmao(randomUUIDString);
										tecnicoParteGmaoAux = this.partetecnicosgmaoServices
												.add(elTecnicoParteGmao);
									}
								} else if (tecnicoContrataAux.getMail() != null) {
									// Actualizar la tabla Partes AUTOMATICA=1
									this.partesService
											.marcarAutomatica(parteNuevoAux);

									// Actualizar la tabla Partes
									// ENVIOMAIL=1
									this.partesService
											.marcarEnvioMail(parteNuevoAux);

									// Enviar email
									try {
										String retorno = this.partesService
												.enviarMailTecnico(
														parteNuevoAux,
														tecnicoContrataAux);
										if ("true".equals(retorno)) {
											// Si ha ido bien el envío de
											// mail se
											// marca
											// enviomail =1 en la tabla
											// TecnicoPartes
											this.partetecnicosService
													.marcarEnvioMail(
															parteNuevoAux
																	.getIdparte(),
															tecnicoContrataAux
																	.getIdtecnico());
										}
										ProcesosGmaoTareasController.logger
												.info("[POST] : email enviado"
														+ retorno);
										// return partesAux;
									} catch (Exception e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									}

								}

								ProcesosGmaoTareasController.logger
										.info("[POST] : Tecnicos encontrados: "
												+ parteTecnicoAux.getIdpartec());
							}

						}

					} else {
						List<Usutecnicos> tecnicosList = this.usuTecnicosService
								.obtenerTecnicosUsuServEdificio(
										codigo.getIdcodigo(),
										parteNuevoAux.getIdedificio(),
										parteNuevoAux.getIdzona(), false);
						ArrayList<Long> arrayTecnicos = new ArrayList<Long>();
						Presencia presencia = new Presencia();
						for (Usutecnicos usuTecnicosAux : tecnicosList) {
							// Comprobar que esten presentes
							// Buscar en la tabla Presencia los tecnicos que
							// tengan con
							// THASTA a 0

							presencia.setIdtecnico(usuTecnicosAux
									.getIdtecnico());
							if (this.presenciaService
									.comprobarTecnicoEstaPresente(presencia)) {
								// El tecnico esta presente
								// Recoger todos los tecnicos y luego
								// seleccionar uno
								// aleatoriamente
								arrayTecnicos
										.add(usuTecnicosAux.getIdtecnico());
							}

							if (arrayTecnicos.size() > 0) {
								// Se trabaja con el tecnico que ha sido
								// elegido
								// aleatoriamente.
								int numAleat = (int) Math.floor(Math.random()
										* (0 - arrayTecnicos.size())
										+ arrayTecnicos.size());
								Long idTecnicoAleat = arrayTecnicos
										.get(numAleat);

								Tecnicos tecnicos = new Tecnicos();
								tecnicos.setIdtecnico(idTecnicoAleat);
								tecnicoAux = this.tecnicosService
										.find(tecnicos);

								// Insertar en la tabla de ParteTecnicos
								Partetecnicos parteTecnico = new Partetecnicos();
								parteTecnico.setIdparte(parteNuevoAux
										.getIdparte());
								parteTecnico.setIdtecnico(tecnicoAux
										.getIdtecnico());
								parteTecnico.setFinalizado("0");
								if (parteNuevoAux != null
										&& parteNuevoAux.getUrgente() != null
										&& parteNuevoAux.getUrgente().equals(
												"1")) {
									parteTecnico.setAceptada(null);
								} else {
									parteTecnico.setAceptada("1");
								}
								if (!observacionesInternas.trim().equals("")) {
									parteTecnico
											.setObservaciones(observacionesInternas);
								}

								Partetecnicos parteTecnicoAux = this.partetecnicosService
										.add(parteTecnico);

								// Si no tiene email se deja como ASIGNACION
								// MANUAL

								/**
								 * Si ha encontrado un técnico, y tiene
								 * aplicación de móvil guardamos el registro en
								 * la tabla de partes gmao para que al mandar el
								 * parte se lo asigne correctamente. Si es un
								 * técnico sin móvil o no ha encontrado ninguno,
								 * se creará el parte en gmao sin técnico
								 * asignado
								 */
								if (tecnicoAux != null
										&& tecnicoAux.getMovilgmao() != null
										&& tecnicoAux.getMovilgmao()
												.equals("1")) {
									this.partesService
											.marcarAutomatica(parteNuevoAux);
									Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
									Partetecnicosgmao elTecnicoParteGmaoNuevo = new Partetecnicosgmao();
									if (parteTecnicoAux != null) {
										elTecnicoParteGmaoNuevo
												.setIdparte(parteNuevoAux
														.getIdparte());
										elTecnicoParteGmaoNuevo
												.setIdtecnico(tecnicoAux
														.getIdtecnico());
										elTecnicoParteGmaoNuevo
												.setIdpartec(parteTecnicoAux
														.getIdpartec());
										String randomUUIDString = "";
										UUID uuid = UUID.randomUUID();
										randomUUIDString = uuid.toString();
										elTecnicoParteGmao
												.setGuidpartetecgmao(randomUUIDString);
										tecnicoParteGmaoAux = this.partetecnicosgmaoServices
												.add(elTecnicoParteGmaoNuevo);
									}
								} else if (tecnicoAux.getMail() != null) {

									// Actualizar la tabla Partes
									// AUTOMATICA=1
									this.partesService
											.marcarAutomatica(parteNuevoAux);
									if (tecnicoAux.getMail() != null) {
										// Actualizar la tabla Partes
										// ENVIOMAIL=1
										this.partesService
												.marcarEnvioMail(parteNuevoAux);

										// Enviar email
										try {
											String retorno = this.partesService
													.enviarMailTecnico(
															parteNuevoAux,
															tecnicoAux);
											if ("true".equals(retorno)) {
												// Si ha ido bien el envío
												// de mail se marca
												// enviomail =1 en la tabla
												// TecnicoPartes
												this.partetecnicosService
														.marcarEnvioMail(
																parteNuevoAux
																		.getIdparte(),
																tecnicoAux
																		.getIdtecnico());
											}
											ProcesosGmaoTareasController.logger
													.info("[POST] : email enviado"
															+ retorno);
											// return partesAux;
										} catch (Exception e) {
											// TODO Auto-generated catch
											// block
											e.printStackTrace();
										}
									}
								}
							}
						}
					}
				}
			}

			// Obtener tecnicos asignados al parte
			// (partetecnicos)
			parteNuevoTecnicoGmaoAux = new Partetecnicosgmao();
			parteNuevoTecnicoGmaoAux.setIdparte(parteNuevoAux.getIdparte());
			List<Partetecnicosgmao> parteNuevoTecnicosGmao = this.partetecnicosgmaoServices
					.findAll(parteNuevoTecnicoGmaoAux, null);

			if (parteNuevoAux.getIddepar() != null) {
				Departamentos departamentoAux = new Departamentos();
				departamentoAux.setIddepar(parteNuevoAux.getIddepar());
				departamentoAux = this.departamentosService
						.find(departamentoAux);
				parteNuevoAux.setDepartamento(departamentoAux);
			}

			if (parteNuevoAux.getIddir() != null) {
				Direcciones direccionAux = new Direcciones();
				direccionAux.setIddir(parteNuevoAux.getIddir());
				direccionAux = this.direccionesService.find(direccionAux);
				parteNuevoAux.setDireccion(direccionAux);
			}

			if (parteNuevoAux.getIdplanta() != null) {
				Plantas plantaAux = new Plantas();
				plantaAux.setIdplanta(parteNuevoAux.getIdplanta());
				plantaAux = this.plantasService.find(plantaAux);
				parteNuevoAux.setPlanta(plantaAux);
			}

			if (parteNuevoAux.getIdzona() != null) {
				Zonas zonaAux = new Zonas();
				zonaAux.setIdzona(parteNuevoAux.getIdzona());
				zonaAux = this.zonasService.find(zonaAux);
				parteNuevoAux.setZona(zonaAux);

			}

			if (parteNuevoAux.getIdespacio() != null) {
				Espacio espacioAux = new Espacio();
				espacioAux.setIdespacio(parteNuevoAux.getIdespacio());
				espacioAux = this.espaciosService.find(espacioAux);
				parteNuevoAux.setEspacio(espacioAux);
			}

			byte[] blobAsBytes = null;
			try {
				if (planoParte != null) {
					// Tiene plano
					int blobLeng = (int) planoParte.getDibujo().length();
					blobAsBytes = planoParte.getDibujo().getBytes(1, blobLeng);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}

			byte[] blobAsBytesPDF = null;
			try {
				if (pdfParte != null) {
					// Tiene plano
					int blobLeng = (int) pdfParte.getPdf().length();
					blobAsBytesPDF = pdfParte.getPdf().getBytes(1, blobLeng);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}

			/**
			 * Se sincronizará con Gmao para crear el parte actualizar los datos
			 * del parte creado con el móvil, añadiendo el numero de OT con el
			 * formato correcto
			 */

			String respuesta = this.procesosJMSService
					.sincronizarParteCorrectivoGmao(parteNuevoAux,
							parteNuevoTecnicosGmao,
							guidedificioFormateado.toLowerCase(), blobAsBytes,
							blobAsBytesPDF, urlConfig);

			/**
			 * Se sincroniza la OT nueva para confirmarla
			 */
			String fechaSinc = "";
			if (ot.get("FechaSinc") != JSONObject.NULL) {
				fechaSinc = ot.getString("FechaSinc");
			}
			JSONObject pdteSincOtOK = new JSONObject();
			JSONArray valoresOTbajada = new JSONArray();
			JSONObject valorBajada = new JSONObject();
			valorBajada.put("UUIdOt", guidpartehijaFormateado);
			valorBajada.put("FechaUltimaSinc", fechaSinc);
			valoresOTbajada.put(valorBajada);
			pdteSincOtOK.put("ots", valoresOTbajada);
			respuesta = this.procesosJMSService.sincronizarGmao(pdteSincOtOK,
					urlConfig + Aa20bConstantes.URL_MARCAR_SINC_OK);

			/**
			 * Después de confirmarla se sube la información con la asignación
			 * del operario a MovilGmao
			 */
			respuesta = this.procesosJMSService
					.sincronizarParteCorrectivoGmao(parteNuevoAux,
							parteNuevoTecnicosGmao,
							guidedificioFormateado.toLowerCase(), null, null,
							urlConfig);

			if (respuesta.equals("OK")) {
				parteNuevoBienCreado = true;
			} else {
				parteNuevoBienCreado = false;
			}

		} else {
			parteNuevoBienCreado = false;
		}

		return parteNuevoBienCreado;

	}

	private String actualizarPresenciaTecnicos(String strJson, String urlConfig) {
		String respuesta = "OK";

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try {
			JSONArray datosUsuarios = new JSONArray(strJson);
			if (datosUsuarios.length() > 0) {
				for (int i = 0; i < datosUsuarios.length(); i++) {

					Tecnicos tecnicoAux = new Tecnicos();

					JSONObject usuario = datosUsuarios.getJSONObject(i);

					String rol = "";
					if (usuario.get("IDRol") != JSONObject.NULL) {
						rol = usuario.getString("IDRol");
					}

					/**
					 * Los roles de cambio de idioma no los procesamos
					 */
					if (rol != null && !rol.equals("IdiomaCap")) {
						String codUsuario = "";
						if (usuario.get("CodOperario") != JSONObject.NULL) {
							codUsuario = usuario.getString("CodOperario");
							try {
								Integer.parseInt(usuario
										.getString("CodOperario"));
								tecnicoAux.setIdtecnico(Long
										.valueOf(codUsuario));
							} catch (NumberFormatException nfe) {
								tecnicoAux.setIdtecnico(null);
							}

						}

						String fechaHastaStr = "";
						Date fechaHastaDate = null;
						Date fechaActual = new Date();
						if (usuario.get("UltimaFechaSinc") != JSONObject.NULL) {
							fechaHastaStr = usuario
									.getString("UltimaFechaSinc");

							try {
								fechaHastaDate = sdf.parse(fechaHastaStr);
							} catch (ParseException e) {
								ProcesosGmaoTareasController.logger
										.error("[MOVILGMAO] : actualizarPresenciaTecnicos - formatear fecha ultima sinc: "
												+ e.getMessage());
							}

						}

						String thasta = "";
						boolean estaPresente = true;
						boolean noEsUsuarioNormal = false;
						if (usuario.get("IMEI") != JSONObject.NULL) {
							if (usuario.getString("IMEI").equals("undefined")) {
								noEsUsuarioNormal = true;
							}
							fechaHastaDate = null;
							thasta = "0";
							estaPresente = true;
						} else {
							thasta = "5";
							estaPresente = false;
						}

						if (usuario.get("Login") != JSONObject.NULL
								&& !usuario.getString("Login").equals("zzxua")
								&& !usuario.getString("Login").equals("xuacu2")
								&& !noEsUsuarioNormal) {

							// Comprobacion de que existe el técnico en nuestra
							// aplicación
							tecnicoAux = this.tecnicosService.find(tecnicoAux);

							if (tecnicoAux != null) {
								Presencia presenciaAux = new Presencia();
								presenciaAux.setIdtecnico(tecnicoAux
										.getIdtecnico());

								List<Presencia> listaPresencias = this.presenciaService
										.obtenerPresencias(presenciaAux, null,
												false);

								for (Presencia presencia : listaPresencias) {
									if (presencia.getThasta() != null
											&& presencia.getThasta()
													.equals("0")) {
										presenciaAux.setIdpresencia(presencia
												.getIdpresencia());
										if (!estaPresente) {
											/**
											 * Si el técnico estaba presente y
											 * se ha desvinculado en la app,
											 * actualizaremos la presencia para
											 * indicar que ya no está disponible
											 */
											//
											presenciaAux.setFhdesde(presencia
													.getFhdesde());
											presenciaAux
													.setFhhasta(fechaActual);
											presenciaAux.setTdesde("4");
											presenciaAux.setThasta(thasta);

											presenciaAux = this.presenciaService
													.update(presenciaAux);

											/**
											 * De cada técnico se obtienen los
											 * partes correctivos y preventivos
											 * que tiene en curso para ponerlos
											 * en pausa
											 */
											this.tratamientoPausarPartesTecnicosLoginLogout(
													tecnicoAux, "CURS", "0",
													"PAUSA", true, urlConfig);

										}
									} else if (presencia.getThasta() != null
											&& !presencia.getThasta().equals(
													"0")) {
										presenciaAux.setIdpresencia(presencia
												.getIdpresencia());
										if (estaPresente) {
											// Si el tecnico no estaba presente
											// y
											// ahora
											// ha
											// hecho login en la aplicación
											// insertaremos la presencia
											presenciaAux
													.setFhdesde(fechaActual);
											presenciaAux
													.setFhhasta(fechaHastaDate);
											presenciaAux.setTdesde("4");
											presenciaAux.setThasta(thasta);

											presenciaAux = this.presenciaService
													.nuevaPresencia(presenciaAux);

											/**
											 * De cada técnico se obtienen los
											 * partes correctivos y preventivos
											 * que tiene en curso para ponerlos
											 * en pausa
											 */
											this.tratamientoPausarPartesTecnicosLoginLogout(
													tecnicoAux, "PAUSA", "1",
													"CURS", false, urlConfig);

										}
									}
								}
							}
						}
					}
				}
			}
		} catch (Exception e) {
			respuesta = "KO";
		}

		return respuesta;

	}

	private String tratamientoPartesCorrectivos(JSONObject ot,
			JSONArray operarios, JSONArray otmods, JSONArray logs,
			JSONArray campos, String guidpartehijaFormateado, String urlConfig,
			String guidpartehija) {

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String respuesta = "";

		// boolean comprobarCambioEstadoCorrectiva = true;
		boolean parteNuevoBienCreado = true;
		String pdteSinc = "";
		if (ot.get("PdteSinc") != JSONObject.NULL) {
			pdteSinc = ot.getString("PdteSinc");
		}

		if (!pdteSinc.equals("0") && !pdteSinc.equals("")) {
			// FechaSinc
			String fechaSinc = "";
			if (ot.get("FechaSinc") != JSONObject.NULL) {
				fechaSinc = ot.getString("FechaSinc");
			}

			Partetecnicosgmao partetecnicosgmaoAux = new Partetecnicosgmao();
			partetecnicosgmaoAux.setGuidpartetecgmao(guidpartehijaFormateado);
			partetecnicosgmaoAux = this.partetecnicosgmaoServices
					.findByGUID(partetecnicosgmaoAux);

			/**
			 * Comprobación para saber si se trata de una OT nueva creada desde
			 * la app movil o planner
			 */
			if (partetecnicosgmaoAux == null) {
				/**
				 * Si se trata de una OT nueva, se crea el parte en nuestra
				 * aplicación
				 */
				parteNuevoBienCreado = this
						.crearParteCorrectivoNuevoDesdeMovilGmao(
								guidpartehijaFormateado, urlConfig, ot);
				partetecnicosgmaoAux = new Partetecnicosgmao();
				partetecnicosgmaoAux
						.setGuidpartetecgmao(guidpartehijaFormateado);
				partetecnicosgmaoAux = this.partetecnicosgmaoServices
						.findByGUID(partetecnicosgmaoAux);
			}
			if (parteNuevoBienCreado) {

				/**
				 * Si el parte correctivo no tenía técnico asignado y ahora ya
				 * le han asignado
				 */
				if (partetecnicosgmaoAux.getIdpartec() == null
						|| (partetecnicosgmaoAux.getIdpartec() != null && partetecnicosgmaoAux
								.getIdpartec() == 0)) {

					String tecnicoResp = "";
					if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
						tecnicoResp = ot.getString("IdOperarioResponsable");
						Partetecnicos partetecnicoNueva = new Partetecnicos();
						partetecnicoNueva.setIdparte(partetecnicosgmaoAux
								.getIdparte());
						partetecnicoNueva.setIdtecnico(Long
								.valueOf(tecnicoResp));
						partetecnicoNueva.setAceptada("1");

						partetecnicoNueva = this.partetecnicosService
								.add(partetecnicoNueva);

						String respuestaAceptada = this.procesosJMSService
								.marcarOTaceptada(partetecnicosgmaoAux
										.getGuidpartetecgmao(), "1", urlConfig);

						partetecnicosgmaoAux.setIdtecnico(Long
								.valueOf(tecnicoResp));
						partetecnicosgmaoAux.setIdpartec(partetecnicoNueva
								.getIdpartec());
						partetecnicosgmaoAux
								.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO);

						Date fechaSincDate = null;
						try {
							fechaSincDate = sdf.parse(fechaSinc);

						} catch (ParseException e) {
							ProcesosGmaoTareasController.logger
									.error("[MOVILGMAO] : tratamientoPartesCorrectivos - formatear fecha sinc: "
											+ e.getMessage()
											+ "; IdParte: "
											+ partetecnicosgmaoAux.getIdparte()
											+ "; IdTecnico:"
											+ partetecnicosgmaoAux
													.getIdtecnico());
						}

						partetecnicosgmaoAux.setFechaEstadoGmao(fechaSincDate);

						partetecnicosgmaoAux = this.partetecnicosgmaoServices
								.update(partetecnicosgmaoAux);
					}
				}

				if (partetecnicosgmaoAux.getIdpartec() != null
						&& partetecnicosgmaoAux.getIdpartec() != 0) {

					Parteejecucion parteEjecucionAux = new Parteejecucion();
					parteEjecucionAux.setIdpartec(partetecnicosgmaoAux
							.getIdpartec());
					List<Parteejecucion> partesEjecucionTecnico = this.parteejecucionServices
							.findAll(parteEjecucionAux, null);

					Partetecnicos partetecnicosAux = new Partetecnicos();
					partetecnicosAux.setIdpartec(partetecnicosgmaoAux
							.getIdpartec());

					partetecnicosAux = this.partetecnicosService
							.find(partetecnicosAux);

					// Operarios
					String tecnicoResp = "";
					if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
						tecnicoResp = ot.getString("IdOperarioResponsable");
					}
					String idEstadoOT = "";
					if (ot.get("IdEstado") != JSONObject.NULL) {
						idEstadoOT = ot.getString("IdEstado");
					}
					if (!idEstadoOT
							.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO)) {
						this.tratamientoOperariosParteCorrectivo(operarios,
								partetecnicosAux, partetecnicosgmaoAux,
								guidpartehija, tecnicoResp, urlConfig);
					}

					// Aceptada
					String aceptada = "";
					if (ot.get("Aceptada") != JSONObject.NULL) {
						aceptada = ot.get("Aceptada").toString();

						if (partetecnicosAux != null
								&& ((partetecnicosAux.getAceptada() != null && !partetecnicosAux
										.getAceptada().equals(aceptada)) || partetecnicosAux
										.getAceptada() == null)) {
							partetecnicosAux.setAceptada(aceptada);
							partetecnicosAux = this.partetecnicosService
									.update(partetecnicosAux);

							// Si el técnico ha rechazadado el parte y
							// el
							// parte es de asignación
							// automática, se deberá asignar
							// automáticamente
							// al siguiente técnico
							// que tenga aplicación movilgmao
							/*
							 * if (aceptada.equals("0")) { Partes parteAux = new
							 * Partes();
							 * parteAux.setIdparte(partetecnicosgmaoAux
							 * .getIdparte()); parteAux =
							 * this.partesService.find(parteAux);
							 * 
							 * // Como ha rechazado el parte, // eliminamos el
							 * // técnico del parte // tanto en la aa20b como en
							 * MovilGmao // (sincronizar)
							 * this.eliminarTecnicoRechazada(parteAux,
							 * partetecnicosAux, partetecnicosgmaoAux,
							 * urlConfig);
							 * 
							 * if (parteAux != null && parteAux.getAutomatica()
							 * != null && parteAux.getAutomatica().equals("1"))
							 * {
							 * 
							 * this.asignarParteCorrectivoAutomatico(parteAux,
							 * partetecnicosAux, urlConfig);
							 * 
							 * } }
							 */
						}

					}

					// Documentos
					// Si tiene más de un documento significa que tiene
					// el
					// PDF
					// guardado con la firma y descripción
					/*
					 * if (documentos.length() > 1) { for (int x = 0; x <
					 * documentos.length(); x++) { JSONObject otdocumento =
					 * documentos.getJSONObject(x); if (otdocumento != null &&
					 * otdocumento.get("UUIdOtDocumento") != JSONObject.NULL &&
					 * !otdocumento .getString("UUIdOtDocumento")
					 * .equalsIgnoreCase( partetecnicosgmaoAux
					 * .getGuidplanopartegmao())) { // Es el documento PDF que
					 * no tenemos, guardamos si // UUId if (partetecnicosgmaoAux
					 * != null && (partetecnicosgmaoAux.getGuidpdf() == null ||
					 * partetecnicosgmaoAux .getGuidpdf() != null &&
					 * partetecnicosgmaoAux .getGuidpdf().trim() .equals(""))) {
					 * partetecnicosgmaoAux.setGuidpdf(otdocumento
					 * .getString("UUIdOtDocumento"));
					 * 
					 * partetecnicosgmaoAux = this.partetecnicosgmaoServices
					 * .update(partetecnicosgmaoAux); } } } }
					 */

					// MODS
					/*
					 * this.tratamientoModsParteCorrectivo(otmods,
					 * parteEjecucionAux, partetecnicosgmaoAux,
					 * partetecnicosAux, partesEjecucionTecnico, guidpartehija,
					 * sdf);
					 */

					// NOTAS TECNICO
					for (int z = 0; z < campos.length(); z++) {
						// comprobarCambioEstadoCorrectiva = false;
						JSONObject otcampo = campos.getJSONObject(z);
						if (otcampo != null
								&& otcampo.get("UUIdOt") != JSONObject.NULL
								&& otcampo.getString("UUIdOt")
										.equalsIgnoreCase(guidpartehija)) {

							String notasTecnico = "";
							if (otcampo.get("IdCampo") != JSONObject.NULL
									&& otcampo.getString("IdCampo").equals(
											"NOTASTEC")) {
								if (otcampo.get("Valor") != JSONObject.NULL
										&& !otcampo.getString("Valor").equals(
												"")) {
									notasTecnico = otcampo.getString("Valor");

									partetecnicosAux.setNotasTec(notasTecnico);
									partetecnicosAux = this.partetecnicosService
											.update(partetecnicosAux);
								}

							}

						}
					}

					/**
					 * Si el parte no tiene mano de obra, deberemos comprobar si
					 * es que ha cambiado de estado de ASIGNADA (ASIG) a EN
					 * CURSO (CURS) o de EN CURSO (CURS) a TERMINADA (TERM)
					 */
					// if (comprobarCambioEstadoCorrectiva) {
					this.tratamientoCambioEstadosParteCorrectivo(logs,
							parteEjecucionAux, guidpartehijaFormateado, sdf,
							urlConfig);
					// }

					/**
					 * Se comprueba si el parte se ha finalizado o no o si ya
					 * estaba finalizado
					 */

					if ((partetecnicosAux != null
							&& partetecnicosAux.getFinalizado() != null
							&& !partetecnicosAux.getFinalizado().equals("1") && idEstadoOT
							.equals("TERM"))
							|| (partetecnicosAux != null
									&& partetecnicosAux.getFinalizado() == null && idEstadoOT
									.equals("TERM"))) {
						partetecnicosAux.setFinalizado("1");
						partetecnicosAux = this.partetecnicosService
								.update(partetecnicosAux);

						/**
						 * Si no está finalizado se comprueba si todos los demás
						 * tecnicos de este parte han finalizado sus ejecuciones
						 * Para saber si finalizar el parte padre de todo
						 */
						Partetecnicos partetecnicospadre = new Partetecnicos();
						partetecnicospadre.setIdparte(partetecnicosgmaoAux
								.getIdparte());
						List<Partetecnicos> listaParteTecnicosAux = this.partetecnicosService
								.findAll(partetecnicospadre, null);

						boolean finalizarParte = true;
						for (Partetecnicos partetecnicopadre : listaParteTecnicosAux) {
							if (partetecnicopadre != null
									&& ((partetecnicopadre.getFinalizado() != null && !partetecnicopadre
											.getFinalizado().equals("1")) || partetecnicopadre
											.getFinalizado() == null)) {
								finalizarParte = false;
							}
						}

						// Si todos los técnicos han finalizado sus
						// ejecuciones
						if (finalizarParte) {

							// Recalculamos el tiempo de ejecución
							this.parteejecucionServices
									.recalcularTiempoParteTecnico(partetecnicosgmaoAux
											.getIdpartec());

							this.finalizarParteCorrectivoMovilgmao(
									partetecnicosgmaoAux, urlConfig);

						}
					}
					// Recalculamos el tiempo de ejecución
					this.parteejecucionServices
							.recalcularTiempoParteTecnico(partetecnicosgmaoAux
									.getIdpartec());

					// Firma conformidad (Indicará si se ha finalizado)
					this.tratamientoFirmaParteCorrectivo(ot,
							partetecnicosgmaoAux);

					/*
					 * ot.get("IdEstado"); ot.get("IdTipo");
					 * ot.get("IdOperarioResponsable"); ot.get("Aceptada");
					 * ot.get("FirmaConformidad"); ot.get("UUIdOt");
					 * ot.get("FechaSinc"); ot.get("UUIdActivo");
					 * ot.get("UUIdOtPadre");
					 */

					/**
					 * Fecha planificacion Si ha cambiado desde el planner de
					 * día el parte
					 */
					String fechaplanif = "";
					if (ot.get("FechaPlanificacion") != JSONObject.NULL) {
						fechaplanif = ot.getString("FechaPlanificacion");

						Date fechaPlanifGmao = null;

						try {
							fechaPlanifGmao = sdf.parse(fechaplanif);

							Partes parteAux = new Partes();
							parteAux.setIdparte(partetecnicosgmaoAux
									.getIdparte());
							parteAux.setFechaplanif(fechaPlanifGmao);

							parteAux = this.partesService
									.actualizarFechaPlanificacion(parteAux);

						} catch (ParseException e) {
							ProcesosGmaoTareasController.logger
									.error("[MOVILGMAO] : bajarOTs - formatear fecha planif: "
											+ e.getMessage());
						}

					}

					// Sincronizamos con MovilGmao para indicar que este parte
					// ya se
					// ha sincronizado OK
					JSONObject pdteSincOtOK = new JSONObject();
					JSONArray valoresOTbajada = new JSONArray();
					JSONObject valorBajada = new JSONObject();
					valorBajada.put("UUIdOt", guidpartehijaFormateado);
					valorBajada.put("FechaUltimaSinc", fechaSinc);
					valoresOTbajada.put(valorBajada);
					pdteSincOtOK.put("ots", valoresOTbajada);
					respuesta = this.procesosJMSService.sincronizarGmao(
							pdteSincOtOK, urlConfig
									+ Aa20bConstantes.URL_MARCAR_SINC_OK);
				}
			}
		}

		return respuesta;

	}

	private String tratamientoPartesPreventivos(JSONObject ot,
			JSONArray operarios, JSONArray otmods, JSONArray revisiones,
			JSONArray logs, JSONArray campos, String guidpartehijaFormateado,
			String guidpartehija, String urlConfig) {

		String respuesta = "";
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		// boolean comprobarCambioEstadoPreventiva = true;
		/*
		 * String guidpartepadreFormateado = ""; if (ot.get("UUIdOtPadre") !=
		 * JSONObject.NULL) { guidpartepadreFormateado =
		 * ot.getString("UUIdOtPadre").replace("{", "");
		 * guidpartepadreFormateado = guidpartepadreFormateado .replace("}",
		 * ""); } else { guidpartepadreFormateado =
		 * ot.getString("UUIdOt").replace("{", ""); guidpartepadreFormateado =
		 * guidpartepadreFormateado .replace("}", ""); if
		 * (guidpartepadreFormateado != null &&
		 * !guidpartepadreFormateado.equals("")) { guidpartepadreFormateado =
		 * guidpartepadreFormateado .toLowerCase(); } }
		 */

		String pdteSinc = "";
		if (ot.get("PdteSinc") != JSONObject.NULL) {
			pdteSinc = ot.getString("PdteSinc");
		}

		if (!pdteSinc.equals("0") && !pdteSinc.equals("")) {
			// FechaSinc
			String fechaSinc = "";
			if (ot.get("FechaSinc") != JSONObject.NULL) {
				fechaSinc = ot.getString("FechaSinc");
			}
			boolean fichaNuevoBienCreado = true;
			Fichatecnicosgmao fichatecnicosgmaoAux = new Fichatecnicosgmao();
			fichatecnicosgmaoAux.setGuidfichatecgmao(guidpartehijaFormateado);
			fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
					.findByGUID(fichatecnicosgmaoAux);

			/**
			 * Comprobación para saber si se trata de una OT de seguimiento o de
			 * ayuda creada desde la app movil
			 */
			if (fichatecnicosgmaoAux == null) {
				/**
				 * Si se trata de una OT de seguimiento o de ayuda
				 */
				fichaNuevoBienCreado = this
						.tratamientoParteAyudaSeguimientoCorrectivoDesdeMovilGmao(
								guidpartehijaFormateado, urlConfig, ot);
				fichatecnicosgmaoAux = new Fichatecnicosgmao();
				fichatecnicosgmaoAux
						.setGuidfichatecgmao(guidpartehijaFormateado);
				fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
						.findByGUID(fichatecnicosgmaoAux);
			}

			if (fichaNuevoBienCreado) {

				if (fichatecnicosgmaoAux != null) {
					Ficha fichaAux = new Ficha();
					/*
					 * fichaAux.setGuidficha(guidpartepadreFormateado); fichaAux
					 * = this.fichasService .findFichaByGuid(fichaAux);
					 */

					fichaAux.setIdficha(fichatecnicosgmaoAux.getIdficha());
					fichaAux = this.fichasService.findFicha(fichaAux);
					// Comprobamos si la ficha es nula por si acaso se ha
					// borrado
					// de nuestra aplic y de movilgmao no
					if (fichaAux != null) {
						Maquinas maquinaAux = this.maquinasService
								.obtenerMaquina(fichaAux.getIdmaquina()
										.toString());

						Gamas gamaAux = this.gamasService
								.obtenerGama(maquinaAux.getIdgama().toString());

						/**
						 * Si el parte preventivo no tenía técnico asignado y
						 * ahora ya le han asignado
						 * 
						 */
						if (fichatecnicosgmaoAux.getIdfichac() == null
								|| (fichatecnicosgmaoAux.getIdfichac() != null && fichatecnicosgmaoAux
										.getIdfichac() == 0)) {
							String tecnicoResp = "";
							if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
								tecnicoResp = ot
										.getString("IdOperarioResponsable");
								Fichatecnico fichatecnicoNueva = new Fichatecnico();
								fichatecnicoNueva
										.setIdficha(fichatecnicosgmaoAux
												.getIdficha());
								fichatecnicoNueva.setIdtecnico(Long
										.valueOf(tecnicoResp));
								fichatecnicoNueva.setAceptada("1");

								fichatecnicoNueva = this.fichatecnicosService
										.add(fichatecnicoNueva);

								String respuestaAceptada = this.procesosJMSService
										.marcarOTaceptada(fichatecnicosgmaoAux
												.getGuidfichatecgmao(), "1",
												urlConfig);

								fichatecnicosgmaoAux.setIdtecnico(Long
										.valueOf(tecnicoResp));
								fichatecnicosgmaoAux
										.setIdfichac(fichatecnicoNueva
												.getIdfitec());
								fichatecnicosgmaoAux
										.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO);

								Date fechaSincDate = null;
								try {
									fechaSincDate = sdf.parse(fechaSinc);

								} catch (ParseException e) {
									ProcesosGmaoTareasController.logger
											.error("[MOVILGMAO] : tratamientoPartesPreventivos - formatear fecha sinc: "
													+ e.getMessage()
													+ "; IdParte: "
													+ fichatecnicosgmaoAux
															.getIdficha()
													+ "; IdTecnico:"
													+ fichatecnicosgmaoAux
															.getIdtecnico());
								}

								fichatecnicosgmaoAux
										.setFechaEstadoGmao(fechaSincDate);

								fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
										.update(fichatecnicosgmaoAux);
							}
						}

						if (fichatecnicosgmaoAux.getIdfichac() != null
								&& fichatecnicosgmaoAux.getIdfichac() != 0) {

							Fichaejecucion fichaEjecucionAux = new Fichaejecucion();
							fichaEjecucionAux.setIdfitec(fichatecnicosgmaoAux
									.getIdfichac());
							List<Fichaejecucion> fichasEjecucionTecnico = this.fichaejecucionServices
									.findAll(fichaEjecucionAux, null);

							Fichatecnico fichatecnicosAux = new Fichatecnico();
							fichatecnicosAux = this.fichatecnicosService
									.obtenerFicha(fichatecnicosgmaoAux
											.getIdfichac());

							// Operarios
							String tecnicoResp = "";
							if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
								tecnicoResp = ot
										.getString("IdOperarioResponsable");
							}

							String idEstadoOT = "";
							if (ot.get("IdEstado") != JSONObject.NULL) {
								idEstadoOT = ot.getString("IdEstado");
							}

							// Si el parte no esta finalizado, comprobamos si ha
							// cambiado el técnico
							if (!idEstadoOT
									.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO)) {
								this.tratamientoOperariosPartePreventivo(
										operarios, fichatecnicosAux,
										fichatecnicosgmaoAux, guidpartehija,
										tecnicoResp);
							}

							// Aceptada
							String aceptada = "";
							if (ot.get("Aceptada") != JSONObject.NULL) {
								aceptada = ot.get("Aceptada").toString();

								if (fichatecnicosAux != null
										&& ((fichatecnicosAux.getAceptada() != null && !fichatecnicosAux
												.getAceptada().equals(aceptada)) || fichatecnicosAux
												.getAceptada() == null)) {
									fichatecnicosAux.setAceptada(aceptada);
									fichatecnicosAux = this.fichatecnicosService
											.update(fichatecnicosAux);
								}

							}

							// Revisiones
							this.tratamientoRevisionesPartePreventivo(
									revisiones, fichaAux, fichatecnicosgmaoAux,
									maquinaAux, gamaAux, fechaSinc,
									guidpartehija, sdf);

							// MODS
							/*
							 * this.tratamientoModsPartePreventivo(otmods,
							 * fichaEjecucionAux, fichatecnicosAux,
							 * fichatecnicosgmaoAux, fichasEjecucionTecnico,
							 * guidpartehija, sdf);
							 */

							// NOTAS TECNICO
							for (int z = 0; z < campos.length(); z++) {
								JSONObject otcampo = campos.getJSONObject(z);
								if (otcampo != null
										&& otcampo.get("UUIdOt") != JSONObject.NULL
										&& otcampo
												.getString("UUIdOt")
												.equalsIgnoreCase(guidpartehija)) {

									String notasTecnico = "";
									if (otcampo.get("IdCampo") != JSONObject.NULL
											&& otcampo.getString("IdCampo")
													.equals("NOTASTEC")) {
										if (otcampo.get("Valor") != JSONObject.NULL
												&& !otcampo.getString("Valor")
														.equals("")) {
											notasTecnico = otcampo
													.getString("Valor");

											fichatecnicosAux
													.setNotasTec(notasTecnico);
											fichatecnicosAux = this.fichatecnicosService
													.update(fichatecnicosAux);
										}

									}

								}
							}

							/**
							 * Se comprueba si el parte se ha finalizado o no o
							 * si ya estaba finalizado
							 */

							/**
							 * Si el parte no tiene mano de obra, deberemos
							 * comprobar si es que ha cambiado de estado de
							 * ASIGNADA (ASIG) a EN CURSO (CURS) o de EN CURSO
							 * (CURS) a TERMINADA (TERM)
							 */
							// if (comprobarCambioEstadoPreventiva) {
							this.tratamientoCambioEstadosPartePreventivo(logs,
									fichaEjecucionAux, guidpartehijaFormateado,
									sdf, urlConfig);
							// }

							if ((fichatecnicosAux != null
									&& fichatecnicosAux.getFinalizado() != null
									&& !fichatecnicosAux.getFinalizado()
											.equals("1") || idEstadoOT
									.equals("TERM"))
									|| (fichatecnicosAux.getFinalizado() == null && idEstadoOT
											.equals("TERM"))) {
								fichatecnicosAux.setFinalizado("1");
								fichatecnicosAux = this.fichatecnicosService
										.update(fichatecnicosAux);

								/**
								 * Si no está finalizado se comprueba si todos
								 * los demás tecnicos de este parte han
								 * finalizado sus ejecuciones Para saber si
								 * finalizar el parte padre de todo
								 */
								Fichatecnico fichatecnicospadre = new Fichatecnico();
								fichatecnicospadre
										.setIdficha(fichatecnicosgmaoAux
												.getIdficha());
								List<Fichatecnico> listaFichaTecnicosAux = this.fichatecnicosService
										.findAll(fichatecnicospadre, null);

								boolean finalizarParte = true;
								for (Fichatecnico fichatecnicopadre : listaFichaTecnicosAux) {
									if (fichatecnicopadre != null
											&& ((fichatecnicopadre
													.getFinalizado() != null && !fichatecnicopadre
													.getFinalizado()
													.equals("1")) || fichatecnicopadre
													.getFinalizado() == null)) {
										finalizarParte = false;
									}
								}

								// Si todos los técnicos han finalizado sus
								// ejecuciones
								if (finalizarParte) {

									this.fichaejecucionServices
											.recalcularTiempoFichaTecnico(fichatecnicosAux
													.getIdfitec());
									this.finalizarPartePreventivoMovilgmao(
											fichatecnicosgmaoAux, maquinaAux,
											urlConfig);

								}

							}

							this.fichaejecucionServices
									.recalcularTiempoFichaTecnico(fichatecnicosAux
											.getIdfitec());

							// Firma conformidad (Indicará si se ha finalizado)
							this.tratamientoFirmaPartePreventivo(ot,
									fichatecnicosgmaoAux);
						}

						/**
						 * Fecha planificacion Si ha cambiado desde el planner
						 * de día el parte
						 */
						String fechaplanif = "";
						if (ot.get("FechaPlanificacion") != JSONObject.NULL) {
							fechaplanif = ot.getString("FechaPlanificacion");

							Date fechaPlanifGmao = null;

							try {
								fechaPlanifGmao = sdf.parse(fechaplanif);
								fichaAux.setFechaplanif(fechaPlanifGmao);
								fichaAux = this.fichasService
										.actualizarFechaPlanificacion(fichaAux);

							} catch (ParseException e) {
								ProcesosGmaoTareasController.logger
										.error("[MOVILGMAO] : bajarOTs - formatear fecha planif: "
												+ e.getMessage());
							}
						}
					}
				}
			}

			JSONObject pdteSincOtOK = new JSONObject();
			JSONArray valoresOTbajada = new JSONArray();
			JSONObject valorBajada = new JSONObject();
			valorBajada.put("UUIdOt", guidpartehijaFormateado);
			valorBajada.put("FechaUltimaSinc", fechaSinc);
			valoresOTbajada.put(valorBajada);
			pdteSincOtOK.put("ots", valoresOTbajada);
			respuesta = this.procesosJMSService.sincronizarGmao(pdteSincOtOK,
					urlConfig + Aa20bConstantes.URL_MARCAR_SINC_OK);
		}

		return respuesta;
	}

	private void tratamientoOperariosParteCorrectivo(JSONArray operarios,
			Partetecnicos partetecnicosAux,
			Partetecnicosgmao partetecnicosgmaoAux, String guidpartehija,
			String tecnicoResponsable, String urlConfig) {

		if (partetecnicosAux != null
				&& partetecnicosAux.getIdtecnico() != null
				&& !partetecnicosAux.getIdtecnico().toString()
						.equalsIgnoreCase(tecnicoResponsable)) {
			// Si no coincide y tiene tecnicoResponsable desde movilgmao
			// significa que ha cambiado de operario
			if (!tecnicoResponsable.equals("")) {
				partetecnicosAux.setIdtecnico(Long.valueOf(tecnicoResponsable));
				partetecnicosgmaoAux.setIdtecnico(Long
						.valueOf(tecnicoResponsable));
				partetecnicosAux = this.partetecnicosService
						.update(partetecnicosAux);
			} else {
				partetecnicosAux.setIdtecnico(null);
				partetecnicosgmaoAux.setIdtecnico(null);
				partetecnicosgmaoAux.setIdpartec(null);
				partetecnicosgmaoAux.setEstadoGmao(null);
				this.partetecnicosService.remove(partetecnicosAux);

				/**
				 * Comprobamos si el parte tiene más técnicos asignados en ese
				 * caso no dejamos el parte sin asignar en el planner y lo
				 * eliminamos
				 */
				Partetecnicosgmao partetecgmaoBusqAux = new Partetecnicosgmao();
				partetecgmaoBusqAux.setIdparte(partetecnicosgmaoAux
						.getIdparte());
				List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
						.findAll(partetecgmaoBusqAux, null);

				if (parteTecnicosGmao.size() > 1) {
					int contadorTecnicos = parteTecnicosGmao.size();
					int contadorBorrados = 1;
					for (Partetecnicosgmao partetecgmaoAux : parteTecnicosGmao) {
						if (partetecgmaoAux != null
								&& (partetecgmaoAux.getIdtecnico() == null || partetecgmaoAux
										.getIdtecnico() == 0)
								&& contadorBorrados != contadorTecnicos) {
							this.procesosJMSService.eliminarOTpadre(
									partetecgmaoAux.getGuidpartetecgmao(),
									urlConfig);
							this.partetecnicosgmaoServices
									.remove(partetecgmaoAux);
							contadorBorrados++;
						}

					}
				}

			}
			partetecnicosgmaoAux = this.partetecnicosgmaoServices
					.update(partetecnicosgmaoAux);
		}

		/*
		 * for (int y = 0; y < operarios.length(); y++) { // if
		 * (operarios.length() > 0) { JSONObject otoperario =
		 * operarios.getJSONObject(y); if (otoperario != null &&
		 * otoperario.get("UUIdOt") != JSONObject.NULL &&
		 * otoperario.getString("UUIdOt").equalsIgnoreCase( guidpartehija)) {
		 * 
		 * // Comprobamos si ha cambiado de operario // desde el planner o app
		 * String idOperarioOT = ""; if (otoperario.get("IdOperario") !=
		 * JSONObject.NULL) { idOperarioOT = otoperario.getString("IdOperario");
		 * 
		 * if (partetecnicosAux != null && partetecnicosAux.getIdtecnico() !=
		 * null && !partetecnicosAux.getIdtecnico().toString()
		 * .equalsIgnoreCase(idOperarioOT)) { // Si no coincide significa que ha
		 * // cambiado de operario partetecnicosAux.setIdtecnico(Long
		 * .valueOf(idOperarioOT));
		 * 
		 * partetecnicosgmaoAux.setIdtecnico(Long .valueOf(idOperarioOT));
		 * 
		 * partetecnicosAux = this.partetecnicosService
		 * .update(partetecnicosAux);
		 * 
		 * partetecnicosgmaoAux = this.partetecnicosgmaoServices
		 * .update(partetecnicosgmaoAux); }
		 * 
		 * } } }
		 */
	}

	private void tratamientoModsParteCorrectivo(JSONArray otmods,
			Parteejecucion parteEjecucionAux,
			Partetecnicosgmao partetecnicosgmaoAux,
			Partetecnicos partetecnicosAux,
			List<Parteejecucion> partesEjecucionTecnico, String guidpartehija,
			SimpleDateFormat sdf) {
		// boolean comprobarCambioEstadoCorrectiva = true;
		for (int z = 0; z < otmods.length(); z++) {
			// comprobarCambioEstadoCorrectiva = false;
			JSONObject otmod = otmods.getJSONObject(z);
			if (otmod != null
					&& otmod.get("UUIdOt") != JSONObject.NULL
					&& otmod.getString("UUIdOt")
							.equalsIgnoreCase(guidpartehija)) {

				parteEjecucionAux = new Parteejecucion();
				/*
				 * String idHora = ""; if (otmod.get("IdHora") != null) { idHora
				 * = otmod.getString("IdHora"); }
				 */
				String fechaEjecInicio = "";
				String fechaEjecFin = "";

				if (otmod.get("HoraInicio") != JSONObject.NULL) {
					fechaEjecInicio = otmod.getString("HoraInicio");
				}
				if (otmod.get("HoraFin") != JSONObject.NULL) {
					fechaEjecFin = otmod.getString("HoraFin");
				}

				Date fechaEjecInicioDate = null;
				Date fechaEjecFinDate = null;
				try {
					fechaEjecInicioDate = sdf.parse(fechaEjecInicio);
					fechaEjecFinDate = sdf.parse(fechaEjecFin);
				} catch (ParseException e) {
					ProcesosGmaoTareasController.logger
							.error("[MOVILGMAO] : bajarOTs - formatear fecha ejec: "
									+ e.getMessage()
									+ "; IdParte: "
									+ partetecnicosgmaoAux.getIdparte()
									+ "; IdTecnico:"
									+ partetecnicosgmaoAux.getIdtecnico());
				}

				// Comprobamos si ya existe esta ejecucion
				// en la
				// tabla
				// para no duplicarla
				boolean existeEjec = false;
				for (Parteejecucion parteEjec : partesEjecucionTecnico) {
					if (fechaEjecInicioDate.compareTo(parteEjec.getFeini()) == 0
							&& fechaEjecFinDate.compareTo(parteEjec.getFefin()) == 0) {
						existeEjec = true;
						break;
					}
				}
				if (!existeEjec) {
					parteEjecucionAux.setIdpartec(partetecnicosgmaoAux
							.getIdpartec());
					parteEjecucionAux.setFeini(fechaEjecInicioDate);
					parteEjecucionAux.setFefin(fechaEjecFinDate);

					parteEjecucionAux = this.parteejecucionServices
							.add(parteEjecucionAux);
				}

			}

			this.parteejecucionServices
					.recalcularTiempoParteTecnico(partetecnicosgmaoAux
							.getIdpartec());

			// Refrescamos el objeto con la información
			// actualizada
			// del parte técnico
			partetecnicosAux = this.partetecnicosService.find(partetecnicosAux);

			// Puede ser que no la haya aceptado en la
			// aplicación
			// móvil
			// y haya
			// metido ejecuciones. En ese caso la marcamos
			// como
			// aceptada
			if (partetecnicosAux != null
					&& ((partetecnicosAux.getAceptada() != null && !partetecnicosAux
							.getAceptada().equals("1")) || partetecnicosAux
							.getAceptada() == null)) {
				partetecnicosAux.setAceptada("1");
				partetecnicosAux = this.partetecnicosService
						.update(partetecnicosAux);
			}
		}

		// return comprobarCambioEstadoCorrectiva;
	}

	private void tratamientoCambioEstadosParteCorrectivo(JSONArray logs,
			Parteejecucion parteEjecucionAux, String guidpartehijaFormateado,
			SimpleDateFormat sdf, String urlConfig) {

		if (logs.length() > 0) {
			int contadorPausasAnt = 0;
			boolean terminar = false;
			List<OtLogGmao> valoresEstados = new ArrayList<OtLogGmao>();
			for (int x = 0; x < logs.length(); x++) {
				JSONObject log = logs.getJSONObject(x);

				// Si el tipo de log es 2, significa que
				// es
				// de cambio de
				// estado
				OtLogGmao otLogObj = new OtLogGmao();
				if (log.get("TipoLog") != JSONObject.NULL
						&& log.getString("TipoLog").equals("2")
						&& log.get("UUIdOt") != JSONObject.NULL
						&& log.getString("UUIdOt").equalsIgnoreCase(
								"{" + guidpartehijaFormateado + "}")) {

					String uuIdOt = "";
					if (log.get("UUIdOt") != JSONObject.NULL) {
						uuIdOt = log.getString("UUIdOt").replace("{", "");
						uuIdOt = uuIdOt.replace("}", "");
						uuIdOt = uuIdOt.toLowerCase();
						otLogObj.setuUIdOt(uuIdOt);
					}

					String estadoMovil = "";
					if (log.get("CampoIdParaFiltro") != JSONObject.NULL) {
						estadoMovil = log.getString("CampoIdParaFiltro");
						otLogObj.setCampoIdParaFiltro(estadoMovil);
						if (estadoMovil.equals("PAUSA")) {
							contadorPausasAnt++;
						} else if (estadoMovil.equals("TERM")) {
							terminar = true;
						}
					}
					String fecha = "";

					if (log.get("FechaLocal") != JSONObject.NULL) {
						fecha = log.getString("FechaLocal");
						otLogObj.setFecha(fecha);

					}

					String valorAnterior = "";
					if (log.get("ValorAnterior") != JSONObject.NULL) {
						valorAnterior = log.getString("ValorAnterior");

						otLogObj.setValorAnterior(valorAnterior);
					}
					valoresEstados.add(otLogObj);
				}
			}
			int contador = 0;
			int contadorPausas = 0;
			for (OtLogGmao estadoGmao : valoresEstados) {

				if (estadoGmao != null) {
					String uuIdOt = estadoGmao.getuUIdOt();
					Partetecnicosgmao parteTecGmaoAux = new Partetecnicosgmao();
					parteTecGmaoAux.setGuidpartetecgmao(uuIdOt);
					parteTecGmaoAux = this.partetecnicosgmaoServices
							.findByGUID(parteTecGmaoAux);

					String valorAnterior = estadoGmao.getValorAnterior();
					String estadoMovil = "";
					if (estadoGmao.getCampoIdParaFiltro() != null) {
						estadoMovil = estadoGmao.getCampoIdParaFiltro();
					}
					Date fechaEstado = null;
					if (estadoGmao.getFecha() != null) {
						try {
							fechaEstado = sdf.parse(estadoGmao.getFecha());

						} catch (ParseException e) {
							ProcesosGmaoTareasController.logger
									.error("[MOVILGMAO] : bajarOTs - formatear fecha estado: "
											+ e.getMessage());
						}
					}

					if (valorAnterior != null) {

						/**
						 * Si el estado ya es Terminado no hacemos nada
						 */
						if (parteTecGmaoAux.getEstadoGmao() == null
								|| (parteTecGmaoAux.getEstadoGmao() != null && !parteTecGmaoAux
										.getEstadoGmao()
										.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO))) {

							/**
							 * Comprobamos si la fecha del estado que viene
							 * informada es anterior a la última que hemos
							 * registrado Si es menor, ya hemos actualizado ese
							 * estado y no hacemos nada
							 */
							if (parteTecGmaoAux.getFechaEstadoGmao() == null
									|| (parteTecGmaoAux.getFechaEstadoGmao() != null && fechaEstado
											.compareTo(parteTecGmaoAux
													.getFechaEstadoGmao()) == 1)) {

								// Significa que ha cambiado
								// de estado
								if (valorAnterior.equals("ASIG")
										&& valorAnterior.equals(parteTecGmaoAux
												.getEstadoGmao())) {
									if (estadoMovil.equals("CURS")
											|| estadoMovil.equals("PAUSA")) {

										if (estadoMovil.equals("CURS")) {
											/**
											 * Comprobamos que no tenga otro
											 * parte ya en curso para pausarlo
											 * Primero comprobamos en partes
											 * correctivos
											 */
											this.comprobrarPartesCorrectivosEnCurso(
													parteTecGmaoAux, urlConfig);

											/**
											 * Comprobamos en partes preventivos
											 */
											Fichatecnicosgmao fichaTecGmaoAux = new Fichatecnicosgmao();
											fichaTecGmaoAux
													.setIdtecnico(parteTecGmaoAux
															.getIdtecnico());
											this.comprobrarPartesPreventivosEnCurso(
													fichaTecGmaoAux, urlConfig);
										}

										parteTecGmaoAux
												.setEstadoGmao(estadoMovil);
										parteTecGmaoAux
												.setFechaEstadoGmao(fechaEstado);

										parteTecGmaoAux = this.partetecnicosgmaoServices
												.update(parteTecGmaoAux);

									} else if (estadoMovil.equals("TERM")) {
										// Actualizamos el
										// estado y fecha
										parteTecGmaoAux
												.setEstadoGmao(estadoMovil);
										parteTecGmaoAux
												.setFechaEstadoGmao(fechaEstado);

										parteTecGmaoAux = this.partetecnicosgmaoServices
												.update(parteTecGmaoAux);
									}
								} else if (valorAnterior.equals("CURS")
										&& valorAnterior.equals(parteTecGmaoAux
												.getEstadoGmao())) {

									// Comprobamos si es Pausa, que sea la
									// última de
									// las
									// pausas de todo
									// el array de estados
									if ((estadoMovil.equals("PAUSA") && ((contadorPausas + 1) == contadorPausasAnt))
											|| estadoMovil.equals("TERM")) {
										// Obtenemos fecha del estado en curso
										Date fechaEnCurso = null;
										if (parteTecGmaoAux
												.getFechaEstadoGmao() != null) {
											fechaEnCurso = parteTecGmaoAux
													.getFechaEstadoGmao();
										}

										// Comprobamos si el estado nuevo es
										// Terminado,
										// para evitar que al recorrer todos los
										// estados vuelva a entrar por Pausa
										if (fechaEnCurso.compareTo(fechaEstado) == -1
												&& ((estadoMovil
														.equals("PAUSA") && !terminar) || (estadoMovil
														.equals("TERM") && terminar))) {
											// Obtenemos las ejecuciones de este
											// tecnico
											// en
											// el parte
											Parteejecucion parteEjecucionLogAux = new Parteejecucion();
											parteEjecucionLogAux
													.setIdpartec(parteTecGmaoAux
															.getIdpartec());
											List<Parteejecucion> partesEjecucionLogTecnico = this.parteejecucionServices
													.findAll(
															parteEjecucionLogAux,
															null);

											// Comprobamos si ya
											// existe esta
											// ejecucion
											// en la
											// tabla
											// para no
											// duplicarla
											boolean existeEjec = false;
											for (Parteejecucion parteEjec : partesEjecucionLogTecnico) {
												if (fechaEnCurso
														.compareTo(parteEjec
																.getFeini()) == 0
														&& fechaEstado
																.compareTo(parteEjec
																		.getFefin()) == 0) {
													existeEjec = true;
													break;
												}
											}
											if (!existeEjec) {
												parteEjecucionLogAux
														.setIdpartec(parteTecGmaoAux
																.getIdpartec());
												parteEjecucionLogAux
														.setFeini(fechaEnCurso);
												parteEjecucionLogAux
														.setFefin(fechaEstado);

												parteEjecucionLogAux = this.parteejecucionServices
														.add(parteEjecucionLogAux);

												this.parteejecucionServices
														.recalcularTiempoParteTecnico(parteTecGmaoAux
																.getIdpartec());
											}

											// Actualizamos el
											// estado y fecha
											parteTecGmaoAux
													.setEstadoGmao(estadoMovil);
											parteTecGmaoAux
													.setFechaEstadoGmao(fechaEstado);

											parteTecGmaoAux = this.partetecnicosgmaoServices
													.update(parteTecGmaoAux);
										}

									}
								} else if (valorAnterior.equals("PAUSA")) {
									contadorPausas++;
									if (valorAnterior.equals(parteTecGmaoAux
											.getEstadoGmao())) {

										if (estadoMovil.equals("CURS")
												|| estadoMovil.equals("TERM")) {

											// Obtenemos fecha del estado en
											// pausa
											Date fechaEnPausa = null;
											if (parteTecGmaoAux
													.getFechaEstadoGmao() != null) {
												fechaEnPausa = parteTecGmaoAux
														.getFechaEstadoGmao();
											}

											// Sumamos el tiempo en pausa al
											// campo
											// tiempopausa
											Integer tiempoPausa = 0;
											if (parteTecGmaoAux
													.getTiempopausaGmao() != null) {
												tiempoPausa = parteTecGmaoAux
														.getTiempopausaGmao();
											}
											Calendar calFechaIniPausa = Calendar
													.getInstance();
											Calendar calFechaFinPausa = Calendar
													.getInstance();
											calFechaIniPausa
													.setTime(fechaEnPausa);
											calFechaFinPausa
													.setTime(fechaEstado);
											Long totalMinutos = ((calFechaFinPausa
													.getTimeInMillis() - calFechaIniPausa
													.getTimeInMillis()) / 1000 / 60);

											if (totalMinutos != 0) {
												tiempoPausa = tiempoPausa
														+ totalMinutos
																.intValue();

												parteTecGmaoAux
														.setTiempopausaGmao(tiempoPausa);
												this.partetecnicosgmaoServices
														.actualizarTiempoPausaParte(parteTecGmaoAux);
											}

											if (estadoMovil.equals("CURS")) {
												/**
												 * Comprobamos que no tenga otro
												 * parte ya en curso para
												 * pausarlo Primero comprobamos
												 * en partes correctivos
												 */
												this.comprobrarPartesCorrectivosEnCurso(
														parteTecGmaoAux,
														urlConfig);

												/**
												 * Comprobamos en partes
												 * preventivos
												 */
												Fichatecnicosgmao fichaTecGmaoAux = new Fichatecnicosgmao();
												fichaTecGmaoAux
														.setIdtecnico(parteTecGmaoAux
																.getIdtecnico());
												this.comprobrarPartesPreventivosEnCurso(
														fichaTecGmaoAux,
														urlConfig);
											}

											// Actualizamos el estado a En
											// curso
											// nuevamente
											parteTecGmaoAux
													.setEstadoGmao(estadoMovil);
											parteTecGmaoAux
													.setFechaEstadoGmao(fechaEstado);

											parteTecGmaoAux = this.partetecnicosgmaoServices
													.update(parteTecGmaoAux);

										}
									}
								}
							}

						}

					} else {
						if (parteTecGmaoAux.getEstadoGmao() == null) {
							parteTecGmaoAux.setEstadoGmao(estadoMovil);
							parteTecGmaoAux.setFechaEstadoGmao(fechaEstado);

							parteTecGmaoAux = this.partetecnicosgmaoServices
									.update(parteTecGmaoAux);
						}
					}
				}
			}

		} else {

		}

	}

	private void finalizarParteCorrectivoMovilgmao(
			Partetecnicosgmao partetecnicosgmaoAux, String urlConfig) {

		Partes parte = this.partesService.finalizarParte(partetecnicosgmaoAux
				.getIdparte());

		// Finalizar parte en MovilGmao

		JSONObject ot = new JSONObject();
		ot.put("UUIdOt", "{" + partetecnicosgmaoAux.getGuidpartetecgmao() + "}");
		String respuestaOT = "";
		respuestaOT = this.procesosJMSService.bajarOtByGUID(ot, urlConfig
				+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

		JSONObject respOt = new JSONObject(respuestaOT);
		JSONArray ots = new JSONArray();
		ots = respOt.getJSONArray("ots");
		JSONObject datosJson = new JSONObject();
		if (ots.length() > 0) {
			DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			JSONObject otmod = new JSONObject();

			JSONArray operarios = new JSONArray();
			operarios = respOt.getJSONArray("operarios");
			JSONArray otmods = new JSONArray();
			otmods = respOt.getJSONArray("otmod");
			JSONArray documentos = new JSONArray();
			documentos = respOt.getJSONArray("documentos");
			JSONArray campos = new JSONArray();
			campos = respOt.getJSONArray("campos");

			/**
			 * Comprobamos si tiene ejecuciones para subirlas a movilgmao
			 */
			Parteejecucion parteEjecucionAux = new Parteejecucion();
			parteEjecucionAux.setIdpartec(partetecnicosgmaoAux.getIdpartec());
			List<Parteejecucion> partesEjecucionTecnico = this.parteejecucionServices
					.findAll(parteEjecucionAux, null);

			for (Parteejecucion parteejec : partesEjecucionTecnico) {
				if (parteejec != null && parteejec.getFeini() != null
						&& parteejec.getFefin() != null) {
					String fechaInicioModJson = df.format(parteejec.getFeini());
					String fechaFinModJson = df.format(parteejec.getFefin());
					otmod = new JSONObject();
					otmod.put("IdOperario", partetecnicosgmaoAux.getIdtecnico());
					otmod.put("IdHora", "HN");
					otmod.put("Fecha", fechaInicioModJson);
					otmod.put("QReal", 0);
					otmod.put("QVenta", 0);
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					otmod.put("UUIdOtMod", randomUUIDString);
					otmod.put("UUIdOt",
							"{" + partetecnicosgmaoAux.getGuidpartetecgmao()
									+ "}");
					otmod.put("HoraInicio", fechaInicioModJson);
					otmod.put("HoraFin", fechaFinModJson);
					otmods.put(otmod);
				}
			}

			datosJson.put("ots", ots);
			if (operarios.length() > 0) {
				datosJson.put("operarios", operarios);
			} else {
				datosJson.put("operarios", JSONObject.NULL);
			}
			if (documentos.length() > 0) {
				datosJson.put("documentos", documentos);
			} else {
				datosJson.put("documentos", JSONObject.NULL);
			}
			datosJson.put("campos", campos);
			if (otmods.length() > 0) {
				datosJson.put("otmod", otmods);
			}

			this.procesosJMSService
					.sincronizarGmao(
							datosJson,
							urlConfig
									+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SubirOTs/");

		}
	}

	private void tratamientoFirmaParteCorrectivo(JSONObject ot,
			Partetecnicosgmao partetecnicosgmaoAux) {

		String firmaConformidad = "";
		if (ot.get("FirmaConformidad") != JSONObject.NULL) {
			firmaConformidad = ot.getString("FirmaConformidad");

			Partefirma partefirmaAux = new Partefirma();
			partefirmaAux.setIdparte(partetecnicosgmaoAux.getIdparte());
			partefirmaAux.setIdtecnico(Integer.valueOf(partetecnicosgmaoAux
					.getIdtecnico().toString()));
			partefirmaAux.setIdpartec(partetecnicosgmaoAux.getIdpartec());

			Partefirma partefirmaExiste = new Partefirma();
			partefirmaExiste = this.partefirmaService.find(partefirmaAux);

			byte[] blobAsBytes = null;
			boolean insertarFirma = false;
			if (partefirmaExiste != null) {
				try {
					// Tiene firma
					int blobLeng = (int) partefirmaExiste.getFirma().length();
					if (blobLeng != 0) {
						blobAsBytes = partefirmaExiste.getFirma().getBytes(1,
								blobLeng);
					} else {
						insertarFirma = true;

					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			} else {
				insertarFirma = true;

			}

			if (insertarFirma) {
				// Si no tiene la firma, la insertamos
				firmaConformidad = firmaConformidad.substring(22);
				// data:image/png;base64,

				byte[] firmaByteArray = Base64.decodeBase64(firmaConformidad
						.getBytes());

				partefirmaAux.setFirmaArray(firmaByteArray);
				partefirmaAux = this.partefirmaService.add(partefirmaAux);
			}

		}
	}

	private void tratamientoOperariosPartePreventivo(JSONArray operarios,
			Fichatecnico fichatecnicosAux,
			Fichatecnicosgmao fichatecnicosgmaoAux, String guidpartehija,
			String tecnicoResponsable) {

		if (fichatecnicosAux != null
				&& fichatecnicosAux.getIdtecnico() != null
				&& !fichatecnicosAux.getIdtecnico().toString()
						.equalsIgnoreCase(tecnicoResponsable)) {
			// Si no coincide y tiene tecnicoResponsable desde movilgmao
			// significa que ha cambiado de operario
			if (!tecnicoResponsable.equals("")) {
				fichatecnicosAux.setIdtecnico(Long.valueOf(tecnicoResponsable));
				fichatecnicosgmaoAux.setIdtecnico(Long
						.valueOf(tecnicoResponsable));
				fichatecnicosAux = this.fichatecnicosService
						.update(fichatecnicosAux);
			} else {
				// Si tecnicoResponsable es blanco significa que se ha quedado
				// sin asignar. Eliminamos de la tabla ficha tecnicos el
				// registro
				fichatecnicosgmaoAux.setIdtecnico(null);
				fichatecnicosgmaoAux.setIdfichac(null);
				fichatecnicosgmaoAux.setEstadoGmao(null);
				this.fichatecnicosService.eliminaTecnicoFicha(fichatecnicosAux);
			}
			fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
					.update(fichatecnicosgmaoAux);

		}

		/*
		 * for (int y = 0; y < operarios.length(); y++) { JSONObject otoperario
		 * = operarios.getJSONObject(y); if (otoperario != null &&
		 * otoperario.get("UUIdOt") != JSONObject.NULL &&
		 * otoperario.getString("UUIdOt").equalsIgnoreCase( guidpartehija)) {
		 * 
		 * // Comprobamos si ha cambiado de operario // desde el planner o app
		 * String idOperarioOT = ""; if (otoperario.get("IdOperario") !=
		 * JSONObject.NULL) { idOperarioOT = otoperario.getString("IdOperario");
		 * 
		 * if (fichatecnicosAux != null && fichatecnicosAux.getIdtecnico() !=
		 * null && !fichatecnicosAux.getIdtecnico().toString()
		 * .equalsIgnoreCase(idOperarioOT)) { // Si no coincide significa que ha
		 * // cambiado de operario fichatecnicosAux.setIdtecnico(Long
		 * .valueOf(idOperarioOT));
		 * 
		 * fichatecnicosgmaoAux.setIdtecnico(Long .valueOf(idOperarioOT));
		 * 
		 * fichatecnicosAux = this.fichatecnicosService
		 * .update(fichatecnicosAux);
		 * 
		 * fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
		 * .update(fichatecnicosgmaoAux); }
		 * 
		 * } } }
		 */
	}

	private void tratamientoRevisionesPartePreventivo(JSONArray revisiones,
			Ficha fichaAux, Fichatecnicosgmao fichatecnicosgmaoAux,
			Maquinas maquinaAux, Gamas gamaAux, String fechaSinc,
			String guidpartehija, SimpleDateFormat sdf) {

		for (int x = 0; x < revisiones.length(); x++) {
			JSONObject revision = revisiones.getJSONObject(x);
			if (revision != null
					&& revision.get("UUIdOt") != JSONObject.NULL
					&& revision.getString("UUIdOt").equalsIgnoreCase(
							guidpartehija)) {
				String idCuestionario = "";
				if (revision.get("IdPunto") != JSONObject.NULL) {
					idCuestionario = revision.getString("IdPunto");

					String valorRev = "";
					if (revision.get("Valor") != JSONObject.NULL) {
						valorRev = revision.getString("Valor");
					}

					Actuacion actuacionAux = new Actuacion();
					// Se comprueba si se trata de los
					// puntos de
					// observaciones (txt)
					// en ese caso se trata directamente con
					// los
					// otros puntos x++
					// y tiene que saltar para que no falle
					// la
					// búsqueda por código
					if (!idCuestionario.equals("")
							&& idCuestionario.indexOf("txt") == -1) {
						actuacionAux.setIdcuestionario(Integer
								.valueOf(idCuestionario));

						actuacionAux.setIdficha(fichaAux.getIdficha());
						actuacionAux.setIdmaquina(fichaAux.getIdmaquina());
						List<Actuacion> listaActuacionAux = this.actuacionServices
								.findAll(actuacionAux, null);

						Date fechaSincDate = null;
						try {
							fechaSincDate = sdf.parse(fechaSinc);

						} catch (ParseException e) {
							ProcesosGmaoTareasController.logger
									.error("[MOVILGMAO] : bajarOTs - formatear fecha sinc: "
											+ e.getMessage()
											+ "; IdParte: "
											+ fichatecnicosgmaoAux.getIdficha()
											+ "; IdTecnico:"
											+ fichatecnicosgmaoAux
													.getIdtecnico());
						}

						if (!valorRev.equals("")
								&& valorRev.equals("0_CORRECTO")) {
							// Todo correcto

							if (listaActuacionAux.size() == 1) {
								actuacionAux = listaActuacionAux.get(0);

								// Comprobamos si es el
								// último
								// punto
								// de revisión o no
								// Si no lo es se obtienen
								// las
								// observaciones al punto de
								// revisión
								// anterior para guardarlas
								if (revisiones.length() > x) {
									x++;
									revision = revisiones.getJSONObject(x);
									if (revision != null
											&& revision.get("UUIdOt") != JSONObject.NULL
											&& revision.getString("UUIdOt")
													.equalsIgnoreCase(
															guidpartehija)) {
										if (revision.get("Valor") != JSONObject.NULL) {
											actuacionAux
													.setDescripcion(revision
															.getString("Valor"));
										} else {
											actuacionAux.setDescripcion("OK");
										}
									}

								}

								actuacionAux.setFeprevista(fechaSincDate);

								actuacionAux = this.actuacionServices
										.modificaActuacion(actuacionAux);
							}
						} else if (!valorRev.equals("")
								&& !valorRev.equals("0_CORRECTO")) {

							// Hay que crear un parte
							// correctivo
							// con
							// todos los datos
							Partes parteCorrectivo = new Partes();
							boolean actualizarActuacion = true;
							String idCodigo = valorRev.substring(0,
									valorRev.indexOf("_"));

							Integer idActuacion = 0;
							String observacionCorrectivo = "";
							if (listaActuacionAux.size() == 1) {
								actuacionAux = listaActuacionAux.get(0);
								if (idActuacion != null) {
									idActuacion = actuacionAux.getIdactuacion();

									// Se busca si ya tiene
									// parte
									// correctivo creado
									// anteriormente
									if (actuacionAux.getIdparte() != null) {
										// Si ya tiene parte
										// comprobamos que
										// se
										// trata
										// del mismo
										// o el técnico ha
										// cambiado
										// y quiere crear
										// otro
										// parte
										// correctivo
										Partes parteCorrectivoAux = new Partes();
										parteCorrectivoAux
												.setIdparte(actuacionAux
														.getIdparte());
										parteCorrectivoAux = this.partesService
												.findParte(parteCorrectivoAux);

										if (parteCorrectivoAux != null) {
											if (parteCorrectivoAux
													.getIdcodigo() != null
													&& parteCorrectivoAux
															.getIdcodigo()
															.toString()
															.equals(idCodigo)) {
												// Si se
												// trata
												// del
												// mismo no
												// hay
												// que
												// volver a
												// crear el
												// parte
												// correctivo
												actualizarActuacion = false;
											}
										}
									}
									parteCorrectivo.setIdactuac(idActuacion);
								}

								// Comprobamos si es el
								// último
								// punto
								// de revisión o no
								// Si no lo es se obtienen
								// las
								// observaciones al punto de
								// revisión
								// anterior para guardarlas

								if (revisiones.length() > x) {
									x++;
									revision = revisiones.getJSONObject(x);
									if (revision != null
											&& revision.get("UUIdOt") != JSONObject.NULL
											&& revision.getString("UUIdOt")
													.equalsIgnoreCase(
															guidpartehija)) {
										if (revision.get("Valor") != JSONObject.NULL) {
											observacionCorrectivo = revision
													.getString("Valor");
										}
									}

								}
							}

							parteCorrectivo.setIdedificio(maquinaAux
									.getIdedificio());
							parteCorrectivo.setIdzona(maquinaAux.getIdzona());
							parteCorrectivo.setIdplanta(maquinaAux
									.getIdplanta());
							parteCorrectivo.setIdclase(gamaAux.getIdclase());
							parteCorrectivo.setIdcodigo(Integer
									.valueOf(idCodigo));

							parteCorrectivo.setIdmaquina(fichaAux
									.getIdmaquina());

							parteCorrectivo.setObserv(observacionCorrectivo);

							if (actualizarActuacion) {
								Partes parteAux = this.partesService
										.nuevoParteCorrDesdePreventivo(parteCorrectivo);

								actuacionAux.setFeprevista(fechaSincDate);
								actuacionAux
										.setDescripcion(observacionCorrectivo);
								actuacionAux = this.actuacionServices
										.modificaActuacion(actuacionAux);

								/**
								 * Mandar a MovilGmao
								 */

								String urlConfig = "";
								String respuesta = "";
								try {
									urlConfig = this.appConfiguration
											.getObject().getProperty(
													"movilgmao.path");
								} catch (Exception e) {

								}

								/**
								 * Hay que mandar el parte igualmente a
								 * movilgmao para ser gestionado desde el
								 * planner. Creamos un registro en la tabla que
								 * guarda el idficha y guidgmao sin técnico
								 */
								Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
								tecnicoParteGmaoAux.setIdparte(parteAux
										.getIdparte());
								String randomUUIDString = "";
								UUID uuid = UUID.randomUUID();
								randomUUIDString = uuid.toString();
								tecnicoParteGmaoAux
										.setGuidpartetecgmao(randomUUIDString);

								tecnicoParteGmaoAux = this.partetecnicosgmaoServices
										.add(tecnicoParteGmaoAux);

								if (parteAux != null) {
									String idEdificio = parteAux
											.getIdedificio();

									Edificios edifAux = new Edificios();
									edifAux = this.edificiosService
											.obtenerEdificio(idEdificio);

									if (parteAux.getIddepar() != null) {
										Departamentos departamentoAux = new Departamentos();
										departamentoAux.setIddepar(parteAux
												.getIddepar());
										departamentoAux = this.departamentosService
												.find(departamentoAux);
										parteAux.setDepartamento(departamentoAux);
									}

									if (parteAux.getIddir() != null) {
										Direcciones direccionAux = new Direcciones();
										direccionAux.setIddir(parteAux
												.getIddir());
										direccionAux = this.direccionesService
												.find(direccionAux);
										parteAux.setDireccion(direccionAux);
									}

									if (parteAux.getIdplanta() != null) {
										Plantas plantaAux = new Plantas();
										plantaAux.setIdplanta(parteAux
												.getIdplanta());
										plantaAux = this.plantasService
												.find(plantaAux);
										parteAux.setPlanta(plantaAux);
									}

									if (parteAux.getIdzona() != null) {
										Zonas zonaAux = new Zonas();
										zonaAux.setIdzona(parteAux.getIdzona());
										zonaAux = this.zonasService
												.find(zonaAux);
										parteAux.setZona(zonaAux);

									}

									if (parteAux.getIdespacio() != null) {
										Espacio espacioAux = new Espacio();
										espacioAux.setIdespacio(parteAux
												.getIdespacio());
										espacioAux = this.espaciosService
												.find(espacioAux);
										parteAux.setEspacio(espacioAux);
									}

									// Obtener tecnicos asignados al parte
									// (partetecnicos)
									List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
											.findAll(tecnicoParteGmaoAux, null);

									respuesta = this.procesosJMSService
											.sincronizarParteCorrectivoGmao(
													parteAux,
													parteTecnicosGmao,
													edifAux.getGuidedificio(),
													null, null, urlConfig);

									if (respuesta != null
											&& respuesta.equals("OK")) {
										ProcesosGmaoTareasController.logger
												.info("[MOVILGMAO] : Creacion parte correctivo desde preventivo en gmao : "
														+ respuesta);
									} else {
										ProcesosGmaoTareasController.logger
												.error("[MOVILGMAO] : Creacion parte correctivo desde preventivo en gmao: "
														+ respuesta);
									}
								}
							}
						}
					}
				}
			}
		}
	}

	private void tratamientoModsPartePreventivo(JSONArray otmods,
			Fichaejecucion fichaEjecucionAux, Fichatecnico fichatecnicosAux,
			Fichatecnicosgmao fichatecnicosgmaoAux,
			List<Fichaejecucion> fichasEjecucionTecnico, String guidpartehija,
			SimpleDateFormat sdf) {
		// boolean comprobarCambioEstadoPreventiva = true;
		for (int z = 0; z < otmods.length(); z++) {
			// comprobarCambioEstadoPreventiva = false;
			JSONObject otmod = otmods.getJSONObject(z);
			if (otmod != null
					&& otmod.get("UUIdOt") != JSONObject.NULL
					&& otmod.getString("UUIdOt")
							.equalsIgnoreCase(guidpartehija)) {

				fichaEjecucionAux = new Fichaejecucion();
				/*
				 * String idHora = ""; if (otmod.get("IdHora") != null) { idHora
				 * = otmod.getString("IdHora"); }
				 */
				String fechaEjecInicio = "";
				String fechaEjecFin = "";

				if (otmod.get("HoraInicio") != JSONObject.NULL) {
					fechaEjecInicio = otmod.getString("HoraInicio");
				}
				if (otmod.get("HoraFin") != JSONObject.NULL) {
					fechaEjecFin = otmod.getString("HoraFin");
				}

				Date fechaEjecInicioDate = null;
				Date fechaEjecFinDate = null;
				try {
					fechaEjecInicioDate = sdf.parse(fechaEjecInicio);
					fechaEjecFinDate = sdf.parse(fechaEjecFin);
				} catch (ParseException e) {
					ProcesosGmaoTareasController.logger
							.error("[MOVILGMAO] : bajarOTs - formatear fecha ejec: "
									+ e.getMessage()
									+ "; IdParte: "
									+ fichatecnicosgmaoAux.getIdficha()
									+ "; IdTecnico:"
									+ fichatecnicosgmaoAux.getIdtecnico());
				}

				// Comprobamos si ya existe esta ejecucion
				// en la
				// tabla
				// para no duplicarla
				boolean existeEjec = false;
				for (Fichaejecucion fichaEjec : fichasEjecucionTecnico) {
					if (fechaEjecInicioDate.compareTo(fichaEjec.getFeini()) == 0
							&& fechaEjecFinDate.compareTo(fichaEjec.getFefin()) == 0) {
						existeEjec = true;
						break;
					}
				}
				if (!existeEjec) {
					fichaEjecucionAux.setIdfitec(fichatecnicosgmaoAux
							.getIdfichac());
					fichaEjecucionAux.setFeini(fechaEjecInicioDate);
					fichaEjecucionAux.setFefin(fechaEjecFinDate);

					fichaEjecucionAux = this.fichaejecucionServices
							.add(fichaEjecucionAux);
				}

			}

			this.fichaejecucionServices
					.recalcularTiempoFichaTecnico(fichatecnicosgmaoAux
							.getIdfichac());

			// Refrescamos el objeto con la información
			// actualizada
			// de la ficha técnico
			fichatecnicosAux = this.fichatecnicosService
					.obtenerFicha(fichatecnicosgmaoAux.getIdfichac());

			// Puede ser que no la haya aceptado en la
			// aplicación
			// móvil
			// y haya
			// metido ejecuciones. En ese caso la marcamos
			// como
			// aceptada
			if (fichatecnicosAux != null
					&& ((fichatecnicosAux.getAceptada() != null && !fichatecnicosAux
							.getAceptada().equals("1")) || fichatecnicosAux
							.getAceptada() == null)) {
				fichatecnicosAux.setAceptada("1");
				fichatecnicosAux = this.fichatecnicosService
						.update(fichatecnicosAux);
			}
		}

		// return comprobarCambioEstadoPreventiva;
	}

	private void tratamientoCambioEstadosPartePreventivo(JSONArray logs,
			Fichaejecucion fichaEjecucionAux, String guidpartehijaFormateado,
			SimpleDateFormat sdf, String urlConfig) {

		if (logs.length() > 0) {
			int contadorPausasAnt = 0;
			boolean terminar = false;
			List<OtLogGmao> valoresEstados = new ArrayList<OtLogGmao>();
			for (int x = 0; x < logs.length(); x++) {
				JSONObject log = logs.getJSONObject(x);

				// Si el tipo de log es 2, significa que
				// es
				// de cambio de
				// estado
				OtLogGmao otLogObj = new OtLogGmao();
				if (log.get("TipoLog") != JSONObject.NULL
						&& log.getString("TipoLog").equals("2")
						&& log.get("UUIdOt") != JSONObject.NULL
						&& log.getString("UUIdOt").equalsIgnoreCase(
								"{" + guidpartehijaFormateado + "}")) {

					String uuIdOt = "";
					if (log.get("UUIdOt") != JSONObject.NULL) {
						uuIdOt = log.getString("UUIdOt").replace("{", "");
						uuIdOt = uuIdOt.replace("}", "");
						uuIdOt = uuIdOt.toLowerCase();
						otLogObj.setuUIdOt(uuIdOt);
					}

					String estadoMovil = "";
					if (log.get("CampoIdParaFiltro") != JSONObject.NULL) {
						estadoMovil = log.getString("CampoIdParaFiltro");
						otLogObj.setCampoIdParaFiltro(estadoMovil);
						if (estadoMovil.equals("PAUSA")) {
							contadorPausasAnt++;
						} else if (estadoMovil.equals("TERM")) {
							terminar = true;
						}
					}
					String fecha = "";

					if (log.get("FechaLocal") != JSONObject.NULL) {
						fecha = log.getString("FechaLocal");
						otLogObj.setFecha(fecha);

					}

					String valorAnterior = "";
					if (log.get("ValorAnterior") != JSONObject.NULL) {
						valorAnterior = log.getString("ValorAnterior");

						otLogObj.setValorAnterior(valorAnterior);
					}
					valoresEstados.add(otLogObj);
				}
			}
			int contador = 0;
			int contadorPausas = 0;
			for (OtLogGmao estadoGmao : valoresEstados) {

				if (estadoGmao != null) {
					String uuIdOt = estadoGmao.getuUIdOt();
					Fichatecnicosgmao fichaTecGmaoAux = new Fichatecnicosgmao();
					fichaTecGmaoAux.setGuidfichatecgmao(uuIdOt);
					fichaTecGmaoAux = this.fichatecnicosgmaoServices
							.findByGUID(fichaTecGmaoAux);

					String valorAnterior = estadoGmao.getValorAnterior();
					String estadoMovil = "";
					if (estadoGmao.getCampoIdParaFiltro() != null) {
						estadoMovil = estadoGmao.getCampoIdParaFiltro();
					}
					Date fechaEstado = null;
					if (estadoGmao.getFecha() != null) {
						try {
							fechaEstado = sdf.parse(estadoGmao.getFecha());

						} catch (ParseException e) {
							ProcesosGmaoTareasController.logger
									.error("[MOVILGMAO] : bajarOTs - formatear fecha estado: "
											+ e.getMessage());
						}
					}

					if (valorAnterior != null) {
						// Significa que ha cambiado
						// de estado

						/**
						 * Si el estado ya es Terminado no hacemos nada
						 */
						if (fichaTecGmaoAux.getEstadoGmao() == null
								|| (fichaTecGmaoAux.getEstadoGmao() != null && !fichaTecGmaoAux
										.getEstadoGmao()
										.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO))) {

							/**
							 * Comprobamos si la fecha del estado que viene
							 * informada es anterior a la última que hemos
							 * registrado Si es menor, ya hemos actualizado ese
							 * estado y no hacemos nada
							 */
							if (fichaTecGmaoAux.getFechaEstadoGmao() == null
									|| (fichaTecGmaoAux.getFechaEstadoGmao() != null && fechaEstado
											.compareTo(fichaTecGmaoAux
													.getFechaEstadoGmao()) == 1)) {

								if (valorAnterior.equals("ASIG")
										&& valorAnterior.equals(fichaTecGmaoAux
												.getEstadoGmao())) {
									if (estadoMovil.equals("CURS")
											|| estadoMovil.equals("PAUSA")) {

										fichaTecGmaoAux
												.setEstadoGmao(estadoMovil);
										fichaTecGmaoAux
												.setFechaEstadoGmao(fechaEstado);

										if (estadoMovil.equals("CURS")) {
											// Comprobamos que no tenga otro
											// parte ya en
											// curso para pausarlo
											this.comprobrarPartesPreventivosEnCurso(
													fichaTecGmaoAux, urlConfig);

											/**
											 * Comprobamos en partes correctivos
											 */
											Partetecnicosgmao parteTecGmaoAux = new Partetecnicosgmao();
											parteTecGmaoAux
													.setIdtecnico(fichaTecGmaoAux
															.getIdtecnico());
											this.comprobrarPartesCorrectivosEnCurso(
													parteTecGmaoAux, urlConfig);
										}

										fichaTecGmaoAux = this.fichatecnicosgmaoServices
												.update(fichaTecGmaoAux);

									} else if (estadoMovil.equals("TERM")) {

										// Actualizamos el
										// estado y fecha
										fichaTecGmaoAux
												.setEstadoGmao(estadoMovil);
										fichaTecGmaoAux
												.setFechaEstadoGmao(fechaEstado);

										fichaTecGmaoAux = this.fichatecnicosgmaoServices
												.update(fichaTecGmaoAux);
									}
								} else if (valorAnterior.equals("CURS")
										&& valorAnterior.equals(fichaTecGmaoAux
												.getEstadoGmao())) {

									// Comprobamos si es Pausa, que sea la
									// última de las
									// pausas de todo
									// el array de estados
									if ((estadoMovil.equals("PAUSA") && ((contadorPausas + 1) == contadorPausasAnt))
											|| estadoMovil.equals("TERM")) {
										// Obtenemos fecha del estado en curso
										Date fechaEnCurso = null;
										if (fichaTecGmaoAux
												.getFechaEstadoGmao() != null) {
											fechaEnCurso = fichaTecGmaoAux
													.getFechaEstadoGmao();
										}

										// Comprobamos si el estado nuevo es
										// Terminado,
										// para evitar que al recorrer todos los
										// estados vuelva a entrar por Pausa
										if (fechaEnCurso.compareTo(fechaEstado) == -1
												&& ((estadoMovil
														.equals("PAUSA") && !terminar) || (estadoMovil
														.equals("TERM") && terminar))) {
											// Obtenemos las ejecuciones de este
											// tecnico
											// en
											// el parte
											Fichaejecucion fichaEjecucionLogAux = new Fichaejecucion();
											fichaEjecucionLogAux
													.setIdfitec(fichaTecGmaoAux
															.getIdfichac());
											List<Fichaejecucion> fichasEjecucionLogTecnico = this.fichaejecucionServices
													.findAll(
															fichaEjecucionLogAux,
															null);

											// Comprobamos si ya
											// existe esta
											// ejecucion
											// en la
											// tabla
											// para no
											// duplicarla
											boolean existeEjec = false;
											for (Fichaejecucion fichaEjec : fichasEjecucionLogTecnico) {
												if (fechaEnCurso
														.compareTo(fichaEjec
																.getFeini()) == 0
														&& fechaEstado
																.compareTo(fichaEjec
																		.getFefin()) == 0) {
													existeEjec = true;
													break;
												}
											}
											if (!existeEjec) {
												fichaEjecucionLogAux
														.setIdfitec(fichaTecGmaoAux
																.getIdfichac());
												fichaEjecucionLogAux
														.setFeini(fechaEnCurso);
												fichaEjecucionLogAux
														.setFefin(fechaEstado);

												fichaEjecucionLogAux = this.fichaejecucionServices
														.add(fichaEjecucionLogAux);

												this.fichaejecucionServices
														.recalcularTiempoFichaTecnico(fichaTecGmaoAux
																.getIdfichac());
											}

											// Actualizamos el
											// estado y fecha
											fichaTecGmaoAux
													.setEstadoGmao(estadoMovil);
											fichaTecGmaoAux
													.setFechaEstadoGmao(fechaEstado);

											fichaTecGmaoAux = this.fichatecnicosgmaoServices
													.update(fichaTecGmaoAux);
										}

									}
								} else if (valorAnterior.equals("PAUSA")) {
									contadorPausas++;
									if (valorAnterior.equals(fichaTecGmaoAux
											.getEstadoGmao())) {
										contador++;
										if (estadoMovil.equals("CURS")
												|| estadoMovil.equals("TERM")) {

											if (contadorPausasAnt == contador) {
												// Obtenemos fecha del estado en
												// pausa
												Date fechaEnPausa = null;
												if (fichaTecGmaoAux
														.getFechaEstadoGmao() != null) {
													fechaEnPausa = fichaTecGmaoAux
															.getFechaEstadoGmao();
												}

												// Sumamos el tiempo en pausa al
												// campo
												// tiempopausa
												Integer tiempoPausa = 0;
												if (fichaTecGmaoAux
														.getTiempoPausaGmao() != null) {
													tiempoPausa = fichaTecGmaoAux
															.getTiempoPausaGmao();
												}
												Calendar calFechaIniPausa = Calendar
														.getInstance();
												Calendar calFechaFinPausa = Calendar
														.getInstance();
												calFechaIniPausa
														.setTime(fechaEnPausa);
												calFechaFinPausa
														.setTime(fechaEstado);
												Long totalMinutos = ((calFechaFinPausa
														.getTimeInMillis() - calFechaIniPausa
														.getTimeInMillis()) / 1000 / 60);

												if (totalMinutos != 0) {
													tiempoPausa = tiempoPausa
															+ totalMinutos
																	.intValue();

													fichaTecGmaoAux
															.setTiempoPausaGmao(tiempoPausa);
													this.fichatecnicosgmaoServices
															.actualizarTiempoPausaFicha(fichaTecGmaoAux);
												}

												if (estadoMovil.equals("CURS")) {
													// Comprobamos que no tenga
													// otro
													// parte ya en
													// curso para pausarlo
													this.comprobrarPartesPreventivosEnCurso(
															fichaTecGmaoAux,
															urlConfig);

													/**
													 * Comprobamos en partes
													 * correctivos
													 */
													Partetecnicosgmao parteTecGmaoAux = new Partetecnicosgmao();
													parteTecGmaoAux
															.setIdtecnico(fichaTecGmaoAux
																	.getIdtecnico());
													this.comprobrarPartesCorrectivosEnCurso(
															parteTecGmaoAux,
															urlConfig);
												}

												// Actualizamos el estado a En
												// curso
												// nuevamente
												fichaTecGmaoAux
														.setEstadoGmao(estadoMovil);
												fichaTecGmaoAux
														.setFechaEstadoGmao(fechaEstado);

												fichaTecGmaoAux = this.fichatecnicosgmaoServices
														.update(fichaTecGmaoAux);
											}
										}
									}

								}

							}

						}

					} else {
						if (fichaTecGmaoAux.getEstadoGmao() == null) {
							fichaTecGmaoAux.setEstadoGmao(estadoMovil);
							fichaTecGmaoAux.setFechaEstadoGmao(fechaEstado);

							fichaTecGmaoAux = this.fichatecnicosgmaoServices
									.update(fichaTecGmaoAux);
						}
					}
				}
			}

		}
	}

	private void finalizarPartePreventivoMovilgmao(
			Fichatecnicosgmao fichatecnicosgmaoAux, Maquinas maquinaAux,
			String urlConfig) {

		Ficha ficha = this.fichasService.finalizarFicha(fichatecnicosgmaoAux
				.getIdficha());

		// Finalizar parte en MovilGmao

		JSONObject ot = new JSONObject();
		ot.put("UUIdOt", "{" + fichatecnicosgmaoAux.getGuidfichatecgmao() + "}");
		String respuestaOT = "";
		respuestaOT = this.procesosJMSService.bajarOtByGUID(ot, urlConfig
				+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

		JSONObject respOt = new JSONObject(respuestaOT);
		JSONArray ots = new JSONArray();
		ots = respOt.getJSONArray("ots");
		JSONObject datosJson = new JSONObject();
		if (ots.length() > 0) {
			DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			JSONObject otmod = new JSONObject();

			JSONArray operarios = new JSONArray();
			operarios = respOt.getJSONArray("operarios");
			JSONArray otmods = new JSONArray();
			otmods = respOt.getJSONArray("otmod");
			JSONArray campos = new JSONArray();
			campos = respOt.getJSONArray("campos");
			JSONArray revisiones = new JSONArray();
			revisiones = respOt.getJSONArray("revisiones");

			/**
			 * Comprobamos si tiene ejecuciones para subirlas a movilgmao
			 */
			Fichaejecucion fichaEjecucionAux = new Fichaejecucion();
			fichaEjecucionAux.setIdfitec(fichatecnicosgmaoAux.getIdfichac());
			List<Fichaejecucion> fichasEjecucionTecnico = this.fichaejecucionServices
					.findAll(fichaEjecucionAux, null);

			for (Fichaejecucion fichaejec : fichasEjecucionTecnico) {
				if (fichaejec != null && fichaejec.getFeini() != null
						&& fichaejec.getFefin() != null) {
					String fechaInicioModJson = df.format(fichaejec.getFeini());
					String fechaFinModJson = df.format(fichaejec.getFefin());
					otmod = new JSONObject();
					otmod.put("IdOperario", fichatecnicosgmaoAux.getIdtecnico());
					otmod.put("IdHora", "HN");
					otmod.put("Fecha", fechaInicioModJson);
					otmod.put("QReal", 0);
					otmod.put("QVenta", 0);
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					otmod.put("UUIdOtMod", randomUUIDString);
					otmod.put("UUIdOt",
							"{" + fichatecnicosgmaoAux.getGuidfichatecgmao()
									+ "}");
					otmod.put("HoraInicio", fechaInicioModJson);
					otmod.put("HoraFin", fechaFinModJson);
					otmods.put(otmod);
				}
			}

			datosJson.put("ots", ots);
			if (operarios.length() > 0) {
				datosJson.put("operarios", operarios);
			} else {
				datosJson.put("operarios", JSONObject.NULL);
			}
			if (revisiones.length() > 0) {
				datosJson.put("revisiones", revisiones);
			} else {
				datosJson.put("revisiones", JSONObject.NULL);
			}
			datosJson.put("campos", campos);
			if (otmods.length() > 0) {
				datosJson.put("otmod", otmods);
			}

			this.procesosJMSService
					.sincronizarGmao(
							datosJson,
							urlConfig
									+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SubirOTs/");

		}

		/*
		 * ficha = new Ficha();
		 * ficha.setIdficha(fichatecnicosgmaoAux.getIdficha()); ficha =
		 * this.fichasService.find(ficha); if (ficha != null &&
		 * ficha.getGuidficha() != null) { Edificios edificioAux = new
		 * Edificios(); maquinaAux = new Maquinas(); if (ficha.getIdmaquina() !=
		 * null) { maquinaAux.setIdmaquina(ficha.getIdmaquina()); maquinaAux =
		 * this.maquinasService.find(maquinaAux); if (maquinaAux != null &&
		 * maquinaAux.getIdedificio() != null) { edificioAux =
		 * this.edificiosService .obtenerEdificio(maquinaAux.getIdedificio()); }
		 * 
		 * if (maquinaAux.getIdzona() != null) { Zonas zonaAux = new Zonas();
		 * zonaAux.setIdzona(maquinaAux.getIdzona()); zonaAux =
		 * this.zonasService.find(zonaAux); maquinaAux.setZona(zonaAux);
		 * 
		 * }
		 * 
		 * if (maquinaAux.getIdplanta() != null) { Plantas plantaAux = new
		 * Plantas(); plantaAux.setIdplanta(maquinaAux.getIdplanta()); plantaAux
		 * = this.plantasService.find(plantaAux);
		 * maquinaAux.setPlanta(plantaAux); }
		 * 
		 * } if (edificioAux != null && edificioAux.getGuidedificio() != null) {
		 * this.procesosJMSService.sincronizarPartePreventivoGmao(ficha,
		 * maquinaAux, null, null, edificioAux.getGuidedificio(), urlConfig); }
		 * }
		 */
	}

	private void tratamientoFirmaPartePreventivo(JSONObject ot,
			Fichatecnicosgmao fichatecnicosgmaoAux) {

		String firmaConformidad = "";
		if (ot.get("FirmaConformidad") != JSONObject.NULL) {
			firmaConformidad = ot.getString("FirmaConformidad");

			Fichafirma fichafirmaAux = new Fichafirma();
			fichafirmaAux.setIdficha(fichatecnicosgmaoAux.getIdficha());
			fichafirmaAux.setIdtecnico(Integer.valueOf(fichatecnicosgmaoAux
					.getIdtecnico().toString()));
			fichafirmaAux.setIdfitec(fichatecnicosgmaoAux.getIdfichac());

			Fichafirma fichafirmaExiste = new Fichafirma();
			fichafirmaExiste = this.fichafirmaService.find(fichafirmaExiste);

			byte[] blobAsBytes = null;
			boolean insertarFirma = false;
			if (fichafirmaExiste != null) {
				try {
					// Tiene firma
					int blobLeng = (int) fichafirmaExiste.getFirma().length();
					if (blobLeng != 0) {
						blobAsBytes = fichafirmaExiste.getFirma().getBytes(1,
								blobLeng);
					} else {
						insertarFirma = true;

					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			} else {
				insertarFirma = true;

			}

			if (insertarFirma) {
				// Si no tiene la firma, la insertamos
				firmaConformidad = firmaConformidad.substring(22);
				// data:image/png;base64,

				byte[] firmaByteArray = Base64.decodeBase64(firmaConformidad
						.getBytes());

				fichafirmaAux.setFirmaArray(firmaByteArray);
				fichafirmaAux = this.fichafirmaService.add(fichafirmaAux);
			}

		}
	}

	private void tratamientoPausarPartesTecnicosLoginLogout(
			Tecnicos tecnicoAux, String estadoBusq, String pausaAuto,
			String estadoNuevo, boolean pausar, String urlConfig) {

		String respuesta = "";
		Partetecnicosgmao parteTecGmaoAux = new Partetecnicosgmao();
		parteTecGmaoAux.setIdtecnico(tecnicoAux.getIdtecnico());
		parteTecGmaoAux.setEstadoGmao(estadoBusq);
		if (pausaAuto != null && pausaAuto.equals("1")) {
			parteTecGmaoAux.setPausaAutoGmao(pausaAuto);
		}
		List<Partetecnicosgmao> listaPartesEnCurso = this.partetecnicosgmaoServices
				.findAll(parteTecGmaoAux, null);

		if (listaPartesEnCurso.size() > 0) {
			// Significa que el técnico ha hecho
			// logout y tiene algún parte en
			// curso
			for (Partetecnicosgmao parteTec : listaPartesEnCurso) {
				if (parteTec != null) {
					if (parteTec.getGuidpartetecgmao() != null) {

						// Si el parte no esta finalizado
						if (parteTec.getEstadoGmao() == null
								|| (!parteTec.getEstadoGmao().equals("TERM"))) {

							JSONObject ot = new JSONObject();
							ot.put("UUIdOt",
									"{" + parteTec.getGuidpartetecgmao() + "}");
							String respuestaOT = "";
							respuestaOT = this.procesosJMSService
									.bajarOtByGUID(
											ot,
											urlConfig
													+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

							if (respuestaOT != null
									&& !respuestaOT
											.equals(Aa20bConstantes.ERROR_500)) {

								JSONObject resp = new JSONObject(respuestaOT);

								JSONArray ots = new JSONArray();
								ots = resp.getJSONArray("ots");

								if (ots.length() > 0) {
									JSONObject otDescargada = ots
											.getJSONObject(0);

									/**
									 * Comprobamos que el estado no haya
									 * cambiado y siga siendo En curso
									 */
									String idEstadoOT = "";
									if (otDescargada.get("IdEstado") != JSONObject.NULL) {
										idEstadoOT = otDescargada
												.getString("IdEstado");

										if (idEstadoOT.equals(estadoBusq)) {
											/**
											 * Cambiamos el estado de la OT a
											 * pausa
											 */
											respuesta = this.procesosJMSService
													.subirOTcambioEstado(
															parteTec.getGuidpartetecgmao(),
															estadoNuevo,
															urlConfig);

											if (respuesta.equals("OK")) {

												/**
												 * Marcamos en la tabla que se
												 * ha pausado automaticamente
												 */
												Date fechaAct = new Date();
												if (pausar) {

													/**
													 * Al forzar el cambio de
													 * estado de En curso a
													 * Pausa, guardamos la
													 * ejecución para tener el
													 * tiempo que llevaba en
													 * curso
													 */

													Parteejecucion parteEjecucionLogAux = new Parteejecucion();
													parteEjecucionLogAux
															.setIdpartec(parteTec
																	.getIdpartec());
													parteEjecucionLogAux
															.setFeini(parteTec
																	.getFechaEstadoGmao());
													parteEjecucionLogAux
															.setFefin(fechaAct);

													parteEjecucionLogAux = this.parteejecucionServices
															.add(parteEjecucionLogAux);

													this.parteejecucionServices
															.recalcularTiempoParteTecnico(parteTec
																	.getIdpartec());

													parteTec.setPausaAutoGmao("1");
													parteTec.setEstadoGmao("PAUSA");
													parteTec.setFechaEstadoGmao(fechaAct);

												} else {
													// Sumamos el tiempo en
													// pausa al
													// campo
													// tiempopausa
													Integer tiempoPausa = 0;
													if (parteTec
															.getTiempopausaGmao() != null) {
														tiempoPausa = parteTec
																.getTiempopausaGmao();
													}
													Calendar calFechaIniPausa = Calendar
															.getInstance();
													Calendar calFechaFinPausa = Calendar
															.getInstance();
													calFechaIniPausa
															.setTime(parteTec
																	.getFechaEstadoGmao());
													calFechaFinPausa
															.setTime(fechaAct);
													Long totalMinutos = ((calFechaFinPausa
															.getTimeInMillis() - calFechaIniPausa
															.getTimeInMillis()) / 1000 / 60);

													if (totalMinutos != 0) {
														tiempoPausa = tiempoPausa
																+ totalMinutos
																		.intValue();

														parteTec.setTiempopausaGmao(tiempoPausa);
														this.partetecnicosgmaoServices
																.actualizarTiempoPausaParte(parteTec);
													}

													parteTec.setPausaAutoGmao("0");
													parteTec.setEstadoGmao("CURS");
													parteTec.setFechaEstadoGmao(fechaAct);

												}
												parteTec = this.partetecnicosgmaoServices
														.marcarPausaAutoParte(parteTec);

												/**
												 * Se sincroniza la OT nueva
												 * para confirmarla
												 */
												String fechaSinc = "";
												if (otDescargada
														.get("FechaSinc") != JSONObject.NULL) {
													fechaSinc = otDescargada
															.getString("FechaSinc");
												}

												JSONObject pdteSincOtOK = new JSONObject();
												JSONArray valoresOTbajada = new JSONArray();
												JSONObject valorBajada = new JSONObject();
												valorBajada
														.put("UUIdOt",
																parteTec.getGuidpartetecgmao());
												valorBajada.put(
														"FechaUltimaSinc",
														fechaSinc);
												valoresOTbajada
														.put(valorBajada);
												pdteSincOtOK.put("ots",
														valoresOTbajada);
												respuesta = this.procesosJMSService
														.sincronizarGmao(
																pdteSincOtOK,
																urlConfig
																		+ Aa20bConstantes.URL_MARCAR_SINC_OK);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		Fichatecnicosgmao fichaTecGmaoAux = new Fichatecnicosgmao();
		fichaTecGmaoAux.setIdtecnico(tecnicoAux.getIdtecnico());
		fichaTecGmaoAux.setEstadoGmao(estadoBusq);
		if (pausaAuto != null && pausaAuto.equals("1")) {
			fichaTecGmaoAux.setPausaAutoGmao(pausaAuto);
		}
		List<Fichatecnicosgmao> listaFichasEnCurso = this.fichatecnicosgmaoServices
				.findAll(fichaTecGmaoAux, null);

		if (listaFichasEnCurso.size() > 0) {
			// Significa que el técnico ha hecho
			// logout y tiene algún parte
			// preventivo en
			// curso
			for (Fichatecnicosgmao fichaTec : listaFichasEnCurso) {
				if (fichaTec != null) {
					if (fichaTec.getGuidfichatecgmao() != null) {

						// Si el parte no esta finalizado
						if (fichaTec.getEstadoGmao() == null
								|| (!fichaTec.getEstadoGmao().equals("TERM"))) {

							JSONObject ot = new JSONObject();
							ot.put("UUIdOt",
									"{" + fichaTec.getGuidfichatecgmao() + "}");
							String respuestaOT = "";
							respuestaOT = this.procesosJMSService
									.bajarOtByGUID(
											ot,
											urlConfig
													+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

							if (respuestaOT != null
									&& !respuestaOT
											.equals(Aa20bConstantes.ERROR_500)) {

								JSONObject resp = new JSONObject(respuestaOT);

								JSONArray ots = new JSONArray();
								ots = resp.getJSONArray("ots");

								if (ots.length() > 0) {
									JSONObject otDescargada = ots
											.getJSONObject(0);

									/**
									 * Comprobamos que el estado no haya
									 * cambiado y siga siendo En curso
									 */
									String idEstadoOT = "";
									if (otDescargada.get("IdEstado") != JSONObject.NULL) {
										idEstadoOT = otDescargada
												.getString("IdEstado");

										if (idEstadoOT.equals(estadoBusq)) {
											/**
											 * Cambiamos el estado de la OT a
											 * pausa
											 */
											respuesta = this.procesosJMSService
													.subirOTcambioEstado(
															fichaTec.getGuidfichatecgmao(),
															estadoNuevo,
															urlConfig);

											if (respuesta.equals("OK")) {
												/**
												 * Marcamos en la tabla que se
												 * ha pausado automaticamente
												 */
												if (pausar) {
													fichaTec.setPausaAutoGmao("1");
													fichaTec.setEstadoGmao("PAUSA");
													fichaTec.setFechaEstadoGmao(new Date());
												} else {

													// Sumamos el tiempo en
													// pausa al
													// campo
													// tiempopausa
													Integer tiempoPausa = 0;
													if (fichaTec
															.getTiempoPausaGmao() != null) {
														tiempoPausa = fichaTec
																.getTiempoPausaGmao();
													}
													Calendar calFechaIniPausa = Calendar
															.getInstance();
													Calendar calFechaFinPausa = Calendar
															.getInstance();
													calFechaIniPausa
															.setTime(fichaTec
																	.getFechaEstadoGmao());
													calFechaFinPausa
															.setTime(new Date());
													Long totalMinutos = ((calFechaFinPausa
															.getTimeInMillis() - calFechaIniPausa
															.getTimeInMillis()) / 1000 / 60);

													if (totalMinutos != 0) {
														tiempoPausa = tiempoPausa
																+ totalMinutos
																		.intValue();

														fichaTec.setTiempoPausaGmao(tiempoPausa);
														this.fichatecnicosgmaoServices
																.actualizarTiempoPausaFicha(fichaTec);
													}

													fichaTec.setPausaAutoGmao("0");
													fichaTec.setEstadoGmao("CURS");
													fichaTec.setFechaEstadoGmao(new Date());

												}
												fichaTec = this.fichatecnicosgmaoServices
														.marcarPausaAutoFicha(fichaTec);

												/**
												 * Se sincroniza la OT nueva
												 * para confirmarla
												 */
												String fechaSinc = "";
												if (otDescargada
														.get("FechaSinc") != JSONObject.NULL) {
													fechaSinc = otDescargada
															.getString("FechaSinc");
												}

												JSONObject pdteSincOtOK = new JSONObject();
												JSONArray valoresOTbajada = new JSONArray();
												JSONObject valorBajada = new JSONObject();
												valorBajada
														.put("UUIdOt",
																fichaTec.getGuidfichatecgmao());
												valorBajada.put(
														"FechaUltimaSinc",
														fechaSinc);
												valoresOTbajada
														.put(valorBajada);
												pdteSincOtOK.put("ots",
														valoresOTbajada);
												respuesta = this.procesosJMSService
														.sincronizarGmao(
																pdteSincOtOK,
																urlConfig
																		+ Aa20bConstantes.URL_MARCAR_SINC_OK);

											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

	}

	private void comprobrarPartesCorrectivosEnCurso(
			Partetecnicosgmao parteTecGmaoAux, String urlConfig) {

		List<Partetecnicosgmao> listaPartesTecCurso = new ArrayList<Partetecnicosgmao>();
		Partetecnicosgmao partetecgmaocursoAux = new Partetecnicosgmao();
		partetecgmaocursoAux.setIdtecnico(parteTecGmaoAux.getIdtecnico());
		partetecgmaocursoAux
				.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_CURSO);
		listaPartesTecCurso = this.partetecnicosgmaoServices.findAll(
				partetecgmaocursoAux, null);
		for (Partetecnicosgmao partetecgmaocurso : listaPartesTecCurso) {
			if (partetecgmaocurso != null
					&& partetecgmaocurso.getGuidpartetecgmao() != null
					&& !partetecgmaocurso.getGuidpartetecgmao().equals(
							parteTecGmaoAux.getGuidpartetecgmao())) {
				// Comprobamos si sigue teniendo
				// actualmente estado EN CURSO en
				// gmao
				JSONObject otcurso = new JSONObject();
				otcurso.put("UUIdOt", "{"
						+ partetecgmaocurso.getGuidpartetecgmao().toUpperCase()
						+ "}");
				String respuestaOTcurso = "";
				respuestaOTcurso = this.procesosJMSService
						.bajarOtByGUID(otcurso, urlConfig
								+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

				JSONObject respOtCurso = new JSONObject(respuestaOTcurso);
				JSONArray otsCurso = new JSONArray();
				otsCurso = respOtCurso.getJSONArray("ots");

				if (otsCurso.length() > 0) {
					JSONObject otCursoComprobar = otsCurso.getJSONObject(0);

					if (otCursoComprobar.get("IdEstado") != JSONObject.NULL
							&& otCursoComprobar.getString("IdEstado").equals(
									Aa20bConstantes.COD_ESTADO_GMAO_CURSO)) {
						String respuestaCambioEstado = this.procesosJMSService
								.subirOTcambioEstado(
										partetecgmaocurso.getGuidpartetecgmao(),
										Aa20bConstantes.COD_ESTADO_GMAO_PAUSA,
										urlConfig);

						if (respuestaCambioEstado.equals("OK")) {

							/**
							 * Al forzar el cambio de estado de En curso a
							 * Pausa, guardamos la ejecución para tener el
							 * tiempo que llevaba en curso
							 */
							Date fechaAct = new Date();
							Parteejecucion parteEjecucionLogAux = new Parteejecucion();

							parteEjecucionLogAux.setIdpartec(partetecgmaocurso
									.getIdpartec());
							parteEjecucionLogAux.setFeini(partetecgmaocurso
									.getFechaEstadoGmao());
							parteEjecucionLogAux.setFefin(fechaAct);

							parteEjecucionLogAux = this.parteejecucionServices
									.add(parteEjecucionLogAux);

							this.parteejecucionServices
									.recalcularTiempoParteTecnico(partetecgmaocurso
											.getIdpartec());

							partetecgmaocurso
									.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_PAUSA);
							partetecgmaocurso.setFechaEstadoGmao(new Date());
							partetecgmaocurso = this.partetecnicosgmaoServices
									.update(partetecgmaocurso);

							/**
							 * Se sincroniza la OT nueva para confirmarla
							 */
							String fechaSinc = "";
							if (otCursoComprobar.get("FechaSinc") != JSONObject.NULL) {
								fechaSinc = otCursoComprobar
										.getString("FechaSinc");
							}

							JSONObject pdteSincOtOK = new JSONObject();
							JSONArray valoresOTbajada = new JSONArray();
							JSONObject valorBajada = new JSONObject();
							valorBajada.put("UUIdOt",
									partetecgmaocurso.getGuidpartetecgmao());
							valorBajada.put("FechaUltimaSinc", fechaSinc);
							valoresOTbajada.put(valorBajada);
							pdteSincOtOK.put("ots", valoresOTbajada);
							respuestaCambioEstado = this.procesosJMSService
									.sincronizarGmao(
											pdteSincOtOK,
											urlConfig
													+ Aa20bConstantes.URL_MARCAR_SINC_OK);
						}
					}
				}
			}
		}

	}

	private void comprobrarPartesPreventivosEnCurso(
			Fichatecnicosgmao fichaTecGmaoAux, String urlConfig) {

		List<Fichatecnicosgmao> listaFichasTecCurso = new ArrayList<Fichatecnicosgmao>();
		Fichatecnicosgmao fichatecgmaocursoAux = new Fichatecnicosgmao();
		fichatecgmaocursoAux.setIdtecnico(fichaTecGmaoAux.getIdtecnico());
		fichatecgmaocursoAux
				.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_CURSO);
		listaFichasTecCurso = this.fichatecnicosgmaoServices.findAll(
				fichatecgmaocursoAux, null);
		for (Fichatecnicosgmao fichatecgmaocurso : listaFichasTecCurso) {
			if (fichatecgmaocurso != null
					&& fichatecgmaocurso.getGuidfichatecgmao() != null
					&& !fichatecgmaocurso.getGuidfichatecgmao().equals(
							fichaTecGmaoAux.getGuidfichatecgmao())) {
				// Comprobamos si sigue teniendo
				// actualmente estado EN CURSO en
				// gmao
				JSONObject otcurso = new JSONObject();
				otcurso.put("UUIdOt", "{"
						+ fichatecgmaocurso.getGuidfichatecgmao().toUpperCase()
						+ "}");
				String respuestaOTcurso = "";
				respuestaOTcurso = this.procesosJMSService
						.bajarOtByGUID(otcurso, urlConfig
								+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

				JSONObject respOtCurso = new JSONObject(respuestaOTcurso);
				JSONArray otsCurso = new JSONArray();
				otsCurso = respOtCurso.getJSONArray("ots");

				if (otsCurso.length() > 0) {
					JSONObject otCursoComprobar = otsCurso.getJSONObject(0);

					if (otCursoComprobar.get("IdEstado") != JSONObject.NULL
							&& otCursoComprobar.getString("IdEstado").equals(
									Aa20bConstantes.COD_ESTADO_GMAO_CURSO)) {
						String respuestaCambioEstado = this.procesosJMSService
								.subirOTcambioEstado(
										fichatecgmaocurso.getGuidfichatecgmao(),
										Aa20bConstantes.COD_ESTADO_GMAO_PAUSA,
										urlConfig);

						if (respuestaCambioEstado.equals("OK")) {

							/**
							 * Al forzar el cambio de estado de En curso a
							 * Pausa, guardamos la ejecución para tener el
							 * tiempo que llevaba en curso
							 */
							Date fechaAct = new Date();
							Fichaejecucion fichaEjecucionLogAux = new Fichaejecucion();

							fichaEjecucionLogAux.setIdfitec(fichatecgmaocurso
									.getIdfichac());
							fichaEjecucionLogAux.setFeini(fichatecgmaocurso
									.getFechaEstadoGmao());
							fichaEjecucionLogAux.setFefin(fechaAct);

							fichaEjecucionLogAux = this.fichaejecucionServices
									.add(fichaEjecucionLogAux);

							this.fichaejecucionServices
									.recalcularTiempoFichaTecnico(fichatecgmaocurso
											.getIdfichac());

							fichatecgmaocurso
									.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_PAUSA);
							fichatecgmaocurso.setFechaEstadoGmao(new Date());
							fichatecgmaocurso = this.fichatecnicosgmaoServices
									.update(fichatecgmaocurso);

							/**
							 * Se sincroniza la OT nueva para confirmarla
							 */
							String fechaSinc = "";
							if (otCursoComprobar.get("FechaSinc") != JSONObject.NULL) {
								fechaSinc = otCursoComprobar
										.getString("FechaSinc");
							}

							JSONObject pdteSincOtOK = new JSONObject();
							JSONArray valoresOTbajada = new JSONArray();
							JSONObject valorBajada = new JSONObject();
							valorBajada.put("UUIdOt",
									fichatecgmaocurso.getGuidfichatecgmao());
							valorBajada.put("FechaUltimaSinc", fechaSinc);
							valoresOTbajada.put(valorBajada);
							pdteSincOtOK.put("ots", valoresOTbajada);
							respuestaCambioEstado = this.procesosJMSService
									.sincronizarGmao(
											pdteSincOtOK,
											urlConfig
													+ Aa20bConstantes.URL_MARCAR_SINC_OK);
						}
					}
				}
			}
		}
	}

	private boolean tratamientoParteAyudaSeguimientoCorrectivoDesdeMovilGmao(
			String guidpartehijaFormateado, String urlConfig, JSONObject ot) {
		boolean fichaNuevaBienCreada = true;

		/**
		 * Si se trata de ayuda o traspaso de parte
		 */
		if (ot.get("UUIdOtSeguida") != JSONObject.NULL
				|| (ot.get("UUIdOtPadre") != JSONObject.NULL)) {
			boolean otnuevacorrecta = true;
			String fichaPadreGuid = "";
			String fichaSeguidoGuid = "";
			String otTraspaso = "";
			String otAyuda = "";
			Integer fichaBusqueda = 0;
			String idTecnicoParteNuevo = "";
			if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
				idTecnicoParteNuevo = ot.getString("IdOperarioResponsable");
			}

			if (ot.get("UUIdOtSeguida") != JSONObject.NULL) {
				otTraspaso = ot.getString("UUIdOtSeguida").replace("{", "");
				otTraspaso = otTraspaso.replace("}", "");
				Fichatecnicosgmao fichatecpadregmaoAux = new Fichatecnicosgmao();
				fichatecpadregmaoAux.setGuidfichatecgmao(otTraspaso
						.toLowerCase());
				fichatecpadregmaoAux = this.fichatecnicosgmaoServices
						.findByGUID(fichatecpadregmaoAux);

				if (fichatecpadregmaoAux != null) {
					/**
					 * El parte existe en nuestro sistema. Debemos crear un
					 * parte nuevo en movil gmao asignandoselo al nuevo técnico
					 * para después finalizar el parte anterior que se quiere
					 * traspasar. En nuestra aplicación se asignará al mismo
					 * parte.
					 */
					fichaSeguidoGuid = fichatecpadregmaoAux
							.getGuidfichatecgmao();
					fichaBusqueda = fichatecpadregmaoAux.getIdficha();
					String tecnicoNuevo = "";
					if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
						tecnicoNuevo = ot.getString("IdOperarioResponsable");
						// Si ha elegido un técnico diferente a el
						if (!tecnicoNuevo.equals(fichatecpadregmaoAux
								.getIdtecnico())) {

							/**
							 * Se comprueba el estado actual del parte para
							 * marcarlo como finalizado en movilgmao
							 */
							if (fichatecpadregmaoAux.getEstadoGmao() != null
									&& fichatecpadregmaoAux
											.getFechaEstadoGmao() != null) {
								if (!fichatecpadregmaoAux
										.getEstadoGmao()
										.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO)) {

									String respuestaCambioEstado = this.procesosJMSService
											.subirOTcambioEstado(
													fichatecpadregmaoAux
															.getGuidfichatecgmao(),
													Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO,
													urlConfig);

									/**
									 * Quitamos el tecnico de la OT (como hace
									 * movilgmao al finalizar)
									 */
									if (respuestaCambioEstado.equals("OK")) {
										this.procesosJMSService
												.subirOTcambioTecnico(
														fichatecpadregmaoAux
																.getGuidfichatecgmao(),
														null, urlConfig);
									}
								}
							}
						} else {
							// Si se ha elegido a el como técnico no asignamos
							// el
							// parte
							otnuevacorrecta = false;
						}
					}
				}

			} else if (ot.get("UUIdOtPadre") != JSONObject.NULL) {
				/**
				 * Si viene con el campo de ot hija significa que quiere ayuda
				 * para el parte. Se deberá crear un parte nuevo hijo y
				 * asignarselo al técnico nuevo, manteniendo el parte anterior
				 * igual
				 */
				otAyuda = ot.getString("UUIdOtPadre").replace("{", "");
				otAyuda = otAyuda.replace("}", "");
				Fichatecnicosgmao fichatecpadregmaoAux = new Fichatecnicosgmao();
				fichatecpadregmaoAux.setGuidfichatecgmao(otAyuda.toLowerCase());
				fichatecpadregmaoAux = this.fichatecnicosgmaoServices
						.findByGUID(fichatecpadregmaoAux);
				if (fichatecpadregmaoAux != null) {
					fichaPadreGuid = fichatecpadregmaoAux.getGuidfichatecgmao();
					String tecnicoNuevo = "";
					if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
						tecnicoNuevo = ot.getString("IdOperarioResponsable");
						// Si se ha elegido a el como técnico no creamos el
						// parte
						if (tecnicoNuevo.equals(fichatecpadregmaoAux
								.getIdtecnico())) {
							otnuevacorrecta = false;
						}
					}

				}
			}

			String guidedificioFormateado = ot.getString("UUIdactivo").replace(
					"{", "");
			guidedificioFormateado = guidedificioFormateado.replace("}", "");

			Ficha fichaBusAux = new Ficha();
			fichaBusAux.setIdficha(fichaBusqueda);
			Ficha fichaAux = this.fichasService.find(fichaBusAux);

			if (fichaAux != null && otnuevacorrecta) {
				/**
				 * Si en el parte nuevo no viene información del técnico
				 * asociado significa que quiere cambiar de técnico
				 */
				Fichatecnicosgmao elTecnicoFichaGmao = new Fichatecnicosgmao();
				Fichatecnicosgmao fichaNuevaTecnicoGmaoAux = new Fichatecnicosgmao();
				if (idTecnicoParteNuevo != null
						&& !idTecnicoParteNuevo.equals("")) {
					Fichatecnico fichaTecnico = new Fichatecnico();
					fichaTecnico.setIdficha(fichaAux.getIdficha());
					fichaTecnico
							.setIdtecnico(Long.valueOf(idTecnicoParteNuevo));
					fichaTecnico.setFinalizado("0");
					fichaTecnico.setAceptada("1");

					Fichatecnico fichaTecnicoAux = this.fichatecnicosService
							.add(fichaTecnico);

					elTecnicoFichaGmao.setIdficha(fichaAux.getIdficha());
					elTecnicoFichaGmao.setIdtecnico(Long
							.valueOf(idTecnicoParteNuevo));
					elTecnicoFichaGmao
							.setIdfichac(fichaTecnicoAux.getIdfitec());
					elTecnicoFichaGmao
							.setGuidfichatecgmao(guidpartehijaFormateado);

					if (!fichaPadreGuid.equals("")) {
						elTecnicoFichaGmao
								.setGuidpartepadreayuda(fichaPadreGuid);
					}
					if (!fichaSeguidoGuid.equals("")) {
						elTecnicoFichaGmao
								.setGuidparteseguido(fichaSeguidoGuid);
					}

					fichaNuevaTecnicoGmaoAux = this.fichatecnicosgmaoServices
							.add(elTecnicoFichaGmao);

				} else {

					/**
					 * No tiene técnico, habrá que buscar uno si es automático
					 * Se crea el registro en la tabla de partes gmao sin
					 * incluir ni el técnico ni el código del parte técnico
					 */

					elTecnicoFichaGmao.setIdficha(fichaAux.getIdficha());
					elTecnicoFichaGmao.setIdtecnico(null);
					elTecnicoFichaGmao.setIdfichac(null);
					elTecnicoFichaGmao
							.setGuidfichatecgmao(guidpartehijaFormateado);

					fichaNuevaTecnicoGmaoAux = this.fichatecnicosgmaoServices
							.add(elTecnicoFichaGmao);
				}

				Tecnicos tecnicoAux = new Tecnicos();
				if (idTecnicoParteNuevo != null
						&& !idTecnicoParteNuevo.equals("")) {
					tecnicoAux.setIdtecnico(Long.valueOf(idTecnicoParteNuevo));
					tecnicoAux = this.tecnicosService.find(tecnicoAux);
				}

				// Obtener tecnicos asignados al parte
				// (partetecnicos)
				fichaNuevaTecnicoGmaoAux = new Fichatecnicosgmao();
				fichaNuevaTecnicoGmaoAux.setIdficha(fichaAux.getIdficha());
				List<Fichatecnicosgmao> fichaNuevaTecnicosGmao = this.fichatecnicosgmaoServices
						.findAll(fichaNuevaTecnicoGmaoAux, null);

				if (fichaAux != null) {

					String idEdificio = null;
					Maquinas maquinaAux = new Maquinas();
					if (fichaAux.getIdmaquina() != null) {

						maquinaAux.setIdmaquina(fichaAux.getIdmaquina());
						maquinaAux = this.maquinasService.find(maquinaAux);

						if (maquinaAux != null
								&& maquinaAux.getIdedificio() != null) {
							idEdificio = maquinaAux.getIdedificio();
						}

						if (maquinaAux.getIdzona() != null) {
							Zonas zonaAux = new Zonas();
							zonaAux.setIdzona(maquinaAux.getIdzona());
							zonaAux = this.zonasService.find(zonaAux);
							maquinaAux.setZona(zonaAux);

						}

						if (maquinaAux.getIdplanta() != null) {
							Plantas plantaAux = new Plantas();
							plantaAux.setIdplanta(maquinaAux.getIdplanta());
							plantaAux = this.plantasService.find(plantaAux);
							maquinaAux.setPlanta(plantaAux);
						}
					}

					Edificios edifAux = new Edificios();
					if (idEdificio != null) {
						edifAux = this.edificiosService
								.obtenerEdificio(idEdificio);
					}

					// Obtener tecnicos asignados al parte preventivo
					// (fichatecnicos)
					Fichatecnicosgmao tecnicoFichaGmaoAux = new Fichatecnicosgmao();
					tecnicoFichaGmaoAux.setIdficha(fichaAux.getIdficha());
					List<Fichatecnicosgmao> fichaTecnicosGmao = this.fichatecnicosgmaoServices
							.findAll(tecnicoFichaGmaoAux, null);

					// Obtener actuaciones asociadas al parte preventivo
					Actuacion actuacionAux = new Actuacion();
					actuacionAux.setIdficha(fichaAux.getIdficha());
					List<Actuacion> listaActuaciones = this.actuacionService
							.obtenerActuaciones(actuacionAux, null);

					/**
					 * Se sincronizará con Gmao para crear el parte actualizar
					 * los datos del parte creado con el móvil, añadiendo el
					 * numero de OT con el formato correcto
					 */
					String respuesta = this.procesosJMSService
							.sincronizarPartePreventivoGmao(fichaAux,
									maquinaAux, fichaTecnicosGmao,
									listaActuaciones,
									edifAux.getGuidedificio(), urlConfig);

					if (respuesta != null && respuesta.equals("OK")) {
						ProcesosGmaoTareasController.logger
								.info("[MOVILGMAO] : sincronizarPartePreventivo: "
										+ respuesta);
					} else {
						ProcesosGmaoTareasController.logger
								.error("[MOVILGMAO] : sincronizarPartePreventivo: "
										+ respuesta);
					}

					/**
					 * Se sincroniza la OT nueva para confirmarla
					 */
					String fechaSinc = "";
					if (ot.get("FechaSinc") != JSONObject.NULL) {
						fechaSinc = ot.getString("FechaSinc");
					}
					JSONObject pdteSincOtOK = new JSONObject();
					JSONArray valoresOTbajada = new JSONArray();
					JSONObject valorBajada = new JSONObject();
					valorBajada.put("UUIdOt", guidpartehijaFormateado);
					valorBajada.put("FechaUltimaSinc", fechaSinc);
					valoresOTbajada.put(valorBajada);
					pdteSincOtOK.put("ots", valoresOTbajada);
					respuesta = this.procesosJMSService.sincronizarGmao(
							pdteSincOtOK, urlConfig
									+ Aa20bConstantes.URL_MARCAR_SINC_OK);

					/**
					 * Después de confirmarla se sube la información con la
					 * asignación del operario a MovilGmao
					 */
					respuesta = this.procesosJMSService
							.sincronizarPartePreventivoGmao(fichaAux,
									maquinaAux, fichaTecnicosGmao,
									listaActuaciones,
									edifAux.getGuidedificio(), urlConfig);

					if (respuesta.equals("OK")) {
						fichaNuevaBienCreada = true;
					} else {
						fichaNuevaBienCreada = false;
					}
				}
			}

		}

		return fichaNuevaBienCreada;
	}

	private String bajarOTcorrectivaGmao(String idParte) {
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		Partetecnicosgmao parteTecnicoGmaoAux = new Partetecnicosgmao();
		parteTecnicoGmaoAux.setIdparte(Integer.valueOf(idParte));
		List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
				.findAll(parteTecnicoGmaoAux, null);

		for (Partetecnicosgmao parteTecnico : parteTecnicosGmao) {
			JSONObject ot = new JSONObject();
			ot.put("UUIdOt", "{" + parteTecnico.getGuidpartetecgmao() + "}");
			String respuestaOT = "";
			respuestaOT = this.procesosJMSService.bajarOtByGUID(ot, urlConfig
					+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

			if (respuestaOT != null
					&& !respuestaOT.equals(Aa20bConstantes.ERROR_500)) {
				respuesta = actualizarPartes(respuestaOT, urlConfig,
						Aa20bConstantes.TIPO_OT_GMAO_CORRECTIVA);
			} else {
				ProcesosGmaoTareasController.logger
						.error("[MOVILGMAO] : bajarOTByUUId - error en la conexión con MovilGmao");
			}

		}

		return respuesta;
	}

	private String bajarOTpreventivaGmao(String idFicha) {
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		Fichatecnicosgmao fichaTecnicoGmaoAux = new Fichatecnicosgmao();
		fichaTecnicoGmaoAux.setIdficha(Integer.valueOf(idFicha));
		List<Fichatecnicosgmao> fichaTecnicosGmao = this.fichatecnicosgmaoServices
				.findAll(fichaTecnicoGmaoAux, null);

		for (Fichatecnicosgmao fichaTecnico : fichaTecnicosGmao) {
			JSONObject ot = new JSONObject();
			ot.put("UUIdOt", "{" + fichaTecnico.getGuidfichatecgmao() + "}");
			String respuestaOT = "";
			respuestaOT = this.procesosJMSService.bajarOtByGUID(ot, urlConfig
					+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

			if (respuestaOT != null
					&& !respuestaOT.equals(Aa20bConstantes.ERROR_500)) {
				respuesta = actualizarPartes(respuestaOT, urlConfig,
						Aa20bConstantes.TIPO_OT_GMAO_PREVENTIVA);
			} else {
				ProcesosGmaoTareasController.logger
						.error("[MOVILGMAO] : bajarOTByUUId - error en la conexión con MovilGmao");
			}

		}

		return respuesta;
	}

}
