package com.ejie.aa20b.control;

import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.ActuacionService;
import com.ejie.aa20b.service.ClaseService;
import com.ejie.aa20b.service.CodigoService;
import com.ejie.aa20b.service.DepartamentosService;
import com.ejie.aa20b.service.DireccionesService;
import com.ejie.aa20b.service.EspacioService;
import com.ejie.aa20b.service.FichaService;
import com.ejie.aa20b.service.FichaejecucionService;
import com.ejie.aa20b.service.FichafirmaService;
import com.ejie.aa20b.service.FichatecnicoService;
import com.ejie.aa20b.service.FichatecnicosgmaoService;
import com.ejie.aa20b.service.GamasService;
import com.ejie.aa20b.service.MaquinasService;
import com.ejie.aa20b.service.ParteejecucionService;
import com.ejie.aa20b.service.PartefirmaService;
import com.ejie.aa20b.service.PartepdfService;
import com.ejie.aa20b.service.ParteplanoService;
import com.ejie.aa20b.service.PartesService;
import com.ejie.aa20b.service.PartetecnicosService;
import com.ejie.aa20b.service.PartetecnicosgmaoService;
import com.ejie.aa20b.service.PlantasService;
import com.ejie.aa20b.service.PresenciaService;
import com.ejie.aa20b.service.ServiciosService;
import com.ejie.aa20b.service.TecnicoEdifService;
import com.ejie.aa20b.service.TecnicosService;
import com.ejie.aa20b.service.UsutecnicosService;
import com.ejie.aa20b.service.ZonasService;

import com.ejie.aa20b.service.EdificiosService;

import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.json.JSONArray;
import com.ejie.x38.json.JSONObject;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.UUID;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa20b.classes.OtLogGmao;
import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Departamentos;
import com.ejie.aa20b.model.Direcciones;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Espacio;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Fichaejecucion;
import com.ejie.aa20b.model.Fichafirma;
import com.ejie.aa20b.model.Fichatecnico;
import com.ejie.aa20b.model.Fichatecnicosgmao;
import com.ejie.aa20b.model.Gamas;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.Parteejecucion;
import com.ejie.aa20b.model.Partefirma;
import com.ejie.aa20b.model.Partepdf;
import com.ejie.aa20b.model.Parteplano;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.Partetecnicos;
import com.ejie.aa20b.model.Partetecnicosgmao;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.Presencia;
import com.ejie.aa20b.model.Servicios;
import com.ejie.aa20b.model.TecnicoEdif;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Usutecnicos;
import com.ejie.aa20b.model.Zonas;

/**
 * ProcesosGmaoController
 * 
 * @author VDIAZSAN
 */

@Controller
@RequestMapping(value = "/procesosGmao")
public class ProcesosGmaoController {

	private static final Logger logger = LoggerFactory
			.getLogger(ProcesosGmaoController.class);

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private EdificiosService edificiosService;

	@Autowired
	private EspacioService espaciosService;

	@Autowired
	private TecnicosService tecnicosService;

	@Autowired
	private TecnicoEdifService tecnicosEdificioService;

	@Autowired
	private ClaseService clasesService;

	@Autowired
	private CodigoService codigosService;

	@Autowired
	private GamasService gamasService;

	@Autowired
	private MaquinasService maquinasService;

	@Autowired
	private ServiciosService serviciosService;

	@Autowired
	private Aa20bProcesosJMSService procesosJMSService;

	@Autowired
	private PartetecnicosgmaoService partetecnicosgmaoServices;

	@Autowired
	private FichatecnicosgmaoService fichatecnicosgmaoServices;

	@Autowired
	private PartetecnicosService partetecnicosService;

	@Autowired
	private FichatecnicoService fichatecnicosService;

	@Autowired
	private PartesService partesService;

	@Autowired
	private FichaService fichasService;

	@Autowired
	private PartefirmaService partefirmaService;

	@Autowired
	private FichafirmaService fichafirmaService;

	@Autowired
	private ParteejecucionService parteejecucionServices;

	@Autowired
	private FichaejecucionService fichaejecucionServices;

	@Autowired
	private ParteplanoService parteplanoService;

	@Autowired
	private ActuacionService actuacionServices;

	@Autowired
	private UsutecnicosService usuTecnicosService;

	@Autowired
	private PresenciaService presenciaService;

	@Autowired
	private DepartamentosService departamentosService;

	@Autowired
	private DireccionesService direccionesService;

	@Autowired
	private PlantasService plantasService;

	@Autowired
	private ZonasService zonasService;

	@Autowired
	private ActuacionService actuacionService;

	@Autowired
	private PartepdfService partepdfService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintProcesosIniciales", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ProcesosGmaoController.logger
				.info("[GET - View] : procesosGmao - Procesos iniciales");
		return "procesosGmaoInit";
	}

	@RequestMapping(value = "/subirTodosEdificiosGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subidTodosEdificiosGmao() {
		ProcesosGmaoController.logger.info("[Gmao - subirTodosEdificios] ");
		String respuesta = "";
		Edificios edifFilter = new Edificios();
		edifFilter.setBaja("0");
		List<Edificios> edificios = this.edificiosService.findAll(edifFilter,
				null);

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		if (edificios.size() != 0) {
			JSONArray listaClientes = new JSONArray();
			JSONArray listaActivoCliente = new JSONArray();
			JSONArray listaActivoCampo = new JSONArray();
			java.util.Date fechaActual = new Date();
			DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			String fechaActualJson = df.format(fechaActual);

			// JSONObject entidades = new JSONObject();

			/**
			 * Gmao Generación estructura entidades Zona y edificio
			 */
			// respuesta = this.procesosJMSService.generarEntidadesEdifEstruc();

			// ProcesosGmaoController.logger
			// .info("[Gmao - generarEntidadesEdifEstruc()] " + respuesta);

			for (Edificios edificio : edificios) {

				if (edificio.getGuidedificio() == null
						|| (edificio.getGuidedificio() != null && edificio
								.getGuidedificio().trim().equals(""))) {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					edificio.setGuidedificio(randomUUIDString);
					this.edificiosService.actualizarUUIDedificio(edificio);
				}
				JSONObject cliente = new JSONObject();
				cliente.put("IdCliente", edificio.getIdedificio());
				cliente.put("DescCliente", edificio.getEedificio() + " / "
						+ edificio.getCedificio());

				listaClientes.put(cliente);

				JSONObject activoCliente = new JSONObject();
				activoCliente.put("DescActivo", edificio.getEedificio() + " / "
						+ edificio.getCedificio());
				activoCliente.put("NSerie", JSONObject.NULL);
				activoCliente.put("IdCliente", edificio.getIdedificio());
				activoCliente.put("IdClaseActivo", "AA20BEDIF");
				int idZona = 0;
				if (edificio.getIdterri() != null && edificio.getIdterri() != 0) {
					idZona = edificio.getIdterri();
				}
				activoCliente.put("IdZona", idZona);
				activoCliente.put("QR", JSONObject.NULL);
				activoCliente.put("Direccion", JSONObject.NULL);
				activoCliente.put("CodigoPostal", JSONObject.NULL);
				activoCliente.put("Poblacion", JSONObject.NULL);
				activoCliente.put("Provincia", JSONObject.NULL);
				activoCliente.put("PosicionGPS", JSONObject.NULL);
				activoCliente.put("CodEnlace", JSONObject.NULL);
				activoCliente.put("IdActivo", "ACT" + edificio.getIdedificio());
				activoCliente.put("IdEstado", JSONObject.NULL);
				activoCliente.put("Pais", JSONObject.NULL);
				if (idZona != 0) {
					activoCliente.put("IdAgrupacionActivo", "act" + idZona);
				} else {
					activoCliente.put("IdAgrupacionActivo", JSONObject.NULL);
				}
				activoCliente.put("FechaFinGarantia", JSONObject.NULL);
				activoCliente.put("fechaSincronizacion", fechaActualJson);
				activoCliente.put("fechaActual", fechaActualJson);
				activoCliente.put("FechaUltimaSinc", fechaActualJson);
				activoCliente.put("FechaBaja", JSONObject.NULL);

				activoCliente.put("UUIdActivo", edificio.getGuidedificio());
				listaActivoCliente.put(activoCliente);

				JSONObject activoCampoC = new JSONObject();
				activoCampoC.put("UUIDActivo", edificio.getGuidedificio());
				activoCampoC.put("Valor", edificio.getCedificio());
				activoCampoC.put("IdCampo", "CEDIFICIO");
				JSONObject activoCampoE = new JSONObject();
				activoCampoE.put("UUIDActivo", edificio.getGuidedificio());
				activoCampoE.put("Valor", edificio.getEedificio());
				activoCampoE.put("IdCampo", "EEDIFICIO");
				listaActivoCampo.put(activoCampoC);
				listaActivoCampo.put(activoCampoE);

				/**
				 * Zonas asignadas al edificio
				 */
				/*
				 * EdifEstruc edifEstrucAux = new EdifEstruc();
				 * edifEstrucAux.setIdedificio(edificio.getIdedificio());
				 * List<EdifEstruc> listaZonasPlantasEdif =
				 * this.edifEstrucService .findAll(edifEstrucAux, null);
				 * 
				 * // Recorremos la tabla 28 para ir sincronizando zonas y
				 * plantas // por zona asignadas JSONArray listaEntidadesLineas
				 * = new JSONArray(); JSONArray listaEntidadesValores = new
				 * JSONArray(); String uuidEdif = "{" +
				 * edificio.getGuidedificio() + "}";
				 * 
				 * for (EdifEstruc edifEstruc : listaZonasPlantasEdif) {
				 * 
				 * JSONObject entidadLinea = new JSONObject(); JSONObject
				 * entidadValor = new JSONObject(); // Zonas Zonas zonaAux = new
				 * Zonas(); zonaAux.setIdzona(edifEstruc.getIdzona()); Zonas
				 * zona = this.zonasService.obtenerZona(zonaAux);
				 * 
				 * if (zona != null) {
				 * 
				 * entidadLinea.put("IdEntidad", "Zonas");
				 * entidadLinea.put("Codigo", uuidEdif + "_" +
				 * zona.getIdzona()); listaEntidadesLineas.put(entidadLinea);
				 * 
				 * entidadValor.put("IdEntidad", "Zonas");
				 * entidadValor.put("IdColumna", "IdZona");
				 * entidadValor.put("Codigo", uuidEdif + "_" +
				 * zona.getIdzona()); entidadValor.put("Valor",
				 * zona.getIdzona()); listaEntidadesValores.put(entidadValor);
				 * entidadValor = new JSONObject();
				 * entidadValor.put("IdEntidad", "Zonas");
				 * entidadValor.put("IdColumna", "DescZona");
				 * entidadValor.put("Codigo", uuidEdif + "_" +
				 * zona.getIdzona()); entidadValor.put("Valor", zona.getCzona()
				 * + " / " + zona.getEzona());
				 * listaEntidadesValores.put(entidadValor); entidadValor = new
				 * JSONObject(); entidadValor.put("IdEntidad", "Zonas");
				 * entidadValor.put("IdColumna", "IdEdificio");
				 * entidadValor.put("Codigo", uuidEdif + "_" +
				 * zona.getIdzona()); entidadValor.put("Valor", uuidEdif);
				 * listaEntidadesValores.put(entidadValor); entidadValor = new
				 * JSONObject(); entidadValor.put("IdEntidad", "Zonas");
				 * entidadValor.put("IdColumna", "Clave");
				 * entidadValor.put("Codigo", uuidEdif + "_" +
				 * zona.getIdzona()); entidadValor.put("Valor", uuidEdif + "_" +
				 * zona.getIdzona()); listaEntidadesValores.put(entidadValor); }
				 * // Plantas Plantas plantaAux = new Plantas();
				 * plantaAux.setIdplanta(Integer.valueOf(edifEstruc
				 * .getIdplanta()));
				 * 
				 * Plantas planta = this.plantasService.find(plantaAux); if
				 * (planta != null) { entidadLinea = new JSONObject();
				 * entidadValor = new JSONObject();
				 * 
				 * entidadLinea.put("IdEntidad", "Plantas");
				 * entidadLinea.put("Codigo", uuidEdif + "_" + zona.getIdzona()
				 * + "_" + planta.getIdplanta());
				 * listaEntidadesLineas.put(entidadLinea);
				 * 
				 * entidadValor.put("IdEntidad", "Plantas");
				 * entidadValor.put("IdColumna", "IdPlanta");
				 * entidadValor.put("Codigo", uuidEdif + "_" + zona.getIdzona()
				 * + "_" + planta.getIdplanta()); entidadValor.put("Valor",
				 * planta.getIdplanta());
				 * listaEntidadesValores.put(entidadValor); entidadValor = new
				 * JSONObject(); entidadValor.put("IdEntidad", "Plantas");
				 * entidadValor.put("IdColumna", "DescPlanta");
				 * entidadValor.put("Codigo", uuidEdif + "_" + zona.getIdzona()
				 * + "_" + planta.getIdplanta()); entidadValor.put("Valor",
				 * planta.getCplanta() + " / " + planta.getEplanta());
				 * listaEntidadesValores.put(entidadValor); entidadValor = new
				 * JSONObject(); entidadValor.put("IdEntidad", "Plantas");
				 * entidadValor.put("IdColumna", "ZonaRel");
				 * entidadValor.put("Codigo", uuidEdif + "_" + zona.getIdzona()
				 * + "_" + planta.getIdplanta()); entidadValor.put("Valor",
				 * uuidEdif + "_" + zona.getIdzona());
				 * listaEntidadesValores.put(entidadValor); } }
				 * 
				 * // Objeto JSON con lineas de entidades
				 * entidades.put("entidadeslineas", listaEntidadesLineas);
				 * entidades.put("entidadesvalores", listaEntidadesValores);
				 * 
				 * respuesta = this.procesosJMSService .sincronizarGmao(
				 * entidades,
				 * "http://svc.intra.integracion.jakina.ejiedes.net/ctxapp/aa20bWebServices/Expertis_Sync_Movil_JS/index.php/sync/masters/InsertarLineasEntidades/"
				 * );
				 */

			}
			JSONObject clientes = new JSONObject();
			clientes.put("clientes", listaClientes);
			String url = urlConfig + Aa20bConstantes.URL_SUBIR_EDIFICIO;
			respuesta = this.procesosJMSService.sincronizarGmao(clientes, url);

			if (respuesta != null && respuesta.equals("OK")) {
				JSONObject activos = new JSONObject();
				activos.put("activos", listaActivoCliente);
				activos.put("activosPreventivo", JSONObject.NULL);
				activos.put("activoCampo", listaActivoCampo);
				url = "";
				url = urlConfig + Aa20bConstantes.URL_SUBIR_ACTIVOS;
				respuesta = this.procesosJMSService.sincronizarGmao(activos,
						url);
			}

			/**
			 * GMAO Sincronizacion de todos laz zonas y plantas por cada
			 * edificio
			 */
			this.procesosJMSService.sincronizarEdifEstruc(edificios,
					Aa20bConstantes.DIRECTA, urlConfig);

		}

		return respuesta;
	}

	@RequestMapping(value = "/subirTodosEspaciosGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodosEspaciosGmao() {
		ProcesosGmaoController.logger.info("[Gmao - subirTodosEspaciosGmao] ");

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuesta = "";
		Espacio espacioFilter = new Espacio();
		espacioFilter.setBaja("0");
		List<Espacio> espacios = this.espaciosService.findAll(espacioFilter,
				null);

		/**
		 * GMAO Sincronizacion de todos laz estancias
		 */
		respuesta = this.procesosJMSService.sincronizarTodasEstanciasGmao(
				espacios, Aa20bConstantes.DIRECTA, urlConfig);

		return respuesta;

	}

	@RequestMapping(value = "/subirTodosTecnicosGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodosTecnicosGmao() {
		ProcesosGmaoController.logger.info("[Gmao - subirTodosEspaciosGmao] ");

		String respuesta = "";
		Tecnicos tecnicosFilter = new Tecnicos();
		tecnicosFilter.setBaja("0");
		tecnicosFilter.setMovilgmao("1");
		List<Tecnicos> tecnicos = this.tecnicosService.findAll(tecnicosFilter,
				null);

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		if (tecnicos.size() != 0) {
			JSONArray listaOperarios = new JSONArray();

			for (Tecnicos tecnico : tecnicos) {
				int contadorTHaraba = 0;
				int contadorTHbizkaia = 0;
				int contadorTHgipuzkoa = 0;
				boolean tecnicoVariosTerrit = false;
				if (tecnico.getGuidtecnico() == null
						|| (tecnico.getGuidtecnico() != null && tecnico
								.getGuidtecnico().trim().equals(""))) {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					tecnico.setGuidtecnico(randomUUIDString);
					this.tecnicosService.actualizarUUIDtecnico(tecnico);
				}
				TecnicoEdif tecEdifAux = new TecnicoEdif();
				tecEdifAux.setIdtecnico(tecnico.getIdtecnico());
				List<TecnicoEdif> tecnicosEdificio = this.tecnicosEdificioService
						.findAll(tecEdifAux, null);
				Edificios edifAux = new Edificios();
				if (tecnicosEdificio.size() > 0) {
					// Recorremos los edificios del técnico para saber si
					// pertenece a un territorio o a varios. Si pertenece a
					// varios
					// no se le agrupará
					for (TecnicoEdif tecnicoEdif : tecnicosEdificio) {
						if (tecnicoEdif != null
								&& tecnicoEdif.getIdedificio() != null) {
							edifAux = new Edificios();
							edifAux = this.edificiosService
									.obtenerEdificio(tecnicoEdif
											.getIdedificio());
							if (edifAux != null && edifAux.getIdterri() != null
									&& edifAux.getIdterri() == 1) {
								contadorTHaraba++;
								if (contadorTHgipuzkoa > 0
										|| contadorTHbizkaia > 0) {
									tecnicoVariosTerrit = true;
								}
							} else if (edifAux != null
									&& edifAux.getIdterri() != null
									&& edifAux.getIdterri() == 20) {
								contadorTHgipuzkoa++;
								if (contadorTHaraba > 0
										|| contadorTHbizkaia > 0) {
									tecnicoVariosTerrit = true;
								}
							} else if (edifAux != null
									&& edifAux.getIdterri() != null
									&& edifAux.getIdterri() == 48) {
								contadorTHbizkaia++;
								if (contadorTHgipuzkoa > 0
										|| contadorTHaraba > 0) {
									tecnicoVariosTerrit = true;
								}
							}
						}
					}

				}

				JSONObject operario = new JSONObject();
				operario.put("IdOperario", tecnico.getIdtecnico());
				operario.put("DescOperario", tecnico.getNombre());
				if (edifAux != null && edifAux.getIdterri() != null
						&& edifAux.getIdterri() != 0 && !tecnicoVariosTerrit) {
					operario.put("IdAgrupacionOperario",
							"tec" + edifAux.getIdterri());
				} else {
					operario.put("IdAgrupacionOperario", JSONObject.NULL);
				}

				listaOperarios.put(operario);

				/*
				 * JSONObject activoOperario = new JSONObject();
				 * activoOperario.put("DescActivo", tecnico.getNombre());
				 * activoOperario.put("NSerie", JSONObject.NULL);
				 * activoOperario.put("IdCliente", "880000");
				 * activoOperario.put("IdClaseActivo", "AA20BTEC");
				 * activoOperario.put("IdZona", JSONObject.NULL);
				 * activoOperario.put("QR", JSONObject.NULL);
				 * activoOperario.put("Direccion", JSONObject.NULL);
				 * activoOperario.put("CodigoPostal", JSONObject.NULL);
				 * activoOperario.put("Poblacion", JSONObject.NULL);
				 * activoOperario.put("Provincia", JSONObject.NULL);
				 * activoOperario.put("PosicionGPS", JSONObject.NULL);
				 * activoOperario.put("CodEnlace", JSONObject.NULL);
				 * activoOperario.put("IdActivo", "ACT" +
				 * tecnico.getIdtecnico()); activoOperario.put("IdEstado",
				 * JSONObject.NULL); activoOperario.put("Pais",
				 * JSONObject.NULL); activoOperario.put("IdAgrupacionActivo",
				 * JSONObject.NULL); activoOperario.put("FechaFinGarantia",
				 * JSONObject.NULL); activoOperario.put("fechaSincronizacion",
				 * fechaActualJson); activoOperario.put("fechaActual",
				 * fechaActualJson); activoOperario.put("FechaUltimaSinc",
				 * fechaActualJson); activoOperario.put("FechaBaja",
				 * JSONObject.NULL);
				 * 
				 * activoOperario.put("UUIdActivo", tecnico.getGuidtecnico());
				 * listaActivoOperario.put(activoOperario);
				 * 
				 * JSONObject activoCampoC = new JSONObject();
				 * activoCampoC.put("UUIDActivo", tecnico.getGuidtecnico());
				 * activoCampoC.put("Valor", tecnico.getNombre());
				 * activoCampoC.put("IdCampo", "NOMBRE");
				 * listaActivoCampo.put(activoCampoC);
				 */

			}
			JSONObject operarios = new JSONObject();
			operarios.put("operarios", listaOperarios);
			String url = urlConfig + Aa20bConstantes.URL_SUBIR_TECNICOS;
			respuesta = this.procesosJMSService.sincronizarGmao(operarios, url);

			/*
			 * if (respuesta != null && respuesta.equals("OK")) { JSONObject
			 * activos = new JSONObject(); activos.put("activos",
			 * listaActivoOperario); activos.put("activosPreventivo",
			 * JSONObject.NULL); activos.put("activoCampo", listaActivoCampo);
			 * url =
			 * "http://svc.intra.integracion.jakina.ejiedes.net/ctxapp/aa20bWebServices/Expertis_Sync_Movil_JS/index.php/sync/masters/SubirActivos/"
			 * ; respuesta = this.procesosJMSService.sincronizarGmao(activos,
			 * url); }
			 */

		}

		return respuesta;

	}

	@RequestMapping(value = "/subirTodosClasesGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodosClasesGmao() {
		ProcesosGmaoController.logger.info("[Gmao - subirTodosClasesGmao] ");

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuesta = "";
		Clase clasesFilter = new Clase();
		clasesFilter.setBaja("0");
		List<Clase> clases = this.clasesService.findAll(clasesFilter, null);

		/**
		 * GMAO Sincronizacion de todos las clases
		 */
		respuesta = this.procesosJMSService.sincronizarTodasClasesGmao(clases,
				Aa20bConstantes.DIRECTA, urlConfig);

		return respuesta;

	}

	@RequestMapping(value = "/subirTodosCodigosGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodosCodigosGmao() {
		ProcesosGmaoController.logger.info("[Gmao - subirTodosCodigosGmao] ");

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuesta = "";
		Codigo codigosFilter = new Codigo();
		codigosFilter.setBaja("0");
		List<Codigo> codigos = this.codigosService.findAll(codigosFilter, null);

		/**
		 * GMAO Sincronizacion de todos los codigos de parte
		 */
		respuesta = this.procesosJMSService.sincronizarTodosCodigosGmao(
				codigos, Aa20bConstantes.DIRECTA, urlConfig);

		return respuesta;

	}

	@RequestMapping(value = "/subirTodosGamasGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodosGamasGmao() {
		ProcesosGmaoController.logger.info("[Gmao - subirTodosGamasGmao] ");

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuesta = "";
		Gamas gamasFilter = new Gamas();
		gamasFilter.setBaja("0");
		List<Gamas> gamas = this.gamasService.findAll(gamasFilter, null);

		/**
		 * GMAO Sincronizacion de todas las gamas de partes preventivos
		 */
		respuesta = this.procesosJMSService.sincronizarTodosGamasGmao(gamas,
				Aa20bConstantes.DIRECTA, urlConfig);

		return respuesta;

	}

	@RequestMapping(value = "/subirTodosDepartamentosGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodosDepartamentosGmao() {
		ProcesosGmaoController.logger.info("[Gmao - subirTodosGamasGmao] ");

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuesta = "";
		Departamentos departamentosFilter = new Departamentos();
		// departamentosFilter.setBaja("0");
		List<Departamentos> dptos = this.departamentosService.findAll(
				departamentosFilter, null);

		/**
		 * GMAO Sincronizacion de todas las gamas de partes preventivos
		 */
		respuesta = this.procesosJMSService.sincronizarTodosDepartamentosGmao(
				dptos, Aa20bConstantes.DIRECTA, urlConfig);

		return respuesta;

	}

	@RequestMapping(value = "/subirTodasDireccionesGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodasDireccionesGmao() {
		ProcesosGmaoController.logger.info("[Gmao - subirTodosGamasGmao] ");

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuesta = "";
		Direcciones direccionesFilter = new Direcciones();
		// direccionesFilter.setBaja("0");
		List<Direcciones> dirs = this.direccionesService.findAllCargaGmao(
				direccionesFilter, null);

		/**
		 * GMAO Sincronizacion de todas las gamas de partes preventivos
		 */
		respuesta = this.procesosJMSService.sincronizarTodasDireccionesGmao(
				dirs, Aa20bConstantes.DIRECTA, urlConfig);

		return respuesta;

	}

	@RequestMapping(value = "/subirTodosMaquinasGmaoFase1", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodosMaquinasGmaoFase1() {
		ProcesosGmaoController.logger.info("[Gmao - subirTodosMaquinasGmao] ");

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuesta = "";
		Maquinas maquinasFilter = new Maquinas();
		maquinasFilter.setBaja("0");
		List<Maquinas> maquinas = this.maquinasService.findAll(maquinasFilter,
				null);

		/**
		 * GMAO Sincronizacion de todas las gamas de partes preventivos
		 */
		respuesta = this.procesosJMSService.sincronizarTodosMaquinasGmao(
				maquinas, Aa20bConstantes.DIRECTA, urlConfig, 1);

		return respuesta;

	}

	@RequestMapping(value = "/subirTodosServiciosGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodosServiciosGmao() {
		ProcesosGmaoController.logger.info("[Gmao - subirTodosServiciosGmao] ");

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuesta = "";
		Servicios servicioFilter = new Servicios();
		servicioFilter.setBaja("0");
		List<Servicios> servicios = this.serviciosService.findAll(
				servicioFilter, null);

		/**
		 * GMAO Sincronizacion de todos los codigos de parte
		 */
		respuesta = this.procesosJMSService.sincronizarTodosServiciosGmao(
				servicios, Aa20bConstantes.DIRECTA, urlConfig);

		return respuesta;

	}

	@RequestMapping(value = "/estrGmaoClaseActivoEdificio", method = RequestMethod.POST)
	public @ResponseBody
	String estrGmaoClaseActivoEdificio(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger
				.info("[Gmao - estrGmaoClaseActivoEdificio] ");
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject requestJSON = new JSONObject();
		if (valorJSON != null && !valorJSON.trim().equals("")) {
			requestJSON = new JSONObject(valorJSON);
		} else {
			JSONArray clasesActivo = new JSONArray();
			JSONObject claseActivo = new JSONObject();
			JSONArray clasesActivoCampo = new JSONArray();
			JSONObject claseActivoCampo = new JSONObject();
			JSONArray clasesActivoIdioma = new JSONArray();
			JSONObject claseActivoIdioma = new JSONObject();
			JSONArray clasesActivoCampoIdioma = new JSONArray();
			JSONObject claseActivoCampoIdioma = new JSONObject();

			claseActivo.put("IDClaseActivo", "AA20BEDIF");
			claseActivo.put("DescClaseActivo", "Edificio");
			claseActivo.put("codMovilGMAO", "AA20BEDIF");
			claseActivo.put("EmailAlerta", JSONObject.NULL);
			claseActivo.put("Planificacion", false);
			clasesActivo.put(claseActivo);

			claseActivoCampo.put("IdClaseActivo", "AA20BEDIF");
			claseActivoCampo.put("IdCampo", "CEDIFICIO");
			claseActivoCampo.put("DescCampo", "Desc. edif. castellano");
			claseActivoCampo.put("Agrupador", "General");
			claseActivoCampo.put("IdEnumerado", JSONObject.NULL);
			claseActivoCampo.put("Tabla", JSONObject.NULL);
			claseActivoCampo.put("Secuencia", "1");
			claseActivoCampo.put("Tipo", "3");
			clasesActivoCampo.put(claseActivoCampo);

			claseActivoCampo = new JSONObject();
			claseActivoCampo.put("IdClaseActivo", "AA20BEDIF");
			claseActivoCampo.put("IdCampo", "EEDIFICIO");
			claseActivoCampo.put("DescCampo", "Desc. edif. euskera");
			claseActivoCampo.put("Agrupador", "General");
			claseActivoCampo.put("IdEnumerado", JSONObject.NULL);
			claseActivoCampo.put("Tabla", JSONObject.NULL);
			claseActivoCampo.put("Secuencia", "2");
			claseActivoCampo.put("Tipo", "3");
			clasesActivoCampo.put(claseActivoCampo);

			claseActivoIdioma.put("IdClaseActivo", "AA20BEDIF");
			claseActivoIdioma.put("IdIdioma", "gv");
			claseActivoIdioma.put("DesClaseActivo", "Edificio");
			clasesActivoIdioma.put(claseActivoIdioma);

			claseActivoIdioma = new JSONObject();
			claseActivoIdioma.put("IdClaseActivo", "AA20BEDIF");
			claseActivoIdioma.put("IdIdioma", "eu");
			claseActivoIdioma.put("DesClaseActivo", "Eraikina");
			clasesActivoIdioma.put(claseActivoIdioma);

			claseActivoCampoIdioma.put("IdClaseActivo", "AA20BEDIF");
			claseActivoCampoIdioma.put("IdIdioma", "gv");
			claseActivoCampoIdioma.put("IdCampo", "CEDIFICIO");
			claseActivoCampoIdioma.put("DescCampo", "Descripción castellano");
			claseActivoCampoIdioma.put("Agrupador", "General");
			clasesActivoCampoIdioma.put(claseActivoCampoIdioma);

			claseActivoCampoIdioma = new JSONObject();
			claseActivoCampoIdioma.put("IdClaseActivo", "AA20BEDIF");
			claseActivoCampoIdioma.put("IdIdioma", "eu");
			claseActivoCampoIdioma.put("IdCampo", "CEDIFICIO");
			claseActivoCampoIdioma.put("DescCampo", "Azalpena gaztelania");
			claseActivoCampoIdioma.put("Agrupador", "General");
			clasesActivoCampoIdioma.put(claseActivoCampoIdioma);

			claseActivoCampoIdioma = new JSONObject();
			claseActivoCampoIdioma.put("IdClaseActivo", "AA20BEDIF");
			claseActivoCampoIdioma.put("IdIdioma", "gv");
			claseActivoCampoIdioma.put("IdCampo", "EEDIFICIO");
			claseActivoCampoIdioma.put("DescCampo", "Descripción euskera");
			claseActivoCampoIdioma.put("Agrupador", "General");
			clasesActivoCampoIdioma.put(claseActivoCampoIdioma);

			claseActivoCampoIdioma = new JSONObject();
			claseActivoCampoIdioma.put("IdClaseActivo", "AA20BEDIF");
			claseActivoCampoIdioma.put("IdIdioma", "eu");
			claseActivoCampoIdioma.put("IdCampo", "EEDIFICIO");
			claseActivoCampoIdioma.put("DescCampo", "Azalpena euskaraz");
			claseActivoCampoIdioma.put("Agrupador", "General");
			clasesActivoCampoIdioma.put(claseActivoCampoIdioma);

			requestJSON.put("clasesActivo", clasesActivo);
			requestJSON.put("clasesActivoCampo", clasesActivoCampo);
			requestJSON.put("clasesactivoidioma", clasesActivoIdioma);
			requestJSON.put("claseactivocampoidioma", clasesActivoCampoIdioma);
		}

		String url = urlConfig + Aa20bConstantes.URL_ESTRUC_ACTIVO;
		respuesta = this.procesosJMSService.sincronizarGmao(requestJSON, url);

		return respuesta;

	}

	@RequestMapping(value = "/subirTodosTerritoriosGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodosTerritoriosGmao(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger
				.info("[Gmao - subirTodosTerritoriosGmao] ");
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject requestJSON = new JSONObject();
		if (valorJSON != null && !valorJSON.trim().equals("")) {
			requestJSON = new JSONObject(valorJSON);
		} else {
			JSONArray zonas = new JSONArray();
			JSONObject zona = new JSONObject();

			zona.put("IdZona", "0");
			zona.put("DescZona", "Por defecto");
			zonas.put(zona);

			zona = new JSONObject();
			zona.put("IdZona", "1");
			zona.put("DescZona", "Araba / Álava");
			zonas.put(zona);

			zona = new JSONObject();
			zona.put("IdZona", "48");
			zona.put("DescZona", "Bizkaia");
			zonas.put(zona);

			zona = new JSONObject();
			zona.put("IdZona", "20");
			zona.put("DescZona", "Gipuzkoa");
			zonas.put(zona);

			requestJSON.put("zonas", zonas);
		}

		String url = urlConfig + Aa20bConstantes.URL_SUBIR_ZONAS;
		respuesta = this.procesosJMSService.sincronizarGmao(requestJSON, url);

		return respuesta;

	}

	@RequestMapping(value = "/subirTodasPrioridadesGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodasPrioridadesGmao(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger
				.info("[Gmao - subirTodasPrioridadesGmao] ");
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject requestJSON = new JSONObject();
		/**
		 * Si el valorJSON tiene valor significa que es subida manual por lo que
		 * se ha tenido que introducir el JSON como texto en el textarea
		 */
		if (valorJSON != null && !valorJSON.trim().equals("")) {
			requestJSON = new JSONObject(valorJSON);
		} else {

			JSONArray prioridades = new JSONArray();
			JSONObject prioridad = new JSONObject();
			JSONArray prioridadesidioma = new JSONArray();
			JSONObject prioridadIdioma = new JSONObject();

			prioridad.put("IdPrioridad", "0");
			prioridad.put("DescPrioridad", "Normal");
			prioridad.put("Predeterminada", true);
			prioridades.put(prioridad);

			prioridad = new JSONObject();
			prioridad.put("IdPrioridad", "1");
			prioridad.put("DescPrioridad", "Urgente");
			prioridad.put("Predeterminada", false);
			prioridades.put(prioridad);

			prioridadIdioma.put("IdPrioridad", "0");
			prioridadIdioma.put("IdIdioma", "gv");
			prioridadIdioma.put("DescPrioridad", "Normal");
			prioridadesidioma.put(prioridadIdioma);

			prioridadIdioma = new JSONObject();
			prioridadIdioma.put("IdPrioridad", "0");
			prioridadIdioma.put("IdIdioma", "eu");
			prioridadIdioma.put("DescPrioridad", "Normala");
			prioridadesidioma.put(prioridadIdioma);

			prioridadIdioma = new JSONObject();
			prioridadIdioma.put("IdPrioridad", "1");
			prioridadIdioma.put("IdIdioma", "gv");
			prioridadIdioma.put("DescPrioridad", "Urgente");
			prioridadesidioma.put(prioridadIdioma);

			prioridadIdioma = new JSONObject();
			prioridadIdioma.put("IdPrioridad", "1");
			prioridadIdioma.put("IdIdioma", "eu");
			prioridadIdioma.put("DescPrioridad", "Presakoa");
			prioridadesidioma.put(prioridadIdioma);

			requestJSON.put("prioridades", prioridades);
			requestJSON.put("prioridadidioma", prioridadesidioma);
		}

		String url = urlConfig + Aa20bConstantes.URL_SUBIR_PRIORIDADES;
		respuesta = this.procesosJMSService.sincronizarGmao(requestJSON, url);

		return respuesta;

	}

	@RequestMapping(value = "/subirAgrupacionActivoGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodasAgrupacionesGmao(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger
				.info("[Gmao - subirAgrupacionActivoGmao] ");
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject requestJSON = new JSONObject();
		/**
		 * Si el valorJSON tiene valor significa que es subida manual por lo que
		 * se ha tenido que introducir el JSON como texto en el textarea
		 */
		if (valorJSON != null && !valorJSON.trim().equals("")) {
			requestJSON = new JSONObject(valorJSON);
		} else {

			JSONArray agrupacionActivo = new JSONArray();
			JSONObject agrupacion = new JSONObject();

			agrupacion.put("IdAgrupacionActivo", "act48");
			agrupacion.put("DescAgrupacionActivo", "Edificios Bizkaia");
			agrupacionActivo.put(agrupacion);

			agrupacion = new JSONObject();
			agrupacion.put("IdAgrupacionActivo", "act20");
			agrupacion.put("DescAgrupacionActivo", "Edificios Gipuzkoa");
			agrupacionActivo.put(agrupacion);

			agrupacion = new JSONObject();
			agrupacion.put("IdAgrupacionActivo", "act1");
			agrupacion.put("DescAgrupacionActivo", "Edificios Araba");
			agrupacionActivo.put(agrupacion);

			requestJSON.put("agrupacionActivo", agrupacionActivo);

		}

		String url = urlConfig + Aa20bConstantes.URL_SUBIR_AGRUPACION_ACTIVO;
		respuesta = this.procesosJMSService.sincronizarGmao(requestJSON, url);

		return respuesta;

	}

	@RequestMapping(value = "/subirAgrupacionOperarioGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodasAgrupacionOperarioGmao(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger
				.info("[Gmao - subirAgrupacionOperarioGmao] ");
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject requestJSON = new JSONObject();
		/**
		 * Si el valorJSON tiene valor significa que es subida manual por lo que
		 * se ha tenido que introducir el JSON como texto en el textarea
		 */
		if (valorJSON != null && !valorJSON.trim().equals("")) {
			requestJSON = new JSONObject(valorJSON);
		} else {

			JSONArray agrupacionOperario = new JSONArray();
			JSONObject operario = new JSONObject();

			operario.put("IdAgrupacionOperario", "tec48");
			operario.put("DescAgrupacionOperario", "Tecnicos Bizkaia");
			agrupacionOperario.put(operario);

			operario = new JSONObject();
			operario.put("IdAgrupacionOperario", "tec20");
			operario.put("DescAgrupacionOperario", "Tecnicos Gipuzkoa");
			agrupacionOperario.put(operario);

			operario = new JSONObject();
			operario.put("IdAgrupacionOperario", "tec1");
			operario.put("DescAgrupacionOperario", "Tecnicos Araba");
			agrupacionOperario.put(operario);

			requestJSON.put("agrupacionOperario", agrupacionOperario);

		}

		String url = urlConfig + Aa20bConstantes.URL_SUBIR_AGRUPACION_OPERARIO;
		respuesta = this.procesosJMSService.sincronizarGmao(requestJSON, url);

		return respuesta;

	}

	@RequestMapping(value = "/subirAgrupacionOperarioActivoGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodasAgrupacionOperarioActivoGmao(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger
				.info("[Gmao - subirAgrupacionOperarioActivoGmao] ");
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject requestJSON = new JSONObject();
		/**
		 * Si el valorJSON tiene valor significa que es subida manual por lo que
		 * se ha tenido que introducir el JSON como texto en el textarea
		 */
		if (valorJSON != null && !valorJSON.trim().equals("")) {
			requestJSON = new JSONObject(valorJSON);
		} else {

			JSONArray agrupacionOperarioActivo = new JSONArray();
			JSONObject operarioActivo = new JSONObject();

			operarioActivo.put("IdAgrupacionActivo", "act48");
			operarioActivo.put("IdAgrupacionOperario", "tec48");
			agrupacionOperarioActivo.put(operarioActivo);

			operarioActivo = new JSONObject();
			operarioActivo.put("IdAgrupacionActivo", "act20");
			operarioActivo.put("IdAgrupacionOperario", "tec20");
			agrupacionOperarioActivo.put(operarioActivo);

			operarioActivo = new JSONObject();
			operarioActivo.put("IdAgrupacionActivo", "act1");
			operarioActivo.put("IdAgrupacionOperario", "tec1");
			agrupacionOperarioActivo.put(operarioActivo);

			requestJSON.put("agrupacionOperarioActivo",
					agrupacionOperarioActivo);

		}

		String url = urlConfig
				+ Aa20bConstantes.URL_SUBIR_AGRUPACION_OPERARIO_ACTIVO;
		respuesta = this.procesosJMSService.sincronizarGmao(requestJSON, url);

		return respuesta;

	}

	@RequestMapping(value = "/subirTodosEstadosGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodosEstadosGmao(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger.info("[Gmao - subirTodosEstadosGmao] ");
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject requestJSON = new JSONObject();
		/**
		 * Si el valorJSON tiene valor significa que es subida manual por lo que
		 * se ha tenido que introducir el JSON como texto en el textarea
		 */
		if (valorJSON != null && !valorJSON.trim().equals("")) {
			requestJSON = new JSONObject(valorJSON);
		} else {

			JSONArray estados = new JSONArray();
			JSONObject estado = new JSONObject();
			JSONArray estadosidioma = new JSONArray();
			JSONObject estadoIdioma = new JSONObject();

			estado.put("IdEstadoOt", "ASIG");
			estado.put("CodEnlace", JSONObject.NULL);
			estado.put("DescEstado", "Asignado");
			estado.put("Color", "#3333ff");
			estado.put("Predeterminado", true);
			estado.put("Cierre", false);
			estados.put(estado);

			estado = new JSONObject();
			estado.put("IdEstadoOt", "CURS");
			estado.put("CodEnlace", JSONObject.NULL);
			estado.put("DescEstado", "En curso");
			estado.put("Color", "#ff6600");
			estado.put("Predeterminado", false);
			estado.put("Cierre", false);
			estados.put(estado);

			estado = new JSONObject();
			estado.put("IdEstadoOt", "PAUSA");
			estado.put("CodEnlace", JSONObject.NULL);
			estado.put("DescEstado", "En pausa");
			estado.put("Color", "#ffff66");
			estado.put("Predeterminado", false);
			estado.put("Cierre", false);
			estados.put(estado);

			estado = new JSONObject();
			estado.put("IdEstadoOt", "TERM");
			estado.put("CodEnlace", JSONObject.NULL);
			estado.put("DescEstado", "Finalizado");
			estado.put("Color", "#33cc00");
			estado.put("Predeterminado", false);
			estado.put("Cierre", true);
			estados.put(estado);

			estadoIdioma.put("IdEstadoOt", "ASIG");
			estadoIdioma.put("IdIdioma", "gv");
			estadoIdioma.put("DescEstado", "Asignado");
			estadosidioma.put(estadoIdioma);

			estadoIdioma = new JSONObject();
			estadoIdioma.put("IdEstadoOt", "ASIG");
			estadoIdioma.put("IdIdioma", "eu");
			estadoIdioma.put("DescEstado", "Esleituta");
			estadosidioma.put(estadoIdioma);

			estadoIdioma.put("IdEstadoOt", "CURS");
			estadoIdioma.put("IdIdioma", "gv");
			estadoIdioma.put("DescEstado", "En curso");
			estadosidioma.put(estadoIdioma);

			estadoIdioma = new JSONObject();
			estadoIdioma.put("IdEstadoOt", "CURS");
			estadoIdioma.put("IdIdioma", "eu");
			estadoIdioma.put("DescEstado", "Uneko");
			estadosidioma.put(estadoIdioma);

			estadoIdioma.put("IdEstadoOt", "PAUSA");
			estadoIdioma.put("IdIdioma", "gv");
			estadoIdioma.put("DescEstado", "En pausa");
			estadosidioma.put(estadoIdioma);

			estadoIdioma = new JSONObject();
			estadoIdioma.put("IdEstadoOt", "PAUSA");
			estadoIdioma.put("IdIdioma", "eu");
			estadoIdioma.put("DescEstado", "Etenaldian");
			estadosidioma.put(estadoIdioma);

			estadoIdioma.put("IdEstadoOt", "TERM");
			estadoIdioma.put("IdIdioma", "gv");
			estadoIdioma.put("DescEstado", "Finalizado");
			estadosidioma.put(estadoIdioma);

			estadoIdioma = new JSONObject();
			estadoIdioma.put("IdEstadoOt", "TERM");
			estadoIdioma.put("IdIdioma", "eu");
			estadoIdioma.put("DescEstado", "Amaitua");
			estadosidioma.put(estadoIdioma);

			requestJSON.put("estados", estados);
			requestJSON.put("estadodidioma", estadosidioma);
		}

		String url = urlConfig + Aa20bConstantes.URL_SUBIR_ESTADOS;
		respuesta = this.procesosJMSService.sincronizarGmao(requestJSON, url);

		return respuesta;

	}

	@RequestMapping(value = "/subirTodasHorasGmao", method = RequestMethod.POST)
	public @ResponseBody
	String subirTodasHorasGmao(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger.info("[Gmao - subirTodasHorasGmao] ");
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject requestJSON = new JSONObject();
		/**
		 * Si el valorJSON tiene valor significa que es subida manual por lo que
		 * se ha tenido que introducir el JSON como texto en el textarea
		 */
		if (valorJSON != null && !valorJSON.trim().equals("")) {
			requestJSON = new JSONObject(valorJSON);
		} else {

			JSONArray horas = new JSONArray();
			JSONObject hora = new JSONObject();
			JSONArray horasidioma = new JSONArray();
			JSONObject horaIdioma = new JSONObject();

			hora.put("IdHora", "HN");
			hora.put("DescHora", "Hora normal");
			hora.put("Predeterminada", true);
			hora.put("DescReemplazable", false);
			hora.put("TipoMod", 1);
			horas.put(hora);

			horaIdioma.put("IdHora", "HN");
			horaIdioma.put("IdIdioma", "gv");
			horaIdioma.put("DescHora", "Hora normal");
			horasidioma.put(horaIdioma);

			horaIdioma = new JSONObject();
			horaIdioma.put("IdHora", "HN");
			horaIdioma.put("IdIdioma", "eu");
			horaIdioma.put("DescHora", "Ordu arrunta");
			horasidioma.put(horaIdioma);

			requestJSON.put("horas", horas);
			requestJSON.put("horaidioma", horasidioma);

		}

		String url = urlConfig + Aa20bConstantes.URL_SUBIR_TIPOS_HORAS;
		respuesta = this.procesosJMSService.sincronizarGmao(requestJSON, url);

		return respuesta;

	}

	@RequestMapping(value = "/estrGmaoTiposOTs", method = RequestMethod.POST)
	public @ResponseBody
	String estrGmaoTiposOTs(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger.info("[Gmao - estrGmaoTiposOTs] ");
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}
		JSONObject requestJSON = new JSONObject();

		if (valorJSON != null && !valorJSON.trim().equals("")) {
			requestJSON = new JSONObject(valorJSON);
		} else {
			JSONArray tipos = new JSONArray();
			JSONObject tipo = new JSONObject();

			JSONArray tiposOtCampo = new JSONArray();
			JSONObject tipoOtCampo = new JSONObject();

			JSONArray tiposOtIdioma = new JSONArray();
			JSONObject tipoOtIdioma = new JSONObject();

			JSONArray tiposOtCampoIdioma = new JSONArray();
			JSONObject tipoOtCampoIdioma = new JSONObject();

			tipo.put("IdTipo", "1");
			tipo.put("DescTipo", "Correctivo");
			tipo.put("IdAgrupacionTipoOt", JSONObject.NULL);
			tipo.put("Predeterminado", true);
			tipos.put(tipo);

			tipo = new JSONObject();
			tipo.put("IdTipo", "2");
			tipo.put("DescTipo", "Preventivo");
			tipo.put("IdAgrupacionTipoOt", JSONObject.NULL);
			tipo.put("Predeterminado", false);
			tipos.put(tipo);

			/*
			 * tipoOtCampo.put("IdTipo", "1"); tipoOtCampo.put("IdCampo",
			 * "FECHARE"); tipoOtCampo.put("DescCampo", "F. Recepción");
			 * tipoOtCampo.put("Agrupador", "General");
			 * tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			 * tipoOtCampo.put("Tabla", JSONObject.NULL);
			 * tipoOtCampo.put("Secuencia", "10"); tipoOtCampo.put("Tipo", "5");
			 * tiposOtCampo.put(tipoOtCampo);
			 */

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "NOMBRE");
			tipoOtCampo.put("DescCampo", "Nombre");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "10");
			tipoOtCampo.put("Tipo", "3");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "TELEFONO");
			tipoOtCampo.put("DescCampo", "Teléfono");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "20");
			tipoOtCampo.put("Tipo", "3");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "MAIL");
			tipoOtCampo.put("DescCampo", "E-mail");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "30");
			tipoOtCampo.put("Tipo", "3");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "DEPARAUX");
			tipoOtCampo.put("DescCampo", "Aux departamento");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("EditAlta", 0);
			tipoOtCampo.put("Secuencia", "60");
			tipoOtCampo.put("Tipo", "1");
			tipoOtCampo.put("ValorDefecto", "0");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "DEPAR");
			tipoOtCampo.put("DescCampo", "Departamento");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "40");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("CamposFiltroEntidad", "DEPARAUX");
			tipoOtCampo.put("ColumnasFiltroEntidad", "Baja");
			tipoOtCampo.put("IdEntidad", "Departamentos");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "DIR");
			tipoOtCampo.put("DescCampo", "Centro órganico");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "50");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("IdEntidad", "Direcciones");
			tipoOtCampo.put("CamposFiltroEntidad", "DEPAR");
			tipoOtCampo.put("ColumnasFiltroEntidad", "DeparRel");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "IDZONAEDIF");
			tipoOtCampo.put("DescCampo", "Zona");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "70");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("IdEntidad", "Zonas");
			tipoOtCampo.put("CamposFiltroEntidad", "UUIdactivo");
			tipoOtCampo.put("ColumnasFiltroEntidad", "IdEdificio");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "IDPLANTA");
			tipoOtCampo.put("DescCampo", "Planta");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "80");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("IdEntidad", "Plantas");
			tipoOtCampo.put("CamposFiltroEntidad", "IDZONAEDIF");
			tipoOtCampo.put("ColumnasFiltroEntidad", "ZonaRel");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "IDESTANCIA");
			tipoOtCampo.put("DescCampo", "Estancia");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "90");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("IdEntidad", "Estancias");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "IDCLASE");
			tipoOtCampo.put("DescCampo", "Clase");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "100");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("IdEntidad", "Clases");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "IDCODIGO");
			tipoOtCampo.put("DescCampo", "Código parte");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "110");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("IdEntidad", "Codigos");
			tipoOtCampo.put("CamposFiltroEntidad", "IDCLASE");
			tipoOtCampo.put("ColumnasFiltroEntidad", "ClaseRel");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "1");
			tipoOtCampo.put("IdCampo", "NOTASTEC");
			tipoOtCampo.put("DescCampo", "Notas técnico");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 1);
			tipoOtCampo.put("Secuencia", "120");
			tipoOtCampo.put("Tipo", "3");
			tiposOtCampo.put(tipoOtCampo);

			// PREVENTIVO
			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "2");
			tipoOtCampo.put("IdCampo", "IDZONAEDIF");
			tipoOtCampo.put("DescCampo", "Zona");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "10");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("IdEntidad", "Zonas");
			tipoOtCampo.put("CamposFiltroEntidad", "UUIdactivo");
			tipoOtCampo.put("ColumnasFiltroEntidad", "IdEdificio");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "2");
			tipoOtCampo.put("IdCampo", "IDPLANTA");
			tipoOtCampo.put("DescCampo", "Planta");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "20");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("IdEntidad", "Plantas");
			tipoOtCampo.put("CamposFiltroEntidad", "IDZONAEDIF");
			tipoOtCampo.put("ColumnasFiltroEntidad", "ZonaRel");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "2");
			tipoOtCampo.put("IdCampo", "IDCLASE");
			tipoOtCampo.put("DescCampo", "Clase");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "30");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("IdEntidad", "Clases");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "2");
			tipoOtCampo.put("IdCampo", "IDGAMA");
			tipoOtCampo.put("DescCampo", "Gama");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "40");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("IdEntidad", "Gamas");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "2");
			tipoOtCampo.put("IdCampo", "IDMAQUINA");
			tipoOtCampo.put("DescCampo", "Maquina");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 0);
			tipoOtCampo.put("Secuencia", "50");
			tipoOtCampo.put("Tipo", "9");
			tipoOtCampo.put("IdEntidad", "Maquinas");
			tipoOtCampo.put("CamposFiltroEntidad", "UUIdactivo");
			tipoOtCampo.put("ColumnasFiltroEntidad", "IdEdificio");
			tiposOtCampo.put(tipoOtCampo);

			tipoOtCampo = new JSONObject();
			tipoOtCampo.put("IdTipo", "2");
			tipoOtCampo.put("IdCampo", "NOTASTEC");
			tipoOtCampo.put("DescCampo", "Notas técnico");
			tipoOtCampo.put("Agrupador", "General");
			tipoOtCampo.put("IdEnumerado", JSONObject.NULL);
			tipoOtCampo.put("Tabla", JSONObject.NULL);
			tipoOtCampo.put("EditModificacion", 1);
			tipoOtCampo.put("Secuencia", "60");
			tipoOtCampo.put("Tipo", "3");
			tiposOtCampo.put(tipoOtCampo);

			// Campos idioma

			// CORRECTIVO
			tipoOtIdioma.put("IdTipo", "1");
			tipoOtIdioma.put("IdIdioma", "gv");
			tipoOtIdioma.put("DescTipo", "Partes correctivos");
			tiposOtIdioma.put(tipoOtIdioma);

			tipoOtIdioma = new JSONObject();
			tipoOtIdioma.put("IdTipo", "1");
			tipoOtIdioma.put("IdIdioma", "eu");
			tipoOtIdioma.put("DescTipo", "Zuzenketa-parteak");
			tiposOtIdioma.put(tipoOtIdioma);

			// PREVENTIVO
			tipoOtIdioma = new JSONObject();
			tipoOtIdioma.put("IdTipo", "2");
			tipoOtIdioma.put("IdIdioma", "gv");
			tipoOtIdioma.put("DescTipo", "Partes preventivos");
			tiposOtIdioma.put(tipoOtIdioma);

			tipoOtIdioma = new JSONObject();
			tipoOtIdioma.put("IdTipo", "2");
			tipoOtIdioma.put("IdIdioma", "eu");
			tipoOtIdioma.put("DescTipo", "Prebentzio-parteak");
			tiposOtIdioma.put(tipoOtIdioma);

			// CORRECTIVO
			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "NOMBRE");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Nombre");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "NOMBRE");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Izena");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "TELEFONO");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Teléfono");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "TELEFONO");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Telefonoa");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "MAIL");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "E-mail");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "MAIL");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "E-maila");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "DEPARAUX");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Departamento aux");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "DEPARAUX");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Saila aux");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "DEPAR");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Departamento");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "DEPAR");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Saila");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "DIR");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Centro órganico");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "DIR");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Adm. Egit. Atala");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "IDZONAEDIF");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Zona");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "IDZONAEDIF");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Zonaldea");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "IDPLANTA");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Planta");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "IDPLANTA");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Solairua");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "IDESTANCIA");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Estancia");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "IDESTANCIA");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Egonlekua");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "IDCLASE");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Clase");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "IDCLASE");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Klasea");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "IDCODIGO");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Código de parte");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "IDCODIGO");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Parte-kodea");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "NOTASTEC");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Notas técnico");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "1");
			tipoOtCampoIdioma.put("IdCampo", "NOTASTEC");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Teknikariaren oharrak");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			/*
			 * tipoOtCampoIdioma = new JSONObject();
			 * tipoOtCampoIdioma.put("IdTipo", "1");
			 * tipoOtCampoIdioma.put("IdCampo", "OBSERV");
			 * tipoOtCampoIdioma.put("IdIdioma", "gv");
			 * tipoOtCampoIdioma.put("DescCampo", "Descripción del parte");
			 * tipoOtCampoIdioma.put("Agrupador", "General");
			 * tiposOtCampoIdioma.put(tipoOtCampoIdioma);
			 * 
			 * tipoOtCampoIdioma = new JSONObject();
			 * tipoOtCampoIdioma.put("IdTipo", "1");
			 * tipoOtCampoIdioma.put("IdCampo", "OBSERV");
			 * tipoOtCampoIdioma.put("IdIdioma", "eu");
			 * tipoOtCampoIdioma.put("DescCampo", "Partearen deskribapena");
			 * tipoOtCampoIdioma.put("Agrupador", "General");
			 * tiposOtCampoIdioma.put(tipoOtCampoIdioma);
			 * 
			 * tipoOtCampoIdioma = new JSONObject();
			 * tipoOtCampoIdioma.put("IdTipo", "1");
			 * tipoOtCampoIdioma.put("IdCampo", "NOTASTEC");
			 * tipoOtCampoIdioma.put("IdIdioma", "gv");
			 * tipoOtCampoIdioma.put("DescCampo", "Notas del técnico");
			 * tipoOtCampoIdioma.put("Agrupador", "General");
			 * tiposOtCampoIdioma.put(tipoOtCampoIdioma);
			 * 
			 * tipoOtCampoIdioma = new JSONObject();
			 * tipoOtCampoIdioma.put("IdTipo", "1");
			 * tipoOtCampoIdioma.put("IdCampo", "NOTASTEC");
			 * tipoOtCampoIdioma.put("IdIdioma", "eu");
			 * tipoOtCampoIdioma.put("DescCampo", "Teknikariaren oharrak");
			 * tipoOtCampoIdioma.put("Agrupador", "General");
			 * tiposOtCampoIdioma.put(tipoOtCampoIdioma);
			 */

			// PREVENTIVO
			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "IDZONAEDIF");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Zona");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "IDZONAEDIF");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Zonaldea");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "IDPLANTA");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Planta");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "IDPLANTA");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Solairua");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "IDCLASE");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Clase");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "IDCLASE");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Klasea");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "IDGAMA");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Gama");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "IDGAMA");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Gama");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "IDMAQUINA");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Maquina");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "IDMAQUINA");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Makina");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "NOTASTEC");
			tipoOtCampoIdioma.put("IdIdioma", "gv");
			tipoOtCampoIdioma.put("DescCampo", "Notas técnico");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			tipoOtCampoIdioma = new JSONObject();
			tipoOtCampoIdioma.put("IdTipo", "2");
			tipoOtCampoIdioma.put("IdCampo", "NOTASTEC");
			tipoOtCampoIdioma.put("IdIdioma", "eu");
			tipoOtCampoIdioma.put("DescCampo", "Teknikariaren oharrak");
			tipoOtCampoIdioma.put("Agrupador", "General");
			tiposOtCampoIdioma.put(tipoOtCampoIdioma);

			requestJSON.put("tipos", tipos);
			requestJSON.put("tiposOtCampo", tiposOtCampo);
			requestJSON.put("tiposOtIdioma", tiposOtIdioma);
			requestJSON.put("tiposOtCampoIdioma", tiposOtCampoIdioma);
		}

		String url = urlConfig + Aa20bConstantes.URL_SUBIR_TIPOS_OT;
		respuesta = this.procesosJMSService.sincronizarGmao(requestJSON, url);

		return respuesta;

	}

	@RequestMapping(value = "/limpiezaActivosGmao", method = RequestMethod.POST)
	public @ResponseBody
	String limpiezaActivosGmao(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger.info("[Gmao - limpiezaActivosGmao] ");
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		JSONObject requestJSON = new JSONObject();
		if (valorJSON != null && !valorJSON.trim().equals("")) {
			requestJSON = new JSONObject(valorJSON);
		} else {
			JSONArray activos = new JSONArray();
			JSONObject activo = new JSONObject();

			activo.put("UUIdActivo", "78kjii78k");
			activos.put(activo);

			requestJSON.put("activos", activos);
		}

		String url = urlConfig
				+ "Expertis_Sync_Movil_JS/index.php/sync/masters/LimpiezaActivos/";
		respuesta = this.procesosJMSService.sincronizarGmao(requestJSON, url);

		return respuesta;

	}

	@RequestMapping(value = "/finalizarPartesPendientes", method = RequestMethod.POST)
	public @ResponseBody
	String finalizarPartesPendientes(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger
				.info("[Gmao - finalizarPartesPendientes] ");
		String respuesta = "";
		if (valorJSON != null && !valorJSON.trim().equals("")) {

		} else {
			Partes parteAux = new Partes();
			parteAux.setEjecutado("0");
			List<Partes> listaPartesPendientes = this.partesService
					.findAllpendientes(parteAux, null);

			for (Partes parte : listaPartesPendientes) {
				List<Partetecnicos> partetecnicosAux = new ArrayList<Partetecnicos>();
				partetecnicosAux = this.partetecnicosService
						.obtenerTecnicosParteAsociados(parte.getIdparte());

				if (partetecnicosAux.size() > 0) {
					// Sumamos a la fecha inicial 2 dias
					java.util.Date fechaEjecMas2 = null;
					java.util.Date fechaInicial = null;
					if (parte.getFechare() != null) {
						fechaInicial = parte.getFechare();
						Calendar calendar = Calendar.getInstance();
						calendar.setTime(fechaInicial);

						calendar.add(Calendar.DAY_OF_YEAR, 2);

						fechaEjecMas2 = calendar.getTime();

					}

					parte.setEjecutado("1");
					parte.setFechaej(fechaEjecMas2);

					parteAux = this.partesService.finalizarParteProceso(parte);
				}
			}
		}

		return respuesta;

	}

	@RequestMapping(value = "/finalizarFichasPendientes", method = RequestMethod.POST)
	public @ResponseBody
	String finalizarFichasPendientes(@RequestParam String valorJSON) {
		ProcesosGmaoController.logger
				.info("[Gmao - finalizarFichasPendientes] ");
		String respuesta = "";
		int contador = 0;
		if (valorJSON != null && !valorJSON.trim().equals("")) {

		} else {
			Ficha fichaAux = new Ficha();
			fichaAux.setEjecutado("0");
			List<Ficha> listaFichasPendientes = this.fichasService
					.findAllpendientes(fichaAux, null);

			for (Ficha ficha : listaFichasPendientes) {

				List<Fichatecnico> fichasTecAux = this.fichatecnicosService
						.obtenerTecnicosFichaAsociados(ficha.getIdficha());
				if (fichasTecAux.size() > 0) {

					Maquinas maquinaAux = new Maquinas();
					maquinaAux.setIdmaquina(ficha.getIdmaquina());
					maquinaAux = this.maquinasService.find(maquinaAux);
					if (maquinaAux != null) {
						if (maquinaAux.getIdedificio() != null
								&& (maquinaAux.getIdedificio().equals("001800")
										|| maquinaAux.getIdedificio().equals(
												"005402")
										&& maquinaAux.getIdedificio().equals(
												"005423")
										|| maquinaAux.getIdedificio().equals(
												"001911") || maquinaAux
										.getIdedificio().equals("001016"))) {
							contador++;
							// Sumamos a la fecha inicial 2 dias
							java.util.Date fechaEjecMas2 = null;
							java.util.Date fechaInicial = null;
							if (ficha.getFeini() != null) {
								fechaInicial = ficha.getFeejec();
								Calendar calendar = Calendar.getInstance();
								calendar.setTime(fechaInicial);

								calendar.add(Calendar.DAY_OF_YEAR, 2);

								fechaEjecMas2 = calendar.getTime();

							}

							ficha.setEjecutado("1");
							ficha.setFeejec(fechaEjecMas2);

							fichaAux = this.fichasService
									.finalizarFichaProceso(ficha);
						}
					}

				}
			}
		}

		return respuesta;

	}

	@RequestMapping(value = "/sincronizarTodasPresencias", method = RequestMethod.POST)
	public @ResponseBody
	String sincronizarTodasPresencias() {

		ProcesosGmaoController.logger
				.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización presencia técnicos - inicio");

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		String respuestaJSON = "";
		String respuesta = "";

		respuestaJSON = this.procesosJMSService.sincronizarGmaoGET(urlConfig
				+ Aa20bConstantes.URL_BAJAR_USUARIOS);

		// Si la respuesta no es nula o blancos traerá el objeto JSON
		if (respuestaJSON != null && !respuestaJSON.equals("")) {
			respuesta = actualizarPresenciaTecnicos(respuestaJSON, urlConfig);
		}

		if (respuesta != null && respuesta.equals("OK")) {
			ProcesosGmaoController.logger
					.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización presencia técnicos - correcta");
		} else {
			ProcesosGmaoController.logger
					.error("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización presencia técnicos - KO");
		}

		ProcesosGmaoController.logger
				.info("[tareaSincronizarTodasOTs] : procesosGmao - Sincronización presencia técnicos - fin");

		return respuesta;
	}

	@RequestMapping(value = "/bajarTodasOTsGmao", method = RequestMethod.POST)
	public @ResponseBody
	String bajarTodasOTsGmao() {
		String respuestaJSON = "";
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}
		respuestaJSON = this.procesosJMSService.sincronizarGmaoGET(urlConfig
				+ Aa20bConstantes.URL_BAJAR_OTS);

		// Si la respuesta no es nula o blancos traerá el objeto JSON
		if (respuestaJSON != null && !respuestaJSON.equals("")) {
			respuesta = actualizarPartes(respuestaJSON, urlConfig);
		}

		return respuesta;
	}

	@RequestMapping(value = "/bajarOTcorrectivaGmao", method = RequestMethod.POST)
	public @ResponseBody
	String bajarOTcorrectivaGmao(String idParte) {
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		/**
		 * Como la presencia ralentiza la carga se comenta. La presencia se
		 * sincroniza automaticamente cada 350 segundos
		 */
		String respuestaPresencia = this.sincronizarTodasPresencias();

		Partetecnicosgmao parteTecnicoGmaoAux = new Partetecnicosgmao();
		parteTecnicoGmaoAux.setIdparte(Integer.valueOf(idParte));
		List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
				.findAll(parteTecnicoGmaoAux, null);

		for (Partetecnicosgmao parteTecnico : parteTecnicosGmao) {
			JSONObject ot = new JSONObject();
			ot.put("UUIdOt", "{" + parteTecnico.getGuidpartetecgmao() + "}");
			String respuestaOT = "";
			respuestaOT = this.procesosJMSService.bajarOtByGUID(ot, urlConfig
					+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

			if (respuestaOT != null
					&& !respuestaOT.equals(Aa20bConstantes.ERROR_500)) {
				respuesta = actualizarPartes(respuestaOT, urlConfig);
			} else {
				ProcesosGmaoController.logger
						.error("[MOVILGMAO] : bajarOTByUUId - error en la conexión con MovilGmao");
			}

		}

		return respuesta;
	}

	@RequestMapping(value = "/bajarOTpreventivaGmao", method = RequestMethod.POST)
	public @ResponseBody
	String bajarOTpreventivaGmao(String idFicha) {
		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}
		/**
		 * Como la presencia ralentiza la carga se comenta. La presencia se
		 * sincroniza automaticamente cada 350 segundos
		 */
		String respuestaPresencia = this.sincronizarTodasPresencias();

		Fichatecnicosgmao fichaTecnicoGmaoAux = new Fichatecnicosgmao();
		fichaTecnicoGmaoAux.setIdficha(Integer.valueOf(idFicha));
		List<Fichatecnicosgmao> fichaTecnicosGmao = this.fichatecnicosgmaoServices
				.findAll(fichaTecnicoGmaoAux, null);

		for (Fichatecnicosgmao fichaTecnico : fichaTecnicosGmao) {
			JSONObject ot = new JSONObject();
			ot.put("UUIdOt", "{" + fichaTecnico.getGuidfichatecgmao() + "}");
			String respuestaOT = "";
			respuestaOT = this.procesosJMSService.bajarOtByGUID(ot, urlConfig
					+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

			if (respuestaOT != null
					&& !respuestaOT.equals(Aa20bConstantes.ERROR_500)) {
				respuesta = actualizarPartes(respuestaOT, urlConfig);
			} else {
				ProcesosGmaoController.logger
						.error("[MOVILGMAO] : bajarOTByUUId - error en la conexión con MovilGmao");
			}

		}

		return respuesta;
	}

	private String actualizarPartes(String respuestaJSON, String urlConfig) {

		String respuesta = "";

		JSONObject resp = new JSONObject(respuestaJSON);

		JSONArray ots = new JSONArray();
		JSONArray otmods = new JSONArray();
		JSONArray revisiones = new JSONArray();
		JSONArray operarios = new JSONArray();
		JSONArray logs = new JSONArray();
		JSONArray campos = new JSONArray();
		ots = resp.getJSONArray("ots");
		otmods = resp.getJSONArray("otmod");
		if (resp.get("revisiones") != JSONObject.NULL) {
			revisiones = resp.getJSONArray("revisiones");
		}
		operarios = resp.getJSONArray("operarios");
		logs = resp.getJSONArray("log");
		campos = resp.getJSONArray("campos");

		if (ots.length() > 0) {
			for (int i = 0; i < ots.length(); i++) {
				JSONObject ot = ots.getJSONObject(i);

				String guidpartehija = ot.get("UUIdOt").toString()
						.toLowerCase();
				String guidpartehijaFormateado = ot.getString("UUIdOt")
						.replace("{", "");
				guidpartehijaFormateado = guidpartehijaFormateado.replace("}",
						"");
				guidpartehijaFormateado = guidpartehijaFormateado.toLowerCase();

				// Distinguir si se trata de un parte correctivo o preventivo
				String tipoParte = "";
				if (ot.get("IdTipo") != JSONObject.NULL) {
					tipoParte = ot.getString("IdTipo");
				}

				if (tipoParte.equals(Aa20bConstantes.TIPO_OT_GMAO_CORRECTIVA)) {
					respuesta = this.tratamientoPartesCorrectivos(ot,
							operarios, otmods, logs, campos,
							guidpartehijaFormateado, urlConfig, guidpartehija);

				} else if (tipoParte
						.equals(Aa20bConstantes.TIPO_OT_GMAO_PREVENTIVA)) {
					respuesta = this.tratamientoPartesPreventivos(ot,
							operarios, otmods, revisiones, logs, campos,
							guidpartehijaFormateado, guidpartehija, urlConfig);
				}

			}
		} else {
			respuesta = "OK";
		}

		return respuesta;
	}

	@RequestMapping(value = "/mostrarFirmaParte", method = RequestMethod.GET)
	public void mostrarPlanoParte(HttpServletRequest req,
			HttpServletResponse res, Model model) throws IOException {

		// init
		byte[] firma = null;
		ServletOutputStream out = res.getOutputStream();
		Partefirma parteplano = new Partefirma();

		// get
		if (req.getParameter("idparte") != null
				&& req.getParameter("idtecnico") != null
				&& req.getParameter("idpartec") != null) {
			Integer idParte = Integer.parseInt(req.getParameter("idparte"));
			Integer idTecnico = Integer.parseInt(req.getParameter("idtecnico"));
			Integer idpartec = Integer.parseInt(req.getParameter("idpartec"));
			parteplano.setIdparte(idParte);
			parteplano.setIdtecnico(idTecnico);
			parteplano.setIdpartec(idpartec);

			ProcesosGmaoController.logger
					.info("[GET - findBy_PK] : Mostrar Plano del parte : "
							+ idParte);

			// set
			res.setContentType("image/png");

			// execute
			firma = this.partefirmaService.buscaFirma(parteplano);

			// blob treatment
			int nBytes = 0;
			if (firma != null) {
				nBytes = firma.length;
				ProcesosGmaoController.logger
						.info("[GET - BUSCA firma] : Tamaño Firma : "
								+ firma.length);
				while (nBytes > 0) {
					out.write(firma, 0, nBytes);
					nBytes = firma.length - nBytes;
				}
			}

			// end
			out.flush();
			out.close();
		}

	}

	@RequestMapping(value = "/mostrarFirmaFicha", method = RequestMethod.GET)
	public void mostrarFirmaFicha(HttpServletRequest req,
			HttpServletResponse res, Model model) throws IOException {

		// init
		byte[] firma = null;
		ServletOutputStream out = res.getOutputStream();
		Fichafirma fichaFirma = new Fichafirma();

		// get
		if (req.getParameter("idficha") != null
				&& req.getParameter("idtecnico") != null
				&& req.getParameter("idfitec") != null) {
			Integer idFicha = Integer.parseInt(req.getParameter("idficha"));
			Integer idTecnico = Integer.parseInt(req.getParameter("idtecnico"));
			Integer idfitec = Integer.parseInt(req.getParameter("idfitec"));
			fichaFirma.setIdficha(idFicha);
			fichaFirma.setIdtecnico(idTecnico);
			fichaFirma.setIdfitec(idfitec);

			ProcesosGmaoController.logger
					.info("[GET - findBy_PK] : Mostrar Firma de la ficha : "
							+ idFicha);

			// set
			res.setContentType("image/png");

			// execute
			firma = this.fichafirmaService.buscaFirma(fichaFirma);

			// blob treatment
			int nBytes = 0;
			if (firma != null) {
				nBytes = firma.length;
				ProcesosGmaoController.logger
						.info("[GET - BUSCA firma] : Tamaño Firma : "
								+ firma.length);
				while (nBytes > 0) {
					out.write(firma, 0, nBytes);
					nBytes = firma.length - nBytes;
				}
			}

			// end
			out.flush();
			out.close();
		}

	}

	@RequestMapping(value = "/enviarNotasRespParte", method = RequestMethod.POST)
	public @ResponseBody
	String modificarNotasParteTecnico(Integer idParte, Long idTecnico,
			String observ) {

		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		Partetecnicosgmao partetecnicosgmaoAux = new Partetecnicosgmao();
		partetecnicosgmaoAux.setIdparte(idParte);
		partetecnicosgmaoAux.setIdtecnico(idTecnico);
		partetecnicosgmaoAux = this.partetecnicosgmaoServices
				.findByIdParte(partetecnicosgmaoAux);

		if (partetecnicosgmaoAux != null) {
			respuesta = this.procesosJMSService.enviarObservacionResponsable(
					partetecnicosgmaoAux.getGuidpartetecgmao(), observ,
					urlConfig);
		}

		return respuesta;
	}

	@RequestMapping(value = "/enviarNotasRespPartePreventivo", method = RequestMethod.POST)
	public @ResponseBody
	String modificarNotasPartePreventivoTecnico(Integer idFicha, String observ) {

		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		Fichatecnicosgmao fichatecnicosgmaoAux = new Fichatecnicosgmao();
		fichatecnicosgmaoAux.setIdficha(idFicha);
		fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
				.findByIdFicha(fichatecnicosgmaoAux);

		if (fichatecnicosgmaoAux != null) {
			respuesta = this.procesosJMSService.enviarObservacionResponsable(
					fichatecnicosgmaoAux.getGuidfichatecgmao(), observ,
					urlConfig);
		}

		return respuesta;
	}

	@RequestMapping(value = "/enviarObservacionesPartePreventivo", method = RequestMethod.POST)
	public @ResponseBody
	String enviarObservacionesPartePreventivo(Integer idFicha, String observ) {

		String respuesta = "";

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		Fichatecnicosgmao fichatecnicosgmaoAux = new Fichatecnicosgmao();
		fichatecnicosgmaoAux.setIdficha(idFicha);
		List<Fichatecnicosgmao> listafichatecnicosgmaoAux = this.fichatecnicosgmaoServices
				.findAll(fichatecnicosgmaoAux, null);

		if (listafichatecnicosgmaoAux != null) {
			for (Fichatecnicosgmao fichatecgmao : listafichatecnicosgmaoAux) {

				respuesta = this.procesosJMSService.enviarObservacionesFicha(
						fichatecgmao.getGuidfichatecgmao(), observ, urlConfig);
			}
		}

		return respuesta;
	}

	/*
	 * @RequestMapping(value = "/OtTienePDF", method = RequestMethod.POST)
	 * public @ResponseBody Boolean parteTieneActuaciones(@RequestParam Integer
	 * idParte,
	 * 
	 * @RequestParam Integer idTecnico, Model model, HttpServletRequest request)
	 * {
	 * 
	 * Partetecnicosgmao partetecnicogmao = new Partetecnicosgmao();
	 * 
	 * ProcesosGmaoController.logger
	 * .info("[POST - OtTienePDF] : Comprobando si la OT tiene PDF. ");
	 * 
	 * if (idParte != null && idTecnico != null) {
	 * partetecnicogmao.setIdparte(idParte);
	 * partetecnicogmao.setIdtecnico(Long.valueOf(idTecnico));
	 * 
	 * Partetecnicosgmao partetecnicosgmaoAux = this.partetecnicosgmaoServices
	 * .find(partetecnicogmao);
	 * 
	 * if (partetecnicosgmaoAux != null) { return true; } else { return false; }
	 * } else { return false; }
	 * 
	 * }
	 */

	/*
	 * @RequestMapping(value = "imprimirPDFot", method = RequestMethod.GET)
	 * public @ResponseBody void imprimirEjecFechaEj(
	 * 
	 * @ModelAttribute Partetecnicosgmao filterParteTecnico, Locale locale,
	 * HttpServletResponse response, HttpServletRequest request) {
	 * 
	 * // Obtenemos el UUId del documento para descargarlo Partetecnicosgmao
	 * partetecnicogmaoAux = new Partetecnicosgmao(); partetecnicogmaoAux =
	 * this.partetecnicosgmaoServices .find(filterParteTecnico);
	 * 
	 * if (partetecnicogmaoAux != null && partetecnicogmaoAux.getGuidpdf() !=
	 * null) { String nombreDoc = "OT752_137_13-07-16_12-24-51.pdf"; String
	 * UUIdDoc = partetecnicogmaoAux.getGuidpdf();
	 * 
	 * String respuesta = this.procesosJMSService .sincronizarGmaoGET(
	 * "http://svc.intra.integracion.jakina.ejiedes.net/ctxapp/aa20bWebServices/SincronizacionFicheros/index.php/sync/sincronizarFicheros/BajarFichero/"
	 * + UUIdDoc + "/" + nombreDoc);
	 * 
	 * System.out.println(respuesta); }
	 * 
	 * }
	 */

	/*
	 * private void asignarParteCorrectivoAutomatico(Partes parteAux,
	 * Partetecnicos partetecnicosAux, String urlConfig) {
	 * 
	 * // Primero buscamos solo técnicos que tengan aplicación MovilGmao
	 * List<Usutecnicos> tecnicosList = this.usuTecnicosService
	 * .obtenerTecnicosUsuServEdificio(parteAux.getIdcodigo(),
	 * parteAux.getIdedificio(), parteAux.getIdzona(), true); ArrayList<Long>
	 * arrayTecnicos = new ArrayList<Long>(); Presencia presencia = new
	 * Presencia(); for (Usutecnicos usuTecnicosAux : tecnicosList) { //
	 * Comprobar que esten presentes // Buscar en la tabla Presencia los //
	 * tecnicos que tengan con // THASTA a 0
	 * presencia.setIdtecnico(usuTecnicosAux.getIdtecnico()); if
	 * (this.presenciaService.comprobarTecnicoEstaPresente(presencia)) { // El
	 * tecnico esta presente // Recoger todos los tecnicos y // luego
	 * seleccionar uno // aleatoriamente
	 * 
	 * // Se comprueba que el técnico // es diferente al que // actualmente //
	 * ha rechazado el parte if (usuTecnicosAux.getIdtecnico().compareTo(
	 * partetecnicosAux.getIdtecnico()) != 0) {
	 * arrayTecnicos.add(usuTecnicosAux.getIdtecnico()); } } } // Si no ha
	 * encontrado ningún técnico con aplicación móvil // se buscará en los demás
	 * que corresponda if (arrayTecnicos.size() == 0) { tecnicosList =
	 * this.usuTecnicosService
	 * .obtenerTecnicosUsuServEdificio(parteAux.getIdcodigo(),
	 * parteAux.getIdedificio(), parteAux.getIdzona(), false); arrayTecnicos =
	 * new ArrayList<Long>(); presencia = new Presencia(); for (Usutecnicos
	 * usuTecnicosAux : tecnicosList) { // Comprobar que esten presentes //
	 * Buscar en la tabla Presencia los // tecnicos que tengan con // THASTA a 0
	 * presencia.setIdtecnico(usuTecnicosAux.getIdtecnico()); if
	 * (this.presenciaService .comprobarTecnicoEstaPresente(presencia)) { // El
	 * tecnico esta presente // Recoger todos los tecnicos y // luego
	 * seleccionar uno // aleatoriamente
	 * 
	 * // Se comprueba que el técnico // es diferente al que // actualmente //
	 * ha rechazado el parte if (usuTecnicosAux.getIdtecnico().compareTo(
	 * partetecnicosAux.getIdtecnico()) != 0) {
	 * arrayTecnicos.add(usuTecnicosAux.getIdtecnico()); } } } }
	 * 
	 * if (arrayTecnicos.size() > 0) { // Se trabaja con el tecnico que ha //
	 * sido elegido // aleatoriamente. int numAleat = (int)
	 * Math.floor(Math.random() (0 - arrayTecnicos.size()) +
	 * arrayTecnicos.size()); Long idTecnicoAleat = arrayTecnicos.get(numAleat);
	 * 
	 * Tecnicos tecnicos = new Tecnicos();
	 * tecnicos.setIdtecnico(idTecnicoAleat); Tecnicos tecnicoAux =
	 * this.tecnicosService.find(tecnicos);
	 * 
	 * // Insertar en la tabla de // ParteTecnicos Partetecnicos parteTecnico =
	 * new Partetecnicos(); parteTecnico.setIdparte(parteAux.getIdparte());
	 * parteTecnico.setIdtecnico(tecnicoAux.getIdtecnico());
	 * parteTecnico.setFinalizado("0"); Partetecnicos parteTecnicoAux =
	 * this.partetecnicosService .add(parteTecnico);
	 * 
	 * /** Victor GMAO Se no tiene email y si no es movilgmao, se deja como
	 * asignacion manual Se comprueba también si tiene gmao además de email
	 * 
	 * // Si no tiene email se deja como // ASIGNACION MANUAL if
	 * (tecnicoAux.getMail() != null || (tecnicoAux.getMovilgmao() != null &&
	 * tecnicoAux .getMovilgmao().equals("1"))) { // Actualizar la tabla Partes
	 * // AUTOMATICA=1 this.partesService.marcarAutomatica(parteAux);
	 * 
	 * if (tecnicoAux.getMail() != null) { // Actualizar la tabla // Partes
	 * ENVIOMAIL=1 this.partesService.marcarEnvioMail(parteAux);
	 * 
	 * // Enviar email try { String retorno =
	 * this.partesService.enviarMailTecnico( parteAux, tecnicoAux); if
	 * ("true".equals(retorno)) { // Si ha ido bien el // envío de mail se //
	 * marca // enviomail =1 en // la tabla // TecnicoPartes
	 * this.partetecnicosService.marcarEnvioMail( parteAux.getIdparte(),
	 * tecnicoAux.getIdtecnico()); } ProcesosGmaoController.logger
	 * .info("[POST] : email enviado" + retorno); // return partesAux; } catch
	 * (Exception e) { // TODO Auto-generated // catch block
	 * e.printStackTrace(); } }
	 * 
	 * /** MOVILGMAO Se comprueba si el tecnico tiene aplicacion movilgmao. Si
	 * la tiene se crea la OT correspondiente
	 * 
	 * 
	 * if (tecnicoAux != null && tecnicoAux.getMovilgmao() != null &&
	 * tecnicoAux.getMovilgmao().equals("1")) {
	 * 
	 * Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
	 * Partetecnicosgmao elTecnicoParteGmao = new Partetecnicosgmao();
	 * 
	 * if (parteAux != null) {
	 * 
	 * elTecnicoParteGmao.setIdparte(parteAux.getIdparte());
	 * elTecnicoParteGmao.setIdtecnico(tecnicoAux .getIdtecnico());
	 * elTecnicoParteGmao.setIdpartec(parteTecnicoAux .getIdpartec()); String
	 * randomUUIDString = ""; UUID uuid = UUID.randomUUID(); randomUUIDString =
	 * uuid.toString(); elTecnicoParteGmao
	 * .setGuidpartetecgmao(randomUUIDString); tecnicoParteGmaoAux =
	 * this.partetecnicosgmaoServices .add(elTecnicoParteGmao);
	 * 
	 * String idEdificio = parteAux.getIdedificio();
	 * 
	 * Edificios edifAux = new Edificios(); edifAux = this.edificiosService
	 * .obtenerEdificio(idEdificio);
	 * 
	 * if (parteAux.getIddepar() != null) { Departamentos departamentoAux = new
	 * Departamentos(); departamentoAux.setIddepar(parteAux.getIddepar());
	 * departamentoAux = this.departamentosService .find(departamentoAux);
	 * parteAux.setDepartamento(departamentoAux); }
	 * 
	 * if (parteAux.getIddir() != null) { Direcciones direccionAux = new
	 * Direcciones(); direccionAux.setIddir(parteAux.getIddir()); direccionAux =
	 * this.direccionesService .find(direccionAux);
	 * parteAux.setDireccion(direccionAux); }
	 * 
	 * if (parteAux.getIdplanta() != null) { Plantas plantaAux = new Plantas();
	 * plantaAux.setIdplanta(parteAux.getIdplanta()); plantaAux =
	 * this.plantasService.find(plantaAux); parteAux.setPlanta(plantaAux); }
	 * 
	 * if (parteAux.getIdzona() != null) { Zonas zonaAux = new Zonas();
	 * zonaAux.setIdzona(parteAux.getIdzona()); zonaAux =
	 * this.zonasService.find(zonaAux); parteAux.setZona(zonaAux);
	 * 
	 * }
	 * 
	 * if (parteAux.getIdespacio() != null) { Espacio espacioAux = new
	 * Espacio(); espacioAux.setIdespacio(parteAux.getIdespacio()); espacioAux =
	 * this.espaciosService.find(espacioAux); parteAux.setEspacio(espacioAux); }
	 * 
	 * // Obtener el plano si // tiene Parteplano planoParte = new Parteplano();
	 * planoParte.setIdparte(parteAux.getIdparte());
	 * 
	 * planoParte = this.parteplanoService.find(planoParte);
	 * 
	 * if (parteAux.getGuidparte() == null) { randomUUIDString = ""; uuid =
	 * UUID.randomUUID(); randomUUIDString = uuid.toString();
	 * parteAux.setGuidparte(randomUUIDString); parteAux = this.partesService
	 * .actualizarUUIDparte(parteAux); }
	 * 
	 * if (planoParte != null) {
	 * 
	 * randomUUIDString = ""; uuid = UUID.randomUUID(); randomUUIDString =
	 * uuid.toString(); elTecnicoParteGmao .setIdparte(parteAux.getIdparte());
	 * elTecnicoParteGmao.setIdtecnico(tecnicoAux .getIdtecnico());
	 * elTecnicoParteGmao.setIdpartec(parteTecnicoAux .getIdpartec());
	 * elTecnicoParteGmao .setGuidplanopartegmao(randomUUIDString);
	 * tecnicoParteGmaoAux = this.partetecnicosgmaoServices
	 * .update(elTecnicoParteGmao); }
	 * 
	 * // Obtener tecnicos // asignados al parte // (partetecnicos)
	 * tecnicoParteGmaoAux = new Partetecnicosgmao();
	 * tecnicoParteGmaoAux.setIdparte(parteAux.getIdparte());
	 * List<Partetecnicosgmao> parteTecnicosGmao =
	 * this.partetecnicosgmaoServices .findAll(tecnicoParteGmaoAux, null);
	 * 
	 * byte[] blobAsBytes = null; try { if (planoParte != null) { // Tiene plano
	 * int blobLeng = (int) planoParte.getDibujo() .length(); blobAsBytes =
	 * planoParte.getDibujo().getBytes( 1, blobLeng); }
	 * 
	 * String respuesta = this.procesosJMSService
	 * .sincronizarParteCorrectivoGmao(parteAux, parteTecnicosGmao,
	 * edifAux.getGuidedificio(), blobAsBytes, urlConfig);
	 * 
	 * if (respuesta != null && respuesta.equals("OK")) {
	 * ProcesosGmaoController.logger
	 * .info("[MOVILGMAO] : sincronizarParteCorrectivo: " + respuesta); } else {
	 * ProcesosGmaoController.logger
	 * .error("[MOVILGMAO] : sincronizarParteCorrectivo: " + respuesta); } }
	 * catch (Exception e) { e.printStackTrace(); }
	 * 
	 * } }
	 * 
	 * /** FIN MOVILGMAO
	 * 
	 * } ProcesosGmaoController.logger .info("[POST] : Tecnicos encontrados: " +
	 * parteTecnicoAux.getIdpartec()); } }
	 */

	/*
	 * private void eliminarTecnicoRechazada(Partes parteAux, Partetecnicos
	 * partetecnicosAux, Partetecnicosgmao partetecnicosgmaoAux, String
	 * urlConfig) {
	 * 
	 * ProcesosGmaoController.logger
	 * .info("[GET - findBy_PK] : Eliminando tecnico en el parte : " +
	 * partetecnicosAux.getIdtecnico());
	 * 
	 * this.partetecnicosService.eliminaTecnicoParte(partetecnicosAux);
	 * 
	 * Partetecnicosgmao elTecnicoParteGmao = new Partetecnicosgmao();
	 * elTecnicoParteGmao.setIdparte(parteAux.getIdparte());
	 * elTecnicoParteGmao.setGuidpartetecgmao(partetecnicosgmaoAux
	 * .getGuidpartetecgmao());
	 * elTecnicoParteGmao.setIdtecnico(partetecnicosgmaoAux.getIdtecnico());
	 * elTecnicoParteGmao.setIdpartec(null); partetecnicosgmaoAux =
	 * this.partetecnicosgmaoServices .update(elTecnicoParteGmao);
	 * 
	 * List<Partetecnicosgmao> parteTecnicosEliminar = new
	 * ArrayList<Partetecnicosgmao>();
	 * parteTecnicosEliminar.add(partetecnicosgmaoAux);
	 * 
	 * if (parteAux != null) { String idEdificio = parteAux.getIdedificio();
	 * 
	 * Edificios edifAux = new Edificios(); edifAux =
	 * this.edificiosService.obtenerEdificio(idEdificio);
	 * 
	 * if (parteAux.getIddepar() != null) { Departamentos departamentoAux = new
	 * Departamentos(); departamentoAux.setIddepar(parteAux.getIddepar());
	 * departamentoAux = this.departamentosService .find(departamentoAux);
	 * parteAux.setDepartamento(departamentoAux); }
	 * 
	 * if (parteAux.getIddir() != null) { Direcciones direccionAux = new
	 * Direcciones(); direccionAux.setIddir(parteAux.getIddir()); direccionAux =
	 * this.direccionesService.find(direccionAux);
	 * parteAux.setDireccion(direccionAux); }
	 * 
	 * if (parteAux.getIdplanta() != null) { Plantas plantaAux = new Plantas();
	 * plantaAux.setIdplanta(parteAux.getIdplanta()); plantaAux =
	 * this.plantasService.find(plantaAux); parteAux.setPlanta(plantaAux); }
	 * 
	 * if (parteAux.getIdzona() != null) { Zonas zonaAux = new Zonas();
	 * zonaAux.setIdzona(parteAux.getIdzona()); zonaAux =
	 * this.zonasService.find(zonaAux); parteAux.setZona(zonaAux);
	 * 
	 * }
	 * 
	 * if (parteAux.getIdespacio() != null) { Espacio espacioAux = new
	 * Espacio(); espacioAux.setIdespacio(parteAux.getIdespacio()); espacioAux =
	 * this.espaciosService.find(espacioAux); parteAux.setEspacio(espacioAux); }
	 * 
	 * // Obtener el plano si tiene Parteplano planoParte = new Parteplano();
	 * planoParte.setIdparte(parteAux.getIdparte());
	 * 
	 * planoParte = this.parteplanoService.find(planoParte);
	 * 
	 * // Obtener tecnicos asignados al parte // (partetecnicos)
	 * Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
	 * tecnicoParteGmaoAux.setIdparte(parteAux.getIdparte());
	 * List<Partetecnicosgmao> parteTecnicosGmao =
	 * this.partetecnicosgmaoServices .findAll(tecnicoParteGmaoAux, null);
	 * 
	 * byte[] blobAsBytes = null; try { if (planoParte != null) { // Tiene plano
	 * int blobLeng = (int) planoParte.getDibujo().length(); blobAsBytes =
	 * planoParte.getDibujo().getBytes(1, blobLeng); }
	 * 
	 * String respuesta = this.procesosJMSService
	 * .sincronizarParteCorrectivoGmao(parteAux, parteTecnicosGmao,
	 * edifAux.getGuidedificio(), blobAsBytes, urlConfig);
	 * 
	 * if (respuesta != null && respuesta.equals("OK")) {
	 * ProcesosGmaoController.logger
	 * .info("[MOVILGMAO] : sincronizarParteCorrectivo: " + respuesta);
	 * 
	 * for (Partetecnicosgmao parteGmaoEliminar : parteTecnicosEliminar) {
	 * this.partetecnicosgmaoServices .remove(parteGmaoEliminar); }
	 * 
	 * // Comprobamos si el parte sigue teniendo técnicos con // gmao // Si ya
	 * no tiene, eliminamos la OT de movilgmao parteTecnicosGmao =
	 * this.partetecnicosgmaoServices.findAll( tecnicoParteGmaoAux, null);
	 * 
	 * if (parteTecnicosGmao.size() == 0) {
	 * this.procesosJMSService.eliminarOTpadre( parteAux.getGuidparte(),
	 * urlConfig); }
	 * 
	 * } else { ProcesosGmaoController.logger
	 * .error("[MOVILGMAO] : sincronizarParteCorrectivo: " + respuesta); }
	 * 
	 * } catch (Exception e) { e.printStackTrace(); }
	 * 
	 * }
	 * 
	 * }
	 */

	private boolean crearParteCorrectivoNuevoDesdeMovilGmao(
			String guidpartehijaFormateado, String urlConfig, JSONObject ot) {

		boolean parteNuevoBienCreado = true;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		// Si el parte es nuevo debemos crearlo en nuestra
		// aplicación
		Partes parteNuevo = new Partes();
		JSONObject otNueva = new JSONObject();
		otNueva.put("UUIdOt", "{" + guidpartehijaFormateado + "}");

		String idTecnicoParteNuevo = "";
		if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
			idTecnicoParteNuevo = ot.getString("IdOperarioResponsable");
		}

		boolean tieneTecnico = false;
		if (idTecnicoParteNuevo != null && !idTecnicoParteNuevo.equals("")) {
			tieneTecnico = true;
		}

		// Nos bajamos todos los datos del nuevo parte
		// desde
		// MovilGMAO
		String respuestaOTnueva = "";
		respuestaOTnueva = this.procesosJMSService.bajarOtByGUID(otNueva,
				urlConfig + Aa20bConstantes.URL_BAJAR_OTS_GUID);

		// Procesamos el JSON que nos hemos bajado con
		// los
		// campos
		JSONObject respNuevaOT = new JSONObject(respuestaOTnueva);
		JSONArray camposNuevaOT = new JSONArray();
		camposNuevaOT = respNuevaOT.getJSONArray("campos");
		String observacionesTecnico = "";
		for (int z = 0; z < camposNuevaOT.length(); z++) {
			JSONObject campo = camposNuevaOT.getJSONObject(z);
			String nombreCampo = "";
			nombreCampo = campo.getString("IdCampo");
			if (nombreCampo.equals("DEPAR")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					try {
						Integer.parseInt(campo.getString("Valor"));
						parteNuevo.setIddepar(Long.valueOf(campo
								.getString("Valor")));
					} catch (NumberFormatException nfe) {
						parteNuevo.setIddepar(null);
					}

				}
			} else if (nombreCampo.equals("DIR")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					try {
						Integer.parseInt(campo.getString("Valor"));
						parteNuevo.setIddir(Integer.valueOf(campo
								.getString("Valor")));
					} catch (NumberFormatException nfe) {
						parteNuevo.setIddir(null);
					}

				}
			} else if (nombreCampo.equals("IDPLANTA")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					String plantaSinFormatear = campo.getString("Valor");
					String zona = plantaSinFormatear
							.substring(plantaSinFormatear.indexOf("_") + 1);
					zona = zona.substring(0, zona.indexOf("_"));
					String planta = plantaSinFormatear
							.substring(plantaSinFormatear.indexOf("_") + 1);
					planta = planta.substring(planta.indexOf("_") + 1);
					parteNuevo.setIdzona(Integer.valueOf(zona));
					parteNuevo.setIdplanta(Integer.valueOf(planta));
				} else {
					parteNuevo.setIdzona(Aa20bConstantes.SIN_ZONAS);
					parteNuevo.setIdplanta(Aa20bConstantes.SIN_PLANTAS);
				}
			} else if (nombreCampo.equals("IDCLASE")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setIdclase(Integer.valueOf(campo
							.getString("Valor")));
				}
			} else if (nombreCampo.equals("IDCODIGO")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setIdcodigo(Integer.valueOf(campo
							.getString("Valor")));
				}
			} else if (nombreCampo.equals("IDESTANCIA")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setIdespacio(Long.valueOf(campo
							.getString("Valor")));
				}
			} else if (nombreCampo.equals("MAIL")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setMail(campo.getString("Valor"));
				}
			} else if (nombreCampo.equals("NOMBRE")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setNombre(campo.getString("Valor"));
				}
			} else if (nombreCampo.equals("TELEFONO")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					parteNuevo.setTelefo(campo.getString("Valor"));
				}
			} else if (nombreCampo.equals("NOTASTEC")) {
				if (campo.get("Valor") != JSONObject.NULL) {
					observacionesTecnico = campo.getString("Valor");
				}
			}
		}
		if (ot.get("DescLarga") != JSONObject.NULL) {
			parteNuevo.setObserv(ot.getString("DescLarga"));
		} else {
			if (ot.get("DescCorta") != JSONObject.NULL) {
				parteNuevo.setObserv(ot.getString("DescCorta"));
			}
		}
		String observacionesInternas = "";
		if (ot.get("ObsInternas") != JSONObject.NULL) {
			observacionesInternas = ot.getString("ObsInternas");
		}

		boolean crearParteNuevo = true;
		boolean otnuevacorrecta = true;
		/**
		 * Si viene con el campo de ot de seguimiento significa que quiere
		 * traspasar el parte a otro técnico y que se quede guardado su trabajo.
		 */
		Integer parteBusqueda = 0;
		String partePadreGuid = "";
		String parteSeguidoGuid = "";
		String otTraspaso = "";
		String otAyuda = "";
		Parteplano planoParte = new Parteplano();
		Partepdf pdfParte = new Partepdf();
		if (ot.get("UUIdOtSeguida") != JSONObject.NULL) {
			crearParteNuevo = false;
			otTraspaso = ot.getString("UUIdOtSeguida").replace("{", "");
			otTraspaso = otTraspaso.replace("}", "");
			Partetecnicosgmao partetecpadregmaoAux = new Partetecnicosgmao();
			partetecpadregmaoAux.setGuidpartetecgmao(otTraspaso.toLowerCase());
			partetecpadregmaoAux = this.partetecnicosgmaoServices
					.findByGUID(partetecpadregmaoAux);

			if (partetecpadregmaoAux != null) {
				/**
				 * El parte existe en nuestro sistema. Debemos crear un parte
				 * nuevo en movil gmao asignandoselo al nuevo técnico para
				 * después finalizar el parte anterior que se quiere traspasar.
				 * En nuestra aplicación se asignará al mismo parte.
				 */
				parteBusqueda = partetecpadregmaoAux.getIdparte();
				parteSeguidoGuid = partetecpadregmaoAux.getGuidpartetecgmao();
				String tecnicoNuevo = "";
				if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
					tecnicoNuevo = ot.getString("IdOperarioResponsable");
					// Si ha elegido un técnico diferente a el
					if (!tecnicoNuevo.equals(partetecpadregmaoAux
							.getIdtecnico())) {

						/**
						 * Se comprueba el estado actual del parte para marcarlo
						 * como finalizado en movilgmao
						 */
						if (partetecpadregmaoAux.getEstadoGmao() == null
								|| (partetecpadregmaoAux.getEstadoGmao() != null && partetecpadregmaoAux
										.getFechaEstadoGmao() != null)) {
							if (partetecpadregmaoAux.getEstadoGmao() == null
									|| (partetecpadregmaoAux.getEstadoGmao() != null && !partetecpadregmaoAux
											.getEstadoGmao()
											.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO))) {

								// Obtener el plano si tiene
								planoParte.setIdparte(partetecpadregmaoAux
										.getIdparte());
								planoParte = this.parteplanoService
										.find(planoParte);

								pdfParte.setIdparte(partetecpadregmaoAux
										.getIdparte());
								pdfParte = this.partepdfService.find(pdfParte);

								String respuestaCambioEstado = this.procesosJMSService
										.subirOTcambioEstado(
												partetecpadregmaoAux
														.getGuidpartetecgmao(),
												Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO,
												urlConfig);

								/**
								 * Quitamos el tecnico de la OT (como hace
								 * movilgmao al finalizar)
								 */
								if (respuestaCambioEstado.equals("OK")) {
									this.procesosJMSService
											.subirOTcambioTecnico(
													partetecpadregmaoAux
															.getGuidpartetecgmao(),
													null, urlConfig);
								}
							}
						}
					} else {
						// Si se ha elegido a el como técnico no creamos el
						// parte
						otnuevacorrecta = false;
					}
				}
			}

		} else if (ot.get("UUIdOtPadre") != JSONObject.NULL) {
			/**
			 * Si viene con el campo de ot hija significa que quiere ayuda para
			 * el parte. Se deberá crear un parte nuevo hijo y asignarselo al
			 * técnico nuevo, manteniendo el parte anterior igual
			 */
			crearParteNuevo = false;
			otAyuda = ot.getString("UUIdOtPadre").replace("{", "");
			otAyuda = otAyuda.replace("}", "");
			Partetecnicosgmao partetecpadregmaoAux = new Partetecnicosgmao();
			partetecpadregmaoAux.setGuidpartetecgmao(otAyuda.toLowerCase());
			partetecpadregmaoAux = this.partetecnicosgmaoServices
					.findByGUID(partetecpadregmaoAux);
			if (partetecpadregmaoAux != null) {
				partePadreGuid = partetecpadregmaoAux.getGuidpartetecgmao();
				parteBusqueda = partetecpadregmaoAux.getIdparte();
				String tecnicoNuevo = "";
				if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
					tecnicoNuevo = ot.getString("IdOperarioResponsable");
					// Si se ha elegido a el como técnico no creamos el parte
					if (tecnicoNuevo
							.equals(partetecpadregmaoAux.getIdtecnico())) {
						otnuevacorrecta = false;
					}
				}
				/**
				 * Comprobamos si el parte al que hace referencia el nuevo tiene
				 * plano. Si lo tiene, creamos una copia del mismo para este
				 * nuevo parte
				 */
				// Obtener el plano si tiene
				planoParte.setIdparte(partetecpadregmaoAux.getIdparte());
				planoParte = this.parteplanoService.find(planoParte);

				pdfParte.setIdparte(partetecpadregmaoAux.getIdparte());
				pdfParte = this.partepdfService.find(pdfParte);
				/*
				 * byte[] blobAsBytes = null; if (planoParte != null) { try { //
				 * Tiene plano int blobLeng = (int)
				 * planoParte.getDibujo().length(); blobAsBytes =
				 * planoParte.getDibujo().getBytes(1, blobLeng); } catch
				 * (Exception e) { e.printStackTrace(); }
				 * parteNuevo.setPlanoMarca(blobAsBytes); }
				 */
			}
		}
		Partes parteNuevoAux = new Partes();
		String guidedificioFormateado = ot.getString("UUIdactivo").replace("{",
				"");
		guidedificioFormateado = guidedificioFormateado.replace("}", "");
		if (crearParteNuevo) {

			// Id edificio
			Edificios edificioAux = new Edificios();
			edificioAux.setGuidedificio(guidedificioFormateado.toLowerCase());
			edificioAux = this.edificiosService.findByGUID(edificioAux);

			if (edificioAux != null) {
				parteNuevo.setIdedificio(edificioAux.getIdedificio());
			}

			// Fecha
			String fechaParteNuevo = "";
			if (ot.get("FechaPlanificacion") != JSONObject.NULL) {
				fechaParteNuevo = ot.getString("FechaPlanificacion");
			}
			Date fechaPlanifParteNuevo = null;

			try {
				fechaPlanifParteNuevo = sdf.parse(fechaParteNuevo);

			} catch (ParseException e) {
				ProcesosGmaoController.logger
						.error("[MOVILGMAO] : bajarOTs - formatear fecha planif parte nuevo: "
								+ e.getMessage());
			}
			parteNuevo.setFechare(fechaPlanifParteNuevo);
			parteNuevo.setFechaplanif(fechaPlanifParteNuevo);

			// Prioridad
			String prioridad = "";
			if (ot.get("IdPrioridad") != JSONObject.NULL) {
				prioridad = ot.getString("IdPrioridad");
			}
			parteNuevo.setUrgente(prioridad);

			// Al crear el parte en nuestra aplicación
			// le asignamos un UUID nuevo ya que el UUID de MovilGmao irá
			// asociado
			// en
			// la tabla de partes gmao de nuestra aplicación
			String randomUUIDString = "";
			UUID uuid = UUID.randomUUID();
			randomUUIDString = uuid.toString();
			parteNuevo.setGuidparte(randomUUIDString);

			parteNuevoAux = this.partesService.add(parteNuevo);
		} else {
			Partes parteBusAux = new Partes();
			parteBusAux.setIdparte(parteBusqueda);
			parteNuevoAux = this.partesService.find(parteBusAux);
		}
		if (parteNuevoAux != null && otnuevacorrecta) {
			/**
			 * Si en el parte nuevo no viene información del técnico asociado
			 * significa que quiere cambiar de técnico
			 */
			Partetecnicosgmao elTecnicoParteGmao = new Partetecnicosgmao();
			Partetecnicosgmao parteNuevoTecnicoGmaoAux = new Partetecnicosgmao();
			if (idTecnicoParteNuevo != null && !idTecnicoParteNuevo.equals("")) {
				Partetecnicos parteTecnico = new Partetecnicos();
				parteTecnico.setIdparte(parteNuevoAux.getIdparte());
				parteTecnico.setIdtecnico(Long.valueOf(idTecnicoParteNuevo));
				parteTecnico.setFinalizado("0");
				if (ot.get("IdPrioridad") != JSONObject.NULL
						&& ot.getString("IdPrioridad").equals("1")) {
					parteTecnico.setAceptada("0");
				} else {
					parteTecnico.setAceptada("1");
				}

				if (!observacionesTecnico.trim().equals("")) {
					parteTecnico.setNotasTec(observacionesTecnico);
				}

				Partetecnicos parteTecnicoAux = this.partetecnicosService
						.add(parteTecnico);

				elTecnicoParteGmao.setIdparte(parteNuevoAux.getIdparte());
				elTecnicoParteGmao.setIdtecnico(Long
						.valueOf(idTecnicoParteNuevo));
				elTecnicoParteGmao.setIdpartec(parteTecnicoAux.getIdpartec());
				elTecnicoParteGmao.setGuidpartetecgmao(guidpartehijaFormateado);
				if (!partePadreGuid.equals("")) {
					elTecnicoParteGmao.setGuidpartepadreayuda(partePadreGuid);
				}
				if (!parteSeguidoGuid.equals("")) {
					elTecnicoParteGmao.setGuidparteseguido(parteSeguidoGuid);
				}
				if (planoParte != null) {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					elTecnicoParteGmao.setGuidplanopartegmao(randomUUIDString);
				}

				if (pdfParte != null) {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					elTecnicoParteGmao.setGuidpdfpartegmao(randomUUIDString);
				}

				parteNuevoTecnicoGmaoAux = this.partetecnicosgmaoServices
						.add(elTecnicoParteGmao);

			} else {

				/**
				 * No tiene técnico, habrá que buscar uno si es automático Se
				 * crea el registro en la tabla de partes gmao sin incluir ni el
				 * técnico ni el código del parte técnico
				 */

				elTecnicoParteGmao.setIdparte(parteNuevoAux.getIdparte());
				elTecnicoParteGmao.setIdtecnico(null);
				elTecnicoParteGmao.setIdpartec(null);
				elTecnicoParteGmao.setGuidpartetecgmao(guidpartehijaFormateado);

				if (planoParte != null) {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					elTecnicoParteGmao.setGuidplanopartegmao(randomUUIDString);
				}

				if (pdfParte != null) {
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					elTecnicoParteGmao.setGuidpdfpartegmao(randomUUIDString);
				}

				parteNuevoTecnicoGmaoAux = this.partetecnicosgmaoServices
						.add(elTecnicoParteGmao);
			}
			Tecnicos tecnicoAux = new Tecnicos();
			if (tieneTecnico) {
				tecnicoAux.setIdtecnico(Long.valueOf(idTecnicoParteNuevo));
				tecnicoAux = this.tecnicosService.find(tecnicoAux);
			} else {
				/**
				 * No tiene técnico, buscaremos uno si es automático
				 */

				Codigo codigo = new Codigo();
				codigo.setIdcodigo(parteNuevoAux.getIdcodigo());
				codigo = this.codigosService.find(codigo);
				if (codigo != null && codigo.getRecibeinci() != null
						&& codigo.getRecibeinci().equals("1")) {
					if (codigo != null && codigo.getContrata() != null
							&& codigo.getContrata().equals("1")) {

						// Obtener los tecnicos de contratas cuya clase y
						// edificio
						// coincidan con los del parte
						List<Tecnicos> tecnicosContrataList = this.tecnicosService
								.obtenerTecnicosClaseContrataEdificio(
										codigo.getIdclase(),
										codigo.getIdservicio(),
										codigo.getIdcodigo(),
										parteNuevoAux.getIdedificio(),
										parteNuevoAux.getIdzona());

						if (tecnicosContrataList.size() > 0) {
							// Hay tecnicos asociados al edificio y clase
							// se asigna automáticamente el parte.
							for (Tecnicos tecnicoContrataAux : tecnicosContrataList) {

								// Insertar en la tabla de ParteTecnicos
								Partetecnicos parteTecnico = new Partetecnicos();
								parteTecnico.setIdparte(parteNuevoAux
										.getIdparte());
								parteTecnico.setIdtecnico(tecnicoContrataAux
										.getIdtecnico());
								parteTecnico.setFinalizado("0");

								if (!observacionesInternas.trim().equals("")) {
									parteTecnico
											.setObservaciones(observacionesInternas);
								}

								Partetecnicos parteTecnicoAux = this.partetecnicosService
										.add(parteTecnico);

								if (tecnicoContrataAux.getMovilgmao() != null
										&& tecnicoContrataAux.getMovilgmao()
												.equals("1")) {

									this.partesService
											.marcarAutomatica(parteNuevoAux);
									/**
									 * MOVILGMAO Se comprueba si el tecnico
									 * tiene aplicacion movilgmao. Si la tiene
									 * se crea la OT correspondiente
									 * 
									 */
									if (tecnicoContrataAux != null
											&& tecnicoContrataAux
													.getMovilgmao() != null
											&& tecnicoContrataAux
													.getMovilgmao().equals("1")) {
										if (parteNuevoAux != null) {
											Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
											elTecnicoParteGmao
													.setIdparte(parteNuevoAux
															.getIdparte());
											elTecnicoParteGmao
													.setIdtecnico(tecnicoAux
															.getIdtecnico());
											elTecnicoParteGmao
													.setIdpartec(parteTecnicoAux
															.getIdpartec());
											String randomUUIDString = "";
											UUID uuid = UUID.randomUUID();
											randomUUIDString = uuid.toString();
											elTecnicoParteGmao
													.setGuidpartetecgmao(randomUUIDString);
											tecnicoParteGmaoAux = this.partetecnicosgmaoServices
													.add(elTecnicoParteGmao);
										}
									}

									/**
									 * FIN MOVILGMAO
									 */
								} else if (tecnicoContrataAux.getMail() != null) {
									// Si no tiene email se deja como ASIGNACION
									// MANUAL

									// Actualizar la tabla Partes AUTOMATICA=1
									this.partesService
											.marcarAutomatica(parteNuevoAux);

									// Actualizar la tabla Partes
									// ENVIOMAIL=1
									this.partesService
											.marcarEnvioMail(parteNuevoAux);

									// Enviar email
									try {
										String retorno = this.partesService
												.enviarMailTecnico(
														parteNuevoAux,
														tecnicoContrataAux);
										if ("true".equals(retorno)) {
											// Si ha ido bien el envío de
											// mail se
											// marca
											// enviomail =1 en la tabla
											// TecnicoPartes
											this.partetecnicosService
													.marcarEnvioMail(
															parteNuevoAux
																	.getIdparte(),
															tecnicoContrataAux
																	.getIdtecnico());
										}
										ProcesosGmaoController.logger
												.info("[POST] : email enviado"
														+ retorno);
										// return partesAux;
									} catch (Exception e) {
										// TODO Auto-generated catch block
										e.printStackTrace();
									}

								}

								ProcesosGmaoController.logger
										.info("[POST] : Tecnicos encontrados: "
												+ parteTecnicoAux.getIdpartec());
							}

						}

					} else {
						List<Usutecnicos> tecnicosList = this.usuTecnicosService
								.obtenerTecnicosUsuServEdificio(
										codigo.getIdcodigo(),
										parteNuevoAux.getIdedificio(),
										parteNuevoAux.getIdzona(), false);
						ArrayList<Long> arrayTecnicos = new ArrayList<Long>();
						Presencia presencia = new Presencia();
						for (Usutecnicos usuTecnicosAux : tecnicosList) {
							// Comprobar que esten presentes
							// Buscar en la tabla Presencia los tecnicos que
							// tengan con
							// THASTA a 0

							presencia.setIdtecnico(usuTecnicosAux
									.getIdtecnico());
							if (this.presenciaService
									.comprobarTecnicoEstaPresente(presencia)) {
								// El tecnico esta presente
								// Recoger todos los tecnicos y luego
								// seleccionar uno
								// aleatoriamente
								arrayTecnicos
										.add(usuTecnicosAux.getIdtecnico());
							}

							if (arrayTecnicos.size() > 0) {
								// Se trabaja con el tecnico que ha sido
								// elegido
								// aleatoriamente.
								int numAleat = (int) Math.floor(Math.random()
										* (0 - arrayTecnicos.size())
										+ arrayTecnicos.size());
								Long idTecnicoAleat = arrayTecnicos
										.get(numAleat);

								Tecnicos tecnicos = new Tecnicos();
								tecnicos.setIdtecnico(idTecnicoAleat);
								tecnicoAux = this.tecnicosService
										.find(tecnicos);

								// Insertar en la tabla de ParteTecnicos
								Partetecnicos parteTecnico = new Partetecnicos();
								parteTecnico.setIdparte(parteNuevoAux
										.getIdparte());
								parteTecnico.setIdtecnico(tecnicoAux
										.getIdtecnico());
								parteTecnico.setFinalizado("0");
								if (parteNuevoAux != null
										&& parteNuevoAux.getUrgente() != null
										&& parteNuevoAux.getUrgente().equals(
												"1")) {
									parteTecnico.setAceptada(null);
								} else {
									parteTecnico.setAceptada("1");
								}
								if (!observacionesInternas.trim().equals("")) {
									parteTecnico
											.setObservaciones(observacionesInternas);
								}

								Partetecnicos parteTecnicoAux = this.partetecnicosService
										.add(parteTecnico);

								// Si no tiene email se deja como ASIGNACION
								// MANUAL

								/**
								 * Si ha encontrado un técnico, y tiene
								 * aplicación de móvil guardamos el registro en
								 * la tabla de partes gmao para que al mandar el
								 * parte se lo asigne correctamente. Si es un
								 * técnico sin móvil o no ha encontrado ninguno,
								 * se creará el parte en gmao sin técnico
								 * asignado
								 */
								if (tecnicoAux != null
										&& tecnicoAux.getMovilgmao() != null
										&& tecnicoAux.getMovilgmao()
												.equals("1")) {
									this.partesService
											.marcarAutomatica(parteNuevoAux);
									Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
									Partetecnicosgmao elTecnicoParteGmaoNuevo = new Partetecnicosgmao();
									if (parteTecnicoAux != null) {
										elTecnicoParteGmaoNuevo
												.setIdparte(parteNuevoAux
														.getIdparte());
										elTecnicoParteGmaoNuevo
												.setIdtecnico(tecnicoAux
														.getIdtecnico());
										elTecnicoParteGmaoNuevo
												.setIdpartec(parteTecnicoAux
														.getIdpartec());
										String randomUUIDString = "";
										UUID uuid = UUID.randomUUID();
										randomUUIDString = uuid.toString();
										elTecnicoParteGmao
												.setGuidpartetecgmao(randomUUIDString);
										tecnicoParteGmaoAux = this.partetecnicosgmaoServices
												.add(elTecnicoParteGmaoNuevo);
									}
								} else if (tecnicoAux.getMail() != null) {

									// Actualizar la tabla Partes
									// AUTOMATICA=1
									this.partesService
											.marcarAutomatica(parteNuevoAux);

									// Actualizar la tabla Partes
									// ENVIOMAIL=1
									this.partesService
											.marcarEnvioMail(parteNuevoAux);

									// Enviar email
									try {
										String retorno = this.partesService
												.enviarMailTecnico(
														parteNuevoAux,
														tecnicoAux);
										if ("true".equals(retorno)) {
											// Si ha ido bien el envío
											// de mail se marca
											// enviomail =1 en la tabla
											// TecnicoPartes
											this.partetecnicosService
													.marcarEnvioMail(
															parteNuevoAux
																	.getIdparte(),
															tecnicoAux
																	.getIdtecnico());
										}
										ProcesosGmaoController.logger
												.info("[POST] : email enviado"
														+ retorno);
										// return partesAux;
									} catch (Exception e) {
										// TODO Auto-generated catch
										// block
										e.printStackTrace();
									}
								}
							}
						}
					}
				}
			}
			if (parteNuevoAux != null) {

				// Obtener tecnicos asignados al parte
				// (partetecnicos)
				parteNuevoTecnicoGmaoAux = new Partetecnicosgmao();
				parteNuevoTecnicoGmaoAux.setIdparte(parteNuevoAux.getIdparte());
				List<Partetecnicosgmao> parteNuevoTecnicosGmao = this.partetecnicosgmaoServices
						.findAll(parteNuevoTecnicoGmaoAux, null);

				if (parteNuevoAux.getIddepar() != null) {
					Departamentos departamentoAux = new Departamentos();
					departamentoAux.setIddepar(parteNuevoAux.getIddepar());
					departamentoAux = this.departamentosService
							.find(departamentoAux);
					parteNuevoAux.setDepartamento(departamentoAux);
				}

				if (parteNuevoAux.getIddir() != null) {
					Direcciones direccionAux = new Direcciones();
					direccionAux.setIddir(parteNuevoAux.getIddir());
					direccionAux = this.direccionesService.find(direccionAux);
					parteNuevoAux.setDireccion(direccionAux);
				}

				if (parteNuevoAux.getIdplanta() != null) {
					Plantas plantaAux = new Plantas();
					plantaAux.setIdplanta(parteNuevoAux.getIdplanta());
					plantaAux = this.plantasService.find(plantaAux);
					parteNuevoAux.setPlanta(plantaAux);
				}

				if (parteNuevoAux.getIdzona() != null) {
					Zonas zonaAux = new Zonas();
					zonaAux.setIdzona(parteNuevoAux.getIdzona());
					zonaAux = this.zonasService.find(zonaAux);
					parteNuevoAux.setZona(zonaAux);

				}

				if (parteNuevoAux.getIdespacio() != null) {
					Espacio espacioAux = new Espacio();
					espacioAux.setIdespacio(parteNuevoAux.getIdespacio());
					espacioAux = this.espaciosService.find(espacioAux);
					parteNuevoAux.setEspacio(espacioAux);
				}

				byte[] blobAsBytes = null;
				try {
					if (planoParte != null && planoParte.getDibujo() != null) {
						// Tiene plano
						int blobLeng = (int) planoParte.getDibujo().length();
						blobAsBytes = planoParte.getDibujo().getBytes(1,
								blobLeng);
					}
				} catch (Exception e) {
					e.printStackTrace();
				}

				byte[] blobAsBytesPDF = null;

				try {
					if (pdfParte != null && pdfParte.getPdf() != null) {
						// Tiene plano
						int blobLeng = (int) pdfParte.getPdf().length();
						blobAsBytesPDF = pdfParte.getPdf()
								.getBytes(1, blobLeng);
					}
				} catch (Exception e) {
					e.printStackTrace();
				}

				/**
				 * Se sincronizará con Gmao para crear el parte actualizar los
				 * datos del parte creado con el móvil, añadiendo el numero de
				 * OT con el formato correcto
				 */

				String respuesta = this.procesosJMSService
						.sincronizarParteCorrectivoGmao(parteNuevoAux,
								parteNuevoTecnicosGmao,
								guidedificioFormateado.toLowerCase(),
								blobAsBytes, blobAsBytesPDF, urlConfig);

				/**
				 * Se sincroniza la OT nueva para confirmarla
				 */
				String fechaSinc = "";
				if (ot.get("FechaSinc") != JSONObject.NULL) {
					fechaSinc = ot.getString("FechaSinc");
				}
				JSONObject pdteSincOtOK = new JSONObject();
				JSONArray valoresOTbajada = new JSONArray();
				JSONObject valorBajada = new JSONObject();
				valorBajada.put("UUIdOt", guidpartehijaFormateado);
				valorBajada.put("FechaUltimaSinc", fechaSinc);
				valoresOTbajada.put(valorBajada);
				pdteSincOtOK.put("ots", valoresOTbajada);
				respuesta = this.procesosJMSService.sincronizarGmao(
						pdteSincOtOK, urlConfig
								+ Aa20bConstantes.URL_MARCAR_SINC_OK);

				/**
				 * Después de confirmarla se sube la información con la
				 * asignación del operario a MovilGmao
				 */
				respuesta = this.procesosJMSService
						.sincronizarParteCorrectivoGmao(parteNuevoAux,
								parteNuevoTecnicosGmao,
								guidedificioFormateado.toLowerCase(), null,
								null, urlConfig);

				if (respuesta.equals("OK")) {
					parteNuevoBienCreado = true;
				} else {
					parteNuevoBienCreado = false;
				}

			}
		} else {
			parteNuevoBienCreado = false;
		}

		return parteNuevoBienCreado;

	}

	private String actualizarPresenciaTecnicos(String strJson, String urlConfig) {
		String respuesta = "OK";

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		try {
			JSONArray datosUsuarios = new JSONArray(strJson);
			if (datosUsuarios.length() > 0) {
				for (int i = 0; i < datosUsuarios.length(); i++) {

					Tecnicos tecnicoAux = new Tecnicos();

					JSONObject usuario = datosUsuarios.getJSONObject(i);

					String rol = "";
					if (usuario.get("IDRol") != JSONObject.NULL) {
						rol = usuario.getString("IDRol");
					}

					/**
					 * Los roles de cambio de idioma no los procesamos
					 */
					if (rol != null && !rol.equals("IdiomaCap")) {
						String codUsuario = "";
						if (usuario.get("CodOperario") != JSONObject.NULL) {
							codUsuario = usuario.getString("CodOperario");
							try {
								Integer.parseInt(usuario
										.getString("CodOperario"));
								tecnicoAux.setIdtecnico(Long
										.valueOf(codUsuario));
							} catch (NumberFormatException nfe) {
								tecnicoAux.setIdtecnico(null);
							}

						}

						String fechaHastaStr = "";
						Date fechaHastaDate = null;
						Date fechaActual = new Date();
						if (usuario.get("UltimaFechaSinc") != JSONObject.NULL) {
							fechaHastaStr = usuario
									.getString("UltimaFechaSinc");

							try {
								fechaHastaDate = sdf.parse(fechaHastaStr);
							} catch (ParseException e) {
								ProcesosGmaoController.logger
										.error("[MOVILGMAO] : actualizarPresenciaTecnicos - formatear fecha ultima sinc: "
												+ e.getMessage());
							}

						}

						String thasta = "";
						boolean estaPresente = true;
						boolean noEsUsuarioNormal = false;
						if (usuario.get("IMEI") != JSONObject.NULL) {
							if (usuario.getString("IMEI").equals("undefined")) {
								noEsUsuarioNormal = true;
							}
							fechaHastaDate = null;
							thasta = "0";
							estaPresente = true;
						} else {
							thasta = "5";
							estaPresente = false;
						}

						if (usuario.get("Login") != JSONObject.NULL
								&& !usuario.getString("Login").equals("zzxua")
								&& !usuario.getString("Login").equals("xuacu2")
								&& !noEsUsuarioNormal) {

							// Comprobacion de que existe el técnico en nuestra
							// aplicación
							tecnicoAux = this.tecnicosService.find(tecnicoAux);

							if (tecnicoAux != null) {
								Presencia presenciaAux = new Presencia();
								presenciaAux.setIdtecnico(tecnicoAux
										.getIdtecnico());

								List<Presencia> listaPresencias = this.presenciaService
										.obtenerPresencias(presenciaAux, null,
												false);

								for (Presencia presencia : listaPresencias) {
									if (presencia.getThasta() != null
											&& presencia.getThasta()
													.equals("0")) {
										presenciaAux.setIdpresencia(presencia
												.getIdpresencia());
										if (!estaPresente) {
											/**
											 * Si el técnico estaba presente y
											 * se ha desvinculado en la app,
											 * actualizaremos la presencia para
											 * indicar que ya no está disponible
											 */
											//
											presenciaAux.setFhdesde(presencia
													.getFhdesde());
											presenciaAux
													.setFhhasta(fechaActual);
											presenciaAux.setTdesde("4");
											presenciaAux.setThasta(thasta);

											presenciaAux = this.presenciaService
													.update(presenciaAux);

											/**
											 * De cada técnico se obtienen los
											 * partes correctivos y preventivos
											 * que tiene en curso para ponerlos
											 * en pausa
											 */
											this.tratamientoPausarPartesTecnicosLoginLogout(
													tecnicoAux, "CURS", "0",
													"PAUSA", true, urlConfig);

											// respuesta =
											// this.bajarTodasOTsGmao();

										}
									} else if (presencia.getThasta() != null
											&& !presencia.getThasta().equals(
													"0")) {
										presenciaAux.setIdpresencia(presencia
												.getIdpresencia());
										if (estaPresente) {
											// Si el tecnico no estaba presente
											// y
											// ahora
											// ha
											// hecho login en la aplicación
											// insertaremos la presencia
											presenciaAux
													.setFhdesde(fechaActual);
											presenciaAux
													.setFhhasta(fechaHastaDate);
											presenciaAux.setTdesde("4");
											presenciaAux.setThasta(thasta);

											presenciaAux = this.presenciaService
													.nuevaPresencia(presenciaAux);

											/**
											 * De cada técnico se obtienen los
											 * partes correctivos y preventivos
											 * que tiene en curso para ponerlos
											 * en pausa
											 */
											this.tratamientoPausarPartesTecnicosLoginLogout(
													tecnicoAux, "PAUSA", "1",
													"CURS", false, urlConfig);

											// respuesta =
											// this.bajarTodasOTsGmao();

										}
									}
								}
							}
						}
					}
				}
			}
		} catch (Exception e) {
			respuesta = "KO";
		}

		return respuesta;

	}

	private String tratamientoPartesCorrectivos(JSONObject ot,
			JSONArray operarios, JSONArray otmods, JSONArray logs,
			JSONArray campos, String guidpartehijaFormateado, String urlConfig,
			String guidpartehija) {

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		String respuesta = "";

		// boolean comprobarCambioEstadoCorrectiva = true;
		boolean parteNuevoBienCreado = true;
		String pdteSinc = "";
		if (ot.get("PdteSinc") != JSONObject.NULL) {
			pdteSinc = ot.getString("PdteSinc");
		}

		if (!pdteSinc.equals("0") && !pdteSinc.equals("")) {
			// FechaSinc
			String fechaSinc = "";
			if (ot.get("FechaSinc") != JSONObject.NULL) {
				fechaSinc = ot.getString("FechaSinc");
			}

			Partetecnicosgmao partetecnicosgmaoAux = new Partetecnicosgmao();
			partetecnicosgmaoAux.setGuidpartetecgmao(guidpartehijaFormateado);
			partetecnicosgmaoAux = this.partetecnicosgmaoServices
					.findByGUID(partetecnicosgmaoAux);

			/**
			 * Comprobación para saber si se trata de una OT nueva creada desde
			 * la app movil o planner
			 */
			if (partetecnicosgmaoAux == null) {
				/**
				 * Si se trata de una OT nueva, se crea el parte en nuestra
				 * aplicación
				 */
				parteNuevoBienCreado = this
						.crearParteCorrectivoNuevoDesdeMovilGmao(
								guidpartehijaFormateado, urlConfig, ot);
				partetecnicosgmaoAux = new Partetecnicosgmao();
				partetecnicosgmaoAux
						.setGuidpartetecgmao(guidpartehijaFormateado);
				partetecnicosgmaoAux = this.partetecnicosgmaoServices
						.findByGUID(partetecnicosgmaoAux);
			}
			if (parteNuevoBienCreado) {

				/**
				 * Si el parte correctivo no tenía técnico asignado y ahora ya
				 * le han asignado
				 */
				if (partetecnicosgmaoAux.getIdpartec() == null
						|| (partetecnicosgmaoAux.getIdpartec() != null && partetecnicosgmaoAux
								.getIdpartec() == 0)) {

					String tecnicoResp = "";
					if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
						tecnicoResp = ot.getString("IdOperarioResponsable");
						Partetecnicos partetecnicoNueva = new Partetecnicos();
						partetecnicoNueva.setIdparte(partetecnicosgmaoAux
								.getIdparte());
						partetecnicoNueva.setIdtecnico(Long
								.valueOf(tecnicoResp));
						partetecnicoNueva.setAceptada("1");

						partetecnicoNueva = this.partetecnicosService
								.add(partetecnicoNueva);

						String respuestaAceptada = this.procesosJMSService
								.marcarOTaceptada(partetecnicosgmaoAux
										.getGuidpartetecgmao(), "1", urlConfig);

						partetecnicosgmaoAux.setIdtecnico(Long
								.valueOf(tecnicoResp));
						partetecnicosgmaoAux.setIdpartec(partetecnicoNueva
								.getIdpartec());
						partetecnicosgmaoAux
								.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO);

						Date fechaSincDate = null;
						try {
							fechaSincDate = sdf.parse(fechaSinc);

						} catch (ParseException e) {
							ProcesosGmaoController.logger
									.error("[MOVILGMAO] : tratamientoPartesCorrectivos - formatear fecha sinc: "
											+ e.getMessage()
											+ "; IdParte: "
											+ partetecnicosgmaoAux.getIdparte()
											+ "; IdTecnico:"
											+ partetecnicosgmaoAux
													.getIdtecnico());
						}

						partetecnicosgmaoAux.setFechaEstadoGmao(fechaSincDate);

						partetecnicosgmaoAux = this.partetecnicosgmaoServices
								.update(partetecnicosgmaoAux);
					}
				}

				if (partetecnicosgmaoAux.getIdpartec() != null
						&& partetecnicosgmaoAux.getIdpartec() != 0) {

					Parteejecucion parteEjecucionAux = new Parteejecucion();
					parteEjecucionAux.setIdpartec(partetecnicosgmaoAux
							.getIdpartec());
					List<Parteejecucion> partesEjecucionTecnico = this.parteejecucionServices
							.findAll(parteEjecucionAux, null);

					Partetecnicos partetecnicosAux = new Partetecnicos();
					partetecnicosAux.setIdpartec(partetecnicosgmaoAux
							.getIdpartec());

					partetecnicosAux = this.partetecnicosService
							.find(partetecnicosAux);

					// Operarios
					String tecnicoResp = "";
					if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
						tecnicoResp = ot.getString("IdOperarioResponsable");
					}

					String idEstadoOT = "";
					if (ot.get("IdEstado") != JSONObject.NULL) {
						idEstadoOT = ot.getString("IdEstado");
					}

					if (!idEstadoOT
							.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO)) {
						this.tratamientoOperariosParteCorrectivo(operarios,
								partetecnicosAux, partetecnicosgmaoAux,
								guidpartehija, tecnicoResp, urlConfig);

					}

					// Aceptada
					String aceptada = "";
					if (ot.get("Aceptada") != JSONObject.NULL) {
						aceptada = ot.get("Aceptada").toString();

						if (partetecnicosAux != null
								&& ((partetecnicosAux.getAceptada() != null && !partetecnicosAux
										.getAceptada().equals(aceptada)) || partetecnicosAux
										.getAceptada() == null)) {
							partetecnicosAux.setAceptada(aceptada);
							partetecnicosAux = this.partetecnicosService
									.update(partetecnicosAux);

							// Si el técnico ha rechazadado el parte y
							// el
							// parte es de asignación
							// automática, se deberá asignar
							// automáticamente
							// al siguiente técnico
							// que tenga aplicación movilgmao
							/*
							 * if (aceptada.equals("0")) { Partes parteAux = new
							 * Partes();
							 * parteAux.setIdparte(partetecnicosgmaoAux
							 * .getIdparte()); parteAux =
							 * this.partesService.find(parteAux);
							 * 
							 * // Como ha rechazado el parte, // eliminamos el
							 * // técnico del parte // tanto en la aa20b como en
							 * MovilGmao // (sincronizar)
							 * this.eliminarTecnicoRechazada(parteAux,
							 * partetecnicosAux, partetecnicosgmaoAux,
							 * urlConfig);
							 * 
							 * if (parteAux != null && parteAux.getAutomatica()
							 * != null && parteAux.getAutomatica().equals("1"))
							 * {
							 * 
							 * this.asignarParteCorrectivoAutomatico(parteAux,
							 * partetecnicosAux, urlConfig);
							 * 
							 * } }
							 */
						}

					}

					// Documentos
					// Si tiene más de un documento significa que tiene
					// el
					// PDF
					// guardado con la firma y descripción
					/*
					 * if (documentos.length() > 1) { for (int x = 0; x <
					 * documentos.length(); x++) { JSONObject otdocumento =
					 * documentos.getJSONObject(x); if (otdocumento != null &&
					 * otdocumento.get("UUIdOtDocumento") != JSONObject.NULL &&
					 * !otdocumento .getString("UUIdOtDocumento")
					 * .equalsIgnoreCase( partetecnicosgmaoAux
					 * .getGuidplanopartegmao())) { // Es el documento PDF que
					 * no tenemos, guardamos si // UUId if (partetecnicosgmaoAux
					 * != null && (partetecnicosgmaoAux.getGuidpdf() == null ||
					 * partetecnicosgmaoAux .getGuidpdf() != null &&
					 * partetecnicosgmaoAux .getGuidpdf().trim() .equals(""))) {
					 * partetecnicosgmaoAux.setGuidpdf(otdocumento
					 * .getString("UUIdOtDocumento"));
					 * 
					 * partetecnicosgmaoAux = this.partetecnicosgmaoServices
					 * .update(partetecnicosgmaoAux); } } } }
					 */

					// MODS
					/*
					 * this.tratamientoModsParteCorrectivo(otmods,
					 * parteEjecucionAux, partetecnicosgmaoAux,
					 * partetecnicosAux, partesEjecucionTecnico, guidpartehija,
					 * sdf);
					 */

					// NOTAS TECNICO
					for (int z = 0; z < campos.length(); z++) {
						// comprobarCambioEstadoCorrectiva = false;
						JSONObject otcampo = campos.getJSONObject(z);
						if (otcampo != null
								&& otcampo.get("UUIdOt") != JSONObject.NULL
								&& otcampo.getString("UUIdOt")
										.equalsIgnoreCase(guidpartehija)) {

							String notasTecnico = "";
							if (otcampo.get("IdCampo") != JSONObject.NULL
									&& otcampo.getString("IdCampo").equals(
											"NOTASTEC")) {
								if (otcampo.get("Valor") != JSONObject.NULL
										&& !otcampo.getString("Valor").equals(
												"")) {
									notasTecnico = otcampo.getString("Valor");

									partetecnicosAux.setNotasTec(notasTecnico);
									partetecnicosAux = this.partetecnicosService
											.update(partetecnicosAux);
								}

							}

						}
					}

					/**
					 * Si el parte no tiene mano de obra, deberemos comprobar si
					 * es que ha cambiado de estado de ASIGNADA (ASIG) a EN
					 * CURSO (CURS) o de EN CURSO (CURS) a TERMINADA (TERM)
					 */
					// if (comprobarCambioEstadoCorrectiva) {
					this.tratamientoCambioEstadosParteCorrectivo(logs,
							parteEjecucionAux, guidpartehijaFormateado, sdf,
							urlConfig);
					// }

					/**
					 * Se comprueba si el parte se ha finalizado o no o si ya
					 * estaba finalizado
					 */
					if ((partetecnicosAux != null
							&& partetecnicosAux.getFinalizado() != null
							&& !partetecnicosAux.getFinalizado().equals("1") && idEstadoOT
							.equals("TERM"))
							|| (partetecnicosAux != null
									&& partetecnicosAux.getFinalizado() == null && idEstadoOT
									.equals("TERM"))) {
						partetecnicosAux.setFinalizado("1");
						partetecnicosAux = this.partetecnicosService
								.update(partetecnicosAux);

						/**
						 * Si no está finalizado se comprueba si todos los demás
						 * tecnicos de este parte han finalizado sus ejecuciones
						 * Para saber si finalizar el parte padre de todo
						 */
						Partetecnicos partetecnicospadre = new Partetecnicos();
						partetecnicospadre.setIdparte(partetecnicosgmaoAux
								.getIdparte());
						List<Partetecnicos> listaParteTecnicosAux = this.partetecnicosService
								.findAll(partetecnicospadre, null);

						boolean finalizarParte = true;
						for (Partetecnicos partetecnicopadre : listaParteTecnicosAux) {
							if (partetecnicopadre != null
									&& ((partetecnicopadre.getFinalizado() != null && !partetecnicopadre
											.getFinalizado().equals("1")) || partetecnicopadre
											.getFinalizado() == null)) {
								finalizarParte = false;
							}
						}

						// Si todos los técnicos han finalizado sus
						// ejecuciones
						if (finalizarParte) {

							// Recalculamos el tiempo de ejecución
							this.parteejecucionServices
									.recalcularTiempoParteTecnico(partetecnicosgmaoAux
											.getIdpartec());

							this.finalizarParteCorrectivoMovilgmao(
									partetecnicosgmaoAux, urlConfig);

						}
					}
					// Recalculamos el tiempo de ejecución
					this.parteejecucionServices
							.recalcularTiempoParteTecnico(partetecnicosgmaoAux
									.getIdpartec());

					// Firma conformidad (Indicará si se ha finalizado)
					this.tratamientoFirmaParteCorrectivo(ot,
							partetecnicosgmaoAux);

					/*
					 * ot.get("IdEstado"); ot.get("IdTipo");
					 * ot.get("IdOperarioResponsable"); ot.get("Aceptada");
					 * ot.get("FirmaConformidad"); ot.get("UUIdOt");
					 * ot.get("FechaSinc"); ot.get("UUIdActivo");
					 * ot.get("UUIdOtPadre");
					 */

					/**
					 * Fecha planificacion Si ha cambiado desde el planner de
					 * día el parte
					 */
					String fechaplanif = "";
					if (ot.get("FechaPlanificacion") != JSONObject.NULL) {
						fechaplanif = ot.getString("FechaPlanificacion");

						Date fechaPlanifGmao = null;

						try {
							fechaPlanifGmao = sdf.parse(fechaplanif);

							Partes parteAux = new Partes();
							parteAux.setIdparte(partetecnicosgmaoAux
									.getIdparte());
							parteAux.setFechaplanif(fechaPlanifGmao);

							parteAux = this.partesService
									.actualizarFechaPlanificacion(parteAux);

						} catch (ParseException e) {
							ProcesosGmaoController.logger
									.error("[MOVILGMAO] : bajarOTs - formatear fecha planif: "
											+ e.getMessage());
						}

					}

					// Sincronizamos con MovilGmao para indicar que este parte
					// ya se
					// ha sincronizado OK
					JSONObject pdteSincOtOK = new JSONObject();
					JSONArray valoresOTbajada = new JSONArray();
					JSONObject valorBajada = new JSONObject();
					valorBajada.put("UUIdOt", guidpartehijaFormateado);
					valorBajada.put("FechaUltimaSinc", fechaSinc);
					valoresOTbajada.put(valorBajada);
					pdteSincOtOK.put("ots", valoresOTbajada);
					respuesta = this.procesosJMSService.sincronizarGmao(
							pdteSincOtOK, urlConfig
									+ Aa20bConstantes.URL_MARCAR_SINC_OK);
				}
			}
		}

		return respuesta;

	}

	private String tratamientoPartesPreventivos(JSONObject ot,
			JSONArray operarios, JSONArray otmods, JSONArray revisiones,
			JSONArray logs, JSONArray campos, String guidpartehijaFormateado,
			String guidpartehija, String urlConfig) {

		String respuesta = "";
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		// boolean comprobarCambioEstadoPreventiva = true;
		/*
		 * String guidpartepadreFormateado = ""; if (ot.get("UUIdOtPadre") !=
		 * JSONObject.NULL) { guidpartepadreFormateado =
		 * ot.getString("UUIdOtPadre").replace("{", "");
		 * guidpartepadreFormateado = guidpartepadreFormateado .replace("}",
		 * ""); } else { guidpartepadreFormateado =
		 * ot.getString("UUIdOt").replace("{", ""); guidpartepadreFormateado =
		 * guidpartepadreFormateado .replace("}", ""); if
		 * (guidpartepadreFormateado != null &&
		 * !guidpartepadreFormateado.equals("")) { guidpartepadreFormateado =
		 * guidpartepadreFormateado .toLowerCase(); } }
		 */

		String pdteSinc = "";
		if (ot.get("PdteSinc") != JSONObject.NULL) {
			pdteSinc = ot.getString("PdteSinc");
		}

		if (!pdteSinc.equals("0") && !pdteSinc.equals("")) {
			// FechaSinc
			String fechaSinc = "";

			if (ot.get("FechaSinc") != JSONObject.NULL) {
				fechaSinc = ot.getString("FechaSinc");
			}
			boolean fichaNuevoBienCreado = true;
			Fichatecnicosgmao fichatecnicosgmaoAux = new Fichatecnicosgmao();
			fichatecnicosgmaoAux.setGuidfichatecgmao(guidpartehijaFormateado);
			fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
					.findByGUID(fichatecnicosgmaoAux);

			/**
			 * Comprobación para saber si se trata de una OT de seguimiento o de
			 * ayuda creada desde la app movil
			 */
			if (fichatecnicosgmaoAux == null) {
				/**
				 * Si se trata de una OT de seguimiento o de ayuda
				 */
				fichaNuevoBienCreado = this
						.tratamientoParteAyudaSeguimientoCorrectivoDesdeMovilGmao(
								guidpartehijaFormateado, urlConfig, ot);
				fichatecnicosgmaoAux = new Fichatecnicosgmao();
				fichatecnicosgmaoAux
						.setGuidfichatecgmao(guidpartehijaFormateado);
				fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
						.findByGUID(fichatecnicosgmaoAux);
			}

			if (fichaNuevoBienCreado) {

				if (fichatecnicosgmaoAux != null) {
					Ficha fichaAux = new Ficha();
					/*
					 * fichaAux.setGuidficha(guidpartepadreFormateado); fichaAux
					 * = this.fichasService .findFichaByGuid(fichaAux);
					 */

					fichaAux.setIdficha(fichatecnicosgmaoAux.getIdficha());
					fichaAux = this.fichasService.findFicha(fichaAux);
					// Comprobamos si la ficha es nula por si acaso se ha
					// borrado
					// de nuestra aplic y de movilgmao no
					if (fichaAux != null) {
						Maquinas maquinaAux = this.maquinasService
								.obtenerMaquina(fichaAux.getIdmaquina()
										.toString());

						Gamas gamaAux = this.gamasService
								.obtenerGama(maquinaAux.getIdgama().toString());

						/**
						 * Si el parte preventivo no tenía técnico asignado y
						 * ahora ya le han asignado
						 * 
						 */
						if (fichatecnicosgmaoAux.getIdfichac() == null
								|| (fichatecnicosgmaoAux.getIdfichac() != null && fichatecnicosgmaoAux
										.getIdfichac() == 0)) {
							String tecnicoResp = "";
							if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
								tecnicoResp = ot
										.getString("IdOperarioResponsable");
								Fichatecnico fichatecnicoNueva = new Fichatecnico();
								fichatecnicoNueva
										.setIdficha(fichatecnicosgmaoAux
												.getIdficha());
								fichatecnicoNueva.setIdtecnico(Long
										.valueOf(tecnicoResp));
								fichatecnicoNueva.setAceptada("1");

								fichatecnicoNueva = this.fichatecnicosService
										.add(fichatecnicoNueva);

								String respuestaAceptada = this.procesosJMSService
										.marcarOTaceptada(fichatecnicosgmaoAux
												.getGuidfichatecgmao(), "1",
												urlConfig);

								fichatecnicosgmaoAux.setIdtecnico(Long
										.valueOf(tecnicoResp));
								fichatecnicosgmaoAux
										.setIdfichac(fichatecnicoNueva
												.getIdfitec());
								fichatecnicosgmaoAux
										.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_ASIGNADO);

								Date fechaSincDate = null;
								try {
									fechaSincDate = sdf.parse(fechaSinc);

								} catch (ParseException e) {
									ProcesosGmaoController.logger
											.error("[MOVILGMAO] : tratamientoPartesPreventivos - formatear fecha sinc: "
													+ e.getMessage()
													+ "; IdParte: "
													+ fichatecnicosgmaoAux
															.getIdficha()
													+ "; IdTecnico:"
													+ fichatecnicosgmaoAux
															.getIdtecnico());
								}

								fichatecnicosgmaoAux
										.setFechaEstadoGmao(fechaSincDate);

								fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
										.update(fichatecnicosgmaoAux);
							}
						}

						if (fichatecnicosgmaoAux.getIdfichac() != null
								&& fichatecnicosgmaoAux.getIdfichac() != 0) {

							Fichaejecucion fichaEjecucionAux = new Fichaejecucion();
							fichaEjecucionAux.setIdfitec(fichatecnicosgmaoAux
									.getIdfichac());
							List<Fichaejecucion> fichasEjecucionTecnico = this.fichaejecucionServices
									.findAll(fichaEjecucionAux, null);

							Fichatecnico fichatecnicosAux = new Fichatecnico();
							fichatecnicosAux = this.fichatecnicosService
									.obtenerFicha(fichatecnicosgmaoAux
											.getIdfichac());

							/**
							 * Se comprueba si el parte sigue teniendo asignado
							 * el técnico y no se ha cambiado desde el planner a
							 * sin asignar o a otro técnico
							 */

							String idEstadoOT = "";
							if (ot.get("IdEstado") != JSONObject.NULL) {
								idEstadoOT = ot.getString("IdEstado");
							}

							// Operarios
							String tecnicoResp = "";
							if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
								tecnicoResp = ot
										.getString("IdOperarioResponsable");
							}

							// Si el parte no esta finalizado, comprobamos si ha
							// cambiado el técnico
							if (!idEstadoOT
									.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO)) {
								this.tratamientoOperariosPartePreventivo(
										operarios, fichatecnicosAux,
										fichatecnicosgmaoAux, guidpartehija,
										tecnicoResp);
							}

							// Aceptada
							String aceptada = "";
							if (ot.get("Aceptada") != JSONObject.NULL) {
								aceptada = ot.get("Aceptada").toString();

								if (fichatecnicosAux != null
										&& ((fichatecnicosAux.getAceptada() != null && !fichatecnicosAux
												.getAceptada().equals(aceptada)) || fichatecnicosAux
												.getAceptada() == null)) {
									fichatecnicosAux.setAceptada(aceptada);
									fichatecnicosAux = this.fichatecnicosService
											.update(fichatecnicosAux);
								}

							}

							// Revisiones
							this.tratamientoRevisionesPartePreventivo(
									revisiones, fichaAux, fichatecnicosgmaoAux,
									maquinaAux, gamaAux, fechaSinc,
									guidpartehija, sdf);

							// MODS
							/*
							 * this.tratamientoModsPartePreventivo(otmods,
							 * fichaEjecucionAux, fichatecnicosAux,
							 * fichatecnicosgmaoAux, fichasEjecucionTecnico,
							 * guidpartehija, sdf);
							 */

							// NOTAS TECNICO
							for (int z = 0; z < campos.length(); z++) {
								JSONObject otcampo = campos.getJSONObject(z);
								if (otcampo != null
										&& otcampo.get("UUIdOt") != JSONObject.NULL
										&& otcampo
												.getString("UUIdOt")
												.equalsIgnoreCase(guidpartehija)) {

									String notasTecnico = "";
									if (otcampo.get("IdCampo") != JSONObject.NULL
											&& otcampo.getString("IdCampo")
													.equals("NOTASTEC")) {
										if (otcampo.get("Valor") != JSONObject.NULL
												&& !otcampo.getString("Valor")
														.equals("")) {
											notasTecnico = otcampo
													.getString("Valor");

											fichatecnicosAux
													.setNotasTec(notasTecnico);
											fichatecnicosAux = this.fichatecnicosService
													.update(fichatecnicosAux);
										}

									}

								}
							}

							/**
							 * Se comprueba si el parte se ha finalizado o no o
							 * si ya estaba finalizado
							 */

							/**
							 * Si el parte no tiene mano de obra, deberemos
							 * comprobar si es que ha cambiado de estado de
							 * ASIGNADA (ASIG) a EN CURSO (CURS) o de EN CURSO
							 * (CURS) a TERMINADA (TERM)
							 */
							// if (comprobarCambioEstadoPreventiva) {
							this.tratamientoCambioEstadosPartePreventivo(logs,
									fichaEjecucionAux, guidpartehijaFormateado,
									sdf, urlConfig);
							// }

							if ((fichatecnicosAux != null
									&& fichatecnicosAux.getFinalizado() != null
									&& !fichatecnicosAux.getFinalizado()
											.equals("1") || idEstadoOT
									.equals("TERM"))
									|| (fichatecnicosAux.getFinalizado() == null && idEstadoOT
											.equals("TERM"))) {
								fichatecnicosAux.setFinalizado("1");
								fichatecnicosAux = this.fichatecnicosService
										.update(fichatecnicosAux);

								/**
								 * Si no está finalizado se comprueba si todos
								 * los demás tecnicos de este parte han
								 * finalizado sus ejecuciones Para saber si
								 * finalizar el parte padre de todo
								 */
								Fichatecnico fichatecnicospadre = new Fichatecnico();
								fichatecnicospadre
										.setIdficha(fichatecnicosgmaoAux
												.getIdficha());
								List<Fichatecnico> listaFichaTecnicosAux = this.fichatecnicosService
										.findAll(fichatecnicospadre, null);

								boolean finalizarParte = true;
								for (Fichatecnico fichatecnicopadre : listaFichaTecnicosAux) {
									if (fichatecnicopadre != null
											&& ((fichatecnicopadre
													.getFinalizado() != null && !fichatecnicopadre
													.getFinalizado()
													.equals("1")) || fichatecnicopadre
													.getFinalizado() == null)) {
										finalizarParte = false;
									}
								}

								// Si todos los técnicos han finalizado sus
								// ejecuciones
								if (finalizarParte) {

									this.fichaejecucionServices
											.recalcularTiempoFichaTecnico(fichatecnicosAux
													.getIdfitec());

									this.finalizarPartePreventivoMovilgmao(
											fichatecnicosgmaoAux, maquinaAux,
											urlConfig);

								}

							}

							this.fichaejecucionServices
									.recalcularTiempoFichaTecnico(fichatecnicosAux
											.getIdfitec());

							// Firma conformidad (Indicará si se ha finalizado)
							this.tratamientoFirmaPartePreventivo(ot,
									fichatecnicosgmaoAux);

						}

						/**
						 * Fecha planificacion Si ha cambiado desde el planner
						 * de día el parte
						 */
						String fechaplanif = "";
						if (ot.get("FechaPlanificacion") != JSONObject.NULL) {
							fechaplanif = ot.getString("FechaPlanificacion");

							Date fechaPlanifGmao = null;

							try {
								fechaPlanifGmao = sdf.parse(fechaplanif);
								fichaAux.setFechaplanif(fechaPlanifGmao);
								fichaAux = this.fichasService
										.actualizarFechaPlanificacion(fichaAux);

							} catch (ParseException e) {
								ProcesosGmaoController.logger
										.error("[MOVILGMAO] : bajarOTs - formatear fecha planif: "
												+ e.getMessage());
							}

						}
					}
				}
			}

			JSONObject pdteSincOtOK = new JSONObject();
			JSONArray valoresOTbajada = new JSONArray();
			JSONObject valorBajada = new JSONObject();
			valorBajada.put("UUIdOt", guidpartehijaFormateado);
			valorBajada.put("FechaUltimaSinc", fechaSinc);
			valoresOTbajada.put(valorBajada);
			pdteSincOtOK.put("ots", valoresOTbajada);
			respuesta = this.procesosJMSService.sincronizarGmao(pdteSincOtOK,
					urlConfig + Aa20bConstantes.URL_MARCAR_SINC_OK);
		}

		return respuesta;
	}

	private void tratamientoOperariosParteCorrectivo(JSONArray operarios,
			Partetecnicos partetecnicosAux,
			Partetecnicosgmao partetecnicosgmaoAux, String guidpartehija,
			String tecnicoResponsable, String urlConfig) {

		if (partetecnicosAux != null
				&& partetecnicosAux.getIdtecnico() != null
				&& !partetecnicosAux.getIdtecnico().toString()
						.equalsIgnoreCase(tecnicoResponsable)) {
			// Si no coincide y tiene tecnicoResponsable desde movilgmao
			// significa que ha cambiado de operario
			if (!tecnicoResponsable.equals("")) {
				partetecnicosAux.setIdtecnico(Long.valueOf(tecnicoResponsable));
				partetecnicosgmaoAux.setIdtecnico(Long
						.valueOf(tecnicoResponsable));
				partetecnicosAux = this.partetecnicosService
						.update(partetecnicosAux);
			} else {
				partetecnicosAux.setIdtecnico(null);
				partetecnicosgmaoAux.setIdtecnico(null);
				partetecnicosgmaoAux.setIdpartec(null);
				partetecnicosgmaoAux.setEstadoGmao(null);
				this.partetecnicosService.remove(partetecnicosAux);

				/**
				 * Comprobamos si el parte tiene más técnicos asignados en ese
				 * caso no dejamos el parte sin asignar en el planner y lo
				 * eliminamos
				 */
				Partetecnicosgmao partetecgmaoBusqAux = new Partetecnicosgmao();
				partetecgmaoBusqAux.setIdparte(partetecnicosgmaoAux
						.getIdparte());
				List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
						.findAll(partetecgmaoBusqAux, null);

				if (parteTecnicosGmao.size() > 1) {
					int contadorTecnicos = parteTecnicosGmao.size();
					int contadorBorrados = 1;
					for (Partetecnicosgmao partetecgmaoAux : parteTecnicosGmao) {
						if (partetecgmaoAux != null
								&& (partetecgmaoAux.getIdtecnico() == null || partetecgmaoAux
										.getIdtecnico() == 0)
								&& contadorBorrados != contadorTecnicos) {
							this.procesosJMSService.eliminarOTpadre(
									partetecgmaoAux.getGuidpartetecgmao(),
									urlConfig);
							this.partetecnicosgmaoServices
									.remove(partetecgmaoAux);
							contadorBorrados++;
						}

					}
				}

			}
			partetecnicosgmaoAux = this.partetecnicosgmaoServices
					.update(partetecnicosgmaoAux);
		}

		/*
		 * for (int y = 0; y < operarios.length(); y++) { // if
		 * (operarios.length() > 0) { JSONObject otoperario =
		 * operarios.getJSONObject(y); if (otoperario != null &&
		 * otoperario.get("UUIdOt") != JSONObject.NULL &&
		 * otoperario.getString("UUIdOt").equalsIgnoreCase( guidpartehija)) {
		 * 
		 * // Comprobamos si ha cambiado de operario // desde el planner o app
		 * String idOperarioOT = ""; if (otoperario.get("IdOperario") !=
		 * JSONObject.NULL) { idOperarioOT = otoperario.getString("IdOperario");
		 * 
		 * if (partetecnicosAux != null && partetecnicosAux.getIdtecnico() !=
		 * null && !partetecnicosAux.getIdtecnico().toString()
		 * .equalsIgnoreCase(idOperarioOT)) { // Si no coincide significa que ha
		 * // cambiado de operario partetecnicosAux.setIdtecnico(Long
		 * .valueOf(idOperarioOT));
		 * 
		 * partetecnicosgmaoAux.setIdtecnico(Long .valueOf(idOperarioOT));
		 * 
		 * partetecnicosAux = this.partetecnicosService
		 * .update(partetecnicosAux);
		 * 
		 * partetecnicosgmaoAux = this.partetecnicosgmaoServices
		 * .update(partetecnicosgmaoAux); }
		 * 
		 * } } }
		 */
	}

	private void tratamientoModsParteCorrectivo(JSONArray otmods,
			Parteejecucion parteEjecucionAux,
			Partetecnicosgmao partetecnicosgmaoAux,
			Partetecnicos partetecnicosAux,
			List<Parteejecucion> partesEjecucionTecnico, String guidpartehija,
			SimpleDateFormat sdf) {
		// boolean comprobarCambioEstadoCorrectiva = true;
		for (int z = 0; z < otmods.length(); z++) {
			// comprobarCambioEstadoCorrectiva = false;
			JSONObject otmod = otmods.getJSONObject(z);
			if (otmod != null
					&& otmod.get("UUIdOt") != JSONObject.NULL
					&& otmod.getString("UUIdOt")
							.equalsIgnoreCase(guidpartehija)) {

				parteEjecucionAux = new Parteejecucion();
				/*
				 * String idHora = ""; if (otmod.get("IdHora") != null) { idHora
				 * = otmod.getString("IdHora"); }
				 */
				String fechaEjecInicio = "";
				String fechaEjecFin = "";

				if (otmod.get("HoraInicio") != JSONObject.NULL) {
					fechaEjecInicio = otmod.getString("HoraInicio");
				}
				if (otmod.get("HoraFin") != JSONObject.NULL) {
					fechaEjecFin = otmod.getString("HoraFin");
				}

				Date fechaEjecInicioDate = null;
				Date fechaEjecFinDate = null;
				try {
					fechaEjecInicioDate = sdf.parse(fechaEjecInicio);
					fechaEjecFinDate = sdf.parse(fechaEjecFin);
				} catch (ParseException e) {
					ProcesosGmaoController.logger
							.error("[MOVILGMAO] : bajarOTs - formatear fecha ejec: "
									+ e.getMessage()
									+ "; IdParte: "
									+ partetecnicosgmaoAux.getIdparte()
									+ "; IdTecnico:"
									+ partetecnicosgmaoAux.getIdtecnico());
				}

				// Comprobamos si ya existe esta ejecucion
				// en la
				// tabla
				// para no duplicarla
				boolean existeEjec = false;
				for (Parteejecucion parteEjec : partesEjecucionTecnico) {
					if (fechaEjecInicioDate.compareTo(parteEjec.getFeini()) == 0
							&& fechaEjecFinDate.compareTo(parteEjec.getFefin()) == 0) {
						existeEjec = true;
						break;
					}
				}
				if (!existeEjec) {
					parteEjecucionAux.setIdpartec(partetecnicosgmaoAux
							.getIdpartec());
					parteEjecucionAux.setFeini(fechaEjecInicioDate);
					parteEjecucionAux.setFefin(fechaEjecFinDate);

					parteEjecucionAux = this.parteejecucionServices
							.add(parteEjecucionAux);
				}

			}

			this.parteejecucionServices
					.recalcularTiempoParteTecnico(partetecnicosgmaoAux
							.getIdpartec());

			// Refrescamos el objeto con la información
			// actualizada
			// del parte técnico
			partetecnicosAux = this.partetecnicosService.find(partetecnicosAux);

			// Puede ser que no la haya aceptado en la
			// aplicación
			// móvil
			// y haya
			// metido ejecuciones. En ese caso la marcamos
			// como
			// aceptada
			if (partetecnicosAux != null
					&& ((partetecnicosAux.getAceptada() != null && !partetecnicosAux
							.getAceptada().equals("1")) || partetecnicosAux
							.getAceptada() == null)) {
				partetecnicosAux.setAceptada("1");
				partetecnicosAux = this.partetecnicosService
						.update(partetecnicosAux);
			}
		}

		// return comprobarCambioEstadoCorrectiva;
	}

	private void tratamientoCambioEstadosParteCorrectivo(JSONArray logs,
			Parteejecucion parteEjecucionAux, String guidpartehijaFormateado,
			SimpleDateFormat sdf, String urlConfig) {

		if (logs.length() > 0) {
			int contadorPausasAnt = 0;
			boolean terminar = false;
			List<OtLogGmao> valoresEstados = new ArrayList<OtLogGmao>();
			for (int x = 0; x < logs.length(); x++) {
				JSONObject log = logs.getJSONObject(x);

				// Si el tipo de log es 2, significa que
				// es
				// de cambio de
				// estado
				OtLogGmao otLogObj = new OtLogGmao();
				if (log.get("TipoLog") != JSONObject.NULL
						&& log.getString("TipoLog").equals("2")
						&& log.get("UUIdOt") != JSONObject.NULL
						&& log.getString("UUIdOt").equalsIgnoreCase(
								"{" + guidpartehijaFormateado + "}")) {

					String uuIdOt = "";
					if (log.get("UUIdOt") != JSONObject.NULL) {
						uuIdOt = log.getString("UUIdOt").replace("{", "");
						uuIdOt = uuIdOt.replace("}", "");
						uuIdOt = uuIdOt.toLowerCase();
						otLogObj.setuUIdOt(uuIdOt);
					}

					String estadoMovil = "";
					if (log.get("CampoIdParaFiltro") != JSONObject.NULL) {
						estadoMovil = log.getString("CampoIdParaFiltro");
						otLogObj.setCampoIdParaFiltro(estadoMovil);
						if (estadoMovil.equals("PAUSA")) {
							contadorPausasAnt++;
						} else if (estadoMovil.equals("TERM")) {
							terminar = true;
						}
					}
					String fecha = "";

					if (log.get("FechaLocal") != JSONObject.NULL) {
						fecha = log.getString("FechaLocal");
						otLogObj.setFecha(fecha);

					}

					String valorAnterior = "";
					if (log.get("ValorAnterior") != JSONObject.NULL) {
						valorAnterior = log.getString("ValorAnterior");

						otLogObj.setValorAnterior(valorAnterior);
					}
					valoresEstados.add(otLogObj);
				}
			}
			int contadorPausas = 0;

			for (OtLogGmao estadoGmao : valoresEstados) {

				if (estadoGmao != null) {
					String uuIdOt = estadoGmao.getuUIdOt();
					Partetecnicosgmao parteTecGmaoAux = new Partetecnicosgmao();
					parteTecGmaoAux.setGuidpartetecgmao(uuIdOt);
					parteTecGmaoAux = this.partetecnicosgmaoServices
							.findByGUID(parteTecGmaoAux);

					String valorAnterior = estadoGmao.getValorAnterior();
					String estadoMovil = "";
					if (estadoGmao.getCampoIdParaFiltro() != null) {
						estadoMovil = estadoGmao.getCampoIdParaFiltro();
					}
					Date fechaEstado = null;
					if (estadoGmao.getFecha() != null) {
						try {
							fechaEstado = sdf.parse(estadoGmao.getFecha());

						} catch (ParseException e) {
							ProcesosGmaoController.logger
									.error("[MOVILGMAO] : bajarOTs - formatear fecha estado: "
											+ e.getMessage());
						}
					}

					if (valorAnterior != null) {

						/**
						 * Si el estado ya es Terminado no hacemos nada
						 */
						if (parteTecGmaoAux.getEstadoGmao() == null
								|| (parteTecGmaoAux.getEstadoGmao() != null && !parteTecGmaoAux
										.getEstadoGmao()
										.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO))) {

							/**
							 * Comprobamos si la fecha del estado que viene
							 * informada es anterior a la última que hemos
							 * registrado Si es menor, ya hemos actualizado ese
							 * estado y no hacemos nada
							 */
							if (parteTecGmaoAux.getFechaEstadoGmao() == null
									|| (parteTecGmaoAux.getFechaEstadoGmao() != null && fechaEstado
											.compareTo(parteTecGmaoAux
													.getFechaEstadoGmao()) == 1)) {

								// Significa que ha cambiado
								// de estado
								if (valorAnterior.equals("ASIG")
										&& valorAnterior.equals(parteTecGmaoAux
												.getEstadoGmao())) {
									if (estadoMovil.equals("CURS")
											|| estadoMovil.equals("PAUSA")) {

										if (estadoMovil.equals("CURS")) {
											/**
											 * Comprobamos que no tenga otro
											 * parte ya en curso para pausarlo
											 * Primero comprobamos en partes
											 * correctivos
											 */
											this.comprobrarPartesCorrectivosEnCurso(
													parteTecGmaoAux, urlConfig);

											/**
											 * Comprobamos en partes preventivos
											 */
											Fichatecnicosgmao fichaTecGmaoAux = new Fichatecnicosgmao();
											fichaTecGmaoAux
													.setIdtecnico(parteTecGmaoAux
															.getIdtecnico());
											this.comprobrarPartesPreventivosEnCurso(
													fichaTecGmaoAux, urlConfig);
										}

										parteTecGmaoAux
												.setEstadoGmao(estadoMovil);
										parteTecGmaoAux
												.setFechaEstadoGmao(fechaEstado);

										parteTecGmaoAux = this.partetecnicosgmaoServices
												.update(parteTecGmaoAux);

									} else if (estadoMovil.equals("TERM")) {
										// Actualizamos el
										// estado y fecha
										parteTecGmaoAux
												.setEstadoGmao(estadoMovil);
										parteTecGmaoAux
												.setFechaEstadoGmao(fechaEstado);

										parteTecGmaoAux = this.partetecnicosgmaoServices
												.update(parteTecGmaoAux);
									}
								} else if (valorAnterior.equals("CURS")
										&& valorAnterior.equals(parteTecGmaoAux
												.getEstadoGmao())) {

									// Comprobamos si es Pausa, que sea la
									// última de
									// las
									// pausas de todo
									// el array de estados
									if ((estadoMovil.equals("PAUSA") && ((contadorPausas + 1) == contadorPausasAnt))
											|| estadoMovil.equals("TERM")) {
										// Obtenemos fecha del estado en curso
										Date fechaEnCurso = null;
										if (parteTecGmaoAux
												.getFechaEstadoGmao() != null) {
											fechaEnCurso = parteTecGmaoAux
													.getFechaEstadoGmao();
										}

										// Comprobamos si el estado nuevo es
										// Terminado,
										// para evitar que al recorrer todos los
										// estados vuelva a entrar por Pausa
										if (fechaEnCurso.compareTo(fechaEstado) == -1
												&& ((estadoMovil
														.equals("PAUSA") && !terminar) || (estadoMovil
														.equals("TERM") && terminar))) {
											// Obtenemos las ejecuciones de este
											// tecnico
											// en
											// el parte
											Parteejecucion parteEjecucionLogAux = new Parteejecucion();
											parteEjecucionLogAux
													.setIdpartec(parteTecGmaoAux
															.getIdpartec());
											List<Parteejecucion> partesEjecucionLogTecnico = this.parteejecucionServices
													.findAll(
															parteEjecucionLogAux,
															null);

											// Comprobamos si ya
											// existe esta
											// ejecucion
											// en la
											// tabla
											// para no
											// duplicarla
											boolean existeEjec = false;
											for (Parteejecucion parteEjec : partesEjecucionLogTecnico) {
												if (fechaEnCurso
														.compareTo(parteEjec
																.getFeini()) == 0
														&& fechaEstado
																.compareTo(parteEjec
																		.getFefin()) == 0) {
													existeEjec = true;
													break;
												}
											}
											if (!existeEjec) {
												parteEjecucionLogAux
														.setIdpartec(parteTecGmaoAux
																.getIdpartec());
												parteEjecucionLogAux
														.setFeini(fechaEnCurso);
												parteEjecucionLogAux
														.setFefin(fechaEstado);

												parteEjecucionLogAux = this.parteejecucionServices
														.add(parteEjecucionLogAux);

												this.parteejecucionServices
														.recalcularTiempoParteTecnico(parteTecGmaoAux
																.getIdpartec());
											}

											// Actualizamos el
											// estado y fecha
											parteTecGmaoAux
													.setEstadoGmao(estadoMovil);
											parteTecGmaoAux
													.setFechaEstadoGmao(fechaEstado);

											parteTecGmaoAux = this.partetecnicosgmaoServices
													.update(parteTecGmaoAux);
										}

									}
								} else if (valorAnterior.equals("PAUSA")) {
									contadorPausas++;
									if (valorAnterior.equals(parteTecGmaoAux
											.getEstadoGmao())) {
										if (estadoMovil.equals("CURS")
												|| estadoMovil.equals("TERM")) {

											// Obtenemos fecha del estado en
											// pausa
											Date fechaEnPausa = null;
											if (parteTecGmaoAux
													.getFechaEstadoGmao() != null) {
												fechaEnPausa = parteTecGmaoAux
														.getFechaEstadoGmao();
											}

											// Sumamos el tiempo en pausa al
											// campo
											// tiempopausa
											Integer tiempoPausa = 0;
											if (parteTecGmaoAux
													.getTiempopausaGmao() != null) {
												tiempoPausa = parteTecGmaoAux
														.getTiempopausaGmao();
											}
											Calendar calFechaIniPausa = Calendar
													.getInstance();
											Calendar calFechaFinPausa = Calendar
													.getInstance();
											calFechaIniPausa
													.setTime(fechaEnPausa);
											calFechaFinPausa
													.setTime(fechaEstado);
											Long totalMinutos = ((calFechaFinPausa
													.getTimeInMillis() - calFechaIniPausa
													.getTimeInMillis()) / 1000 / 60);

											if (totalMinutos != 0) {
												tiempoPausa = tiempoPausa
														+ totalMinutos
																.intValue();

												parteTecGmaoAux
														.setTiempopausaGmao(tiempoPausa);
												this.partetecnicosgmaoServices
														.actualizarTiempoPausaParte(parteTecGmaoAux);
											}

											if (estadoMovil.equals("CURS")) {
												/**
												 * Comprobamos que no tenga otro
												 * parte ya en curso para
												 * pausarlo Primero comprobamos
												 * en partes correctivos
												 */
												this.comprobrarPartesCorrectivosEnCurso(
														parteTecGmaoAux,
														urlConfig);

												/**
												 * Comprobamos en partes
												 * preventivos
												 */
												Fichatecnicosgmao fichaTecGmaoAux = new Fichatecnicosgmao();
												fichaTecGmaoAux
														.setIdtecnico(parteTecGmaoAux
																.getIdtecnico());
												this.comprobrarPartesPreventivosEnCurso(
														fichaTecGmaoAux,
														urlConfig);
											}

											// Actualizamos el estado a En
											// curso
											// nuevamente
											parteTecGmaoAux
													.setEstadoGmao(estadoMovil);
											parteTecGmaoAux
													.setFechaEstadoGmao(fechaEstado);

											parteTecGmaoAux = this.partetecnicosgmaoServices
													.update(parteTecGmaoAux);

										}
									}
								}
							}

						}

					} else {
						if (parteTecGmaoAux.getEstadoGmao() == null) {
							parteTecGmaoAux.setEstadoGmao(estadoMovil);
							parteTecGmaoAux.setFechaEstadoGmao(fechaEstado);

							parteTecGmaoAux = this.partetecnicosgmaoServices
									.update(parteTecGmaoAux);
						}
					}
				}
			}

		} else {

		}

	}

	private void finalizarParteCorrectivoMovilgmao(
			Partetecnicosgmao partetecnicosgmaoAux, String urlConfig) {

		Partes parte = this.partesService.finalizarParte(partetecnicosgmaoAux
				.getIdparte());

		// Finalizar parte en MovilGmao

		JSONObject ot = new JSONObject();
		ot.put("UUIdOt", "{" + partetecnicosgmaoAux.getGuidpartetecgmao() + "}");
		String respuestaOT = "";
		respuestaOT = this.procesosJMSService.bajarOtByGUID(ot, urlConfig
				+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

		JSONObject respOt = new JSONObject(respuestaOT);
		JSONArray ots = new JSONArray();
		ots = respOt.getJSONArray("ots");
		JSONObject datosJson = new JSONObject();
		if (ots.length() > 0) {
			DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			JSONObject otmod = new JSONObject();

			JSONArray operarios = new JSONArray();
			operarios = respOt.getJSONArray("operarios");
			JSONArray otmods = new JSONArray();
			otmods = respOt.getJSONArray("otmod");
			JSONArray documentos = new JSONArray();
			documentos = respOt.getJSONArray("documentos");
			JSONArray campos = new JSONArray();
			campos = respOt.getJSONArray("campos");

			/**
			 * Comprobamos si tiene ejecuciones para subirlas a movilgmao
			 */
			Parteejecucion parteEjecucionAux = new Parteejecucion();
			parteEjecucionAux.setIdpartec(partetecnicosgmaoAux.getIdpartec());
			List<Parteejecucion> partesEjecucionTecnico = this.parteejecucionServices
					.findAll(parteEjecucionAux, null);

			for (Parteejecucion parteejec : partesEjecucionTecnico) {
				if (parteejec != null && parteejec.getFeini() != null
						&& parteejec.getFefin() != null) {
					String fechaInicioModJson = df.format(parteejec.getFeini());
					String fechaFinModJson = df.format(parteejec.getFefin());
					otmod = new JSONObject();
					otmod.put("IdOperario", partetecnicosgmaoAux.getIdtecnico());
					otmod.put("IdHora", "HN");
					otmod.put("Fecha", fechaInicioModJson);
					otmod.put("QReal", 0);
					otmod.put("QVenta", 0);
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					otmod.put("UUIdOtMod", randomUUIDString);
					otmod.put("UUIdOt",
							"{" + partetecnicosgmaoAux.getGuidpartetecgmao()
									+ "}");
					otmod.put("HoraInicio", fechaInicioModJson);
					otmod.put("HoraFin", fechaFinModJson);
					otmods.put(otmod);
				}
			}

			datosJson.put("ots", ots);
			if (operarios.length() > 0) {
				datosJson.put("operarios", operarios);
			} else {
				datosJson.put("operarios", JSONObject.NULL);
			}
			if (documentos.length() > 0) {
				datosJson.put("documentos", documentos);
			} else {
				datosJson.put("documentos", JSONObject.NULL);
			}
			datosJson.put("campos", campos);
			if (otmods.length() > 0) {
				datosJson.put("otmod", otmods);
			}

			this.procesosJMSService
					.sincronizarGmao(
							datosJson,
							urlConfig
									+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SubirOTs/");

		}

		/*
		 * parte = new Partes();
		 * parte.setIdparte(partetecnicosgmaoAux.getIdparte()); parte =
		 * this.partesService.find(parte); if (parte != null &&
		 * parte.getGuidparte() != null) { Edificios edificioAux = new
		 * Edificios(); if (parte.getIdedificio() != null) { edificioAux =
		 * this.edificiosService.obtenerEdificio(parte .getIdedificio()); } if
		 * (edificioAux != null && edificioAux.getGuidedificio() != null) {
		 * 
		 * if (parte.getIddepar() != null) { Departamentos departamentoAux = new
		 * Departamentos(); departamentoAux.setIddepar(parte.getIddepar());
		 * departamentoAux = this.departamentosService .find(departamentoAux);
		 * parte.setDepartamento(departamentoAux); }
		 * 
		 * if (parte.getIddir() != null) { Direcciones direccionAux = new
		 * Direcciones(); direccionAux.setIddir(parte.getIddir()); direccionAux
		 * = this.direccionesService.find(direccionAux);
		 * parte.setDireccion(direccionAux); }
		 * 
		 * if (parte.getIdplanta() != null) { Plantas plantaAux = new Plantas();
		 * plantaAux.setIdplanta(parte.getIdplanta()); plantaAux =
		 * this.plantasService.find(plantaAux); parte.setPlanta(plantaAux); }
		 * 
		 * if (parte.getIdzona() != null) { Zonas zonaAux = new Zonas();
		 * zonaAux.setIdzona(parte.getIdzona()); zonaAux =
		 * this.zonasService.find(zonaAux); parte.setZona(zonaAux);
		 * 
		 * }
		 * 
		 * if (parte.getIdespacio() != null) { Espacio espacioAux = new
		 * Espacio(); espacioAux.setIdespacio(parte.getIdespacio()); espacioAux
		 * = this.espaciosService.find(espacioAux);
		 * parte.setEspacio(espacioAux); }
		 * 
		 * this.procesosJMSService.sincronizarParteCorrectivoGmao(parte, null,
		 * edificioAux.getGuidedificio(), null, urlConfig); } }
		 */
	}

	private void tratamientoFirmaParteCorrectivo(JSONObject ot,
			Partetecnicosgmao partetecnicosgmaoAux) {

		String firmaConformidad = "";
		if (ot.get("FirmaConformidad") != JSONObject.NULL) {
			firmaConformidad = ot.getString("FirmaConformidad");

			Partefirma partefirmaAux = new Partefirma();
			partefirmaAux.setIdparte(partetecnicosgmaoAux.getIdparte());
			partefirmaAux.setIdtecnico(Integer.valueOf(partetecnicosgmaoAux
					.getIdtecnico().toString()));
			partefirmaAux.setIdpartec(partetecnicosgmaoAux.getIdpartec());

			Partefirma partefirmaExiste = new Partefirma();
			partefirmaExiste = this.partefirmaService.find(partefirmaAux);

			byte[] blobAsBytes = null;
			boolean insertarFirma = false;
			if (partefirmaExiste != null) {
				try {
					// Tiene firma
					int blobLeng = (int) partefirmaExiste.getFirma().length();
					if (blobLeng != 0) {
						blobAsBytes = partefirmaExiste.getFirma().getBytes(1,
								blobLeng);
					} else {
						insertarFirma = true;

					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			} else {
				insertarFirma = true;

			}

			if (insertarFirma) {
				// Si no tiene la firma, la insertamos
				firmaConformidad = firmaConformidad.substring(22);
				// data:image/png;base64,

				byte[] firmaByteArray = Base64.decodeBase64(firmaConformidad
						.getBytes());

				partefirmaAux.setFirmaArray(firmaByteArray);
				partefirmaAux = this.partefirmaService.add(partefirmaAux);
			}

		}
	}

	private void tratamientoOperariosPartePreventivo(JSONArray operarios,
			Fichatecnico fichatecnicosAux,
			Fichatecnicosgmao fichatecnicosgmaoAux, String guidpartehija,
			String tecnicoResponsable) {

		if (fichatecnicosAux != null
				&& fichatecnicosAux.getIdtecnico() != null
				&& !fichatecnicosAux.getIdtecnico().toString()
						.equalsIgnoreCase(tecnicoResponsable)) {
			// Si no coincide y tiene tecnicoResponsable desde movilgmao
			// significa que ha cambiado de operario
			if (!tecnicoResponsable.equals("")) {
				fichatecnicosAux.setIdtecnico(Long.valueOf(tecnicoResponsable));
				fichatecnicosgmaoAux.setIdtecnico(Long
						.valueOf(tecnicoResponsable));
				fichatecnicosAux = this.fichatecnicosService
						.update(fichatecnicosAux);
			} else {
				// Si tecnicoResponsable es blanco significa que se ha quedado
				// sin asignar. Eliminamos de la tabla ficha tecnicos el
				// registro
				fichatecnicosgmaoAux.setIdtecnico(null);
				fichatecnicosgmaoAux.setIdfichac(null);
				fichatecnicosgmaoAux.setEstadoGmao(null);
				this.fichatecnicosService.eliminaTecnicoFicha(fichatecnicosAux);
			}
			fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
					.update(fichatecnicosgmaoAux);

		}

		/*
		 * for (int y = 0; y < operarios.length(); y++) { JSONObject otoperario
		 * = operarios.getJSONObject(y); if (otoperario != null &&
		 * otoperario.get("UUIdOt") != JSONObject.NULL &&
		 * otoperario.getString("UUIdOt").equalsIgnoreCase( guidpartehija)) {
		 * 
		 * // Comprobamos si ha cambiado de operario // desde el planner o app
		 * String idOperarioOT = ""; if (otoperario.get("IdOperario") !=
		 * JSONObject.NULL) { idOperarioOT = otoperario.getString("IdOperario");
		 * 
		 * if (fichatecnicosAux != null && fichatecnicosAux.getIdtecnico() !=
		 * null && !fichatecnicosAux.getIdtecnico().toString()
		 * .equalsIgnoreCase(idOperarioOT)) { // Si no coincide significa que ha
		 * // cambiado de operario fichatecnicosAux.setIdtecnico(Long
		 * .valueOf(idOperarioOT));
		 * 
		 * fichatecnicosgmaoAux.setIdtecnico(Long .valueOf(idOperarioOT));
		 * 
		 * fichatecnicosAux = this.fichatecnicosService
		 * .update(fichatecnicosAux);
		 * 
		 * fichatecnicosgmaoAux = this.fichatecnicosgmaoServices
		 * .update(fichatecnicosgmaoAux); }
		 * 
		 * } } }
		 */
	}

	private void tratamientoRevisionesPartePreventivo(JSONArray revisiones,
			Ficha fichaAux, Fichatecnicosgmao fichatecnicosgmaoAux,
			Maquinas maquinaAux, Gamas gamaAux, String fechaSinc,
			String guidpartehija, SimpleDateFormat sdf) {

		for (int x = 0; x < revisiones.length(); x++) {
			JSONObject revision = revisiones.getJSONObject(x);
			if (revision != null
					&& revision.get("UUIdOt") != JSONObject.NULL
					&& revision.getString("UUIdOt").equalsIgnoreCase(
							guidpartehija)) {
				String idCuestionario = "";
				if (revision.get("IdPunto") != JSONObject.NULL) {
					idCuestionario = revision.getString("IdPunto");

					String valorRev = "";
					if (revision.get("Valor") != JSONObject.NULL) {
						valorRev = revision.getString("Valor");
					}

					Actuacion actuacionAux = new Actuacion();
					// Se comprueba si se trata de los
					// puntos de
					// observaciones (txt)
					// en ese caso se trata directamente con
					// los
					// otros puntos x++
					// y tiene que saltar para que no falle
					// la
					// búsqueda por código
					if (!idCuestionario.equals("")
							&& idCuestionario.indexOf("txt") == -1) {
						actuacionAux.setIdcuestionario(Integer
								.valueOf(idCuestionario));

						actuacionAux.setIdficha(fichaAux.getIdficha());
						actuacionAux.setIdmaquina(fichaAux.getIdmaquina());
						List<Actuacion> listaActuacionAux = this.actuacionServices
								.findAll(actuacionAux, null);

						Date fechaSincDate = null;
						try {
							fechaSincDate = sdf.parse(fechaSinc);

						} catch (ParseException e) {
							ProcesosGmaoController.logger
									.error("[MOVILGMAO] : bajarOTs - formatear fecha sinc: "
											+ e.getMessage()
											+ "; IdParte: "
											+ fichatecnicosgmaoAux.getIdficha()
											+ "; IdTecnico:"
											+ fichatecnicosgmaoAux
													.getIdtecnico());
						}

						if (!valorRev.equals("")
								&& valorRev.equals("0_CORRECTO")) {
							// Todo correcto

							if (listaActuacionAux.size() == 1) {
								actuacionAux = listaActuacionAux.get(0);

								// Comprobamos si es el
								// último
								// punto
								// de revisión o no
								// Si no lo es se obtienen
								// las
								// observaciones al punto de
								// revisión
								// anterior para guardarlas
								if (revisiones.length() > x) {
									x++;
									revision = revisiones.getJSONObject(x);
									if (revision != null
											&& revision.get("UUIdOt") != JSONObject.NULL
											&& revision.getString("UUIdOt")
													.equalsIgnoreCase(
															guidpartehija)) {
										if (revision.get("Valor") != JSONObject.NULL) {
											actuacionAux
													.setDescripcion(revision
															.getString("Valor"));
										} else {
											actuacionAux.setDescripcion("OK");
										}
									}

								}

								actuacionAux.setFeprevista(fechaSincDate);

								actuacionAux = this.actuacionServices
										.modificaActuacion(actuacionAux);
							}
						} else if (!valorRev.equals("")
								&& !valorRev.equals("0_CORRECTO")) {

							// Hay que crear un parte
							// correctivo
							// con
							// todos los datos
							Partes parteCorrectivo = new Partes();
							boolean actualizarActuacion = true;
							String idCodigo = valorRev.substring(0,
									valorRev.indexOf("_"));

							Integer idActuacion = 0;
							String observacionCorrectivo = "";
							if (listaActuacionAux.size() == 1) {
								actuacionAux = listaActuacionAux.get(0);
								if (idActuacion != null) {
									idActuacion = actuacionAux.getIdactuacion();

									// Se busca si ya tiene
									// parte
									// correctivo creado
									// anteriormente
									if (actuacionAux.getIdparte() != null) {
										// Si ya tiene parte
										// comprobamos que
										// se
										// trata
										// del mismo
										// o el técnico ha
										// cambiado
										// y quiere crear
										// otro
										// parte
										// correctivo
										Partes parteCorrectivoAux = new Partes();
										parteCorrectivoAux
												.setIdparte(actuacionAux
														.getIdparte());
										parteCorrectivoAux = this.partesService
												.findParte(parteCorrectivoAux);

										if (parteCorrectivoAux != null) {
											if (parteCorrectivoAux
													.getIdcodigo() != null
													&& parteCorrectivoAux
															.getIdcodigo()
															.toString()
															.equals(idCodigo)) {
												// Si se
												// trata
												// del
												// mismo no
												// hay
												// que
												// volver a
												// crear el
												// parte
												// correctivo
												actualizarActuacion = false;
											}
										}
									}
									parteCorrectivo.setIdactuac(idActuacion);
								}

								// Comprobamos si es el
								// último
								// punto
								// de revisión o no
								// Si no lo es se obtienen
								// las
								// observaciones al punto de
								// revisión
								// anterior para guardarlas

								if (revisiones.length() > x) {
									x++;
									revision = revisiones.getJSONObject(x);
									if (revision != null
											&& revision.get("UUIdOt") != JSONObject.NULL
											&& revision.getString("UUIdOt")
													.equalsIgnoreCase(
															guidpartehija)) {
										if (revision.get("Valor") != JSONObject.NULL) {
											observacionCorrectivo = revision
													.getString("Valor");
										}
									}

								}
							}

							parteCorrectivo.setIdedificio(maquinaAux
									.getIdedificio());
							parteCorrectivo.setIdzona(maquinaAux.getIdzona());
							parteCorrectivo.setIdplanta(maquinaAux
									.getIdplanta());
							parteCorrectivo.setIdclase(gamaAux.getIdclase());
							parteCorrectivo.setIdcodigo(Integer
									.valueOf(idCodigo));

							parteCorrectivo.setIdmaquina(fichaAux
									.getIdmaquina());

							parteCorrectivo.setObserv(observacionCorrectivo);

							if (actualizarActuacion) {
								Partes parteAux = this.partesService
										.nuevoParteCorrDesdePreventivo(parteCorrectivo);

								actuacionAux.setFeprevista(fechaSincDate);
								actuacionAux
										.setDescripcion(observacionCorrectivo);
								actuacionAux = this.actuacionServices
										.modificaActuacion(actuacionAux);

								/**
								 * Mandar a MovilGmao
								 */

								String urlConfig = "";
								String respuesta = "";
								try {
									urlConfig = this.appConfiguration
											.getObject().getProperty(
													"movilgmao.path");
								} catch (Exception e) {

								}

								/**
								 * Hay que mandar el parte igualmente a
								 * movilgmao para ser gestionado desde el
								 * planner. Creamos un registro en la tabla que
								 * guarda el idficha y guidgmao sin técnico
								 */
								Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
								tecnicoParteGmaoAux.setIdparte(parteAux
										.getIdparte());
								String randomUUIDString = "";
								UUID uuid = UUID.randomUUID();
								randomUUIDString = uuid.toString();
								tecnicoParteGmaoAux
										.setGuidpartetecgmao(randomUUIDString);

								tecnicoParteGmaoAux = this.partetecnicosgmaoServices
										.add(tecnicoParteGmaoAux);

								if (parteAux != null) {
									String idEdificio = parteAux
											.getIdedificio();

									Edificios edifAux = new Edificios();
									edifAux = this.edificiosService
											.obtenerEdificio(idEdificio);

									if (parteAux.getIddepar() != null) {
										Departamentos departamentoAux = new Departamentos();
										departamentoAux.setIddepar(parteAux
												.getIddepar());
										departamentoAux = this.departamentosService
												.find(departamentoAux);
										parteAux.setDepartamento(departamentoAux);
									}

									if (parteAux.getIddir() != null) {
										Direcciones direccionAux = new Direcciones();
										direccionAux.setIddir(parteAux
												.getIddir());
										direccionAux = this.direccionesService
												.find(direccionAux);
										parteAux.setDireccion(direccionAux);
									}

									if (parteAux.getIdplanta() != null) {
										Plantas plantaAux = new Plantas();
										plantaAux.setIdplanta(parteAux
												.getIdplanta());
										plantaAux = this.plantasService
												.find(plantaAux);
										parteAux.setPlanta(plantaAux);
									}

									if (parteAux.getIdzona() != null) {
										Zonas zonaAux = new Zonas();
										zonaAux.setIdzona(parteAux.getIdzona());
										zonaAux = this.zonasService
												.find(zonaAux);
										parteAux.setZona(zonaAux);

									}

									if (parteAux.getIdespacio() != null) {
										Espacio espacioAux = new Espacio();
										espacioAux.setIdespacio(parteAux
												.getIdespacio());
										espacioAux = this.espaciosService
												.find(espacioAux);
										parteAux.setEspacio(espacioAux);
									}

									// Obtener tecnicos asignados al parte
									// (partetecnicos)
									List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
											.findAll(tecnicoParteGmaoAux, null);

									respuesta = this.procesosJMSService
											.sincronizarParteCorrectivoGmao(
													parteAux,
													parteTecnicosGmao,
													edifAux.getGuidedificio(),
													null, null, urlConfig);

									if (respuesta != null
											&& respuesta.equals("OK")) {
										ProcesosGmaoController.logger
												.info("[MOVILGMAO] : Creacion parte correctivo desde preventivo en gmao : "
														+ respuesta);
									} else {
										ProcesosGmaoController.logger
												.error("[MOVILGMAO] : Creacion parte correctivo desde preventivo en gmao: "
														+ respuesta);
									}

								}
							}
						}
					}
				}
			}
		}
	}

	private void tratamientoModsPartePreventivo(JSONArray otmods,
			Fichaejecucion fichaEjecucionAux, Fichatecnico fichatecnicosAux,
			Fichatecnicosgmao fichatecnicosgmaoAux,
			List<Fichaejecucion> fichasEjecucionTecnico, String guidpartehija,
			SimpleDateFormat sdf) {
		// boolean comprobarCambioEstadoPreventiva = true;
		for (int z = 0; z < otmods.length(); z++) {
			// comprobarCambioEstadoPreventiva = false;
			JSONObject otmod = otmods.getJSONObject(z);
			if (otmod != null
					&& otmod.get("UUIdOt") != JSONObject.NULL
					&& otmod.getString("UUIdOt")
							.equalsIgnoreCase(guidpartehija)) {

				fichaEjecucionAux = new Fichaejecucion();
				/*
				 * String idHora = ""; if (otmod.get("IdHora") != null) { idHora
				 * = otmod.getString("IdHora"); }
				 */
				String fechaEjecInicio = "";
				String fechaEjecFin = "";

				if (otmod.get("HoraInicio") != JSONObject.NULL) {
					fechaEjecInicio = otmod.getString("HoraInicio");
				}
				if (otmod.get("HoraFin") != JSONObject.NULL) {
					fechaEjecFin = otmod.getString("HoraFin");
				}

				Date fechaEjecInicioDate = null;
				Date fechaEjecFinDate = null;
				try {
					fechaEjecInicioDate = sdf.parse(fechaEjecInicio);
					fechaEjecFinDate = sdf.parse(fechaEjecFin);
				} catch (ParseException e) {
					ProcesosGmaoController.logger
							.error("[MOVILGMAO] : bajarOTs - formatear fecha ejec: "
									+ e.getMessage()
									+ "; IdParte: "
									+ fichatecnicosgmaoAux.getIdficha()
									+ "; IdTecnico:"
									+ fichatecnicosgmaoAux.getIdtecnico());
				}

				// Comprobamos si ya existe esta ejecucion
				// en la
				// tabla
				// para no duplicarla
				boolean existeEjec = false;
				for (Fichaejecucion fichaEjec : fichasEjecucionTecnico) {
					if (fechaEjecInicioDate.compareTo(fichaEjec.getFeini()) == 0
							&& fechaEjecFinDate.compareTo(fichaEjec.getFefin()) == 0) {
						existeEjec = true;
						break;
					}
				}
				if (!existeEjec) {
					fichaEjecucionAux.setIdfitec(fichatecnicosgmaoAux
							.getIdfichac());
					fichaEjecucionAux.setFeini(fechaEjecInicioDate);
					fichaEjecucionAux.setFefin(fechaEjecFinDate);

					fichaEjecucionAux = this.fichaejecucionServices
							.add(fichaEjecucionAux);
				}

			}

			this.fichaejecucionServices
					.recalcularTiempoFichaTecnico(fichatecnicosgmaoAux
							.getIdfichac());

			// Refrescamos el objeto con la información
			// actualizada
			// de la ficha técnico
			fichatecnicosAux = this.fichatecnicosService
					.obtenerFicha(fichatecnicosgmaoAux.getIdfichac());

			// Puede ser que no la haya aceptado en la
			// aplicación
			// móvil
			// y haya
			// metido ejecuciones. En ese caso la marcamos
			// como
			// aceptada
			if (fichatecnicosAux != null
					&& ((fichatecnicosAux.getAceptada() != null && !fichatecnicosAux
							.getAceptada().equals("1")) || fichatecnicosAux
							.getAceptada() == null)) {
				fichatecnicosAux.setAceptada("1");
				fichatecnicosAux = this.fichatecnicosService
						.update(fichatecnicosAux);
			}
		}

		// return comprobarCambioEstadoPreventiva;
	}

	private void tratamientoCambioEstadosPartePreventivo(JSONArray logs,
			Fichaejecucion fichaEjecucionAux, String guidpartehijaFormateado,
			SimpleDateFormat sdf, String urlConfig) {

		if (logs.length() > 0) {
			int contadorPausasAnt = 0;
			boolean terminar = false;
			List<OtLogGmao> valoresEstados = new ArrayList<OtLogGmao>();
			for (int x = 0; x < logs.length(); x++) {
				JSONObject log = logs.getJSONObject(x);

				// Si el tipo de log es 2, significa que
				// es
				// de cambio de
				// estado
				OtLogGmao otLogObj = new OtLogGmao();
				if (log.get("TipoLog") != JSONObject.NULL
						&& log.getString("TipoLog").equals("2")
						&& log.get("UUIdOt") != JSONObject.NULL
						&& log.getString("UUIdOt").equalsIgnoreCase(
								"{" + guidpartehijaFormateado + "}")) {

					String uuIdOt = "";
					if (log.get("UUIdOt") != JSONObject.NULL) {
						uuIdOt = log.getString("UUIdOt").replace("{", "");
						uuIdOt = uuIdOt.replace("}", "");
						uuIdOt = uuIdOt.toLowerCase();
						otLogObj.setuUIdOt(uuIdOt);
					}

					String estadoMovil = "";
					if (log.get("CampoIdParaFiltro") != JSONObject.NULL) {
						estadoMovil = log.getString("CampoIdParaFiltro");
						otLogObj.setCampoIdParaFiltro(estadoMovil);
						if (estadoMovil.equals("PAUSA")) {
							contadorPausasAnt++;
						} else if (estadoMovil.equals("TERM")) {
							terminar = true;
						}
					}
					String fecha = "";

					if (log.get("FechaLocal") != JSONObject.NULL) {
						fecha = log.getString("FechaLocal");
						otLogObj.setFecha(fecha);

					}

					String valorAnterior = "";
					if (log.get("ValorAnterior") != JSONObject.NULL) {
						valorAnterior = log.getString("ValorAnterior");

						otLogObj.setValorAnterior(valorAnterior);
					}
					valoresEstados.add(otLogObj);
				}
			}
			int contador = 0;
			int contadorPausas = 0;
			for (OtLogGmao estadoGmao : valoresEstados) {

				if (estadoGmao != null) {
					String uuIdOt = estadoGmao.getuUIdOt();
					Fichatecnicosgmao fichaTecGmaoAux = new Fichatecnicosgmao();
					fichaTecGmaoAux.setGuidfichatecgmao(uuIdOt);
					fichaTecGmaoAux = this.fichatecnicosgmaoServices
							.findByGUID(fichaTecGmaoAux);

					String valorAnterior = estadoGmao.getValorAnterior();
					String estadoMovil = "";
					if (estadoGmao.getCampoIdParaFiltro() != null) {
						estadoMovil = estadoGmao.getCampoIdParaFiltro();
					}
					Date fechaEstado = null;
					if (estadoGmao.getFecha() != null) {
						try {
							fechaEstado = sdf.parse(estadoGmao.getFecha());

						} catch (ParseException e) {
							ProcesosGmaoController.logger
									.error("[MOVILGMAO] : bajarOTs - formatear fecha estado: "
											+ e.getMessage());
						}
					}

					if (valorAnterior != null) {
						// Significa que ha cambiado
						// de estado

						/**
						 * Si el estado ya es Terminado no hacemos nada
						 */
						if (fichaTecGmaoAux.getEstadoGmao() == null
								|| (fichaTecGmaoAux.getEstadoGmao() != null && !fichaTecGmaoAux
										.getEstadoGmao()
										.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO))) {

							/**
							 * Comprobamos si la fecha del estado que viene
							 * informada es anterior a la última que hemos
							 * registrado Si es menor, ya hemos actualizado ese
							 * estado y no hacemos nada
							 */
							if (fichaTecGmaoAux.getFechaEstadoGmao() == null
									|| (fichaTecGmaoAux.getFechaEstadoGmao() != null && fechaEstado
											.compareTo(fichaTecGmaoAux
													.getFechaEstadoGmao()) == 1)) {

								if (valorAnterior.equals("ASIG")
										&& valorAnterior.equals(fichaTecGmaoAux
												.getEstadoGmao())) {
									if (estadoMovil.equals("CURS")
											|| estadoMovil.equals("PAUSA")) {

										fichaTecGmaoAux
												.setEstadoGmao(estadoMovil);
										fichaTecGmaoAux
												.setFechaEstadoGmao(fechaEstado);

										if (estadoMovil.equals("CURS")) {
											// Comprobamos que no tenga otro
											// parte ya en
											// curso para pausarlo
											this.comprobrarPartesPreventivosEnCurso(
													fichaTecGmaoAux, urlConfig);

											/**
											 * Comprobamos en partes correctivos
											 */
											Partetecnicosgmao parteTecGmaoAux = new Partetecnicosgmao();
											parteTecGmaoAux
													.setIdtecnico(fichaTecGmaoAux
															.getIdtecnico());
											this.comprobrarPartesCorrectivosEnCurso(
													parteTecGmaoAux, urlConfig);
										}

										fichaTecGmaoAux = this.fichatecnicosgmaoServices
												.update(fichaTecGmaoAux);

									} else if (estadoMovil.equals("TERM")) {
										// Actualizamos el
										// estado y fecha
										fichaTecGmaoAux
												.setEstadoGmao(estadoMovil);
										fichaTecGmaoAux
												.setFechaEstadoGmao(fechaEstado);

										fichaTecGmaoAux = this.fichatecnicosgmaoServices
												.update(fichaTecGmaoAux);
									}
								} else if (valorAnterior.equals("CURS")
										&& valorAnterior.equals(fichaTecGmaoAux
												.getEstadoGmao())) {

									// Comprobamos si es Pausa, que sea la
									// última de las
									// pausas de todo
									// el array de estados
									if ((estadoMovil.equals("PAUSA") && ((contadorPausas + 1) == contadorPausasAnt))
											|| estadoMovil.equals("TERM")) {
										// Obtenemos fecha del estado en curso
										Date fechaEnCurso = null;
										if (fichaTecGmaoAux
												.getFechaEstadoGmao() != null) {
											fechaEnCurso = fichaTecGmaoAux
													.getFechaEstadoGmao();
										}

										// Comprobamos si el estado nuevo es
										// Terminado,
										// para evitar que al recorrer todos los
										// estados vuelva a entrar por Pausa
										if (fechaEnCurso.compareTo(fechaEstado) == -1
												&& ((estadoMovil
														.equals("PAUSA") && !terminar) || (estadoMovil
														.equals("TERM") && terminar))) {
											// Obtenemos las ejecuciones de este
											// tecnico
											// en
											// el parte
											Fichaejecucion fichaEjecucionLogAux = new Fichaejecucion();
											fichaEjecucionLogAux
													.setIdfitec(fichaTecGmaoAux
															.getIdfichac());
											List<Fichaejecucion> fichasEjecucionLogTecnico = this.fichaejecucionServices
													.findAll(
															fichaEjecucionLogAux,
															null);

											// Comprobamos si ya
											// existe esta
											// ejecucion
											// en la
											// tabla
											// para no
											// duplicarla
											boolean existeEjec = false;
											for (Fichaejecucion fichaEjec : fichasEjecucionLogTecnico) {
												if (fechaEnCurso
														.compareTo(fichaEjec
																.getFeini()) == 0
														&& fechaEstado
																.compareTo(fichaEjec
																		.getFefin()) == 0) {
													existeEjec = true;
													break;
												}
											}
											if (!existeEjec) {
												fichaEjecucionLogAux
														.setIdfitec(fichaTecGmaoAux
																.getIdfichac());
												fichaEjecucionLogAux
														.setFeini(fechaEnCurso);
												fichaEjecucionLogAux
														.setFefin(fechaEstado);

												fichaEjecucionLogAux = this.fichaejecucionServices
														.add(fichaEjecucionLogAux);

												this.fichaejecucionServices
														.recalcularTiempoFichaTecnico(fichaTecGmaoAux
																.getIdfichac());
											}

											// Actualizamos el
											// estado y fecha
											fichaTecGmaoAux
													.setEstadoGmao(estadoMovil);
											fichaTecGmaoAux
													.setFechaEstadoGmao(fechaEstado);

											fichaTecGmaoAux = this.fichatecnicosgmaoServices
													.update(fichaTecGmaoAux);
										}

									}
								} else if (valorAnterior.equals("PAUSA")) {
									contadorPausas++;
									if (valorAnterior.equals(fichaTecGmaoAux
											.getEstadoGmao())) {
										contador++;
										if (estadoMovil.equals("CURS")
												|| estadoMovil.equals("TERM")) {

											if (contadorPausasAnt == contador) {
												// Obtenemos fecha del estado en
												// pausa
												Date fechaEnPausa = null;
												if (fichaTecGmaoAux
														.getFechaEstadoGmao() != null) {
													fechaEnPausa = fichaTecGmaoAux
															.getFechaEstadoGmao();
												}

												// Sumamos el tiempo en pausa al
												// campo
												// tiempopausa
												Integer tiempoPausa = 0;
												if (fichaTecGmaoAux
														.getTiempoPausaGmao() != null) {
													tiempoPausa = fichaTecGmaoAux
															.getTiempoPausaGmao();
												}
												Calendar calFechaIniPausa = Calendar
														.getInstance();
												Calendar calFechaFinPausa = Calendar
														.getInstance();
												calFechaIniPausa
														.setTime(fechaEnPausa);
												calFechaFinPausa
														.setTime(fechaEstado);
												Long totalMinutos = ((calFechaFinPausa
														.getTimeInMillis() - calFechaIniPausa
														.getTimeInMillis()) / 1000 / 60);

												if (totalMinutos != 0) {
													tiempoPausa = tiempoPausa
															+ totalMinutos
																	.intValue();

													fichaTecGmaoAux
															.setTiempoPausaGmao(tiempoPausa);
													this.fichatecnicosgmaoServices
															.actualizarTiempoPausaFicha(fichaTecGmaoAux);
												}

												if (estadoMovil.equals("CURS")) {
													// Comprobamos que no tenga
													// otro
													// parte ya en
													// curso para pausarlo
													this.comprobrarPartesPreventivosEnCurso(
															fichaTecGmaoAux,
															urlConfig);

													/**
													 * Comprobamos en partes
													 * correctivos
													 */
													Partetecnicosgmao parteTecGmaoAux = new Partetecnicosgmao();
													parteTecGmaoAux
															.setIdtecnico(fichaTecGmaoAux
																	.getIdtecnico());
													this.comprobrarPartesCorrectivosEnCurso(
															parteTecGmaoAux,
															urlConfig);
												}

												// Actualizamos el estado a En
												// curso
												// nuevamente
												fichaTecGmaoAux
														.setEstadoGmao(estadoMovil);
												fichaTecGmaoAux
														.setFechaEstadoGmao(fechaEstado);

												fichaTecGmaoAux = this.fichatecnicosgmaoServices
														.update(fichaTecGmaoAux);
											}
										}
									}

								}

							}

						}

					} else {
						if (fichaTecGmaoAux.getEstadoGmao() == null) {
							fichaTecGmaoAux.setEstadoGmao(estadoMovil);
							fichaTecGmaoAux.setFechaEstadoGmao(fechaEstado);

							fichaTecGmaoAux = this.fichatecnicosgmaoServices
									.update(fichaTecGmaoAux);
						}
					}
				}
			}

		}
	}

	private void finalizarPartePreventivoMovilgmao(
			Fichatecnicosgmao fichatecnicosgmaoAux, Maquinas maquinaAux,
			String urlConfig) {

		Ficha ficha = this.fichasService.finalizarFicha(fichatecnicosgmaoAux
				.getIdficha());

		// Finalizar parte en MovilGmao

		JSONObject ot = new JSONObject();
		ot.put("UUIdOt", "{" + fichatecnicosgmaoAux.getGuidfichatecgmao() + "}");
		String respuestaOT = "";
		respuestaOT = this.procesosJMSService.bajarOtByGUID(ot, urlConfig
				+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

		JSONObject respOt = new JSONObject(respuestaOT);
		JSONArray ots = new JSONArray();
		ots = respOt.getJSONArray("ots");
		JSONObject datosJson = new JSONObject();
		if (ots.length() > 0) {
			DateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			JSONObject otmod = new JSONObject();

			JSONArray operarios = new JSONArray();
			operarios = respOt.getJSONArray("operarios");
			JSONArray otmods = new JSONArray();
			otmods = respOt.getJSONArray("otmod");
			JSONArray campos = new JSONArray();
			campos = respOt.getJSONArray("campos");
			JSONArray revisiones = new JSONArray();
			revisiones = respOt.getJSONArray("revisiones");

			/**
			 * Comprobamos si tiene ejecuciones para subirlas a movilgmao
			 */
			Fichaejecucion fichaEjecucionAux = new Fichaejecucion();
			fichaEjecucionAux.setIdfitec(fichatecnicosgmaoAux.getIdfichac());
			List<Fichaejecucion> fichasEjecucionTecnico = this.fichaejecucionServices
					.findAll(fichaEjecucionAux, null);

			for (Fichaejecucion fichaejec : fichasEjecucionTecnico) {
				if (fichaejec != null && fichaejec.getFeini() != null
						&& fichaejec.getFefin() != null) {
					String fechaInicioModJson = df.format(fichaejec.getFeini());
					String fechaFinModJson = df.format(fichaejec.getFefin());
					otmod = new JSONObject();
					otmod.put("IdOperario", fichatecnicosgmaoAux.getIdtecnico());
					otmod.put("IdHora", "HN");
					otmod.put("Fecha", fechaInicioModJson);
					otmod.put("QReal", 0);
					otmod.put("QVenta", 0);
					String randomUUIDString = "";
					UUID uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					otmod.put("UUIdOtMod", randomUUIDString);
					otmod.put("UUIdOt",
							"{" + fichatecnicosgmaoAux.getGuidfichatecgmao()
									+ "}");
					otmod.put("HoraInicio", fechaInicioModJson);
					otmod.put("HoraFin", fechaFinModJson);
					otmods.put(otmod);
				}
			}

			datosJson.put("ots", ots);
			if (operarios.length() > 0) {
				datosJson.put("operarios", operarios);
			} else {
				datosJson.put("operarios", JSONObject.NULL);
			}
			if (revisiones.length() > 0) {
				datosJson.put("revisiones", revisiones);
			} else {
				datosJson.put("revisiones", JSONObject.NULL);
			}
			datosJson.put("campos", campos);
			if (otmods.length() > 0) {
				datosJson.put("otmod", otmods);
			}

			this.procesosJMSService
					.sincronizarGmao(
							datosJson,
							urlConfig
									+ "Expertis_Sync_Movil_JS/index.php/sync/masters/SubirOTs/");

		}
	}

	private void tratamientoFirmaPartePreventivo(JSONObject ot,
			Fichatecnicosgmao fichatecnicosgmaoAux) {

		String firmaConformidad = "";
		if (ot.get("FirmaConformidad") != JSONObject.NULL) {
			firmaConformidad = ot.getString("FirmaConformidad");

			Fichafirma fichafirmaAux = new Fichafirma();
			fichafirmaAux.setIdficha(fichatecnicosgmaoAux.getIdficha());
			fichafirmaAux.setIdtecnico(Integer.valueOf(fichatecnicosgmaoAux
					.getIdtecnico().toString()));
			fichafirmaAux.setIdfitec(fichatecnicosgmaoAux.getIdfichac());

			Fichafirma fichafirmaExiste = new Fichafirma();
			fichafirmaExiste = this.fichafirmaService.find(fichafirmaExiste);

			byte[] blobAsBytes = null;
			boolean insertarFirma = false;
			if (fichafirmaExiste != null) {
				try {
					// Tiene firma
					int blobLeng = (int) fichafirmaExiste.getFirma().length();
					if (blobLeng != 0) {
						blobAsBytes = fichafirmaExiste.getFirma().getBytes(1,
								blobLeng);
					} else {
						insertarFirma = true;

					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			} else {
				insertarFirma = true;

			}

			if (insertarFirma) {
				// Si no tiene la firma, la insertamos
				firmaConformidad = firmaConformidad.substring(22);
				// data:image/png;base64,

				byte[] firmaByteArray = Base64.decodeBase64(firmaConformidad
						.getBytes());

				fichafirmaAux.setFirmaArray(firmaByteArray);
				fichafirmaAux = this.fichafirmaService.add(fichafirmaAux);
			}

		}
	}

	private void tratamientoPausarPartesTecnicosLoginLogout(
			Tecnicos tecnicoAux, String estadoBusq, String pausaAuto,
			String estadoNuevo, boolean pausar, String urlConfig) {

		String respuesta = "";
		Partetecnicosgmao parteTecGmaoAux = new Partetecnicosgmao();
		parteTecGmaoAux.setIdtecnico(tecnicoAux.getIdtecnico());
		parteTecGmaoAux.setEstadoGmao(estadoBusq);
		if (pausaAuto != null && pausaAuto.equals("1")) {
			parteTecGmaoAux.setPausaAutoGmao(pausaAuto);
		}
		List<Partetecnicosgmao> listaPartesEnCurso = this.partetecnicosgmaoServices
				.findAll(parteTecGmaoAux, null);

		if (listaPartesEnCurso.size() > 0) {
			// Significa que el técnico ha hecho
			// logout y tiene algún parte en
			// curso
			for (Partetecnicosgmao parteTec : listaPartesEnCurso) {
				if (parteTec != null) {
					if (parteTec.getGuidpartetecgmao() != null) {

						// Si el parte no esta finalizado
						if (parteTec.getEstadoGmao() == null
								|| (!parteTec.getEstadoGmao().equals("TERM"))) {

							JSONObject ot = new JSONObject();
							ot.put("UUIdOt",
									"{" + parteTec.getGuidpartetecgmao() + "}");
							String respuestaOT = "";
							respuestaOT = this.procesosJMSService
									.bajarOtByGUID(
											ot,
											urlConfig
													+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

							if (respuestaOT != null
									&& !respuestaOT
											.equals(Aa20bConstantes.ERROR_500)) {

								JSONObject resp = new JSONObject(respuestaOT);

								JSONArray ots = new JSONArray();
								ots = resp.getJSONArray("ots");

								if (ots.length() > 0) {
									JSONObject otDescargada = ots
											.getJSONObject(0);

									/**
									 * Comprobamos que el estado no haya
									 * cambiado y siga siendo En curso
									 */
									String idEstadoOT = "";
									if (otDescargada.get("IdEstado") != JSONObject.NULL) {
										idEstadoOT = otDescargada
												.getString("IdEstado");

										if (idEstadoOT.equals(estadoBusq)) {
											/**
											 * Cambiamos el estado de la OT a
											 * pausa
											 */
											respuesta = this.procesosJMSService
													.subirOTcambioEstado(
															parteTec.getGuidpartetecgmao(),
															estadoNuevo,
															urlConfig);

											if (respuesta.equals("OK")) {

												/**
												 * Marcamos en la tabla que se
												 * ha pausado automaticamente
												 */
												Date fechaAct = new Date();
												if (pausar) {

													/**
													 * Al forzar el cambio de
													 * estado de En curso a
													 * Pausa, guardamos la
													 * ejecución para tener el
													 * tiempo que llevaba en
													 * curso
													 */

													Parteejecucion parteEjecucionLogAux = new Parteejecucion();
													parteEjecucionLogAux
															.setIdpartec(parteTec
																	.getIdpartec());
													parteEjecucionLogAux
															.setFeini(parteTec
																	.getFechaEstadoGmao());
													parteEjecucionLogAux
															.setFefin(fechaAct);

													parteEjecucionLogAux = this.parteejecucionServices
															.add(parteEjecucionLogAux);

													this.parteejecucionServices
															.recalcularTiempoParteTecnico(parteTec
																	.getIdpartec());

													parteTec.setPausaAutoGmao("1");
													parteTec.setEstadoGmao("PAUSA");
													parteTec.setFechaEstadoGmao(fechaAct);
												} else {
													// Sumamos el tiempo en
													// pausa al
													// campo
													// tiempopausa
													Integer tiempoPausa = 0;
													if (parteTec
															.getTiempopausaGmao() != null) {
														tiempoPausa = parteTec
																.getTiempopausaGmao();
													}
													Calendar calFechaIniPausa = Calendar
															.getInstance();
													Calendar calFechaFinPausa = Calendar
															.getInstance();
													calFechaIniPausa
															.setTime(parteTec
																	.getFechaEstadoGmao());
													calFechaFinPausa
															.setTime(fechaAct);
													Long totalMinutos = ((calFechaFinPausa
															.getTimeInMillis() - calFechaIniPausa
															.getTimeInMillis()) / 1000 / 60);

													if (totalMinutos != 0) {
														tiempoPausa = tiempoPausa
																+ totalMinutos
																		.intValue();

														parteTec.setTiempopausaGmao(tiempoPausa);
														this.partetecnicosgmaoServices
																.actualizarTiempoPausaParte(parteTec);
													}

													parteTec.setPausaAutoGmao("0");
													parteTec.setEstadoGmao("CURS");
													parteTec.setFechaEstadoGmao(fechaAct);

												}
												parteTec = this.partetecnicosgmaoServices
														.marcarPausaAutoParte(parteTec);

												/**
												 * Se sincroniza la OT nueva
												 * para confirmarla
												 */
												String fechaSinc = "";
												if (otDescargada
														.get("FechaSinc") != JSONObject.NULL) {
													fechaSinc = otDescargada
															.getString("FechaSinc");
												}

												JSONObject pdteSincOtOK = new JSONObject();
												JSONArray valoresOTbajada = new JSONArray();
												JSONObject valorBajada = new JSONObject();
												valorBajada
														.put("UUIdOt",
																parteTec.getGuidpartetecgmao());
												valorBajada.put(
														"FechaUltimaSinc",
														fechaSinc);
												valoresOTbajada
														.put(valorBajada);
												pdteSincOtOK.put("ots",
														valoresOTbajada);
												respuesta = this.procesosJMSService
														.sincronizarGmao(
																pdteSincOtOK,
																urlConfig
																		+ Aa20bConstantes.URL_MARCAR_SINC_OK);
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

		Fichatecnicosgmao fichaTecGmaoAux = new Fichatecnicosgmao();
		fichaTecGmaoAux.setIdtecnico(tecnicoAux.getIdtecnico());
		fichaTecGmaoAux.setEstadoGmao(estadoBusq);
		if (pausaAuto != null && pausaAuto.equals("1")) {
			fichaTecGmaoAux.setPausaAutoGmao(pausaAuto);
		}
		List<Fichatecnicosgmao> listaFichasEnCurso = this.fichatecnicosgmaoServices
				.findAll(fichaTecGmaoAux, null);

		if (listaFichasEnCurso.size() > 0) {
			// Significa que el técnico ha hecho
			// logout y tiene algún parte
			// preventivo en
			// curso
			for (Fichatecnicosgmao fichaTec : listaFichasEnCurso) {
				if (fichaTec != null) {
					if (fichaTec.getGuidfichatecgmao() != null) {

						// Si el parte no esta finalizado
						if (fichaTec.getEstadoGmao() == null
								|| (!fichaTec.getEstadoGmao().equals("TERM"))) {

							JSONObject ot = new JSONObject();
							ot.put("UUIdOt",
									"{" + fichaTec.getGuidfichatecgmao() + "}");
							String respuestaOT = "";
							respuestaOT = this.procesosJMSService
									.bajarOtByGUID(
											ot,
											urlConfig
													+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

							if (respuestaOT != null
									&& !respuestaOT
											.equals(Aa20bConstantes.ERROR_500)) {

								JSONObject resp = new JSONObject(respuestaOT);

								JSONArray ots = new JSONArray();
								ots = resp.getJSONArray("ots");

								if (ots.length() > 0) {
									JSONObject otDescargada = ots
											.getJSONObject(0);

									/**
									 * Comprobamos que el estado no haya
									 * cambiado y siga siendo En curso
									 */
									String idEstadoOT = "";
									if (otDescargada.get("IdEstado") != JSONObject.NULL) {
										idEstadoOT = otDescargada
												.getString("IdEstado");

										if (idEstadoOT.equals(estadoBusq)) {
											/**
											 * Cambiamos el estado de la OT a
											 * pausa
											 */
											respuesta = this.procesosJMSService
													.subirOTcambioEstado(
															fichaTec.getGuidfichatecgmao(),
															estadoNuevo,
															urlConfig);

											if (respuesta.equals("OK")) {
												/**
												 * Marcamos en la tabla que se
												 * ha pausado automaticamente
												 */
												if (pausar) {
													fichaTec.setPausaAutoGmao("1");
													fichaTec.setEstadoGmao("PAUSA");
													fichaTec.setFechaEstadoGmao(new Date());
												} else {

													// Sumamos el tiempo en
													// pausa al
													// campo
													// tiempopausa
													Integer tiempoPausa = 0;
													if (fichaTec
															.getTiempoPausaGmao() != null) {
														tiempoPausa = fichaTec
																.getTiempoPausaGmao();
													}
													Calendar calFechaIniPausa = Calendar
															.getInstance();
													Calendar calFechaFinPausa = Calendar
															.getInstance();
													calFechaIniPausa
															.setTime(fichaTec
																	.getFechaEstadoGmao());
													calFechaFinPausa
															.setTime(new Date());
													Long totalMinutos = ((calFechaFinPausa
															.getTimeInMillis() - calFechaIniPausa
															.getTimeInMillis()) / 1000 / 60);

													if (totalMinutos != 0) {
														tiempoPausa = tiempoPausa
																+ totalMinutos
																		.intValue();

														fichaTec.setTiempoPausaGmao(tiempoPausa);
														this.fichatecnicosgmaoServices
																.actualizarTiempoPausaFicha(fichaTec);
													}

													fichaTec.setPausaAutoGmao("0");
													fichaTec.setEstadoGmao("CURS");
													fichaTec.setFechaEstadoGmao(new Date());

												}
												fichaTec = this.fichatecnicosgmaoServices
														.marcarPausaAutoFicha(fichaTec);

												/**
												 * Se sincroniza la OT nueva
												 * para confirmarla
												 */
												String fechaSinc = "";
												if (otDescargada
														.get("FechaSinc") != JSONObject.NULL) {
													fechaSinc = otDescargada
															.getString("FechaSinc");
												}

												JSONObject pdteSincOtOK = new JSONObject();
												JSONArray valoresOTbajada = new JSONArray();
												JSONObject valorBajada = new JSONObject();
												valorBajada
														.put("UUIdOt",
																fichaTec.getGuidfichatecgmao());
												valorBajada.put(
														"FechaUltimaSinc",
														fechaSinc);
												valoresOTbajada
														.put(valorBajada);
												pdteSincOtOK.put("ots",
														valoresOTbajada);
												respuesta = this.procesosJMSService
														.sincronizarGmao(
																pdteSincOtOK,
																urlConfig
																		+ Aa20bConstantes.URL_MARCAR_SINC_OK);

											}
										}
									}
								}
							}
						}
					}
				}
			}
		}

	}

	private void comprobrarPartesCorrectivosEnCurso(
			Partetecnicosgmao parteTecGmaoAux, String urlConfig) {

		List<Partetecnicosgmao> listaPartesTecCurso = new ArrayList<Partetecnicosgmao>();
		Partetecnicosgmao partetecgmaocursoAux = new Partetecnicosgmao();
		partetecgmaocursoAux.setIdtecnico(parteTecGmaoAux.getIdtecnico());
		partetecgmaocursoAux
				.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_CURSO);
		listaPartesTecCurso = this.partetecnicosgmaoServices.findAll(
				partetecgmaocursoAux, null);
		for (Partetecnicosgmao partetecgmaocurso : listaPartesTecCurso) {
			if (partetecgmaocurso != null
					&& partetecgmaocurso.getGuidpartetecgmao() != null
					&& !partetecgmaocurso.getGuidpartetecgmao().equals(
							parteTecGmaoAux.getGuidpartetecgmao())) {
				// Comprobamos si sigue teniendo
				// actualmente estado EN CURSO en
				// gmao
				JSONObject otcurso = new JSONObject();
				otcurso.put("UUIdOt", "{"
						+ partetecgmaocurso.getGuidpartetecgmao().toUpperCase()
						+ "}");
				String respuestaOTcurso = "";
				respuestaOTcurso = this.procesosJMSService
						.bajarOtByGUID(otcurso, urlConfig
								+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

				JSONObject respOtCurso = new JSONObject(respuestaOTcurso);
				JSONArray otsCurso = new JSONArray();
				otsCurso = respOtCurso.getJSONArray("ots");

				if (otsCurso.length() > 0) {
					JSONObject otCursoComprobar = otsCurso.getJSONObject(0);

					if (otCursoComprobar.get("IdEstado") != JSONObject.NULL
							&& otCursoComprobar.getString("IdEstado").equals(
									Aa20bConstantes.COD_ESTADO_GMAO_CURSO)) {
						String respuestaCambioEstado = this.procesosJMSService
								.subirOTcambioEstado(
										partetecgmaocurso.getGuidpartetecgmao(),
										Aa20bConstantes.COD_ESTADO_GMAO_PAUSA,
										urlConfig);

						if (respuestaCambioEstado.equals("OK")) {

							/**
							 * Al forzar el cambio de estado de En curso a
							 * Pausa, guardamos la ejecución para tener el
							 * tiempo que llevaba en curso
							 */
							Date fechaAct = new Date();
							Parteejecucion parteEjecucionLogAux = new Parteejecucion();

							parteEjecucionLogAux.setIdpartec(partetecgmaocurso
									.getIdpartec());
							parteEjecucionLogAux.setFeini(partetecgmaocurso
									.getFechaEstadoGmao());
							parteEjecucionLogAux.setFefin(fechaAct);

							parteEjecucionLogAux = this.parteejecucionServices
									.add(parteEjecucionLogAux);

							this.parteejecucionServices
									.recalcularTiempoParteTecnico(partetecgmaocurso
											.getIdpartec());

							partetecgmaocurso
									.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_PAUSA);
							partetecgmaocurso.setFechaEstadoGmao(fechaAct);
							partetecgmaocurso = this.partetecnicosgmaoServices
									.update(partetecgmaocurso);

							/**
							 * Se sincroniza la OT nueva para confirmarla
							 */
							String fechaSinc = "";
							if (otCursoComprobar.get("FechaSinc") != JSONObject.NULL) {
								fechaSinc = otCursoComprobar
										.getString("FechaSinc");
							}

							JSONObject pdteSincOtOK = new JSONObject();
							JSONArray valoresOTbajada = new JSONArray();
							JSONObject valorBajada = new JSONObject();
							valorBajada.put("UUIdOt",
									partetecgmaocurso.getGuidpartetecgmao());
							valorBajada.put("FechaUltimaSinc", fechaSinc);
							valoresOTbajada.put(valorBajada);
							pdteSincOtOK.put("ots", valoresOTbajada);
							respuestaCambioEstado = this.procesosJMSService
									.sincronizarGmao(
											pdteSincOtOK,
											urlConfig
													+ Aa20bConstantes.URL_MARCAR_SINC_OK);

						}
					}
				}
			}
		}
	}

	private void comprobrarPartesPreventivosEnCurso(
			Fichatecnicosgmao fichaTecGmaoAux, String urlConfig) {

		List<Fichatecnicosgmao> listaFichasTecCurso = new ArrayList<Fichatecnicosgmao>();
		Fichatecnicosgmao fichatecgmaocursoAux = new Fichatecnicosgmao();
		fichatecgmaocursoAux.setIdtecnico(fichaTecGmaoAux.getIdtecnico());
		fichatecgmaocursoAux
				.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_CURSO);
		listaFichasTecCurso = this.fichatecnicosgmaoServices.findAll(
				fichatecgmaocursoAux, null);
		for (Fichatecnicosgmao fichatecgmaocurso : listaFichasTecCurso) {
			if (fichatecgmaocurso != null
					&& fichatecgmaocurso.getGuidfichatecgmao() != null
					&& !fichatecgmaocurso.getGuidfichatecgmao().equals(
							fichaTecGmaoAux.getGuidfichatecgmao())) {
				// Comprobamos si sigue teniendo
				// actualmente estado EN CURSO en
				// gmao
				JSONObject otcurso = new JSONObject();
				otcurso.put("UUIdOt", "{"
						+ fichatecgmaocurso.getGuidfichatecgmao().toUpperCase()
						+ "}");
				String respuestaOTcurso = "";
				respuestaOTcurso = this.procesosJMSService
						.bajarOtByGUID(otcurso, urlConfig
								+ Aa20bConstantes.URL_BAJAR_OTS_GUID);

				JSONObject respOtCurso = new JSONObject(respuestaOTcurso);
				JSONArray otsCurso = new JSONArray();
				otsCurso = respOtCurso.getJSONArray("ots");

				if (otsCurso.length() > 0) {
					JSONObject otCursoComprobar = otsCurso.getJSONObject(0);

					if (otCursoComprobar.get("IdEstado") != JSONObject.NULL
							&& otCursoComprobar.getString("IdEstado").equals(
									Aa20bConstantes.COD_ESTADO_GMAO_CURSO)) {
						String respuestaCambioEstado = this.procesosJMSService
								.subirOTcambioEstado(
										fichatecgmaocurso.getGuidfichatecgmao(),
										Aa20bConstantes.COD_ESTADO_GMAO_PAUSA,
										urlConfig);

						if (respuestaCambioEstado.equals("OK")) {

							/**
							 * Al forzar el cambio de estado de En curso a
							 * Pausa, guardamos la ejecución para tener el
							 * tiempo que llevaba en curso
							 */
							Date fechaAct = new Date();
							Fichaejecucion fichaEjecucionLogAux = new Fichaejecucion();

							fichaEjecucionLogAux.setIdfitec(fichatecgmaocurso
									.getIdfichac());
							fichaEjecucionLogAux.setFeini(fichatecgmaocurso
									.getFechaEstadoGmao());
							fichaEjecucionLogAux.setFefin(fechaAct);

							fichaEjecucionLogAux = this.fichaejecucionServices
									.add(fichaEjecucionLogAux);

							this.fichaejecucionServices
									.recalcularTiempoFichaTecnico(fichatecgmaocurso
											.getIdfichac());

							fichatecgmaocurso
									.setEstadoGmao(Aa20bConstantes.COD_ESTADO_GMAO_PAUSA);
							fichatecgmaocurso.setFechaEstadoGmao(new Date());
							fichatecgmaocurso = this.fichatecnicosgmaoServices
									.update(fichatecgmaocurso);

							/**
							 * Se sincroniza la OT nueva para confirmarla
							 */
							String fechaSinc = "";
							if (otCursoComprobar.get("FechaSinc") != JSONObject.NULL) {
								fechaSinc = otCursoComprobar
										.getString("FechaSinc");
							}

							JSONObject pdteSincOtOK = new JSONObject();
							JSONArray valoresOTbajada = new JSONArray();
							JSONObject valorBajada = new JSONObject();
							valorBajada.put("UUIdOt",
									fichatecgmaocurso.getGuidfichatecgmao());
							valorBajada.put("FechaUltimaSinc", fechaSinc);
							valoresOTbajada.put(valorBajada);
							pdteSincOtOK.put("ots", valoresOTbajada);
							respuestaCambioEstado = this.procesosJMSService
									.sincronizarGmao(
											pdteSincOtOK,
											urlConfig
													+ Aa20bConstantes.URL_MARCAR_SINC_OK);
						}
					}
				}
			}
		}
	}

	private boolean tratamientoParteAyudaSeguimientoCorrectivoDesdeMovilGmao(
			String guidpartehijaFormateado, String urlConfig, JSONObject ot) {
		boolean fichaNuevaBienCreada = true;

		/**
		 * Si se trata de ayuda o traspaso de parte
		 */
		if (ot.get("UUIdOtSeguida") != JSONObject.NULL
				|| (ot.get("UUIdOtPadre") != JSONObject.NULL)) {
			boolean otnuevacorrecta = true;
			String fichaPadreGuid = "";
			String fichaSeguidoGuid = "";
			String otTraspaso = "";
			String otAyuda = "";
			Integer fichaBusqueda = 0;
			String idTecnicoParteNuevo = "";
			if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
				idTecnicoParteNuevo = ot.getString("IdOperarioResponsable");
			}

			if (ot.get("UUIdOtSeguida") != JSONObject.NULL) {
				otTraspaso = ot.getString("UUIdOtSeguida").replace("{", "");
				otTraspaso = otTraspaso.replace("}", "");
				Fichatecnicosgmao fichatecpadregmaoAux = new Fichatecnicosgmao();
				fichatecpadregmaoAux.setGuidfichatecgmao(otTraspaso
						.toLowerCase());
				fichatecpadregmaoAux = this.fichatecnicosgmaoServices
						.findByGUID(fichatecpadregmaoAux);

				if (fichatecpadregmaoAux != null) {
					/**
					 * El parte existe en nuestro sistema. Debemos crear un
					 * parte nuevo en movil gmao asignandoselo al nuevo técnico
					 * para después finalizar el parte anterior que se quiere
					 * traspasar. En nuestra aplicación se asignará al mismo
					 * parte.
					 */
					fichaSeguidoGuid = fichatecpadregmaoAux
							.getGuidfichatecgmao();
					fichaBusqueda = fichatecpadregmaoAux.getIdficha();
					String tecnicoNuevo = "";
					if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
						tecnicoNuevo = ot.getString("IdOperarioResponsable");
						// Si ha elegido un técnico diferente a el
						if (!tecnicoNuevo.equals(fichatecpadregmaoAux
								.getIdtecnico())) {

							/**
							 * Se comprueba el estado actual del parte para
							 * marcarlo como finalizado en movilgmao
							 */
							if (fichatecpadregmaoAux.getEstadoGmao() != null
									&& fichatecpadregmaoAux
											.getFechaEstadoGmao() != null) {
								if (!fichatecpadregmaoAux
										.getEstadoGmao()
										.equals(Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO)) {

									String respuestaCambioEstado = this.procesosJMSService
											.subirOTcambioEstado(
													fichatecpadregmaoAux
															.getGuidfichatecgmao(),
													Aa20bConstantes.COD_ESTADO_GMAO_TERMINADO,
													urlConfig);

									/**
									 * Quitamos el tecnico de la OT (como hace
									 * movilgmao al finalizar)
									 */
									if (respuestaCambioEstado.equals("OK")) {
										this.procesosJMSService
												.subirOTcambioTecnico(
														fichatecpadregmaoAux
																.getGuidfichatecgmao(),
														null, urlConfig);
									}
								}
							}
						} else {
							// Si se ha elegido a el como técnico no asignamos
							// el
							// parte
							otnuevacorrecta = false;
						}
					}
				}

			} else if (ot.get("UUIdOtPadre") != JSONObject.NULL) {
				/**
				 * Si viene con el campo de ot hija significa que quiere ayuda
				 * para el parte. Se deberá crear un parte nuevo hijo y
				 * asignarselo al técnico nuevo, manteniendo el parte anterior
				 * igual
				 */
				otAyuda = ot.getString("UUIdOtPadre").replace("{", "");
				otAyuda = otAyuda.replace("}", "");
				Fichatecnicosgmao fichatecpadregmaoAux = new Fichatecnicosgmao();
				fichatecpadregmaoAux.setGuidfichatecgmao(otAyuda.toLowerCase());
				fichatecpadregmaoAux = this.fichatecnicosgmaoServices
						.findByGUID(fichatecpadregmaoAux);
				if (fichatecpadregmaoAux != null) {
					fichaPadreGuid = fichatecpadregmaoAux.getGuidfichatecgmao();
					String tecnicoNuevo = "";
					if (ot.get("IdOperarioResponsable") != JSONObject.NULL) {
						tecnicoNuevo = ot.getString("IdOperarioResponsable");
						// Si se ha elegido a el como técnico no creamos el
						// parte
						if (tecnicoNuevo.equals(fichatecpadregmaoAux
								.getIdtecnico())) {
							otnuevacorrecta = false;
						}
					}

				}
			}

			String guidedificioFormateado = ot.getString("UUIdactivo").replace(
					"{", "");
			guidedificioFormateado = guidedificioFormateado.replace("}", "");

			Ficha fichaBusAux = new Ficha();
			fichaBusAux.setIdficha(fichaBusqueda);
			Ficha fichaAux = this.fichasService.find(fichaBusAux);

			if (fichaAux != null && otnuevacorrecta) {
				/**
				 * Si en el parte nuevo no viene información del técnico
				 * asociado significa que quiere cambiar de técnico
				 */
				Fichatecnicosgmao elTecnicoFichaGmao = new Fichatecnicosgmao();
				Fichatecnicosgmao fichaNuevaTecnicoGmaoAux = new Fichatecnicosgmao();
				if (idTecnicoParteNuevo != null
						&& !idTecnicoParteNuevo.equals("")) {
					Fichatecnico fichaTecnico = new Fichatecnico();
					fichaTecnico.setIdficha(fichaAux.getIdficha());
					fichaTecnico
							.setIdtecnico(Long.valueOf(idTecnicoParteNuevo));
					fichaTecnico.setFinalizado("0");
					fichaTecnico.setAceptada("1");

					Fichatecnico fichaTecnicoAux = this.fichatecnicosService
							.add(fichaTecnico);

					elTecnicoFichaGmao.setIdficha(fichaAux.getIdficha());
					elTecnicoFichaGmao.setIdtecnico(Long
							.valueOf(idTecnicoParteNuevo));
					elTecnicoFichaGmao
							.setIdfichac(fichaTecnicoAux.getIdfitec());
					elTecnicoFichaGmao
							.setGuidfichatecgmao(guidpartehijaFormateado);

					if (!fichaPadreGuid.equals("")) {
						elTecnicoFichaGmao
								.setGuidpartepadreayuda(fichaPadreGuid);
					}
					if (!fichaSeguidoGuid.equals("")) {
						elTecnicoFichaGmao
								.setGuidparteseguido(fichaSeguidoGuid);
					}

					fichaNuevaTecnicoGmaoAux = this.fichatecnicosgmaoServices
							.add(elTecnicoFichaGmao);

				} else {

					/**
					 * No tiene técnico, habrá que buscar uno si es automático
					 * Se crea el registro en la tabla de partes gmao sin
					 * incluir ni el técnico ni el código del parte técnico
					 */

					elTecnicoFichaGmao.setIdficha(fichaAux.getIdficha());
					elTecnicoFichaGmao.setIdtecnico(null);
					elTecnicoFichaGmao.setIdfichac(null);
					elTecnicoFichaGmao
							.setGuidfichatecgmao(guidpartehijaFormateado);

					fichaNuevaTecnicoGmaoAux = this.fichatecnicosgmaoServices
							.add(elTecnicoFichaGmao);
				}

				Tecnicos tecnicoAux = new Tecnicos();
				if (idTecnicoParteNuevo != null
						&& !idTecnicoParteNuevo.equals("")) {
					tecnicoAux.setIdtecnico(Long.valueOf(idTecnicoParteNuevo));
					tecnicoAux = this.tecnicosService.find(tecnicoAux);
				}

				// Obtener tecnicos asignados al parte
				// (partetecnicos)
				fichaNuevaTecnicoGmaoAux = new Fichatecnicosgmao();
				fichaNuevaTecnicoGmaoAux.setIdficha(fichaAux.getIdficha());
				List<Fichatecnicosgmao> fichaNuevaTecnicosGmao = this.fichatecnicosgmaoServices
						.findAll(fichaNuevaTecnicoGmaoAux, null);

				if (fichaAux != null) {

					String idEdificio = null;
					Maquinas maquinaAux = new Maquinas();
					if (fichaAux.getIdmaquina() != null) {

						maquinaAux.setIdmaquina(fichaAux.getIdmaquina());
						maquinaAux = this.maquinasService.find(maquinaAux);

						if (maquinaAux != null
								&& maquinaAux.getIdedificio() != null) {
							idEdificio = maquinaAux.getIdedificio();
						}

						if (maquinaAux.getIdzona() != null) {
							Zonas zonaAux = new Zonas();
							zonaAux.setIdzona(maquinaAux.getIdzona());
							zonaAux = this.zonasService.find(zonaAux);
							maquinaAux.setZona(zonaAux);

						}

						if (maquinaAux.getIdplanta() != null) {
							Plantas plantaAux = new Plantas();
							plantaAux.setIdplanta(maquinaAux.getIdplanta());
							plantaAux = this.plantasService.find(plantaAux);
							maquinaAux.setPlanta(plantaAux);
						}
					}

					Edificios edifAux = new Edificios();
					if (idEdificio != null) {
						edifAux = this.edificiosService
								.obtenerEdificio(idEdificio);
					}

					// Obtener tecnicos asignados al parte preventivo
					// (fichatecnicos)
					Fichatecnicosgmao tecnicoFichaGmaoAux = new Fichatecnicosgmao();
					tecnicoFichaGmaoAux.setIdficha(fichaAux.getIdficha());
					List<Fichatecnicosgmao> fichaTecnicosGmao = this.fichatecnicosgmaoServices
							.findAll(tecnicoFichaGmaoAux, null);

					// Obtener actuaciones asociadas al parte preventivo
					Actuacion actuacionAux = new Actuacion();
					actuacionAux.setIdficha(fichaAux.getIdficha());
					List<Actuacion> listaActuaciones = this.actuacionService
							.obtenerActuaciones(actuacionAux, null);

					/**
					 * Se sincronizará con Gmao para crear el parte actualizar
					 * los datos del parte creado con el móvil, añadiendo el
					 * numero de OT con el formato correcto
					 */
					String respuesta = this.procesosJMSService
							.sincronizarPartePreventivoGmao(fichaAux,
									maquinaAux, fichaTecnicosGmao,
									listaActuaciones,
									edifAux.getGuidedificio(), urlConfig);

					if (respuesta != null && respuesta.equals("OK")) {
						ProcesosGmaoController.logger
								.info("[MOVILGMAO] : sincronizarPartePreventivo: "
										+ respuesta);
					} else {
						ProcesosGmaoController.logger
								.error("[MOVILGMAO] : sincronizarPartePreventivo: "
										+ respuesta);
					}

					/**
					 * Se sincroniza la OT nueva para confirmarla
					 */
					String fechaSinc = "";
					if (ot.get("FechaSinc") != JSONObject.NULL) {
						fechaSinc = ot.getString("FechaSinc");
					}
					JSONObject pdteSincOtOK = new JSONObject();
					JSONArray valoresOTbajada = new JSONArray();
					JSONObject valorBajada = new JSONObject();
					valorBajada.put("UUIdOt", guidpartehijaFormateado);
					valorBajada.put("FechaUltimaSinc", fechaSinc);
					valoresOTbajada.put(valorBajada);
					pdteSincOtOK.put("ots", valoresOTbajada);
					respuesta = this.procesosJMSService.sincronizarGmao(
							pdteSincOtOK, urlConfig
									+ Aa20bConstantes.URL_MARCAR_SINC_OK);

					/**
					 * Después de confirmarla se sube la información con la
					 * asignación del operario a MovilGmao
					 */
					respuesta = this.procesosJMSService
							.sincronizarPartePreventivoGmao(fichaAux,
									maquinaAux, fichaTecnicosGmao,
									listaActuaciones,
									edifAux.getGuidedificio(), urlConfig);

					if (respuesta.equals("OK")) {
						fichaNuevaBienCreada = true;
					} else {
						fichaNuevaBienCreada = false;
					}
				}
			}

		}

		return fichaNuevaBienCreada;
	}
}
