package com.ejie.aa20b.control;

import com.ejie.aa20b.service.Aa20bUsuarioXLNETService;
import com.ejie.aa20b.service.PresenciaService;
import com.ejie.aa20b.service.TecnicosService;
import com.ejie.aa20b.service.TipopresenciaService;
import com.ejie.aa20b.service.UsuariosService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.Presencia;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Tipopresencia;
import com.ejie.aa20b.model.Usuarios;

/**
 * PresenciaController generated by UDA, 30-abr-2015 12:53:01.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/presencia")
public class PresenciaController {

	private static final Logger logger = LoggerFactory
			.getLogger(PresenciaController.class);

	@Autowired
	private PresenciaService presenciaService;

	@Autowired
	private TipopresenciaService tipopresenciaService;

	@Autowired
	private TecnicosService tecnicosService;

	@Autowired
	private Aa20bUsuarioXLNETService usuarioXLNETService;

	@Autowired
	private UsuariosService usuarioService;

	@Autowired
	private UsuarioXLNETController usuarioXLNETController;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		PresenciaController.logger.info("[GET - View] : presencia");
		return "presencia";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idpresencia
	 *            Integer
	 * @return presencia Presencia
	 */
	@RequestMapping(value = "/{idpresencia}", method = RequestMethod.GET)
	public @ResponseBody
	Presencia getById(@PathVariable Integer idpresencia) {
		Presencia presencia = new Presencia();
		presencia.setIdpresencia(idpresencia);
		presencia = this.presenciaService.find(presencia);
		PresenciaController.logger
				.info("[GET - findBy_PK] : Obtener Presencia por PK");
		return presencia;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterPresencia
	 *            Presencia
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Presencia> getAll(@ModelAttribute Presencia filterPresencia) {
		PresenciaController.logger
				.info("[GET - find_ALL] : Obtener Presencia por filtro");
		return this.presenciaService.findAll(filterPresencia, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Presencia edit(@RequestBody Presencia presencia) {
		Presencia presenciaAux = this.presenciaService.update(presencia);
		PresenciaController.logger
				.info("[PUT] : Presencia actualizado correctamente");
		return presenciaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param presencia
	 *            Presencia
	 * @return Presencia
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Presencia add(@RequestBody Presencia presencia) {
		Presencia presenciaAux = this.presenciaService.add(presencia);
		PresenciaController.logger
				.info("[POST] : Presencia insertado correctamente");
		return presenciaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idpresencia
	 *            Integer
	 * @return presencia
	 */
	@RequestMapping(value = "/{idpresencia}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Presencia remove(@PathVariable Integer idpresencia) {
		Presencia presencia = new Presencia();
		presencia.setIdpresencia(idpresencia);
		this.presenciaService.remove(presencia);
		PresenciaController.logger
				.info("[DELETE] : Presencia borrado correctamente");
		return presencia;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param presenciaIds
	 *            List
	 * @return presenciaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> presenciaIds) {
		List<Presencia> presenciaList = new ArrayList<Presencia>();
		for (List<String> presenciaId : presenciaIds) {
			Iterator<String> iterator = presenciaId.iterator();
			Presencia presencia = new Presencia(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			presencia.setIdpresencia(ObjectConversionManager.convert(
					iterator.next(), Integer.class));
			presenciaList.add(presencia);
		}
		this.presenciaService.removeMultiple(presenciaList);
		PresenciaController.logger
				.info("[POST - DELETE_ALL] : Presencia borrados correctamente");
		return presenciaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPresencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Presencia filterPresencia,
			@ModelAttribute Pagination pagination) {
		List<Presencia> presencias = this.presenciaService.findAllLike(
				filterPresencia, pagination, false);
		Long recordNum = this.presenciaService.findAllLikeCount(
				filterPresencia, false);
		PresenciaController.logger.info("[GET - jqGrid] : Obtener Presencia");
		return new JQGridJSONModel(pagination, recordNum, presencias);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPresencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridPresencias", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridPresencias(@ModelAttribute Presencia filterPresencia,
			@ModelAttribute Pagination pagination, HttpServletRequest request) {

		// Obtener las presencias de los tecnicos asociados al usuario
		// identificado en XLNETS
		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		filterPresencia.setUidUsuario(sUIDUsuario);

		List<Presencia> presencias = this.presenciaService.obtenerPresencias(
				filterPresencia, pagination, false);
		Long recordNum = this.presenciaService.obtenerPresenciasCount(
				filterPresencia, false);
		PresenciaController.logger.info("[GET - jqGrid] : Obtener Presencia");

		request.getSession().setAttribute("FiltroPresencia", filterPresencia);

		return new JQGridJSONModel(pagination, recordNum, presencias);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idPresenciaBusc
	 *            Integer
	 * @param fechaPreDBusc
	 *            String
	 * @param fechaPreHBusc
	 *            String
	 * @return historiaPresencia String
	 */
	@RequestMapping(value = "/buscarHistoria", method = RequestMethod.POST)
	public String getById(@RequestParam Integer idPresenciaBusc, Model model) {

		PresenciaController.logger.info("[GET - findBy_PK] : Presencia.");

		Presencia presencia = new Presencia();

		presencia = this.getById(idPresenciaBusc);

		PresenciaController.logger.info("[GET - findBy_PK] : Presencia: "
				+ presencia.toString());

		model.addAttribute("Presencia", presencia);

		return "historiaPresencia";
	}

	/**
	 * Method 'presenciasTecnico'.
	 * 
	 * @param filterPresencia
	 *            Presencia
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "presenciasTecnico", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel presenciasTecnico(
			@ModelAttribute Presencia filterPresencia,
			@ModelAttribute Pagination pagination, HttpServletRequest request) {

		Presencia filtroPresencia = (Presencia) request.getSession()
				.getAttribute("FiltroPresencia");
		if (filtroPresencia != null) {
			filterPresencia.setFechaPreD(filtroPresencia.getFechaPreD());
			filterPresencia.setFechaPreH(filtroPresencia.getFechaPreH());
		}

		List<Presencia> presencias = this.presenciaService.findAllLike(
				filterPresencia, pagination, false);
		Long recordNum = this.presenciaService.findAllLikeCount(
				filterPresencia, false);
		PresenciaController.logger.info("[GET - jqGrid] : Obtener Presencia");
		return new JQGridJSONModel(pagination, recordNum, presencias);
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/modificar", method = RequestMethod.GET)
	public String getCreateFormModficar(Model model, HttpServletRequest request) {
		PresenciaController.logger.info("[GET - View] : modificar presencia");

		Integer idPresencia = Integer.parseInt(request
				.getParameter("idPresencia"));

		PresenciaController.logger
				.info("[GET - View] : modificar Presencias : presencia: "
						+ idPresencia);

		Presencia presencia = this.getById(idPresencia);

		PresenciaController.logger.info("[GET - View] : modificar presencia : "
				+ presencia.toString());

		model.addAttribute("Presencia", presencia);

		request.setAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		return "editarPresencia";
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param presencia
	 *            Presencias
	 * @return Presencias
	 */
	@RequestMapping(value = "/modificaPresencia", method = RequestMethod.POST)
	public @ResponseBody
	Presencia modificaPresencias(@RequestBody Presencia presencia) {

		PresenciaController.logger
				.info("[PUT] : Presencias antes de modificar : "
						+ presencia.toString());
		// Se actualizar THASTA a 4
		presencia.setThasta("4");
		Presencia presenciaAux = this.presenciaService.update(presencia);
		PresenciaController.logger
				.info("[PUT] : Presencias actualizado correctamente");
		return presenciaAux;

	}

	/**
	 * Method 'getRemoteComboTiposPresencia'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "tipopresencia/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Tipopresencia> getRemoteComboTiposPresencia(Model model) {
		PresenciaController.logger
				.info("[GET - View] : getRemoteComboTiposPresencia");
		model.addAttribute("tipopresencia",
				this.tipopresenciaService.findAll(null, null));
		return this.tipopresenciaService.findAll(null, null);
	}

	@RequestMapping(value = "/addNuevaPresencia", method = RequestMethod.POST)
	public @ResponseBody
	Presencia addNuevaPresencias(@RequestBody Presencia presencia, Model model) {

		PresenciaController.logger.info("[POST] : ENTRAMOS EN ADD presencia");

		PresenciaController.logger.info("[POST] : ADD : presencia : "
				+ presencia.toString());

		presencia.setTdesde("4");
		if (presencia.getFhhasta() == null) {
			presencia.setThasta("0");
		} else {
			presencia.setThasta("4");
		}
		Presencia presenciaAux = this.presenciaService
				.nuevaPresencia(presencia);
		PresenciaController.logger
				.info("[POST] : presencia insertado correctamente");

		return presenciaAux;
	}

	/**
	 * Method 'getCreateForm2'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "nuevo", method = RequestMethod.GET)
	public String getCreateForm2(Model model, HttpServletRequest request) {
		PresenciaController.logger.info("[GET - View] : nueva Presencia");
		model.addAttribute("accion", Aa20bConstantes.ACCION_NUEVO);

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);
		return "editarPresencia";
	}

	/**
	 * Method 'getRemoteComboTecnicos'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "tecnicos/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Tecnicos> getRemoteComboTecnicos(Model model) {
		PresenciaController.logger
				.info("[GET - View] : getRemoteComboTecnicos");

		// Comprobar si el usuario identificado en XLNET es Responsable
		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETService.obtenerUIDUsuario();
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		Usuarios usuarioAux = this.usuarioService.find(usuario);
		if (usuarioAux != null) {
			if (usuarioAux.getResponsable() == 1) {
				// Es responsable
				return this.tecnicosService.obtenerTecnicosPresencia(
						sUIDUsuario, true);
			} else {
				return this.tecnicosService.obtenerTecnicosPresencia(
						sUIDUsuario, false);
			}
		} else {
			return null;
		}

	}
}
