package com.ejie.aa20b.control;

import com.ejie.aa20b.service.PlantasService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa20b.model.Plantas;

/**
 * PlantasController generated by UDA, 28-nov-2014 11:32:27.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/plantas")
public class PlantasController {

	private static final Logger logger = LoggerFactory
			.getLogger(PlantasController.class);

	@Autowired
	private PlantasService plantasService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		PlantasController.logger.info("[GET - View] : plantas");
		return "plantas";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idplanta
	 *            Integer
	 * @param cplanta
	 *            String
	 * @param eplanta
	 *            String
	 * @param baja
	 *            String
	 * @param feini
	 *            Date
	 * @param numPlanta
	 *            Integer
	 * @return plantas Plantas
	 */
	@RequestMapping(value = "/{idplanta}/{cplanta}/{eplanta}/{baja}/{feini}/{numPlanta}", method = RequestMethod.GET)
	public @ResponseBody
	Plantas getById(@PathVariable Integer idplanta,
			@PathVariable String cplanta, @PathVariable String eplanta,
			@PathVariable String baja, @PathVariable Date feini,
			@PathVariable Integer numPlanta) {
		Plantas plantas = new Plantas();
		plantas.setIdplanta(idplanta);
		plantas.setCplanta(cplanta);
		plantas.setEplanta(eplanta);
		plantas.setBaja(baja);
		plantas.setFeini(feini);
		plantas.setNumPlanta(numPlanta);
		plantas = this.plantasService.find(plantas);
		PlantasController.logger
				.info("[GET - findBy_PK] : Obtener Plantas por PK");
		return plantas;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterPlantas
	 *            Plantas
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Plantas> getAll(@ModelAttribute Plantas filterPlantas) {
		PlantasController.logger
				.info("[GET - find_ALL] : Obtener Plantas por filtro");
		return this.plantasService.findAll(filterPlantas, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Plantas
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Plantas edit(@RequestBody Plantas plantas) {
		Plantas plantasAux = this.plantasService.update(plantas);
		PlantasController.logger
				.info("[PUT] : Plantas actualizado correctamente");
		return plantasAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param plantas
	 *            Plantas
	 * @return Plantas
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Plantas add(@RequestBody Plantas plantas) {
		Plantas plantasAux = this.plantasService.add(plantas);
		PlantasController.logger
				.info("[POST] : Plantas insertado correctamente");
		return plantasAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idplanta
	 *            Integer
	 * @param cplanta
	 *            String
	 * @param eplanta
	 *            String
	 * @param baja
	 *            String
	 * @param feini
	 *            Date
	 * @param numPlanta
	 *            Integer
	 * @return plantas
	 */
	@RequestMapping(value = "/{idplanta}/{cplanta}/{eplanta}/{baja}/{feini}/{numPlanta}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Plantas remove(@PathVariable Integer idplanta,
			@PathVariable String cplanta, @PathVariable String eplanta,
			@PathVariable String baja, @PathVariable Date feini,
			@PathVariable Integer numPlanta) {
		Plantas plantas = new Plantas();
		plantas.setIdplanta(idplanta);
		plantas.setCplanta(cplanta);
		plantas.setEplanta(eplanta);
		plantas.setBaja(baja);
		plantas.setFeini(feini);
		plantas.setNumPlanta(numPlanta);
		this.plantasService.remove(plantas);
		PlantasController.logger
				.info("[DELETE] : Plantas borrado correctamente");
		return plantas;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param plantasIds
	 *            List
	 * @return plantasList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> plantasIds) {
		List<Plantas> plantasList = new ArrayList<Plantas>();
		for (List<String> plantasId : plantasIds) {
			Iterator<String> iterator = plantasId.iterator();
			Plantas plantas = new Plantas(); // NOPMD - Objeto nuevo en la lista
												// (parametro del servicio)
			plantas.setIdplanta(ObjectConversionManager.convert(
					iterator.next(), java.lang.Integer.class));
			plantas.setCplanta(ObjectConversionManager.convert(iterator.next(),
					String.class));
			plantas.setEplanta(ObjectConversionManager.convert(iterator.next(),
					String.class));
			plantas.setBaja(ObjectConversionManager.convert(iterator.next(),
					String.class));
			plantas.setFeini(ObjectConversionManager.convert(iterator.next(),
					java.util.Date.class));
			plantas.setNumPlanta(ObjectConversionManager.convert(
					iterator.next(), java.lang.Integer.class));
			plantasList.add(plantas);
		}
		this.plantasService.removeMultiple(plantasList);
		PlantasController.logger
				.info("[POST - DELETE_ALL] : Plantas borrados correctamente");
		return plantasIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPlantas
	 *            Plantas
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Plantas filterPlantas,
			@ModelAttribute Pagination pagination) {
		List<Plantas> plantass = this.plantasService.findAllLike(filterPlantas,
				pagination, false);
		Long recordNum = this.plantasService.findAllLikeCount(filterPlantas,
				false);
		PlantasController.logger.info("[GET - jqGrid] : Obtener Plantas");
		return new JQGridJSONModel(pagination, recordNum, plantass);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idplanta
	 *            Integer
	 * @return planta Plantas
	 */
	@RequestMapping(value = "/{idplanta}", method = RequestMethod.GET)
	public @ResponseBody
	Plantas getById(@PathVariable Integer idplanta) {
		Plantas planta = new Plantas();
		planta.setIdplanta(idplanta);
		planta = this.plantasService.find(planta);
		PlantasController.logger
				.info("[GET - findBy_PK] : Obtener Plantas por PK");
		return planta;
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/modificar", method = RequestMethod.GET)
	public String getCreateFormModficar(Model model, HttpServletRequest request) {
		PlantasController.logger.info("[GET - View] : modificar planta");

		Integer idPlanta = Integer.parseInt(request.getParameter("idPlanta"));

		PlantasController.logger
				.info("[GET - View] : modificar Plantas : planta: " + idPlanta);

		Plantas planta = this.getById(idPlanta);

		PlantasController.logger.info("[GET - View] : modificar planta : "
				+ planta.toString());

		/*
		 * PlantasIncidenciasController.logger
		 * .info("[planta INCIDENCIA EN MODIFICAR : " +
		 * plantaIncidencia.getCodPlantas());
		 */
		model.addAttribute("Planta", planta);

		request.setAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		return "editarPlanta";
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param planta
	 *            Plantas
	 * @return Plantas
	 */
	@RequestMapping(value = "/modificaPlanta", method = RequestMethod.POST)
	public @ResponseBody
	Plantas modificaPlantas(@RequestBody Plantas planta) {

		PlantasController.logger.info("[POST] : MODIFY : Valor de Baja : "
				+ planta.getBaja());

		if (planta.getBaja() == null)
			planta.setBaja("0");
		else
			planta.setBaja("1");

		PlantasController.logger.info("[PUT] : Plantas antes de modificar : "
				+ planta.toString());
		Plantas plantaAux = this.plantasService.update(planta);
		PlantasController.logger
				.info("[PUT] : Plantas actualizado correctamente");
		return plantaAux;

	}

	@RequestMapping(value = "/addNuevaPlanta", method = RequestMethod.POST)
	public @ResponseBody
	Plantas addNuevaPlantas(@RequestBody Plantas planta, Model model) {

		PlantasController.logger.info("[POST] : ENTRAMOS EN ADD planta");

		PlantasController.logger.info("[POST] : ADD : planta : "
				+ planta.toString());
		Plantas plantaAux = this.plantasService.add(planta);
		PlantasController.logger
				.info("[POST] : planta insertado correctamente");

		return plantaAux;
	}

	/**
	 * Method 'getCreateForm2'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "nuevo", method = RequestMethod.GET)
	public String getCreateForm2(Model model, HttpServletRequest request) {
		PlantasController.logger.info("[GET - View] : nuevaPlanta");
		model.addAttribute("accion", Aa20bConstantes.ACCION_NUEVO);

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);
		return "editarPlanta";
	}

	/**
	 * Method 'plantasZonaConPlanos'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "plantasZonaConPlanos/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Plantas> plantasZonaConPlanos(
			@RequestParam(value = "comboZonas", required = false) Integer cod_Zona,
			@RequestParam(value = "comboEdificios", required = false) String codEdif) {
		PlantasController.logger.info("[GET - View] : plantasZonaConPlanos");

		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		return this.plantasService.obtenerPlantasEdifZonaConPlanos(codEdif,
				cod_Zona);
	}

}
