package com.ejie.aa20b.control;

import com.ejie.aa20b.service.PartetecnicosService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.model.Partetecnicos;
import com.ejie.aa20b.model.Tecnicos;

/**
 * PartetecnicosController generated by UDA, 22-dic-2014 10:12:00.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/partetecnicos")
public class PartetecnicosController {

	private static final Logger logger = LoggerFactory
			.getLogger(PartetecnicosController.class);

	@Autowired
	private PartetecnicosService partetecnicosService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		PartetecnicosController.logger.info("[GET - View] : partetecnicos");
		return "partetecnicos";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idpartec
	 *            Integer
	 * @return partetecnicos Partetecnicos
	 */
	@RequestMapping(value = "/{idpartec}", method = RequestMethod.GET)
	public @ResponseBody
	Partetecnicos getById(@PathVariable Integer idpartec) {
		Partetecnicos partetecnicos = new Partetecnicos();
		partetecnicos.setIdpartec(idpartec);
		partetecnicos = this.partetecnicosService.find(partetecnicos);
		PartetecnicosController.logger
				.info("[GET - findBy_PK] : Obtener Partetecnicos por PK");
		return partetecnicos;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterPartetecnicos
	 *            Partetecnicos
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Partetecnicos> getAll(@ModelAttribute Partetecnicos filterPartetecnicos) {
		PartetecnicosController.logger
				.info("[GET - find_ALL] : Obtener Partetecnicos por filtro");
		return this.partetecnicosService.findAll(filterPartetecnicos, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Partetecnicos edit(@RequestBody Partetecnicos partetecnicos) {
		Partetecnicos partetecnicosAux = this.partetecnicosService
				.update(partetecnicos);
		PartetecnicosController.logger
				.info("[PUT] : Partetecnicos actualizado correctamente");
		return partetecnicosAux;
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param idPartec
	 *            Integer
	 * @param observ
	 *            String
	 * @return Partetecnicos
	 */
	@RequestMapping(value = "modificarNotasParteTecnico", method = RequestMethod.POST)
	public @ResponseBody
	Partetecnicos modificarNotasParteTecnico(Integer idPartec, String observ) {

		Partetecnicos partetecnicos = new Partetecnicos();
		partetecnicos.setIdpartec(idPartec);
		partetecnicos.setObservaciones(observ);
		Partetecnicos partetecnicosAux = this.partetecnicosService
				.guardarNotas(partetecnicos);
		PartetecnicosController.logger
				.info("[PUT] : Partetecnicos: Observaciones actualizado correctamente");
		return partetecnicosAux;
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param idPartec
	 *            Integer
	 * @param notasTec
	 *            String
	 * @return Partetecnicos
	 */
	@RequestMapping(value = "modificarNotasTecnicoParteTecnico", method = RequestMethod.POST)
	public @ResponseBody
	Partetecnicos modificarNotasTecnicoParteTecnico(Integer idPartec,
			String notasTec) {

		Partetecnicos partetecnicos = new Partetecnicos();
		partetecnicos.setIdpartec(idPartec);
		partetecnicos.setNotasTec(notasTec);
		Partetecnicos partetecnicosAux = this.partetecnicosService
				.guardarNotasTecnico(partetecnicos);
		PartetecnicosController.logger
				.info("[PUT] : Partetecnicos: Notas tecnico actualizado correctamente");
		return partetecnicosAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param partetecnicos
	 *            Partetecnicos
	 * @return Partetecnicos
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Partetecnicos add(@RequestBody Partetecnicos partetecnicos) {
		Partetecnicos partetecnicosAux = this.partetecnicosService
				.add(partetecnicos);
		PartetecnicosController.logger
				.info("[POST] : Partetecnicos insertado correctamente");
		return partetecnicosAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idpartec
	 *            Integer
	 * @return partetecnicos
	 */
	@RequestMapping(value = "/{idpartec}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Partetecnicos remove(@PathVariable Integer idpartec) {
		Partetecnicos partetecnicos = new Partetecnicos();
		partetecnicos.setIdpartec(idpartec);
		this.partetecnicosService.remove(partetecnicos);
		PartetecnicosController.logger
				.info("[DELETE] : Partetecnicos borrado correctamente");
		return partetecnicos;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param partetecnicosIds
	 *            List
	 * @return partetecnicosList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> partetecnicosIds) {
		List<Partetecnicos> partetecnicosList = new ArrayList<Partetecnicos>();
		for (List<String> partetecnicosId : partetecnicosIds) {
			Iterator<String> iterator = partetecnicosId.iterator();
			Partetecnicos partetecnicos = new Partetecnicos(); // NOPMD - Objeto
																// nuevo en la
																// lista
																// (parametro
																// del servicio)
			partetecnicos.setIdpartec(ObjectConversionManager.convert(
					iterator.next(), Integer.class));
			partetecnicosList.add(partetecnicos);
		}
		this.partetecnicosService.removeMultiple(partetecnicosList);
		PartetecnicosController.logger
				.info("[POST - DELETE_ALL] : Partetecnicos borrados correctamente");
		return partetecnicosIds;
	}

	/**
	 * Method 'obtenerTecnicosParteAsignadosGrid'.
	 * 
	 * @param filterTecnicos
	 *            Tecnicos
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "obtenerTecnicosParteAsignadosGrid", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel obtenerTecnicosParteAsignadosGrid(HttpServletRequest req,
			@ModelAttribute Tecnicos filterTecnicos,
			@ModelAttribute Pagination pagination) {

		Integer idParte = Integer.parseInt(req.getParameter("idParte"));
		List<Partetecnicos> tecnicoss = this.partetecnicosService
				.tecnicosParteGrid(pagination, idParte);
		Long recordNum = this.partetecnicosService
				.tecnicosParteGridCount(idParte);
		PartetecnicosController.logger
				.info("[GET - jqGrid] : Obtener Tecnicos");
		return new JQGridJSONModel(pagination, recordNum, tecnicoss);
	}

	/**
	 * Method 'finalizarParteTecnico'.
	 * 
	 * @param idParteTec
	 *            Integer
	 * @param valorActual
	 *            String
	 * @param model
	 *            Model
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/finalizarParteTecnico", method = RequestMethod.POST)
	public @ResponseBody
	Partetecnicos finalizarParteTecnico(@RequestParam Integer idParteTec,
			@RequestParam String valorActual, Model model,
			HttpServletRequest request) {

		Partetecnicos tecnicoParteAux = new Partetecnicos();

		tecnicoParteAux.setIdpartec(idParteTec);
		tecnicoParteAux.setFinalizado(valorActual);

		tecnicoParteAux = this.partetecnicosService
				.finalizarParteTec(tecnicoParteAux);

		PartetecnicosController.logger.info("[GET - FINALIZAR PARTE TECNICO] "
				+ idParteTec);

		return tecnicoParteAux;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPartetecnicos
	 *            Partetecnicos
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute Partetecnicos filterPartetecnicos,
			@ModelAttribute Pagination pagination) {
		List<Partetecnicos> partetecnicoss = this.partetecnicosService.findAll(
				filterPartetecnicos, pagination);
		Long recordNum = this.partetecnicosService
				.findAllCount(filterPartetecnicos);
		PartetecnicosController.logger
				.info("[GET - jqGrid] : Obtener Partetecnicos");
		return new JQGridJSONModel(pagination, recordNum, partetecnicoss);
	}

	/**
	 * 
	 * Method 'parteTieneTecnicos'.
	 * 
	 * 
	 * @Param idParte Integer
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return Boolean
	 */

	@RequestMapping(value = "/parteTieneTecnicos", method = RequestMethod.POST)
	public @ResponseBody
	Boolean parteTieneActuaciones(@RequestParam Integer idParte, Model model,
			HttpServletRequest request) {

		Partetecnicos partetecnico = new Partetecnicos();

		PartetecnicosController.logger
				.info("[POST - parteTieneTecnicos] : Comprobando si el parte tiene tecnicos. ");

		partetecnico.setIdparte(idParte);

		List<Partetecnicos> lsParteTecnicos = this.partetecnicosService
				.findAll(partetecnico, null);
		if (lsParteTecnicos.size() > 0) {
			return true;
		} else {
			return false;
		}

	}

}
