package com.ejie.aa20b.control;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;

import javax.activation.DataHandler;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;

import weblogic.utils.encoders.BASE64Decoder;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.informes.t07bGeneraPDF_RTF;
import com.ejie.aa20b.informes.listados.Correctivos;
import com.ejie.aa20b.informes.listados.EjecFechaEj;
import com.ejie.aa20b.informes.listados.EjecTecnico;
import com.ejie.aa20b.informes.listados.PendAsignar;
import com.ejie.aa20b.informes.listados.PendEjecAuto;
import com.ejie.aa20b.informes.listados.PendEjecManual;
import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Departamentos;
import com.ejie.aa20b.model.Direcciones;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Espacio;
import com.ejie.aa20b.model.Partepdf;
import com.ejie.aa20b.model.Parteplano;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.Partetecnicos;
import com.ejie.aa20b.model.Partetecnicosgmao;
import com.ejie.aa20b.model.PlanGeneral;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.Presencia;
import com.ejie.aa20b.model.Servicios;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Usuarios;
import com.ejie.aa20b.model.Usutecnicos;
import com.ejie.aa20b.model.Zonas;
import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.Aa20bUsuarioXLNETService;
import com.ejie.aa20b.service.ClaseService;
import com.ejie.aa20b.service.CodigoService;
import com.ejie.aa20b.service.DepartamentosService;
import com.ejie.aa20b.service.DireccionesService;
import com.ejie.aa20b.service.EdificiosService;
import com.ejie.aa20b.service.EspacioService;
import com.ejie.aa20b.service.PartepdfService;
import com.ejie.aa20b.service.ParteplanoService;
import com.ejie.aa20b.service.PartesService;
import com.ejie.aa20b.service.PartetecnicosService;
import com.ejie.aa20b.service.PartetecnicosgmaoService;
import com.ejie.aa20b.service.PlantasService;
import com.ejie.aa20b.service.PresenciaService;
import com.ejie.aa20b.service.ServiciosService;
import com.ejie.aa20b.service.TecnicosService;
import com.ejie.aa20b.service.UsuariosService;
import com.ejie.aa20b.service.UsutecnicosService;
import com.ejie.aa20b.service.ZonasService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;

/**
 * PartesController generated by UDA, 28-nov-2014 11:59:05.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/partes")
public class PartesController {

	private static final Logger logger = LoggerFactory
			.getLogger(PartesController.class);

	@Autowired
	private PartesService partesService;

	@Autowired
	private EdificiosService edificiosService;

	@Autowired
	private DepartamentosService departamentosService;

	@Autowired
	private DireccionesService direccionesService;

	@Autowired
	private PlantasService plantasService;

	@Autowired
	private ZonasService zonasService;

	@Autowired
	private ClaseService clasesService;

	@Autowired
	private CodigoService codigosService;

	@Autowired
	private EspacioService espaciosService;

	@Autowired
	private TecnicosService tecnicosService;

	@Autowired
	private PresenciaService presenciaService;

	@Autowired
	private PartetecnicosService partetecnicosService;

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private UsuarioXLNETController usuarioXLNETController;

	@Autowired
	private Aa20bUsuarioXLNETService usuarioXLNETService;

	@Autowired
	private UsutecnicosService usuTecnicosService;

	@Autowired
	private UsuariosService usuariosService;

	@Autowired
	private ServiciosService serviciosService;

	@Autowired
	private ParteplanoService parteplanoService;

	@Autowired
	private PartepdfService partepdfService;

	@Autowired
	private PartetecnicosgmaoService partetecnicosgmaoServices;

	@Autowired
	private Aa20bProcesosJMSService procesosJMSService;

	@InitBinder
	protected void initBinder(HttpServletRequest request,
			ServletRequestDataBinder binder) throws ServletException {
		binder.registerCustomEditor(byte[].class,
				new ByteArrayMultipartFileEditor());
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : partes");

		request.getSession().removeAttribute("FiltroPartes");

		return "partes";
	}

	/**
	 * Method 'maintVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintVolver", method = RequestMethod.GET)
	public String maintVolver(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : partes");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Partes parteFiltro = (Partes) request.getSession().getAttribute(
				"FiltroPartes");

		model.addAttribute("FiltroParte", parteFiltro);

		return "partes";
	}

	/**
	 * Method 'corrPendAsignarVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "corrPendAsignarVolver", method = RequestMethod.GET)
	public String corrPendAsignarVolver(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : partes");
		model.addAttribute("Pendiente", "CorrAsignar");
		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Partes parteFiltro = (Partes) request.getSession().getAttribute(
				"FiltroPartes");

		model.addAttribute("FiltroParte", parteFiltro);

		return "corrPendientes";
	}

	/**
	 * Method 'corrPendAsignar'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "corrPendAsignar", method = RequestMethod.GET)
	public String corrPendAsignar(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : partes");
		model.addAttribute("Pendiente", "CorrAsignar");
		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroPartes");

		return "corrPendientes";
	}

	/**
	 * Method 'corrAutVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "corrAutVolver", method = RequestMethod.GET)
	public String corrAutVolver(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : partes");
		model.addAttribute("Pendiente", "CorrAut");
		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Partes parteFiltro = (Partes) request.getSession().getAttribute(
				"FiltroPartes");

		model.addAttribute("FiltroParte", parteFiltro);
		return "corrPendientes";
	}

	/**
	 * Method 'corrAut'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "corrAut", method = RequestMethod.GET)
	public String corrAut(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : partes");
		model.addAttribute("Pendiente", "CorrAut");
		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroPartes");

		return "corrPendientes";
	}

	/**
	 * Method 'corrManVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "corrManVolver", method = RequestMethod.GET)
	public String corrManVolver(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : partes");
		model.addAttribute("Pendiente", "CorrMan");
		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Partes parteFiltro = (Partes) request.getSession().getAttribute(
				"FiltroPartes");

		model.addAttribute("FiltroParte", parteFiltro);
		return "corrPendientes";
	}

	/**
	 * Method 'corrMan'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "corrMan", method = RequestMethod.GET)
	public String corrMan(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : partes");
		model.addAttribute("Pendiente", "CorrMan");
		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroPartes");

		return "corrPendientes";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idparte
	 *            Integer
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @param ventanaOrigen
	 *            String
	 * @param accion
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/buscarParte", method = RequestMethod.POST)
	public String getById(@RequestParam Integer idparte,
			@RequestParam String ventanaOrigen, @RequestParam String accion,
			Model model, HttpServletRequest request) {

		PartesController.logger.info("[GET - findBy_PK] : partes");

		Partes parte = new Partes();
		parte.setIdparte(idparte);

		if (accion == null)
			accion = "";

		parte = this.partesService.findParte(parte);

		PartesController.logger.info("[GET - findBy_PK] : partes: "
				+ parte.toString());

		model.addAttribute("Parte", parte);

		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		/**
		 * Busquamos para saber si tiene pdf adjunto
		 */
		Partepdf partepdfAux = new Partepdf();
		partepdfAux.setIdparte(parte.getIdparte());

		byte[] pdf = partepdfService.buscaPdf(partepdfAux);
		if (pdf != null && pdf.length > 0) {
			model.addAttribute("tienePdf", "si");
		} else {
			model.addAttribute("tienePdf", "no");
		}

		return "editarPartes";
	}

	@RequestMapping(value = "/getDocumentoPDF", method = RequestMethod.GET)
	public void getDocumentoFase(
			@RequestParam(value = "idParte", required = false) String idParte,
			HttpServletRequest request, HttpServletResponse response)
			throws IOException {

		Partepdf partePdfAux = new Partepdf();
		partePdfAux.setIdparte(Integer.valueOf(idParte));
		byte[] fileByteArray = this.partepdfService.buscaPdf(partePdfAux);
		ServletOutputStream sos = null;
		BufferedOutputStream bos = null;
		StringBuffer fileName = new StringBuffer("Adjunto");
		if (fileByteArray != null) {

			response.setContentType("application/pdf");
			fileName.append(".");
			fileName.append("pdf");

			response.setContentLength(fileByteArray.length);
			response.setHeader("Pragma", "no-cache");
			response.setHeader("Expires", "-1");
			response.setHeader("Cache-Control",
					"no-store, no-cache, must-revalidate");
			response.setHeader("Content-Disposition", "attachment;filename=\""
					+ fileName + "\"");
			sos = response.getOutputStream();
			bos = new BufferedOutputStream(sos);// NOPMD
			bos.write(fileByteArray);
			bos.flush();
			bos.close();
		}

		// return partePdfAux;
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idparte
	 *            Integer
	 * @param request
	 *            HttpServletRequest
	 * @param model
	 *            Model
	 * @param ventanaOrigen
	 *            String
	 * @param accion
	 *            String
	 * @param pagina
	 *            Long
	 * @return personal Personal
	 */
	@RequestMapping(value = "/buscarParteGrid", method = RequestMethod.POST)
	public String buscarParteGrid(@RequestParam Integer idparte,
			@RequestParam String ventanaOrigen, @RequestParam Long pagina,
			@RequestParam String accion, Model model, HttpServletRequest request) {

		PartesController.logger.info("[GET - findBy_PK] : partes");

		Partes parte = new Partes();
		parte.setIdparte(idparte);

		request.getSession(true).setAttribute("paginaPartes", pagina);

		if (accion == null)
			accion = "";

		parte = this.partesService.findParte(parte);

		PartesController.logger.info("[GET - findBy_PK] : partes: "
				+ parte.toString());

		model.addAttribute("Parte", parte);

		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		/**
		 * Busquamos para saber si tiene pdf adjunto
		 */
		Partepdf partepdfAux = new Partepdf();
		partepdfAux.setIdparte(parte.getIdparte());

		byte[] pdf = this.partepdfService.buscaPdf(partepdfAux);
		if (pdf != null && pdf.length > 0) {
			model.addAttribute("tienePdf", "si");
		} else {
			model.addAttribute("tienePdf", "no");
		}

		return "editarPartes";
	}

	@RequestMapping(value = "/buscarParteGridSoloLectura", method = RequestMethod.POST)
	public String buscarParteGridSL(@RequestParam Integer idparte,
			@RequestParam String ventanaOrigen, @RequestParam int pagina,
			@RequestParam String accion, Model model, HttpServletRequest request) {

		PartesController.logger.info("[GET - findBy_PK] : partes");

		Partes parte = new Partes();
		parte.setIdparte(idparte);

		// request.getSession(true).setAttribute("paginaPartes", pagina);

		if (accion == null)
			accion = "";

		parte = this.partesService.findParte(parte);

		model.addAttribute("Parte", parte);
		model.addAttribute("accion", Aa20bConstantes.ACCION_VER_DETALLE);
		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		/**
		 * Busquamos para saber si tiene pdf adjunto
		 */
		Partepdf partepdfAux = new Partepdf();
		partepdfAux.setIdparte(parte.getIdparte());

		byte[] pdf = this.partepdfService.buscaPdf(partepdfAux);
		if (pdf != null && pdf.length > 0) {
			model.addAttribute("tienePdf", "si");
		} else {
			model.addAttribute("tienePdf", "no");
		}

		return "consultarPartes";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idparte
	 *            Integer
	 * @return personal Personal
	 */
	@RequestMapping(value = "/buscarParteGridPG", method = RequestMethod.POST)
	public String buscarParteGridPG(@RequestParam Integer idparte,
			@RequestParam String ventanaOrigen, @RequestParam String paginaPG,
			Model model, HttpServletRequest request) {

		PartesController.logger.info("[GET - findBy_PK] : partes");

		Partes parte = new Partes();
		parte.setIdparte(idparte);

		parte = this.partesService.findParte(parte);

		PartesController.logger.info("[GET - findBy_PK] : partes: "
				+ parte.toString());

		model.addAttribute("Parte", parte);

		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		// Meto en sesión la página en la que se encuentra dentro de la
		// planificacion general
		request.getSession().setAttribute("paginaPG", paginaPG);

		PlanGeneral planGeneral = (PlanGeneral) request.getSession()
				.getAttribute("PlanGeneral");
		if (planGeneral != null) {
			model.addAttribute("PlanGeneral", planGeneral);
			// request.getSession().removeAttribute("PlanGeneral");
		}

		/**
		 * Busquamos para saber si tiene pdf adjunto
		 */
		Partepdf partepdfAux = new Partepdf();
		partepdfAux.setIdparte(parte.getIdparte());

		byte[] pdf = partepdfService.buscaPdf(partepdfAux);
		if (pdf != null && pdf.length > 0) {
			model.addAttribute("tienePdf", "si");
		} else {
			model.addAttribute("tienePdf", "no");
		}

		return "editarPartes";
	}

	/**
	 * Method 'abrirParteDesdeFicha'.
	 * 
	 * @param idparte
	 *            Integer
	 * @return personal Personal
	 */
	@RequestMapping(value = "/abrirParteDesdeFicha", method = RequestMethod.POST)
	public String abrirParteDesdeFicha(@RequestParam Integer idparte,
			@RequestParam String idfichaPC, @RequestParam String accion,
			Model model, HttpServletRequest request) {

		PartesController.logger.info("[GET - findBy_PK] : partes");

		Partes parte = new Partes();
		parte.setIdparte(idparte);

		if (accion == null)
			accion = "";

		parte = this.partesService.findParte(parte);

		PartesController.logger.info("[GET - findBy_PK] : partes: "
				+ parte.toString());

		model.addAttribute("Parte", parte);

		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		// Para poder volver a la ficha que ha generado el parte.
		model.addAttribute("ventanaOrigen", "Ficha");
		model.addAttribute("idFicha", idfichaPC);

		/**
		 * Busquamos para saber si tiene pdf adjunto
		 */
		Partepdf partepdfAux = new Partepdf();
		partepdfAux.setIdparte(parte.getIdparte());

		byte[] pdf = partepdfService.buscaPdf(partepdfAux);
		if (pdf != null && pdf.length > 0) {
			model.addAttribute("tienePdf", "si");
		} else {
			model.addAttribute("tienePdf", "no");
		}

		return "editarPartes";
	}

	@RequestMapping(value = "/abrirParteDesdeFichaSoloLectura", method = RequestMethod.POST)
	public String abrirParteDesdeFichaSoloLectura(
			@RequestParam Integer idparte, @RequestParam String idfichaPC,
			@RequestParam String accion, Model model, HttpServletRequest request) {

		PartesController.logger.info("[GET - findBy_PK] : partes");

		Partes parte = new Partes();
		parte.setIdparte(idparte);

		if (accion == null)
			accion = "";

		parte = this.partesService.findParte(parte);

		PartesController.logger.info("[GET - findBy_PK] : partes: "
				+ parte.toString());

		model.addAttribute("Parte", parte);

		model.addAttribute("accion", Aa20bConstantes.ACCION_VER_DETALLE);
		// Para poder volver a la ficha que ha generado el parte.
		model.addAttribute("ventanaOrigen", "Ficha");
		model.addAttribute("idFicha", idfichaPC);

		/**
		 * Busquamos para saber si tiene pdf adjunto
		 */
		Partepdf partepdfAux = new Partepdf();
		partepdfAux.setIdparte(parte.getIdparte());

		byte[] pdf = this.partepdfService.buscaPdf(partepdfAux);
		if (pdf != null && pdf.length > 0) {
			model.addAttribute("tienePdf", "si");
		} else {
			model.addAttribute("tienePdf", "no");
		}

		return "consultarPartes";
	}

	/**
	 * Method 'abrirParteDesdeFicha'.
	 * 
	 * @param idparte
	 *            Integer
	 * @return personal Personal
	 */
	@RequestMapping(value = "/abrirParteDesdeAgenda", method = RequestMethod.POST)
	public String abrirParteDesdeAgenda(@RequestParam Integer idparte,
			@RequestParam String fechaAgenda, @RequestParam String accion,
			Model model, HttpServletRequest request) {

		PartesController.logger.info("[GET - findBy_PK] : partes");

		Partes parte = new Partes();
		parte.setIdparte(idparte);

		if (accion == null)
			accion = "";

		parte = this.partesService.findParte(parte);

		PartesController.logger.info("[GET - findBy_PK] : partes: "
				+ parte.toString());

		model.addAttribute("Parte", parte);

		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		// Para poder volver a la ficha que ha generado el parte.
		model.addAttribute("ventanaOrigen", "Agenda");
		model.addAttribute("fechaAgenda", fechaAgenda);

		/**
		 * Busquamos para saber si tiene pdf adjunto
		 */
		Partepdf partepdfAux = new Partepdf();
		partepdfAux.setIdparte(parte.getIdparte());

		byte[] pdf = partepdfService.buscaPdf(partepdfAux);
		if (pdf != null && pdf.length > 0) {
			model.addAttribute("tienePdf", "si");
		} else {
			model.addAttribute("tienePdf", "no");
		}

		return "editarPartes";
	}

	/**
	 * Method 'nuevoParte'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 * @throws SecurityHelpperException
	 */
	@RequestMapping(value = "nuevoParte", method = RequestMethod.GET)
	public String nuevoParte(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : nuevo Parte Responsable");

		model.addAttribute("accion", Aa20bConstantes.ACCION_NUEVO);
		return "editarPartes";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idparte
	 *            Integer
	 * @return partes Partes
	 */
	@RequestMapping(value = "/{idparte}", method = RequestMethod.GET)
	public @ResponseBody
	Partes getById(@PathVariable Integer idparte) {
		Partes partes = new Partes();
		partes.setIdparte(idparte);
		partes = this.partesService.find(partes);
		PartesController.logger
				.info("[GET - findBy_PK] : Obtener Partes por PK");
		return partes;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Partes> getAll(@ModelAttribute Partes filterPartes) {
		PartesController.logger
				.info("[GET - find_ALL] : Obtener Partes por filtro");
		return this.partesService.findAll(filterPartes, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Partes edit(@RequestBody Partes partes) {
		Partes partesAux = this.partesService.update(partes);
		PartesController.logger
				.info("[PUT] : Partes actualizado correctamente");
		return partesAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Partes add(@RequestBody Partes partes) {
		Partes partesAux = this.partesService.add(partes);
		PartesController.logger.info("[POST] : Partes insertado correctamente");
		return partesAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idparte
	 *            Integer
	 * @return partes
	 */
	@RequestMapping(value = "/{idparte}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Partes remove(@PathVariable Integer idparte) {
		Partes partes = new Partes();
		partes.setIdparte(idparte);
		this.partesService.remove(partes);
		PartesController.logger.info("[DELETE] : Partes borrado correctamente");
		return partes;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param partesIds
	 *            List
	 * @return partesList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> partesIds) {
		List<Partes> partesList = new ArrayList<Partes>();
		for (List<String> partesId : partesIds) {
			Iterator<String> iterator = partesId.iterator();
			Partes partes = new Partes(); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			partes.setIdparte(ObjectConversionManager.convert(iterator.next(),
					Integer.class));
			partesList.add(partes);
		}
		this.partesService.removeMultiple(partesList);
		PartesController.logger
				.info("[POST - DELETE_ALL] : Partes borrados correctamente");
		return partesIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Partes filterPartes,
			@ModelAttribute Pagination pagination) {
		List<Partes> partess = this.partesService.findAllLike(filterPartes,
				pagination, false);
		Long recordNum = this.partesService.findAllLikeCount(filterPartes,
				false);
		PartesController.logger.info("[GET - jqGrid] : Obtener Partes");
		return new JQGridJSONModel(pagination, recordNum, partess);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridPartes", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridPartes(@ModelAttribute Partes filterPartes,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {

		if (request.getSession(true).getAttribute("paginaPartes") != null) {
			pagination.setPage((Long) request.getSession(true).getAttribute(
					"paginaPartes"));
		}

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) { // TODO Auto-generated catch
												// block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				if (filterPartes != null && filterPartes.getCodigo() != null) {
					codigo = filterPartes.getCodigo();
				}
				codigo.setIdservicio(usuario.getIdservicio());

				filterPartes.setCodigo(codigo);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		List<Partes> partess = this.partesService.obtenerPartesGrid(
				filterPartes, pagination, false, sUIDUsuario);

		Long recordNum = this.partesService.obtenerPartesGridCount(
				filterPartes, false, sUIDUsuario);
		PartesController.logger.info("[GET - jqGrid] : Obtener Partes");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterPartes.getFechareD() != null) {
			try {
				filterPartes.setStrFechareD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareD(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (filterPartes.getFechareH() != null) {
			try {
				filterPartes.setStrFechareH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareH(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifD() != null) {
			try {
				filterPartes.setStrFechaplanifD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifD(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifH() != null) {
			try {
				filterPartes.setStrFechaplanifH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifH(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroPartes", filterPartes);

		request.getSession(true).setAttribute("paginaPartes", null);
		return new JQGridJSONModel(pagination, recordNum, partess);
	}

	/**
	 * Method 'gridListCorr'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridListCorr", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridListCorr(@ModelAttribute Partes filterPartes,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {

		if (request.getSession(true).getAttribute("paginaPartes") != null) {
			pagination.setPage((Long) request.getSession(true).getAttribute(
					"paginaPartes"));
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				if (filterPartes != null && filterPartes.getCodigo() != null) {
					codigo = filterPartes.getCodigo();
				}
				codigo.setIdservicio(usuario.getIdservicio());
				filterPartes.setCodigo(codigo);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		List<Partes> partess = this.partesService.obtenerListCorrGrid(
				filterPartes, pagination, false, sUIDUsuario);

		Long recordNum = this.partesService.obtenerListCorrGridCount(
				filterPartes, false, sUIDUsuario);
		PartesController.logger
				.info("[GET - jqGrid] : Obtener Listado Correctivos");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterPartes.getFechareD() != null) {
			try {
				filterPartes.setStrFechareD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareD(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (filterPartes.getFechareH() != null) {
			try {
				filterPartes.setStrFechareH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareH(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifD() != null) {
			try {
				filterPartes.setStrFechaplanifD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifD(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifH() != null) {
			try {
				filterPartes.setStrFechaplanifH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifH(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroPartes", filterPartes);

		request.getSession(true).setAttribute("paginaPartes", null);
		return new JQGridJSONModel(pagination, recordNum, partess);
	}

	/**
	 * Method 'gridListEjecTecnico'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridListEjecTecnico", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridListEjecTecnico(@ModelAttribute Partes filterPartes,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {

		if (request.getSession(true).getAttribute("paginaPartes") != null) {
			pagination.setPage((Long) request.getSession(true).getAttribute(
					"paginaPartes"));
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);

			request.getSession().setAttribute("idUsuario", sUIDUsuario);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				if (filterPartes != null && filterPartes.getCodigo() != null) {
					codigo = filterPartes.getCodigo();
				}
				codigo.setIdservicio(usuario.getIdservicio());
				filterPartes.setCodigo(codigo);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		List<Partes> partess = this.partesService.obtenerListEjecTecnicoGrid(
				filterPartes, pagination, false, sUIDUsuario);

		/**
		 * Repetimos la consulta sin paginación para obtener el total de tiempo
		 * (pendiente de mejorar)
		 */
		List<Partes> partesTotalTiempo = this.partesService
				.obtenerListEjecTecnicoGrid(filterPartes, null, false,
						sUIDUsuario);

		// Calculamos el total de minutos
		int totalMinutos = 0;
		for (Partes parteAuxTiempo : partesTotalTiempo) {
			if (parteAuxTiempo.getTiempoReal() != null) {
				totalMinutos = totalMinutos + parteAuxTiempo.getTiempoReal();
			}
		}
		request.getSession().setAttribute("totalTiempo", totalMinutos);

		Long recordNum = this.partesService.obtenerListEjecTecnicoGridCount(
				filterPartes, false, sUIDUsuario);
		PartesController.logger
				.info("[GET - jqGrid] : Obtener Listado Ejecutados por Técnico");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterPartes.getFechareD() != null) {
			try {
				filterPartes.setStrFechareD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareD(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (filterPartes.getFechareH() != null) {
			try {
				filterPartes.setStrFechareH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareH(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifD() != null) {
			try {
				filterPartes.setStrFechaplanifD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifD(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifH() != null) {
			try {
				filterPartes.setStrFechaplanifH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifH(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroPartes", filterPartes);

		request.getSession(true).setAttribute("paginaPartes", null);
		return new JQGridJSONModel(pagination, recordNum, partess);
	}

	@RequestMapping(value = "/obtenerTiempoTotalListado", method = RequestMethod.POST)
	public @ResponseBody
	int obtenerTiempoTotalListado(Model model, HttpServletRequest request) {

		int tiempoTotal = 0;
		if (request.getSession(true).getAttribute("totalTiempo") != null) {
			tiempoTotal = Integer.valueOf(
					request.getSession(true).getAttribute("totalTiempo")
							.toString()).intValue();
		}

		return tiempoTotal;

	}

	/**
	 * Method 'gridListEjecFechaEj'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridListEjecFechaEj", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridListEjecFechaEj(@ModelAttribute Partes filterPartes,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {

		if (request.getSession(true).getAttribute("paginaPartes") != null) {
			pagination.setPage((Long) request.getSession(true).getAttribute(
					"paginaPartes"));
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
			request.getSession().setAttribute("idUsuario", sUIDUsuario);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				if (filterPartes != null && filterPartes.getCodigo() != null) {
					codigo = filterPartes.getCodigo();
				}
				codigo.setIdservicio(usuario.getIdservicio());
				filterPartes.setCodigo(codigo);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		List<Partes> partess = this.partesService.obtenerListEjecFechaEjGrid(
				filterPartes, pagination, false, sUIDUsuario);

		/**
		 * Repetimos la búsqueda sin paginación para obtener el total de tiempo
		 * (pendiente de mejorar)
		 */
		List<Partes> partesTotalTiempo = this.partesService
				.obtenerListEjecFechaEjGrid(filterPartes, null, false,
						sUIDUsuario);

		// Calculamos el total de minutos
		int totalMinutos = 0;
		for (Partes parteAuxTiempo : partesTotalTiempo) {
			if (parteAuxTiempo.getTiempoReal() != null) {
				totalMinutos = totalMinutos + parteAuxTiempo.getTiempoReal();
			}
		}
		request.getSession().setAttribute("totalTiempo", totalMinutos);

		Long recordNum = this.partesService.obtenerListEjecFechaEjGridCount(
				filterPartes, false, sUIDUsuario);
		PartesController.logger
				.info("[GET - jqGrid] : Obtener Listado Ejecutados por Fecha ");
		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterPartes.getFechareD() != null) {
			try {
				filterPartes.setStrFechareD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareD(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (filterPartes.getFechareH() != null) {
			try {
				filterPartes.setStrFechareH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareH(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifD() != null) {
			try {
				filterPartes.setStrFechaplanifD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifD(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifH() != null) {
			try {
				filterPartes.setStrFechaplanifH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifH(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroPartes", filterPartes);

		request.getSession(true).setAttribute("paginaPartes", null);
		return new JQGridJSONModel(pagination, recordNum, partess);
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridCorrPendAsignar", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridCorrPendAsignar(@ModelAttribute Partes filterPartes,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				if (filterPartes.getCodigo() != null) {
					codigo = filterPartes.getCodigo();
				}
				codigo.setIdservicio(usuario.getIdservicio());
				filterPartes.setCodigo(codigo);

			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}
		filterPartes.setNoProcede("1");
		List<Partes> partess = this.partesService.obtenerCorrPendAsignar(
				filterPartes, pagination, false, sUIDUsuario);

		Long recordNum = this.partesService.obtenerCorrPendAsignarCount(
				filterPartes, false, sUIDUsuario);
		PartesController.logger
				.info("[GET - jqGrid] : Obtener Partes correctivos pendientes de asignar tecnicos");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterPartes.getFechareD() != null) {
			try {
				filterPartes.setStrFechareD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareD(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (filterPartes.getFechareH() != null) {
			try {
				filterPartes.setStrFechareH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareH(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifD() != null) {
			try {
				filterPartes.setStrFechaplanifD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifD(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifH() != null) {
			try {
				filterPartes.setStrFechaplanifH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifH(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroPartes", filterPartes);
		return new JQGridJSONModel(pagination, recordNum, partess);
	}

	/**
	 * Method 'imprimirCorrPendAsignar'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirCorrPendAsignar", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirCorrPendAsignar(@ModelAttribute Partes filterPartes,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;
		Date dateFechaPlanifD = null;
		Date dateFechaPlanifH = null;

		if (filterPartes != null && filterPartes.getStrFechareD() != null
				&& !filterPartes.getStrFechareD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterPartes.getStrFechareD());
				filterPartes.setFechareD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterPartes != null && filterPartes.getStrFechareH() != null
				&& !filterPartes.getStrFechareH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterPartes.getStrFechareH());
				filterPartes.setFechareH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

		if (filterPartes != null && filterPartes.getStrFechaplanifD() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifD = sdf.parse(filterPartes.getStrFechaplanifD());
				filterPartes.setFechaplanifD(dateFechaPlanifD);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes != null && filterPartes.getStrFechaplanifH() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifH = sdf.parse(filterPartes.getStrFechaplanifH());
				filterPartes.setFechaplanifH(dateFechaPlanifH);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Integer idficha = filterFicha.getIdficha();

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		PendAsignar pendAsignar = new PendAsignar();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.partesService
					.montarSelectTablaCorrPendAsignar(idioma, filterPartes,
							sUIDUsuario);

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, pendAsignar
						.getFoPendAsignarXml(request, locale, listaTabla,
								filterPartes),
						Aa20bConstantes.plantillaPendAsignareu);

			} else {
				generaPdfRtf.generarXML2PDF(response, pendAsignar
						.getFoPendAsignarXml(request, locale, listaTabla,
								filterPartes),
						Aa20bConstantes.plantillaPendAsignar);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'imprimirCorrPendEjecManual'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirCorrPendEjecManual", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirCorrPendEjecManual(@ModelAttribute Partes filterPartes,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;
		Date dateFechaPlanifH = null;
		Date dateFechaPlanifD = null;

		if (filterPartes != null && filterPartes.getStrFechareD() != null
				&& filterPartes.getStrFechareD() != null
				&& !filterPartes.getStrFechareD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterPartes.getStrFechareD());
				filterPartes.setFechareD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterPartes != null && filterPartes.getStrFechareH() != null
				&& !filterPartes.getStrFechareH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterPartes.getStrFechareH());
				filterPartes.setFechareH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

		if (filterPartes != null && filterPartes.getStrFechaplanifD() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifD = sdf.parse(filterPartes.getStrFechaplanifD());
				filterPartes.setFechaplanifD(dateFechaPlanifD);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes != null && filterPartes.getStrFechaplanifH() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifH = sdf.parse(filterPartes.getStrFechaplanifH());
				filterPartes.setFechaplanifH(dateFechaPlanifH);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Integer idficha = filterFicha.getIdficha();

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		PendEjecManual pendEjecManual = new PendEjecManual();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.partesService
					.montarSelectTablaCorrPendEjecManual(idioma, filterPartes,
							sUIDUsuario);

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, pendEjecManual
						.getFoPendEjecManualXml(request, locale, listaTabla,
								filterPartes),
						Aa20bConstantes.plantillaPendEjecManualeu);

			} else {
				generaPdfRtf.generarXML2PDF(response, pendEjecManual
						.getFoPendEjecManualXml(request, locale, listaTabla,
								filterPartes),
						Aa20bConstantes.plantillaPendEjecManual);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'imprimirCorrPendEjecAuto'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirCorrPendEjecAuto", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirCorrPendEjecAuto(@ModelAttribute Partes filterPartes,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;
		Date dateFechaPlanifD = null;
		Date dateFechaPlanifH = null;

		if (filterPartes != null && filterPartes.getStrFechareD() != null
				&& !filterPartes.getStrFechareD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterPartes.getStrFechareD());
				filterPartes.setFechareD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterPartes != null && filterPartes.getStrFechareH() != null
				&& !filterPartes.getStrFechareH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterPartes.getStrFechareH());
				filterPartes.setFechareH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

		if (filterPartes != null && filterPartes.getStrFechaplanifD() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifD = sdf.parse(filterPartes.getStrFechaplanifD());
				filterPartes.setFechaplanifD(dateFechaPlanifD);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes != null && filterPartes.getStrFechaplanifH() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifH = sdf.parse(filterPartes.getStrFechaplanifH());
				filterPartes.setFechaplanifH(dateFechaPlanifH);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Integer idficha = filterFicha.getIdficha();

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		PendEjecAuto pendEjecAuto = new PendEjecAuto();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.partesService
					.montarSelectTablaCorrPendEjecAuto(idioma, filterPartes,
							sUIDUsuario);

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, pendEjecAuto
						.getFoPendEjecAutoXml(request, locale, listaTabla,
								filterPartes),
						Aa20bConstantes.plantillaPendEjecAutoeu);

			} else {
				generaPdfRtf.generarXML2PDF(response, pendEjecAuto
						.getFoPendEjecAutoXml(request, locale, listaTabla,
								filterPartes),
						Aa20bConstantes.plantillaPendEjecAuto);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridCorrAutomatico", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridCorrAutomatico(@ModelAttribute Partes filterPartes,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				if (filterPartes.getCodigo() != null) {
					codigo = filterPartes.getCodigo();
				}
				codigo.setIdservicio(usuario.getIdservicio());
				filterPartes.setCodigo(codigo);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		List<Partes> partess = this.partesService.obtenerCorrAut(filterPartes,
				pagination, false, sUIDUsuario);

		Long recordNum = this.partesService.obtenerCorrAutCount(filterPartes,
				false, sUIDUsuario);
		PartesController.logger
				.info("[GET - jqGrid] : Obtener Partes correctivos asignados automaticamente pendientes de ejecutar");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterPartes.getFechareD() != null) {
			try {
				filterPartes.setStrFechareD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareD(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (filterPartes.getFechareH() != null) {
			try {
				filterPartes.setStrFechareH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareH(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifD() != null) {
			try {
				filterPartes.setStrFechaplanifD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifD(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifH() != null) {
			try {
				filterPartes.setStrFechaplanifH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifH(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroPartes", filterPartes);

		return new JQGridJSONModel(pagination, recordNum, partess);
	}

	/**
	 * Method 'gridCorrManual'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridCorrManual", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridCorrManual(@ModelAttribute Partes filterPartes,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				if (filterPartes.getCodigo() != null) {
					codigo = filterPartes.getCodigo();
				}
				codigo.setIdservicio(usuario.getIdservicio());
				filterPartes.setCodigo(codigo);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		List<Partes> partess = this.partesService.obtenerCorrMan(filterPartes,
				pagination, false, sUIDUsuario);

		Long recordNum = this.partesService.obtenerCorrManCount(filterPartes,
				false, sUIDUsuario);
		PartesController.logger
				.info("[GET - jqGrid] : Obtener Partes correctivos asignados manualmente pendientes de ejecutar");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterPartes.getFechareD() != null) {
			try {
				filterPartes.setStrFechareD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareD(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (filterPartes.getFechareH() != null) {
			try {
				filterPartes.setStrFechareH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechareH(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifD() != null) {
			try {
				filterPartes.setStrFechaplanifD(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifD(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes.getFechaplanifH() != null) {
			try {
				filterPartes.setStrFechaplanifH(Aa20bFecha.getFechaFormateada(
						filterPartes.getFechaplanifH(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroPartes", filterPartes);

		return new JQGridJSONModel(pagination, recordNum, partess);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 * @throws SecurityHelpperException
	 */
	@RequestMapping(value = "nuevo", method = RequestMethod.GET)
	public String getCreateForm4(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : nuevo Parte");

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);

		return "nuevoPartes";
	}

	/**
	 * Method 'editarPartes'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 * @throws SecurityHelpperException
	 */
	@RequestMapping(value = "editarPartes", method = RequestMethod.GET)
	public String editarPartes(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : editar Parte ");

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);

		return "editarPartes";
	}

	/**
	 * Method 'getRemoteComboDepartamentos'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "departamentos/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Departamentos> getRemoteComboDepartamentos(Model model) {
		PartesController.logger
				.info("[GET - View] : getRemoteComboDepartamentos");
		model.addAttribute("departamentos",
				this.departamentosService.findAll(null, null));
		return this.departamentosService.findAll(null, null);
	}

	/**
	 * Method 'getRemoteComboDepartamentosAlta'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "departamentosAlta/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Departamentos> getRemoteComboDepartamentosAlta(Model model) {
		PartesController.logger
				.info("[GET - View] : getRemoteComboDepartamentosAlta");
		Departamentos dptos = new Departamentos();
		dptos.setBaja("0");
		model.addAttribute("departamentos",
				this.departamentosService.findAll(dptos, null));
		return this.departamentosService.findAll(dptos, null);
	}

	/**
	 * Method 'getRemoteComboDirecciones'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "direcciones/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Direcciones> getRemoteComboDirecciones(
			@RequestParam(value = "comboDepartamentos", required = false) Long cod_departamento) {
		PartesController.logger
				.info("[GET - View] : getRemoteComboDirecciones");

		Direcciones direccion = new Direcciones();
		direccion.setIddepar(cod_departamento);

		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		return this.direccionesService.findAllFormateado(direccion, null);
	}

	/**
	 * Method 'getRemoteComboDireccionesAlta'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "direccionesAlta/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Direcciones> getRemoteComboDireccionesAlta(
			@RequestParam(value = "comboDepartamentos", required = false) Long cod_departamento) {
		PartesController.logger
				.info("[GET - View] : getRemoteComboDireccionesAlta");

		Direcciones direccion = new Direcciones();
		direccion.setIddepar(cod_departamento);
		direccion.setBaja("0");
		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		return this.direccionesService.findAllFormateado(direccion, null);
	}

	/**
	 * Method 'getRemoteComboEdificios'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "edificios/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Edificios> getRemoteComboEdificios(Model model) {
		PartesController.logger.info("[GET - View] : obtenercomboedificios");
		model.addAttribute("edificios",
				this.edificiosService.findAll(null, null));
		return this.edificiosService.findAll(null, null);
	}

	/**
	 * Method 'edificiosUsuario'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "edificiosUsuario/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Edificios> edificiosUsuario(Model model) {
		PartesController.logger.info("[GET - View] : edificiosUsuario");

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETService.obtenerUIDUsuario();
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		List<Edificios> edificioss = this.edificiosService
				.obtenerEdificiosUsuario(null, null, false, sUIDUsuario);

		model.addAttribute("edificios", edificioss);

		// return this.edificiosService.findAll(null, null);
		return edificioss;
	}

	/**
	 * Method 'getRemoteComboPlantasZona'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "plantasZona/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Plantas> getRemoteComboPlantasZona(
			@RequestParam(value = "comboZonas", required = false) Integer cod_Zona,
			@RequestParam(value = "comboEdificios", required = false) String codEdif) {
		PartesController.logger
				.info("[GET - View] : getRemoteComboPlantasZona");

		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}

		return this.plantasService
				.obtenerPlantasEdifZonaAlta(codEdif, cod_Zona);
	}

	/**
	 * Method 'getRemoteComboPlantas'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "plantas/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Plantas> getRemoteComboPlantas(Model model) {
		PartesController.logger.info("[GET - View] : obtenercomboPlantas");
		Plantas planta = new Plantas();
		planta.setBaja("0");
		model.addAttribute("plantas", this.plantasService.findAll(planta, null));
		return this.plantasService.findAll(planta, null);
	}

	/**
	 * Method 'getRemoteComboPlantasAlta'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "plantasAlta/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Plantas> getRemoteComboPlantasAlta(Model model) {
		PartesController.logger
				.info("[GET - View] : getRemoteComboPlantasAlta");
		Plantas plantas = new Plantas();
		plantas.setBaja("0");
		model.addAttribute("plantas",
				this.plantasService.findAll(plantas, null));
		return this.plantasService.findAll(plantas, null);
	}

	/**
	 * Method 'getRemoteComboZonas'. Obtiene las zonas asociadas a un edificio.
	 * 
	 * @param codEdif
	 *            String
	 * 
	 * @return List
	 */
	@RequestMapping(value = "zonasEdif/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Zonas> getRemoteComboZonas(
			@RequestParam(value = "comboEdificios", required = false) String codEdif) {
		PartesController.logger.info("[GET - View] : obtenercomboZonas");

		try {
			Thread.sleep(1000);
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
		// model.addAttribute("zonas", this.zonasService.findAll(null, null));

		return this.zonasService.obtenerZonasEdifAlta(codEdif);
	}

	/**
	 * Method 'getRemoteComboZonas'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "zonas/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Zonas> getRemoteComboZonas(Model model) {
		PartesController.logger.info("[GET - View] : obtenercomboZonas");
		Zonas zona = new Zonas();
		zona.setBaja("0");
		model.addAttribute("zonas", this.zonasService.findAll(zona, null));
		return this.zonasService.findAll(zona, null);
	}

	/**
	 * Method 'getRemoteComboZonasAlta'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "zonasAlta/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Zonas> getRemoteComboZonasAlta(Model model) {
		PartesController.logger.info("[GET - View] : getRemoteComboZonasAlta");
		Zonas zonas = new Zonas();
		zonas.setBaja("0");
		model.addAttribute("zonas", this.zonasService.findAll(zonas, null));
		return this.zonasService.findAll(zonas, null);
	}

	/**
	 * Method 'getRemoteComboClasesActivo'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "clasesActivo/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Clase> getRemoteComboClasesActivo(Model model) {
		PartesController.logger
				.info("[GET - View] : getRemoteComboClasesActivo");
		model.addAttribute("clases", this.clasesService.findAll(null, null));
		return this.clasesService.findAll(null, null);
	}

	/**
	 * Method 'buscaZonasOcupadas'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "activos/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Codigo> buscaZonasOcupadas(
			@RequestParam(value = "idclase", required = false) String idClase,
			Model model) {
		String language = "es";
		PartesController.logger
				.info("[GET - BUSCA activos] : BUSCA activos para una Clase de activos: "
						+ idClase);
		List<Codigo> activos = codigosService.obtenerActivosClase(idClase,
				language);
		model.addAttribute(activos);

		PartesController.logger
				.info("[GET - findBy_PK] : Obtener codigos por PK");
		return activos;

	}

	/**
	 * 
	 * Method 'getRemoteAutocompleteEspacios'.
	 * 
	 * 
	 * 
	 * @param model
	 * 
	 * 
	 * 
	 * @return List
	 */

	@RequestMapping(value = "espacios/autocomplete/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Espacio> getRemoteAutocompleteEspacios(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		// Filtro segÃƒÂºn idioma
		Espacio espacios = new Espacio();
		if (com.ejie.x38.util.Constants.EUSKARA.equals(locale.getLanguage())) {
			espacios.setEespacio(q);
		} else {
			espacios.setCespacio(q);
		}
		return espaciosService.findAllLike(espacios, null, c);
	}

	/**
	 * 
	 * Method 'getRemoteAutocompleteActivos'.
	 * 
	 * 
	 * 
	 * @param model
	 * 
	 * 
	 * 
	 * @return List
	 */

	@RequestMapping(value = "activos/autocomplete/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Codigo> getRemoteAutocompleteActivos(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		// Filtro segÃƒÂºn idioma
		Codigo activo = new Codigo();
		if (com.ejie.x38.util.Constants.EUSKARA.equals(locale.getLanguage())) {
			activo.setEcodigo(q);
		} else {
			activo.setCcodigo(q);
		}
		return codigosService.findAllLike(activo, null, c);
	}

	/**
	 * 
	 * Method 'getRemoteAutocompleteClasesActivo'.
	 * 
	 * 
	 * 
	 * @param model
	 * 
	 * 
	 * 
	 * @return List
	 */

	@RequestMapping(value = "clasesActivo/autocomplete/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Clase> getRemoteAutocompleteClasesActivo(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {
		// Idioma
		Locale locale = LocaleContextHolder.getLocale();
		// Filtro segÃƒÂºn idioma
		Clase clase = new Clase();
		if (com.ejie.x38.util.Constants.EUSKARA.equals(locale.getLanguage())) {
			clase.setEclase(q);
		} else {
			clase.setCclase(q);
		}
		return clasesService.findAllLike(clase, null, c);
	}

	public byte[] decodeToImage(String imageString) {
		byte[] imageByte = null;
		try {
			BASE64Decoder decoder = new BASE64Decoder();
			imageByte = decoder.decodeBuffer(imageString);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return imageByte;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param partes
	 *            Partes
	 * @param request
	 *            HttpServletRequest
	 * @return Partes
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.POST)
	public @ResponseBody
	Partes alta(@ModelAttribute Partes partes, HttpServletRequest request) {

		request.getSession(true).setAttribute("dptoXLNET", "SI");

		Date fechaHoy = new Date();
		partes.setFechare(fechaHoy);

		// Si planta y/o zona son nulas poner a cero
		if (partes.getIdzona() == null) {
			partes.setIdzona(Aa20bConstantes.SIN_ZONAS);
		}
		if (partes.getIdplanta() == null) {
			partes.setIdplanta(Aa20bConstantes.SIN_PLANTAS);
		}

		byte[] arrayPlano = decodeToImage(partes.getPlanoMarcaString());

		partes.setPlanoMarca(arrayPlano);
		// ********************************************************************
		// COMPROBAR LA POSIBILIDAD DE QUE PUEDA SER UNA AVERÃA DUPLICADA
		// Si coincide: Edificio, zona, planta, clase y codigo de activo en otra
		// averÃ­a no ejecutada y no relacionada con
		// coincidente inicial
		// ********************************************************************
		Partes parteDuplicado = new Partes();
		parteDuplicado.setIdedificio(partes.getIdedificio());
		parteDuplicado.setIdzona(partes.getIdzona());
		parteDuplicado.setIdplanta(partes.getIdplanta());
		parteDuplicado.setIdclase(partes.getIdclase());
		parteDuplicado.setIdcodigo(partes.getIdcodigo());
		parteDuplicado.setEjecutado("0");
		parteDuplicado.setAveriaRepe(null);

		List<Partes> ListaDuplicados = this.partesService
				.obtenerParte(parteDuplicado);

		if (ListaDuplicados.size() > 0) {
			// Ha encontrado un duplicado
			// Comprobar si vienen parentesis porque en
			// ese caso se queda bloqueada la pantalla. Como esta información es
			// para pintar la información del parte encontrado, se sustituyen
			// por guiones
			String observac = "";
			if (ListaDuplicados != null && ListaDuplicados.size() > 0
					&& ListaDuplicados.get(0) != null
					&& ListaDuplicados.get(0).getObserv() != null
					&& !ListaDuplicados.get(0).getObserv().equals("")) {
				observac = ListaDuplicados.get(0).getObserv();
				observac = observac.replaceAll("\\(", "-");
				observac = observac.replaceAll("\\)", "-");
				ListaDuplicados.get(0).setObserv(observac);
			}
			ListaDuplicados.get(0).setErrorParte("Parte duplicado");
			ListaDuplicados.get(0).setPlanoMarca(null);

			Partes parteDupla = new Partes();
			parteDupla.setIdparte(ListaDuplicados.get(0).getIdparte());
			parteDupla.setFechare(ListaDuplicados.get(0).getFechare());
			parteDupla.setErrorParte("Parte duplicado");

			String strNombre = ListaDuplicados.get(0).getNombre();
			if (strNombre != null) {
				strNombre = strNombre.replaceAll("\\(", "-");
				strNombre = strNombre.replaceAll("\\)", "-");
			}
			parteDupla.setNombre(strNombre);

			String strEdificio = "";
			if (ListaDuplicados.get(0).getEdificio() != null) {
				strEdificio = ListaDuplicados.get(0).getEdificio()
						.getCedificio();
				if (strEdificio != null) {
					strEdificio = strEdificio.replaceAll("\\(", "-");
					strEdificio = strEdificio.replaceAll("\\)", "-");
				}
			}
			Edificios edificio = new Edificios();
			edificio.setCedificio(strEdificio);
			parteDupla.setEdificio(edificio);

			String strZona = "";
			if (ListaDuplicados.get(0).getZona() != null) {
				strZona = ListaDuplicados.get(0).getZona().getCzona();
				if (strZona != null) {
					strZona = strZona.replaceAll("\\(", "-");
					strZona = strZona.replaceAll("\\)", "-");
				}
			}
			Zonas zona = new Zonas();
			zona.setCzona(strZona);
			parteDupla.setZona(zona);

			String strPlanta = "";
			if (ListaDuplicados.get(0).getPlanta() != null) {
				strPlanta = ListaDuplicados.get(0).getPlanta().getCplanta();
				if (strPlanta != null) {
					strPlanta = strPlanta.replaceAll("\\(", "-");
					strPlanta = strPlanta.replaceAll("\\)", "-");
				}
			}
			Plantas planta = new Plantas();
			planta.setCplanta(strPlanta);
			parteDupla.setPlanta(planta);

			String strEspacio = "";
			if (ListaDuplicados.get(0).getEspacio() != null) {
				strEspacio = ListaDuplicados.get(0).getEspacio().getCespacio();
				if (strEspacio != null) {
					strEspacio = strEspacio.replaceAll("\\(", "-");
					strEspacio = strEspacio.replaceAll("\\)", "-");
				}
			}
			Espacio espacio = new Espacio();
			espacio.setCespacio(strEspacio);
			parteDupla.setEspacio(espacio);

			String strClase = "";
			if (ListaDuplicados.get(0).getClase() != null) {
				strClase = ListaDuplicados.get(0).getClase().getCclase();
				if (strClase != null) {
					strClase = strClase.replaceAll("\\(", "-");
					strClase = strClase.replaceAll("\\)", "-");
				}
			}
			Clase clase = new Clase();
			clase.setCclase(strClase);
			parteDupla.setClase(clase);

			String strCodigo = "";
			if (ListaDuplicados.get(0).getCodigo() != null) {
				strCodigo = ListaDuplicados.get(0).getCodigo().getCcodigo();
				if (strCodigo != null) {
					strCodigo = strCodigo.replaceAll("\\(", "-");
					strCodigo = strCodigo.replaceAll("\\)", "-");
				}
			}
			Codigo codigo = new Codigo();
			codigo.setCcodigo(strCodigo);
			parteDupla.setCodigo(codigo);

			parteDupla.setObserv(ListaDuplicados.get(0).getObserv());

			return parteDupla;
		} else {
			return agregarParte(partes);
		}

	}

	/**
	 * Method 'add'.
	 * 
	 * @param partes
	 *            Partes
	 * @param request
	 *            HttpServletRequest
	 * @return Partes
	 */
	@RequestMapping(value = "/altaManual", method = RequestMethod.POST)
	public @ResponseBody
	Partes altaManual(@ModelAttribute Partes partes, HttpServletRequest request) {

		Date fechaHoy = new Date();
		partes.setFechare(fechaHoy);

		byte[] arrayPlano = decodeToImage(partes.getPlanoMarcaString());

		request.getSession(true).setAttribute("dptoXLNET", "NO");

		partes.setPlanoMarca(arrayPlano);
		// ********************************************************************
		// COMPROBAR LA POSIBILIDAD DE QUE PUEDA SER UNA AVERÃA DUPLICADA
		// Si coincide: Edificio, zona, planta, clase y codigo de activo en otra
		// averÃ­a no ejecutada y no relacionada con
		// coincidente inicial
		// ********************************************************************
		Partes parteDuplicado = new Partes();
		parteDuplicado.setIdedificio(partes.getIdedificio());
		parteDuplicado.setIdzona(partes.getIdzona());
		parteDuplicado.setIdplanta(partes.getIdplanta());
		parteDuplicado.setIdclase(partes.getIdclase());
		parteDuplicado.setIdcodigo(partes.getIdcodigo());
		parteDuplicado.setEjecutado("0");
		parteDuplicado.setAveriaRepe(null);

		List<Partes> ListaDuplicados = this.partesService
				.obtenerParte(parteDuplicado);
		if (ListaDuplicados.size() > 0) {
			// Ha encontrado un duplicado
			// Comprobar si vienen parentesis porque en
			// ese caso se queda bloqueada la pantalla. Como esta información es
			// para pintar la información del parte encontrado, se sustituyen
			// por guiones
			String observac = "";
			if (ListaDuplicados != null && ListaDuplicados.size() > 0
					&& ListaDuplicados.get(0) != null
					&& ListaDuplicados.get(0).getObserv() != null
					&& !ListaDuplicados.get(0).getObserv().equals("")) {
				observac = ListaDuplicados.get(0).getObserv();
				observac = observac.replaceAll("\\(", "-");
				observac = observac.replaceAll("\\)", "-");
				ListaDuplicados.get(0).setObserv(observac);
			}
			ListaDuplicados.get(0).setErrorParte("Parte duplicado");
			ListaDuplicados.get(0).setPlanoMarca(null);

			Partes parteDupla = new Partes();
			parteDupla.setIdparte(ListaDuplicados.get(0).getIdparte());
			parteDupla.setFechare(ListaDuplicados.get(0).getFechare());
			parteDupla.setErrorParte("Parte duplicado");

			String strNombre = ListaDuplicados.get(0).getNombre();
			if (strNombre != null) {
				strNombre = strNombre.replaceAll("\\(", "-");
				strNombre = strNombre.replaceAll("\\)", "-");
			}
			parteDupla.setNombre(strNombre);

			String strEdificio = "";
			if (ListaDuplicados.get(0).getEdificio() != null) {
				strEdificio = ListaDuplicados.get(0).getEdificio()
						.getCedificio();
				if (strEdificio != null) {
					strEdificio = strEdificio.replaceAll("\\(", "-");
					strEdificio = strEdificio.replaceAll("\\)", "-");
				}
			}
			Edificios edificio = new Edificios();
			edificio.setCedificio(strEdificio);
			parteDupla.setEdificio(edificio);

			String strZona = "";
			if (ListaDuplicados.get(0).getZona() != null) {
				strZona = ListaDuplicados.get(0).getZona().getCzona();
				if (strZona != null) {
					strZona = strZona.replaceAll("\\(", "-");
					strZona = strZona.replaceAll("\\)", "-");
				}
			}
			Zonas zona = new Zonas();
			zona.setCzona(strZona);
			parteDupla.setZona(zona);

			String strPlanta = "";
			if (ListaDuplicados.get(0).getPlanta() != null) {
				strPlanta = ListaDuplicados.get(0).getPlanta().getCplanta();
				if (strPlanta != null) {
					strPlanta = strPlanta.replaceAll("\\(", "-");
					strPlanta = strPlanta.replaceAll("\\)", "-");
				}
			}
			Plantas planta = new Plantas();
			planta.setCplanta(strPlanta);
			parteDupla.setPlanta(planta);

			String strEspacio = "";
			if (ListaDuplicados.get(0).getEspacio() != null) {
				strEspacio = ListaDuplicados.get(0).getEspacio().getCespacio();
				if (strEspacio != null) {
					strEspacio = strEspacio.replaceAll("\\(", "-");
					strEspacio = strEspacio.replaceAll("\\)", "-");
				}
			}
			Espacio espacio = new Espacio();
			espacio.setCespacio(strEspacio);
			parteDupla.setEspacio(espacio);

			String strClase = "";
			if (ListaDuplicados.get(0).getClase() != null) {
				strClase = ListaDuplicados.get(0).getClase().getCclase();
				if (strClase != null) {
					strClase = strClase.replaceAll("\\(", "-");
					strClase = strClase.replaceAll("\\)", "-");
				}
			}
			Clase clase = new Clase();
			clase.setCclase(strClase);
			parteDupla.setClase(clase);

			String strCodigo = "";
			if (ListaDuplicados.get(0).getCodigo() != null) {
				strCodigo = ListaDuplicados.get(0).getCodigo().getCcodigo();
				if (strCodigo != null) {
					strCodigo = strCodigo.replaceAll("\\(", "-");
					strCodigo = strCodigo.replaceAll("\\)", "-");
				}
			}
			Codigo codigo = new Codigo();
			codigo.setCcodigo(strCodigo);
			parteDupla.setCodigo(codigo);

			parteDupla.setObserv(ListaDuplicados.get(0).getObserv());

			return parteDupla;
		} else {
			return agregarParteManual(partes);
		}

	}

	/**
	 * Method 'modificar'.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	@RequestMapping(value = "/modificar", method = RequestMethod.POST)
	public @ResponseBody
	Partes modificar(@ModelAttribute Partes partes) {

		/*
		 * //
		 * ********************************************************************
		 * // COMPROBAR LA POSIBILIDAD DE QUE PUEDA SER UNA AVERÃA DUPLICADA //
		 * Si coincide: Edificio, zona, planta, clase y codigo de activo en otra
		 * // averÃ­a no ejecutada y no relacionada con // coincidente inicial
		 * //
		 * ********************************************************************
		 * Partes parteDuplicado = new Partes();
		 * parteDuplicado.setIdedificio(partes.getIdedificio());
		 * parteDuplicado.setIdzona(partes.getIdzona());
		 * parteDuplicado.setIdplanta(partes.getIdplanta());
		 * parteDuplicado.setIdclase(partes.getIdclase());
		 * parteDuplicado.setIdcodigo(partes.getIdcodigo());
		 * parteDuplicado.setEjecutado("0"); parteDuplicado.setAveriaRepe(null);
		 * 
		 * List<Partes> ListaDuplicados = this.partesService
		 * .obtenerParte(parteDuplicado); if (ListaDuplicados.size() > 0) { //
		 * Ha encontrado un duplicado
		 * ListaDuplicados.get(0).setErrorParte("Parte duplicado"); return
		 * ListaDuplicados.get(0); } else { return modificarParte(partes); }
		 */
		return modificarParte(partes);
	}

	/**
	 * Method 'modificarParte'.
	 * 
	 * @param partes
	 *            Partes
	 * @param planoMarca
	 *            MultipartFile
	 * @return Partes
	 */
	@RequestMapping(value = "/modificarParte", method = RequestMethod.POST)
	public @ResponseBody
	Partes modificarParte(@ModelAttribute Partes partes) {

		Partes partesAux = this.partesService.modificarParte(partes);

		PartesController.logger
				.info("[POST] : Partes modificado correctamente");

		/**
		 * MovilGmao
		 */
		/*
		 * Partetecnicosgmao parteTecnicosgmaoAux = new Partetecnicosgmao();
		 * parteTecnicosgmaoAux.setIdparte(partes.getIdparte());
		 * List<Partetecnicosgmao> listaParteTecnicosgmao =
		 * this.partetecnicosgmaoServices .findAll(parteTecnicosgmaoAux, null);
		 * 
		 * String urlConfig = ""; try { urlConfig =
		 * this.appConfiguration.getObject().getProperty( "movilgmao.path"); }
		 * catch (Exception e) {
		 * 
		 * }
		 * 
		 * Edificios edificioAux = new Edificios(); if (partes.getIdedificio()
		 * != null) { edificioAux = this.edificiosService.obtenerEdificio(partes
		 * .getIdedificio()); }
		 * 
		 * this.procesosJMSService.sincronizarParteCorrectivoGmao(partes,
		 * listaParteTecnicosgmao, edificioAux.getGuidedificio(), null,
		 * urlConfig);
		 */

		return partesAux;

	}

	/**
	 * Method 'agregarParte'.
	 * 
	 * @param partes
	 *            Partes
	 * @param planoMarca
	 *            MultipartFile
	 * @return Partes
	 */
	@RequestMapping(value = "/agregarParte", method = RequestMethod.POST)
	public @ResponseBody
	Partes agregarParte(@ModelAttribute Partes partes) {

		// Si planta y/o zona son nulas poner a cero
		if (partes.getIdzona() == null) {
			partes.setIdzona(Aa20bConstantes.SIN_ZONAS);
		}
		if (partes.getIdplanta() == null) {
			partes.setIdplanta(Aa20bConstantes.SIN_PLANTAS);
		}

		byte[] arrayPlano = decodeToImage(partes.getPlanoMarcaString());

		partes.setPlanoMarca(arrayPlano);

		Date hoy = new Date();
		partes.setFechare(hoy);

		// Comprobar si el codigo de Edificio existe en la tabla de Edificios.
		// Si no existe, no se permite dar de alta el parte.
		if (!this.edificiosService.comprobarExisteEdificio(partes
				.getIdedificio())) {
			// No existe el edificio. No se continua
			partes.setErrorParte("NOEXISTEEDIFICIO");
			return partes;
		}
		// Comprobar si el codigo de Departamento existe en la tabla de
		// Departamentos. Si no existe, darlo de alta.
		Departamentos depto = new Departamentos();
		depto.setCidepar(partes.getDepartamento().getIddepar().toString());
		depto.setCdepar(partes.getDepartamento().getCdepar());
		depto.setEdepar(partes.getDepartamento().getEdepar());

		if (this.departamentosService.altaExisteDepartamento(depto) == null) {
			// No se ha podido comprobar y/o dar de alta el departamento. No se
			// continua
			return null;
		}
		Long idDepartamento = this.departamentosService
				.altaExisteDepartamento(depto);

		// obtener el iddepar del departamento
		Departamentos deptoBusq = new Departamentos();
		deptoBusq.setCidepar(depto.getCidepar());
		List<Departamentos> deptoList = this.departamentosService.findAll(
				deptoBusq, null);

		partes.setIddepar(deptoList.get(0).getIddepar());

		// Comprobar si el codigo de Direccion existe en la tabla de
		// Direcciones. Si no existe, darlo de alta.
		Direcciones direccion = new Direcciones();

		direccion.setCidir(partes.getIddir().toString());
		direccion.setCodestrUs(partes.getDireccion().getCodestrUs());
		direccion.setCdir(partes.getDireccion().getCdir());
		direccion.setEdir(partes.getDireccion().getEdir());
		direccion.setIddepar(idDepartamento);

		if (!this.direccionesService.altaExisteDireccion(direccion)) {
			// No se ha podido comprobar y/o dar de alta la direccion. No se
			// continua
			return null;
		}

		// obtener el iddir de la direccion
		Direcciones dirBusq = new Direcciones();
		dirBusq.setCidir(direccion.getCidir());
		List<Direcciones> dirList = this.direccionesService.findAll(dirBusq,
				null);

		partes.setIddir(dirList.get(0).getIddir());

		/**
		 * MovilGmao Cuando se crea el parte debemos meter un guid para después
		 * efectuar el envío a MovilGmao
		 */
		String randomUUIDString = "";
		UUID uuid = UUID.randomUUID();
		randomUUIDString = uuid.toString();
		partes.setGuidparte(randomUUIDString);

		/***/

		/**
		 * Fecha planif agenda
		 */
		if (partes.getFechare() != null) {
			partes.setFechaplanif(partes.getFechare());
		}

		Partes partesAux = this.partesService.add(partes);

		Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
		Partetecnicosgmao elTecnicoParteGmao = new Partetecnicosgmao();
		boolean tieneTecnico = false;
		boolean esTecGmao = false;

		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}
		/*
		 * *******************************************************************
		 * Si ha ido todo bien, comprobar que el código de parte en la tabla
		 * CODIGOS el campo RECIBE_INCI Si campo CONTRATA está a 1: Obtener
		 * tecnicos contrata Si contrata =0 : obtener tecnicos presentes
		 * *******************************************************************
		 */
		Codigo codigo = new Codigo();
		codigo.setIdcodigo(partes.getIdcodigo());
		codigo = this.codigosService.find(codigo);

		if (codigo != null && codigo.getRecibeinci() != null
				&& codigo.getRecibeinci().equals("1")) {
			if (codigo != null && codigo.getContrata() != null
					&& codigo.getContrata().equals("1")) {
				// Obtener los tecnicos de contratas cuya clase y edificio
				// coincidan con los del parte
				List<Tecnicos> tecnicosContrataList = this.tecnicosService
						.obtenerTecnicosClaseContrataEdificio(
								codigo.getIdclase(), codigo.getIdservicio(),
								codigo.getIdcodigo(), partes.getIdedificio(),
								partes.getIdzona());
				if (tecnicosContrataList.size() > 0) {
					// Hay tecnicos asociados al edificio y clase
					// se asigna automáticamente el parte.
					for (Tecnicos tecnicoAux : tecnicosContrataList) {
						tieneTecnico = true;
						// Insertar en la tabla de ParteTecnicos
						Partetecnicos parteTecnico = new Partetecnicos();
						parteTecnico.setIdparte(partesAux.getIdparte());
						parteTecnico.setIdtecnico(tecnicoAux.getIdtecnico());
						parteTecnico.setFinalizado("0");

						Partetecnicos parteTecnicoAux = this.partetecnicosService
								.add(parteTecnico);

						// Si no tiene email se deja como ASIGNACION MANUAL

						if (tecnicoAux.getMovilgmao() != null
								&& tecnicoAux.getMovilgmao().equals("1")) {
							this.partesService.marcarAutomatica(partesAux);
							/**
							 * MOVILGMAO Se comprueba si el tecnico tiene
							 * aplicacion movilgmao. Si la tiene se crea la OT
							 * correspondiente
							 * 
							 */

							esTecGmao = true;
							if (partesAux != null) {

								elTecnicoParteGmao.setIdparte(partesAux
										.getIdparte());
								elTecnicoParteGmao.setIdtecnico(tecnicoAux
										.getIdtecnico());
								elTecnicoParteGmao.setIdpartec(parteTecnicoAux
										.getIdpartec());
								randomUUIDString = "";
								uuid = UUID.randomUUID();
								randomUUIDString = uuid.toString();
								elTecnicoParteGmao
										.setGuidpartetecgmao(randomUUIDString);
								tecnicoParteGmaoAux = this.partetecnicosgmaoServices
										.add(elTecnicoParteGmao);
							}

							/**
							 * FIN MOVILGMAO
							 */
						} else if (tecnicoAux.getMail() != null) {
							// Actualizar la tabla Partes AUTOMATICA=1
							this.partesService.marcarAutomatica(partesAux);

							// Actualizar la tabla Partes ENVIOMAIL=1
							this.partesService.marcarEnvioMail(partesAux);

							// Enviar email
							try {
								String retorno = enviarMailTecnico(partes,
										tecnicoAux);
								if ("true".equals(retorno)) {
									// Si ha ido bien el envío de mail se
									// marca
									// enviomail =1 en la tabla
									// TecnicoPartes
									this.partetecnicosService.marcarEnvioMail(
											partesAux.getIdparte(),
											tecnicoAux.getIdtecnico());
								}
								PartesController.logger
										.info("[POST] : email enviado"
												+ retorno);
								// return partesAux;
							} catch (Exception e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}
						}

						PartesController.logger
								.info("[POST] : Tecnicos encontrados: "
										+ parteTecnicoAux.getIdpartec());
					}
				} else {
					// No hay tecnicos asociados al edificio y clase
					// Se deja como un parte con asignación manual.
				}

			} else {

				/*
				 * Eliminar // Obtener los tecnicos que esten presentes en este
				 * momento // Obtener tecnicos relacionados con el edificios
				 * TecnicoEdif tecnicoEdif = new TecnicoEdif();
				 * tecnicoEdif.setIdedificio(partesAux.getIdedificio());
				 * tecnicoEdif.setBaja("0");
				 * 
				 * ArrayList<Long> arrayTecnicos = new ArrayList<Long>();
				 * List<TecnicoEdif> tecnicosList = this.tecnicoEdifService
				 * .findAll(tecnicoEdif, null);
				 */

				// El código de parte nos indica que no es de contrata y a que
				// servicio corresponde. Con el servicio y edificio se obtiene
				// los técnicos asociados que no son contratas.

				List<Usutecnicos> tecnicosList = this.usuTecnicosService
						.obtenerTecnicosUsuServEdificio(codigo.getIdcodigo(),
								partes.getIdedificio(), partes.getIdzona(),
								false);
				ArrayList<Long> arrayTecnicos = new ArrayList<Long>();
				Presencia presencia = new Presencia();
				for (Usutecnicos usuTecnicosAux : tecnicosList) {
					// Comprobar que esten presentes
					// Buscar en la tabla Presencia los tecnicos que tengan con
					// THASTA a 0

					presencia.setIdtecnico(usuTecnicosAux.getIdtecnico());
					if (this.presenciaService
							.comprobarTecnicoEstaPresente(presencia)) {
						// El tecnico esta presente
						// Recoger todos los tecnicos y luego seleccionar uno
						// aleatoriamente
						arrayTecnicos.add(usuTecnicosAux.getIdtecnico());
					}
				}

				if (arrayTecnicos.size() > 0) {
					tieneTecnico = true;
					// Se trabaja con el tecnico que ha sido elegido
					// aleatoriamente.
					int numAleat = (int) Math
							.floor(Math.random() * (0 - arrayTecnicos.size())
									+ arrayTecnicos.size());
					Long idTecnicoAleat = arrayTecnicos.get(numAleat);

					Tecnicos tecnicos = new Tecnicos();
					tecnicos.setIdtecnico(idTecnicoAleat);
					Tecnicos tecnicoAux = this.tecnicosService.find(tecnicos);

					// Insertar en la tabla de ParteTecnicos
					Partetecnicos parteTecnico = new Partetecnicos();
					parteTecnico.setIdparte(partesAux.getIdparte());
					parteTecnico.setIdtecnico(tecnicoAux.getIdtecnico());
					parteTecnico.setFinalizado("0");
					if (partes != null && partes.getUrgente() != null
							&& partes.getUrgente().equals("1")) {
						parteTecnico.setAceptada(null);
					} else {
						parteTecnico.setAceptada("1");
					}
					Partetecnicos parteTecnicoAux = this.partetecnicosService
							.add(parteTecnico);

					/**
					 * MOVILGMAO Se comprueba si el tecnico tiene aplicacion
					 * movilgmao. Si la tiene se crea la OT correspondiente
					 * 
					 */
					if (tecnicoAux != null && tecnicoAux.getMovilgmao() != null
							&& tecnicoAux.getMovilgmao().equals("1")) {
						this.partesService.marcarAutomatica(partesAux);
						esTecGmao = true;
						if (partesAux != null) {

							elTecnicoParteGmao.setIdparte(partesAux
									.getIdparte());
							elTecnicoParteGmao.setIdtecnico(tecnicoAux
									.getIdtecnico());
							elTecnicoParteGmao.setIdpartec(parteTecnicoAux
									.getIdpartec());
							randomUUIDString = "";
							uuid = UUID.randomUUID();
							randomUUIDString = uuid.toString();
							elTecnicoParteGmao
									.setGuidpartetecgmao(randomUUIDString);
							tecnicoParteGmaoAux = this.partetecnicosgmaoServices
									.add(elTecnicoParteGmao);
						}

						/**
						 * FIN MOVILGMAO
						 */
					} else if (tecnicoAux.getMail() != null) {
						// Si no tiene email se deja como ASIGNACION MANUAL
						// Actualizar la tabla Partes AUTOMATICA=1
						this.partesService.marcarAutomatica(partesAux);

						// Actualizar la tabla Partes ENVIOMAIL=1
						this.partesService.marcarEnvioMail(partesAux);

						// Enviar email
						try {
							String retorno = enviarMailTecnico(partes,
									tecnicoAux);
							if ("true".equals(retorno)) {
								// Si ha ido bien el envío de mail se marca
								// enviomail =1 en la tabla TecnicoPartes
								this.partetecnicosService.marcarEnvioMail(
										partesAux.getIdparte(),
										tecnicoAux.getIdtecnico());
							}
							PartesController.logger
									.info("[POST] : email enviado" + retorno);
							// return partesAux;
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}

					PartesController.logger
							.info("[POST] : Tecnicos encontrados: "
									+ parteTecnicoAux.getIdpartec());
				}
			}
		}
		boolean enviarParteGmao = false;
		if (partesAux != null) {

			/**
			 * Enviar mail de confirmación al usuario que ha creado el parte
			 */
			try {
				if (partesAux.getMail() != null
						&& !partesAux.getMail().trim().equals("")) {
					String retorno = enviarMailUsuario(partesAux);
					PartesController.logger
							.info("[POST] : email confirmación enviado"
									+ retorno);
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			if (!tieneTecnico) {
				/**
				 * No tiene técnico, crea el registro en la tabla de partes gmao
				 * sin incluir ni el técnico ni el código del parte técnico
				 */

				elTecnicoParteGmao.setIdparte(partesAux.getIdparte());
				elTecnicoParteGmao.setIdtecnico(null);
				elTecnicoParteGmao.setIdpartec(null);
				randomUUIDString = "";
				uuid = UUID.randomUUID();
				randomUUIDString = uuid.toString();
				elTecnicoParteGmao.setGuidpartetecgmao(randomUUIDString);

				tecnicoParteGmaoAux = this.partetecnicosgmaoServices
						.add(elTecnicoParteGmao);
				enviarParteGmao = true;
			} else {
				if (esTecGmao) {
					enviarParteGmao = true;
				}
			}

			if (enviarParteGmao) {
				String idEdificio = partesAux.getIdedificio();

				Edificios edifAux = new Edificios();
				edifAux = this.edificiosService.obtenerEdificio(idEdificio);

				if (partesAux.getIddepar() != null) {
					Departamentos departamentoAux = new Departamentos();
					departamentoAux.setIddepar(partesAux.getIddepar());
					departamentoAux = this.departamentosService
							.find(departamentoAux);
					partesAux.setDepartamento(departamentoAux);
				}

				if (partesAux.getIddir() != null) {
					Direcciones direccionAux = new Direcciones();
					direccionAux.setIddir(partesAux.getIddir());
					direccionAux = this.direccionesService.find(direccionAux);
					partesAux.setDireccion(direccionAux);
				}

				if (partesAux.getIdplanta() != null) {
					Plantas plantaAux = new Plantas();
					plantaAux.setIdplanta(partesAux.getIdplanta());
					plantaAux = this.plantasService.find(plantaAux);
					partesAux.setPlanta(plantaAux);
				}

				if (partesAux.getIdzona() != null) {
					Zonas zonaAux = new Zonas();
					zonaAux.setIdzona(partesAux.getIdzona());
					zonaAux = this.zonasService.find(zonaAux);
					partesAux.setZona(zonaAux);
				}

				if (partesAux.getIdespacio() != null) {
					Espacio espacioAux = new Espacio();
					espacioAux.setIdespacio(partesAux.getIdespacio());
					espacioAux = this.espaciosService.find(espacioAux);
					partesAux.setEspacio(espacioAux);
				}

				// Obtener el plano si tiene
				Parteplano planoParte = new Parteplano();
				planoParte.setIdparte(partesAux.getIdparte());

				planoParte = this.parteplanoService.find(planoParte);

				Partepdf pdfParte = new Partepdf();
				pdfParte.setIdparte(partesAux.getIdparte());
				pdfParte = this.partepdfService.find(pdfParte);

				if (partesAux.getGuidparte() == null) {
					randomUUIDString = "";
					uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					partesAux.setGuidparte(randomUUIDString);
					partesAux = this.partesService
							.actualizarUUIDparte(partesAux);
				}

				if (planoParte != null) {

					randomUUIDString = "";
					uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					if (tieneTecnico) {
						elTecnicoParteGmao.setIdparte(partesAux.getIdparte());
						elTecnicoParteGmao.setIdtecnico(tecnicoParteGmaoAux
								.getIdtecnico());
						elTecnicoParteGmao.setIdpartec(tecnicoParteGmaoAux
								.getIdpartec());
					} else {
						elTecnicoParteGmao.setIdparte(partesAux.getIdparte());
						elTecnicoParteGmao.setIdtecnico(null);
						elTecnicoParteGmao.setIdpartec(null);
					}

					elTecnicoParteGmao.setGuidplanopartegmao(randomUUIDString);
					tecnicoParteGmaoAux = this.partetecnicosgmaoServices
							.update(elTecnicoParteGmao);
				}

				if (pdfParte != null) {

					randomUUIDString = "";
					uuid = UUID.randomUUID();
					randomUUIDString = uuid.toString();
					if (tieneTecnico) {
						elTecnicoParteGmao.setIdparte(partesAux.getIdparte());
						elTecnicoParteGmao.setIdtecnico(tecnicoParteGmaoAux
								.getIdtecnico());
						elTecnicoParteGmao.setIdpartec(tecnicoParteGmaoAux
								.getIdpartec());
					} else {
						elTecnicoParteGmao.setIdparte(partesAux.getIdparte());
						elTecnicoParteGmao.setIdtecnico(null);
						elTecnicoParteGmao.setIdpartec(null);
					}

					elTecnicoParteGmao.setGuidpdfpartegmao(randomUUIDString);
					tecnicoParteGmaoAux = this.partetecnicosgmaoServices
							.update(elTecnicoParteGmao);
				}

				// Obtener tecnicos asignados al parte
				// (partetecnicos)
				tecnicoParteGmaoAux = new Partetecnicosgmao();
				tecnicoParteGmaoAux.setIdparte(partesAux.getIdparte());
				List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
						.findAll(tecnicoParteGmaoAux, null);

				byte[] blobAsBytes = null;
				byte[] blobAsBytesPDF = null;

				try {
					if (planoParte != null) {
						// Tiene plano
						int blobLeng = (int) planoParte.getDibujo().length();
						blobAsBytes = planoParte.getDibujo().getBytes(1,
								blobLeng);
					}

					if (pdfParte != null) {
						// Tiene plano
						int blobLeng = (int) pdfParte.getPdf().length();
						blobAsBytesPDF = pdfParte.getPdf()
								.getBytes(1, blobLeng);
					}

					String respuesta = this.procesosJMSService
							.sincronizarParteCorrectivoGmao(partesAux,
									parteTecnicosGmao,
									edifAux.getGuidedificio(), blobAsBytes,
									blobAsBytesPDF, urlConfig);

					if (respuesta != null && respuesta.equals("OK")) {
						PartesController.logger
								.info("[MOVILGMAO] : sincronizarParteCorrectivo: "
										+ respuesta);

					} else {
						PartesController.logger
								.error("[MOVILGMAO] : sincronizarParteCorrectivo: "
										+ respuesta);
					}
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		}

		PartesController.logger.info("[POST] : Partes insertado correctamente");
		Partes parteCorrecto = new Partes();
		parteCorrecto.setIdparte(partesAux.getIdparte());
		return parteCorrecto;

	}

	/**
	 * Method 'agregarParte'.
	 * 
	 * @param partes
	 *            Partes
	 * @param planoMarca
	 *            MultipartFile
	 * @return Partes
	 */
	@RequestMapping(value = "/agregarParteManual", method = RequestMethod.POST)
	public @ResponseBody
	Partes agregarParteManual(@ModelAttribute Partes partes) {

		Date fechaHoy = new Date();
		partes.setFechare(fechaHoy);

		// Si planta y/o zona son nulas poner a cero
		if (partes.getIdzona() == null) {
			partes.setIdzona(Aa20bConstantes.SIN_ZONAS);
		}
		if (partes.getIdplanta() == null) {
			partes.setIdplanta(Aa20bConstantes.SIN_PLANTAS);
		}

		if (!partes.getPlanoMarcaString().equals("")) {
			byte[] arrayPlano = decodeToImage(partes.getPlanoMarcaString());
			partes.setPlanoMarca(arrayPlano);
		}

		/**
		 * MovilGmao Cuando se crea el parte debemos meter un guid para después
		 * efectuar el envío a MovilGmao
		 */
		String randomUUIDString = "";
		UUID uuid = UUID.randomUUID();
		randomUUIDString = uuid.toString();
		partes.setGuidparte(randomUUIDString);

		/**
		 * Fecha planif agenda
		 */
		if (partes.getFechare() != null) {
			partes.setFechaplanif(partes.getFechare());
		}

		Partes partesAux = this.partesService.add(partes);
		Partes parteGenerado = new Partes();
		parteGenerado.setIdparte(partesAux.getIdparte());

		if (partesAux != null && partesAux.getMail() != null
				&& !partesAux.getMail().trim().equals("")) {
			/**
			 * Enviar mail de confirmación al usuario que ha creado el parte
			 */
			try {
				if (partesAux.getMail() != null
						&& !partesAux.getMail().trim().equals("")) {
					String retorno = enviarMailUsuario(partesAux);
					PartesController.logger
							.info("[POST] : email confirmación enviado"
									+ retorno);
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		/**
		 * Hay que mandar el parte igualmente a movilgmao para ser gestionado
		 * desde el planner. Creamos un registro en la tabla que guarda el
		 * idficha y guidgmao sin técnico
		 */
		Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
		tecnicoParteGmaoAux.setIdparte(partesAux.getIdparte());
		randomUUIDString = "";
		uuid = UUID.randomUUID();
		randomUUIDString = uuid.toString();
		tecnicoParteGmaoAux.setGuidpartetecgmao(randomUUIDString);

		tecnicoParteGmaoAux = this.partetecnicosgmaoServices
				.add(tecnicoParteGmaoAux);

		/**
		 * Mandar a MovilGmao
		 */
		String urlConfig = "";
		String respuesta = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		if (partesAux != null) {
			String idEdificio = partesAux.getIdedificio();

			Edificios edifAux = new Edificios();
			edifAux = this.edificiosService.obtenerEdificio(idEdificio);

			if (partesAux.getIddepar() != null) {
				Departamentos departamentoAux = new Departamentos();
				departamentoAux.setIddepar(partesAux.getIddepar());
				departamentoAux = this.departamentosService
						.find(departamentoAux);
				partesAux.setDepartamento(departamentoAux);
			}

			if (partesAux.getIddir() != null) {
				Direcciones direccionAux = new Direcciones();
				direccionAux.setIddir(partesAux.getIddir());
				direccionAux = this.direccionesService.find(direccionAux);
				partesAux.setDireccion(direccionAux);
			}

			if (partesAux.getIdplanta() != null) {
				Plantas plantaAux = new Plantas();
				plantaAux.setIdplanta(partesAux.getIdplanta());
				plantaAux = this.plantasService.find(plantaAux);
				partesAux.setPlanta(plantaAux);
			}

			if (partesAux.getIdzona() != null) {
				Zonas zonaAux = new Zonas();
				zonaAux.setIdzona(partesAux.getIdzona());
				zonaAux = this.zonasService.find(zonaAux);
				partesAux.setZona(zonaAux);

			}

			if (partesAux.getIdespacio() != null) {
				Espacio espacioAux = new Espacio();
				espacioAux.setIdespacio(partesAux.getIdespacio());
				espacioAux = this.espaciosService.find(espacioAux);
				partesAux.setEspacio(espacioAux);
			}

			// Obtener el plano si tiene
			Parteplano planoParte = new Parteplano();
			planoParte.setIdparte(partesAux.getIdparte());

			planoParte = this.parteplanoService.find(planoParte);

			Partepdf pdfParte = new Partepdf();
			pdfParte.setIdparte(partesAux.getIdparte());

			pdfParte = this.partepdfService.find(pdfParte);

			if (planoParte != null) {

				randomUUIDString = "";
				uuid = UUID.randomUUID();
				randomUUIDString = uuid.toString();
				tecnicoParteGmaoAux.setGuidplanopartegmao(randomUUIDString);
				tecnicoParteGmaoAux = this.partetecnicosgmaoServices
						.update(tecnicoParteGmaoAux);
			}

			if (pdfParte != null) {

				randomUUIDString = "";
				uuid = UUID.randomUUID();
				randomUUIDString = uuid.toString();
				tecnicoParteGmaoAux.setGuidpdfpartegmao(randomUUIDString);
				tecnicoParteGmaoAux = this.partetecnicosgmaoServices
						.update(tecnicoParteGmaoAux);
			}

			// Obtener tecnicos asignados al parte (partetecnicos)
			List<Partetecnicosgmao> parteTecnicosGmao = this.partetecnicosgmaoServices
					.findAll(tecnicoParteGmaoAux, null);

			byte[] blobAsBytes = null;
			byte[] blobAsBytesPDF = null;
			try {
				if (planoParte != null) {
					// Tiene plano
					int blobLeng = (int) planoParte.getDibujo().length();
					blobAsBytes = planoParte.getDibujo().getBytes(1, blobLeng);
				}

				if (pdfParte != null) {
					// Tiene plano
					int blobLeng = (int) pdfParte.getPdf().length();
					blobAsBytesPDF = pdfParte.getPdf().getBytes(1, blobLeng);
				}

				respuesta = this.procesosJMSService
						.sincronizarParteCorrectivoGmao(partesAux,
								parteTecnicosGmao, edifAux.getGuidedificio(),
								blobAsBytes, blobAsBytesPDF, urlConfig);

				if (respuesta != null && respuesta.equals("OK")) {
					PartesController.logger
							.info("[MOVILGMAO] : agregarParteManual: "
									+ respuesta);
				} else {
					PartesController.logger
							.error("[MOVILGMAO] : agregarParteManual: "
									+ respuesta);
				}
			} catch (Exception e) {
				e.printStackTrace();
			}

		}

		/***/

		PartesController.logger.info("[POST] : Partes insertado correctamente");

		return parteGenerado;

	}

	/**
	 * Method 'agregarParteDuplicado'.
	 * 
	 * @param partes
	 *            Partes
	 * @return Partes
	 */
	@RequestMapping(value = "/agregarParteDuplicado", method = RequestMethod.POST)
	public @ResponseBody
	Partes agregarParteDuplicado(@ModelAttribute Partes partes,
			HttpServletRequest request) {

		// Si planta y/o zona son nulas poner a cero
		if (partes.getIdzona() == null) {
			partes.setIdzona(Aa20bConstantes.SIN_ZONAS);
		}
		if (partes.getIdplanta() == null) {
			partes.setIdplanta(Aa20bConstantes.SIN_PLANTAS);
		}

		// No cromprobamos si existe el edificio, departamento y direccion (como
		// se hace en agregarParte) en las tabla de Edificios ya que se supone
		// que al asociarse el parte a otro existente ya se ha hecho esas
		// comprobaciones.

		byte[] arrayPlano = decodeToImage(partes.getPlanoMarcaString());

		partes.setPlanoMarca(arrayPlano);

		Date hoy = new Date();
		partes.setFechare(hoy);

		// obtener el iddepar del departamento.
		// Si se ha introducido usuario de XLNET viene el dato de
		// ciddepar
		if (request != null
				&& request.getSession().getAttribute("dptoXLNET") != null
				&& !request.getSession().getAttribute("dptoXLNET").equals("SI")) {

		} else {
			Departamentos deptoBusq = new Departamentos();
			deptoBusq.setCidepar(partes.getIddepar().toString());
			List<Departamentos> deptoList = this.departamentosService.findAll(
					deptoBusq, null);
			partes.setIddepar(deptoList.get(0).getIddepar());

			// obtener el iddir de la direccion
			Direcciones dirBusq = new Direcciones();
			dirBusq.setCidir(partes.getIddir().toString());
			List<Direcciones> dirList = this.direccionesService.findAll(
					dirBusq, null);
			partes.setIddir(dirList.get(0).getIddir());
		}

		/**
		 * MovilGmao Cuando se crea el parte debemos meter un guid para después
		 * efectuar el envío a MovilGmao
		 */
		String randomUUIDString = "";
		UUID uuid = UUID.randomUUID();
		randomUUIDString = uuid.toString();
		partes.setGuidparte(randomUUIDString);

		/***/

		/**
		 * Fecha planif agenda
		 */
		if (partes.getFechare() != null) {
			partes.setFechaplanif(partes.getFechare());
		}

		Partes partesAux = this.partesService.add(partes);

		/*
		 * ANGEL 20150429 // /Â¿Â¿Â¿Â¿Â¿Â¿Â¿Â¿Â¿Â¿Â¿ ESTO HAY QUE HACERLO
		 * TAMBIEN EN DUPLICADOS // ???????????????
		 * 
		 * //
		 * ********************************************************************
		 * // Si ha ido todo bien, comprobar si la clasificaciÃ³n de activo //
		 * seleccionada estÃ¡ relacionada con un tÃ©cnico/s â€“ contrata/s // En
		 * caso afirmativo enviar un email a dicho tÃ©cnico //
		 * ********************************************************************
		 * 
		 * // Obtener tecnicos relacionados con el edificios TecnicoEdif
		 * tecnicoEdif = new TecnicoEdif();
		 * tecnicoEdif.setIdedificio(partesAux.getIdedificio());
		 * tecnicoEdif.setBaja("0");
		 * 
		 * List<TecnicoEdif> tecnicosList = this.tecnicoEdifService.findAll(
		 * tecnicoEdif, null); for (TecnicoEdif tecnicoEdifAux : tecnicosList) {
		 * // Comprobar si los tecnicos encontrados tienen RECIBE_IN=1 Y //
		 * IDCLASE = Clase seleccionada Tecnicos tecnicos = new Tecnicos();
		 * tecnicos.setIdtecnico(tecnicoEdifAux.getIdtecnico());
		 * 
		 * Tecnicos tecnicoAux = this.tecnicosService.find(tecnicos); if
		 * (tecnicoAux.getIdclase().equals(partesAux.getIdclase())) { // La
		 * clase del tecnico coincide con la clase seleccionada. if
		 * (tecnicoAux.getRecibeInci() != null) { if
		 * (tecnicoAux.getRecibeInci().equals("1")) { // El tecnico puede
		 * recibir incidencias. // Insertar en la tabla de ParteTecnicos
		 * Partetecnicos parteTecnico = new Partetecnicos();
		 * parteTecnico.setIdparte(partesAux.getIdparte());
		 * parteTecnico.setIdtecnico(tecnicoAux.getIdtecnico());
		 * parteTecnico.setFinalizado("0");
		 * 
		 * Partetecnicos parteTecnicoAux = this.partetecnicosService
		 * .add(parteTecnico);
		 * 
		 * // Actualizar la tabla Partes AUTOMATICA=1
		 * this.partesService.marcarAutomatica(partesAux);
		 * 
		 * // Enviar email try { String retorno = enviarMailTecnico(partes,
		 * tecnicoAux); PartesController.logger .info("[POST] : email enviado" +
		 * retorno); // return partesAux; } catch (Exception e) { // TODO
		 * Auto-generated catch block e.printStackTrace(); }
		 * 
		 * PartesController.logger .info("[POST] : Tecnicos encontrados: " +
		 * parteTecnicoAux.getIdpartec()); } } }
		 * 
		 * }
		 */

		/*
		 * Partetecnicosgmao tecnicoParteGmaoAux = new Partetecnicosgmao();
		 * Partetecnicosgmao elTecnicoParteGmao = new Partetecnicosgmao();
		 * boolean tieneTecnico = false; String urlConfig = ""; try { urlConfig
		 * = this.appConfiguration.getObject().getProperty( "movilgmao.path"); }
		 * catch (Exception e) {
		 * 
		 * }
		 */

		/*
		 * *******************************************************************
		 * Si ha ido todo bien, comprobar que el cÃ³digo de parte en la tabla
		 * CODIGOS el campo RECIBE_INCI Si campo CONTRATA estÃ¡ a 1: Obtener
		 * tecnicos contrata Si contrata =0 : obtener tecnicos presentes
		 * *******************************************************************
		 */
		Codigo codigo = new Codigo();
		codigo.setIdcodigo(partes.getIdcodigo());
		codigo = this.codigosService.find(codigo);
		if (codigo != null && codigo.getRecibeinci() != null
				&& codigo.getRecibeinci().equals("1")) {
			if (codigo != null && codigo.getContrata() != null
					&& codigo.getContrata().equals("1")) {
				// Obtener los tecnicos de contratas cuya clase y edificio
				// coincidan con los del parte
				List<Tecnicos> tecnicosContrataList = this.tecnicosService
						.obtenerTecnicosClaseContrataEdificio(
								codigo.getIdclase(), codigo.getIdservicio(),
								codigo.getIdcodigo(), partes.getIdedificio(),
								partes.getIdzona());
				if (tecnicosContrataList.size() > 0) {
					// Hay tecnicos asociados al edificio y clase
					// se asigna automáticamente el parte.
					for (Tecnicos tecnicoAux : tecnicosContrataList) {
						// Insertar en la tabla de ParteTecnicos
						Partetecnicos parteTecnico = new Partetecnicos();
						parteTecnico.setIdparte(partesAux.getIdparte());
						parteTecnico.setIdtecnico(tecnicoAux.getIdtecnico());
						parteTecnico.setFinalizado("0");
						Partetecnicos parteTecnicoAux = this.partetecnicosService
								.add(parteTecnico);

						// Si no tiene email se deja como ASIGNACION MANUAL
						if (tecnicoAux.getMovilgmao() != null
								&& tecnicoAux.getMovilgmao().equals("1")) {
							this.partesService.marcarAutomatica(partesAux);
						} else if (tecnicoAux.getMail() != null) {

							// Actualizar la tabla Partes AUTOMATICA=1
							this.partesService.marcarAutomatica(partesAux);

							// Actualizar la tabla Partes ENVIOMAIL=1
							this.partesService.marcarEnvioMail(partesAux);

							// Enviar email
							try {
								String retorno = enviarMailTecnico(partes,
										tecnicoAux);
								if ("true".equals(retorno)) {
									// Si ha ido bien el envío de mail se marca
									// enviomail =1 en la tabla TecnicoPartes
									this.partetecnicosService.marcarEnvioMail(
											partesAux.getIdparte(),
											tecnicoAux.getIdtecnico());
								}
								PartesController.logger
										.info("[POST] : email enviado"
												+ retorno);
								// return partesAux;
							} catch (Exception e) {
								// TODO Auto-generated catch block
								e.printStackTrace();
							}

						}
						PartesController.logger
								.info("[POST] : Tecnicos encontrados: "
										+ parteTecnicoAux.getIdpartec());
					}
				} else {
					// No hay tecnicos asociados al edificio y clase
					// Se deja como un parte con asignación manual.
				}

			} else {
				/*
				 * Eliminar // Obtener los tecnicos que esten presentes en este
				 * momento // Obtener tecnicos relacionados con el edificios
				 * TecnicoEdif tecnicoEdif = new TecnicoEdif();
				 * tecnicoEdif.setIdedificio(partesAux.getIdedificio());
				 * tecnicoEdif.setBaja("0");
				 * 
				 * ArrayList<Long> arrayTecnicos = new ArrayList<Long>();
				 * List<TecnicoEdif> tecnicosList = this.tecnicoEdifService
				 * .findAll(tecnicoEdif, null);
				 */

				// El código de parte nos indica que no es de contrata y a que
				// servicio corresponde. Con el servicio y edificio se obtiene
				// los técnicos asociados que no son contratas.

				List<Usutecnicos> tecnicosList = this.usuTecnicosService
						.obtenerTecnicosUsuServEdificio(codigo.getIdcodigo(),
								partes.getIdedificio(), partes.getIdzona(),
								false);
				ArrayList<Long> arrayTecnicos = new ArrayList<Long>();
				Presencia presencia = new Presencia();
				for (Usutecnicos usuTecnicosAux : tecnicosList) {
					// Comprobar que esten presentes
					// Buscar en la tabla Presencia los tecnicos que tengan con
					// THASTA a 0

					presencia.setIdtecnico(usuTecnicosAux.getIdtecnico());
					if (this.presenciaService
							.comprobarTecnicoEstaPresente(presencia)) {
						// El tecnico esta presente
						// Recoger todos los tecnicos y luego seleccionar uno
						// aleatoriamente
						arrayTecnicos.add(usuTecnicosAux.getIdtecnico());
					}
				}

				if (arrayTecnicos.size() > 0) {
					// tieneTecnico = true;
					// Se trabaja con el tecnico que ha sido elegido
					// aleatoriamente.
					int numAleat = (int) Math
							.floor(Math.random() * (0 - arrayTecnicos.size())
									+ arrayTecnicos.size());
					Long idTecnicoAleat = arrayTecnicos.get(numAleat);

					Tecnicos tecnicos = new Tecnicos();
					tecnicos.setIdtecnico(idTecnicoAleat);
					Tecnicos tecnicoAux = this.tecnicosService.find(tecnicos);

					// Insertar en la tabla de ParteTecnicos
					Partetecnicos parteTecnico = new Partetecnicos();
					parteTecnico.setIdparte(partesAux.getIdparte());
					parteTecnico.setIdtecnico(tecnicoAux.getIdtecnico());
					parteTecnico.setFinalizado("0");
					if (partes != null && partes.getUrgente() != null
							&& partes.getUrgente().equals("1")) {
						parteTecnico.setAceptada(null);
					} else {
						parteTecnico.setAceptada("1");
					}
					Partetecnicos parteTecnicoAux = this.partetecnicosService
							.add(parteTecnico);

					// Si no tiene email se deja como ASIGNACION MANUAL
					if (tecnicoAux.getMovilgmao() != null
							&& tecnicoAux.getMovilgmao().equals("1")) {
						this.partesService.marcarAutomatica(partesAux);
					} else if (tecnicoAux.getMail() != null) {

						// Actualizar la tabla Partes AUTOMATICA=1
						this.partesService.marcarAutomatica(partesAux);

						// Actualizar la tabla Partes ENVIOMAIL=1
						this.partesService.marcarEnvioMail(partesAux);

						// Enviar email
						try {
							String retorno = enviarMailTecnico(partes,
									tecnicoAux);
							if ("true".equals(retorno)) {
								// Si ha ido bien el envío de mail se marca
								// enviomail =1 en la tabla TecnicoPartes
								this.partetecnicosService.marcarEnvioMail(
										partesAux.getIdparte(),
										tecnicoAux.getIdtecnico());
							}
							PartesController.logger
									.info("[POST] : email enviado" + retorno);
							// return partesAux;
						} catch (Exception e) {
							// TODO Auto-generated catch block
							e.printStackTrace();
						}
					}
					PartesController.logger
							.info("[POST] : Tecnicos encontrados: "
									+ parteTecnicoAux.getIdpartec());
				}
			}
		}

		if (partesAux != null) {

			/**
			 * Enviar mail de confirmación al usuario que ha creado el parte
			 */
			try {
				if (partesAux.getMail() != null
						&& !partesAux.getMail().trim().equals("")) {
					String retorno = enviarMailUsuario(partesAux);
					PartesController.logger
							.info("[POST] : email confirmación enviado"
									+ retorno);
				}
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

			/*
			 * if (!tieneTecnico) { /** No tiene técnico, crea el registro en la
			 * tabla de partes gmao sin incluir ni el técnico ni el código del
			 * parte técnico
			 * 
			 * 
			 * elTecnicoParteGmao.setIdparte(partesAux.getIdparte());
			 * elTecnicoParteGmao.setIdtecnico(null);
			 * elTecnicoParteGmao.setIdpartec(null); randomUUIDString = ""; uuid
			 * = UUID.randomUUID(); randomUUIDString = uuid.toString();
			 * elTecnicoParteGmao.setGuidpartetecgmao(randomUUIDString);
			 * 
			 * tecnicoParteGmaoAux = this.partetecnicosgmaoServices
			 * .add(elTecnicoParteGmao); }
			 */

			/*
			 * String idEdificio = partesAux.getIdedificio();
			 * 
			 * Edificios edifAux = new Edificios(); edifAux =
			 * this.edificiosService.obtenerEdificio(idEdificio);
			 * 
			 * if (partesAux.getIddepar() != null) { Departamentos
			 * departamentoAux = new Departamentos();
			 * departamentoAux.setIddepar(partesAux.getIddepar());
			 * departamentoAux = this.departamentosService
			 * .find(departamentoAux);
			 * partesAux.setDepartamento(departamentoAux); }
			 * 
			 * if (partesAux.getIddir() != null) { Direcciones direccionAux =
			 * new Direcciones(); direccionAux.setIddir(partesAux.getIddir());
			 * direccionAux = this.direccionesService.find(direccionAux);
			 * partesAux.setDireccion(direccionAux); }
			 * 
			 * if (partesAux.getIdplanta() != null) { Plantas plantaAux = new
			 * Plantas(); plantaAux.setIdplanta(partesAux.getIdplanta());
			 * plantaAux = this.plantasService.find(plantaAux);
			 * partesAux.setPlanta(plantaAux); }
			 * 
			 * if (partesAux.getIdzona() != null) { Zonas zonaAux = new Zonas();
			 * zonaAux.setIdzona(partesAux.getIdzona()); zonaAux =
			 * this.zonasService.find(zonaAux); partesAux.setZona(zonaAux);
			 * 
			 * }
			 * 
			 * if (partesAux.getIdespacio() != null) { Espacio espacioAux = new
			 * Espacio(); espacioAux.setIdespacio(partesAux.getIdespacio());
			 * espacioAux = this.espaciosService.find(espacioAux);
			 * partesAux.setEspacio(espacioAux); }
			 * 
			 * // Obtener el plano si tiene Parteplano planoParte = new
			 * Parteplano(); planoParte.setIdparte(partesAux.getIdparte());
			 * 
			 * planoParte = this.parteplanoService.find(planoParte);
			 * 
			 * Partepdf pdfParte = new Partepdf();
			 * pdfParte.setIdparte(partesAux.getIdparte());
			 * 
			 * pdfParte = this.partepdfService.find(pdfParte);
			 * 
			 * if (partesAux.getGuidparte() == null) { randomUUIDString = "";
			 * uuid = UUID.randomUUID(); randomUUIDString = uuid.toString();
			 * partesAux.setGuidparte(randomUUIDString); partesAux =
			 * this.partesService.actualizarUUIDparte(partesAux); }
			 * 
			 * if (planoParte != null) {
			 * 
			 * randomUUIDString = ""; uuid = UUID.randomUUID(); randomUUIDString
			 * = uuid.toString(); if (tieneTecnico) {
			 * elTecnicoParteGmao.setIdparte(partesAux.getIdparte());
			 * elTecnicoParteGmao.setIdtecnico(tecnicoParteGmaoAux
			 * .getIdtecnico());
			 * elTecnicoParteGmao.setIdpartec(tecnicoParteGmaoAux
			 * .getIdpartec()); } else {
			 * elTecnicoParteGmao.setIdparte(partesAux.getIdparte());
			 * elTecnicoParteGmao.setIdtecnico(null);
			 * elTecnicoParteGmao.setIdpartec(null); }
			 * 
			 * elTecnicoParteGmao.setGuidplanopartegmao(randomUUIDString);
			 * tecnicoParteGmaoAux = this.partetecnicosgmaoServices
			 * .update(elTecnicoParteGmao); }
			 * 
			 * if (pdfParte != null) {
			 * 
			 * randomUUIDString = ""; uuid = UUID.randomUUID(); randomUUIDString
			 * = uuid.toString(); if (tieneTecnico) {
			 * elTecnicoParteGmao.setIdparte(partesAux.getIdparte());
			 * elTecnicoParteGmao.setIdtecnico(tecnicoParteGmaoAux
			 * .getIdtecnico());
			 * elTecnicoParteGmao.setIdpartec(tecnicoParteGmaoAux
			 * .getIdpartec()); } else {
			 * elTecnicoParteGmao.setIdparte(partesAux.getIdparte());
			 * elTecnicoParteGmao.setIdtecnico(null);
			 * elTecnicoParteGmao.setIdpartec(null); }
			 * 
			 * elTecnicoParteGmao.setGuidpdfpartegmao(randomUUIDString);
			 * tecnicoParteGmaoAux = this.partetecnicosgmaoServices
			 * .update(elTecnicoParteGmao); }
			 * 
			 * // Obtener tecnicos asignados al parte // (partetecnicos)
			 * tecnicoParteGmaoAux = new Partetecnicosgmao();
			 * tecnicoParteGmaoAux.setIdparte(partesAux.getIdparte());
			 * List<Partetecnicosgmao> parteTecnicosGmao =
			 * this.partetecnicosgmaoServices .findAll(tecnicoParteGmaoAux,
			 * null);
			 * 
			 * byte[] blobAsBytes = null; byte[] blobAsBytesPDF = null; try { if
			 * (planoParte != null) { // Tiene plano int blobLeng = (int)
			 * planoParte.getDibujo().length(); blobAsBytes =
			 * planoParte.getDibujo().getBytes(1, blobLeng); }
			 * 
			 * if (pdfParte != null) { // Tiene plano int blobLeng = (int)
			 * pdfParte.getPdf().length(); blobAsBytesPDF =
			 * pdfParte.getPdf().getBytes(1, blobLeng); }
			 * 
			 * String respuesta = this.procesosJMSService
			 * .sincronizarParteCorrectivoGmao(partesAux, parteTecnicosGmao,
			 * edifAux.getGuidedificio(), blobAsBytes, blobAsBytesPDF,
			 * urlConfig);
			 * 
			 * if (respuesta != null && respuesta.equals("OK")) {
			 * PartesController.logger
			 * .info("[MOVILGMAO] : sincronizarParteCorrectivo: " + respuesta);
			 * 
			 * } else { PartesController.logger
			 * .error("[MOVILGMAO] : sincronizarParteCorrectivo: " + respuesta);
			 * } } catch (Exception e) { e.printStackTrace(); }
			 */

		}

		PartesController.logger.info("[POST] : Partes insertado correctamente");
		Partes parteCorrecto = new Partes();
		parteCorrecto.setIdparte(partesAux.getIdparte());
		return parteCorrecto;

	}

	/**
	 * Method 'enviarParteAlTecnico'.
	 * 
	 * @param idParte
	 *            Integer
	 * @param idTecnico
	 *            Long
	 * @return String
	 */
	@RequestMapping(value = "/enviarParteAlTecnico", method = RequestMethod.POST)
	public @ResponseBody
	String enviarParteAlTecnico(Integer idParte, Long idTecnico)
			throws Exception {
		Tecnicos tecnico = new Tecnicos();
		tecnico.setIdtecnico(idTecnico);

		Tecnicos tecnicoAux = new Tecnicos();
		tecnicoAux = this.tecnicosService.find(tecnico);

		Partes partes = new Partes();
		partes.setIdparte(idParte);

		String mensajeEnviado = this.enviarMailTecnico(partes, tecnicoAux);

		if (mensajeEnviado != null && "true".equals(mensajeEnviado)) {
			// Si se ha enviado correctamente actualizar el campo ENVIO_MAIL del
			// Parte/Tecnico

			this.partetecnicosService.marcarEnvioMail(partes.getIdparte(),
					idTecnico);

		}
		return mensajeEnviado;
	}

	/**
	 * Method 'enviarParteTodosTecnico'.
	 * 
	 * @param idParte
	 *            Integer
	 * @return String
	 */
	@RequestMapping(value = "/enviarParteTodosTecnico", method = RequestMethod.POST)
	public @ResponseBody
	String enviarParteTodosTecnico(Integer idParte) throws Exception {

		Partes partes = new Partes();
		partes.setIdparte(idParte);

		// Obtener los tecnicos asociados a este parte.
		List<Partetecnicos> lsParteTecnicos = this.partetecnicosService
				.obtenerTecnicosParteAsociados(idParte);

		Tecnicos tecnico;
		String mensajeEnviado = "";

		StringBuffer faltanEmail = new StringBuffer("");
		Long idTecnico;
		for (int i = 0; i < lsParteTecnicos.size(); i++) {
			idTecnico = lsParteTecnicos.get(i).getIdtecnico();
			tecnico = new Tecnicos();
			tecnico.setIdtecnico(idTecnico);
			tecnico = this.tecnicosService.find(tecnico);
			if (tecnico.getMail() == null) {
				if (!faltanEmail.toString().equals("")) {
					faltanEmail.append("; ");
					faltanEmail.append(tecnico.getNombre());
				} else {
					faltanEmail.append(tecnico.getNombre());
				}
			}
			mensajeEnviado = this.enviarMailTecnico(partes, tecnico);
			if (mensajeEnviado != null && "true".equals(mensajeEnviado)) {
				// Si se ha enviado correctamente actualizar el campo ENVIO_MAIL
				// del Parte/Tecnico
				this.partetecnicosService.marcarEnvioMail(partes.getIdparte(),
						idTecnico);
				// Actualizar tambien el campo enviomail de la tabla de partes
				this.partesService.marcarEnvioMail(partes);
			} else {
				if (tecnico.getMail() != null) {
					// No se ha podido enviar un mail y el problema no esta en
					// que no existia email para ese tecnico
					return mensajeEnviado;
				}
			}
		}

		if ("".equals(faltanEmail.toString())) {
			return "true";
		} else {
			return "Falta email de: " + faltanEmail.toString();
		}
	}

	private String enviarMailTecnico(Partes parteOrig, Tecnicos tecnicos)
			throws Exception {

		PartesController.logger.info("enviarMailParteAveria - INICIO: ");

		Partes parte = partesService.findParte(parteOrig);

		String to = "";

		// Acceder a los Diccionarios
		Locale loc = LocaleContextHolder.getLocale();
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");

		try {
			// String remitente = this.appConfiguration.getObject().getProperty(
			// "user.mail.remitente");

			String variableRemitente = this.partesService
					.obtenerVariableCorreo("user.mail.remitente");

			if (variableRemitente == null || variableRemitente == "") {
				String retorno = this.appMessageSource.getMessage(
						"general.email.error", null, loc)
						+ "\n"
						+ this.appMessageSource.getMessage(
								"general.email.noExisteEmisor", null, loc);
				return retorno;
			} else {
				String host = this.appConfiguration.getObject().getProperty(
						"servidor.smtp");

				to = tecnicos.getMail();
				// to = "MJ-Mesanza@ejie.eus";

				String from = variableRemitente;

				PartesController.logger
						.info("enviarMailNuevoParte - ENVIAR MAIL from: "
								+ variableRemitente + " to: " + to);

				Properties props = System.getProperties();
				props.put("mail.smtp.host", host);

				// Esta lÃ­nea indica que vamos a autenticarnos en el servidor
				// SMTP
				// props.put("mail.smtp.auth", "true");
				props.put("mail.smtp.auth", "false");

				// Obtener una sesiÃ³n con las propiedades anteriormente
				// definidas
				// Authenticator auth = new MiAutenticador();
				// Session sesion = Session.getDefaultInstance(props, auth);
				Session sesion = Session.getInstance(props);
				String urgenteCAS = "";
				String urgenteEUS = "";
				if (parte != null && parte.getUrgente() != null
						&& parte.getUrgente().equals("1")) {
					urgenteCAS = this.appMessageSource.getMessage(
							"parte.email.urgente", null, lEus);
					urgenteEUS = this.appMessageSource.getMessage(
							"parte.email.urgente", null, lCas);
				}

				String asunto = "##"
						+ urgenteCAS
						+ " "
						+ this.appMessageSource.getMessage(
								"parte.email.asunto", null, lEus)
						+ parte.getIdparte()
						+ " / "
						+ urgenteEUS
						+ " "
						+ this.appMessageSource.getMessage(
								"parte.email.asunto", null, lCas)
						+ +parte.getIdparte() + "##";

				/* EUSKERA */
				StringBuffer contenido = new StringBuffer("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.titulo", null, lEus)
						+ " "
						+ parte.getIdparte()
						+ " "
						+ this.appMessageSource.getMessage(
								"parte.email.titulo2", null, lEus) + "</p>");

				contenido.append("<p>");

				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.DatosPersonales", null, lEus)
						+ "</b>");
				contenido
						.append("<br/><b></u>"
								+ this.appMessageSource.getMessage(
										"parte.email.textoNombre", null, lEus)
								+ "</b>");
				contenido.append(" ").append(parte.getNombre());

				if (parte.getVip() != null && parte.getVip().equals("1")) {
					contenido.append("<br/><b><span style='color:red'>"
							+ this.appMessageSource.getMessage(
									"parte.email.vip", null, lEus)
							+ "</span></b>");
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDepartamento", null, lEus)
						+ "</b>");
				contenido.append(" ").append(
						parte.getDepartamento().getEdepar());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDireccion", null, lEus)
						+ "</b>");
				contenido.append(" ").append(parte.getDireccion().getEdir());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.telefono", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getTelefo());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.email",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getMail());
				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.LocAveria", null, lEus) + "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage(
								"parte.email.edificio", null, lEus) + "</b>");
				contenido.append(" ")
						.append(parte.getEdificio().getEedificio());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.planta", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getPlanta().getEplanta());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.zona",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getZona().getEzona());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.espacio", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getEspacio().getEespacio());
				contenido.append("</p>");

				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.AveriaDetectada", null, lEus)
						+ "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage("parte.email.clase",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getClase().getEclase());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.Activo", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getCodigo().getEcodigo());

				if (!"".equals(urgenteCAS)) {
					contenido
							.append("<br/><b>"
									+ this.appMessageSource.getMessage(
											"parte.email.urgente", null, lEus)
									+ "</b>");
				}

				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<br/><u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.descParte", null, lEus)
						+ "</b></u>");
				contenido.append(" ").append(parte.getObserv());
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.despedida", null, lEus) + "</p>");

				contenido.append("<br/>");
				contenido
						.append("<p style='font-style:italic;'>"
								+ this.appMessageSource.getMessage(
										"parte.email.norespuesta", null, lEus)
								+ "</p>");
				/**/

				contenido
						.append("___________________________________________________________________________________");

				/* CASTELLANO */
				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.titulo", null, lCas) + " "
						+ parte.getIdparte() + "</p>");

				contenido.append("<p>");

				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.DatosPersonales", null, lCas)
						+ "</b>");
				contenido
						.append("<br/><b></u>"
								+ this.appMessageSource.getMessage(
										"parte.email.textoNombre", null, lCas)
								+ "</b>");
				contenido.append(" ").append(parte.getNombre());

				if (parte.getVip() != null && parte.getVip().equals("1")) {
					contenido.append("<br/><b><span style='color:red'>"
							+ this.appMessageSource.getMessage(
									"parte.email.vip", null, lCas)
							+ "</span></b>");
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDepartamento", null, lCas)
						+ "</b>");
				contenido.append(" ").append(
						parte.getDepartamento().getCdepar());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDireccion", null, lCas)
						+ "</b>");
				contenido.append(" ").append(parte.getDireccion().getCdir());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.telefono", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getTelefo());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.email",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getMail());
				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.LocAveria", null, lCas) + "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage(
								"parte.email.edificio", null, lCas) + "</b>");
				contenido.append(" ")
						.append(parte.getEdificio().getCedificio());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.planta", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getPlanta().getCplanta());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.zona",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getZona().getCzona());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.espacio", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getEspacio().getCespacio());
				contenido.append("</p>");

				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.AveriaDetectada", null, lCas)
						+ "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage("parte.email.clase",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getClase().getCclase());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.Activo", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getCodigo().getCcodigo());

				if (!"".equals(urgenteCAS)) {
					contenido
							.append("<br/><b>"
									+ this.appMessageSource.getMessage(
											"parte.email.urgente", null, lCas)
									+ "</b>");
				}

				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<br/><u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.descParte", null, lCas)
						+ "</b></u>");
				contenido.append(" ").append(parte.getObserv());
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.despedida", null, lCas) + "</p>");

				contenido.append("<br/>");
				contenido
						.append("<p style='font-style:italic;'>"
								+ this.appMessageSource.getMessage(
										"parte.email.norespuesta", null, lCas)
								+ "</p>");
				/**/

				/**/

				// contenido
				// .append("<img src='http://desarrollo.jakina.ejiedes.net:7001/aa20bMaqPartesWar/parteplano/mostrarPlanoParte?idParte="
				// + parte.getIdparte() + "'/>");
				/*
				 * String urlBase =
				 * this.appConfiguration.getObject().getProperty( "url_base");
				 * contenido .append("<img src='" + urlBase +
				 * "/aa20bMaqPartesWar/parteplano/mostrarPlanoParte?idParte=" +
				 * parte.getIdparte() + "'/>");
				 */
				// Añadir la imagen

				// Map<String, String> inlineImages = new HashMap<String,
				// String>();
				/*
				 * String urlBase =
				 * this.appConfiguration.getObject().getProperty( "url_base");
				 * inlineImages .put("planoAveria", urlBase +
				 * "/aa20bMaqPartesWar/parteplano/mostrarPlanoParte?idParte=" +
				 * parte.getIdparte());
				 */

				// Obtener el plano si tiene
				Parteplano planoParte = new Parteplano();
				planoParte.setIdparte(parte.getIdparte());

				planoParte = this.parteplanoService.find(planoParte);
				byte[] blobAsBytes = null;
				if (planoParte != null) {
					// Tiene plano
					int blobLeng = (int) planoParte.getDibujo().length();
					blobAsBytes = planoParte.getDibujo().getBytes(1, blobLeng);
				}

				// inlineImages.put("planoAveria", "D:/Koala.jpg");

				// FIN Añadir la imagen

				// create a message
				MimeMessage msg = new MimeMessage(sesion);
				msg.setFrom(new InternetAddress(from));
				msg.addRecipient(Message.RecipientType.TO, new InternetAddress(
						to));

				// String emailoculto = this.appConfiguration.getObject()
				// .getProperty("emailCopiaOculta");

				String variableEmailOculto = this.partesService
						.obtenerVariableCorreo("emailCopiaOculta");

				if (variableEmailOculto != null
						&& !variableEmailOculto.isEmpty())
					msg.addRecipient(Message.RecipientType.BCC,
							new InternetAddress(variableEmailOculto));
				// create and fill the first message part
				MimeBodyPart mbp1 = new MimeBodyPart();

				if (blobAsBytes != null) {
					contenido.append("<img src='cid:planoAveria\'/>");
				}
				// mbp1.setText(contenido.toString());
				mbp1.setContent(contenido.toString(), "text/html");
				// mbp1.setHeader("Content-Type",
				// "text/html; charset=ISO-8859-1");
				Multipart mp = new MimeMultipart();
				mp.addBodyPart(mbp1);

				if (blobAsBytes != null) {
					MimeBodyPart mbp2 = new MimeBodyPart();
					mbp2.setHeader("Content-ID", "<planoAveria>");
					mbp2.setDisposition(MimeBodyPart.INLINE);
					// create the Multipart and add its parts to it
					ByteArrayDataSource source = new ByteArrayDataSource(
							blobAsBytes, "image/jpeg");
					mbp2.setDataHandler(new DataHandler(source));
					mbp2.setFileName("planoParte.png");

					mp.addBodyPart(mbp2);
				}

				// Si hay imagen
				/*
				 * if (inlineImages != null && inlineImages.size() > 0) {
				 * Set<String> setImageID = inlineImages.keySet(); for (String
				 * contentId : setImageID) { MimeBodyPart imagePart = new
				 * MimeBodyPart(); ByteArrayDataSource source = new
				 * ByteArrayDataSource(blobAsBytes, "image/jpeg");
				 * 
				 * mbp1.setDataHandler(new DataHandler(source));
				 * mbp1.setFileName(attachment.getFileName());
				 * 
				 * 
				 * 
				 * String imageFilePath = inlineImages.get(contentId); try {
				 * imagePart.attachFile(imageFilePath); } catch (IOException ex)
				 * { ex.printStackTrace(); } mp.addBodyPart(imagePart); } }
				 */

				// add the Multipart to the message
				msg.setContent(mp);
				msg.setSubject(asunto);

				// set the Date: header
				msg.setSentDate(new Date());

				// send the message
				Transport.send(msg);

				planoParte = null;

				// Marcar
				PartesController.logger.info("enviarMailParteAveria - FIN. ");

				return "true";
			}
		} catch (Exception ex) {
			PartesController.logger
					.error("enviarMailParteAveria - ENVIAR MAIL to:" + to + " "
							+ ex.getMessage());
			StackTraceElement[] trazas = ex.getStackTrace();
			for (StackTraceElement traza : trazas) {
				PartesController.logger.error(traza.toString());
			}
			StringBuffer retorno = new StringBuffer();
			retorno.append(
					this.appMessageSource.getMessage("general.email.error",
							null, loc))
					.append("\n")
					.append(this.appMessageSource.getMessage(
							"general.email.noExisteEmisor", null, loc));
			retorno.append(" ").append(to);
			return retorno.toString();
		}
	}

	private String enviarMailUsuario(Partes parteOrig) throws Exception {

		PartesController.logger.info("enviarMailParteAveria - INICIO: ");

		Partes parte = partesService.findParte(parteOrig);

		String to = "";

		// Acceder a los Diccionarios
		Locale loc = LocaleContextHolder.getLocale();
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");

		try {
			// String remitente = this.appConfiguration.getObject().getProperty(
			// "user.mail.remitente");

			String variableRemitente = this.partesService
					.obtenerVariableCorreo("user.mail.remitente");

			if (variableRemitente == null || variableRemitente == "") {
				String retorno = this.appMessageSource.getMessage(
						"general.email.error", null, loc)
						+ "\n"
						+ this.appMessageSource.getMessage(
								"general.email.noExisteEmisor", null, loc);
				return retorno;
			} else {
				String host = this.appConfiguration.getObject().getProperty(
						"servidor.smtp");

				to = parte.getMail();
				// to = "MJ-Mesanza@ejie.eus";

				String from = variableRemitente;

				PartesController.logger
						.info("enviarMailConfirmacionNuevoParte - ENVIAR MAIL from: "
								+ variableRemitente + " to: " + to);

				Properties props = System.getProperties();
				props.put("mail.smtp.host", host);
				props.put("mail.smtp.auth", "false");

				Session sesion = Session.getInstance(props);
				String urgenteCAS = "";
				String urgenteEUS = "";
				if (parte != null && parte.getUrgente() != null
						&& parte.getUrgente().equals("1")) {
					urgenteCAS = this.appMessageSource.getMessage(
							"parte.email.urgente", null, lEus);
					urgenteEUS = this.appMessageSource.getMessage(
							"parte.email.urgente", null, lCas);
				}

				String asunto = "##"
						+ urgenteCAS
						+ " "
						+ this.appMessageSource.getMessage(
								"parte.email.asuntousuario", null, lEus)
						+ parte.getIdparte()
						+ " / "
						+ urgenteEUS
						+ " "
						+ this.appMessageSource.getMessage(
								"parte.email.asuntousuario", null, lCas)
						+ +parte.getIdparte() + "##";

				/* EUSKERA */
				StringBuffer contenido = new StringBuffer("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.titulo", null, lEus)
						+ " "
						+ parte.getIdparte()
						+ " "
						+ this.appMessageSource.getMessage(
								"parte.email.titulo2", null, lEus) + "</p>");

				contenido.append("<p>");

				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.DatosPersonales", null, lEus)
						+ "</b>");
				contenido
						.append("<br/><b></u>"
								+ this.appMessageSource.getMessage(
										"parte.email.textoNombre", null, lEus)
								+ "</b>");
				contenido.append(" ").append(parte.getNombre());

				if (parte.getVip() != null && parte.getVip().equals("1")) {
					contenido.append("<br/><b><span style='color:red'>"
							+ this.appMessageSource.getMessage(
									"parte.email.vip", null, lEus)
							+ "</span></b>");
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDepartamento", null, lEus)
						+ "</b>");
				contenido.append(" ").append(
						parte.getDepartamento().getEdepar());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDireccion", null, lEus)
						+ "</b>");
				contenido.append(" ").append(parte.getDireccion().getEdir());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.telefono", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getTelefo());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.email",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getMail());
				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.LocAveria", null, lEus) + "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage(
								"parte.email.edificio", null, lEus) + "</b>");
				contenido.append(" ")
						.append(parte.getEdificio().getEedificio());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.planta", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getPlanta().getEplanta());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.zona",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getZona().getEzona());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.espacio", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getEspacio().getEespacio());
				contenido.append("</p>");

				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.AveriaDetectada", null, lEus)
						+ "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage("parte.email.clase",
								null, lEus) + "</b>");
				contenido.append(" ").append(parte.getClase().getEclase());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.Activo", null, lEus) + "</b>");
				contenido.append(" ").append(parte.getCodigo().getEcodigo());

				if (!"".equals(urgenteCAS)) {
					contenido
							.append("<br/><b>"
									+ this.appMessageSource.getMessage(
											"parte.email.urgente", null, lEus)
									+ "</b>");
				}

				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<br/><u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.descParte", null, lEus)
						+ "</b></u>");
				contenido.append(" ").append(parte.getObserv());
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.despedida", null, lEus) + "</p>");

				contenido.append("<br/>");
				contenido
						.append("<p style='font-style:italic;'>"
								+ this.appMessageSource.getMessage(
										"parte.email.norespuesta", null, lEus)
								+ "</p>");
				/**/

				contenido
						.append("___________________________________________________________________________________");

				/* CASTELLANO */
				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.titulo", null, lCas) + " "
						+ parte.getIdparte() + "</p>");

				contenido.append("<p>");

				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.DatosPersonales", null, lCas)
						+ "</b>");
				contenido
						.append("<br/><b></u>"
								+ this.appMessageSource.getMessage(
										"parte.email.textoNombre", null, lCas)
								+ "</b>");
				contenido.append(" ").append(parte.getNombre());

				if (parte.getVip() != null && parte.getVip().equals("1")) {
					contenido.append("<br/><b><span style='color:red'>"
							+ this.appMessageSource.getMessage(
									"parte.email.vip", null, lCas)
							+ "</span></b>");
				}
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDepartamento", null, lCas)
						+ "</b>");
				contenido.append(" ").append(
						parte.getDepartamento().getCdepar());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.textoDireccion", null, lCas)
						+ "</b>");
				contenido.append(" ").append(parte.getDireccion().getCdir());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.telefono", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getTelefo());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.email",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getMail());
				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.LocAveria", null, lCas) + "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage(
								"parte.email.edificio", null, lCas) + "</b>");
				contenido.append(" ")
						.append(parte.getEdificio().getCedificio());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.planta", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getPlanta().getCplanta());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("parte.email.zona",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getZona().getCzona());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.espacio", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getEspacio().getCespacio());
				contenido.append("</p>");

				contenido.append("<p>");
				contenido.append("<u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.AveriaDetectada", null, lCas)
						+ "</b>");
				contenido.append("<br/><b></u>"
						+ this.appMessageSource.getMessage("parte.email.clase",
								null, lCas) + "</b>");
				contenido.append(" ").append(parte.getClase().getCclase());
				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.Activo", null, lCas) + "</b>");
				contenido.append(" ").append(parte.getCodigo().getCcodigo());

				if (!"".equals(urgenteCAS)) {
					contenido
							.append("<br/><b>"
									+ this.appMessageSource.getMessage(
											"parte.email.urgente", null, lCas)
									+ "</b>");
				}

				contenido.append("</p>");
				contenido.append("<p>");
				contenido.append("<br/><u><b>"
						+ this.appMessageSource.getMessage(
								"parte.email.descParte", null, lCas)
						+ "</b></u>");
				contenido.append(" ").append(parte.getObserv());
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.despedida", null, lCas) + "</p>");

				contenido.append("<br/>");
				contenido
						.append("<p style='font-style:italic;'>"
								+ this.appMessageSource.getMessage(
										"parte.email.norespuesta", null, lCas)
								+ "</p>");
				/**/

				/**/

				// contenido
				// .append("<img src='http://desarrollo.jakina.ejiedes.net:7001/aa20bMaqPartesWar/parteplano/mostrarPlanoParte?idParte="
				// + parte.getIdparte() + "'/>");
				/*
				 * String urlBase =
				 * this.appConfiguration.getObject().getProperty( "url_base");
				 * contenido .append("<img src='" + urlBase +
				 * "/aa20bMaqPartesWar/parteplano/mostrarPlanoParte?idParte=" +
				 * parte.getIdparte() + "'/>");
				 */
				// Añadir la imagen

				// Map<String, String> inlineImages = new HashMap<String,
				// String>();
				/*
				 * String urlBase =
				 * this.appConfiguration.getObject().getProperty( "url_base");
				 * inlineImages .put("planoAveria", urlBase +
				 * "/aa20bMaqPartesWar/parteplano/mostrarPlanoParte?idParte=" +
				 * parte.getIdparte());
				 */

				// Obtener el plano si tiene
				Parteplano planoParte = new Parteplano();
				planoParte.setIdparte(parte.getIdparte());

				planoParte = this.parteplanoService.find(planoParte);
				byte[] blobAsBytes = null;
				if (planoParte != null) {
					// Tiene plano
					int blobLeng = (int) planoParte.getDibujo().length();
					blobAsBytes = planoParte.getDibujo().getBytes(1, blobLeng);
				}

				// inlineImages.put("planoAveria", "D:/Koala.jpg");

				// FIN Añadir la imagen

				// create a message
				MimeMessage msg = new MimeMessage(sesion);
				msg.setFrom(new InternetAddress(from));
				msg.addRecipient(Message.RecipientType.TO, new InternetAddress(
						to));

				// String emailoculto = this.appConfiguration.getObject()
				// .getProperty("emailCopiaOculta");

				String variableEmailOculto = this.partesService
						.obtenerVariableCorreo("emailCopiaOculta");

				if (variableEmailOculto != null
						&& !variableEmailOculto.isEmpty())
					msg.addRecipient(Message.RecipientType.BCC,
							new InternetAddress(variableEmailOculto));
				// create and fill the first message part
				MimeBodyPart mbp1 = new MimeBodyPart();

				if (blobAsBytes != null) {
					contenido.append("<img src='cid:planoAveria\'/>");
				}
				// mbp1.setText(contenido.toString());
				mbp1.setContent(contenido.toString(), "text/html");
				// mbp1.setHeader("Content-Type",
				// "text/html; charset=ISO-8859-1");
				Multipart mp = new MimeMultipart();
				mp.addBodyPart(mbp1);

				if (blobAsBytes != null) {
					MimeBodyPart mbp2 = new MimeBodyPart();
					mbp2.setHeader("Content-ID", "<planoAveria>");
					mbp2.setDisposition(MimeBodyPart.INLINE);
					// create the Multipart and add its parts to it
					ByteArrayDataSource source = new ByteArrayDataSource(
							blobAsBytes, "image/jpeg");
					mbp2.setDataHandler(new DataHandler(source));
					mbp2.setFileName("planoParte.png");

					mp.addBodyPart(mbp2);
				}

				// Si hay imagen
				/*
				 * if (inlineImages != null && inlineImages.size() > 0) {
				 * Set<String> setImageID = inlineImages.keySet(); for (String
				 * contentId : setImageID) { MimeBodyPart imagePart = new
				 * MimeBodyPart(); ByteArrayDataSource source = new
				 * ByteArrayDataSource(blobAsBytes, "image/jpeg");
				 * 
				 * mbp1.setDataHandler(new DataHandler(source));
				 * mbp1.setFileName(attachment.getFileName());
				 * 
				 * 
				 * 
				 * String imageFilePath = inlineImages.get(contentId); try {
				 * imagePart.attachFile(imageFilePath); } catch (IOException ex)
				 * { ex.printStackTrace(); } mp.addBodyPart(imagePart); } }
				 */

				// add the Multipart to the message
				msg.setContent(mp);
				msg.setSubject(asunto);

				// set the Date: header
				msg.setSentDate(new Date());

				// send the message
				Transport.send(msg);

				planoParte = null;

				// Marcar
				PartesController.logger.info("enviarMailParteAveria - FIN. ");

				return "true";
			}
		} catch (Exception ex) {
			PartesController.logger
					.error("enviarMailParteAveriaUsuario - ENVIAR MAIL to:"
							+ to + " " + ex.getMessage());
			StackTraceElement[] trazas = ex.getStackTrace();
			for (StackTraceElement traza : trazas) {
				PartesController.logger.error(traza.toString());
			}
			StringBuffer retorno = new StringBuffer();
			retorno.append(
					this.appMessageSource.getMessage("general.email.error",
							null, loc))
					.append("\n")
					.append(this.appMessageSource.getMessage(
							"general.email.noExisteEmisor", null, loc));
			retorno.append(" ").append(to);
			return retorno.toString();
		}
	}

	/**
	 * Method 'actualizarEjecParte'.
	 * 
	 * @param idParte
	 *            Integer
	 * @param accionParte
	 *            String
	 * @return Partes
	 */
	@RequestMapping(value = "/actualizarEjecParte", method = RequestMethod.POST)
	public @ResponseBody
	Partes actualizarEjecParte(@RequestParam Integer idParte,
			@RequestParam String accionParte, Model model,
			HttpServletRequest request) {

		Partes parte = new Partes();
		if (accionParte.equalsIgnoreCase("ABRIR")) {
			parte = this.partesService.abrirParte(idParte);

		} else if (accionParte.equalsIgnoreCase("FINALIZAR")) {
			parte = this.partesService.finalizarParte(idParte);
		}

		PartesController.logger.info("[GET - FINALIZAR PARTE ] " + idParte);

		return parte;
	}

	/**
	 * Method 'listadoPartesCorrVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "listadoPartesCorrVolver", method = RequestMethod.GET)
	public String listadoPartesCorrVolver(Model model,
			HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : listadoPartesCorr");
		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Partes parteFiltro = (Partes) request.getSession().getAttribute(
				"FiltroPartes");

		model.addAttribute("FiltroParte", parteFiltro);

		Boolean usuarioEsTecMantenimiento = this.usuarioXLNETService
				.esTecMantenimiento();

		if (usuarioEsTecMantenimiento) {
			model.addAttribute("modoConsultaTipo", "1");
		} else {
			model.addAttribute("modoConsultaTipo", "0");
		}

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) { // TODO Auto-generated catch
												// block
			e.printStackTrace();
		}

		model.addAttribute("idUsuario", sUIDUsuario);

		return "listadoPartesCorr";
	}

	/**
	 * Method 'listadoPartesCorr'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "listadoPartesCorr", method = RequestMethod.GET)
	public String listadoPartesCorr(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : listadoPartesCorr");
		// Vaciar el filtro guardado en la sesion
		request.getSession().removeAttribute("FiltroPartes");

		Boolean usuarioEsTecMantenimiento = this.usuarioXLNETService
				.esTecMantenimiento();

		if (usuarioEsTecMantenimiento) {
			model.addAttribute("modoConsultaTipo", "1");
		} else {
			model.addAttribute("modoConsultaTipo", "0");
		}

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) { // TODO Auto-generated catch
												// block
			e.printStackTrace();
		}

		model.addAttribute("idUsuario", sUIDUsuario);

		return "listadoPartesCorr";
	}

	/**
	 * Method 'listadoEjecTecnicoVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "listadoEjecTecnicoVolver", method = RequestMethod.GET)
	public String listadoEjecTecnicoVolver(Model model,
			HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : listadoEjecTecnico");
		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Partes parteFiltro = (Partes) request.getSession().getAttribute(
				"FiltroPartes");

		model.addAttribute("FiltroParte", parteFiltro);

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) { // TODO Auto-generated catch
												// block
			e.printStackTrace();
		}

		model.addAttribute("idUsuario", sUIDUsuario);

		return "listadoEjecTecnico";
	}

	/**
	 * Method 'listadoEjecTecnico'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "listadoEjecTecnico", method = RequestMethod.GET)
	public String listadoEjecTecnico(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : listadoEjecTecnico");
		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroPartes");

		return "listadoEjecTecnico";
	}

	/**
	 * Method 'listadoEjecFechaEjVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "listadoEjecFechaEjVolver", method = RequestMethod.GET)
	public String listadoEjecFechaEjVolver(Model model,
			HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : listadoEjecFechaEj");
		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Partes parteFiltro = (Partes) request.getSession().getAttribute(
				"FiltroPartes");

		model.addAttribute("FiltroParte", parteFiltro);

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) { // TODO Auto-generated catch
												// block
			e.printStackTrace();
		}

		model.addAttribute("idUsuario", sUIDUsuario);
		model.addAttribute("volver", "SI");

		return "listadoEjecFechaEj";
	}

	/**
	 * Method 'listadoEjecFechaEj'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "listadoEjecFechaEj", method = RequestMethod.GET)
	public String listadoEjecFechaEj(Model model, HttpServletRequest request) {
		PartesController.logger.info("[GET - View] : listadoEjecFechaEj");
		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroPartes");

		return "listadoEjecFechaEj";
	}

	/**
	 * Method 'imprimirListadoCorr'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirCorrectivos", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirCorrectivos(@ModelAttribute Partes filterPartes,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {
		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;
		Date dateFechaPlanifD = null;
		Date dateFechaPlanifH = null;

		if (filterPartes != null && filterPartes.getStrFechareD() != null
				&& !filterPartes.getStrFechareD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterPartes.getStrFechareD());
				filterPartes.setFechareD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterPartes != null && filterPartes.getStrFechareH() != null
				&& !filterPartes.getStrFechareH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterPartes.getStrFechareH());
				filterPartes.setFechareH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterPartes != null && filterPartes.getStrFechaplanifD() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifD = sdf.parse(filterPartes.getStrFechaplanifD());
				filterPartes.setFechaplanifD(dateFechaPlanifD);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes != null && filterPartes.getStrFechaplanifH() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifH = sdf.parse(filterPartes.getStrFechaplanifH());
				filterPartes.setFechaplanifH(dateFechaPlanifH);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				if (filterPartes != null && filterPartes.getCodigo() != null) {
					codigo = filterPartes.getCodigo();
				}
				codigo.setIdservicio(usuario.getIdservicio());
				filterPartes.setCodigo(codigo);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		Correctivos correctivos = new Correctivos();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.partesService
					.montarSelectTablaCorrectivos(idioma, filterPartes,
							sUIDUsuario);

			if (usuarioEsAdministrador
					&& filterPartes.getCodigo().getIdservicio() != null) {
				// Obtener la descripción del servicio seleccionado para mostrar
				// en la cabecera del pdf
				Servicios servicio = new Servicios();
				servicio.setIdservicio((long) filterPartes.getCodigo()
						.getIdservicio());
				servicio = this.serviciosService.find(servicio);
				Codigo codigo = new Codigo();
				codigo.setServicio(servicio);
				codigo.setIdservicio(filterPartes.getCodigo().getIdservicio());
				filterPartes.setCodigo(codigo);
			}

			String plantilla = "";
			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				plantilla = Aa20bConstantes.plantillaCorrectivosAgrupeu;
				if (filterPartes != null
						&& filterPartes.getOperacion().equals("1")) {
					plantilla = Aa20bConstantes.plantillaCorrectivoseu;
				}
				generaPdfRtf.generarXML2PDF(response, correctivos
						.getFoCorrectivosXml(request, locale, listaTabla,
								filterPartes), plantilla);

			} else {
				plantilla = Aa20bConstantes.plantillaCorrectivosAgrup;
				if (filterPartes != null
						&& filterPartes.getOperacion().equals("1")) {
					plantilla = Aa20bConstantes.plantillaCorrectivos;
				}
				generaPdfRtf.generarXML2PDF(response, correctivos
						.getFoCorrectivosXml(request, locale, listaTabla,
								filterPartes), plantilla);

			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	/**
	 * Method 'imprimirListadoEjecTecnico'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirEjecTecnico", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirEjecTecnico(@ModelAttribute Partes filterPartes,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {
		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;
		Date dateFechaPlanifD = null;
		Date dateFechaPlanifH = null;

		if (filterPartes != null && filterPartes.getStrFechareD() != null
				&& !filterPartes.getStrFechareD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterPartes.getStrFechareD());
				filterPartes.setFechareD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterPartes != null && filterPartes.getStrFechareH() != null
				&& !filterPartes.getStrFechareH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterPartes.getStrFechareH());
				filterPartes.setFechareH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

		if (filterPartes != null && filterPartes.getStrFechaplanifD() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifD = sdf.parse(filterPartes.getStrFechaplanifD());
				filterPartes.setFechaplanifD(dateFechaPlanifD);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes != null && filterPartes.getStrFechaplanifH() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifH = sdf.parse(filterPartes.getStrFechaplanifH());
				filterPartes.setFechaplanifH(dateFechaPlanifH);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				if (filterPartes != null && filterPartes.getCodigo() != null) {
					codigo = filterPartes.getCodigo();
				}
				codigo.setIdservicio(usuario.getIdservicio());
				filterPartes.setCodigo(codigo);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		EjecTecnico ejecTecnico = new EjecTecnico();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.partesService
					.montarSelectTablaEjecTecnico(idioma, filterPartes,
							sUIDUsuario);

			if (usuarioEsAdministrador
					&& filterPartes.getCodigo().getIdservicio() != null) {
				// Obtener la descripción del servicio seleccionado para mostrar
				// en la cabecera del pdf
				Servicios servicio = new Servicios();
				servicio.setIdservicio((long) filterPartes.getCodigo()
						.getIdservicio());
				servicio = this.serviciosService.find(servicio);
				Codigo codigo = new Codigo();
				codigo.setServicio(servicio);
				codigo.setIdservicio(filterPartes.getCodigo().getIdservicio());
				filterPartes.setCodigo(codigo);
			}

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, ejecTecnico
						.getFoEjecTecnicoXml(request, locale, listaTabla,
								filterPartes),
						Aa20bConstantes.plantillaEjecTecnicoeu);

			} else {
				generaPdfRtf.generarXML2PDF(response, ejecTecnico
						.getFoEjecTecnicoXml(request, locale, listaTabla,
								filterPartes),
						Aa20bConstantes.plantillaEjecTecnico);

			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	/**
	 * Method 'imprimirEjecFechaEj'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirEjecFechaEj", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirEjecFechaEj(@ModelAttribute Partes filterPartes,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {
		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;
		Date dateFechaPlanifD = null;
		Date dateFechaPlanifH = null;

		if (filterPartes != null && filterPartes.getStrFechareD() != null
				&& !filterPartes.getStrFechareD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterPartes.getStrFechareD());
				filterPartes.setFechareD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterPartes != null && filterPartes.getStrFechareH() != null
				&& !filterPartes.getStrFechareH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterPartes.getStrFechareH());
				filterPartes.setFechareH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

		if (filterPartes != null && filterPartes.getStrFechaplanifD() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifD = sdf.parse(filterPartes.getStrFechaplanifD());
				filterPartes.setFechaplanifD(dateFechaPlanifD);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		if (filterPartes != null && filterPartes.getStrFechaplanifH() != null) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaPlanifH = sdf.parse(filterPartes.getStrFechaplanifH());
				filterPartes.setFechaplanifH(dateFechaPlanifH);
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				if (filterPartes != null && filterPartes.getCodigo() != null) {
					codigo = filterPartes.getCodigo();
				}
				codigo.setIdservicio(usuario.getIdservicio());
				filterPartes.setCodigo(codigo);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		EjecFechaEj ejecTecnico = new EjecFechaEj();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.partesService
					.montarSelectTablaEjecFechaEj(idioma, filterPartes,
							sUIDUsuario);

			if (usuarioEsAdministrador
					&& filterPartes.getCodigo().getIdservicio() != null) {
				// Obtener la descripción del servicio seleccionado para mostrar
				// en la cabecera del pdf
				Servicios servicio = new Servicios();
				servicio.setIdservicio((long) filterPartes.getCodigo()
						.getIdservicio());
				servicio = this.serviciosService.find(servicio);
				Codigo codigo = new Codigo();
				codigo.setServicio(servicio);
				codigo.setIdservicio(filterPartes.getCodigo().getIdservicio());
				filterPartes.setCodigo(codigo);
			}

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, ejecTecnico
						.getFoEjecFechaEjXml(request, locale, listaTabla,
								filterPartes),
						Aa20bConstantes.plantillaEjecFechaEjeu);

			} else {
				generaPdfRtf.generarXML2PDF(response, ejecTecnico
						.getFoEjecFechaEjXml(request, locale, listaTabla,
								filterPartes),
						Aa20bConstantes.plantillaEjecFechaEj);

			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

	@RequestMapping(value = "/comprobarParteZonaTecnico", method = RequestMethod.POST)
	public @ResponseBody
	String comprobarParteZonaTecnico(@RequestParam String codEdificio,
			@RequestParam Long idTecnico,
			@RequestParam ArrayList<Integer> zonasSeleccionadas, Model model,
			HttpServletRequest request) {
		String valorDevuelto = "";
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");
		Locale locale = LocaleContextHolder.getLocale();
		String idioma = locale.getLanguage();
		PartesController.logger
				.info("[POST - comprobarParteZonaTecnico] : Comprobar si el tecnico tiene un parte asociado en esa zona: ");

		for (int i = 0; i < zonasSeleccionadas.size(); i++) {
			List<Partes> partesEncontrados = this.partesService
					.comprobarParteZonaTecnico(codEdificio,
							zonasSeleccionadas.get(i), idTecnico);
			if (partesEncontrados.size() > 0) {
				if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
					valorDevuelto = this.appMessageSource.getMessage(
							"parte.numParte", null, lEus)
							+ ": "
							+ partesEncontrados.get(0).getIdparte()
							+ " - "
							+ this.appMessageSource.getMessage("parte.zona",
									null, lEus)
							+ ": "
							+ partesEncontrados.get(0).getZona().getEzona();
				} else {
					valorDevuelto = this.appMessageSource.getMessage(
							"parte.numParte", null, lCas)
							+ ": "
							+ partesEncontrados.get(0).getIdparte()
							+ " - "
							+ this.appMessageSource.getMessage("parte.zona",
									null, lCas)
							+ ": "
							+ partesEncontrados.get(0).getZona().getCzona();
				}
				return valorDevuelto;
			}

		}

		return valorDevuelto;
	}

	/**
	 * 
	 * Method 'tienenParteZonas'.
	 * 
	 * 
	 * puestoIntroducido String
	 * 
	 * @return List
	 */

	@RequestMapping(value = "/tienenParteZonas", method = RequestMethod.POST)
	public @ResponseBody
	StringBuffer tienenParteZonas(@RequestParam String codEdificio,
			@RequestParam ArrayList<Integer> zonasSeleccionadas, Model model,
			HttpServletRequest request) {

		Partes parte = new Partes();

		PartesController.logger
				.info("[POST - tienenParteZonas] : Comprobando si la zona a desasociar tiene partes asignados  : ");

		StringBuffer strPartes = new StringBuffer("");

		for (int i = 0; i < zonasSeleccionadas.size(); i++) {
			parte.setIdedificio(codEdificio);
			parte.setIdzona(zonasSeleccionadas.get(i));

			List<Partes> lsPartes = this.partesService.findAll(parte, null);
			for (Partes parteAux : lsPartes) {

				// Insertar en la tabla de ParteTecnicos
				strPartes.append(parteAux.getIdparte().toString());
				strPartes.append("; ");
			}
		}
		return strPartes;
	}

	/**
	 * 
	 * Method 'tienenParteZonaPlanta'.
	 * 
	 * 
	 * puestoIntroducido String
	 * 
	 * @return List
	 */

	@RequestMapping(value = "/tienenParteZonaPlanta", method = RequestMethod.POST)
	public @ResponseBody
	StringBuffer tienenParteZonaPlanta(@RequestParam String codEdificio,
			@RequestParam Integer codZona,
			@RequestParam ArrayList<Integer> plantasSeleccionadas, Model model,
			HttpServletRequest request) {

		Partes parte = new Partes();

		PartesController.logger
				.info("[POST - tienenParteZonaPlanta] : Comprobando si la planta/zona a desasociar tiene partes asignados  : ");

		StringBuffer strPartes = new StringBuffer("");

		for (int i = 0; i < plantasSeleccionadas.size(); i++) {
			parte.setIdedificio(codEdificio);
			parte.setIdzona(codZona);
			parte.setIdplanta(plantasSeleccionadas.get(i));

			List<Partes> lsPartes = this.partesService.findAll(parte, null);
			for (Partes parteAux : lsPartes) {

				// Insertar en la tabla de ParteTecnicos
				strPartes.append(parteAux.getIdparte().toString());
				strPartes.append("; ");
			}
		}
		return strPartes;
	}

	/**
	 * 
	 * Method 'eliminarParte'.
	 * 
	 * 
	 * puestoIntroducido String
	 * 
	 * @return Boolean
	 */

	@RequestMapping(value = "/eliminarParte", method = RequestMethod.POST)
	public @ResponseBody
	Boolean eliminarParte(@RequestParam Integer idParte, Model model,
			HttpServletRequest request) {

		Partes parte = new Partes();

		PartesController.logger
				.info("[POST - eliminarParte] : Eliminar el parte. ");

		parte.setIdparte(idParte);

		this.partesService.eliminarParte(parte);

		/**
		 * Comprobamos si el parte se había subido a movilgmao, si es así lo
		 * eliminamos
		 */
		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {
			e.printStackTrace();
		}

		Partetecnicosgmao partetecgmaoAux = new Partetecnicosgmao();
		partetecgmaoAux.setIdparte(idParte);
		partetecgmaoAux = this.partetecnicosgmaoServices
				.findByIdParte(partetecgmaoAux);
		if (partetecgmaoAux != null) {
			this.procesosJMSService.eliminarOTpadre(
					partetecgmaoAux.getGuidpartetecgmao(), urlConfig);

			this.partetecnicosgmaoServices.remove(partetecgmaoAux);
		}
		return true;
	}

	/**
	 * 
	 * Method 'parteTieneHijos'.
	 * 
	 * 
	 * puestoIntroducido String
	 * 
	 * @return Boolean
	 */

	@RequestMapping(value = "/parteTieneHijos", method = RequestMethod.POST)
	public @ResponseBody
	Boolean parteTieneHijos(@RequestParam Integer idParte, Model model,
			HttpServletRequest request) {

		Partes parte = new Partes();

		PartesController.logger
				.info("[POST - parteTieneHijos] : Comprobar si el parte tiene hijos. ");

		parte.setAveriaRepe(idParte);

		List<Partes> lsPartes = this.partesService.findAll(parte, null);
		if (lsPartes.size() > 0) {
			return true;
		} else {
			return false;
		}

	}

	@RequestMapping(value = "/parteFinalizado", method = RequestMethod.POST)
	public @ResponseBody
	Boolean parteFinalizado(@RequestParam Integer idParte, Model model,
			HttpServletRequest request) {

		Partes parte = new Partes();

		PartesController.logger
				.info("[POST - parteTieneHijos] : Comprobar si el parte esta finalizado. ");

		parte.setEjecutado("1");
		parte.setIdparte(idParte);

		List<Partes> lsPartes = this.partesService.findAll(parte, null);
		if (lsPartes.size() > 0) {
			return true;
		} else {
			return false;
		}

	}

	/**
	 * Method 'obtenerDatosEjecucion'.
	 * 
	 * @param idparte
	 *            Integer
	 * @return List
	 */
	@RequestMapping(value = "/obtenerDatosEjecucion", method = RequestMethod.POST)
	public @ResponseBody
	Partes obtenerDatosEjecucion(@RequestParam Integer idparte) {
		PartesController.logger
				.info("[GET - obtenerTiposAlta] : Obtener Espacios en Alta");
		Partes parte = new Partes();
		parte.setIdparte(idparte);
		parte = this.partesService.findParte(parte);

		return parte;
	}

	/**
	 * Method 'finalizarParteNoProcede'.
	 * 
	 * @param idParte
	 *            Integer
	 * @param accionParte
	 *            String
	 * @return Partes
	 */
	@RequestMapping(value = "/finalizarParteNoProcede", method = RequestMethod.POST)
	public @ResponseBody
	Partes finalizarParteNoProcede(@RequestParam Integer idParte,
			@RequestParam String observNoProcede, Model model,
			HttpServletRequest request) {

		Partes parte = new Partes();
		parte.setIdparte(idParte);
		parte.setNoProcede("1");
		parte.setObservNoProcede(observNoProcede);
		parte = this.partesService.actualizarInfoNoProcede(parte);

		parte = this.partesService.finalizarParte(idParte);
		PartesController.logger.info("[GET - FINALIZAR PARTE NO PROCEDE] "
				+ idParte);

		return parte;
	}

	@RequestMapping(value = "/maintConsultaUsuarioNormal", method = RequestMethod.GET)
	public String formConsultaPartesUsuarioNormal(Model model,
			HttpServletRequest request) {
		PartesController.logger
				.info("[GET - maintConsultaUsuarioNormal] : partes");

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) { // TODO Auto-generated catch
												// block
			e.printStackTrace();
		}

		model.addAttribute("usuario", sUIDUsuario);

		return "partesUsuarioNormal";
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridPartesUsuarioNormal", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridPartesUsuarioNormal(
			@ModelAttribute Partes filterPartes, Locale locale,
			@ModelAttribute Pagination pagination, HttpServletRequest request) {

		/*
		 * if (request.getSession(true).getAttribute("paginaPartes") != null) {
		 * pagination.setPage((Long) request.getSession(true).getAttribute(
		 * "paginaPartes")); }
		 */

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) { // TODO Auto-generated catch
												// block
			e.printStackTrace();
		}

		List<Partes> partess = this.partesService
				.obtenerPartesConsultaUsuNormalGrid(filterPartes, pagination,
						false, sUIDUsuario);

		Long recordNum = this.partesService
				.obtenerPartesConsultaUsuNormalGridCount(filterPartes, false,
						sUIDUsuario);
		PartesController.logger
				.info("[GET - jqGrid] : Obtener Partes consulta usuario normal");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		/*
		 * if (filterPartes.getFechareD() != null) { try {
		 * filterPartes.setStrFechareD(Aa20bFecha.getFechaFormateada(
		 * filterPartes.getFechareD(), locale)); } catch (Exception e) { // TODO
		 * Auto-generated catch block e.printStackTrace(); } } if
		 * (filterPartes.getFechareH() != null) { try {
		 * filterPartes.setStrFechareH(Aa20bFecha.getFechaFormateada(
		 * filterPartes.getFechareH(), locale)); } catch (Exception e) { // TODO
		 * Auto-generated catch block e.printStackTrace(); } }
		 * 
		 * request.getSession().setAttribute("FiltroPartes", filterPartes);
		 * 
		 * request.getSession(true).setAttribute("paginaPartes", null);
		 */
		return new JQGridJSONModel(pagination, recordNum, partess);
	}

}
