package com.ejie.aa20b.control;

import com.ejie.aa20b.service.ParteplanoService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.model.Parteplano;

/**
 * ParteplanoController generated by UDA, 13-ene-2015 13:00:41.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/parteplano")
public class ParteplanoController {

	private static final Logger logger = LoggerFactory
			.getLogger(ParteplanoController.class);

	@Autowired
	private ParteplanoService parteplanoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ParteplanoController.logger.info("[GET - View] : parteplano");
		return "parteplano";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idparte
	 *            Integer
	 * @return parteplano Parteplano
	 */
	@RequestMapping(value = "/{idparte}", method = RequestMethod.GET)
	public @ResponseBody
	Parteplano getById(@PathVariable Integer idparte) {
		Parteplano parteplano = new Parteplano();
		parteplano.setIdparte(idparte);
		parteplano = this.parteplanoService.find(parteplano);
		ParteplanoController.logger
				.info("[GET - findBy_PK] : Obtener Parteplano por PK");
		return parteplano;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterParteplano
	 *            Parteplano
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Parteplano> getAll(@ModelAttribute Parteplano filterParteplano) {
		ParteplanoController.logger
				.info("[GET - find_ALL] : Obtener Parteplano por filtro");
		return this.parteplanoService.findAll(filterParteplano, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @return Parteplano
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Parteplano edit(@RequestBody Parteplano parteplano) {
		Parteplano parteplanoAux = this.parteplanoService.update(parteplano);
		ParteplanoController.logger
				.info("[PUT] : Parteplano actualizado correctamente");
		return parteplanoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param parteplano
	 *            Parteplano
	 * @return Parteplano
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Parteplano add(@RequestBody Parteplano parteplano) {
		Parteplano parteplanoAux = this.parteplanoService.add(parteplano);
		ParteplanoController.logger
				.info("[POST] : Parteplano insertado correctamente");
		return parteplanoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idparte
	 *            Integer
	 * @return parteplano
	 */
	@RequestMapping(value = "/{idparte}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Parteplano remove(@PathVariable Integer idparte) {
		Parteplano parteplano = new Parteplano();
		parteplano.setIdparte(idparte);
		this.parteplanoService.remove(parteplano);
		ParteplanoController.logger
				.info("[DELETE] : Parteplano borrado correctamente");
		return parteplano;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param parteplanoIds
	 *            List
	 * @return parteplanoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> parteplanoIds) {
		List<Parteplano> parteplanoList = new ArrayList<Parteplano>();
		for (List<String> parteplanoId : parteplanoIds) {
			Iterator<String> iterator = parteplanoId.iterator();
			Parteplano parteplano = new Parteplano(); // NOPMD - Objeto nuevo en
														// la lista (parametro
														// del servicio)
			parteplano.setIdparte(ObjectConversionManager.convert(
					iterator.next(), Integer.class));
			parteplanoList.add(parteplano);
		}
		this.parteplanoService.removeMultiple(parteplanoList);
		ParteplanoController.logger
				.info("[POST - DELETE_ALL] : Parteplano borrados correctamente");
		return parteplanoIds;
	}

	@RequestMapping(value = "/mostrarPlanoParte", method = RequestMethod.GET)
	public void mostrarPlanoParte(HttpServletRequest req,
			HttpServletResponse res, Model model) throws IOException {

		// init
		byte[] dibujo = null;
		ServletOutputStream out = res.getOutputStream();
		Parteplano parteplano = new Parteplano();

		// get
		Integer idParte = Integer.parseInt(req.getParameter("idParte"));
		parteplano.setIdparte(idParte);

		ParteplanoController.logger
				.info("[GET - findBy_PK] : Mostrar Plano del parte : "
						+ idParte);

		// set
		res.setContentType("image/jpeg");

		// execute
		dibujo = this.parteplanoService.buscaDibujo(parteplano);

		// blob treatment
		int nBytes = 0;
		if (dibujo != null) {
			nBytes = dibujo.length;
			ParteplanoController.logger
					.info("[GET - BUSCA Plano] : Tamaño Plano : "
							+ dibujo.length);
			while (nBytes > 0) {
				out.write(dibujo, 0, nBytes);
				nBytes = dibujo.length - nBytes;
			}
		}

		// end
		out.flush();
		out.close();
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterParteplano
	 *            Parteplano
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Parteplano filterParteplano,
			@ModelAttribute Pagination pagination) {
		List<Parteplano> parteplanos = this.parteplanoService.findAll(
				filterParteplano, pagination);
		Long recordNum = this.parteplanoService.findAllCount(filterParteplano);
		ParteplanoController.logger.info("[GET - jqGrid] : Obtener Parteplano");
		return new JQGridJSONModel(pagination, recordNum, parteplanos);
	}

	/**
	 * 
	 * Method 'parteTienePlano'.
	 * 
	 * 
	 * idParte Integer
	 * 
	 * @return List
	 */

	@RequestMapping(value = "/parteTienePlano", method = RequestMethod.POST)
	public @ResponseBody
	Boolean parteTienePlano(Integer idParte) {

		Parteplano partePlano = new Parteplano();
		partePlano.setIdparte(idParte);

		Long recordNum = this.parteplanoService.findAllCount(partePlano);
		ParteplanoController.logger.info("[GET - parteTienePlano] : ");
		if (recordNum > 0) {
			return true;
		} else {
			return false;
		}

	}
}
