package com.ejie.aa20b.control;

import com.bea.core.repackaged.springframework.beans.propertyeditors.CustomDateEditor;
import com.bea.core.repackaged.springframework.context.i18n.LocaleContextHolder;
import com.ejie.aa20b.service.ParteejecucionService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.DateTimeManager;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.support.ByteArrayMultipartFileEditor;

import com.ejie.aa20b.model.Parteejecucion;

/**
 * ParteejecucionController generated by UDA, 22-ene-2015 12:41:38.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/parteejecucion")
public class ParteejecucionController {

	private static final Logger logger = LoggerFactory
			.getLogger(ParteejecucionController.class);

	@Autowired
	private ParteejecucionService parteejecucionService;

	@InitBinder
	protected void initBinder(HttpServletRequest request,
			ServletRequestDataBinder binder) throws ServletException {
		binder.registerCustomEditor(byte[].class,
				new ByteArrayMultipartFileEditor());
		binder.registerCustomEditor(
				Date.class,
				new CustomDateEditor(DateTimeManager
						.getDateTimeFormat(LocaleContextHolder.getLocale()),
						true));
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ParteejecucionController.logger.info("[GET - View] : parteejecucion");
		return "parteejecucion";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idpartec
	 *            Integer
	 * @return parteejecucion Parteejecucion
	 */
	@RequestMapping(value = "/{idpartec}", method = RequestMethod.GET)
	public @ResponseBody
	Parteejecucion getById(@PathVariable Integer idpartec) {
		Parteejecucion parteejecucion = new Parteejecucion();
		parteejecucion.setIdpartec(idpartec);
		parteejecucion = this.parteejecucionService.find(parteejecucion);
		ParteejecucionController.logger
				.info("[GET - findBy_PK] : Obtener Parteejecucion por PK");
		return parteejecucion;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterParteejecucion
	 *            Parteejecucion
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Parteejecucion> getAll(
			@ModelAttribute Parteejecucion filterParteejecucion) {
		ParteejecucionController.logger
				.info("[GET - find_ALL] : Obtener Parteejecucion por filtro");
		return this.parteejecucionService.findAll(filterParteejecucion, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Parteejecucion edit(@RequestBody Parteejecucion parteejecucion) {
		Parteejecucion parteejecucionAux = this.parteejecucionService
				.update(parteejecucion);
		ParteejecucionController.logger
				.info("[PUT] : Parteejecucion actualizado correctamente");
		return parteejecucionAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param parteejecucion
	 *            Parteejecucion
	 * @return Parteejecucion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Parteejecucion add(@RequestBody Parteejecucion parteejecucion) {
		Parteejecucion parteejecucionAux = this.parteejecucionService
				.add(parteejecucion);
		ParteejecucionController.logger
				.info("[POST] : Parteejecucion insertado correctamente");
		return parteejecucionAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idpartec
	 *            Integer
	 * @return parteejecucion
	 */
	@RequestMapping(value = "/{idpartec}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Parteejecucion remove(@PathVariable Integer idpartec) {
		Parteejecucion parteejecucion = new Parteejecucion();
		parteejecucion.setIdpartec(idpartec);
		this.parteejecucionService.remove(parteejecucion);
		ParteejecucionController.logger
				.info("[DELETE] : Parteejecucion borrado correctamente");
		return parteejecucion;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param parteejecucionIds
	 *            List
	 * @return parteejecucionList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> parteejecucionIds) {
		List<Parteejecucion> parteejecucionList = new ArrayList<Parteejecucion>();
		for (List<String> parteejecucionId : parteejecucionIds) {
			Iterator<String> iterator = parteejecucionId.iterator();
			Parteejecucion parteejecucion = new Parteejecucion(); // NOPMD -
																	// Objeto
																	// nuevo en
																	// la lista
																	// (parametro
																	// del
																	// servicio)
			parteejecucion.setIdpartec(ObjectConversionManager.convert(
					iterator.next(), Integer.class));
			parteejecucionList.add(parteejecucion);
		}
		this.parteejecucionService.removeMultiple(parteejecucionList);
		ParteejecucionController.logger
				.info("[POST - DELETE_ALL] : Parteejecucion borrados correctamente");
		return parteejecucionIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterParteejecucion
	 *            Parteejecucion
	 * @param pagination
	 *            Pagination
	 * @param idParTec
	 *            Integer
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute Parteejecucion filterParteejecucion,
			@ModelAttribute Pagination pagination, HttpServletRequest req) {

		Integer idParTec = null;
		if (req.getParameter("idParTec") != null
				&& !req.getParameter("idParTec").equals("")) {
			idParTec = Integer.parseInt(req.getParameter("idParTec"));
			filterParteejecucion.setIdpartec(idParTec);

		} else {
			filterParteejecucion.setIdpartec(0);
		}
		List<Parteejecucion> parteejecucions = this.parteejecucionService
				.findAll(filterParteejecucion, pagination);
		Long recordNum = this.parteejecucionService
				.findAllCount(filterParteejecucion);
		ParteejecucionController.logger
				.info("[GET - jqGrid] : Obtener Parteejecucion");
		return new JQGridJSONModel(pagination, recordNum, parteejecucions);

	}

	/**
	 * Method 'ejecucionesParte'.
	 * 
	 * @param filterParteejecucion
	 *            Parteejecucion
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "ejecucionesParte", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel ejecucionesParte(
			@ModelAttribute Parteejecucion filterParteejecucion,
			@ModelAttribute Pagination pagination) {

		List<Parteejecucion> parteejecucions = this.parteejecucionService
				.findAll(filterParteejecucion, pagination);
		Long recordNum = this.parteejecucionService
				.findAllCount(filterParteejecucion);
		ParteejecucionController.logger
				.info("[GET - jqGrid] : Obtener Parteejecucion");
		return new JQGridJSONModel(pagination, recordNum, parteejecucions);

	}

	/**
	 * Method 'modificarEjecParte'.
	 * 
	 * @param parteEjec
	 *            Parteejecucion
	 * @param accion
	 *            String
	 * @return Parteejecucion
	 */
	@RequestMapping(value = "modificarEjecParte", method = RequestMethod.POST)
	public @ResponseBody
	String modificarEjecParte(@RequestBody Parteejecucion parteEjec,
			@RequestParam String accion) {

		Parteejecucion parteejecucions = new Parteejecucion();
		if (accion.equals("NUEVO")) {
			parteejecucions = this.parteejecucionService
					.nuevaEjecucionParte(parteEjec);
			if (parteejecucions != null) {
				// Ejecucion insertada correctamente
				ParteejecucionController.logger
						.info("[PUT] : Ejecucion Nueva correctamente");
				return "OK";
			} else {
				return "NOVALIDA";
			}

		} else if (accion.equals("MODIFICAR")) {
			parteejecucions = this.parteejecucionService
					.modificarEjecucionParte(parteEjec);
			ParteejecucionController.logger
					.info("[PUT] : Ejecucion actualizado correctamente");
			if (parteejecucions != null) {
				// Ejecucion insertada correctamente
				return "OK";
			} else {
				return "NOVALIDA";
			}
		}
		return "ERROR";
	}

	@RequestMapping(value = "/recalcularTiempoParteTecnico", method = RequestMethod.POST)
	public @ResponseBody
	Boolean recalcularTiempoParteTecnico(@RequestParam Integer idParteTec,
			Model model, HttpServletRequest request) {

		Boolean tiempoActualizado;
		tiempoActualizado = this.parteejecucionService
				.recalcularTiempoParteTecnico(idParteTec);

		ParteejecucionController.logger
				.info("[GET - Actualizar TiempoReal] : ");

		return tiempoActualizado;
	}

	@RequestMapping(value = "/eliminarEjecParte", method = RequestMethod.POST)
	public @ResponseBody
	Boolean eliminarEjecParte(@RequestParam Integer idparteEjecucion,
			Model model, HttpServletRequest request) {

		Parteejecucion parteejecucions = new Parteejecucion();
		parteejecucions.setIdpareje(idparteEjecucion);
		this.parteejecucionService.remove(parteejecucions);

		ParteejecucionController.logger
				.info("[GET - Actualizar TiempoReal] : ");

		return true;
	}

	/**
	 * 
	 * Method 'parteTecnicoTieneEjecuciones'.
	 * 
	 * 
	 * puestoIntroducido String
	 * 
	 * @return List
	 */

	@RequestMapping(value = "/parteTecnicoTieneEjecuciones", method = RequestMethod.POST)
	public @ResponseBody
	String parteTecnicoTieneEjecuciones(@RequestParam Integer idParTec,
			Model model, HttpServletRequest request) {

		Parteejecucion parteejecucions = new Parteejecucion();

		ParteejecucionController.logger
				.info("[POST - parteTecnicoTieneEjecuciones] : Comprobando si el Técnico asociado a este parte tiene ejecuciones. ");

		parteejecucions.setIdpartec(idParTec);

		List<Parteejecucion> lsParEjec = this.parteejecucionService.findAll(
				parteejecucions, null);
		if (lsParEjec.size() > 0) {
			// Comprobar que todas las ejecuciones estén finalizadas. En caso
			// contrario no se podrá finalizar
			for (Parteejecucion parteEjec : lsParEjec) {
				if (parteEjec.getFefin() == null) {
					return "FALTA FEFIN";
				}
			}
			return "OK";
		} else {
			return "FALTA EJEC";
		}

	}

}
