package com.ejie.aa20b.control;

import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.ActuacionService;
import com.ejie.aa20b.service.ClaseService;
import com.ejie.aa20b.service.CodigoService;
import com.ejie.aa20b.service.EdificiosService;
import com.ejie.aa20b.service.FichaService;
import com.ejie.aa20b.service.FichatecnicoService;
import com.ejie.aa20b.service.FichatecnicosgmaoService;
import com.ejie.aa20b.service.MaquinasService;
import com.ejie.aa20b.service.GamasService;
import com.ejie.aa20b.service.PlantasService;
import com.ejie.aa20b.service.UsuariosService;
import com.ejie.aa20b.service.ZonasService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.aa20b.util.PdfPrevAnualPorEdificios;
import com.ejie.aa20b.util.PdfPrevProgAnual;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.informes.t07bGeneraPDF_RTF;
import com.ejie.aa20b.informes.listados.ActAnualEdif;
import com.ejie.aa20b.informes.listados.PlanAnual;
import com.ejie.aa20b.informes.listados.PlanAnualEdif;
import com.ejie.aa20b.informes.listados.PlanAnualGamas;
import com.ejie.aa20b.informes.listados.PlanGeneralA;
import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.ActAnual;
import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Fichatecnico;
import com.ejie.aa20b.model.Fichatecnicosgmao;
import com.ejie.aa20b.model.Gamas;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.PlanGeneral;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.PrevAnual;
import com.ejie.aa20b.model.TablaPlanificacion;
import com.ejie.aa20b.model.Usuarios;
import com.ejie.aa20b.model.Zonas;

/**
 * MaquinasController generated by UDA, 04-mar-2015 15:44:22.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/maquinas")
public class MaquinasController {

	private static final Logger logger = LoggerFactory
			.getLogger(MaquinasController.class);

	@Autowired
	private MaquinasService maquinasService;

	@Autowired
	private CodigoService codigoService;

	@Autowired
	private GamasService gamasService;

	@Autowired
	private ClaseService claseService;

	@Autowired
	private UsuarioXLNETController usuarioXLNETController;

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private UsuariosService usuariosService;

	@Autowired
	private Aa20bProcesosJMSService procesosJMSService;

	@Autowired
	private FichatecnicoService fichatecnicoService;

	@Autowired
	private FichatecnicosgmaoService fichatecnicosgmaoServices;

	@Autowired
	private FichaService fichaService;

	@Autowired
	private EdificiosService edificiosService;

	@Autowired
	private ActuacionService actuacionService;

	@Autowired
	private PlantasService plantasService;

	@Autowired
	private ZonasService zonasService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		MaquinasController.logger.info("[GET - View] : maquinas");

		// Borrar el filtro de la sesion.
		request.getSession().removeAttribute("FiltroMaquinas");

		return "maquinas";
	}

	/**
	 * Method 'maintVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintVolver", method = RequestMethod.GET)
	public String maintVolver(Model model, HttpServletRequest request) {
		MaquinasController.logger.info("[GET - View] : maquinas");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Maquinas maquinaFiltro = (Maquinas) request.getSession().getAttribute(
				"FiltroMaquinas");

		model.addAttribute("FiltroMaquina", maquinaFiltro);

		return "maquinas";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idmaquina
	 *            Long
	 * @return maquinas Maquinas
	 */
	@RequestMapping(value = "/{idmaquina}", method = RequestMethod.GET)
	public @ResponseBody
	Maquinas getById(@PathVariable Long idmaquina) {
		Maquinas maquinas = new Maquinas();
		maquinas.setIdmaquina(idmaquina);
		maquinas = this.maquinasService.find(maquinas);
		MaquinasController.logger
				.info("[GET - findBy_PK] : Obtener Maquinas por PK");
		return maquinas;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterMaquinas
	 *            Maquinas
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Maquinas> getAll(@ModelAttribute Maquinas filterMaquinas) {
		MaquinasController.logger
				.info("[GET - find_ALL] : Obtener Maquinas por filtro");
		return this.maquinasService.findAll(filterMaquinas, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @return Maquinas
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Maquinas edit(@RequestBody Maquinas maquinas) {
		Maquinas maquinasAux = this.maquinasService.update(maquinas);
		MaquinasController.logger
				.info("[PUT] : Maquinas actualizado correctamente");
		return maquinasAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @return Maquinas
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Maquinas add(@RequestBody Maquinas maquinas) {
		Maquinas maquinasAux = this.maquinasService.add(maquinas);
		MaquinasController.logger
				.info("[POST] : Maquinas insertado correctamente");
		return maquinasAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idmaquina
	 *            Long
	 * @return maquinas
	 */
	@RequestMapping(value = "/{idmaquina}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Maquinas remove(@PathVariable Long idmaquina) {
		Maquinas maquinas = new Maquinas();
		maquinas.setIdmaquina(idmaquina);
		this.maquinasService.remove(maquinas);
		MaquinasController.logger
				.info("[DELETE] : Maquinas borrado correctamente");
		return maquinas;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param maquinasIds
	 *            List
	 * @return maquinasList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> maquinasIds) {
		List<Maquinas> maquinasList = new ArrayList<Maquinas>();
		for (List<String> maquinasId : maquinasIds) {
			Iterator<String> iterator = maquinasId.iterator();
			Maquinas maquinas = new Maquinas(); // NOPMD - Objeto nuevo en la
												// lista (parametro del
												// servicio)
			maquinas.setIdmaquina(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			maquinasList.add(maquinas);
		}
		this.maquinasService.removeMultiple(maquinasList);
		MaquinasController.logger
				.info("[POST - DELETE_ALL] : Maquinas borrados correctamente");
		return maquinasIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterMaquinas
	 *            Maquinas
	 * @param pagination
	 *            Pagination
	 * @param locale
	 *            Locale
	 * @param request
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Maquinas filterMaquinas,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {
		List<Maquinas> maquinass = this.maquinasService.findAllLike(
				filterMaquinas, pagination, false);
		Long recordNum = this.maquinasService.findAllLikeCount(filterMaquinas,
				false);
		MaquinasController.logger.info("[GET - jqGrid] : Obtener Maquinas");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterMaquinas.getFeini() != null) {
			try {
				filterMaquinas.setStrFeini(Aa20bFecha.getFechaFormateada(
						filterMaquinas.getFeini(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroMaquinas", filterMaquinas);

		return new JQGridJSONModel(pagination, recordNum, maquinass);
	}

	/**
	 * Obtiene las máquinas de edificios relacionados con el usuario de XLNET.
	 * 
	 * @param filterMaquinas
	 *            Maquinas
	 * @param pagination
	 *            Pagination
	 * @param locale
	 *            Locale
	 * @param request
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridMaquinasUsuario", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridMaquinasUsuario(
			@ModelAttribute Maquinas filterMaquinas, Locale locale,
			@ModelAttribute Pagination pagination, HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		List<Maquinas> maquinass = this.maquinasService.obtenerMaquinasUsuario(
				filterMaquinas, pagination, false, sUIDUsuario);
		Long recordNum = this.maquinasService.obtenerMaquinasUsuarioCount(
				filterMaquinas, false, sUIDUsuario);
		MaquinasController.logger
				.info("[GET - jqGrid] : Obtener Maquinas Usuario");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterMaquinas.getFeini() != null) {
			try {
				filterMaquinas.setStrFeini(Aa20bFecha.getFechaFormateada(
						filterMaquinas.getFeini(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroMaquinas", filterMaquinas);

		return new JQGridJSONModel(pagination, recordNum, maquinass);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idMaquinaBusc
	 *            String
	 * @return editarMaquina String
	 */
	@RequestMapping(value = "/buscarMaquina", method = RequestMethod.POST)
	public String getById(@RequestParam String idMaquinaBusc,
			@RequestParam String ventanaOrigen, Model model,
			HttpServletRequest request) {

		MaquinasController.logger.info("[GET - findBy_PK] : Maquina");

		Maquinas maquina = new Maquinas();

		maquina = this.maquinasService.obtenerMaquina(idMaquinaBusc);

		MaquinasController.logger.info("[GET - findBy_PK] : Maquina: "
				+ maquina.toString());

		model.addAttribute("Maquina", maquina);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		if (request.getSession().getAttribute("ventanaOrigen") != null) {
			model.addAttribute("ventanaOrigen", request.getSession()
					.getAttribute("ventanaOrigen"));
		}

		PlanGeneral planGeneral = (PlanGeneral) request.getSession()
				.getAttribute("PlanGeneral");
		if (planGeneral != null) {
			model.addAttribute("PlanGeneral", planGeneral);
			// request.getSession().removeAttribute("PlanGeneral");
		}
		return "editarMaquina";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idMaquinaBusc
	 *            String
	 * @param ventanaOrigen
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return editarMaquina String
	 */
	@RequestMapping(value = "/buscarMaquinaMant", method = RequestMethod.POST)
	public String buscarMaquinaMant(@RequestParam String idMaquinaBusc,
			@RequestParam String ventanaOrigen, Model model,
			HttpServletRequest request) {

		MaquinasController.logger.info("[GET - findBy_PK] : Maquina");

		Maquinas maquina = new Maquinas();

		maquina = this.maquinasService.obtenerMaquina(idMaquinaBusc);

		MaquinasController.logger.info("[GET - findBy_PK] : Maquina: "
				+ maquina.toString());

		model.addAttribute("Maquina", maquina);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		return "editarMaquina";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idMaquinaBusc
	 *            String
	 * @return editarMaquina String
	 */
	@RequestMapping(value = "/buscarMaquinaPG", method = RequestMethod.POST)
	public String buscarMaquinaPG(@RequestParam String idMaquinaBusc,
			@RequestParam String ventanaOrigen, @RequestParam String paginaPG,
			Model model, HttpServletRequest request) {

		MaquinasController.logger.info("[GET - findBy_PK] : Maquina");

		Maquinas maquina = new Maquinas();

		maquina = this.maquinasService.obtenerMaquina(idMaquinaBusc);

		MaquinasController.logger.info("[GET - findBy_PK] : Maquina: "
				+ maquina.toString());

		model.addAttribute("Maquina", maquina);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		// Meto en sesión la página en la que se encuentra dentro de la
		// planificacion general
		request.getSession().setAttribute("paginaPG", paginaPG);

		PlanGeneral planGeneral = (PlanGeneral) request.getSession()
				.getAttribute("PlanGeneral");
		if (planGeneral != null) {
			model.addAttribute("PlanGeneral", planGeneral);
			// request.getSession().removeAttribute("PlanGeneral");
		}
		return "editarMaquina";
	}

	/**
	 * Method 'getRemoteComboActivos'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "activos/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Codigo> getRemoteComboActivos(Model model) {
		MaquinasController.logger.info("[GET - View] : getRemoteComboActivos");
		model.addAttribute("codigos", this.codigoService.findAll(null, null));
		return this.codigoService.findAll(null, null);
	}

	/**
	 * Method 'getRemoteComboGamas'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "gamas/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Gamas> getRemoteComboGamas(Model model) {
		MaquinasController.logger.info("[GET - View] : getRemoteComboGamas");
		model.addAttribute("gamas", this.gamasService.findAll(null, null));
		return this.gamasService.findAll(null, null);
	}

	/**
	 * Method 'getRemoteComboClase'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "clase/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Clase> getRemoteComboClase(Model model, HttpServletRequest request) {
		MaquinasController.logger.info("[GET - View] : getRemoteComboClase");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);

		Clase claseAux = new Clase();
		claseAux.setBaja("0");
		if (usuario.getIdClase() != null && usuario.getIdClase().intValue() > 0) {
			claseAux.setIdclase(usuario.getIdClase());
		}
		model.addAttribute("clase", this.claseService.findAll(claseAux, null));
		return this.claseService.findAll(claseAux, null);
	}

	/**
	 * Method 'getRemoteComboGamasServicio'.
	 * 
	 * @param model
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "claseGamasServicio/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Clase> getRemoteComboClaseGamasServicio(Model model, Integer idClase,
			HttpServletRequest request) {
		MaquinasController.logger
				.info("[GET - View] : getRemoteComboClaseGamasServicio");
		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Gamas gama = new Gamas();

		// Si el usuario está asociado al servicio=0 puede ver todas las gamas.
		// En caso contrario solo verá las gamas asociadas al servicio del
		// Usuario logueado.

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		if (usuario != null && usuario.getIdservicio() != null
				&& usuario.getIdservicio() != 0) {
			gama.setIdservicio(usuario.getIdservicio());
		}

		List<Clase> listaClasesGamasServicio = new ArrayList<Clase>();

		if (usuario.getIdClase() != null && usuario.getIdClase().intValue() > 0) {
			gama.setIdclase(usuario.getIdClase());
		}

		listaClasesGamasServicio = this.gamasService.findClasesGamaServicio(
				gama, null);

		model.addAttribute("clase", listaClasesGamasServicio);
		return listaClasesGamasServicio;
	}

	/**
	 * Method 'getRemoteComboGamasServicio'.
	 * 
	 * @param model
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "gamasServicio/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Gamas> getRemoteComboGamasServicio(Model model,
			HttpServletRequest request,
			@RequestParam(value = "clasec", required = false) String clase) {
		MaquinasController.logger
				.info("[GET - View] : getRemoteComboGamasServicio");
		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Gamas gama = new Gamas();

		// Si el usuario está asociado al servicio=0 puede ver todas las gamas.
		// En caso contrario solo verá las gamas asociadas al servicio del
		// Usuario logueado.

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		if (usuario != null && usuario.getIdservicio() != null
				&& usuario.getIdservicio() != 0) {
			gama.setIdservicio(usuario.getIdservicio());
		}
		gama.setBaja("0");
		if (clase != null && !clase.equals("")) {
			gama.setIdclase(Integer.valueOf(clase));
		}
		model.addAttribute("gamas", this.gamasService.findAll(gama, null));
		return this.gamasService.findAll(gama, null);
	}

	/**
	 * Method 'getRemoteComboGamasAlta'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "gamasAlta/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Gamas> getRemoteComboGamasAlta(Model model) {
		MaquinasController.logger
				.info("[GET - View] : getRemoteComboGamasAlta");
		Gamas gamas = new Gamas();
		gamas.setBaja("0");

		model.addAttribute("gamas", this.gamasService.findAll(gamas, null));
		return this.gamasService.findAll(gamas, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param maquina
	 *            Maquinas
	 * @return Maquinas
	 */
	@RequestMapping(value = "/modificarMaquina", method = RequestMethod.POST)
	public @ResponseBody
	Maquinas modificarMaquina(@RequestBody Maquinas maquina) {

		MaquinasController.logger.info("[POST] : MODIFY : Valor de Baja : "
				+ maquina.getBaja());

		/**
		 * GMAO Comprobaremos si el espacio no se encontraba de baja. Relleno
		 */
		boolean sincronizarTodasMaquinasGmao = false;
		boolean sincronizarMaquinaGmao = true;
		Maquinas maquinaBaja = this.getById(maquina.getIdmaquina());
		/***/

		if (maquina.getBaja() == null) {
			/**
			 * GMAO Si estaba de baja significa que se ha puesto de alta ahora y
			 * hay que sincronizar con Gmao
			 */
			if (maquinaBaja.getBaja() != null
					&& maquinaBaja.getBaja().equals("1")) {
				sincronizarTodasMaquinasGmao = true;
			}

			maquina.setBaja("0");
		} else {

			/**
			 * GMAO Si no estaba de baja significa que se ha puesto de baja
			 * ahora y hay que sincronizar con Gmao
			 */
			if (maquinaBaja.getBaja() == null
					|| (maquinaBaja.getBaja() != null && maquinaBaja.getBaja()
							.equals("0"))) {
				sincronizarTodasMaquinasGmao = true;
			} else {
				// Si estaba de baja y sigue de baja no actualizamos GMAO
				sincronizarMaquinaGmao = false;
			}
			/***/

			maquina.setBaja("1");
		}

		/*
		 * if (maquina.getBaja() == null) maquina.setBaja("0"); else
		 * maquina.setBaja("1");
		 */

		MaquinasController.logger.info("[PUT] : Maquina antes de modificar : "
				+ maquina.toString());
		Maquinas maquinaAux = this.maquinasService.update(maquina);
		MaquinasController.logger
				.info("[PUT] : Maquina actualizado correctamente");

		/**
		 * GMAO - Si la actualización de la máquina ha ido bien, generamos un
		 * mensaje en la cola para actualizar la entidad 'maquina' en BBDD
		 * movilgmao. Si se ha puesto de baja, se deben sincronizar todas las
		 * entidades 'maquina'
		 */
		if (sincronizarTodasMaquinasGmao) {
			Maquinas maquinaFilter = new Maquinas();
			maquinaFilter.setBaja("0");
			List<Maquinas> maquinas = this.maquinasService.findAll(
					maquinaFilter, null);

			/**
			 * GMAO Sincronizacion de todos los codigos
			 */
			String urlConfig = "";
			try {
				urlConfig = this.appConfiguration.getObject().getProperty(
						"movilgmao.path");
			} catch (Exception e) {

			}
			this.procesosJMSService.sincronizarTodosMaquinasGmao(maquinas,
					Aa20bConstantes.COLA, urlConfig, 1);

			/*
			 * this.procesosJMSService.sincronizarTodosMaquinasGmao(maquinas,
			 * Aa20bConstantes.COLA, urlConfig, 2);
			 * 
			 * this.procesosJMSService.sincronizarTodosMaquinasGmao(maquinas,
			 * Aa20bConstantes.COLA, urlConfig, 3);
			 */
		} else {

			if (sincronizarMaquinaGmao) {
				MaquinasController.logger
						.info("[JMS] notificar modificación máquina movilgmao");

				this.procesosJMSService.sincronizarMaquinaGmao(maquina);
			}

		}

		return maquinaAux;

	}

	/**
	 * Method 'nuevoMaquina'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/nuevoMaquina", method = RequestMethod.GET)
	public String nuevoMaquina(Model model) {

		MaquinasController.logger.info("[GET - View] : nuevo maquina");
		return "nuevoMaquina";
	}

	/**
	 * Method 'add'.
	 * 
	 * @param maquinas
	 *            Maquinas
	 * @return Maquinas
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.POST)
	public @ResponseBody
	Maquinas alta(@RequestBody Maquinas maquinas) {

		Date fechaHoy = new Date();
		maquinas.setFeini(fechaHoy);
		maquinas.setBaja("0");

		Maquinas maquinasAux = this.maquinasService.add(maquinas);
		MaquinasController.logger
				.info("[POST] : Maquinas insertado correctamente");

		/**
		 * GMAO Sincronizacion de todas las máquinas
		 */

		MaquinasController.logger
				.info("[JMS] notificar modificación maquina movilgmao");

		this.procesosJMSService.sincronizarMaquinaGmao(maquinas);

		return maquinasAux;
	}

	/**
	 * Method 'planGeneral'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@SuppressWarnings("rawtypes")
	@RequestMapping(value = "planGeneral", method = RequestMethod.GET)
	public String planGeneral(Model model, Locale locale,
			HttpServletRequest request) {
		MaquinasController.logger
				.info("[GET - View] : tabla Planificacion General");

		/*
		 * ArrayList laTabla = maquinasService.obtenerPlanificiacionGeneral();
		 * model.addAttribute("planGeneral", laTabla);
		 * request.getSession().setAttribute("planGeneral", laTabla);
		 */
		return "tablaPlanGeneral";
	}

	/**
	 * Method 'prevAnual'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@SuppressWarnings("rawtypes")
	@RequestMapping(value = "prevAnual", method = RequestMethod.GET)
	public String prevAnual(Model model, Locale locale,
			HttpServletRequest request) {
		MaquinasController.logger.info("[GET - View] : tabla Previsión anual");

		return "tablaPrevAnual";
	}

	/**
	 * Method 'actAnual'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@SuppressWarnings("rawtypes")
	@RequestMapping(value = "actAnual", method = RequestMethod.GET)
	public String actAnual(Model model, Locale locale,
			HttpServletRequest request) {
		MaquinasController.logger
				.info("[GET - View] : tabla Actuaciones anuales");

		return "tablaActAnual";
	}

	/**
	 * Method 'actAnualVolver'. para cuando se vuelve de otra ventana y hay que
	 * recargar con el último filtro la ventana de Planfiicación General
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@SuppressWarnings("rawtypes")
	@RequestMapping(value = "actAnualVolver", method = RequestMethod.GET)
	public String actAnualVolver(Model model, Locale locale,
			HttpServletRequest request) {
		MaquinasController.logger
				.info("[GET - View] : volver a tabla Actuaciones anuales");

		// Si tenemos en sessión los parametros del filtro de busqueda de
		// Actauciones anuales los añadimos
		ActAnual actAnual = (ActAnual) request.getSession().getAttribute(
				"ActAnual");
		if (actAnual != null) {
			model.addAttribute("ActAnual", actAnual);
			model.addAttribute("vieneDeOtraVentana", "SI");
		}

		// Si tenemos en sessión el parametro de paginacion
		String paginaPG = (String) request.getSession()
				.getAttribute("paginaPG");
		if (paginaPG != null) {
			model.addAttribute("paginaPG", paginaPG);
		}

		return "tablaActAnual";
	}

	/**
	 * Method 'planGeneralVolver'. para cuando se vuelve de otra ventana y hay
	 * que recargar con el último filtro la ventana de Planfiicación General
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@SuppressWarnings("rawtypes")
	@RequestMapping(value = "planGeneralVolver", method = RequestMethod.GET)
	public String planGeneralVolver(Model model, Locale locale,
			HttpServletRequest request) {
		MaquinasController.logger
				.info("[GET - View] : volver a tabla Planificacion General");

		// Si tenemos en sessión los parametros del filtro de busqueda de
		// Planificación General los añadimos
		PlanGeneral planGeneral = (PlanGeneral) request.getSession()
				.getAttribute("PlanGeneral");
		if (planGeneral != null) {
			model.addAttribute("PlanGeneral", planGeneral);
			model.addAttribute("vieneDeOtraVentana", "SI");
		}

		// Si tenemos en sessión el parametro de paginacion
		String paginaPG = (String) request.getSession()
				.getAttribute("paginaPG");
		if (paginaPG != null) {
			model.addAttribute("paginaPG", paginaPG);
		}

		/*
		 * ArrayList laTabla = maquinasService.obtenerPlanificiacionGeneral();
		 * model.addAttribute("planGeneral", laTabla);
		 * request.getSession().setAttribute("planGeneral", laTabla);
		 */
		return "tablaPlanGeneral";
	}

	/**
	 * Method 'genera el html de la tabla en el servidor en lugar de en el js'.
	 * 
	 * 
	 * @return List
	 */
	@SuppressWarnings("rawtypes")
	@RequestMapping(value = "obtenerPlanGeneralServ", method = RequestMethod.POST)
	public @ResponseBody
	StringBuffer obtenerPlanGeneralServ(Locale locale, Integer anioFiltro,
			String maquinaFiltro, Integer zonaFiltro, Integer plantaFiltro,
			Long gamaFiltro, Integer bajaFiltro, Long claseFiltro,
			HttpServletRequest request) {

		PlanGeneral filtroPlanGeneral = new PlanGeneral();

		if (!"".equals(anioFiltro)) {
			filtroPlanGeneral.setAnio(anioFiltro);
		}
		if (!"".equals(maquinaFiltro)) {
			filtroPlanGeneral.setMaquina(maquinaFiltro);
		}
		if (zonaFiltro != null && zonaFiltro != 0) {
			filtroPlanGeneral.setIdzona(zonaFiltro);
		}
		if (plantaFiltro != null && plantaFiltro != 0) {
			filtroPlanGeneral.setIdplanta(plantaFiltro);
		}
		if (gamaFiltro != null && gamaFiltro != 0) {
			filtroPlanGeneral.setIdgama(gamaFiltro);
		}
		if (bajaFiltro != null && bajaFiltro == 1) {
			filtroPlanGeneral.setIncluirBaja(1);
		} else {
			filtroPlanGeneral.setIncluirBaja(0);
		}
		if (claseFiltro != null && claseFiltro != 0) {
			filtroPlanGeneral.setIdclase(claseFiltro);
		}

		// Meto en sesión los parametros recibidos para poder volver de
		// otras
		// ventanas sin solicitar seleccionar filtros.
		request.getSession().setAttribute("PlanGeneral", filtroPlanGeneral);

		// Cogemos el puesto de la persona de XLNET para obtener los
		// edificios
		// que tiene marcados para ver
		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		filtroPlanGeneral.setUidper(sUIDUsuario);

		ArrayList laTabla = maquinasService
				.obtenerPlanificiacionGeneral(filtroPlanGeneral);

		StringBuffer strTabla = new StringBuffer();

		strTabla.append("<table id=mitabla class='tablaPlanGeneral'>");
		// creamos la fila mes al que corresponde la semana
		strTabla.append("<tr class='tablaPlanGeneralTD'>");
		strTabla.append("<td class='tablaPlanGeneralTD'>--</td>");
		strTabla.append("<td class='tablaPlanGeneralTD'>-</td>");
		strTabla.append("<td class='tablaPlanGeneralTD'>-</td>");

		String[] letrasMeses;
		try {
			letrasMeses = Aa20bFecha.letraMesSemana(anioFiltro);
		} catch (Exception e) {
			letrasMeses = null;
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		for (int a = 0; a < 54; a++) {
			String strMesDeSemana = letrasMeses[a];
			strTabla.append("<td class='tablaPlanGeneralTD'>" + strMesDeSemana
					+ "</td>");
		}
		strTabla.append("</tr>");

		// creamos la fila de números de semana
		strTabla.append("<tr class='tablaPlanGeneralTD'>");
		if (locale.getLanguage() != null && locale.getLanguage().equals("eu")) {
			strTabla.append("<td class='tablaPlanGeneralTD'>Makina-deskribapena</td>");
		} else {
			strTabla.append("<td class='tablaPlanGeneralTD'>Descripción de máquina</td>");
		}
		strTabla.append("<td class='tablaPlanGeneralTD'>-</td>");
		strTabla.append("<td class='tablaPlanGeneralTD'>-</td>");
		for (int a = 0; a < 54; a++) {
			String str = "";
			if (a < 10) {
				str = "0" + a;
			} else {
				str = a + "";
			}
			strTabla.append("<td class='tablaPlanGeneralTD'>" + str + "</td>");
		}
		strTabla.append("</tr>");

		// Añadimos una linea en blanco
		strTabla.append("<tr class='tablaPlanGeneralTD'>");
		strTabla.append("<td class='tablaPlanGeneralTD'>--</td>");
		strTabla.append("</tr>");

		String src = "";
		String sTituloAbriMaquina = this.appMessageSource.getMessage(
				"planGeneral.abrirMaquina", null, locale);
		String sTituloCrearPartePrev = this.appMessageSource.getMessage(
				"planGeneral.crearPartePrev", null, locale);
		String sSemana = this.appMessageSource.getMessage("planGeneral.semana",
				null, locale);

		String rutaStaticos = "";
		try {
			rutaStaticos = this.appConfiguration.getObject().getProperty(
					"statics.path");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		String idMaquinaHTML = "";
		String cMaquinaHTML = "";
		String[] arrayValor = null;
		String[] arrayTitulos = null;
		String[] arrayColorFondo = null;
		Boolean NoEsPrimero = false;

		// Se añade un registro por cada máquina
		for (int i = 0; i < laTabla.size(); i++) {
			// viene un registro por cada fecha encontrada (SIGMTO de la
			// tabla
			// MAQUINAS, fichaFeeje de la tabla FICHAS, parteFeeje de la
			// tabla
			// PARTES)
			// Solo hay que generar una linea por cada máquina.

			HashMap datosMaquina = (HashMap) laTabla.get(i);

			if (!NoEsPrimero) {
				// Inicializar array de Valor y titulos de las semanas
				arrayValor = new String[54];
				arrayTitulos = new String[54];
				arrayColorFondo = new String[54];
			}

			// Si no es el primer registro y la máquina del registro
			// anterior es
			// diferente del registro actual generamos el html
			if (NoEsPrimero
					&& !datosMaquina.get("idmaquina").toString()
							.equals(idMaquinaHTML)) {
				// Añadimos el nombre de la máquina
				strTabla.append("<tr class='tablaPlanGeneralTD'>");
				strTabla.append("<td class='tablaPlanGeneralTD'>"
						+ cMaquinaHTML + "</td>");

				// Añadimos los botónes
				src = rutaStaticos + "/aa20b/images/ver_detalle.gif";
				strTabla.append("<td title='"
						+ sTituloAbriMaquina
						+ "' class='tablaPlanGeneralTD'><img width='15' height='15' src='"
						+ src + "' onclick='btn_abrirMaquina(" + idMaquinaHTML
						+ ");' style='cursor: pointer;'></img></td>");

				src = rutaStaticos + "/aa20b/images/nuevo.gif";
				strTabla.append("<td title='"
						+ sTituloCrearPartePrev
						+ "' class='tablaPlanGeneralTD'><img width='15' height='15' src='"
						+ src + "' onclick='btn_crearPartePrev("
						+ idMaquinaHTML
						+ ");' style='cursor: pointer;'></img></td>");

				// Añadimos los valores por semana
				String sTitulo = "";
				String sValor = "";
				String sClaseTD = "";
				for (int a = 0; a < 54; a++) {
					if (datosMaquina.get("semanaActual").equals(a + "")) {
						// Si la semana es la semana actual pintamos de
						// amarillo

						if (arrayTitulos[a] == null) {
							sTitulo = sSemana + a + " -- " + cMaquinaHTML; // datosMaquina.get("cmaquina");
						} else {
							sTitulo = arrayTitulos[a];
						}
						sValor = "";
						if (arrayValor[a] != null) {
							sValor = arrayValor[a];
						}
						sClaseTD = "tablaPlanGeneralTDSAct";
					} else {
						if (arrayTitulos[a] == null) {
							sTitulo = sSemana + a + " -- " + cMaquinaHTML;// datosMaquina.get("cmaquina");
						} else {
							sTitulo = arrayTitulos[a];
						}
						sValor = "";
						if (arrayValor[a] != null) {
							sValor = arrayValor[a];
						}
						sClaseTD = "tablaPlanGeneralTD";
					}
					strTabla.append("<td " + arrayColorFondo[a] + " class='"
							+ sClaseTD + "' onclick='clickCelda()' title='"
							+ sTitulo + "' id='" + idMaquinaHTML// datosMaquina.get("idmaquina")
							+ "@" + a + "'>" + sValor + "</td>"); // id
																	// formato
																	// (Numero
																	// de
																	// máquina
																	// @
																	// semana)

				}
				strTabla.append("</tr>");
				// Inicializar array de Valor y titulos de las semanas
				arrayValor = new String[54];
				arrayTitulos = new String[54];
				arrayColorFondo = new String[54];
			}

			// Añadimos los valores por semana
			for (int a = 0; a < 54; a++) {
				String sem = "S" + a;
				String sValor = (String) datosMaquina.get(sem);
				if (sValor != "") {
					// sValor = datosMaquina.get("tabla").toString();
					// comprobamos si ya existe para esa semana una acción
					// (Mantenimiento, Ficha, Parte)
					if (arrayValor[a] == null) {
						arrayValor[a] = datosMaquina.get("tabla").toString();
						arrayTitulos[a] = sSemana + a + ", "
								+ datosMaquina.get("cmaquina") + " -- "
								+ datosMaquina.get("tabla").toString() + ": "
								+ datosMaquina.get(sem);
						if (datosMaquina.get("ejecutadoFicha") != null
								&& datosMaquina.get("ejecutadoFicha").equals(
										"1")) {
							arrayColorFondo[a] = "style='background-color: #4afd92;'"; // Amarillo
						} else if (datosMaquina.get("ejecutadoParte") != null
								&& datosMaquina.get("ejecutadoParte").equals(
										"1")) {
							arrayColorFondo[a] = "style='background-color: #737ff8;'"; // Azul
						} else {
							arrayColorFondo[a] = ""; // Nada
						}
					} else {
						// Metemos una X y el titulo añadimos la nueva fecha
						arrayValor[a] = "X";
						String valorAnterior = arrayTitulos[a];
						arrayTitulos[a] = valorAnterior + "; "
								+ datosMaquina.get("tabla").toString() + ": "
								+ datosMaquina.get(sem);
					}

				}
			}

			// Si se trata del último registro generamos el html
			// directamente
			if (i == laTabla.size() - 1) {
				// Añadimos el nombre de la máquina
				strTabla.append("<tr class='tablaPlanGeneralTD'>");
				strTabla.append("<td class='tablaPlanGeneralTD'>"
						+ datosMaquina.get("cmaquina").toString() + "</td>");

				// Añadimos los botónes
				src = rutaStaticos + "/aa20b/images/ver_detalle.gif";
				strTabla.append("<td title='"
						+ sTituloAbriMaquina
						+ "' class='tablaPlanGeneralTD'><img width='15' height='15' src='"
						+ src + "' onclick='btn_abrirMaquina("
						+ datosMaquina.get("idmaquina").toString()
						+ ");' style='cursor: pointer;'></img></td>");

				src = rutaStaticos + "/aa20b/images/nuevo.gif";
				strTabla.append("<td title='"
						+ sTituloCrearPartePrev
						+ "' class='tablaPlanGeneralTD'><img width='15' height='15' src='"
						+ src + "' onclick='btn_crearPartePrev("
						+ datosMaquina.get("idmaquina").toString()
						+ ");' style='cursor: pointer;'></img></td>");

				// Añadimos los valores por semana
				String sTitulo = "";
				String sValor = "";
				String sClaseTD = "";
				for (int a = 0; a < 54; a++) {
					if (datosMaquina.get("semanaActual").equals(a + "")) {
						// Si la semana es la semana actual pintamos de
						// amarillo

						if (arrayTitulos[a] == null) {
							sTitulo = sSemana + a + " -- "
									+ datosMaquina.get("cmaquina").toString();
						} else {
							sTitulo = arrayTitulos[a];
						}
						sValor = "";
						if (arrayValor[a] != null) {
							sValor = arrayValor[a];
						}
						sClaseTD = "tablaPlanGeneralTDSAct";
					} else {
						if (arrayTitulos[a] == null) {
							sTitulo = sSemana + a + " -- "
									+ datosMaquina.get("cmaquina");
						} else {
							sTitulo = arrayTitulos[a];
						}
						sValor = "";
						if (arrayValor[a] != null) {
							sValor = arrayValor[a];
						}
						sClaseTD = "tablaPlanGeneralTD";
					}
					strTabla.append("<td " + arrayColorFondo[a] + " class='"
							+ sClaseTD + "' onclick='clickCelda()' title='"
							+ sTitulo + "' id='"
							+ datosMaquina.get("idmaquina").toString() + "@"
							+ a + "'>" + sValor + "</td>"); // id
															// formato
															// (Numero
															// de
															// máquina
															// @
															// semana)

				}
				strTabla.append("</tr>");
				// Inicializar array de Valor y titulos de las semanas
				arrayValor = new String[54];
				arrayTitulos = new String[54];
				arrayColorFondo = new String[54];
			}
			// Recojo el id de la maquina
			idMaquinaHTML = datosMaquina.get("idmaquina").toString();
			cMaquinaHTML = datosMaquina.get("cmaquina").toString();
			NoEsPrimero = true;
		}

		strTabla.append("</table>");

		return strTabla;
	}

	/**
	 * Method 'obtenerPlanGeneral'.
	 * 
	 * 
	 * @return List
	 */
	@SuppressWarnings("rawtypes")
	@RequestMapping(value = "obtenerPlanGeneral", method = RequestMethod.POST)
	public @ResponseBody
	JQGridJSONModel obtenerPlanGeneral(Locale locale, Integer anioFiltro,
			String maquinaFiltro, Integer zonaFiltro, Integer plantaFiltro,
			Long gamaFiltro, Integer bajaFiltro, Integer territorioFiltro,
			Integer contrataFiltro, HttpServletRequest request,
			String numPagina, String estadoFiltro, Long claseFiltro) {

		PlanGeneral filtroPlanGeneral = new PlanGeneral();

		if (!"".equals(anioFiltro)) {
			filtroPlanGeneral.setAnio(anioFiltro);
		}
		if (!"".equals(maquinaFiltro)) {
			filtroPlanGeneral.setMaquina(maquinaFiltro);
		}
		if (zonaFiltro != null && zonaFiltro != 0) {
			filtroPlanGeneral.setIdzona(zonaFiltro);
		}
		if (plantaFiltro != null) {
			filtroPlanGeneral.setIdplanta(plantaFiltro);
		}
		if (gamaFiltro != null && gamaFiltro != 0) {
			filtroPlanGeneral.setIdgama(gamaFiltro);
		}
		if (territorioFiltro != null && territorioFiltro != 0) {
			filtroPlanGeneral.setIdterri(territorioFiltro);
		}
		if (bajaFiltro != null && bajaFiltro == 1) {
			filtroPlanGeneral.setIncluirBaja(1);
		} else {
			filtroPlanGeneral.setIncluirBaja(0);
		}
		if (contrataFiltro != null && contrataFiltro == 1) {
			filtroPlanGeneral.setContrata("1");
		} else if (contrataFiltro != null && contrataFiltro == 0) {
			filtroPlanGeneral.setContrata("0");
		}
		if ("R".equals(estadoFiltro)) {
			filtroPlanGeneral.setEjecutado("1");
		} else if ("P".equals(estadoFiltro)) {
			filtroPlanGeneral.setEjecutado("0");
		}
		/*
		 * if (tipoMantFiltro != null && "C".equals(tipoMantFiltro)) {
		 * filtroPlanGeneral.setTipoMant("C"); } else if (tipoMantFiltro != null
		 * && "P".equals(tipoMantFiltro)) { filtroPlanGeneral.setTipoMant("P");
		 * }
		 */
		if (claseFiltro != null && claseFiltro != 0) {
			filtroPlanGeneral.setIdclase(claseFiltro);
		}

		// Meto en sesión los parametros recibidos para poder volver de
		// otras
		// ventanas sin solicitar seleccionar filtros.
		request.getSession().setAttribute("PlanGeneral", filtroPlanGeneral);

		// Cogemos el puesto de la persona de XLNET para obtener los
		// edificios
		// que tiene marcados para ver
		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);

		filtroPlanGeneral.setUidper(sUIDUsuario);
		if (usuario != null && usuario.getIdservicio() != null) {
			filtroPlanGeneral.setIdservicio(usuario.getIdservicio());
		}

		// Primero obtener el numero total de máquinas que cumplen con el filtro
		Long countMaquinasPG = this.maquinasService
				.obtenerMaquinasPGCount(filtroPlanGeneral);

		Pagination pagination = new Pagination();
		pagination.setPage(Long.valueOf(numPagina));
		pagination.setRows(Long.valueOf(30));

		// Si no hay registros que cumplan el filtro no hacemos nada
		if (countMaquinasPG > 0) {
			// Obtener los id de las máquinas, con paginación, yque cumplen con
			// el
			// filtro
			ArrayList idMaquinas = this.maquinasService.obtenerIdMaquinasPG(
					filtroPlanGeneral, pagination);

			// Obtener los datos referidos a esos idmáquinas.
			ArrayList laTabla = this.maquinasService.obtenerPG(
					filtroPlanGeneral,
					StringUtils.join(idMaquinas.toArray(), ","));

			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(numPagina);
			data.setRecords(countMaquinasPG.intValue());
			data.setTotal(countMaquinasPG, pagination.getRows());
			data.setRows(laTabla);
			return data;
		}
		return null;

	}

	/**
	 * Method 'obtenerPrevAnual'.
	 * 
	 * 
	 * @return List
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = "obtenerPrevAnual", method = RequestMethod.POST)
	public @ResponseBody
	JQGridJSONModel obtenerPrevAnual(Locale locale, Integer anioFiltro,
			String maquinaFiltro, Integer zonaFiltro, Integer plantaFiltro,
			Long gamaFiltro, Integer bajaFiltro, Integer territorioFiltro,
			Integer contrataFiltro, HttpServletRequest request,
			String numPagina, String estadoFiltro, Long claseFiltro) {

		PrevAnual filtroPrevAnual = new PrevAnual();

		if (!"".equals(anioFiltro)) {
			filtroPrevAnual.setAnio(anioFiltro);
		}
		if (!"".equals(maquinaFiltro)) {
			filtroPrevAnual.setMaquina(maquinaFiltro);
		}
		if (zonaFiltro != null && zonaFiltro != 0) {
			filtroPrevAnual.setIdzona(zonaFiltro);
		}
		if (plantaFiltro != null && plantaFiltro != 0) {
			filtroPrevAnual.setIdplanta(plantaFiltro);
		}
		if (gamaFiltro != null && gamaFiltro != 0) {
			filtroPrevAnual.setIdgama(gamaFiltro);
		}
		if (territorioFiltro != null && territorioFiltro != 0) {
			filtroPrevAnual.setIdterri(territorioFiltro);
		}
		if (bajaFiltro != null && bajaFiltro == 1) {
			filtroPrevAnual.setIncluirBaja(1);
		} else {
			filtroPrevAnual.setIncluirBaja(0);
		}
		if (contrataFiltro != null && contrataFiltro == 1) {
			filtroPrevAnual.setContrata("1");
		} else if (contrataFiltro != null && contrataFiltro == 0) {
			filtroPrevAnual.setContrata("0");
		}

		if ("R".equals(estadoFiltro)) {
			filtroPrevAnual.setEjecutado("1");
		} else if ("P".equals(estadoFiltro)) {
			filtroPrevAnual.setEjecutado("0");
		}

		if (claseFiltro != null && claseFiltro != 0) {
			filtroPrevAnual.setIdclase(claseFiltro);
		}

		// Meto en sesión los parametros recibidos para poder volver de
		// otras
		// ventanas sin solicitar seleccionar filtros.
		request.getSession().setAttribute("PrevAnual", filtroPrevAnual);

		// Cogemos el puesto de la persona de XLNET para obtener los
		// edificios
		// que tiene marcados para ver
		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);

		filtroPrevAnual.setUidper(sUIDUsuario);
		if (usuario != null && usuario.getIdservicio() != null) {
			filtroPrevAnual.setIdservicio(usuario.getIdservicio());
		}

		// Primero obtener el numero total de máquinas que cumplen con el filtro
		Long countMaquinasPA = this.maquinasService
				.obtenerMaquinasPACount(filtroPrevAnual);

		Pagination pagination = new Pagination();
		pagination.setPage(Long.valueOf(numPagina));
		pagination.setRows(Long.valueOf(30));

		// Si no hay registros que cumplan el filtro no hacemos nada
		if (countMaquinasPA > 0) {
			// Obtener los id de las máquinas, con paginación, y que cumplen con
			// el filtro
			ArrayList idMaquinas = this.maquinasService.obtenerIdMaquinasPA(
					filtroPrevAnual, pagination);

			ArrayList tablaGenerada = this.generarTablaPA(filtroPrevAnual,
					idMaquinas);

			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(numPagina);
			data.setRecords(countMaquinasPA.intValue());
			data.setTotal(countMaquinasPA, pagination.getRows());
			data.setRows(tablaGenerada);
			return data;
		}
		return null;

	}

	/**
	 * Method 'obtenerActAnual'.
	 * 
	 * 
	 * @return List
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = "obtenerActAnual", method = RequestMethod.POST)
	public @ResponseBody
	JQGridJSONModel obtenerActAnual(Locale locale, Integer anioFiltro,
			String maquinaFiltro, Integer zonaFiltro, Integer plantaFiltro,
			Long gamaFiltro, Integer bajaFiltro, Integer territorioFiltro,
			Integer contrataFiltro, HttpServletRequest request,
			String numPagina, String estadoFiltro, Integer idFichaFiltro,
			Long claseFiltro) {

		ActAnual filtroActAnual = new ActAnual();

		if (!"".equals(anioFiltro)) {
			filtroActAnual.setAnio(anioFiltro);
		}
		if (!"".equals(maquinaFiltro)) {
			filtroActAnual.setMaquina(maquinaFiltro);
		}
		if (zonaFiltro != null) {
			filtroActAnual.setIdzona(zonaFiltro);
		}
		if (plantaFiltro != null) {
			filtroActAnual.setIdplanta(plantaFiltro);
		}
		if (gamaFiltro != null && gamaFiltro != 0) {
			filtroActAnual.setIdgama(gamaFiltro);
		}
		if (territorioFiltro != null && territorioFiltro != 0) {
			filtroActAnual.setIdterri(territorioFiltro);
		}
		if (bajaFiltro != null && bajaFiltro == 1) {
			filtroActAnual.setIncluirBaja(1);
		} else {
			filtroActAnual.setIncluirBaja(0);
		}
		if (contrataFiltro != null && contrataFiltro == 1) {
			filtroActAnual.setContrata("1");
		} else if (contrataFiltro != null && contrataFiltro == 0) {
			filtroActAnual.setContrata("0");
		}
		if (idFichaFiltro != null && idFichaFiltro != 0) {
			filtroActAnual.setIdficha(idFichaFiltro);
		}

		if ("R".equals(estadoFiltro)) {
			filtroActAnual.setEjecutado("1");
		} else if ("P".equals(estadoFiltro)) {
			filtroActAnual.setEjecutado("0");
		}

		if (claseFiltro != null && claseFiltro != 0) {
			filtroActAnual.setIdclase(claseFiltro);
		}

		// Meto en sesión los parametros recibidos para poder volver de
		// otras
		// ventanas sin solicitar seleccionar filtros.
		request.getSession().setAttribute("ActAnual", filtroActAnual);

		// Cogemos el puesto de la persona de XLNET para obtener los
		// edificios
		// que tiene marcados para ver
		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);

		filtroActAnual.setUidper(sUIDUsuario);
		if (usuario != null && usuario.getIdservicio() != null) {
			filtroActAnual.setIdservicio(usuario.getIdservicio());
		}

		// Primero obtener el numero total de máquinas que cumplen con el filtro
		Long countMaquinasAA = this.maquinasService
				.obtenerMaquinasAACount(filtroActAnual);

		Pagination pagination = new Pagination();
		pagination.setPage(Long.valueOf(numPagina));
		pagination.setRows(Long.valueOf(30));

		// Si no hay registros que cumplan el filtro no hacemos nada
		if (countMaquinasAA > 0) {
			// Obtener los id de las máquinas, con paginación, y que cumplen con
			// el filtro
			ArrayList idMaquinas = this.maquinasService.obtenerIdMaquinasAA(
					filtroActAnual, pagination);

			// ArrayList tablaGenerada = this.generarTablaAA(filtroActAnual,
			// idMaquinas);

			ArrayList tablaGenerada = this.maquinasService
					.obtenerAA(filtroActAnual,
							StringUtils.join(idMaquinas.toArray(), ","));

			JQGridJSONModel data = new JQGridJSONModel();
			data.setPage(numPagina);
			data.setRecords(countMaquinasAA.intValue());
			data.setTotal(countMaquinasAA, pagination.getRows());
			data.setRows(tablaGenerada);
			return data;
		}
		return null;

	}

	/**
	 * Method 'generarTablaPAImprimir'.
	 * 
	 * 
	 * @return List
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	ArrayList generarTablaPAImprimir(PrevAnual filtroPrevAnual) {

		/*
		 * 
		 * con el dato de semanas de cada cuestionario asociado a la máquina
		 * calcular las fechas de los proximos mantenimientos sumando
		 * sucesivamente las semanas a la fecha del último mantenimiento. de las
		 * fechas de mantenimientos solo cogemos las que correspondan al año del
		 * filtro.
		 */

		ArrayList laTabla = this.maquinasService
				.obtenerPAImprimir(filtroPrevAnual);
		// ahora hay que recorrer todo el array. Si el dato se refiere a una
		// previsión (P) hay que añadir la planificación para lo que queda
		// de año
		ArrayList tablaCompleta = new ArrayList();
		Calendar fechaAccion = Calendar.getInstance(Locale.GERMAN);
		Calendar c = Calendar.getInstance(Locale.GERMAN);
		SimpleDateFormat sdf;
		Calendar fechaInicio = new GregorianCalendar();
		Calendar fechaFin = new GregorianCalendar();

		Calendar calendar = Calendar.getInstance(Locale.GERMAN);
		calendar.setFirstDayOfWeek(Calendar.MONDAY);
		calendar.setMinimalDaysInFirstWeek(4);
		calendar.setTime(calendar.getTime());

		sdf = new SimpleDateFormat("yyyy/MM/dd");
		String sFecInicio = calendar.get(Calendar.YEAR) + "/01/01";
		Date unoDeEnero = null;
		try {
			unoDeEnero = sdf.parse(sFecInicio);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		String idioma = LocaleContextHolder.getLocale().getLanguage();
		String idMaquinaControl = "";
		Boolean idMaquinaAgregado = false;
		HashMap datosMaquinaOrigen = new HashMap();
		for (int a = 0; a < laTabla.size(); a++) {
			HashMap datosMaquina = (HashMap) laTabla.get(a);
			if (!idMaquinaControl.equals("")
					&& !datosMaquina.get("idmaquina").toString()
							.equals(idMaquinaControl)) {
				// es otra máquina. Comprobar si se ha agregado dicha
				// máquina al array que se devuelve (tablaCompleta)
				if (!idMaquinaAgregado) {
					// agregar maquina
					tablaCompleta.add(datosMaquinaOrigen);
				}
				idMaquinaAgregado = false;
			}
			datosMaquinaOrigen = (HashMap) datosMaquina.clone();

			// if (datosMaquina.get("idmaquina").equals("1690")) {
			// MaquinasController.logger.info("[Post] : semanas: ");
			// }
			if (datosMaquina.get("tabla").equals("P")) {
				// tiene cuestionarios. Hay que crear un registro para cada
				// intervalo de semanas
				if (datosMaquina.get("SEMANAS") != null) {
					Integer semanasCuestionario = Integer
							.parseInt((String) datosMaquina.get("SEMANAS"));
					if (semanasCuestionario > 0) {
						boolean anioDelFiltro = false;
						// las previsiones empiezan desde la última fecha de
						// mantenimiento

						Date fechaInicioPrev = (Date) datosMaquina
								.get("SIGMTO");
						Date fechaPrev = fechaInicioPrev;
						// se añadiran una nueva planificacion cada
						// semanasCuestionario
						// P.ejemplo si si son 4 semanas. Habrá una
						// planificacion cada cuatro semanas hasta fin de
						// año
						while (!anioDelFiltro) {
							// Clono el hashMap de datos maquina para
							// actualizar algun valor y luego agregarlo a la
							// tabla
							HashMap datosMaquinaCopia = (HashMap) datosMaquina
									.clone();

							String fechaEjec = " ";
							String fechaString = "";
							Integer diaSemana;
							// int nDifDias = 0;
							int semanaDelAnio = 99; // Pongo 99 para que no
													// salga en la tabla
							fechaAccion.setTime(fechaPrev);
							if (filtroPrevAnual.getAnio() >= fechaAccion
									.get(Calendar.YEAR)) {
								// La fecha prevista conicide con el año del
								// filtro.Se pinta.

								// 1º Obtener la semana a la que corresponde
								// esa fecha
								sdf = new SimpleDateFormat("yyyy/MM/dd");
								sFecInicio = fechaAccion.get(Calendar.YEAR)
										+ "/01/01";
								fechaInicio.setTime(unoDeEnero);
								fechaFin.setTime(fechaAccion.getTime());
								c.setTimeInMillis(fechaFin.getTime().getTime()
										- fechaInicio.getTime().getTime());
								// nDifDias = c.get(Calendar.DAY_OF_YEAR);
								// semanaDelAnio = nDifDias / 7;
								semanaDelAnio = fechaAccion
										.get(Calendar.WEEK_OF_YEAR);

								fechaString = Aa20bFecha.getFecha(fechaAccion
										.getTime());
								diaSemana = fechaAccion
										.get(Calendar.DAY_OF_WEEK);

								if (idioma
										.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
									fechaEjec = Aa20bFecha
											.convertirFechaCompletaEu(
													fechaString, diaSemana);

								} else {
									fechaEjec = Aa20bFecha
											.convertirFechaCompleta(
													fechaString, diaSemana);
								}

								for (int i = 0; i < 54; i++) {
									datosMaquinaCopia
											.put("S" + i,
													semanaDelAnio == i ? fechaEjec
															: "");
								}
								// Si la fecha prevista conicide con el año del
								// filtro.Se pinta.
								if (filtroPrevAnual.getAnio() == fechaAccion
										.get(Calendar.YEAR)) {
									tablaCompleta.add(datosMaquinaCopia);
									idMaquinaAgregado = true;
								}

								fechaPrev = Aa20bFecha.addSemanas(
										fechaAccion.getTime(),
										semanasCuestionario);

							} else {
								anioDelFiltro = true;
							}
						}
					}
				}
			} else {
				tablaCompleta.add(datosMaquina);
				idMaquinaAgregado = true;
			}
			idMaquinaControl = datosMaquina.get("idmaquina").toString();
		}
		// MaquinasController.logger.info("[Post] : Registros: "
		// + tablaCompleta.toString());

		return tablaCompleta;
	}

	/**
	 * Method 'generarTablaPA'.
	 * 
	 * 
	 * @return List
	 */
	@SuppressWarnings({ "unchecked", "rawtypes" })
	ArrayList generarTablaPA(PrevAnual filtroPrevAnual, ArrayList idMaquinas) {

		/*
		 * 
		 * con el dato de semanas de cada cuestionario asociado a la máquina
		 * calcular las fechas de los proximos mantenimientos sumando
		 * sucesivamente las semanas a la fecha del último mantenimiento. de las
		 * fechas de mantenimientos solo cogemos las que correspondan al año del
		 * filtro.
		 */

		// Obtener los datos referidos a esos idmáquinas.
		ArrayList laTabla = this.maquinasService.obtenerPA(filtroPrevAnual,
				StringUtils.join(idMaquinas.toArray(), ","));
		// ahora hay que recorrer todo el array. Si el dato se refiere a una
		// previsión (P) hay que añadir la planificación para lo que queda
		// de año
		ArrayList tablaCompleta = new ArrayList();
		Calendar fechaAccion = Calendar.getInstance(Locale.GERMAN);
		Calendar c = Calendar.getInstance(Locale.GERMAN);
		SimpleDateFormat sdf;
		Calendar fechaInicio = new GregorianCalendar();
		Calendar fechaFin = new GregorianCalendar();

		Calendar calendar = Calendar.getInstance(Locale.GERMAN);
		calendar.setFirstDayOfWeek(Calendar.MONDAY);
		calendar.setMinimalDaysInFirstWeek(4);
		calendar.setTime(calendar.getTime());

		sdf = new SimpleDateFormat("yyyy/MM/dd");
		String sFecInicio = calendar.get(Calendar.YEAR) + "/01/01";
		Date unoDeEnero = null;
		try {
			unoDeEnero = sdf.parse(sFecInicio);
		} catch (ParseException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		String idioma = LocaleContextHolder.getLocale().getLanguage();
		String idMaquinaControl = "";
		Boolean idMaquinaAgregado = false;
		HashMap datosMaquinaOrigen = new HashMap();
		for (int a = 0; a < laTabla.size(); a++) {
			HashMap datosMaquina = (HashMap) laTabla.get(a);
			if (!idMaquinaControl.equals("")
					&& !datosMaquina.get("idmaquina").toString()
							.equals(idMaquinaControl)) {
				// es otra máquina. Comprobar si se ha agregado dicha
				// máquina al array que se devuelve (tablaCompleta)
				if (!idMaquinaAgregado) {
					// agregar maquina
					tablaCompleta.add(datosMaquinaOrigen);
				}
				idMaquinaAgregado = false;
			}
			datosMaquinaOrigen = (HashMap) datosMaquina.clone();

			// if (datosMaquina.get("idmaquina").equals("1690")) {
			// MaquinasController.logger.info("[Post] : semanas: ");
			// }
			if (datosMaquina.get("tabla").equals("P")) {
				// tiene cuestionarios. Hay que crear un registro para cada
				// intervalo de semanas
				if (datosMaquina.get("SEMANAS") != null) {
					Integer semanasCuestionario = Integer
							.parseInt((String) datosMaquina.get("SEMANAS"));
					if (semanasCuestionario > 0) {
						boolean anioDelFiltro = false;
						// las previsiones empiezan desde la última fecha de
						// mantenimiento

						Date fechaInicioPrev = (Date) datosMaquina
								.get("SIGMTO");

						Date fechaPrev = fechaInicioPrev;

						// se añadiran una nueva planificacion cada
						// semanasCuestionario
						// P.ejemplo si si son 4 semanas. Habrá una
						// planificacion cada cuatro semanas hasta fin de
						// año
						while (!anioDelFiltro) {
							// Clono el hashMap de datos maquina para
							// actualizar algun valor y luego agregarlo a la
							// tabla
							HashMap datosMaquinaCopia = (HashMap) datosMaquina
									.clone();

							String fechaEjec = " ";
							String fechaString = "";
							Integer diaSemana;
							// int nDifDias = 0;
							int semanaDelAnio = 99; // Pongo 99 para que no
													// salga en la tabla
							fechaAccion.setTime(fechaPrev);
							// MaquinasController.logger.info("Año fechaPrev: "
							// + fechaAccion.get(Calendar.YEAR));
							if (filtroPrevAnual.getAnio() >= fechaAccion
									.get(Calendar.YEAR)) {

								// 1º Obtener la semana a la que corresponde
								// esa fecha
								sdf = new SimpleDateFormat("yyyy/MM/dd");
								sFecInicio = fechaAccion.get(Calendar.YEAR)
										+ "/01/01";
								fechaInicio.setTime(unoDeEnero);
								fechaFin.setTime(fechaAccion.getTime());
								c.setTimeInMillis(fechaFin.getTime().getTime()
										- fechaInicio.getTime().getTime());
								// nDifDias = c.get(Calendar.DAY_OF_YEAR);
								// semanaDelAnio = nDifDias / 7;
								semanaDelAnio = fechaAccion
										.get(Calendar.WEEK_OF_YEAR);
								fechaString = Aa20bFecha.getFecha(fechaAccion
										.getTime());
								diaSemana = fechaAccion
										.get(Calendar.DAY_OF_WEEK);

								if (idioma
										.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
									fechaEjec = Aa20bFecha
											.convertirFechaCompletaEu(
													fechaString, diaSemana);

								} else {
									fechaEjec = Aa20bFecha
											.convertirFechaCompleta(
													fechaString, diaSemana);
								}

								for (int i = 0; i < 54; i++) {
									datosMaquinaCopia
											.put("S" + i,
													semanaDelAnio == i ? fechaEjec
															: "");
								}
								// Si la fecha prevista conicide con el año del
								// filtro.Se pinta.
								if (filtroPrevAnual.getAnio() == fechaAccion
										.get(Calendar.YEAR)) {
									tablaCompleta.add(datosMaquinaCopia);
									idMaquinaAgregado = true;
								}
								fechaPrev = Aa20bFecha.addSemanas(
										fechaAccion.getTime(),
										semanasCuestionario);

							} else {
								anioDelFiltro = true;
							}
						}
					}
				}
			} else {
				tablaCompleta.add(datosMaquina);
				idMaquinaAgregado = true;
			}
			idMaquinaControl = datosMaquina.get("idmaquina").toString();
		}
		// MaquinasController.logger.info("[Post] : Registros: "
		// + tablaCompleta.toString());

		return tablaCompleta;
	}

	/**
	 * Method 'imprimirProgAnual'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = "imprimirProgAnual", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirProgAnual(@ModelAttribute PrevAnual filterPrevAnual,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		if (filterPrevAnual.getIdclase() != null
				&& filterPrevAnual.getIdclase().longValue() == 0) {
			filterPrevAnual.setIdclase(null);
		}

		if ("".equals(filterPrevAnual.getMaquina())) {
			filterPrevAnual.setMaquina(null);
		}
		if ("".equals(filterPrevAnual.getEjecutado())) {
			filterPrevAnual.setEjecutado(null);
		}
		if ("".equals(filterPrevAnual.getContrata())) {
			filterPrevAnual.setContrata(null);
		}

		String idioma = locale.getLanguage();

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);

		filterPrevAnual.setUidper(sUIDUsuario);
		if (usuario != null && usuario.getIdservicio() != null) {
			filterPrevAnual.setIdservicio(usuario.getIdservicio());
		}

		ArrayList tablaGenerada = this.generarTablaPAImprimir(filterPrevAnual);

		// montarTablaPrevAnual
		ArrayList<TablaPlanificacion> tablaMontada = this
				.montarTablaPrevAnual(tablaGenerada);

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();
		PlanAnual planAnual = new PlanAnual();

		// Genera el pdf a partir de todos los datos
		if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
			try {
				generaPdfRtf.generarXML2PDF(response, planAnual
						.getFoPlanAnualXml(request, locale, tablaMontada,
								filterPrevAnual),
						Aa20bConstantes.plantillaPlanAnualeu);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		} else {
			try {
				generaPdfRtf.generarXML2PDF(response, planAnual
						.getFoPlanAnualXml(request, locale, tablaMontada,
								filterPrevAnual),
						Aa20bConstantes.plantillaPlanAnual);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}

	/**
	 * Method 'imprimirProgAnual_itext'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = "imprimirProgAnual_itext", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirProgAnual_itext(@ModelAttribute PrevAnual filterPrevAnual,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		if (filterPrevAnual.getIdclase() != null
				&& filterPrevAnual.getIdclase().longValue() == 0) {
			filterPrevAnual.setIdclase(null);
		}

		if ("".equals(filterPrevAnual.getMaquina())) {
			filterPrevAnual.setMaquina(null);
		}
		if ("".equals(filterPrevAnual.getEjecutado())) {
			filterPrevAnual.setEjecutado(null);
		}
		if ("".equals(filterPrevAnual.getContrata())) {
			filterPrevAnual.setContrata(null);
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);

		filterPrevAnual.setUidper(sUIDUsuario);
		if (usuario != null && usuario.getIdservicio() != null) {
			filterPrevAnual.setIdservicio(usuario.getIdservicio());
		}

		ArrayList tablaGenerada = this.generarTablaPAImprimir(filterPrevAnual);

		// montarTablaPrevAnual
		ArrayList<TablaPlanificacion> tablaMontada = this
				.montarTablaPrevAnual(tablaGenerada);

		// Genera el pdf a partir de todos los datos
		PdfPrevProgAnual pp = new PdfPrevProgAnual(this.appMessageSource,
				locale);
		response.setContentType("application/pdf");

		response.setHeader("Content-Disposition",
				"inline; filename=Programa_Anual.pdf");

		try {
			pp.crearListado(tablaMontada, filterPrevAnual,
					response.getOutputStream());
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'imprimirPrevAnualEdif'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = "imprimirPrevAnualEdif", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirPrevAnualEdif(@ModelAttribute PrevAnual filterPrevAnual,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		if (filterPrevAnual.getIdclase() != null
				&& filterPrevAnual.getIdclase().longValue() == 0) {
			filterPrevAnual.setIdclase(null);
		}

		if ("".equals(filterPrevAnual.getMaquina())) {
			filterPrevAnual.setMaquina(null);
		}
		if ("".equals(filterPrevAnual.getEjecutado())) {
			filterPrevAnual.setEjecutado(null);
		}
		if ("".equals(filterPrevAnual.getContrata())) {
			filterPrevAnual.setContrata(null);
		}

		String idioma = locale.getLanguage();

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		filterPrevAnual.setUidper(sUIDUsuario);
		if (usuario != null && usuario.getIdservicio() != null) {
			filterPrevAnual.setIdservicio(usuario.getIdservicio());
		}
		ArrayList tablaGenerada = this.generarTablaPAImprimir(filterPrevAnual);

		// montarTablaPrevAnual
		ArrayList<TablaPlanificacion> tablaMontada = this
				.montarTablaPrevAnualEdif(tablaGenerada);

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();
		PlanAnualEdif planAnualEdif = new PlanAnualEdif();

		// Genera el pdf a partir de todos los datos
		if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
			try {
				generaPdfRtf.generarXML2PDF(response, planAnualEdif
						.getFoPlanAnualEdifXml(request, locale, tablaMontada,
								filterPrevAnual),
						Aa20bConstantes.plantillaPlanAnualEdifeu);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		} else {
			try {
				generaPdfRtf.generarXML2PDF(response, planAnualEdif
						.getFoPlanAnualEdifXml(request, locale, tablaMontada,
								filterPrevAnual),
						Aa20bConstantes.plantillaPlanAnualEdif);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}

	/**
	 * Method 'imprimirPrevAnualEdif_itext'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = "imprimirPrevAnualEdif_itext", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirPrevAnualEdif_itext(@ModelAttribute PrevAnual filterPrevAnual,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		if (filterPrevAnual.getIdclase() != null
				&& filterPrevAnual.getIdclase().longValue() == 0) {
			filterPrevAnual.setIdclase(null);
		}
		if ("".equals(filterPrevAnual.getMaquina())) {
			filterPrevAnual.setMaquina(null);
		}
		if ("".equals(filterPrevAnual.getEjecutado())) {
			filterPrevAnual.setEjecutado(null);
		}
		if ("".equals(filterPrevAnual.getContrata())) {
			filterPrevAnual.setContrata(null);
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		filterPrevAnual.setUidper(sUIDUsuario);
		if (usuario != null && usuario.getIdservicio() != null) {
			filterPrevAnual.setIdservicio(usuario.getIdservicio());
		}
		ArrayList tablaGenerada = this.generarTablaPAImprimir(filterPrevAnual);

		// montarTablaPrevAnual
		ArrayList<TablaPlanificacion> tablaMontada = this
				.montarTablaPrevAnualEdif(tablaGenerada);

		// Genera el pdf a partir de todos los datos
		PdfPrevAnualPorEdificios pp = new PdfPrevAnualPorEdificios(
				this.appMessageSource, locale);
		response.setContentType("application/pdf");

		response.setHeader("Content-Disposition",
				"inline; filename=Previsto_por_edificios.pdf");

		try {
			pp.crearListado(tablaMontada, filterPrevAnual,
					response.getOutputStream());
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'imprimeActAnualRealEdif'.
	 * 
	 * @param filterActAnual
	 *            ActAnual
	 * @return JQGridJSONModel
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = "imprimeActAnualRealEdif", method = RequestMethod.GET)
	public @ResponseBody
	void imprimeActAnualRealEdif(@ModelAttribute ActAnual filterActAnual,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		if (filterActAnual.getIdclase() != null
				&& filterActAnual.getIdclase().longValue() == 0) {
			filterActAnual.setIdclase(null);
		}

		if ("".equals(filterActAnual.getMaquina())) {
			filterActAnual.setMaquina(null);
		}
		if ("".equals(filterActAnual.getEjecutado())) {
			filterActAnual.setEjecutado(null);
		}
		if ("".equals(filterActAnual.getContrata())) {
			filterActAnual.setContrata(null);
		}

		String idioma = locale.getLanguage();

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);

		filterActAnual.setUidper(sUIDUsuario);
		if (usuario != null && usuario.getIdservicio() != null) {
			filterActAnual.setIdservicio(usuario.getIdservicio());
		}

		ArrayList idMaquinas = this.maquinasService.obtenerIdMaquinasAA(
				filterActAnual, null);

		ArrayList tablaGenerada = this.maquinasService.obtenerAARealEdif(
				filterActAnual, StringUtils.join(idMaquinas.toArray(), ","));

		// montarTablaPrevAnual
		ArrayList<TablaPlanificacion> tablaMontada = this
				.montarTablaActAnualRealEdif(tablaGenerada);

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();
		ActAnualEdif actAnualEdif = new ActAnualEdif();

		// Genera el pdf a partir de todos los datos
		if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
			try {
				generaPdfRtf.generarXML2PDF(response, actAnualEdif
						.getFoActAnualEdifXml(request, locale, tablaMontada,
								filterActAnual),
						Aa20bConstantes.plantillaActAnualEdifeu);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		} else {
			try {
				generaPdfRtf.generarXML2PDF(response, actAnualEdif
						.getFoActAnualEdifXml(request, locale, tablaMontada,
								filterActAnual),
						Aa20bConstantes.plantillaActAnualEdif);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}

	/**
	 * Method 'imprimirPrevAnualGamas'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = "imprimirPrevAnualGamas", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirPrevAnualGamas(@ModelAttribute PrevAnual filterPrevAnual,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {
		if (filterPrevAnual.getIdclase() != null
				&& filterPrevAnual.getIdclase().longValue() == 0) {
			filterPrevAnual.setIdclase(null);
		}

		if ("".equals(filterPrevAnual.getMaquina())) {
			filterPrevAnual.setMaquina(null);
		}
		if ("".equals(filterPrevAnual.getEjecutado())) {
			filterPrevAnual.setEjecutado(null);
		}
		if ("".equals(filterPrevAnual.getContrata())) {
			filterPrevAnual.setContrata(null);
		}

		String idioma = locale.getLanguage();

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		filterPrevAnual.setUidper(sUIDUsuario);
		if (usuario != null && usuario.getIdservicio() != null) {
			filterPrevAnual.setIdservicio(usuario.getIdservicio());
		}
		ArrayList tablaGenerada = this.generarTablaPAImprimir(filterPrevAnual);

		// montarTablaPrevAnual
		ArrayList<TablaPlanificacion> tablaMontada = this
				.montarTablaPrevAnualEdif(tablaGenerada);

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();
		PlanAnualGamas planAnualGamas = new PlanAnualGamas();

		// Genera el pdf a partir de todos los datos
		if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
			try {
				generaPdfRtf.generarXML2PDF(response, planAnualGamas
						.getFoPlanAnualGamasXml(request, locale, tablaMontada,
								filterPrevAnual),
						Aa20bConstantes.plantillaPlanAnualGamaseu);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		} else {
			try {
				generaPdfRtf.generarXML2PDF(response, planAnualGamas
						.getFoPlanAnualGamasXml(request, locale, tablaMontada,
								filterPrevAnual),
						Aa20bConstantes.plantillaPlanAnualGamas);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}

	/**
	 * Method 'montarTablaPrevAnual'.
	 * 
	 * 
	 * @return List
	 */
	@SuppressWarnings({ "unchecked", "rawtypes", "null" })
	ArrayList montarTablaPrevAnual(ArrayList tablaGenerada) {
		ArrayList<TablaPlanificacion> arrayTablaPlan = new ArrayList<TablaPlanificacion>();
		Boolean NoEsPrimero = false;
		String idMaquinaHTML = "";
		String cMaquinaHTML = "";
		String codigoMaquinaHTML = "";
		String gamaHTML = "";
		String edificioHTML = "";
		String zonaHTML = "";
		String plantaHTML = "";
		String sValor = "";
		String[] arrayValor = null;

		for (int i = 0; i < tablaGenerada.size(); i++) {
			HashMap datosMaquina = (HashMap) tablaGenerada.get(i);

			// viene un registro por cada fecha encontrada (SIGMTO de la tabla
			// MAQUINAS, fichaFeeje de la tabla FICHAS, parteFeeje de la tabla
			// PARTES)
			// Solo hay que generar una linea por cada máquina.
			if (!NoEsPrimero) {
				// Inicializar array de Valor
				arrayValor = new String[54];
			}
			// Si no es el primer registro y la máquina del registro anterior es
			// diferente del registro actual añadimos la máquina al array de
			// maquinas final
			if (NoEsPrimero && datosMaquina.get("idmaquina") != null
					&& !datosMaquina.get("idmaquina").equals(idMaquinaHTML)) {
				TablaPlanificacion tablaPlanif = new TablaPlanificacion();
				String[] arraySemana;
				arraySemana = new String[54];
				for (int a = 0; a < 54; a++) {
					sValor = "";
					if (arrayValor[a] != null) {
						sValor = arrayValor[a];
					}
					arraySemana[a] = sValor;
				}
				tablaPlanif.setIdmaquina(Long.parseLong(idMaquinaHTML));
				tablaPlanif.setDescripcion(cMaquinaHTML);
				tablaPlanif.setCodigoMaq(codigoMaquinaHTML);
				tablaPlanif.setGama(gamaHTML);
				tablaPlanif.setEdificio(edificioHTML);
				tablaPlanif.setZona(zonaHTML);
				tablaPlanif.setPlanta(plantaHTML);

				tablaPlanif.setArraySemana(arraySemana);
				arrayTablaPlan.add(tablaPlanif);
				// Inicializar array de Valor de las semanas
				arrayValor = new String[54];

			}

			// Añadimos los valores por semana
			for (int a = 0; a < 54; a++) {
				String sem = "S" + a;
				sValor = datosMaquina.get(sem) != null ? datosMaquina.get(sem)
						.toString() : "";

				if (sValor != "") {
					// comprobamos si ya existe para esa semana una acción
					// (Ficha, planificacion)
					if (arrayValor[a] == null) {
						if (datosMaquina.get("fichaSituacion") != null
								&& datosMaquina.get("fichaSituacion").equals(
										"O")) {
							arrayValor[a] = "O";
						} else if (datosMaquina.get("fichaSituacion") != null
								&& datosMaquina.get("fichaSituacion").equals(
										"R")) {
							arrayValor[a] = "R";
						} else {
							arrayValor[a] = datosMaquina.get("tabla") != null ? datosMaquina
									.get("tabla").toString() : "";
						}

					} else {
						// Metemos una X y el titulo añadimos la nueva fecha
						if (datosMaquina.get("fichaSituacion") != null
								&& datosMaquina.get("fichaSituacion").equals(
										"O")) {
							arrayValor[a] = "O";
						} else if (datosMaquina.get("fichaSituacion") != null
								&& datosMaquina.get("fichaSituacion").equals(
										"R")) {
							arrayValor[a] = "R";
						} else {
							arrayValor[a] = datosMaquina.get("tabla") != null ? datosMaquina
									.get("tabla").toString() : "";
							;
						}
					}
				}
			}

			// Si se trata del último registro generamos añadimos la máquina al
			// array de maquinas final
			if (i == tablaGenerada.size() - 1) {
				// Añadimos el nombre de la máquina
				TablaPlanificacion tablaPlanif = new TablaPlanificacion();
				tablaPlanif.setIdmaquina(Long.parseLong((String) datosMaquina
						.get("idmaquina") != null ? datosMaquina.get(
						"idmaquina").toString() : "0"));
				tablaPlanif
						.setDescripcion(datosMaquina.get("cmaquina") != null ? datosMaquina
								.get("cmaquina").toString() : "");
				tablaPlanif
						.setCodigoMaq(datosMaquina.get("mcodigo") != null ? datosMaquina
								.get("mcodigo").toString() : "");
				tablaPlanif
						.setGama(datosMaquina.get("gama") != null ? datosMaquina
								.get("gama").toString() : "");
				tablaPlanif
						.setEdificio(datosMaquina.get("EDIFICIO") != null ? datosMaquina
								.get("EDIFICIO").toString() : "");
				tablaPlanif
						.setZona(datosMaquina.get("ZONA") != null ? datosMaquina
								.get("ZONA").toString() : "");
				tablaPlanif
						.setPlanta(datosMaquina.get("PLANTA") != null ? datosMaquina
								.get("PLANTA").toString() : "");

				// Añadimos los valores por semana
				sValor = "";
				String[] arraySemana;
				arraySemana = new String[54];
				for (int a = 0; a < 54; a++) {
					sValor = "";
					if (arrayValor[a] != null) {
						sValor = arrayValor[a];
					}
					arraySemana[a] = sValor;
				}
				tablaPlanif.setArraySemana(arraySemana);
				arrayTablaPlan.add(tablaPlanif);

				// Inicializar array de Valorde las semanas
				arrayValor = new String[54];
			}
			// Recojo el id de la maquina
			idMaquinaHTML = datosMaquina.get("idmaquina") != null ? datosMaquina
					.get("idmaquina").toString() : "";
			cMaquinaHTML = datosMaquina.get("cmaquina") != null ? datosMaquina
					.get("cmaquina").toString() : "";
			codigoMaquinaHTML = datosMaquina.get("mcodigo") != null ? datosMaquina
					.get("mcodigo").toString() : "-";
			gamaHTML = datosMaquina.get("gama") != null ? datosMaquina.get(
					"gama").toString() : "";
			edificioHTML = datosMaquina.get("EDIFICIO") != null ? datosMaquina
					.get("EDIFICIO").toString() : "";
			zonaHTML = datosMaquina.get("ZONA") != null ? datosMaquina.get(
					"ZONA").toString() : "";
			plantaHTML = datosMaquina.get("PLANTA") != null ? datosMaquina.get(
					"PLANTA").toString() : "";
			NoEsPrimero = true;

		}
		return arrayTablaPlan;
	}

	/**
	 * Method 'montarTablaPrevAnualEdif'.
	 * 
	 * 
	 * @return List
	 */
	@SuppressWarnings({ "rawtypes" })
	ArrayList montarTablaPrevAnualEdif(ArrayList tablaGenerada) {
		ArrayList<TablaPlanificacion> arrayTablaPlan = new ArrayList<TablaPlanificacion>();
		Boolean NoEsPrimero = false;
		String idMaquinaHTML = "";
		String cMaquinaHTML = "";
		String codigoMaquinaHTML = "";
		String gamaHTML = "";
		String edificioHTML = "";
		String zonaHTML = "";
		String plantaHTML = "";
		Integer nTiempo = 0;
		Integer[] arrayTiempos = null;

		for (int i = 0; i < tablaGenerada.size(); i++) {
			HashMap datosMaquina = (HashMap) tablaGenerada.get(i);

			// viene un registro por cada fecha encontrada (SIGMTO de la tabla
			// MAQUINAS, fichaFeeje de la tabla FICHAS, parteFeeje de la tabla
			// PARTES)
			// Solo hay que generar una linea por cada máquina.
			if (!NoEsPrimero) {
				// Inicializar array de Valor
				arrayTiempos = new Integer[54];
			}
			// Si no es el primer registro y la máquina del registro anterior es
			// diferente del registro actual añadimos la máquina al array de
			// maquinas final
			if (NoEsPrimero && datosMaquina.get("idmaquina") != null
					&& !datosMaquina.get("idmaquina").equals(idMaquinaHTML)) {
				TablaPlanificacion tablaPlanif = new TablaPlanificacion();
				String[] arraySemana;
				arraySemana = new String[54];
				for (int a = 0; a < 54; a++) {
					nTiempo = 0;
					if (arrayTiempos[a] != null) {
						nTiempo = arrayTiempos[a];
					}
					arraySemana[a] = nTiempo.toString();
				}
				tablaPlanif.setIdmaquina(Long.parseLong(idMaquinaHTML));
				tablaPlanif.setDescripcion(cMaquinaHTML);
				tablaPlanif.setCodigoMaq(codigoMaquinaHTML);
				tablaPlanif.setGama(gamaHTML);
				tablaPlanif.setEdificio(edificioHTML);
				tablaPlanif.setZona(zonaHTML);
				tablaPlanif.setPlanta(plantaHTML);

				tablaPlanif.setArraySemana(arraySemana);
				arrayTablaPlan.add(tablaPlanif);
				// Inicializar array de Valor de las semanas
				arrayTiempos = new Integer[54];

			}

			// Añadimos los valores por semana
			for (int a = 0; a < 54; a++) {
				String sem = "S" + a;
				String sValor = datosMaquina.get(sem) != null ? datosMaquina
						.get(sem).toString() : "";
				// nTiempo = (Integer) (!sValor.equals("") ? sValor : 0);

				if (!sValor.equals("")) {
					// comprobamos si ya existe tiempo para esa semana una
					if (arrayTiempos[a] == null) {
						// Recogemos el valor de tiempo de ejecucion
						arrayTiempos[a] = Integer
								.parseInt((String) (datosMaquina
										.get("TIEMPOEJ") != null ? datosMaquina
										.get("TIEMPOEJ") : "0"));
					} else {
						Integer valorAnterior = arrayTiempos[a];
						arrayTiempos[a] = valorAnterior
								+ Integer.parseInt((String) (datosMaquina
										.get("TIEMPOEJ") != null ? datosMaquina
										.get("TIEMPOEJ") : "0"));
					}
				}
			}

			// Si se trata del último registro generamos añadimos la máquina al
			// array de maquinas final
			if (i == tablaGenerada.size() - 1) {
				// Añadimos el nombre de la máquina
				TablaPlanificacion tablaPlanif = new TablaPlanificacion();
				tablaPlanif.setIdmaquina(Long.parseLong((String) datosMaquina
						.get("idmaquina") != null ? datosMaquina.get(
						"idmaquina").toString() : "0"));
				tablaPlanif
						.setDescripcion(datosMaquina.get("cmaquina") != null ? datosMaquina
								.get("cmaquina").toString() : "");
				tablaPlanif
						.setCodigoMaq(datosMaquina.get("mcodigo") != null ? datosMaquina
								.get("mcodigo").toString() : "");
				tablaPlanif
						.setGama(datosMaquina.get("gama") != null ? datosMaquina
								.get("gama").toString() : "");
				tablaPlanif
						.setEdificio(datosMaquina.get("EDIFICIO") != null ? datosMaquina
								.get("EDIFICIO").toString() : "");
				tablaPlanif
						.setZona(datosMaquina.get("ZONA") != null ? datosMaquina
								.get("ZONA").toString() : "");
				tablaPlanif
						.setPlanta(datosMaquina.get("PLANTA") != null ? datosMaquina
								.get("PLANTA").toString() : "");

				// Añadimos los valores por semana
				nTiempo = 0;
				String[] arraySemana;
				arraySemana = new String[54];
				for (int a = 0; a < 54; a++) {
					nTiempo = 0;
					if (arrayTiempos[a] != null) {
						nTiempo = arrayTiempos[a];
					}
					arraySemana[a] = nTiempo.toString();
				}
				tablaPlanif.setArraySemana(arraySemana);
				arrayTablaPlan.add(tablaPlanif);

				// Inicializar array de tiempos
				arrayTiempos = new Integer[54];
			}
			// Recojo el id de la maquina
			idMaquinaHTML = datosMaquina.get("idmaquina") != null ? datosMaquina
					.get("idmaquina").toString() : "";
			cMaquinaHTML = datosMaquina.get("cmaquina") != null ? datosMaquina
					.get("cmaquina").toString() : "";
			codigoMaquinaHTML = datosMaquina.get("mcodigo") != null ? datosMaquina
					.get("mcodigo").toString() : "-";
			gamaHTML = datosMaquina.get("gama") != null ? datosMaquina.get(
					"gama").toString() : "";
			edificioHTML = datosMaquina.get("EDIFICIO") != null ? datosMaquina
					.get("EDIFICIO").toString() : "";
			zonaHTML = datosMaquina.get("ZONA") != null ? datosMaquina.get(
					"ZONA").toString() : "";
			plantaHTML = datosMaquina.get("PLANTA") != null ? datosMaquina.get(
					"PLANTA").toString() : "";
			NoEsPrimero = true;

		}
		return arrayTablaPlan;
	}

	/**
	 * Method 'montarTablaActAnualRealEdif'.
	 * 
	 * 
	 * @return List
	 */
	@SuppressWarnings({ "rawtypes" })
	ArrayList montarTablaActAnualRealEdif(ArrayList tablaGenerada) {
		ArrayList<TablaPlanificacion> arrayTablaPlan = new ArrayList<TablaPlanificacion>();
		Boolean NoEsPrimero = false;
		String idMaquinaHTML = "";
		String cMaquinaHTML = "";
		String codigoMaquinaHTML = "";
		String gamaHTML = "";
		String edificioHTML = "";
		String zonaHTML = "";
		String plantaHTML = "";
		Integer nTiempo = 0;
		Integer[] arrayTiempos = null;

		for (int i = 0; i < tablaGenerada.size(); i++) {
			HashMap datosMaquina = (HashMap) tablaGenerada.get(i);

			// Solo hay que generar una linea por cada máquina.
			if (!NoEsPrimero) {
				// Inicializar array de Valor
				arrayTiempos = new Integer[54];
			}
			// Si no es el primer registro y la máquina del registro anterior es
			// diferente del registro actual añadimos la máquina al array de
			// maquinas final
			if (NoEsPrimero && datosMaquina.get("idmaquina") != null
					&& !datosMaquina.get("idmaquina").equals(idMaquinaHTML)) {
				TablaPlanificacion tablaPlanif = new TablaPlanificacion();
				String[] arraySemana;
				arraySemana = new String[54];
				for (int a = 0; a < 54; a++) {
					nTiempo = 0;
					if (arrayTiempos[a] != null) {
						nTiempo = arrayTiempos[a];
					}
					arraySemana[a] = nTiempo.toString();
				}
				tablaPlanif.setIdmaquina(Long.parseLong(idMaquinaHTML));
				tablaPlanif.setDescripcion(cMaquinaHTML);
				tablaPlanif.setCodigoMaq(codigoMaquinaHTML);
				tablaPlanif.setGama(gamaHTML);
				tablaPlanif.setEdificio(edificioHTML);
				tablaPlanif.setZona(zonaHTML);
				tablaPlanif.setPlanta(plantaHTML);

				tablaPlanif.setArraySemana(arraySemana);
				arrayTablaPlan.add(tablaPlanif);
				// Inicializar array de Valor de las semanas
				arrayTiempos = new Integer[54];

			}

			// Añadimos los valores por semana
			for (int a = 0; a < 54; a++) {
				String sem = "S" + a;
				String sValor = datosMaquina.get(sem) != null ? datosMaquina
						.get(sem).toString() : "";
				// nTiempo = (Integer) (!sValor.equals("") ? sValor : 0);

				if (!sValor.equals("")) {
					// comprobamos si ya existe tiempo para esa semana una
					if (arrayTiempos[a] == null) {
						// Recogemos el valor de tiempo de ejecucion
						arrayTiempos[a] = Integer.parseInt((String) sValor);
						/*
						 * arrayTiempos[a] = Integer .parseInt((String)
						 * (datosMaquina.get("MINUTOS") != null ? datosMaquina
						 * .get("MINUTOS") : "0"));
						 */
					} else {
						Integer valorAnterior = arrayTiempos[a];
						arrayTiempos[a] = valorAnterior
								+ Integer.parseInt((String) sValor);
						/*
						 * arrayTiempos[a] = valorAnterior +
						 * Integer.parseInt((String) (datosMaquina
						 * .get("MINUTOS") != null ? datosMaquina
						 * .get("MINUTOS") : "0"));
						 */
					}
				}
			}

			// Si se trata del último registro generamos añadimos la máquina al
			// array de maquinas final
			if (i == tablaGenerada.size() - 1) {
				// Añadimos el nombre de la máquina
				TablaPlanificacion tablaPlanif = new TablaPlanificacion();
				tablaPlanif.setIdmaquina(Long.parseLong((String) datosMaquina
						.get("idmaquina") != null ? datosMaquina.get(
						"idmaquina").toString() : "0"));
				tablaPlanif
						.setDescripcion(datosMaquina.get("cmaquina") != null ? datosMaquina
								.get("cmaquina").toString() : "");
				tablaPlanif
						.setCodigoMaq(datosMaquina.get("mcodigo") != null ? datosMaquina
								.get("mcodigo").toString() : "");
				tablaPlanif
						.setGama(datosMaquina.get("gama") != null ? datosMaquina
								.get("gama").toString() : "");
				tablaPlanif
						.setEdificio(datosMaquina.get("EDIFICIO") != null ? datosMaquina
								.get("EDIFICIO").toString() : "");
				tablaPlanif
						.setZona(datosMaquina.get("ZONA") != null ? datosMaquina
								.get("ZONA").toString() : "");
				tablaPlanif
						.setPlanta(datosMaquina.get("PLANTA") != null ? datosMaquina
								.get("PLANTA").toString() : "");

				// Añadimos los valores por semana
				nTiempo = 0;
				String[] arraySemana;
				arraySemana = new String[54];
				for (int a = 0; a < 54; a++) {
					nTiempo = 0;
					if (arrayTiempos[a] != null) {
						nTiempo = arrayTiempos[a];
					}
					arraySemana[a] = nTiempo.toString();
				}
				tablaPlanif.setArraySemana(arraySemana);
				arrayTablaPlan.add(tablaPlanif);

				// Inicializar array de tiempos
				arrayTiempos = new Integer[54];
			}
			// Recojo el id de la maquina
			idMaquinaHTML = datosMaquina.get("idmaquina") != null ? datosMaquina
					.get("idmaquina").toString() : "";
			cMaquinaHTML = datosMaquina.get("cmaquina") != null ? datosMaquina
					.get("cmaquina").toString() : "";
			codigoMaquinaHTML = datosMaquina.get("mcodigo") != null ? datosMaquina
					.get("mcodigo").toString() : "-";
			gamaHTML = datosMaquina.get("gama") != null ? datosMaquina.get(
					"gama").toString() : "";
			edificioHTML = datosMaquina.get("EDIFICIO") != null ? datosMaquina
					.get("EDIFICIO").toString() : "";
			zonaHTML = datosMaquina.get("ZONA") != null ? datosMaquina.get(
					"ZONA").toString() : "";
			plantaHTML = datosMaquina.get("PLANTA") != null ? datosMaquina.get(
					"PLANTA").toString() : "";
			NoEsPrimero = true;

		}
		return arrayTablaPlan;
	}

	/**
	 * Method 'crearParteAutomatico'.
	 * 
	 * @param maquina
	 *            Maquinas
	 * @return Maquinas
	 */
	@RequestMapping(value = "/crearParteAutomatico", method = RequestMethod.POST)
	public @ResponseBody
	Ficha crearParteAutomatico(HttpServletRequest request, Long idMaquina,
			String mantTec) {

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Ficha creaParte = this.maquinasService.crearParteAutomatico(idMaquina,
				sUIDUsuario, mantTec);

		MaquinasController.logger
				.info("[Post] : Crear Parte Automático. Maquina: " + idMaquina);

		/**
		 * MOVILGMAO Se comprobará la tabla de ficha tecnicos para ver si se han
		 * asignado automáticamente y así ya mandar el parte preventivo a los
		 * correspondientes
		 */
		if (creaParte != null && creaParte.getIdficha() != null) {
			Fichatecnico fichaTecnicoAux = new Fichatecnico();
			fichaTecnicoAux.setIdficha(creaParte.getIdficha());

			List<Fichatecnico> listaTecnicosFicha = this.fichatecnicoService
					.findAll(fichaTecnicoAux, null);

			if (listaTecnicosFicha.size() > 0) {
				Fichatecnicosgmao tecnicoFichaGmaoAux = new Fichatecnicosgmao();
				Fichatecnicosgmao elTecnicoFichaGmao = new Fichatecnicosgmao();
				for (Fichatecnico tecnicoFicha : listaTecnicosFicha) {

					if (tecnicoFicha != null
							&& tecnicoFicha.getIdficha() != null) {
						/**
						 * Comprobamos si ya existe una ficha (parte preventivo)
						 * en gmao para este idFicha y técnico que se hubiera
						 * quedado huérfano
						 */

						tecnicoFichaGmaoAux.setIdficha(tecnicoFicha
								.getIdficha());
						tecnicoFichaGmaoAux.setIdtecnico(tecnicoFicha
								.getIdtecnico());
						tecnicoFichaGmaoAux.setIdfichac(null);
						tecnicoFichaGmaoAux = this.fichatecnicosgmaoServices
								.find(tecnicoFichaGmaoAux);

						elTecnicoFichaGmao
								.setIdficha(tecnicoFicha.getIdficha());
						elTecnicoFichaGmao.setIdtecnico(tecnicoFicha
								.getIdtecnico());
						elTecnicoFichaGmao.setIdfichac(tecnicoFicha
								.getIdfitec());
						if (tecnicoFichaGmaoAux != null) {
							elTecnicoFichaGmao
									.setGuidfichatecgmao(tecnicoFichaGmaoAux
											.getGuidfichatecgmao());

							tecnicoFichaGmaoAux = this.fichatecnicosgmaoServices
									.update(elTecnicoFichaGmao);
						} else {
							String randomUUIDString = "";
							UUID uuid = UUID.randomUUID();
							randomUUIDString = uuid.toString();
							elTecnicoFichaGmao
									.setGuidfichatecgmao(randomUUIDString);
							tecnicoFichaGmaoAux = this.fichatecnicosgmaoServices
									.add(elTecnicoFichaGmao);
						}
						/**
						 * 
						 */
					}
				}
			} else {
				/**
				 * Si no tiene técnico, habrá que mandar el parte igualmente a
				 * movilgmao para ser gestionado desde el planner. Creamos un
				 * registro en la tabla que guarda el idficha y guidgmao sin
				 * técnico
				 */
				Fichatecnicosgmao tecnicoFichaGmaoAux = new Fichatecnicosgmao();
				tecnicoFichaGmaoAux.setIdficha(creaParte.getIdficha());
				String randomUUIDString = "";
				UUID uuid = UUID.randomUUID();
				randomUUIDString = uuid.toString();
				tecnicoFichaGmaoAux.setGuidfichatecgmao(randomUUIDString);

				tecnicoFichaGmaoAux = this.fichatecnicosgmaoServices
						.add(tecnicoFichaGmaoAux);

			}
			/**
			 * Cuando se crea el parte preventivo con los técnicos asignados
			 * automáticamente se debe mandar a MovilGmao para que lo tengan en
			 * su BBDD y le llegue al técnico o técnicos correspondientes
			 */

			Integer idFicha = creaParte.getIdficha();
			String urlConfig = "";
			try {
				urlConfig = this.appConfiguration.getObject().getProperty(
						"movilgmao.path");
			} catch (Exception e) {

			}
			Ficha fichaAux = new Ficha();
			fichaAux.setIdficha(idFicha);
			fichaAux = this.fichaService.find(fichaAux);
			if (fichaAux != null) {

				String idEdificio = null;
				Maquinas maquinaAux = new Maquinas();
				if (fichaAux.getIdmaquina() != null) {

					maquinaAux.setIdmaquina(fichaAux.getIdmaquina());
					maquinaAux = this.maquinasService.find(maquinaAux);

					if (maquinaAux != null
							&& maquinaAux.getIdedificio() != null) {
						idEdificio = maquinaAux.getIdedificio();
					}

					if (maquinaAux.getIdzona() != null) {
						Zonas zonaAux = new Zonas();
						zonaAux.setIdzona(maquinaAux.getIdzona());
						zonaAux = this.zonasService.find(zonaAux);
						maquinaAux.setZona(zonaAux);

					}

					if (maquinaAux.getIdplanta() != null) {
						Plantas plantaAux = new Plantas();
						plantaAux.setIdplanta(maquinaAux.getIdplanta());
						plantaAux = this.plantasService.find(plantaAux);
						maquinaAux.setPlanta(plantaAux);
					}
				}

				Edificios edifAux = new Edificios();
				if (idEdificio != null) {
					edifAux = this.edificiosService.obtenerEdificio(idEdificio);
				}

				// Obtener tecnicos asignados al parte preventivo
				// (fichatecnicos)
				Fichatecnicosgmao tecnicoFichaGmaoAux = new Fichatecnicosgmao();
				tecnicoFichaGmaoAux.setIdficha(idFicha);
				List<Fichatecnicosgmao> fichaTecnicosGmao = this.fichatecnicosgmaoServices
						.findAll(tecnicoFichaGmaoAux, null);

				// Obtener actuaciones asociadas al parte preventivo
				Actuacion actuacionAux = new Actuacion();
				actuacionAux.setIdficha(idFicha);
				List<Actuacion> listaActuaciones = this.actuacionService
						.obtenerActuaciones(actuacionAux, null);

				String respuesta = this.procesosJMSService
						.sincronizarPartePreventivoGmao(fichaAux, maquinaAux,
								fichaTecnicosGmao, listaActuaciones,
								edifAux.getGuidedificio(), urlConfig);

				if (respuesta != null && respuesta.equals("OK")) {
					MaquinasController.logger
							.info("[MOVILGMAO] : sincronizarPartePreventivo: "
									+ respuesta);
				} else {
					MaquinasController.logger
							.error("[MOVILGMAO] : sincronizarPartePreventivo: "
									+ respuesta);
				}

			}

			/**
			 * FIN MOVILGMAO
			 */

		}

		/***/

		return creaParte;

	}

	/**
	 * Method 'actualizarFechasMto'.
	 * 
	 * @param maquina
	 *            Maquinas
	 * @return Maquinas
	 * @throws Exception
	 */
	@RequestMapping(value = "/actualizarFechasMto", method = RequestMethod.POST)
	public @ResponseBody
	Maquinas actualizarFechasMto(HttpServletRequest request, Long numMaquina,
			Integer numSemana) throws Exception {

		Maquinas maquinas = new Maquinas();
		maquinas.setIdmaquina(numMaquina);

		Calendar fecha = new GregorianCalendar();
		int anio = fecha.get(Calendar.YEAR);

		Date fechaInicio = Aa20bFecha.getFecha("01", "01",
				Integer.toString(anio));

		Date fechaActual = Aa20bFecha.addSemanas(fechaInicio, numSemana);
		maquinas.setSigMto(fechaActual);
		maquinas.setPrimerMto(fechaActual);

		Maquinas maquinasAux = this.maquinasService
				.actualizarFechasMto(maquinas);
		MaquinasController.logger
				.info("[Post] : Actualizar fechas Maquinas. Maquina: "
						+ numMaquina);

		return maquinasAux;

	}

	/**
	 * Method 'comprobarFechaPrimerMto'. Compromar si la máquina tiene fecha de
	 * primer mantenimiento.
	 * 
	 * @param Long
	 *            idMaquina
	 * @return Maquinas
	 * @throws Exception
	 */
	@RequestMapping(value = "/comprobarFechaPrimerMto", method = RequestMethod.POST)
	public @ResponseBody
	Boolean comprobarFechaPrimerMto(HttpServletRequest request, String idMaquina) {

		MaquinasController.logger.info("[POST - comprobarFechaPrimerMto] ");

		Maquinas maquina = new Maquinas();

		maquina = this.maquinasService.obtenerMaquina(idMaquina);

		if (maquina != null && maquina.getPrimerMto() != null) {
			return true;
		} else {
			return false;
		}
	}

	/**
	 * Method 'imprimirPlanGeneralA'.
	 * 
	 * @param filterPlanGeneral
	 *            PlanGeneral
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	@RequestMapping(value = "imprimirPlanGeneralA", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirPlanGeneralA(@ModelAttribute PlanGeneral filterPlanGeneral,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		if (filterPlanGeneral.getIdclase() != null
				&& filterPlanGeneral.getIdclase().longValue() == 0) {
			filterPlanGeneral.setIdclase(null);
		}
		if ("".equals(filterPlanGeneral.getMaquina())) {
			filterPlanGeneral.setMaquina(null);
		}
		if ("".equals(filterPlanGeneral.getEjecutado())) {
			filterPlanGeneral.setEjecutado(null);
		}
		if ("".equals(filterPlanGeneral.getTipoMant())) {
			filterPlanGeneral.setTipoMant(null);
		}
		if ("".equals(filterPlanGeneral.getContrata())) {
			filterPlanGeneral.setContrata(null);
		}

		String idioma = locale.getLanguage();

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);

		filterPlanGeneral.setUidper(sUIDUsuario);
		if (usuario != null && usuario.getIdservicio() != null) {
			filterPlanGeneral.setIdservicio(usuario.getIdservicio());
		}

		// Obtener los datos referidos a esos idmáquinas.
		ArrayList laTabla = this.maquinasService
				.obtenerPGImprimir(filterPlanGeneral);

		// montarTablaPlanGeneral
		ArrayList<TablaPlanificacion> tablaMontada = this
				.montarTablaPlanGeneral(laTabla);

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();
		PlanGeneralA planGeneralA = new PlanGeneralA();

		// Genera el pdf a partir de todos los datos
		if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
			try {
				generaPdfRtf.generarXML2PDF(response, planGeneralA
						.getFoPlanGeneralAXml(request, locale, tablaMontada,
								filterPlanGeneral),
						Aa20bConstantes.plantillaPlanGeneraleu);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}

		} else {
			try {
				generaPdfRtf.generarXML2PDF(response, planGeneralA
						.getFoPlanGeneralAXml(request, locale, tablaMontada,
								filterPlanGeneral),
						Aa20bConstantes.plantillaPlanGeneral);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

	}

	/**
	 * Method 'montarTablaPlanGeneral'.
	 * 
	 * 
	 * @return List
	 */
	@SuppressWarnings({ "rawtypes" })
	ArrayList montarTablaPlanGeneral(ArrayList tablaGenerada) {
		ArrayList<TablaPlanificacion> arrayTablaPlan = new ArrayList<TablaPlanificacion>();
		Boolean NoEsPrimero = false;
		String idMaquinaHTML = "";
		String cMaquinaHTML = "";
		String codigoMaquinaHTML = "";
		String sValor = "";
		String sValorColor = "";
		String[] arrayValor = null;
		String[] arrayColor = null;

		for (int i = 0; i < tablaGenerada.size(); i++) {
			HashMap datosMaquina = (HashMap) tablaGenerada.get(i);
			// viene un registro por cada fecha encontrada:
			// M en rojo: Fecha del ultimo mantenimiento anterior al 1 de enero
			// del año filtrado.
			// M en rosa: Fecha del ultimo mantenimiento posterior al 31 de
			// diciembre del año filtrado.
			// C en azul: Parte correctivo ejecutado.
			// F en verde: Ficha ejecutada.
			// X: Incluye más de un tipo de acción.
			// Solo hay que generar una linea por cada máquina.
			if (!NoEsPrimero) {
				// Inicializar array de Valor
				arrayValor = new String[54];
				arrayColor = new String[54];
			}
			// Si no es el primer registro y la máquina del registro anterior es
			// diferente del registro actual añadimos la máquina al array de
			// maquinas final
			if (NoEsPrimero && datosMaquina.get("idmaquina") != null
					&& !datosMaquina.get("idmaquina").equals(idMaquinaHTML)) {
				TablaPlanificacion tablaPlanif = new TablaPlanificacion();
				String[] arraySemana;
				arraySemana = new String[54];
				String[] arraySemanaColor;
				arraySemanaColor = new String[54];
				for (int a = 0; a < 54; a++) {
					sValor = "";
					sValorColor = "";
					if (arrayValor[a] != null) {
						sValor = arrayValor[a];
					}
					if (arrayColor[a] != null) {
						sValorColor = arrayColor[a];
					}
					arraySemana[a] = sValor;
					arraySemanaColor[a] = sValorColor;
				}
				tablaPlanif.setIdmaquina(Long.parseLong(idMaquinaHTML));
				tablaPlanif.setDescripcion(cMaquinaHTML);
				tablaPlanif.setCodigoMaq(codigoMaquinaHTML);

				tablaPlanif.setArraySemana(arraySemana);
				tablaPlanif.setArraySemanaColor(arraySemanaColor);
				arrayTablaPlan.add(tablaPlanif);
				// Inicializar array de Valor de las semanas
				arrayValor = new String[54];
				arrayColor = new String[54];

			}

			// Añadimos los valores por semana
			for (int a = 0; a < 54; a++) {
				String sem = "S" + a;
				sValor = datosMaquina.get(sem) != null ? datosMaquina.get(sem)
						.toString() : "";

				if (sValor != "") {
					// comprobamos si ya existe para esa semana una acción
					// (Ficha, correctivo, mantenimiento)
					if (arrayValor[a] == null) {
						// Cogemos la letra
						arrayValor[a] = datosMaquina.get("tabla") != null ? datosMaquina
								.get("tabla").toString() : "";
						// Aplicamos el color
						if (datosMaquina.get("ejecutadoFicha") != null
								&& datosMaquina.get("ejecutadoFicha").equals(
										"1")) {
							arrayColor[a] = "V"; // Color verde
						} else if (datosMaquina.get("ejecutadoParte") != null
								&& datosMaquina.get("ejecutadoParte").equals(
										"1")) {
							arrayColor[a] = "A"; // Color azul
						} else if (datosMaquina.get("anioAteriorM") != null
								&& datosMaquina.get("anioAteriorM")
										.equals("SI")) {
							arrayColor[a] = "R"; // Color rojo
						} else if (datosMaquina.get("anioSiguienteM") != null
								&& datosMaquina.get("anioSiguienteM").equals(
										"SI")) {
							arrayColor[a] = "M"; // Color morado
						} else {
							arrayColor[a] = "9"; // Sin color
						}
					} else {
						// Metemos una X
						arrayValor[a] = "X";
						arrayColor[a] = "9"; // Sin color
					}
				}
			}

			// Si se trata del último registro generamos añadimos la máquina al
			// array de maquinas final
			if (i == tablaGenerada.size() - 1) {
				// Añadimos el nombre de la máquina
				TablaPlanificacion tablaPlanif = new TablaPlanificacion();
				tablaPlanif.setIdmaquina(Long.parseLong((String) datosMaquina
						.get("idmaquina") != null ? datosMaquina.get(
						"idmaquina").toString() : "0"));
				tablaPlanif
						.setDescripcion(datosMaquina.get("cmaquina") != null ? datosMaquina
								.get("cmaquina").toString() : "");
				tablaPlanif
						.setCodigoMaq(datosMaquina.get("mcodigo") != null ? datosMaquina
								.get("mcodigo").toString() : "");

				// Añadimos los valores por semana
				sValor = "";
				sValorColor = "";
				String[] arraySemana;
				String[] arraySemanaColor;
				arraySemana = new String[54];
				arraySemanaColor = new String[54];
				for (int a = 0; a < 54; a++) {
					sValor = "";
					sValorColor = "";
					if (arrayValor[a] != null) {
						sValor = arrayValor[a];
					}
					if (arrayColor[a] != null) {
						sValorColor = arrayColor[a];
					}
					arraySemana[a] = sValor;
					arraySemanaColor[a] = sValorColor;
				}
				tablaPlanif.setArraySemana(arraySemana);
				tablaPlanif.setArraySemanaColor(arraySemanaColor);
				arrayTablaPlan.add(tablaPlanif);

				// Inicializar array de Valorde las semanas
				arrayValor = new String[54];
			}
			// Recojo el id de la maquina
			idMaquinaHTML = datosMaquina.get("idmaquina") != null ? datosMaquina
					.get("idmaquina").toString() : "";
			cMaquinaHTML = datosMaquina.get("cmaquina") != null ? datosMaquina
					.get("cmaquina").toString() : "";
			codigoMaquinaHTML = datosMaquina.get("mcodigo") != null ? datosMaquina
					.get("mcodigo").toString() : "-";
			NoEsPrimero = true;

		}
		return arrayTablaPlan;
	}

}
