package com.ejie.aa20b.control;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.ldap.SecurityHelpperXLNets;
import com.ejie.aa20b.model.Usuarios;

import com.ejie.aa20b.service.Aa20bUsuarioXLNETService;
import com.ejie.aa20b.service.FichaService;
import com.ejie.aa20b.service.PartesService;
import com.ejie.aa20b.service.UsuariosService;

/**
 * PlanosController generated by UDA, 12-ene-2015 16:12:03.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/inicio")
public class InicioController {

	private static final Logger logger = LoggerFactory
			.getLogger(InicioController.class);

	@Autowired
	private PartesService partesService;

	@Autowired
	private FichaService fichaService;

	@Autowired
	private UsuarioXLNETController usuarioXLNETController;

	@Autowired
	private Aa20bUsuarioXLNETService usuarioXLNETService;

	@Autowired
	private UsuariosService usuariosService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		InicioController.logger.info("[GET - Inicio] : Inicio");

		// Eliminar cuando se abra a todos
		boolean usuarioLogueadoEsPublico = new SecurityHelpperXLNets()
				.usuarioLogueadoEsPublico();

		if (usuarioLogueadoEsPublico) {
			return "redirect:/partes/nuevo";
		}
		// FIN Eliminar cuando se abra a todos

		boolean usuarioLogueadoEsAplicacion = new SecurityHelpperXLNets()
				.usuarioLogueadoEsAplicacion();

		if (usuarioLogueadoEsAplicacion) {
			String sUIDUsuario = "";
			try {
				sUIDUsuario = this.usuarioXLNETController
						.obtenerUsuarioXLNET(request);
			} catch (SecurityHelpperException e) { // TODO Auto-generated catch
													// block
				e.printStackTrace();
			}

			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null) {
				// return "redirect:/partes/maint";
				Boolean usuarioEsAdministrador = this.usuarioXLNETService
						.esAdministrador();
				Boolean usuarioEsRespCorrectivo = this.usuarioXLNETService
						.esRespCorrectivo();
				Boolean usuarioEsTecMantenimiento = this.usuarioXLNETService
						.esTecMantenimiento();
				Boolean usuarioEsRespServicio = this.usuarioXLNETService
						.esRespServicio();
				Boolean usuarioEsRespTaller = this.usuarioXLNETService
						.esRespTaller();

				if (usuarioEsAdministrador) {
					return "redirect:/inicio/inicioAdmin";
				} else if (usuarioEsRespCorrectivo) {
					return "redirect:/inicio/inicioRespCorr";
				} else if (usuarioEsTecMantenimiento) {
					return "redirect:/inicio/inicioTecMant";
				} else if (usuarioEsRespServicio) {
					return "redirect:/inicio/inicioRespServ";
				} else if (usuarioEsRespTaller) {
					return "redirect:/inicio/inicioRespTaller";
				} else {
					return "redirect:/partes/maint";
				}
			} else {
				return "usuarioNoConfigurado";
			}
		} else {
			return "redirect:/partes/nuevo";
		}
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/menuPendientes", method = RequestMethod.GET)
	public String menuPendientes(Model model, HttpServletRequest request) {
		InicioController.logger.info("[GET - View] : abrir menu Pendientes");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		Integer idServicio = null;
		Integer idClase = null;
		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		if (!usuarioEsAdministrador) {
			if (usuario != null && usuario.getIdservicio() != null) {
				idServicio = usuario.getIdservicio();
			}

		}
		if (usuario != null && usuario.getIdClase() != null) {
			idClase = usuario.getIdClase();
		}
		String corrPendAPT = this.partesService.calculaCorrPendAPT(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigAut = this.partesService.calculaCorrAsigAut(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigMan = this.partesService.calculaCorrAsigMan(sUIDUsuario,
				idServicio, idClase).toString();

		String prevPendATC = this.fichaService.calculaPrevPendATC(sUIDUsuario,
				idServicio, idClase).toString();
		String prevAsigPendEjec = this.fichaService.calculaPrevAsigPendEjec(
				sUIDUsuario, idServicio, idClase).toString();

		model.addAttribute("corrPendAPT", corrPendAPT);
		model.addAttribute("corrAsigAut", corrAsigAut);
		model.addAttribute("corrAsigMan", corrAsigMan);
		model.addAttribute("prevPendATC", prevPendATC);
		model.addAttribute("prevAsigPendEjec", prevAsigPendEjec);

		return "menuPendientes";
	}

	/**
	 * Method 'inicioWelcome'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "inicioWelcome", method = RequestMethod.GET)
	public String inicioWelcome(Model model, HttpServletRequest request) {
		InicioController.logger.info("[GET - View] : inicioWelcome");

		return "welcome";
	}

	/**
	 * Method 'inicioAdmin'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "inicioAdmin", method = RequestMethod.GET)
	public String inicioAdmin(Model model, HttpServletRequest request) {
		InicioController.logger.info("[GET - View] : inicioAdmin");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		Integer idServicio = null;
		Integer idClase = null;
		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		if (!usuarioEsAdministrador) {
			if (usuario != null && usuario.getIdservicio() != null) {
				idServicio = usuario.getIdservicio();
			}

		}

		if (usuario != null && usuario.getIdClase() != null) {
			idClase = usuario.getIdClase();
		}

		String corrPendAPT = this.partesService.calculaCorrPendAPT(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigAut = this.partesService.calculaCorrAsigAut(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigMan = this.partesService.calculaCorrAsigMan(sUIDUsuario,
				idServicio, idClase).toString();

		String prevPendATC = this.fichaService.calculaPrevPendATC(sUIDUsuario,
				idServicio, idClase).toString();
		String prevAsigPendEjec = this.fichaService.calculaPrevAsigPendEjec(
				sUIDUsuario, idServicio, idClase).toString();

		model.addAttribute("corrPendAPT", corrPendAPT);
		model.addAttribute("corrAsigAut", corrAsigAut);
		model.addAttribute("corrAsigMan", corrAsigMan);
		model.addAttribute("prevPendATC", prevPendATC);
		model.addAttribute("prevAsigPendEjec", prevAsigPendEjec);

		return "inicioAdmin";
	}

	/**
	 * Method 'inicioAdmin'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "inicioRespCorr", method = RequestMethod.GET)
	public String inicioRespCorr(Model model, HttpServletRequest request) {
		InicioController.logger.info("[GET - View] : inicioAdmin");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		Integer idServicio = null;
		Integer idClase = null;
		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		if (!usuarioEsAdministrador) {
			if (usuario != null && usuario.getIdservicio() != null) {
				idServicio = usuario.getIdservicio();
			}

		}
		if (usuario != null && usuario.getIdClase() != null) {
			idClase = usuario.getIdClase();
		}

		String corrPendAPT = this.partesService.calculaCorrPendAPT(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigAut = this.partesService.calculaCorrAsigAut(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigMan = this.partesService.calculaCorrAsigMan(sUIDUsuario,
				idServicio, idClase).toString();

		String prevPendATC = this.fichaService.calculaPrevPendATC(sUIDUsuario,
				idServicio, idClase).toString();
		String prevAsigPendEjec = this.fichaService.calculaPrevAsigPendEjec(
				sUIDUsuario, idServicio, idClase).toString();

		model.addAttribute("corrPendAPT", corrPendAPT);
		model.addAttribute("corrAsigAut", corrAsigAut);
		model.addAttribute("corrAsigMan", corrAsigMan);
		model.addAttribute("prevPendATC", prevPendATC);
		model.addAttribute("prevAsigPendEjec", prevAsigPendEjec);

		return "inicioRespCorr";
	}

	/**
	 * Method 'inicioAdmin'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "inicioRespServ", method = RequestMethod.GET)
	public String inicioRespServ(Model model, HttpServletRequest request) {
		InicioController.logger.info("[GET - View] : inicioAdmin");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		Integer idServicio = null;
		Integer idClase = null;
		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		if (!usuarioEsAdministrador) {
			if (usuario != null && usuario.getIdservicio() != null) {
				idServicio = usuario.getIdservicio();
			}

		}
		if (usuario != null && usuario.getIdClase() != null) {
			idClase = usuario.getIdClase();
		}

		String corrPendAPT = this.partesService.calculaCorrPendAPT(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigAut = this.partesService.calculaCorrAsigAut(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigMan = this.partesService.calculaCorrAsigMan(sUIDUsuario,
				idServicio, idClase).toString();

		String prevPendATC = this.fichaService.calculaPrevPendATC(sUIDUsuario,
				idServicio, idClase).toString();
		String prevAsigPendEjec = this.fichaService.calculaPrevAsigPendEjec(
				sUIDUsuario, idServicio, idClase).toString();

		model.addAttribute("corrPendAPT", corrPendAPT);
		model.addAttribute("corrAsigAut", corrAsigAut);
		model.addAttribute("corrAsigMan", corrAsigMan);
		model.addAttribute("prevPendATC", prevPendATC);
		model.addAttribute("prevAsigPendEjec", prevAsigPendEjec);

		return "inicioRespServ";
	}

	/**
	 * Method 'inicioAdmin'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "inicioRespTaller", method = RequestMethod.GET)
	public String inicioRespTaller(Model model, HttpServletRequest request) {
		InicioController.logger.info("[GET - View] : inicioAdmin");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		Integer idServicio = null;
		Integer idClase = null;
		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		if (!usuarioEsAdministrador) {
			if (usuario != null && usuario.getIdservicio() != null) {
				idServicio = usuario.getIdservicio();
			}

		}

		if (usuario != null && usuario.getIdClase() != null) {
			idClase = usuario.getIdClase();
		}

		String corrPendAPT = this.partesService.calculaCorrPendAPT(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigAut = this.partesService.calculaCorrAsigAut(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigMan = this.partesService.calculaCorrAsigMan(sUIDUsuario,
				idServicio, idClase).toString();

		String prevPendATC = this.fichaService.calculaPrevPendATC(sUIDUsuario,
				idServicio, idClase).toString();
		String prevAsigPendEjec = this.fichaService.calculaPrevAsigPendEjec(
				sUIDUsuario, idServicio, idClase).toString();

		model.addAttribute("corrPendAPT", corrPendAPT);
		model.addAttribute("corrAsigAut", corrAsigAut);
		model.addAttribute("corrAsigMan", corrAsigMan);
		model.addAttribute("prevPendATC", prevPendATC);
		model.addAttribute("prevAsigPendEjec", prevAsigPendEjec);

		return "inicioRespTaller";
	}

	/**
	 * Method 'inicioAdmin'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "inicioTecMant", method = RequestMethod.GET)
	public String inicioTecMant(Model model, HttpServletRequest request) {
		InicioController.logger.info("[GET - View] : inicioAdmin");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		Integer idServicio = null;
		Integer idClase = null;
		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		if (!usuarioEsAdministrador) {
			if (usuario != null && usuario.getIdservicio() != null) {
				idServicio = usuario.getIdservicio();
			}

		}

		if (usuario != null && usuario.getIdClase() != null) {
			idClase = usuario.getIdClase();
		}

		String corrPendAPT = this.partesService.calculaCorrPendAPT(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigAut = this.partesService.calculaCorrAsigAut(sUIDUsuario,
				idServicio, idClase).toString();
		String corrAsigMan = this.partesService.calculaCorrAsigMan(sUIDUsuario,
				idServicio, idClase).toString();

		String prevPendATC = this.fichaService.calculaPrevPendATC(sUIDUsuario,
				idServicio, idClase).toString();
		String prevAsigPendEjec = this.fichaService.calculaPrevAsigPendEjec(
				sUIDUsuario, idServicio, idClase).toString();

		model.addAttribute("corrPendAPT", corrPendAPT);
		model.addAttribute("corrAsigAut", corrAsigAut);
		model.addAttribute("corrAsigMan", corrAsigMan);
		model.addAttribute("prevPendATC", prevPendATC);
		model.addAttribute("prevAsigPendEjec", prevAsigPendEjec);

		return "inicioTecMant";
	}

	/**
	 * Method 'ayudaInicio'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "ayudaInicio", method = RequestMethod.GET)
	public String ayudaInicio(Model model, HttpServletRequest request) {
		InicioController.logger.info("[GET - View] : ayudaInicio");
		model.addAttribute("ayudaInicio", "ayudaInicio");
		return "ayudaInicio";
	}

}
