package com.ejie.aa20b.control;

import com.ejie.aa20b.service.FichatecnicoService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa20b.model.Fichatecnico;

/**
 * FichatecnicoController generated by UDA, 07-abr-2015 11:48:11.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/fichatecnico")
public class FichatecnicoController {

	private static final Logger logger = LoggerFactory
			.getLogger(FichatecnicoController.class);

	@Autowired
	private FichatecnicoService fichatecnicoService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		FichatecnicoController.logger.info("[GET - View] : fichatecnico");
		return "fichatecnico";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idfitec
	 *            Integer
	 * @param idficha
	 *            Integer
	 * @param idtecnico
	 *            Long
	 * @param tiemporeal
	 *            Long
	 * @param finalizado
	 *            String
	 * @param observaciones
	 *            String
	 * @return fichatecnico Fichatecnico
	 */
	@RequestMapping(value = "/{idfitec}/{idficha}/{idtecnico}/{tiemporeal}/{finalizado}/{observaciones}", method = RequestMethod.GET)
	public @ResponseBody
	Fichatecnico getById(@PathVariable Integer idfitec,
			@PathVariable Integer idficha, @PathVariable Long idtecnico,
			@PathVariable Long tiemporeal, @PathVariable String finalizado,
			@PathVariable String observaciones) {
		Fichatecnico fichatecnico = new Fichatecnico();
		fichatecnico.setIdfitec(idfitec);
		fichatecnico.setIdficha(idficha);
		fichatecnico.setIdtecnico(idtecnico);
		fichatecnico.setTiemporeal(tiemporeal);
		fichatecnico.setFinalizado(finalizado);
		fichatecnico.setObservaciones(observaciones);
		fichatecnico = this.fichatecnicoService.find(fichatecnico);
		FichatecnicoController.logger
				.info("[GET - findBy_PK] : Obtener Fichatecnico por PK");
		return fichatecnico;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterFichatecnico
	 *            Fichatecnico
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Fichatecnico> getAll(@ModelAttribute Fichatecnico filterFichatecnico) {
		FichatecnicoController.logger
				.info("[GET - find_ALL] : Obtener Fichatecnico por filtro");
		return this.fichatecnicoService.findAll(filterFichatecnico, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Fichatecnico edit(@RequestBody Fichatecnico fichatecnico) {
		Fichatecnico fichatecnicoAux = this.fichatecnicoService
				.update(fichatecnico);
		FichatecnicoController.logger
				.info("[PUT] : Fichatecnico actualizado correctamente");
		return fichatecnicoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param fichatecnico
	 *            Fichatecnico
	 * @return Fichatecnico
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Fichatecnico add(@RequestBody Fichatecnico fichatecnico) {
		Fichatecnico fichatecnicoAux = this.fichatecnicoService
				.add(fichatecnico);
		FichatecnicoController.logger
				.info("[POST] : Fichatecnico insertado correctamente");
		return fichatecnicoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idfitec
	 *            Integer
	 * @param idficha
	 *            Integer
	 * @param idtecnico
	 *            Long
	 * @param tiemporeal
	 *            Long
	 * @param finalizado
	 *            String
	 * @param observaciones
	 *            String
	 * @return fichatecnico
	 */
	@RequestMapping(value = "/{idfitec}/{idficha}/{idtecnico}/{tiemporeal}/{finalizado}/{observaciones}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Fichatecnico remove(@PathVariable Integer idfitec,
			@PathVariable Integer idficha, @PathVariable Long idtecnico,
			@PathVariable Long tiemporeal, @PathVariable String finalizado,
			@PathVariable String observaciones) {
		Fichatecnico fichatecnico = new Fichatecnico();
		fichatecnico.setIdfitec(idfitec);
		fichatecnico.setIdficha(idficha);
		fichatecnico.setIdtecnico(idtecnico);
		fichatecnico.setTiemporeal(tiemporeal);
		fichatecnico.setFinalizado(finalizado);
		fichatecnico.setObservaciones(observaciones);
		this.fichatecnicoService.remove(fichatecnico);
		FichatecnicoController.logger
				.info("[DELETE] : Fichatecnico borrado correctamente");
		return fichatecnico;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param fichatecnicoIds
	 *            List
	 * @return fichatecnicoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> fichatecnicoIds) {
		List<Fichatecnico> fichatecnicoList = new ArrayList<Fichatecnico>();
		for (List<String> fichatecnicoId : fichatecnicoIds) {
			Iterator<String> iterator = fichatecnicoId.iterator();
			Fichatecnico fichatecnico = new Fichatecnico(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			fichatecnico.setIdfitec(ObjectConversionManager.convert(
					iterator.next(), Integer.class));
			fichatecnico.setIdficha(ObjectConversionManager.convert(
					iterator.next(), java.lang.Integer.class));
			fichatecnico.setIdtecnico(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			fichatecnico.setTiemporeal(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			fichatecnico.setFinalizado(ObjectConversionManager.convert(
					iterator.next(), String.class));
			fichatecnico.setObservaciones(ObjectConversionManager.convert(
					iterator.next(), String.class));
			fichatecnicoList.add(fichatecnico);
		}
		this.fichatecnicoService.removeMultiple(fichatecnicoList);
		FichatecnicoController.logger
				.info("[POST - DELETE_ALL] : Fichatecnico borrados correctamente");
		return fichatecnicoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterFichatecnico
	 *            Fichatecnico
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute Fichatecnico filterFichatecnico,
			@ModelAttribute Pagination pagination) {
		List<Fichatecnico> fichatecnicos = this.fichatecnicoService.findAll(
				filterFichatecnico, pagination);
		Long recordNum = this.fichatecnicoService
				.findAllCount(filterFichatecnico);
		FichatecnicoController.logger
				.info("[GET - jqGrid] : Obtener Fichatecnico");
		return new JQGridJSONModel(pagination, recordNum, fichatecnicos);
	}

	/**
	 * Method 'obtenerTecnicosFichaAsignadosGrid'.
	 * 
	 * @param filterTecnicos
	 *            Tecnicos
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "obtenerTecnicosFichaAsignadosGrid", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel obtenerTecnicosFichaAsignadosGrid(HttpServletRequest req,
			@ModelAttribute Fichatecnico filterFichatecnico,
			@ModelAttribute Pagination pagination) {

		Integer idFicha = Integer.parseInt(req.getParameter("idFicha"));
		filterFichatecnico.setIdficha(idFicha);
		List<Fichatecnico> tecnicoss = this.fichatecnicoService
				.tecnicosFichaGrid(filterFichatecnico, pagination);
		Long recordNum = this.fichatecnicoService
				.tecnicosFichaGridCount(filterFichatecnico);
		FichatecnicoController.logger.info("[GET - jqGrid] : Obtener Tecnicos");
		return new JQGridJSONModel(pagination, recordNum, tecnicoss);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param idFichac
	 *            Integer
	 * @param observ
	 *            String
	 * @return Partetecnicos
	 */
	@RequestMapping(value = "modificarNotasFichaTecnico", method = RequestMethod.POST)
	public @ResponseBody
	Fichatecnico modificarNotasFichaTecnico(Integer idFichac, String observ) {

		Fichatecnico fichatecnicos = new Fichatecnico();
		fichatecnicos.setIdfitec(idFichac);
		fichatecnicos.setObservaciones(observ);
		Fichatecnico fichatecnicosAux = this.fichatecnicoService
				.guardarNotas(fichatecnicos);
		FichatecnicoController.logger
				.info("[PUT] : Fichatecnicos: Observaciones actualizado correctamente");
		return fichatecnicosAux;
	}

	/**
	 * Method 'finalizarFichaTecnico'.
	 * 
	 * @param idFichaTec
	 *            Integer
	 * @param valorActual
	 *            String
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/finalizarFichaTecnico", method = RequestMethod.POST)
	public @ResponseBody
	Fichatecnico finalizarFichaTecnico(@RequestParam Integer idFichaTec,
			@RequestParam String valorActual, Model model,
			HttpServletRequest request) {

		Fichatecnico tecnicoFichaAux = new Fichatecnico();

		tecnicoFichaAux.setIdfitec(idFichaTec);
		tecnicoFichaAux.setFinalizado(valorActual);

		tecnicoFichaAux = this.fichatecnicoService
				.finalizarFichaTec(tecnicoFichaAux);

		FichatecnicoController.logger.info("[GET - FINALIZAR FICHA TECNICO] "
				+ idFichaTec);

		return tecnicoFichaAux;
	}
}
