package com.ejie.aa20b.control;

import com.ejie.aa20b.service.FichaejecucionService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa20b.model.Fichaejecucion;

/**
 * FichaejecucionController generated by UDA, 13-may-2015 16:26:17.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/fichaejecucion")
public class FichaejecucionController {

	private static final Logger logger = LoggerFactory
			.getLogger(FichaejecucionController.class);

	@Autowired
	private FichaejecucionService fichaejecucionService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		FichaejecucionController.logger.info("[GET - View] : fichaejecucion");
		return "fichaejecucion";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idfitec
	 *            Integer
	 * @param feini
	 *            Date
	 * @param fefin
	 *            Date
	 * @return fichaejecucion Fichaejecucion
	 */
	@RequestMapping(value = "/{idfitec}/{feini}/{fefin}", method = RequestMethod.GET)
	public @ResponseBody
	Fichaejecucion getById(@PathVariable Integer idfitec,
			@PathVariable Date feini, @PathVariable Date fefin) {
		Fichaejecucion fichaejecucion = new Fichaejecucion();
		fichaejecucion.setIdfitec(idfitec);
		fichaejecucion.setFeini(feini);
		fichaejecucion.setFefin(fefin);
		fichaejecucion = this.fichaejecucionService.find(fichaejecucion);
		FichaejecucionController.logger
				.info("[GET - findBy_PK] : Obtener Fichaejecucion por PK");
		return fichaejecucion;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterFichaejecucion
	 *            Fichaejecucion
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Fichaejecucion> getAll(
			@ModelAttribute Fichaejecucion filterFichaejecucion) {
		FichaejecucionController.logger
				.info("[GET - find_ALL] : Obtener Fichaejecucion por filtro");
		return this.fichaejecucionService.findAll(filterFichaejecucion, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @return Fichaejecucion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Fichaejecucion edit(@RequestBody Fichaejecucion fichaejecucion) {
		Fichaejecucion fichaejecucionAux = this.fichaejecucionService
				.update(fichaejecucion);
		FichaejecucionController.logger
				.info("[PUT] : Fichaejecucion actualizado correctamente");
		return fichaejecucionAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param fichaejecucion
	 *            Fichaejecucion
	 * @return Fichaejecucion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Fichaejecucion add(@RequestBody Fichaejecucion fichaejecucion) {
		Fichaejecucion fichaejecucionAux = this.fichaejecucionService
				.add(fichaejecucion);
		FichaejecucionController.logger
				.info("[POST] : Fichaejecucion insertado correctamente");
		return fichaejecucionAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idfitec
	 *            Integer
	 * @param feini
	 *            Date
	 * @param fefin
	 *            Date
	 * @return fichaejecucion
	 */
	@RequestMapping(value = "/{idfitec}/{feini}/{fefin}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Fichaejecucion remove(@PathVariable Integer idfitec,
			@PathVariable Date feini, @PathVariable Date fefin) {
		Fichaejecucion fichaejecucion = new Fichaejecucion();
		fichaejecucion.setIdfitec(idfitec);
		fichaejecucion.setFeini(feini);
		fichaejecucion.setFefin(fefin);
		this.fichaejecucionService.remove(fichaejecucion);
		FichaejecucionController.logger
				.info("[DELETE] : Fichaejecucion borrado correctamente");
		return fichaejecucion;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param fichaejecucionIds
	 *            List
	 * @return fichaejecucionList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> fichaejecucionIds) {
		List<Fichaejecucion> fichaejecucionList = new ArrayList<Fichaejecucion>();
		for (List<String> fichaejecucionId : fichaejecucionIds) {
			Iterator<String> iterator = fichaejecucionId.iterator();
			Fichaejecucion fichaejecucion = new Fichaejecucion(); // NOPMD -
																	// Objeto
																	// nuevo en
																	// la lista
																	// (parametro
																	// del
																	// servicio)
			fichaejecucion.setIdfitec(ObjectConversionManager.convert(
					iterator.next(), java.lang.Integer.class));
			fichaejecucion.setFeini(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			fichaejecucion.setFefin(ObjectConversionManager.convert(
					iterator.next(), java.util.Date.class));
			fichaejecucionList.add(fichaejecucion);
		}
		this.fichaejecucionService.removeMultiple(fichaejecucionList);
		FichaejecucionController.logger
				.info("[POST - DELETE_ALL] : Fichaejecucion borrados correctamente");
		return fichaejecucionIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterFichaejecucion
	 *            Fichaejecucion
	 * @param pagination
	 *            Pagination
	 * @param idFiTec
	 *            Integer
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute Fichaejecucion filterFichaejecucion,
			@ModelAttribute Pagination pagination, HttpServletRequest req) {

		Integer idFiTec = null;
		if (req.getParameter("idFiTec") != null
				&& !req.getParameter("idFiTec").equals("")) {
			idFiTec = Integer.parseInt(req.getParameter("idFiTec"));
			filterFichaejecucion.setIdfitec(idFiTec);

		} else {
			filterFichaejecucion.setIdfitec(0);
		}

		List<Fichaejecucion> fichaejecucions = this.fichaejecucionService
				.findAll(filterFichaejecucion, pagination);
		Long recordNum = this.fichaejecucionService
				.findAllCount(filterFichaejecucion);
		FichaejecucionController.logger
				.info("[GET - jqGrid] : Obtener Fichaejecucion");
		return new JQGridJSONModel(pagination, recordNum, fichaejecucions);
	}

	/**
	 * Method 'ejecucionesFicha'.
	 * 
	 * @param filterFichaejecucion
	 *            Fichaejecucion
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "ejecucionesFicha", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel ejecucionesFicha(
			@ModelAttribute Fichaejecucion filterFichaejecucion,
			@ModelAttribute Pagination pagination) {

		List<Fichaejecucion> Fichaejecucions = this.fichaejecucionService
				.findAll(filterFichaejecucion, pagination);
		Long recordNum = this.fichaejecucionService
				.findAllCount(filterFichaejecucion);
		FichaejecucionController.logger
				.info("[GET - jqGrid] : Obtener Fichaejecucion");
		return new JQGridJSONModel(pagination, recordNum, Fichaejecucions);

	}

	/**
	 * Method 'modificarEjecFicha'.
	 * 
	 * @param fichaEjec
	 *            Fichaejecucion
	 * @param accion
	 *            String
	 * @return Fichaejecucion
	 */
	@RequestMapping(value = "modificarEjecFicha", method = RequestMethod.POST)
	public @ResponseBody
	String modificarEjecFicha(@RequestBody Fichaejecucion fichaEjec,
			@RequestParam String accion) {

		Fichaejecucion fichaejecucions = new Fichaejecucion();
		if (accion.equals("NUEVO")) {
			fichaejecucions = this.fichaejecucionService
					.nuevaEjecucionFicha(fichaEjec);
			if (fichaejecucions != null) {
				// Ejecucion insertada correctamente
				FichaejecucionController.logger
						.info("[PUT] : Ejecucion Nueva correctamente");
				return "OK";
			} else {
				return "NOVALIDA";
			}

		} else if (accion.equals("MODIFICAR")) {
			fichaejecucions = this.fichaejecucionService
					.modificarEjecucionFicha(fichaEjec);
			FichaejecucionController.logger
					.info("[PUT] : Ejecucion actualizado correctamente");
			if (fichaejecucions != null) {
				// Ejecucion insertada correctamente
				return "OK";
			} else {
				return "NOVALIDA";
			}
		}
		return "ERROR";
	}

	@RequestMapping(value = "/recalcularTiempoFichaTecnico", method = RequestMethod.POST)
	public @ResponseBody
	Boolean recalcularTiempoFichaTecnico(@RequestParam Integer idFichaTec,
			Model model, HttpServletRequest request) {

		Boolean tiempoActualizado;
		tiempoActualizado = this.fichaejecucionService
				.recalcularTiempoFichaTecnico(idFichaTec);

		FichaejecucionController.logger
				.info("[GET - Actualizar TiempoReal] : ");

		return tiempoActualizado;
	}

	@RequestMapping(value = "/eliminarEjecFicha", method = RequestMethod.POST)
	public @ResponseBody
	Boolean eliminarEjecFicha(@RequestParam Integer idfichaEjecucion,
			Model model, HttpServletRequest request) {

		Fichaejecucion fichaejecucions = new Fichaejecucion();
		fichaejecucions.setIdficeje(idfichaEjecucion);
		this.fichaejecucionService.remove(fichaejecucions);

		FichaejecucionController.logger
				.info("[GET - Actualizar TiempoReal] : ");

		return true;
	}

	/**
	 * 
	 * Method 'fichaTecnicoTieneEjecuciones'.
	 * 
	 * 
	 * puestoIntroducido String
	 * 
	 * @return List
	 */

	@RequestMapping(value = "/fichaTecnicoTieneEjecuciones", method = RequestMethod.POST)
	public @ResponseBody
	String fichaTecnicoTieneEjecuciones(@RequestParam Integer idFiTec,
			Model model, HttpServletRequest request) {

		Fichaejecucion fichaejecucions = new Fichaejecucion();

		FichaejecucionController.logger
				.info("[POST - fichaTecnicoTieneEjecuciones] : Comprobando si el Técnico asociado a esta ficha tiene ejecuciones. ");

		fichaejecucions.setIdfitec(idFiTec);

		List<Fichaejecucion> lsFiEjec = this.fichaejecucionService.findAll(
				fichaejecucions, null);
		if (lsFiEjec.size() > 0) {
			// Comprobar que todas las ejecuciones estén finalizadas. En caso
			// contrario no se podrá finalizar
			for (Fichaejecucion fichaEjec : lsFiEjec) {
				if (fichaEjec.getFefin() == null) {
					return "FALTA FEFIN";
				}
			}
			return "OK";
		} else {
			return "FALTA EJEC";
		}
	}
}
