package com.ejie.aa20b.control;

import com.ejie.aa20b.service.Aa20bUsuarioXLNETService;
import com.ejie.aa20b.service.FichaService;
import com.ejie.aa20b.service.FichatecnicoService;
import com.ejie.aa20b.service.MaquinasService;
import com.ejie.aa20b.service.PartesService;
import com.ejie.aa20b.service.TecnicosService;
import com.ejie.aa20b.service.UsuariosService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.crypto.dsig.spec.XPathType.Filter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.informes.t07bGeneraPDF_RTF;
import com.ejie.aa20b.informes.listados.FichaInforme;
import com.ejie.aa20b.informes.listados.PrevAsigPendEjec;
import com.ejie.aa20b.informes.listados.PrevPendAsignar;
import com.ejie.aa20b.informes.listados.Preventivos;
import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.ActAnual;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Fichatecnico;
import com.ejie.aa20b.model.Gamas;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.PlanGeneral;
import com.ejie.aa20b.model.TablaInformes;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Usuarios;
import com.ejie.aa20b.util.Aa20bConstantes;

/**
 * FichaController generated by UDA, 10-mar-2015 10:12:59.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/ficha")
public class FichaController {

	private static final Logger logger = LoggerFactory
			.getLogger(FichaController.class);

	@Autowired
	private FichaService fichaService;

	@Autowired
	private MaquinasService maquinasService;

	@Autowired
	private TecnicosService tecnicosService;

	@Autowired
	private FichatecnicoService fichatecnicoService;

	@Autowired
	private PartesService partesService;

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private UsuarioXLNETController usuarioXLNETController;

	@Autowired
	private Aa20bUsuarioXLNETService usuarioXLNETService;

	@Autowired
	private UsuariosService usuariosService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		FichaController.logger.info("[GET - View] : ficha");
		request.getSession().removeAttribute("FiltroFicha");

		Boolean usuarioEsTecMantenimiento = this.usuarioXLNETService
				.esTecMantenimiento();

		if (usuarioEsTecMantenimiento) {
			model.addAttribute("modoConsultaTipo", "1");
		} else {
			model.addAttribute("modoConsultaTipo", "0");
		}

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) { // TODO Auto-generated catch
												// block
			e.printStackTrace();
		}

		model.addAttribute("idUsuario", sUIDUsuario);

		return "ficha";
	}

	/**
	 * Method 'maintVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintVolver", method = RequestMethod.GET)
	public String maintVolver(Model model, HttpServletRequest request) {
		FichaController.logger.info("[GET - View] : maintVolver");
		// Meter en sesion el filtro para si edita una Ficha al volver cargar el
		// filtro
		Ficha fichaFiltro = (Ficha) request.getSession().getAttribute(
				"FiltroFicha");

		model.addAttribute("FiltroFicha", fichaFiltro);

		Boolean usuarioEsTecMantenimiento = this.usuarioXLNETService
				.esTecMantenimiento();
		if (usuarioEsTecMantenimiento) {
			model.addAttribute("modoConsultaTipo", "1");
		} else {
			model.addAttribute("modoConsultaTipo", "0");
		}

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) { // TODO Auto-generated catch
												// block
			e.printStackTrace();
		}

		model.addAttribute("idUsuario", sUIDUsuario);

		return "ficha";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idficha
	 *            Integer
	 * @return ficha Ficha
	 */
	@RequestMapping(value = "/{idficha}", method = RequestMethod.GET)
	public @ResponseBody
	Ficha getById(@PathVariable Integer idficha) {
		Ficha ficha = new Ficha();
		ficha.setIdficha(idficha);
		ficha = this.fichaService.find(ficha);
		FichaController.logger.info("[GET - findBy_PK] : Obtener Ficha por PK");
		return ficha;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterFicha
	 *            Ficha
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Ficha> getAll(@ModelAttribute Ficha filterFicha) {
		FichaController.logger
				.info("[GET - find_ALL] : Obtener Ficha por filtro");
		return this.fichaService.findAll(filterFicha, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Ficha edit(@RequestBody Ficha ficha) {
		Ficha fichaAux = this.fichaService.update(ficha);
		FichaController.logger.info("[PUT] : Ficha actualizado correctamente");
		return fichaAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Ficha
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Ficha add(@RequestBody Ficha ficha) {
		Ficha fichaAux = this.fichaService.add(ficha);
		FichaController.logger.info("[POST] : Ficha insertado correctamente");
		return fichaAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idficha
	 *            Integer
	 * @return ficha
	 */
	@RequestMapping(value = "/{idficha}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Ficha remove(@PathVariable Integer idficha) {
		Ficha ficha = new Ficha();
		ficha.setIdficha(idficha);
		this.fichaService.remove(ficha);
		FichaController.logger.info("[DELETE] : Ficha borrado correctamente");
		return ficha;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param fichaIds
	 *            List
	 * @return fichaList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> fichaIds) {
		List<Ficha> fichaList = new ArrayList<Ficha>();
		for (List<String> fichaId : fichaIds) {
			Iterator<String> iterator = fichaId.iterator();
			Ficha ficha = new Ficha(); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			ficha.setIdficha(ObjectConversionManager.convert(iterator.next(),
					Integer.class));
			fichaList.add(ficha);
		}
		this.fichaService.removeMultiple(fichaList);
		FichaController.logger
				.info("[POST - DELETE_ALL] : Ficha borrados correctamente");
		return fichaIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterFicha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Ficha filterFicha,
			@ModelAttribute Pagination pagination) {
		List<Ficha> fichas = this.fichaService.findAll(filterFicha, pagination);
		Long recordNum = this.fichaService.findAllCount(filterFicha);
		FichaController.logger.info("[GET - jqGrid] : Obtener Ficha");
		return new JQGridJSONModel(pagination, recordNum, fichas);
	}

	/**
	 * Method 'imprimirFicha'.
	 * 
	 * @param filterFicha
	 *            Ficha
	 * @param locale
	 *            Locale
	 * @return void
	 */
	/* Imprime la ficha */
	@RequestMapping(value = "/imprimirFicha", method = RequestMethod.GET)
	public @ResponseBody
	void generaListado(@ModelAttribute Ficha filterFicha, Locale locale,
			HttpServletResponse response, HttpServletRequest request) {

		// Integer idficha = filterFicha.getIdficha();
		String idioma = locale.getLanguage();

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		FichaInforme fichaInforme = new FichaInforme();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.fichaService
					.montarSelectTablaFicha(idioma, filterFicha);

			/* Obtener los tecnicos asociados a la ficha */
			ArrayList<TablaInformes> listaTecnicos = this.fichaService
					.montarSelectTablaFichaTecnicos(idioma, filterFicha);

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, fichaInforme
						.getFoImpresoFichaXml(request, locale, listaTabla,
								listaTecnicos, filterFicha),
						Aa20bConstantes.plantillaFichaeu);

			} else {
				generaPdfRtf.generarXML2PDF(response, fichaInforme
						.getFoImpresoFichaXml(request, locale, listaTabla,
								listaTecnicos, filterFicha),
						Aa20bConstantes.plantillaFicha);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'buscarFicha'.
	 * 
	 * @param idEditarFicha
	 *            Integer
	 * @param ventanaOrigenFicha
	 *            String
	 * @return buscarFicha String
	 */
	@RequestMapping(value = "/buscarFicha", method = RequestMethod.POST)
	public String buscarFicha(@RequestParam Integer idEditarFicha,
			@RequestParam String ventanaOrigenFicha, Model model,
			HttpServletRequest request) {

		FichaController.logger.info("[GET - findBy_PK] : Fichas");

		Ficha ficha = new Ficha();

		ficha = this.getById(idEditarFicha);

		FichaController.logger.info("[GET - findBy_PK] : Ficha: "
				+ ficha.toString());

		model.addAttribute("Ficha", ficha);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigenFicha",
				ventanaOrigenFicha);
		model.addAttribute("ventanaOrigenFicha", ventanaOrigenFicha);
		if (request.getParameter("fechaAgenda") != null
				&& !request.getParameter("fechaAgenda").equals("")) {
			model.addAttribute("fechaAgenda",
					request.getParameter("fechaAgenda"));
		}

		return "editarFicha";
	}

	@RequestMapping(value = "/buscarFichaSoloLectura", method = RequestMethod.POST)
	public String buscarFichaSoloLectura(@RequestParam Integer idEditarFicha,
			@RequestParam String ventanaOrigenFicha, Model model,
			HttpServletRequest request) {

		FichaController.logger.info("[GET - findBy_PK] : Fichas");

		Ficha ficha = new Ficha();

		ficha = this.getById(idEditarFicha);

		FichaController.logger.info("[GET - findBy_PK] : Ficha: "
				+ ficha.toString());

		model.addAttribute("Ficha", ficha);
		model.addAttribute("accion", Aa20bConstantes.ACCION_VER_DETALLE);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigenFicha",
				ventanaOrigenFicha);
		model.addAttribute("ventanaOrigenFicha", ventanaOrigenFicha);

		return "consultarFicha";
	}

	/**
	 * Method 'buscarFicha'.
	 * 
	 * @param idEditarFicha
	 *            String
	 * @return buscarFicha String
	 */
	@RequestMapping(value = "/buscarFichaPG", method = RequestMethod.POST)
	public String buscarFichaPG(@RequestParam Integer idEditarFicha,
			@RequestParam String ventanaOrigenFicha,
			@RequestParam String paginaPG, Model model,
			HttpServletRequest request) {

		FichaController.logger.info("[GET - findBy_PK] : Fichas");

		Ficha ficha = new Ficha();

		ficha = this.getById(idEditarFicha);

		FichaController.logger.info("[GET - findBy_PK] : Ficha: "
				+ ficha.toString());

		model.addAttribute("Ficha", ficha);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigenFicha",
				ventanaOrigenFicha);
		model.addAttribute("ventanaOrigenFicha", ventanaOrigenFicha);

		// Meto en sesión la página en la que se encuentra dentro de la
		// planificacion general
		request.getSession().setAttribute("paginaPG", paginaPG);

		PlanGeneral planGeneral = (PlanGeneral) request.getSession()
				.getAttribute("PlanGeneral");
		if (planGeneral != null) {
			model.addAttribute("PlanGeneral", planGeneral);
			// request.getSession().removeAttribute("PlanGeneral");
		}

		return "editarFicha";
	}

	/**
	 * Method 'buscarFichaActAnual'.
	 * 
	 * @param idEditarFicha
	 *            String
	 * @return buscarFicha String
	 */
	@RequestMapping(value = "/buscarFichaActAnual", method = RequestMethod.POST)
	public String buscarFichaActAnual(@RequestParam Integer idEditarFicha,
			@RequestParam String ventanaOrigenFicha,
			@RequestParam String paginaPG, Model model,
			HttpServletRequest request) {

		FichaController.logger.info("[GET - findBy_PK] : Fichas");

		Ficha ficha = new Ficha();

		ficha = this.getById(idEditarFicha);

		FichaController.logger.info("[GET - findBy_PK] : Ficha: "
				+ ficha.toString());

		model.addAttribute("Ficha", ficha);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigenFicha",
				ventanaOrigenFicha);
		model.addAttribute("ventanaOrigenFicha", ventanaOrigenFicha);

		// Meto en sesión la página en la que se encuentra dentro de la
		// planificacion general
		request.getSession().setAttribute("paginaPG", paginaPG);

		ActAnual actAnual = (ActAnual) request.getSession().getAttribute(
				"ActAnual");
		if (actAnual != null) {
			model.addAttribute("ActAnual", actAnual);
		}

		return "editarFicha";
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/crearParteCorrectivo", method = RequestMethod.GET)
	public String crearParteCorrectivo(Model model, HttpServletRequest request) {
		FichaController.logger.info("[GET - View] : modificar actuacion");

		Long idmaquina_PC = Long
				.parseLong(request.getParameter("idmaquina_PC"));
		Integer idActuacion_PC = Integer.parseInt(request
				.getParameter("idActuacion_PC"));

		// Obtener datos máquina para pasar al la venantan de nuevo parte
		// correctivo.
		// Edificio, zona y planta
		Maquinas maquinas = new Maquinas();
		maquinas.setIdmaquina(idmaquina_PC);
		maquinas = this.maquinasService.find(maquinas);

		FichaController.logger.info("[GET - View] : crear parte correctivo : "
				+ maquinas.toString());
		if (maquinas != null) {
			Partes parte = new Partes();
			parte.setIdmaquina(maquinas.getIdmaquina());
			parte.setIdedificio(maquinas.getIdedificio());
			parte.setIdzona(maquinas.getIdzona());
			parte.setIdplanta(maquinas.getIdplanta());
			parte.setIdactuac(idActuacion_PC);
			model.addAttribute("Parte", parte);
		}

		return "nuevoParteCorr";
	}

	/**
	 * Method 'enviarFichaAlTecnico'.
	 * 
	 * @param idFicha
	 *            Integer
	 * @param idTecnico
	 *            Long
	 * @return String
	 * @throws Exception
	 */
	@RequestMapping(value = "/enviarFichaAlTecnico", method = RequestMethod.POST)
	public @ResponseBody
	String enviarFichaAlTecnico(@RequestParam Integer idFicha,
			@RequestParam Long idTecnico, Locale locale) throws Exception {

		Tecnicos tecnico = new Tecnicos();
		tecnico.setIdtecnico(idTecnico);

		Tecnicos tecnicoAux = new Tecnicos();
		tecnicoAux = this.tecnicosService.find(tecnico);

		Ficha ficha = new Ficha();
		ficha.setIdficha(idFicha);
		ficha = this.fichaService.findFicha(ficha);

		String mensajeEnviado = this.enviarMailTecnico(ficha, tecnicoAux,
				locale);

		if (mensajeEnviado != null && "true".equals(mensajeEnviado)) {
			// Si se ha enviado correctamente actualizar el campo ENVIO_MAIL del
			// FICHA/Tecnico

			this.fichatecnicoService.marcarEnvioMail(ficha.getIdficha(),
					idTecnico);

		}
		return mensajeEnviado;

	}

	/**
	 * Method 'enviarFichaTodosTecnico'.
	 * 
	 * @param idFicha
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/enviarFichaTodosTecnico", method = RequestMethod.POST)
	public @ResponseBody
	String enviarFichaTodosTecnico(Integer idFichaTodos, Locale locale)
			throws Exception {

		if (idFichaTodos == null) {
			return "Error al recoger el número de ficha";
		}

		// Integer idFicha = Integer.parseInt(idFichaTodos);
		Ficha ficha = new Ficha();
		ficha.setIdficha(idFichaTodos);

		// Obtener los tecnicos asociados a esta ficha.
		List<Fichatecnico> lsFichaTecnicos = this.fichatecnicoService
				.obtenerTecnicosFichaAsociados(idFichaTodos);

		Tecnicos tecnico;
		String mensajeEnviado = "";

		StringBuffer faltanEmail = new StringBuffer("");
		Long idTecnico;
		for (int i = 0; i < lsFichaTecnicos.size(); i++) {
			idTecnico = lsFichaTecnicos.get(i).getIdtecnico();
			tecnico = new Tecnicos();
			tecnico.setIdtecnico(idTecnico);
			tecnico = this.tecnicosService.find(tecnico);
			if (tecnico.getMail() == null) {
				if (!faltanEmail.toString().equals("")) {
					faltanEmail.append("; ");
					faltanEmail.append(tecnico.getNombre());
				} else {
					faltanEmail.append(tecnico.getNombre());
				}
			}
			mensajeEnviado = this.enviarMailTecnico(ficha, tecnico, locale);
			if (mensajeEnviado != null && "true".equals(mensajeEnviado)) {
				// Si se ha enviado correctamente actualizar el campo ENVIO_MAIL
				// del Ficha/Tecnico
				this.fichatecnicoService.marcarEnvioMail(ficha.getIdficha(),
						idTecnico);
				// Actualizar tambien el campo enviomail de la tabla de fichas
				this.fichaService.marcarEnvioMail(ficha);
			} else {
				if (tecnico.getMail() != null) {
					// No se ha podido enviar un mail y el problema no esta en
					// que no existia email para ese tecnico
					return mensajeEnviado;
				}
			}
		}

		if ("".equals(faltanEmail.toString())) {
			return "true";
		} else {
			return "Falta email de: " + faltanEmail.toString();
		}
	}

	private String enviarMailTecnico(Ficha fichaOrig, Tecnicos tecnicos,
			Locale locale) throws Exception {

		FichaController.logger.info("enviarMailFicha - INICIO: ");

		String idioma = locale.getLanguage();

		Ficha ficha = fichaService.findFicha(fichaOrig);

		String to = "";

		// Acceder a los Diccionarios
		Locale loc = LocaleContextHolder.getLocale();
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");

		try {
			// String remitente = this.appConfiguration.getObject().getProperty(
			// "user.mail.remitente");

			String variableRemitente = this.partesService
					.obtenerVariableCorreo("user.mail.remitente");

			if (variableRemitente == null || variableRemitente == "") {
				String retorno = this.appMessageSource.getMessage(
						"general.email.error", null, loc)
						+ "\n"
						+ this.appMessageSource.getMessage(
								"general.email.noExisteEmisor", null, loc);
				return retorno;
			} else {
				String host = this.appConfiguration.getObject().getProperty(
						"servidor.smtp");

				to = tecnicos.getMail();
				// to = "MJ-Mesanza@ejie.eus";

				String from = variableRemitente;

				FichaController.logger
						.info("enviarMailFicha - ENVIAR MAIL from: "
								+ variableRemitente + " to: " + to);

				Properties props = System.getProperties();
				props.put("mail.smtp.host", host);

				// Esta lÃ­nea indica que vamos a autenticarnos en el servidor
				// SMTP
				// props.put("mail.smtp.auth", "true");
				props.put("mail.smtp.auth", "false");

				// Obtener una sesiÃ³n con las propiedades anteriormente
				// definidas
				// Authenticator auth = new MiAutenticador();
				// Session sesion = Session.getDefaultInstance(props, auth);
				Session sesion = Session.getInstance(props);

				String asunto = this.appMessageSource.getMessage(
						"ficha.email.asunto", null, lEus)
						+ ficha.getIdficha()
						+ " / "
						+ this.appMessageSource.getMessage(
								"ficha.email.asunto", null, lCas)
						+ +ficha.getIdficha();

				/* EUSKERA */
				StringBuffer contenido = new StringBuffer("<p>"
						+ this.appMessageSource.getMessage(
								"ficha.email.titulo", null, lEus) + "</p>");

				contenido.append("<p>");

				contenido.append("<b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.asunto", null, lEus) + "</b>");
				contenido.append(" ").append(ficha.getIdficha());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.textoLocalizacion", null, lEus)
						+ "</b>");
				contenido.append(" ").append(
						ficha.getMaquina().getEdifZonaPlta());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.equipo", null, lEus) + "</b>");
				contenido.append(" ").append(ficha.getMaquina().getCmaquina());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("ficha.email.gama",
								null, lEus) + "</b>");
				contenido.append(" ").append(ficha.getGama().getCgama());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.tiempoReal", null, lEus) + "</b>");
				if (ficha != null && ficha.getTiemporeal() != null
						&& ficha.getTiemporeal() > 0) {
					Integer fichaHoras = (int) Math
							.floor(ficha.getTiemporeal() / 60);
					Integer fichaMinutos = (int) (ficha.getTiemporeal() % 60);

					contenido.append(" ").append(fichaHoras);
					contenido.append(" ").append(":");
					contenido.append(" ").append(fichaMinutos);
				}

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.realizado", null, lEus) + "</b>");
				if (ficha != null && ficha.getEjecutado() != null
						&& ficha.getEjecutado().equals("1")) {
					contenido.append(" ").append("SI");
				} else {
					contenido.append(" ").append("NO");
				}

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.fechaFin", null, lEus) + "</b>");
				String fechaString = "";
				Integer diaSemana = 0;
				String fechaEjec = Aa20bFecha.convertirFechaCompletaEu(
						fechaString, diaSemana);
				contenido.append(" ").append(fechaEjec);

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.tecnicos", null, lEus) + "</b>");
				contenido.append(" ").append(tecnicos.getNombre());

				/***********************************/
				/* obtener la lista de operaciones */
				/***********************************/
				Ficha fichaOper = new Ficha();
				fichaOper.setIdficha(fichaOrig.getIdficha());
				ArrayList<TablaInformes> listaOperaciones = this.fichaService
						.montarSelectTablaFicha(idioma, fichaOper);

				if (listaOperaciones.size() > 0) {
					String descOper = this.appMessageSource.getMessage(
							"ficha.email.descOper", null, lEus);
					String periodo = this.appMessageSource.getMessage(
							"ficha.email.periodo", null, lEus);
					String incidencias = this.appMessageSource.getMessage(
							"ficha.email.incidencias", null, lEus);
					String correctivo = this.appMessageSource.getMessage(
							"ficha.email.correctivo", null, lEus);

					contenido
							.append("<table border='1' style='border-collapse:collapse;'><thead><tr><th>");
					contenido.append(descOper);
					contenido.append("</th><th>");
					contenido.append(periodo);
					contenido.append("</th><th>");
					contenido.append(incidencias);
					contenido.append("</th><th>");
					contenido.append(correctivo);
					contenido.append("</th></tr></thead> <tbody>");

					for (int i = 0; i < listaOperaciones.size(); i++) {
						TablaInformes laFila = new TablaInformes();
						laFila = (TablaInformes) listaOperaciones.get(i);
						contenido.append("<tr>");
						contenido.append(" ").append("<td>");
						contenido.append(" ").append(
								laFila.getOperacion() == null ? "" : laFila
										.getOperacion());
						contenido.append("</td>");
						contenido.append(" ").append("<td>");
						contenido.append(" ").append(
								laFila.getSemanas() == null ? "" : laFila
										.getSemanas());
						contenido.append("</td>");
						contenido.append(" ").append("<td>");
						contenido.append(" ").append(
								laFila.getDescripcion() == null ? "" : laFila
										.getDescripcion());
						contenido.append("</td>");
						contenido.append(" ").append("<td>");
						contenido.append(" ").append(
								laFila.getIdparte() == null ? "" : laFila
										.getIdparte().toString());
						contenido.append("</td>");
						contenido.append("</tr>");
					}
					contenido.append("</tbody></table>");
				}
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.despedida", null, lEus) + "</p>");

				contenido.append("<br/>");
				contenido
						.append("<p style='font-style:italic;'>"
								+ this.appMessageSource.getMessage(
										"parte.email.norespuesta", null, lEus)
								+ "</p>");

				contenido
						.append("___________________________________________________________________________________");

				/* CASTELLANO */
				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"ficha.email.titulo", null, lCas) + "</p>");

				contenido.append("<p>");

				contenido.append("<b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.asunto", null, lCas) + "</b>");
				contenido.append(" ").append(ficha.getIdficha());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.textoLocalizacion", null, lCas)
						+ "</b>");
				contenido.append(" ").append(
						ficha.getMaquina().getEdifZonaPlta());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.equipo", null, lCas) + "</b>");
				contenido.append(" ").append(ficha.getMaquina().getCmaquina());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage("ficha.email.gama",
								null, lCas) + "</b>");
				contenido.append(" ").append(ficha.getGama().getCgama());

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.tiempoReal", null, lCas) + "</b>");
				if (ficha != null && ficha.getTiemporeal() != null
						&& ficha.getTiemporeal() > 0) {
					Integer fichaHoras = (int) Math
							.floor(ficha.getTiemporeal() / 60);
					Integer fichaMinutos = (int) (ficha.getTiemporeal() % 60);

					contenido.append(" ").append(fichaHoras);
					contenido.append(" ").append(":");
					contenido.append(" ").append(fichaMinutos);
				}

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.realizado", null, lCas) + "</b>");
				if (ficha != null && ficha.getEjecutado() != null
						&& ficha.getEjecutado().equals("1")) {
					contenido.append(" ").append("SI");
				} else {
					contenido.append(" ").append("NO");
				}

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.fechaFin", null, lCas) + "</b>");
				fechaString = "";
				diaSemana = 0;
				fechaEjec = " ";
				if (ficha.getFeejec() != null) {
					fechaString = Aa20bFecha.getFecha(ficha.getFeejec());
					diaSemana = ficha.getFeejec().getDay() + 1;
					fechaEjec = Aa20bFecha.convertirFechaCompleta(fechaString,
							diaSemana);
				}
				contenido.append(" ").append(fechaEjec);

				contenido.append("<br/><b>"
						+ this.appMessageSource.getMessage(
								"ficha.email.tecnicos", null, lCas) + "</b>");
				contenido.append(" ").append(tecnicos.getNombre());

				if (listaOperaciones.size() > 0) {
					String descOper = this.appMessageSource.getMessage(
							"ficha.email.descOper", null, lCas);
					String periodo = this.appMessageSource.getMessage(
							"ficha.email.periodo", null, lCas);
					String incidencias = this.appMessageSource.getMessage(
							"ficha.email.incidencias", null, lCas);
					String correctivo = this.appMessageSource.getMessage(
							"ficha.email.correctivo", null, lCas);

					contenido
							.append("<table border='1' style='border-collapse:collapse;'><thead><tr><th>");
					contenido.append(descOper);
					contenido.append("</th><th>");
					contenido.append(periodo);
					contenido.append("</th><th>");
					contenido.append(incidencias);
					contenido.append("</th><th>");
					contenido.append(correctivo);
					contenido.append("</th></tr></thead> <tbody>");

					for (int i = 0; i < listaOperaciones.size(); i++) {
						TablaInformes laFila = new TablaInformes();
						laFila = (TablaInformes) listaOperaciones.get(i);
						contenido.append("<tr>");
						contenido.append(" ").append("<td>");
						contenido.append(" ").append(
								laFila.getOperacion() == null ? "" : laFila
										.getOperacion());
						contenido.append("</td>");
						contenido.append(" ").append("<td>");
						contenido.append(" ").append(
								laFila.getSemanas() == null ? "" : laFila
										.getSemanas());
						contenido.append("</td>");
						contenido.append(" ").append("<td>");
						contenido.append(" ").append(
								laFila.getDescripcion() == null ? "" : laFila
										.getDescripcion());
						contenido.append("</td>");
						contenido.append(" ").append("<td>");
						contenido.append(" ").append(
								laFila.getIdparte() == null ? "" : laFila
										.getIdparte().toString());
						contenido.append("</td>");
						contenido.append("</tr>");
					}
					contenido.append("</tbody></table>");

				}
				contenido.append("</p>");

				contenido.append("<p>"
						+ this.appMessageSource.getMessage(
								"parte.email.despedida", null, lCas) + "</p>");

				contenido.append("<br/>");
				contenido
						.append("<p style='font-style:italic;'>"
								+ this.appMessageSource.getMessage(
										"parte.email.norespuesta", null, lCas)
								+ "</p>");
				/**/

				// create a message
				MimeMessage msg = new MimeMessage(sesion);
				msg.setFrom(new InternetAddress(from));
				msg.addRecipient(Message.RecipientType.TO, new InternetAddress(
						to));

				// String emailoculto = this.appConfiguration.getObject()
				// .getProperty("emailCopiaOculta");

				String variableEmailOculto = this.partesService
						.obtenerVariableCorreo("emailCopiaOculta");

				if (variableEmailOculto != null
						&& !variableEmailOculto.isEmpty())
					msg.addRecipient(Message.RecipientType.BCC,
							new InternetAddress(variableEmailOculto));
				// create and fill the first message part
				MimeBodyPart mbp1 = new MimeBodyPart();

				mbp1.setContent(contenido.toString(), "text/html");
				// mbp1.setHeader("Content-Type",
				// "text/html; charset=ISO-8859-1");
				Multipart mp = new MimeMultipart();
				mp.addBodyPart(mbp1);

				// add the Multipart to the message
				msg.setContent(mp);
				msg.setSubject(asunto);

				// set the Date: header
				msg.setSentDate(new Date());

				// send the message
				Transport.send(msg);

				// Marcar
				FichaController.logger.info("enviarMailFicha - FIN. ");

				return "true";
			}
		} catch (Exception ex) {
			FichaController.logger.error("enviarMailFicha - ENVIAR MAIL to:"
					+ to + " " + ex.getMessage());
			StackTraceElement[] trazas = ex.getStackTrace();
			for (StackTraceElement traza : trazas) {
				FichaController.logger.error(traza.toString());
			}
			StringBuffer retorno = new StringBuffer();
			retorno.append(
					this.appMessageSource.getMessage("general.email.error",
							null, loc))
					.append("\n")
					.append(this.appMessageSource.getMessage(
							"general.email.noExisteEmisor", null, loc));
			retorno.append(" ").append(to);
			return retorno.toString();
		}
	}

	/**
	 * Method 'actualizarEjecFicha'.
	 * 
	 * @param idFicha
	 *            Integer
	 * @param accionFicha
	 *            String
	 * @return Fichas
	 */
	@RequestMapping(value = "/actualizarEjecFicha", method = RequestMethod.POST)
	public @ResponseBody
	Ficha actualizarEjecFicha(@RequestParam Integer idFicha,
			@RequestParam String accionFicha, Model model,
			HttpServletRequest request) {

		Ficha parte = new Ficha();
		if (accionFicha.equalsIgnoreCase("ABRIR")) {
			parte = this.fichaService.abrirFicha(idFicha);

		} else if (accionFicha.equalsIgnoreCase("FINALIZAR")) {
			parte = this.fichaService.finalizarFicha(idFicha);
		}

		FichaController.logger.info("[GET - FINALIZAR FICHA ] " + idFicha);

		return parte;
	}

	/**
	 * Method 'obtenerDatosEjecucion'.
	 * 
	 * @param idficha
	 *            Integer
	 * @return List
	 */
	@RequestMapping(value = "/obtenerDatosEjecucion", method = RequestMethod.POST)
	public @ResponseBody
	Ficha obtenerDatosEjecucion(@RequestParam Integer idficha) {
		FichaController.logger
				.info("[GET - obtenerTiposAlta] : Obtener Espacios en Alta");
		Ficha ficha = new Ficha();
		ficha.setIdficha(idficha);
		ficha = this.fichaService.findFicha(ficha);

		return ficha;
	}

	/**
	 * Method 'prevPendAsignarVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "prevPendAsignarVolver", method = RequestMethod.GET)
	public String prevPendAsignarVolver(Model model, HttpServletRequest request) {
		FichaController.logger.info("[GET - View] : prevPendAsignarVolver");
		model.addAttribute("Pendiente", "PrevAsignar");
		// Meter en sesion el filtro para si edita una Ficha al volver cargar el
		// filtro
		Ficha fichaFiltro = (Ficha) request.getSession().getAttribute(
				"FiltroFicha");

		model.addAttribute("FiltroFicha", fichaFiltro);

		return "prevPendientes";
	}

	/**
	 * Method 'prevPendAsignar'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "prevPendAsignar", method = RequestMethod.GET)
	public String prevPendAsignar(Model model, HttpServletRequest request) {
		FichaController.logger.info("[GET - View] : prevPendAsignar");
		model.addAttribute("Pendiente", "PrevAsignar");
		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroFicha");

		return "prevPendientes";
	}

	/**
	 * Method 'prevAsigPendEjecutarVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "prevAsigPendEjecutarVolver", method = RequestMethod.GET)
	public String prevAsigPendEjecutarVolver(Model model,
			HttpServletRequest request) {
		FichaController.logger
				.info("[GET - View] : prevAsigPendEjecutarVolver");
		model.addAttribute("Pendiente", "PrevAsigPendEjec");
		// Meter en sesion el filtro para si edita una Ficha al volver cargar el
		// filtro
		Ficha fichaFiltro = (Ficha) request.getSession().getAttribute(
				"FiltroFicha");

		model.addAttribute("FiltroFicha", fichaFiltro);

		return "prevPendientes";
	}

	/**
	 * Method 'prevAsigPendEjecutar'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "prevAsigPendEjecutar", method = RequestMethod.GET)
	public String prevAsigPendEjecutar(Model model, HttpServletRequest request) {
		FichaController.logger.info("[GET - View] : prevAsigPendEjecutar");
		model.addAttribute("Pendiente", "PrevAsigPendEjec");
		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroFicha");

		return "prevPendientes";
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterFicha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridPrevPendAsignar", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridPrevPendAsignar(@ModelAttribute Ficha filterFicha,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Gamas gama = new Gamas();
				if (filterFicha.getGama() != null) {
					gama = filterFicha.getGama();
				}
				gama.setIdservicio(usuario.getIdservicio());
				filterFicha.setGama(gama);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		List<Ficha> partess = this.fichaService.obtenerPrevPendAsignar(
				filterFicha, pagination, false, sUIDUsuario);

		Long recordNum = this.fichaService.obtenerPrevPendAsignarCount(
				filterFicha, false, sUIDUsuario);
		FichaController.logger
				.info("[GET - jqGrid] : Obtener Ficha preventivos pendientes de asignar tecnicos");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterFicha.getFechaD() != null) {
			try {
				filterFicha.setStrFechaD(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaD(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (filterFicha.getFechaH() != null) {
			try {
				filterFicha.setStrFechaH(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaH(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		if (filterFicha.getFechaplanifD() != null) {
			try {
				filterFicha.setStrFechaplanifD(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaplanifD(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		if (filterFicha.getFechaplanifH() != null) {
			try {
				filterFicha.setStrFechaplanifH(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaplanifH(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroFicha", filterFicha);
		return new JQGridJSONModel(pagination, recordNum, partess);
	}

	/**
	 * Method 'gridPrevAsigPendEjec'.
	 * 
	 * @param filterFicha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridPrevAsigPendEjec", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridPrevAsigPendEjec(@ModelAttribute Ficha filterFicha,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Gamas gama = new Gamas();
				if (filterFicha.getGama() != null) {
					gama = filterFicha.getGama();
				}
				gama.setIdservicio(usuario.getIdservicio());
				filterFicha.setGama(gama);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		List<Ficha> partess = this.fichaService.obtenerPrevAsigPendEjec(
				filterFicha, pagination, false, sUIDUsuario);

		Long recordNum = this.fichaService.obtenerPrevAsigPendEjecCount(
				filterFicha, false, sUIDUsuario);
		FichaController.logger
				.info("[GET - jqGrid] : Obtener Ficha preventivos asignados pendientes de ejecutar");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterFicha.getFechaD() != null) {
			try {
				filterFicha.setStrFechaD(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaD(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (filterFicha.getFechaH() != null) {
			try {
				filterFicha.setStrFechaH(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaH(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		if (filterFicha.getFechaplanifD() != null) {
			try {
				filterFicha.setStrFechaplanifD(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaplanifD(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		if (filterFicha.getFechaplanifH() != null) {
			try {
				filterFicha.setStrFechaplanifH(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaplanifH(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroFicha", filterFicha);
		return new JQGridJSONModel(pagination, recordNum, partess);
	}

	/**
	 * Method 'imprimirPrevPendAsignar'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirPrevPendAsignar", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirPrevPendAsignar(@ModelAttribute Ficha filterFichas,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;

		if (filterFichas != null && filterFichas.getStrFechaD() != null
				&& !filterFichas.getStrFechaD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterFichas.getStrFechaD());
				filterFichas.setFechaD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaH() != null
				&& !filterFichas.getStrFechaH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterFichas.getStrFechaH());
				filterFichas.setFechaH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

		Date dateFechaplanifD = null;
		Date dateFechaplanifH = null;
		if (filterFichas != null && filterFichas.getStrFechaplanifD() != null
				&& !filterFichas.getStrFechaplanifD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifD = sdf.parse(filterFichas.getStrFechaplanifD());
				filterFichas.setFechaplanifD(dateFechaplanifD);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaplanifH() != null
				&& !filterFichas.getStrFechaplanifH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifH = sdf.parse(filterFichas.getStrFechaplanifH());
				filterFichas.setFechaplanifH(dateFechaplanifH);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Integer idficha = filterFicha.getIdficha();

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		PrevPendAsignar prevPendAsignar = new PrevPendAsignar();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.fichaService
					.montarSelectTablaPrevPendAsignar(idioma, filterFichas,
							sUIDUsuario);

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, prevPendAsignar
						.getFoPrevPendAsignarXml(request, locale, listaTabla,
								filterFichas),
						Aa20bConstantes.plantillaPrevPendAsignareu);

			} else {
				generaPdfRtf.generarXML2PDF(response, prevPendAsignar
						.getFoPrevPendAsignarXml(request, locale, listaTabla,
								filterFichas),
						Aa20bConstantes.plantillaPrevPendAsignar);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'imprimirAsigPendEjec'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirAsigPendEjec", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirAsigPendEjec(@ModelAttribute Ficha filterFichas,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;

		if (filterFichas != null && filterFichas.getStrFechaD() != null
				&& !filterFichas.getStrFechaD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterFichas.getStrFechaD());
				filterFichas.setFechaD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaH() != null
				&& !filterFichas.getStrFechaH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterFichas.getStrFechaH());
				filterFichas.setFechaH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

		Date dateFechaplanifD = null;
		Date dateFechaplanifH = null;
		if (filterFichas != null && filterFichas.getStrFechaplanifD() != null
				&& !filterFichas.getStrFechaplanifD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifD = sdf.parse(filterFichas.getStrFechaplanifD());
				filterFichas.setFechaplanifD(dateFechaplanifD);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaplanifH() != null
				&& !filterFichas.getStrFechaplanifH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifH = sdf.parse(filterFichas.getStrFechaplanifH());
				filterFichas.setFechaplanifH(dateFechaplanifH);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Integer idficha = filterFicha.getIdficha();

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		PrevAsigPendEjec prevAsigPendEjec = new PrevAsigPendEjec();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.fichaService
					.montarSelectTablaPrevAsigPendEjec(idioma, filterFichas,
							sUIDUsuario);

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, prevAsigPendEjec
						.getFoPrevAsigPendEjecXml(request, locale, listaTabla,
								filterFichas),
						Aa20bConstantes.plantillaPrevAsigPendEjeceu);

			} else {
				generaPdfRtf.generarXML2PDF(response, prevAsigPendEjec
						.getFoPrevAsigPendEjecXml(request, locale, listaTabla,
								filterFichas),
						Aa20bConstantes.plantillaPrevAsigPendEjec);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'imprimirListadoFichas'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirListadoFichas", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirListadoFichas(@ModelAttribute Ficha filterFichas,
			Locale locale, HttpServletResponse response,
			HttpServletRequest request) {

		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;

		if (filterFichas != null && filterFichas.getStrFechaD() != null
				&& !filterFichas.getStrFechaD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterFichas.getStrFechaD());
				filterFichas.setFechaD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaH() != null
				&& !filterFichas.getStrFechaH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterFichas.getStrFechaH());
				filterFichas.setFechaH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		Date dateFechaplanifD = null;
		Date dateFechaplanifH = null;
		if (filterFichas != null && filterFichas.getStrFechaplanifD() != null
				&& !filterFichas.getStrFechaplanifD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifD = sdf.parse(filterFichas.getStrFechaplanifD());
				filterFichas.setFechaplanifD(dateFechaplanifD);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaplanifH() != null
				&& !filterFichas.getStrFechaplanifH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifH = sdf.parse(filterFichas.getStrFechaplanifH());
				filterFichas.setFechaplanifH(dateFechaplanifH);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Integer idficha = filterFicha.getIdficha();

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		Preventivos preventivos = new Preventivos();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.fichaService
					.montarSelectTablaPreventivos(idioma, filterFichas,
							sUIDUsuario);

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, preventivos
						.getFoPreventivosXml(request, locale, listaTabla,
								filterFichas),
						Aa20bConstantes.plantillaPreventivoseu);

			} else {
				generaPdfRtf.generarXML2PDF(response, preventivos
						.getFoPreventivosXml(request, locale, listaTabla,
								filterFichas),
						Aa20bConstantes.plantillaPreventivos);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'imprimirDiario'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirDiario", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirDiario(@ModelAttribute Ficha filterFichas, Locale locale,
			HttpServletResponse response, HttpServletRequest request) {

		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;

		if (filterFichas != null && filterFichas.getStrFechaD() != null
				&& filterFichas.getStrFechaD() != null
				&& !filterFichas.getStrFechaD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterFichas.getStrFechaD());
				filterFichas.setFechaD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaH() != null
				&& filterFichas.getStrFechaH() != null
				&& !filterFichas.getStrFechaH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterFichas.getStrFechaH());
				filterFichas.setFechaH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

		Date dateFechaplanifD = null;
		Date dateFechaplanifH = null;
		if (filterFichas != null && filterFichas.getStrFechaplanifD() != null
				&& filterFichas.getStrFechaplanifD() != null
				&& !filterFichas.getStrFechaplanifD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifD = sdf.parse(filterFichas.getStrFechaplanifD());
				filterFichas.setFechaplanifD(dateFechaplanifD);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaplanifH() != null
				&& filterFichas.getStrFechaplanifH() != null
				&& !filterFichas.getStrFechaplanifH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifH = sdf.parse(filterFichas.getStrFechaplanifH());
				filterFichas.setFechaplanifH(dateFechaplanifH);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Integer idficha = filterFicha.getIdficha();

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		Preventivos preventivos = new Preventivos();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.fichaService
					.montarSelectTablaDiarioFichas(idioma, filterFichas,
							sUIDUsuario);

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, preventivos
						.getFoDiarioFichasXml(request, locale, listaTabla,
								filterFichas),
						Aa20bConstantes.plantillaDiarioFichaseu);

			} else {
				generaPdfRtf.generarXML2PDF(response, preventivos
						.getFoDiarioFichasXml(request, locale, listaTabla,
								filterFichas),
						Aa20bConstantes.plantillaDiarioFichas);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'imprimirEjecutados'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirEjecutados", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirEjecutados(@ModelAttribute Ficha filterFichas, Locale locale,
			HttpServletResponse response, HttpServletRequest request) {

		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;

		if (filterFichas != null && filterFichas.getStrFechaD() != null
				&& !filterFichas.getStrFechaD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterFichas.getStrFechaD());
				filterFichas.setFechaD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaH() != null
				&& !filterFichas.getStrFechaH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterFichas.getStrFechaH());
				filterFichas.setFechaH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

		Date dateFechaplanifD = null;
		Date dateFechaplanifH = null;
		if (filterFichas != null && filterFichas.getStrFechaplanifD() != null
				&& !filterFichas.getStrFechaplanifD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifD = sdf.parse(filterFichas.getStrFechaplanifD());
				filterFichas.setFechaplanifD(dateFechaplanifD);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaplanifH() != null
				&& !filterFichas.getStrFechaplanifH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifH = sdf.parse(filterFichas.getStrFechaplanifH());
				filterFichas.setFechaplanifH(dateFechaplanifH);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Integer idficha = filterFicha.getIdficha();

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		Preventivos preventivos = new Preventivos();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.fichaService
					.montarSelectTablaFichasEjecutadas(idioma, filterFichas,
							sUIDUsuario);

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, preventivos
						.getFoFichasEjecutadasXml(request, locale, listaTabla,
								filterFichas),
						Aa20bConstantes.plantillaFichasEjecTecnicoeu);

			} else {
				generaPdfRtf.generarXML2PDF(response, preventivos
						.getFoFichasEjecutadasXml(request, locale, listaTabla,
								filterFichas),
						Aa20bConstantes.plantillaFichasEjecTecnico);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'imprimirDetallados'.
	 * 
	 * @param filterPartes
	 *            Partes
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "imprimirDetallados", method = RequestMethod.GET)
	public @ResponseBody
	void imprimirDetallados(@ModelAttribute Ficha filterFichas, Locale locale,
			HttpServletResponse response, HttpServletRequest request) {

		String idioma = locale.getLanguage();
		SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
		Date dateFechaD = null;
		Date dateFechaH = null;

		if (filterFichas != null && filterFichas.getStrFechaD() != null
				&& !filterFichas.getStrFechaD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaD = sdf.parse(filterFichas.getStrFechaD());
				filterFichas.setFechaD(dateFechaD);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaH() != null
				&& !filterFichas.getStrFechaH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaH = sdf.parse(filterFichas.getStrFechaH());
				filterFichas.setFechaH(dateFechaH);
			} catch (ParseException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
		}

		Date dateFechaplanifD = null;
		Date dateFechaplanifH = null;
		if (filterFichas != null && filterFichas.getStrFechaplanifD() != null
				&& !filterFichas.getStrFechaplanifD().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifD = sdf.parse(filterFichas.getStrFechaplanifD());
				filterFichas.setFechaplanifD(dateFechaplanifD);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}
		if (filterFichas != null && filterFichas.getStrFechaplanifH() != null
				&& !filterFichas.getStrFechaplanifH().equals("")) {
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				sdf = new SimpleDateFormat("yyyy-MM-dd");
			}
			try {
				dateFechaplanifH = sdf.parse(filterFichas.getStrFechaplanifH());
				filterFichas.setFechaplanifH(dateFechaplanifH);
			} catch (Exception e1) {
				e1.printStackTrace();
			}
		}

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		// Integer idficha = filterFicha.getIdficha();

		t07bGeneraPDF_RTF generaPdfRtf = new t07bGeneraPDF_RTF();

		Preventivos preventivos = new Preventivos();

		try {

			/* Monta la tabla con los datos */
			ArrayList<TablaInformes> listaTabla = this.fichaService
					.montarSelectTablaFichasEjecutadasDetalle(idioma,
							filterFichas, sUIDUsuario);

			/* Genera el pdf a partir de todos los datos */
			if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
				generaPdfRtf.generarXML2PDF(response, preventivos
						.getFoFichasEjecutadasDetalleXml(request, locale,
								listaTabla, filterFichas),
						Aa20bConstantes.plantillaFichasEjecTecnicoDetalleeu);

			} else {
				generaPdfRtf.generarXML2PDF(response, preventivos
						.getFoFichasEjecutadasDetalleXml(request, locale,
								listaTabla, filterFichas),
						Aa20bConstantes.plantillaFichasEjecTecnicoDetalle);
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

	}

	/**
	 * Method 'gridFichas'.
	 * 
	 * @param filterFicha
	 *            Ficha
	 * @param pagination
	 *            Pagination
	 * @param request
	 *            HttpServletRequest
	 * @param locale
	 *            Locale
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridFichas", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridFichas(@ModelAttribute Ficha filterFicha,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que pertenece el usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Gamas gama = new Gamas();
				if (filterFicha.getGama() != null) {
					gama = filterFicha.getGama();
				}
				gama.setIdservicio(usuario.getIdservicio());
				filterFicha.setGama(gama);
			} else {
				// El usuario identificado en XLNET no está dado de alta en la
				// tabla de Usuario
				// Sacar aviso y echar de la aplicación

			}
		}

		List<Ficha> partess = this.fichaService.obtenerFichasGrid(filterFicha,
				pagination, false, sUIDUsuario);

		Long recordNum = this.fichaService.obtenerFichasGridCount(filterFicha,
				false, sUIDUsuario);
		FichaController.logger
				.info("[GET - jqGrid] : Obtener Ficha preventivos pendientes de asignar tecnicos");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterFicha.getFechaD() != null) {
			try {
				filterFicha.setStrFechaD(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaD(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if (filterFicha.getFechaH() != null) {
			try {
				filterFicha.setStrFechaH(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaH(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		if (filterFicha.getFechaplanifD() != null) {
			try {
				filterFicha.setStrFechaplanifD(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaplanifD(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		if (filterFicha.getFechaplanifH() != null) {
			try {
				filterFicha.setStrFechaplanifH(Aa20bFecha.getFechaFormateada(
						filterFicha.getFechaplanifH(), locale));
			} catch (Exception e) {
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroFicha", filterFicha);
		return new JQGridJSONModel(pagination, recordNum, partess);
	}

	/**
	 * Method 'modificarObservacionesFicha'.
	 * 
	 * @param ficha
	 *            Ficha
	 * @return Maquinas
	 */
	@RequestMapping(value = "/modificarObservacionesFicha", method = RequestMethod.POST)
	public @ResponseBody
	Ficha modificarObservacionesFicha(@RequestBody Ficha ficha) {

		FichaController.logger.info("[POST] : MODIFY : Nº de ficha: "
				+ ficha.getIdficha());

		Ficha fichaAux = this.fichaService.modificarObserv(ficha);
		FichaController.logger.info("[PUT] : Ficha actualizada correctamente");
		return fichaAux;

	}
}
