package com.ejie.aa20b.control;

import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.EspacioService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Espacio;

/**
 * EspacioController generated by UDA, 28-nov-2014 11:49:07.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/espacio")
public class EspacioController {

	private static final Logger logger = LoggerFactory
			.getLogger(EspacioController.class);

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private EspacioService espacioService;

	@Autowired
	private Aa20bProcesosJMSService procesosJMSService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		EspacioController.logger.info("[GET - View] : espacio");
		return "espacio";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idespacio
	 *            Long
	 * @return espacio Espacio
	 */
	@RequestMapping(value = "/{idespacio}", method = RequestMethod.GET)
	public @ResponseBody
	Espacio getById(@PathVariable Long idespacio) {
		Espacio espacio = new Espacio();
		espacio.setIdespacio(idespacio);
		espacio = this.espacioService.find(espacio);
		EspacioController.logger
				.info("[GET - findBy_PK] : Obtener Espacio por PK");
		return espacio;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterEspacio
	 *            Espacio
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Espacio> getAll(@ModelAttribute Espacio filterEspacio) {
		EspacioController.logger
				.info("[GET - find_ALL] : Obtener Espacio por filtro");
		return this.espacioService.findAll(filterEspacio, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Espacio
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Espacio edit(@RequestBody Espacio espacio) {
		Espacio espacioAux = this.espacioService.update(espacio);
		EspacioController.logger
				.info("[PUT] : Espacio actualizado correctamente");
		return espacioAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Espacio
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Espacio add(@RequestBody Espacio espacio) {
		Espacio espacioAux = this.espacioService.add(espacio);
		EspacioController.logger
				.info("[POST] : Espacio insertado correctamente");
		return espacioAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idespacio
	 *            Long
	 * @return espacio
	 */
	@RequestMapping(value = "/{idespacio}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Espacio remove(@PathVariable Long idespacio) {
		Espacio espacio = new Espacio();
		espacio.setIdespacio(idespacio);
		this.espacioService.remove(espacio);
		EspacioController.logger
				.info("[DELETE] : Espacio borrado correctamente");
		return espacio;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param espacioIds
	 *            List
	 * @return espacioList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> espacioIds) {
		List<Espacio> espacioList = new ArrayList<Espacio>();
		for (List<String> espacioId : espacioIds) {
			Iterator<String> iterator = espacioId.iterator();
			Espacio espacio = new Espacio(); // NOPMD - Objeto nuevo en la lista
												// (parametro del servicio)
			espacio.setIdespacio(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			espacioList.add(espacio);
		}
		this.espacioService.removeMultiple(espacioList);
		EspacioController.logger
				.info("[POST - DELETE_ALL] : Espacio borrados correctamente");
		return espacioIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterEspacio
	 *            Espacio
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Espacio filterEspacio,
			@ModelAttribute Pagination pagination) {
		List<Espacio> espacios = this.espacioService.findAllLike(filterEspacio,
				pagination, false);
		Long recordNum = this.espacioService.findAllLikeCount(filterEspacio,
				false);
		EspacioController.logger.info("[GET - jqGrid] : Obtener Espacio");
		return new JQGridJSONModel(pagination, recordNum, espacios);
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/modificar", method = RequestMethod.GET)
	public String getCreateFormModficar(Model model, HttpServletRequest request) {
		EspacioController.logger.info("[GET - View] : modificar espacio");

		Long idEspacio = Long.parseLong(request.getParameter("idEspacio"));

		EspacioController.logger
				.info("[GET - View] : modificar Espacio : espacio: "
						+ idEspacio);

		Espacio espacio = this.getById(idEspacio);

		EspacioController.logger.info("[GET - View] : modificar espacio : "
				+ espacio.toString());

		/*
		 * TipoIncidenciasController.logger
		 * .info("[TIPO INCIDENCIA EN MODIFICAR : " +
		 * tipoIncidencia.getCodTipo());
		 */
		model.addAttribute("Espacio", espacio);

		request.setAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		return "editarEspacio";
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param espacio
	 *            Espacio
	 * @return Espacio
	 */
	@RequestMapping(value = "/modificaEspacio", method = RequestMethod.POST)
	public @ResponseBody
	Espacio modificaEspacio(@RequestBody Espacio espacio) {

		EspacioController.logger.info("[POST] : MODIFY : Valor de Baja : "
				+ espacio.getBaja());

		/**
		 * GMAO Comprobaremos si el espacio no se encontraba de baja. Relleno
		 */
		boolean sincronizarTodosEspaciosGmao = false;
		boolean sincronizarEspacioGmao = true;
		Espacio espacioBaja = this.getById(espacio.getIdespacio());
		/***/

		if (espacio.getBaja() == null) {
			/**
			 * GMAO Si estaba de baja significa que se ha puesto de alta ahora y
			 * hay que sincronizar con Gmao
			 */
			if (espacioBaja.getBaja() != null
					&& espacioBaja.getBaja().equals("1")) {
				sincronizarTodosEspaciosGmao = true;
			}
			espacio.setBaja("0");
		} else {
			/**
			 * GMAO Si no estaba de baja significa que se ha puesto de baja
			 * ahora y hay que sincronizar con Gmao
			 */
			if (espacioBaja.getBaja() == null
					|| (espacioBaja.getBaja() != null && espacioBaja.getBaja()
							.equals("0"))) {
				sincronizarTodosEspaciosGmao = true;
			} else {
				// Si estaba de baja y sigue de baja no actualizamos GMAO
				sincronizarEspacioGmao = false;
			}
			/***/
			espacio.setBaja("1");
		}
		EspacioController.logger.info("[PUT] : Espacio antes de modificar : "
				+ espacio.toString());
		Espacio espacioAux = this.espacioService.update(espacio);
		EspacioController.logger
				.info("[PUT] : Espacio actualizado correctamente");

		/**
		 * GMAO - Si la actualización del espacio ha ido bien, generamos un
		 * mensaje en la cola para actualizar la entidad 'estancia' en BBDD
		 * movilgmao. Si se ha puesto de baja, se deben sincronizar todas las
		 * entidades 'estancia'
		 */
		if (sincronizarTodosEspaciosGmao) {
			Espacio espacioFilter = new Espacio();
			espacioFilter.setBaja("0");
			List<Espacio> espacios = this.espacioService.findAll(espacioFilter,
					null);

			/**
			 * GMAO Sincronizacion de todos laz estancias
			 */
			String urlConfig = "";
			try {
				urlConfig = this.appConfiguration.getObject().getProperty(
						"movilgmao.path");
			} catch (Exception e) {

			}
			this.procesosJMSService.sincronizarTodasEstanciasGmao(espacios,
					Aa20bConstantes.COLA, urlConfig);
		} else {

			if (sincronizarEspacioGmao) {
				EspacioController.logger
						.info("[JMS] notificar modificación estancia movilgmao");

				this.procesosJMSService.sincronizarEstanciaGmao(espacio);
			}

		}
		return espacioAux;
	}

	@RequestMapping(value = "/addNuevaEspacio", method = RequestMethod.POST)
	public @ResponseBody
	Espacio addNuevaEspacio(@RequestBody Espacio espacio, Model model) {

		EspacioController.logger.info("[POST] : ENTRAMOS EN ADD espacio");

		EspacioController.logger.info("[POST] : ADD : espacio : "
				+ espacio.toString());
		espacio.setBaja("0");
		Espacio espacioAux = this.espacioService.add(espacio);
		EspacioController.logger
				.info("[POST] : espacio insertado correctamente");

		/**
		 * GMAO Sincronizacion de todos laz estancias
		 */

		EspacioController.logger
				.info("[JMS] notificar modificación estancia movilgmao");

		this.procesosJMSService.sincronizarEstanciaGmao(espacio);

		return espacioAux;
	}

	/**
	 * Method 'getCreateForm2'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "nuevo", method = RequestMethod.GET)
	public String getCreateForm2(Model model, HttpServletRequest request) {
		EspacioController.logger.info("[GET - View] : nuevo Espacio");
		model.addAttribute("accion", Aa20bConstantes.ACCION_NUEVO);

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);
		return "editarEspacio";
	}

	/**
	 * Method 'obtenerEspaciosAlta'.
	 * 
	 * @param filterEspacio
	 *            Espacio
	 * @return List
	 */
	@RequestMapping(value = "espaciosAlta/obtenerEspaciosAlta", method = RequestMethod.POST)
	public @ResponseBody
	List<Espacio> obtenerEspaciosAlta(@ModelAttribute Espacio filterEspacio) {
		EspacioController.logger
				.info("[GET - obtenerTiposAlta] : Obtener Espacios en Alta");
		return this.espacioService.obtenerEspaciosAlta(filterEspacio);
	}
}
