package com.ejie.aa20b.control;

import com.ejie.aa20b.service.EdificiosverService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.Edificiosver;

/**
 * EdificiosverController generated by UDA, 13-mar-2015 12:21:21.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/edificiosver")
public class EdificiosverController {

	private static final Logger logger = LoggerFactory
			.getLogger(EdificiosverController.class);

	@Autowired
	private EdificiosverService edificiosverService;

	@Autowired
	private UsuarioXLNETController usuarioXLNETController;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		EdificiosverController.logger.info("[GET - View] : edificiosver");
		return "edificiosver";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param uidPer
	 *            String
	 * @param idedificio
	 *            String
	 * @return edificiosver Edificiosver
	 */
	@RequestMapping(value = "/{uidPer}/{idedificio}", method = RequestMethod.GET)
	public @ResponseBody
	Edificiosver getById(@PathVariable String uidPer,
			@PathVariable String idedificio) {
		Edificiosver edificiosver = new Edificiosver();
		edificiosver.setUidPer(uidPer);
		edificiosver.setIdedificio(idedificio);
		edificiosver = this.edificiosverService.find(edificiosver);
		EdificiosverController.logger
				.info("[GET - findBy_PK] : Obtener Edificiosver por PK");
		return edificiosver;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterEdificiosver
	 *            Edificiosver
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Edificiosver> getAll(@ModelAttribute Edificiosver filterEdificiosver) {
		EdificiosverController.logger
				.info("[GET - find_ALL] : Obtener Edificiosver por filtro");
		return this.edificiosverService.findAll(filterEdificiosver, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Edificiosver edit(@RequestBody Edificiosver edificiosver) {
		Edificiosver edificiosverAux = this.edificiosverService
				.update(edificiosver);
		EdificiosverController.logger
				.info("[PUT] : Edificiosver actualizado correctamente");
		return edificiosverAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param edificiosver
	 *            Edificiosver
	 * @return Edificiosver
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Edificiosver add(@RequestBody Edificiosver edificiosver) {
		Edificiosver edificiosverAux = this.edificiosverService
				.add(edificiosver);
		EdificiosverController.logger
				.info("[POST] : Edificiosver insertado correctamente");
		return edificiosverAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param uidPer
	 *            String
	 * @param idedificio
	 *            String
	 * @return edificiosver
	 */
	@RequestMapping(value = "/{uidPer}/{idedificio}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Edificiosver remove(@PathVariable String uidPer,
			@PathVariable String idedificio) {
		Edificiosver edificiosver = new Edificiosver();
		edificiosver.setUidPer(uidPer);
		edificiosver.setIdedificio(idedificio);
		this.edificiosverService.remove(edificiosver);
		EdificiosverController.logger
				.info("[DELETE] : Edificiosver borrado correctamente");
		return edificiosver;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param edificiosverIds
	 *            List
	 * @return edificiosverList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> edificiosverIds) {
		List<Edificiosver> edificiosverList = new ArrayList<Edificiosver>();
		for (List<String> edificiosverId : edificiosverIds) {
			Iterator<String> iterator = edificiosverId.iterator();
			Edificiosver edificiosver = new Edificiosver(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			edificiosver.setUidPer(ObjectConversionManager.convert(
					iterator.next(), String.class));
			edificiosver.setIdedificio(ObjectConversionManager.convert(
					iterator.next(), String.class));
			edificiosverList.add(edificiosver);
		}
		this.edificiosverService.removeMultiple(edificiosverList);
		EdificiosverController.logger
				.info("[POST - DELETE_ALL] : Edificiosver borrados correctamente");
		return edificiosverIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterEdificiosver
	 *            Edificiosver
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute Edificiosver filterEdificiosver,
			@ModelAttribute Pagination pagination) {
		List<Edificiosver> edificiosvers = this.edificiosverService.findAll(
				filterEdificiosver, pagination);
		Long recordNum = this.edificiosverService
				.findAllCount(filterEdificiosver);
		EdificiosverController.logger
				.info("[GET - jqGrid] : Obtener Edificiosver");
		return new JQGridJSONModel(pagination, recordNum, edificiosvers);
	}

	/**
	 * Method 'obtenerEdificiosUsuarioAsignados'.
	 * 
	 * @param idEdificio
	 *            Integer
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerEdificiosUsuarioAsignados", method = RequestMethod.POST)
	public @ResponseBody
	List<Edificiosver> obtenerEdificiosUsuarioAsignados(String idUsuario) {
		EdificiosverController.logger
				.info("[GET - obtenerEdificiosUsuarioAsignados] : Obtener Edificios asignados al usuario");
		List<Edificiosver> listaEdificios = this.edificiosverService
				.obtenerEdificiosUsuarioAsignados(idUsuario);

		return listaEdificios;
	}

	/**
	 * Method 'obtenerEdificiosUsuarioLibres'.
	 * 
	 * @param idEdificio
	 *            Integer
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerEdificiosUsuarioLibres", method = RequestMethod.POST)
	public @ResponseBody
	List<Edificiosver> obtenerEdificiosUsuarioLibres(String idUsuario) {
		EdificiosverController.logger
				.info("[GET - obtenerEdificiosUsuarioLibres] : Obtener Edificios no asignados al usuario");
		List<Edificiosver> listaEdificios = this.edificiosverService
				.obtenerEdificiosUsuarioLibres(idUsuario);

		return listaEdificios;
	}

	@RequestMapping(value = "/sumaEdificios", method = RequestMethod.POST)
	public @ResponseBody
	Edificiosver sumaEdificios(@RequestParam String idUsuario,
			@RequestParam ArrayList<String> edificiosSeleccionados,
			Model model, HttpServletRequest request) {

		Edificiosver usuedificiosAux = new Edificiosver();
		Edificiosver elEdificiosver = new Edificiosver();

		for (int i = 0; i < edificiosSeleccionados.size(); i++) {
			elEdificiosver.setUidPer(idUsuario);
			elEdificiosver.setVer("1");
			elEdificiosver.setIdedificio(edificiosSeleccionados.get(i));
			EdificiosverController.logger
					.info("[GET - findBy_PK] : Grabando edificios usuario : "
							+ elEdificiosver.getIdedificio());

			usuedificiosAux = this.edificiosverService.add(elEdificiosver);
		}

		EdificiosverController.logger
				.info("[GET - SUMA EDIFICIOS] : EDIFICIOS: "
						+ edificiosSeleccionados.size());

		return usuedificiosAux;
	}

	@RequestMapping(value = "/restaEdificios", method = RequestMethod.POST)
	public @ResponseBody
	Edificiosver restaEdificios(@RequestParam String idUsuario,
			@RequestParam ArrayList<String> edificiosSeleccionados,
			Model model, HttpServletRequest request) {

		Edificiosver EdificiosverAux = new Edificiosver();
		Edificiosver elEdificiosver = new Edificiosver();

		for (int i = 0; i < edificiosSeleccionados.size(); i++) {
			elEdificiosver.setUidPer(idUsuario);
			elEdificiosver.setIdedificio(edificiosSeleccionados.get(i));

			/* execute */
			this.edificiosverService.remove(elEdificiosver);
		}

		EdificiosverController.logger
				.info("[GET - RESTA EDIFICIOS] : EDIFICIOS: "
						+ edificiosSeleccionados.size());

		return EdificiosverAux;
	}

	/**
	 * Method 'obtenerEdificiosUsuarioNOVer'.
	 * 
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerEdificiosUsuarioNOVer", method = RequestMethod.POST)
	public @ResponseBody
	List<Edificiosver> obtenerEdificiosUsuarioNOVer(HttpServletRequest request,
			String idTerri) {
		EdificiosverController.logger
				.info("[GET - obtenerEdificiosUsuarioNOVer] : Obtener Edificios del usuario marcados para NO ver");
		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		List<Edificiosver> listaEdificios = this.edificiosverService
				.obtenerEdificiosUsuarioNOVer(sUIDUsuario, idTerri);

		return listaEdificios;
	}

	/**
	 * Method 'obtenerEdificiosUsuarioVer'.
	 * 
	 * 
	 * @return List
	 */
	@RequestMapping(value = "obtenerEdificiosUsuarioVer", method = RequestMethod.POST)
	public @ResponseBody
	List<Edificiosver> obtenerEdificiosUsuarioVer(HttpServletRequest request,
			String idTerri) {
		EdificiosverController.logger
				.info("[GET - obtenerEdificiosUsuarioNOVer] : Obtener Edificios del usuario marcados para ver");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		List<Edificiosver> listaEdificios = this.edificiosverService
				.obtenerEdificiosUsuarioVer(sUIDUsuario, idTerri);

		return listaEdificios;
	}

	@RequestMapping(value = "/sumaEdificiosVer", method = RequestMethod.POST)
	public @ResponseBody
	Edificiosver sumaEdificiosVer(
			@RequestParam ArrayList<String> edificiosSeleccionados,
			Model model, HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Edificiosver usuedificiosAux = new Edificiosver();
		Edificiosver elEdificiosver = new Edificiosver();

		for (int i = 0; i < edificiosSeleccionados.size(); i++) {
			elEdificiosver.setUidPer(sUIDUsuario);
			elEdificiosver.setIdedificio(edificiosSeleccionados.get(i));
			EdificiosverController.logger
					.info("[GET - RESTA EDIFICIOS ver] : Grabando edificios usuario para VER : "
							+ elEdificiosver.getIdedificio());

			usuedificiosAux = this.edificiosverService
					.marcarVer(elEdificiosver);
		}

		EdificiosverController.logger
				.info("[GET - SUMA EDIFICIOS] : EDIFICIOS: "
						+ edificiosSeleccionados.size());

		return usuedificiosAux;
	}

	@RequestMapping(value = "/restaEdificiosVer", method = RequestMethod.POST)
	public @ResponseBody
	Edificiosver restaEdificiosVer(
			@RequestParam ArrayList<String> edificiosSeleccionados,
			Model model, HttpServletRequest request) {
		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Edificiosver EdificiosverAux = new Edificiosver();
		Edificiosver elEdificiosver = new Edificiosver();

		for (int i = 0; i < edificiosSeleccionados.size(); i++) {
			elEdificiosver.setUidPer(sUIDUsuario);
			elEdificiosver.setIdedificio(edificiosSeleccionados.get(i));

			this.edificiosverService.marcarNOVer(elEdificiosver);
		}

		EdificiosverController.logger
				.info("[GET - RESTA EDIFICIOS] : Grabando edificios usuario para NO VER : "
						+ edificiosSeleccionados.size());

		return EdificiosverAux;
	}
}
