package com.ejie.aa20b.control;

import com.ejie.aa20b.service.EdificiosXlnetService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.model.EdificiosXlnet;

/**
 * EdificiosXlnetController generated by UDA, 13-feb-2015 12:34:52.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/edificiosxlnet")
public class EdificiosXlnetController {

	private static final Logger logger = LoggerFactory
			.getLogger(EdificiosXlnetController.class);

	@Autowired
	private EdificiosXlnetService edificiosXlnetService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		EdificiosXlnetController.logger.info("[GET - View] : edificiosxlnet");
		return "edificiosxlnet";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param n38uidedificio
	 *            String
	 * @return edificiosXlnet EdificiosXlnet
	 */
	@RequestMapping(value = "/{n38uidedificio}", method = RequestMethod.GET)
	public @ResponseBody
	EdificiosXlnet getById(@PathVariable String n38uidedificio) {
		EdificiosXlnet edificiosXlnet = new EdificiosXlnet();
		edificiosXlnet.setN38uidedificio(n38uidedificio);
		edificiosXlnet = this.edificiosXlnetService.find(edificiosXlnet);
		EdificiosXlnetController.logger
				.info("[GET - findBy_PK] : Obtener EdificiosXlnet por PK");
		return edificiosXlnet;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterEdificiosXlnet
	 *            EdificiosXlnet
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<EdificiosXlnet> getAll(
			@ModelAttribute EdificiosXlnet filterEdificiosXlnet) {
		EdificiosXlnetController.logger
				.info("[GET - find_ALL] : Obtener EdificiosXlnet por filtro");
		return this.edificiosXlnetService.findAll(filterEdificiosXlnet, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param edificiosXlnet
	 *            EdificiosXlnet
	 * @return EdificiosXlnet
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	EdificiosXlnet edit(@RequestBody EdificiosXlnet edificiosXlnet) {
		EdificiosXlnet edificiosXlnetAux = this.edificiosXlnetService
				.update(edificiosXlnet);
		EdificiosXlnetController.logger
				.info("[PUT] : EdificiosXlnet actualizado correctamente");
		return edificiosXlnetAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param edificiosXlnet
	 *            EdificiosXlnet
	 * @return EdificiosXlnet
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	EdificiosXlnet add(@RequestBody EdificiosXlnet edificiosXlnet) {
		EdificiosXlnet edificiosXlnetAux = this.edificiosXlnetService
				.add(edificiosXlnet);
		EdificiosXlnetController.logger
				.info("[POST] : EdificiosXlnet insertado correctamente");
		return edificiosXlnetAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param n38uidedificio
	 *            String
	 * @return edificiosXlnet
	 */
	@RequestMapping(value = "/{n38uidedificio}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	EdificiosXlnet remove(@PathVariable String n38uidedificio) {
		EdificiosXlnet edificiosXlnet = new EdificiosXlnet();
		edificiosXlnet.setN38uidedificio(n38uidedificio);
		this.edificiosXlnetService.remove(edificiosXlnet);
		EdificiosXlnetController.logger
				.info("[DELETE] : EdificiosXlnet borrado correctamente");
		return edificiosXlnet;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param edificiosXlnetIds
	 *            List
	 * @return edificiosXlnetList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> edificiosXlnetIds) {
		List<EdificiosXlnet> edificiosXlnetList = new ArrayList<EdificiosXlnet>();
		for (List<String> edificiosXlnetId : edificiosXlnetIds) {
			Iterator<String> iterator = edificiosXlnetId.iterator();
			EdificiosXlnet edificiosXlnet = new EdificiosXlnet(); // NOPMD -
																	// Objeto
																	// nuevo en
																	// la lista
																	// (parametro
																	// del
																	// servicio)
			edificiosXlnet.setN38uidedificio(ObjectConversionManager.convert(
					iterator.next(), String.class));
			edificiosXlnetList.add(edificiosXlnet);
		}
		this.edificiosXlnetService.removeMultiple(edificiosXlnetList);
		EdificiosXlnetController.logger
				.info("[POST - DELETE_ALL] : EdificiosXlnet borrados correctamente");
		return edificiosXlnetIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterEdificiosXlnet
	 *            EdificiosXlnet
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute EdificiosXlnet filterEdificiosXlnet,
			@ModelAttribute Pagination pagination) {
		List<EdificiosXlnet> edificiosXlnets = this.edificiosXlnetService
				.findAllLike(filterEdificiosXlnet, pagination, false);
		Long recordNum = this.edificiosXlnetService.findAllLikeCount(
				filterEdificiosXlnet, false);
		EdificiosXlnetController.logger
				.info("[GET - jqGrid] : Obtener EdificiosXlnet");
		return new JQGridJSONModel(pagination, recordNum, edificiosXlnets);
	}

	/**
	 * Method 'getListaEdificiosXLNET'. vacia la tabla de EdificiosXLNET y la
	 * vuelve a cargar con los edificios que se obtienen de XLNET.
	 * 
	 * 
	 * @return Boolean
	 * @throws SecurityHelpperException
	 */
	@RequestMapping(value = "listaEdificiosXLNET", method = RequestMethod.POST)
	public @ResponseBody
	Boolean getListaEdificiosXLNET() {
		logger.info("[GET - View] : obtener edificios de XLNET");
		return this.edificiosXlnetService.getListaEdificiosXLNETs();
	}

	/**
	 * Method 'obtenerEdificiosXLNET'.
	 * 
	 * @param idEdificio
	 *            String
	 * @param idParte
	 *            Integer
	 * @return List
	 */
	@RequestMapping(value = "obtenerEdificiosXLNET", method = RequestMethod.POST)
	public @ResponseBody
	List<EdificiosXlnet> obtenerTecnicosParteLibres(String idEdificio) {
		EdificiosXlnetController.logger
				.info("[GET - obtenerEdificiosXLNET] : Obtener Edificios de la tabla de Edificios_XLNET");

		EdificiosXlnet edificioXLNET = new EdificiosXlnet();
		edificioXLNET.setN38uidedificio(idEdificio);
		List<EdificiosXlnet> listaEdificiosXLNET = this.edificiosXlnetService
				.findAllLike(edificioXLNET, null, false);

		return listaEdificiosXLNET;
	}

}
