package com.ejie.aa20b.control;

import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.Aa20bUsuarioXLNETService;
import com.ejie.aa20b.service.EdificiosService;
import com.ejie.aa20b.service.TecnicoEdifService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.json.JSONArray;
import com.ejie.x38.json.JSONObject;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.TecnicoEdif;

/**
 * EdificiosController generated by UDA, 28-nov-2014 11:32:27.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/edificios")
public class EdificiosController {

	private static final Logger logger = LoggerFactory
			.getLogger(EdificiosController.class);

	@Autowired
	private EdificiosService edificiosService;

	@Autowired
	private TecnicoEdifService tecnicoEdifService;

	@Autowired
	private Aa20bUsuarioXLNETService usuarioXLNETService;

	@Autowired
	private Aa20bProcesosJMSService procesosJMSService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		EdificiosController.logger.info("[GET - View] : edificios");

		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroEdificios");

		return "edificios";
	}

	/**
	 * Method 'maintVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintVolver", method = RequestMethod.GET)
	public String maintVolver(Model model, HttpServletRequest request) {
		EdificiosController.logger.info("[GET - View] : edificios");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Edificios edificioFiltro = (Edificios) request.getSession()
				.getAttribute("FiltroEdificios");

		model.addAttribute("FiltroEdificio", edificioFiltro);

		return "edificios";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idedificio
	 *            String
	 * @param cedificio
	 *            String
	 * @param eedificio
	 *            String
	 * @param baja
	 *            String
	 * @return edificios Edificios
	 */
	@RequestMapping(value = "/{idedificio}/{cedificio}/{eedificio}/{baja}/{gestCentra}", method = RequestMethod.GET)
	public @ResponseBody
	Edificios getById(@PathVariable String idedificio,
			@PathVariable String cedificio, @PathVariable String eedificio,
			@PathVariable String baja, @PathVariable String gestCentra) {
		Edificios edificios = new Edificios();
		edificios.setIdedificio(idedificio);
		edificios.setCedificio(cedificio);
		edificios.setEedificio(eedificio);
		edificios.setBaja(baja);
		edificios.setGestCentra(gestCentra);
		edificios = this.edificiosService.find(edificios);
		EdificiosController.logger
				.info("[GET - findBy_PK] : Obtener Edificios por PK");
		return edificios;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterEdificios
	 *            Edificios
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Edificios> getAll(@ModelAttribute Edificios filterEdificios) {
		EdificiosController.logger
				.info("[GET - find_ALL] : Obtener Edificios por filtro");
		return this.edificiosService.findAll(filterEdificios, null);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idEdificioBusc
	 *            String
	 * @param ventanaOrigen
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return editarEdificio String
	 */
	@RequestMapping(value = "/buscarEdificio", method = RequestMethod.POST)
	public String getById(@RequestParam String idEdificioBusc,
			@RequestParam String ventanaOrigen, Model model,
			HttpServletRequest request) {

		EdificiosController.logger.info("[GET - findBy_PK] : Edificio");

		Edificios edificio = new Edificios();

		edificio = this.edificiosService.obtenerEdificio(idEdificioBusc);

		EdificiosController.logger.info("[GET - findBy_PK] : Edificio: "
				+ edificio.toString());

		model.addAttribute("Edificio", edificio);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		return "editarEdificio";
	}

	/**
	 * Method 'nuevoEdificio'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/nuevoEdificio", method = RequestMethod.GET)
	public String nuevoEdificio(Model model) {

		EdificiosController.logger.info("[GET - View] : nuevo edificio");
		return "nuevoEdificio";
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Edificios edit(@RequestBody Edificios edificios) {
		/*
		 * if (edificios.getBaja() == null) edificios.setBaja("0"); else
		 * edificios.setBaja("1");
		 */
		Edificios edificiosAux = this.edificiosService.update(edificios);
		EdificiosController.logger
				.info("[PUT] : Edificios actualizado correctamente");

		return edificiosAux;
	}

	/**
	 * Method 'modificarEdificio'.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	@RequestMapping(value = "modificarEdificio", method = RequestMethod.POST)
	public @ResponseBody
	Edificios modificarEdificio(@RequestBody Edificios edificios) {

		/**
		 * GMAO Comprobaremos si el edificio no se encontraba de baja. Relleno
		 * el campo guid con el valor de la BBDD para no crear un duplicado en
		 * GMAO
		 */
		boolean sincronizarActivoGmao = false;
		boolean sincronizarClienteGmao = true;
		Edificios edificioBaja = this.edificiosService
				.obtenerEdificio(edificios.getIdedificio());
		edificios.setGuidedificio(edificioBaja.getGuidedificio());
		/***/

		if (edificios.getBaja() == null) {
			/**
			 * GMAO Si estaba de baja significa que se ha puesto de alta ahora y
			 * hay que sincronizar con Gmao
			 */
			if (edificioBaja.getBaja() != null
					&& edificioBaja.getBaja().equals("1")) {
				sincronizarActivoGmao = true;
			}
			/***/

			edificios.setBaja("0");
		} else {
			/**
			 * GMAO Si no estaba de baja significa que se ha puesto de baja
			 * ahora y hay que sincronizar con Gmao
			 */
			if (edificioBaja.getBaja() == null
					|| (edificioBaja.getBaja() != null && edificioBaja
							.getBaja().equals("0"))) {
				sincronizarActivoGmao = true;
			} else {
				// Si estaba de baja y sigue de baja no actualizamos GMAO
				sincronizarClienteGmao = false;
			}
			/***/

			edificios.setBaja("1");
		}
		Edificios edificiosAux = this.edificiosService.update(edificios);
		EdificiosController.logger
				.info("[PUT] : Edificios actualizado correctamente");

		/**
		 * GMAO - Si la actualización del edificio ha ido bien generamos un
		 * mensaje en la cola para actualizar el edificio y su activo en BBDD
		 * movilgmao. Se comprueba que el registro tengo guid y sino tiene se
		 * genera y guarda
		 */
		if (sincronizarActivoGmao) {
			if (edificios.getGuidedificio() == null
					|| (edificios.getGuidedificio() != null && edificios
							.getGuidedificio().trim().equals(""))) {
				String randomUUIDString = "";
				UUID uuid = UUID.randomUUID();
				randomUUIDString = uuid.toString();
				edificios.setGuidedificio(randomUUIDString);
				this.edificiosService.actualizarUUIDedificio(edificios);
			}
		}
		if (sincronizarClienteGmao) {
			EdificiosController.logger
					.info("[JMS] notificar modificación edificio movilgmao");

			this.procesosJMSService.notificarCambioDatosJMS(
					Aa20bConstantes.OPER_MANT_EDIF,
					Aa20bConstantes.CLASE_EDIFICIOS, edificios);
		}

		return edificiosAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Edificios add(@RequestBody Edificios edificios) {
		// edificios.setBaja("0");
		Edificios edificiosAux = this.edificiosService.add(edificios);
		EdificiosController.logger
				.info("[POST] : Edificios insertado correctamente");

		return edificiosAux;
	}

	/**
	 * Method 'existeEdificio'.
	 * 
	 * @param idEdificioBusc
	 *            String
	 * @return Boolean
	 */
	@RequestMapping(value = "/existeEdificio", method = RequestMethod.GET)
	public @ResponseBody
	Boolean existeEdificio(String idedificio) {

		EdificiosController.logger.info("[GET - existeEdificio] : Edificio");

		// Validar que no existe ya un edificio con el mismo código

		Edificios edificio = new Edificios();
		edificio = this.edificiosService.obtenerEdificio(idedificio);
		if (edificio == null) {
			EdificiosController.logger
					.info("[GET - existeEdificio] : No existe el Edificio: ");
			return false;
		} else {
			EdificiosController.logger
					.info("[GET - existeEdificio] : Existe Edificio: ");
			return true;
		}

	}

	/**
	 * Method 'add'.
	 * 
	 * @param edificios
	 *            Edificios
	 * @return Edificios
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.POST)
	public @ResponseBody
	Edificios alta(@RequestBody Edificios edificios) {

		Date fechaHoy = new Date();
		edificios.setFeini(fechaHoy);
		// edificios.setBaja("0");

		if (edificios.getGestCentra() == null) {
			edificios.setGestCentra("0");
		}

		/**
		 * Obtener codigo GUID
		 */
		String randomUUIDString = "";
		UUID uuid = UUID.randomUUID();
		randomUUIDString = uuid.toString();
		edificios.setGuidedificio(randomUUIDString);

		Edificios edificiosAux = this.edificiosService.nuevoEdificio(edificios);
		EdificiosController.logger
				.info("[POST] : Edificios insertado correctamente");

		// Si la creación del edificio ha ido bien generamos
		// un mensaje en la cola para insertar el registro del edificio en BBDD
		// movilgmao
		EdificiosController.logger
				.info("[JMS] notificar creación edificio movilgmao");
		this.procesosJMSService.notificarCambioDatosJMS(
				Aa20bConstantes.OPER_MANT_EDIF,
				Aa20bConstantes.CLASE_EDIFICIOS, edificios);

		return edificiosAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idedificio
	 *            String
	 * @param cedificio
	 *            String
	 * @param eedificio
	 *            String
	 * @param baja
	 *            String
	 * @return edificios
	 */
	@RequestMapping(value = "/{idedificio}/{cedificio}/{eedificio}/{baja}/{gestCentra}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Edificios remove(@PathVariable String idedificio,
			@PathVariable String cedificio, @PathVariable String eedificio,
			@PathVariable String baja, @PathVariable String gestCentra) {
		Edificios edificios = new Edificios();
		edificios.setIdedificio(idedificio);
		edificios.setCedificio(cedificio);
		edificios.setEedificio(eedificio);
		edificios.setBaja(baja);
		edificios.setGestCentra(gestCentra);
		this.edificiosService.remove(edificios);
		EdificiosController.logger
				.info("[DELETE] : Edificios borrado correctamente");
		return edificios;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param edificiosIds
	 *            List
	 * @return edificiosList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> edificiosIds) {
		List<Edificios> edificiosList = new ArrayList<Edificios>();
		for (List<String> edificiosId : edificiosIds) {
			Iterator<String> iterator = edificiosId.iterator();
			Edificios edificios = new Edificios(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			edificios.setIdedificio(ObjectConversionManager.convert(
					iterator.next(), String.class));
			edificios.setCedificio(ObjectConversionManager.convert(
					iterator.next(), String.class));
			edificios.setEedificio(ObjectConversionManager.convert(
					iterator.next(), String.class));
			edificios.setBaja(ObjectConversionManager.convert(iterator.next(),
					String.class));
			edificios.setGestCentra(ObjectConversionManager.convert(
					iterator.next(), String.class));
			edificiosList.add(edificios);
		}
		this.edificiosService.removeMultiple(edificiosList);
		EdificiosController.logger
				.info("[POST - DELETE_ALL] : Edificios borrados correctamente");
		return edificiosIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterEdificios
	 *            Edificios
	 * @param pagination
	 *            Pagination
	 * @param locale
	 *            Locale
	 * @param request
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Edificios filterEdificios,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {
		if (filterEdificios.getBaja() != null
				&& filterEdificios.getBaja().equals("on")) {
			filterEdificios.setBaja("1");
		}
		if (filterEdificios.getGestCentra() != null
				&& filterEdificios.getGestCentra().equals("on")) {
			filterEdificios.setGestCentra("1");
		}

		List<Edificios> edificioss = this.edificiosService.obtenerEdificios(
				filterEdificios, pagination, false);
		Long recordNum = this.edificiosService.obtenerEdificiosCount(
				filterEdificios, false);
		EdificiosController.logger.info("[GET - jqGrid] : Obtener Edificios");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterEdificios.getFeini() != null) {
			try {
				filterEdificios.setStrFeini(Aa20bFecha.getFechaFormateada(
						filterEdificios.getFeini(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroEdificios", filterEdificios);

		return new JQGridJSONModel(pagination, recordNum, edificioss);
	}

	/**
	 * Method 'getRemoteComboEdificios'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "edificiosAltaUsuario/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Edificios> getRemoteComboEdificios(Model model) {
		EdificiosController.logger.info("[GET - View] : edificiosAltaUsuario");

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETService.obtenerUIDUsuario();
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		Edificios edificios = new Edificios();
		edificios.setBaja("0");

		List<Edificios> listEdificios = this.edificiosService
				.obtenerEdificiosUsuario(edificios, null, null, sUIDUsuario);

		model.addAttribute("edificios", listEdificios);
		return listEdificios;
	}

	/**
	 * Method 'obtenerEdificiosTecnicoLibres'.Obtener de los Edificios asociados
	 * al Usuario que se ha identificado en XLNET aquellos que estan asociados
	 * al tecnico seleccionado
	 * 
	 * @param idTecnico
	 *            Integer
	 * @param UIDPuesto
	 *            String
	 * @return List
	 */
	@RequestMapping(value = "obtenerEdificiosTecnicoLibres", method = RequestMethod.POST)
	public @ResponseBody
	List<Edificios> obtenerEdificiosTecnicoLibres(Integer idTecnico,
			String UIDPuesto) {
		EdificiosController.logger
				.info("[GET - obtenerEdificiosTecnicoLibres] : ");
		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETService.obtenerUIDUsuario();
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		List<Edificios> listaEdificios = this.edificiosService
				.obtenerEdificiosTecnicoLibres(idTecnico, sUIDUsuario);

		return listaEdificios;
	}

	/**
	 * Method 'obtenerEdificiosTecnicoOcupados'.
	 * 
	 * @param idTecnico
	 *            Integer
	 * @param UIDPuesto
	 *            String
	 * @return List
	 */
	@RequestMapping(value = "obtenerEdificiosTecnicoOcupados", method = RequestMethod.POST)
	public @ResponseBody
	List<Edificios> obtenerEdificiosTecnicoOcupados(Integer idTecnico) {
		EdificiosController.logger
				.info("[GET - obtenerEdificiosTecnicoLibres] : Obtener de los Edificios asociados al UID PUESTO aquellos que estan asociados al tecnico seleccionado");
		List<Edificios> listaEdificios = this.edificiosService
				.obtenerEdificiosTecnicoOcupados(idTecnico);

		return listaEdificios;
	}

	@RequestMapping(value = "/sumaEdificiosTecnico", method = RequestMethod.POST)
	public @ResponseBody
	TecnicoEdif sumaEdificiosTecnico(@RequestParam Long idTecnico,
			@RequestParam ArrayList<String> edificiosSeleccionados,
			Model model, HttpServletRequest request) {

		TecnicoEdif edificioTecnicoAux = new TecnicoEdif();
		TecnicoEdif elEdificioTecnico = new TecnicoEdif();

		for (int i = 0; i < edificiosSeleccionados.size(); i++) {
			elEdificioTecnico.setIdtecnico(idTecnico);
			elEdificioTecnico.setIdedificio(edificiosSeleccionados.get(i));
			EdificiosController.logger
					.info("[GET - findBy_PK] : Asignando Edificios al técnico: "
							+ elEdificioTecnico.getIdtecnico());

			edificioTecnicoAux = this.tecnicoEdifService.add(elEdificioTecnico);
		}

		EdificiosController.logger.info("[GET - SUMA EDIFICIOS] : Edificios: "
				+ edificiosSeleccionados.size());

		return edificioTecnicoAux;
	}

	@RequestMapping(value = "/restaEdificiosTecnico", method = RequestMethod.POST)
	public @ResponseBody
	TecnicoEdif restaEdificiosTecnico(@RequestParam Long idTecnico,
			@RequestParam ArrayList<String> edificiosSeleccionados,
			Model model, HttpServletRequest request) {

		TecnicoEdif tecnicoParteAux = new TecnicoEdif();
		TecnicoEdif elEdificioTecnico = new TecnicoEdif();

		for (int i = 0; i < edificiosSeleccionados.size(); i++) {
			elEdificioTecnico.setIdtecnico(idTecnico);
			elEdificioTecnico.setIdedificio(edificiosSeleccionados.get(i));
			EdificiosController.logger
					.info("[GET - findBy_PK] : Eliminando Edificios al técnico : "
							+ elEdificioTecnico.getIdtecnico());
			/* execute */
			this.tecnicoEdifService.quitarEdificioATecnico(elEdificioTecnico);
			EdificiosController.logger
					.info("[DELETE] : TecnicoEdif borrado correctamente");
		}

		EdificiosController.logger.info("[GET - RESTA EDIFICIOS] : EDIFICIOS: "
				+ edificiosSeleccionados.size());

		return tecnicoParteAux;
	}

	/**
	 * Method 'edificiosConPlanos'.
	 * 
	 * @param model
	 * 
	 * @return List
	 */
	@RequestMapping(value = "edificiosConPlanos/combo/remote", method = RequestMethod.GET)
	public @ResponseBody
	List<Edificios> edificiosConPlanos(Model model) {
		EdificiosController.logger.info("[GET - View] : obtenercomboedificios");
		model.addAttribute("edificios",
				this.edificiosService.obtenerEdificiosConPlanos());
		return this.edificiosService.obtenerEdificiosConPlanos();
	}

}
