package com.ejie.aa20b.control;

import com.ejie.aa20b.service.DireccionesService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa20b.model.Direcciones;

/**
 * DireccionesController generated by UDA, 28-nov-2014 11:32:27.
 * @author UDA
 */
 
@Controller
@RequestMapping (value = "/direcciones")

public class DireccionesController  {

	private static final Logger logger = LoggerFactory.getLogger(DireccionesController.class);

	@Autowired
	private DireccionesService direccionesService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		DireccionesController.logger.info("[GET - View] : direcciones");
		return "direcciones";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param iddir Integer
	 * @return direcciones Direcciones
	 */
	@RequestMapping(value = "/{iddir}", method = RequestMethod.GET)
	public @ResponseBody Direcciones getById(@PathVariable Integer iddir) {
        Direcciones direcciones = new Direcciones();
		direcciones.setIddir(iddir);
        direcciones = this.direccionesService.find(direcciones);
        DireccionesController.logger.info("[GET - findBy_PK] : Obtener Direcciones por PK");
        return direcciones;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterDirecciones Direcciones
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Direcciones> getAll(@ModelAttribute Direcciones filterDirecciones) {
		DireccionesController.logger.info("[GET - find_ALL] : Obtener Direcciones por filtro");
	    return this.direccionesService.findAll(filterDirecciones, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param direcciones Direcciones 
	 * @return Direcciones
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Direcciones edit(@RequestBody Direcciones direcciones) {		
        Direcciones direccionesAux = this.direccionesService.update(direcciones);
		DireccionesController.logger.info("[PUT] : Direcciones actualizado correctamente");
        return direccionesAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param direcciones Direcciones 
	 * @return Direcciones
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Direcciones add(@RequestBody Direcciones direcciones) {		
        Direcciones direccionesAux = this.direccionesService.add(direcciones);
        DireccionesController.logger.info("[POST] : Direcciones insertado correctamente");
    	return direccionesAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param iddir Integer
	 * @return direcciones
	 */
	@RequestMapping(value = "/{iddir}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Direcciones remove(@PathVariable Integer iddir) {
        Direcciones direcciones = new Direcciones();
        direcciones.setIddir(iddir);
        this.direccionesService.remove(direcciones);
       	DireccionesController.logger.info("[DELETE] : Direcciones borrado correctamente");
       	return direcciones;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param direccionesIds List
	 * @return direccionesList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> direccionesIds) {
        List<Direcciones> direccionesList = new ArrayList<Direcciones>();
        for (List<String> direccionesId:direccionesIds) {
		    Iterator<String> iterator = direccionesId.iterator();
		    Direcciones direcciones = new Direcciones(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        direcciones.setIddir(ObjectConversionManager.convert(iterator.next(), Integer.class));
		    direccionesList.add(direcciones);
	    }
        this.direccionesService.removeMultiple(direccionesList);
		DireccionesController.logger.info("[POST - DELETE_ALL] : Direcciones borrados correctamente");
		return direccionesIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterDirecciones Direcciones
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Direcciones filterDirecciones, @ModelAttribute Pagination pagination) {
        List<Direcciones> direccioness = this.direccionesService.findAll(filterDirecciones, pagination);
        Long recordNum = this.direccionesService.findAllCount(filterDirecciones);
        DireccionesController.logger.info("[GET - jqGrid] : Obtener Direcciones");
		return new JQGridJSONModel(pagination, recordNum, direccioness);
	}
	
}	
