package com.ejie.aa20b.control;

import com.ejie.aa20b.service.DepartamentosService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa20b.model.Departamentos;

/**
 * DepartamentosController generated by UDA, 28-nov-2014 11:32:27.
 * @author UDA
 */
 
@Controller
@RequestMapping (value = "/departamentos")

public class DepartamentosController  {

	private static final Logger logger = LoggerFactory.getLogger(DepartamentosController.class);

	@Autowired
	private DepartamentosService departamentosService;
	
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		DepartamentosController.logger.info("[GET - View] : departamentos");
		return "departamentos";
	}

	/**
	 * Method 'getById'.
	 *
	 * @param iddepar Long
	 * @return departamentos Departamentos
	 */
	@RequestMapping(value = "/{iddepar}", method = RequestMethod.GET)
	public @ResponseBody Departamentos getById(@PathVariable Long iddepar) {
        Departamentos departamentos = new Departamentos();
		departamentos.setIddepar(iddepar);
        departamentos = this.departamentosService.find(departamentos);
        DepartamentosController.logger.info("[GET - findBy_PK] : Obtener Departamentos por PK");
        return departamentos;
	}

	/**
	 * Method 'getAll'.
	 *
	 * @param filterDepartamentos Departamentos
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody List<Departamentos> getAll(@ModelAttribute Departamentos filterDepartamentos) {
		DepartamentosController.logger.info("[GET - find_ALL] : Obtener Departamentos por filtro");
	    return this.departamentosService.findAll(filterDepartamentos, null);
	}

	/**
	 * Method 'edit'.
	 *
	 * @param departamentos Departamentos 
	 * @return Departamentos
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Departamentos edit(@RequestBody Departamentos departamentos) {		
        Departamentos departamentosAux = this.departamentosService.update(departamentos);
		DepartamentosController.logger.info("[PUT] : Departamentos actualizado correctamente");
        return departamentosAux;
    }

	/**
	 * Method 'add'.
	 *
	 * @param departamentos Departamentos 
	 * @return Departamentos
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Departamentos add(@RequestBody Departamentos departamentos) {		
        Departamentos departamentosAux = this.departamentosService.add(departamentos);
        DepartamentosController.logger.info("[POST] : Departamentos insertado correctamente");
    	return departamentosAux;
	}

	/**
	 * Method 'remove'.
	 *
	 * @param iddepar Long
	 * @return departamentos
	 */
	@RequestMapping(value = "/{iddepar}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
    public @ResponseBody Departamentos remove(@PathVariable Long iddepar) {
        Departamentos departamentos = new Departamentos();
        departamentos.setIddepar(iddepar);
        this.departamentosService.remove(departamentos);
       	DepartamentosController.logger.info("[DELETE] : Departamentos borrado correctamente");
       	return departamentos;
    }
	
	/**
	 * Method 'removeAll'.
	 *
	 * @param departamentosIds List
	 * @return departamentosList
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody List<List<String>> removeMultiple(@RequestBody List<List<String>> departamentosIds) {
        List<Departamentos> departamentosList = new ArrayList<Departamentos>();
        for (List<String> departamentosId:departamentosIds) {
		    Iterator<String> iterator = departamentosId.iterator();
		    Departamentos departamentos = new Departamentos(); //NOPMD - Objeto nuevo en la lista (parametro del servicio)
	        departamentos.setIddepar(ObjectConversionManager.convert(iterator.next(), Long.class));
		    departamentosList.add(departamentos);
	    }
        this.departamentosService.removeMultiple(departamentosList);
		DepartamentosController.logger.info("[POST - DELETE_ALL] : Departamentos borrados correctamente");
		return departamentosIds;
	}	

	/**
	 * Method 'getAllJQGrid'.
	 *
	 * @param filterDepartamentos Departamentos
	 * @param pagination Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers={"JQGridModel=true"})
	public @ResponseBody JQGridJSONModel getAllJQGrid(@ModelAttribute Departamentos filterDepartamentos, @ModelAttribute Pagination pagination) {
        List<Departamentos> departamentoss = this.departamentosService.findAll(filterDepartamentos, pagination);
        Long recordNum = this.departamentosService.findAllCount(filterDepartamentos);
        DepartamentosController.logger.info("[GET - jqGrid] : Obtener Departamentos");
		return new JQGridJSONModel(pagination, recordNum, departamentoss);
	}
	
}	
