package com.ejie.aa20b.control;

import com.ejie.aa20b.service.CuestionarioService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import com.ejie.aa20b.model.Cuestionario;

/**
 * CuestionarioController generated by UDA, 02-mar-2015 11:32:38.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/cuestionario")
public class CuestionarioController {

	private static final Logger logger = LoggerFactory
			.getLogger(CuestionarioController.class);

	@Autowired
	private CuestionarioService cuestionarioService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		CuestionarioController.logger.info("[GET - View] : cuestionario");
		return "cuestionario";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idcuestionario
	 *            Integer
	 * @return cuestionario Cuestionario
	 */
	@RequestMapping(value = "/{idcuestionario}", method = RequestMethod.GET)
	public @ResponseBody
	Cuestionario getById(@PathVariable Integer idcuestionario) {
		Cuestionario cuestionario = new Cuestionario();
		cuestionario.setIdcuestionario(idcuestionario);
		cuestionario = this.cuestionarioService.find(cuestionario);
		CuestionarioController.logger
				.info("[GET - findBy_PK] : Obtener Cuestionario por PK");
		return cuestionario;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterCuestionario
	 *            Cuestionario
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Cuestionario> getAll(@ModelAttribute Cuestionario filterCuestionario) {
		CuestionarioController.logger
				.info("[GET - find_ALL] : Obtener Cuestionario por filtro");
		return this.cuestionarioService.findAll(filterCuestionario, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return Cuestionario
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Cuestionario edit(@RequestBody Cuestionario cuestionario) {
		Cuestionario cuestionarioAux = this.cuestionarioService
				.update(cuestionario);
		CuestionarioController.logger
				.info("[PUT] : Cuestionario actualizado correctamente");
		return cuestionarioAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return Cuestionario
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Cuestionario add(@RequestBody Cuestionario cuestionario) {
		Cuestionario cuestionarioAux = this.cuestionarioService
				.add(cuestionario);
		CuestionarioController.logger
				.info("[POST] : Cuestionario insertado correctamente");
		return cuestionarioAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idcuestionario
	 *            Integer
	 * @return cuestionario
	 */
	@RequestMapping(value = "/{idcuestionario}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	String remove(@PathVariable Integer idcuestionario) {
		Cuestionario cuestionario = new Cuestionario();
		cuestionario.setIdcuestionario(idcuestionario);
		// this.cuestionarioService.remove(cuestionario);
		String eliminado = this.cuestionarioService
				.eliminarCuestionario(cuestionario);
		if (eliminado == "ok") {
			CuestionarioController.logger
					.info("[DELETE] : Cuestionario borrado correctamente");
		} else if (eliminado == "tieneActuaciones") {
			CuestionarioController.logger
					.info("[DELETE] : Cuestionario no eliminado porque tiene actuaciones");
		}

		return eliminado;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param cuestionarioIds
	 *            List
	 * @return cuestionarioList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> cuestionarioIds) {
		List<Cuestionario> cuestionarioList = new ArrayList<Cuestionario>();
		for (List<String> cuestionarioId : cuestionarioIds) {
			Iterator<String> iterator = cuestionarioId.iterator();
			Cuestionario cuestionario = new Cuestionario(); // NOPMD - Objeto
															// nuevo en la lista
															// (parametro del
															// servicio)
			cuestionario.setIdcuestionario(ObjectConversionManager.convert(
					iterator.next(), Integer.class));
			cuestionarioList.add(cuestionario);
		}
		this.cuestionarioService.removeMultiple(cuestionarioList);
		CuestionarioController.logger
				.info("[POST - DELETE_ALL] : Cuestionario borrados correctamente");
		return cuestionarioIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterCuestionario
	 *            Cuestionario
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute Cuestionario filterCuestionario,
			@ModelAttribute Pagination pagination) {
		List<Cuestionario> cuestionarios = this.cuestionarioService.findAll(
				filterCuestionario, pagination);
		Long recordNum = this.cuestionarioService
				.findAllCount(filterCuestionario);
		CuestionarioController.logger
				.info("[GET - jqGrid] : Obtener Cuestionario");
		return new JQGridJSONModel(pagination, recordNum, cuestionarios);
	}

	/**
	 * Method 'obtenerCuestionariosGama'.
	 * 
	 * @param filterCuestionario
	 *            Cuestionario
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "cuestionariosGama", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel obtenerCuestionariosGama(
			@ModelAttribute Cuestionario filterCuestionario,
			@ModelAttribute Pagination pagination) {

		List<Cuestionario> cuestionario = this.cuestionarioService.findAll(
				filterCuestionario, pagination);
		Long recordNum = this.cuestionarioService
				.findAllCount(filterCuestionario);
		CuestionarioController.logger
				.info("[GET - jqGrid] : Obtener Cuestionario");
		return new JQGridJSONModel(pagination, recordNum, cuestionario);

	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/modificar", method = RequestMethod.GET)
	public String getCreateFormModficar(Model model, HttpServletRequest request) {
		CuestionarioController.logger
				.info("[GET - View] : modificar cuestionario");

		Integer idCuestionario = Integer.parseInt(request
				.getParameter("idCuestionario"));

		CuestionarioController.logger
				.info("[GET - View] : modificar Cuestionario : cuestionario: "
						+ idCuestionario);

		Cuestionario cuestionario = this.getById(idCuestionario);

		CuestionarioController.logger
				.info("[GET - View] : modificar cuestionario : "
						+ cuestionario.toString());

		model.addAttribute("Cuestionario", cuestionario);

		request.setAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		return "editarCuestionario";
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param cuestionario
	 *            Cuestionario
	 * @return Cuestionario
	 */
	@RequestMapping(value = "/modificaCuestionario", method = RequestMethod.POST)
	public @ResponseBody
	Cuestionario modificaCuestionario(@RequestBody Cuestionario cuestionario) {

		CuestionarioController.logger
				.info("[PUT] : Cuestionario antes de modificar : "
						+ cuestionario.toString());
		Cuestionario cuestionarioAux = this.cuestionarioService
				.update(cuestionario);
		CuestionarioController.logger
				.info("[PUT] : Cuestionario actualizado correctamente");
		return cuestionarioAux;

	}

	@RequestMapping(value = "/addNuevaCuestionario", method = RequestMethod.POST)
	public @ResponseBody
	Cuestionario addNuevaCuestionario(@RequestBody Cuestionario cuestionario,
			Model model) {

		CuestionarioController.logger
				.info("[POST] : ENTRAMOS EN ADD cuestionario");

		CuestionarioController.logger.info("[POST] : ADD : cuestionario : "
				+ cuestionario.toString());
		Cuestionario cuestionarioAux = this.cuestionarioService
				.add(cuestionario);
		CuestionarioController.logger
				.info("[POST] : cuestionario insertado correctamente");

		return cuestionarioAux;
	}

	/**
	 * Method 'getCreateForm2'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "nuevo", method = RequestMethod.GET)
	public String getCreateForm2(Model model, HttpServletRequest request) {
		CuestionarioController.logger.info("[GET - View] : nuevo Cuestionario");
		model.addAttribute("accion", Aa20bConstantes.ACCION_NUEVO);

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);
		return "editarCuestionario";
	}

	@RequestMapping(value = "/existeOrdenGama", method = RequestMethod.POST)
	public @ResponseBody
	Boolean existeOrdenGama(@RequestParam Long numOrden,
			@RequestParam Long idGama, Model model, HttpServletRequest request) {

		Cuestionario cuestionario = new Cuestionario();
		CuestionarioController.logger.info("[POST - existeOrdenGama] ");

		cuestionario.setIdgama(idGama);
		cuestionario.setNroorden(numOrden);
		List<Cuestionario> cuestionarios = this.cuestionarioService.findAll(
				cuestionario, null);

		if (cuestionarios.size() > 0) {
			return true;
		}

		return false;
	}

	@RequestMapping(value = "/obtenerMaxOrdenGama", method = RequestMethod.POST)
	public @ResponseBody
	Long obtenerMaxOrdenGama(@RequestParam Long idGama, Model model,
			HttpServletRequest request) {

		CuestionarioController.logger.info("[POST - obtenerMaxOrdenGama] ");

		Long maxOrdenGama = this.cuestionarioService
				.obtenerMaxOrdenGama(idGama);

		return maxOrdenGama + 1;
	}

	/**
	 * Method 'eliminarCuestionario'.
	 * 
	 * @param idcuestionario
	 *            Integer
	 * @return cuestionario
	 */
	@RequestMapping(value = "eliminarCuestionario", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Cuestionario eliminarCuestionario(@PathVariable Integer idcuestionario) {
		Cuestionario cuestionario = new Cuestionario();
		cuestionario.setIdcuestionario(idcuestionario);
		this.cuestionarioService.remove(cuestionario);
		CuestionarioController.logger
				.info("[DELETE] : Cuestionario borrado correctamente");
		return cuestionario;
	}
}
