package com.ejie.aa20b.control;

import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.Aa20bUsuarioXLNETService;
import com.ejie.aa20b.service.CodigoService;
import com.ejie.aa20b.service.UsuariosService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Usuarios;

/**
 * CodigoController generated by UDA, 28-nov-2014 12:22:02.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/codigo")
public class CodigoController {

	private static final Logger logger = LoggerFactory
			.getLogger(CodigoController.class);

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private CodigoService codigoService;

	@Autowired
	private Aa20bUsuarioXLNETService usuarioXLNETService;

	@Autowired
	private UsuarioXLNETController usuarioXLNETController;

	@Autowired
	private UsuariosService usuariosService;

	@Autowired
	private Aa20bProcesosJMSService procesosJMSService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		CodigoController.logger.info("[GET - View] : codigo");

		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroCodigos");

		return "codigo";
	}

	/**
	 * Method 'maintVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintVolver", method = RequestMethod.GET)
	public String maintVolver(Model model, HttpServletRequest request) {
		CodigoController.logger.info("[GET - View] : codigo");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Codigo codigoFiltro = (Codigo) request.getSession().getAttribute(
				"FiltroCodigos");

		model.addAttribute("FiltroCodigo", codigoFiltro);

		return "codigo";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idcodigo
	 *            Integer
	 * @return codigo Codigo
	 */
	@RequestMapping(value = "/{idcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Codigo getById(@PathVariable Integer idcodigo) {
		Codigo codigo = new Codigo();
		codigo.setIdcodigo(idcodigo);
		codigo = this.codigoService.find(codigo);
		CodigoController.logger
				.info("[GET - findBy_PK] : Obtener Codigo por PK");
		return codigo;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterCodigo
	 *            Codigo
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Codigo> getAll(@ModelAttribute Codigo filterCodigo) {
		CodigoController.logger
				.info("[GET - find_ALL] : Obtener Codigo por filtro");
		return this.codigoService.findAll(filterCodigo, null);
	}

	/**
	 * Method 'obtenerCodigosAltaClaseServicio'.
	 * 
	 * @param filterCodigo
	 *            Codigo
	 * @param claseSel
	 *            Integer
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "codigosAlta/obtenerCodigosAltaClaseServicio", method = RequestMethod.POST)
	public @ResponseBody
	List<Codigo> obtenerCodigosAltaClaseServicio(
			@ModelAttribute Codigo filterCodigo, Integer claseSel,
			HttpServletRequest request) {
		CodigoController.logger
				.info("[GET - obtenerCodigosAltaClaseServicio] : Obtener Codigos en Alta para una clase dada asociados a un servicio");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado
		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Integer idServicio = usuario.getIdservicio();
				filterCodigo.setIdservicio(idServicio);
			}
		}

		if (claseSel != null) {
			filterCodigo.setIdclase(claseSel);
		}
		return this.codigoService.obtenerCodigosAlta(filterCodigo);
	}

	/**
	 * Method 'obtenerCodigosClaseServicio'.
	 * 
	 * @param filterCodigo
	 *            Codigo
	 * @param claseSel
	 *            Integer
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "codigos/obtenerCodigosClaseServicio", method = RequestMethod.POST)
	public @ResponseBody
	List<Codigo> obtenerCodigosClaseServicio(
			@ModelAttribute Codigo filterCodigo, Integer claseSel,
			HttpServletRequest request) {
		CodigoController.logger
				.info("[GET - obtenerCodigosClaseServicio] : Obtener Codigos para una clase dada asociados a un servicio");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado
		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Integer idServicio = usuario.getIdservicio();
				filterCodigo.setIdservicio(idServicio);
			}
		}

		if (claseSel != null) {
			filterCodigo.setIdclase(claseSel);
		}
		return this.codigoService.findAll(filterCodigo, null); // .obtenerActivosClase(idClase,
																// language).obtenerCodigosAlta(filterCodigo);
	}

	/**
	 * Method 'obtenerCodigosAltaClase'.
	 * 
	 * @param filterCodigo
	 *            Codigo
	 * @param claseSel
	 *            Integer
	 * @return List
	 */
	@RequestMapping(value = "codigosAlta/obtenerCodigosAltaClase", method = RequestMethod.POST)
	public @ResponseBody
	List<Codigo> obtenerCodigosAltaClase(@ModelAttribute Codigo filterCodigo,
			Integer claseSel) {
		CodigoController.logger
				.info("[GET - obtenerCodigosAltaClase] : Obtener Codigos en Alta para una clase dada");
		if (claseSel != null) {
			filterCodigo.setIdclase(claseSel);
		}
		return this.codigoService.obtenerCodigosAlta(filterCodigo);
	}

	/**
	 * Method 'obtenerCodigosAltaClaseUsuPubli'.
	 * 
	 * @param filterCodigo
	 *            Codigo
	 * @param Integer
	 *            claseSel
	 * @return List
	 */
	@RequestMapping(value = "codigosAlta/obtenerCodigosAltaClaseUsuPubli", method = RequestMethod.POST)
	public @ResponseBody
	List<Codigo> obtenerCodigosAltaClaseUsuPubli(
			@ModelAttribute Codigo filterCodigo, Integer claseSel,
			HttpServletRequest request) {
		filterCodigo.setUsupubli("1");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado
		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Integer idServicio = usuario.getIdservicio();
				filterCodigo.setIdservicio(idServicio);
			}
		}

		CodigoController.logger
				.info("[GET - obtenerCodigosAltaClaseUsuPubli] : Obtener Codigos en Alta para una clase dada que tengan la marca de Usuario publico");
		if (claseSel != null) {
			filterCodigo.setIdclase(claseSel);
		}
		return this.codigoService.obtenerCodigosAlta(filterCodigo);
	}

	/**
	 * Method 'obtenerCodigosAlta'.
	 * 
	 * @param filterCodigo
	 *            Codigo
	 * @return List
	 */
	@RequestMapping(value = "codigosAlta/obtenerCodigosAlta", method = RequestMethod.POST)
	public @ResponseBody
	List<Codigo> obtenerCodigoAlta(@ModelAttribute Codigo filterCodigo) {
		CodigoController.logger
				.info("[GET - obtenerCodigosAlta] : Obtener Codigos en Alta");
		return this.codigoService.obtenerCodigosAlta(filterCodigo);
	}

	/**
	 * Method 'obtenerCodigosAltaServicio'.
	 * 
	 * @param filterCodigo
	 *            Codigo
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "codigosAlta/obtenerCodigosAltaServicio", method = RequestMethod.POST)
	public @ResponseBody
	List<Codigo> obtenerCodigosAltaServicio(
			@ModelAttribute Codigo filterCodigo, HttpServletRequest request) {
		CodigoController.logger
				.info("[GET - obtenerCodigosAlta] : Obtener Codigos en Alta asociados a un servico");

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado
		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Integer idServicio = usuario.getIdservicio();
				filterCodigo.setIdservicio(idServicio);
			}
		}

		return this.codigoService.obtenerCodigosAlta(filterCodigo);
	}

	/**
	 * Method 'obtenerCodigosServicio'.
	 * 
	 * @param filterCodigo
	 *            Codigo
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "codigos/obtenerCodigosServicio", method = RequestMethod.POST)
	public @ResponseBody
	List<Codigo> obtenerCodigosServicio(@ModelAttribute Codigo filterCodigo,
			HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado
		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				Integer idServicio = usuario.getIdservicio();
				filterCodigo.setIdservicio(idServicio);
			}
		}

		CodigoController.logger
				.info("[GET - obtenerCodigos] : Obtener Codigos");
		return this.codigoService.findAll(filterCodigo, null);
	}

	/**
	 * Method 'obtenerCodigos'.
	 * 
	 * @param filterCodigo
	 *            Codigo
	 * @return List
	 */
	@RequestMapping(value = "codigos/obtenerCodigos", method = RequestMethod.POST)
	public @ResponseBody
	List<Codigo> obtenerCodigo(@ModelAttribute Codigo filterCodigo) {
		CodigoController.logger
				.info("[GET - obtenerCodigos] : Obtener Codigos");
		return this.codigoService.findAll(filterCodigo, null);
	}

	/**
	 * Method 'obtenerCodigosAltaUsuPubli'.
	 * 
	 * @param filterCodigo
	 *            Codigo
	 * @return List
	 */
	@RequestMapping(value = "codigosAlta/obtenerCodigosAltaUsuPubli", method = RequestMethod.POST)
	public @ResponseBody
	List<Codigo> obtenerCodigosAltaUsuPubli(@ModelAttribute Codigo filterCodigo) {
		filterCodigo.setUsupubli("1");
		CodigoController.logger
				.info("[GET - obtenerCodigosAltaUsuPubli] : Obtener Codigos en Alta para un usuario publico");
		return this.codigoService.obtenerCodigosAlta(filterCodigo);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Codigo edit(@RequestBody Codigo codigo) {
		Codigo codigoAux = this.codigoService.update(codigo);
		CodigoController.logger
				.info("[PUT] : Codigo actualizado correctamente");
		return codigoAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Codigo add(@RequestBody Codigo codigo) {
		Codigo codigoAux = this.codigoService.add(codigo);
		CodigoController.logger.info("[POST] : Codigo insertado correctamente");
		return codigoAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idcodigo
	 *            Integer
	 * @return codigo
	 */
	@RequestMapping(value = "/{idcodigo}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Codigo remove(@PathVariable Integer idcodigo) {
		Codigo codigo = new Codigo();
		codigo.setIdcodigo(idcodigo);
		this.codigoService.remove(codigo);
		CodigoController.logger.info("[DELETE] : Codigo borrado correctamente");
		return codigo;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param codigoIds
	 *            List
	 * @return codigoList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> codigoIds) {
		List<Codigo> codigoList = new ArrayList<Codigo>();
		for (List<String> codigoId : codigoIds) {
			Iterator<String> iterator = codigoId.iterator();
			Codigo codigo = new Codigo(); // NOPMD - Objeto nuevo en la lista
											// (parametro del servicio)
			codigo.setIdcodigo(ObjectConversionManager.convert(iterator.next(),
					Integer.class));
			codigoList.add(codigo);
		}
		this.codigoService.removeMultiple(codigoList);
		CodigoController.logger
				.info("[POST - DELETE_ALL] : Codigo borrados correctamente");
		return codigoIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterCodigo
	 *            Codigo
	 * @param pagination
	 *            Pagination
	 * @param locale
	 *            Locale
	 * @param request
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Codigo filterCodigo,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {
		List<Codigo> codigos = this.codigoService.findAllLike(filterCodigo,
				pagination, false);
		Long recordNum = this.codigoService.findAllLikeCount(filterCodigo,
				false);
		CodigoController.logger.info("[GET - jqGrid] : Obtener Codigo");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterCodigo.getFeini() != null) {
			try {
				filterCodigo.setStrFeini(Aa20bFecha.getFechaFormateada(
						filterCodigo.getFeini(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroCodigos", filterCodigo);

		return new JQGridJSONModel(pagination, recordNum, codigos);
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/modificar", method = RequestMethod.GET)
	public String getCreateFormModficar(Model model, HttpServletRequest request) {
		CodigoController.logger.info("[GET - View] : modificar codigo");

		Integer idCodigo = Integer.parseInt(request.getParameter("idCodigo"));

		CodigoController.logger
				.info("[GET - View] : modificar Codigo : codigo: " + idCodigo);

		Codigo codigo = this.getById(idCodigo);

		CodigoController.logger.info("[GET - View] : modificar codigo : "
				+ codigo.toString());

		model.addAttribute("Codigo", codigo);

		request.setAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		return "editarCodigo";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idCodigoBusc
	 *            String
	 * @param ventanaOrigen
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return editarCodigo String
	 */
	@RequestMapping(value = "/buscarCodigo", method = RequestMethod.POST)
	public String buscarCodigo(@RequestParam Integer idCodigoBusc,
			@RequestParam String ventanaOrigen, Model model,
			HttpServletRequest request) {

		Codigo codigo = this.getById(idCodigoBusc);

		CodigoController.logger.info("[GET - findBy_PK] : codigo: "
				+ codigo.toString());

		model.addAttribute("Codigo", codigo);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		return "editarCodigo";
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param codigo
	 *            Codigo
	 * @return Codigo
	 */
	@RequestMapping(value = "/modificaCodigo", method = RequestMethod.POST)
	public @ResponseBody
	Codigo modificaCodigo(@RequestBody Codigo codigo) {

		CodigoController.logger.info("[POST] : MODIFY : Valor de Baja : "
				+ codigo.getBaja());

		/**
		 * GMAO Comprobaremos si el espacio no se encontraba de baja. Relleno
		 */
		boolean sincronizarTodosCodigosGmao = false;
		boolean sincronizarCodigoGmao = true;
		Codigo codigoBaja = this.getById(codigo.getIdcodigo());
		/***/

		if (codigo.getBaja() == null) {
			/**
			 * GMAO Si estaba de baja significa que se ha puesto de alta ahora y
			 * hay que sincronizar con Gmao
			 */
			if (codigoBaja.getBaja() != null
					&& codigoBaja.getBaja().equals("1")) {
				sincronizarTodosCodigosGmao = true;
			}

			codigo.setBaja("0");
		} else {

			/**
			 * GMAO Si no estaba de baja significa que se ha puesto de baja
			 * ahora y hay que sincronizar con Gmao
			 */
			if (codigoBaja.getBaja() == null
					|| (codigoBaja.getBaja() != null && codigoBaja.getBaja()
							.equals("0"))) {
				sincronizarTodosCodigosGmao = true;
			} else {
				// Si estaba de baja y sigue de baja no actualizamos GMAO
				sincronizarCodigoGmao = false;
			}
			/***/

			codigo.setBaja("1");
		}

		if (codigo.getUsupubli() == null)
			codigo.setUsupubli("0");
		else
			codigo.setUsupubli("1");

		if (codigo.getRecibeinci() == null)
			codigo.setRecibeinci("0");
		else
			codigo.setRecibeinci("1");

		if (codigo.getContrata() == null)
			codigo.setContrata("0");
		else
			codigo.setContrata("1");

		CodigoController.logger.info("[PUT] : Codigo antes de modificar : "
				+ codigo.toString());
		Codigo codigoAux = this.codigoService.update(codigo);
		CodigoController.logger
				.info("[PUT] : Codigo actualizado correctamente");

		/**
		 * GMAO - Si la actualización del codigo ha ido bien, generamos un
		 * mensaje en la cola para actualizar la entidad 'codigo' en BBDD
		 * movilgmao. Si se ha puesto de baja, se deben sincronizar todas las
		 * entidades 'estancia'
		 */
		if (sincronizarTodosCodigosGmao) {
			Codigo codigoFilter = new Codigo();
			codigoFilter.setBaja("0");
			List<Codigo> codigos = this.codigoService.findAll(codigoFilter,
					null);

			/**
			 * GMAO Sincronizacion de todos los codigos
			 */
			String urlConfig = "";
			try {
				urlConfig = this.appConfiguration.getObject().getProperty(
						"movilgmao.path");
			} catch (Exception e) {

			}

			this.procesosJMSService.sincronizarTodosCodigosGmao(codigos,
					Aa20bConstantes.COLA, urlConfig);
		} else {

			if (sincronizarCodigoGmao) {
				CodigoController.logger
						.info("[JMS] notificar modificación codigo movilgmao");

				this.procesosJMSService.sincronizarCodigoGmao(codigo);
			}

		}

		return codigoAux;

	}

	@RequestMapping(value = "/addNuevaCodigo", method = RequestMethod.POST)
	public @ResponseBody
	Codigo addNuevaCodigo(@RequestBody Codigo codigo, Model model) {

		CodigoController.logger.info("[POST] : ENTRAMOS EN ADD codigo");

		CodigoController.logger.info("[POST] : ADD : codigo : "
				+ codigo.toString());
		codigo.setBaja("0");
		if (codigo != null && codigo.getRecibeinci() == null) {
			codigo.setRecibeinci("0");
		}
		if (codigo != null && codigo.getContrata() == null) {
			codigo.setContrata("0");
		}
		if (codigo != null && codigo.getUsupubli() == null) {
			codigo.setUsupubli("0");
		}
		if (codigo != null && codigo.getFeini() == null) {
			Date fechaHoy = new Date();
			codigo.setFeini(fechaHoy);
		}
		Codigo codigoAux = this.codigoService.add(codigo);
		CodigoController.logger.info("[POST] : codigo insertado correctamente");

		/**
		 * GMAO Sincronizacion de todos los codigos
		 */

		CodigoController.logger
				.info("[JMS] notificar modificación codigo movilgmao");

		// this.procesosJMSService.sincronizarCodigoGmao(codigo);

		Codigo codigoFilter = new Codigo();
		codigoFilter.setBaja("0");
		List<Codigo> codigos = this.codigoService.findAll(codigoFilter, null);

		/**
		 * GMAO Sincronizacion de todos los codigos
		 */
		String urlConfig = "";
		try {
			urlConfig = this.appConfiguration.getObject().getProperty(
					"movilgmao.path");
		} catch (Exception e) {

		}

		this.procesosJMSService.sincronizarTodosCodigosGmao(codigos,
				Aa20bConstantes.COLA, urlConfig);

		return codigoAux;
	}

	/**
	 * Method 'getCreateForm2'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "nuevo", method = RequestMethod.GET)
	public String getCreateForm2(Model model, HttpServletRequest request) {
		CodigoController.logger.info("[GET - View] : nueva codigo");
		model.addAttribute("accion", Aa20bConstantes.ACCION_NUEVO);

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);
		return "nuevoCodigo";
	}

	@RequestMapping(value = "codigoParteEsUrgente", method = RequestMethod.POST)
	public @ResponseBody
	Boolean codigoParteEsUrgente(Integer idCodigo) {

		Codigo codigo = new Codigo();
		codigo.setIdcodigo(idCodigo);
		codigo = this.codigoService.find(codigo);
		CodigoController.logger.info("[POST] : codigoParteEsUrgente");
		if (codigo != null && codigo.getUrgente() != null
				&& codigo.getUrgente().equals("1")) {
			return true;
		} else {
			return false;
		}
	}

}
