package com.ejie.aa20b.control;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.model.Clasecontrata;
import com.ejie.aa20b.service.ClasecontrataService;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;

/**
 * ClasecontrataController generated by UDA, 17-abr-2015 11:56:32.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/clasecontrata")
public class ClasecontrataController {

	private static final Logger logger = LoggerFactory
			.getLogger(ClasecontrataController.class);

	@Autowired
	private ClasecontrataService clasecontrataService;

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ClasecontrataController.logger.info("[GET - View] : clasecontrata");
		return "clasecontrata";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idclase
	 *            Integer
	 * @param idtecnico
	 *            Long
	 * @return clasecontrata Clasecontrata
	 */
	@RequestMapping(value = "/{idclase}/{idtecnico}", method = RequestMethod.GET)
	public @ResponseBody
	Clasecontrata getById(@PathVariable Integer idclase,
			@PathVariable Long idtecnico) {
		Clasecontrata clasecontrata = new Clasecontrata();
		clasecontrata.setIdclase(idclase);
		clasecontrata.setIdtecnico(idtecnico);
		clasecontrata = this.clasecontrataService.find(clasecontrata);
		ClasecontrataController.logger
				.info("[GET - findBy_PK] : Obtener Clasecontrata por PK");
		return clasecontrata;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterClasecontrata
	 *            Clasecontrata
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Clasecontrata> getAll(@ModelAttribute Clasecontrata filterClasecontrata) {
		ClasecontrataController.logger
				.info("[GET - find_ALL] : Obtener Clasecontrata por filtro");
		return this.clasecontrataService.findAll(filterClasecontrata, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Clasecontrata edit(@RequestBody Clasecontrata clasecontrata) {
		Clasecontrata clasecontrataAux = this.clasecontrataService
				.update(clasecontrata);
		ClasecontrataController.logger
				.info("[PUT] : Clasecontrata actualizado correctamente");
		return clasecontrataAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param clasecontrata
	 *            Clasecontrata
	 * @return Clasecontrata
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Clasecontrata add(@RequestBody Clasecontrata clasecontrata) {
		Clasecontrata clasecontrataAux = this.clasecontrataService
				.add(clasecontrata);
		ClasecontrataController.logger
				.info("[POST] : Clasecontrata insertado correctamente");
		return clasecontrataAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idclase
	 *            Integer
	 * @param idtecnico
	 *            Long
	 * @return clasecontrata
	 */
	@RequestMapping(value = "/{idclase}/{idtecnico}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Clasecontrata remove(@PathVariable Integer idclase,
			@PathVariable Long idtecnico) {
		Clasecontrata clasecontrata = new Clasecontrata();
		clasecontrata.setIdclase(idclase);
		clasecontrata.setIdtecnico(idtecnico);
		this.clasecontrataService.remove(clasecontrata);
		ClasecontrataController.logger
				.info("[DELETE] : Clasecontrata borrado correctamente");
		return clasecontrata;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param clasecontrataIds
	 *            List
	 * @return clasecontrataList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> clasecontrataIds) {
		List<Clasecontrata> clasecontrataList = new ArrayList<Clasecontrata>();
		for (List<String> clasecontrataId : clasecontrataIds) {
			Iterator<String> iterator = clasecontrataId.iterator();
			Clasecontrata clasecontrata = new Clasecontrata(); // NOPMD - Objeto
																// nuevo en la
																// lista
																// (parametro
																// del servicio)
			clasecontrata.setIdclase(ObjectConversionManager.convert(
					iterator.next(), Integer.class));
			clasecontrata.setIdtecnico(ObjectConversionManager.convert(
					iterator.next(), Long.class));
			clasecontrataList.add(clasecontrata);
		}
		this.clasecontrataService.removeMultiple(clasecontrataList);
		ClasecontrataController.logger
				.info("[POST - DELETE_ALL] : Clasecontrata borrados correctamente");
		return clasecontrataIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterClasecontrata
	 *            Clasecontrata
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(
			@ModelAttribute Clasecontrata filterClasecontrata,
			@ModelAttribute Pagination pagination) {
		List<Clasecontrata> clasecontratas = this.clasecontrataService.findAll(
				filterClasecontrata, pagination);
		Long recordNum = this.clasecontrataService
				.findAllCount(filterClasecontrata);
		ClasecontrataController.logger
				.info("[GET - jqGrid] : Obtener Clasecontrata");
		return new JQGridJSONModel(pagination, recordNum, clasecontratas);
	}

	/**
	 * 
	 * Method 'tieneCodigosAsociados'.
	 * 
	 * 
	 * puestoIntroducido String
	 * 
	 * @return List
	 */

	@RequestMapping(value = "/tieneCodigosAsociados", method = RequestMethod.POST)
	public @ResponseBody
	Boolean tieneCodigosAsociados(@RequestParam Integer idClase,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {

		Clasecontrata claseContrata = new Clasecontrata();

		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			claseContrata.setIdclase(idClase);
			claseContrata.setIdtecnico(tecnicosSeleccionados.get(i));

			List<Clasecontrata> lsClaseContrata = this.clasecontrataService
					.findAll(claseContrata, null);
			for (int a = 0; a < lsClaseContrata.size(); a++) {
				if (lsClaseContrata.get(a).getIdcodigo() != 0) {
					return true;
				}
			}
		}

		ClasecontrataController.logger
				.info("[POST - tieneCodigosAsociados] : Comprobando codigos de ClaseContrata  : ");

		return false;
	}

	@RequestMapping(value = "/comprobarTecnicosConClaseCodigoBaja", method = RequestMethod.POST)
	public @ResponseBody
	String comprobarTecnicosConClaseCodigoBaja(@RequestParam Integer idClase,
			@RequestParam Integer idCodigo,
			@RequestParam ArrayList<Long> tecnicosSeleccionados, Model model,
			HttpServletRequest request) {
		StringBuilder valorDevuelto = new StringBuilder("");

		ClasecontrataController.logger
				.info("[POST - comprobarTecnicosConClaseCodigoBaja] : Comprobar si hay tecnicos en la tabla CLASECONTRATA con baja=1: ");

		Clasecontrata claseContrata = new Clasecontrata();
		for (int i = 0; i < tecnicosSeleccionados.size(); i++) {
			claseContrata.setIdclase(idClase);
			claseContrata.setIdcodigo(idCodigo);
			claseContrata.setIdtecnico(tecnicosSeleccionados.get(i));
			claseContrata.setBaja("1");

			List<Clasecontrata> tecnicoEncontrados = this.clasecontrataService
					.findAll(claseContrata, null);
			if (tecnicoEncontrados.size() > 0) {
				if (valorDevuelto.length() > 0) {
					valorDevuelto.append(", ");
					valorDevuelto.append(tecnicoEncontrados.get(0).getNombre());
				} else {
					valorDevuelto.append(tecnicoEncontrados.get(0).getNombre());
				}
			}
		}
		if (valorDevuelto.length() > 0) {
			return valorDevuelto.toString();
		} else {
			return "OK";
		}
	}
}
