package com.ejie.aa20b.control;

import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.Aa20bUsuarioXLNETService;
import com.ejie.aa20b.service.ClaseService;
import com.ejie.aa20b.service.UsuariosService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.classes.Aa20bFecha;
import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Espacio;
import com.ejie.aa20b.model.Usuarios;

/**
 * ClaseController generated by UDA, 28-nov-2014 11:32:27.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/clase")
public class ClaseController {

	private static final Logger logger = LoggerFactory
			.getLogger(ClaseController.class);

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private ClaseService claseService;

	@Autowired
	private Aa20bUsuarioXLNETService usuarioXLNETService;

	@Autowired
	private UsuarioXLNETController usuarioXLNETController;

	@Autowired
	private UsuariosService usuariosService;

	@Autowired
	private Aa20bProcesosJMSService procesosJMSService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request) {
		ClaseController.logger.info("[GET - View] : clase");
		// Borrar el filtro de la sesion
		request.getSession().removeAttribute("FiltroClases");

		return "clase";
	}

	/**
	 * Method 'maintVolver'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintVolver", method = RequestMethod.GET)
	public String maintVolver(Model model, HttpServletRequest request) {
		ClaseController.logger.info("[GET - View] : clase");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		Clase claseFiltro = (Clase) request.getSession().getAttribute(
				"FiltroClases");

		model.addAttribute("FiltroClase", claseFiltro);

		return "clase";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idclase
	 *            Integer
	 * @param cclase
	 *            String
	 * @param eclase
	 *            String
	 * @param baja
	 *            String
	 * @param feini
	 *            Date
	 * @param usupubli
	 *            String
	 * @return clase Clase
	 */
	@RequestMapping(value = "/{idclase}/{cclase}/{eclase}/{baja}/{feini}/{usupubli}", method = RequestMethod.GET)
	public @ResponseBody
	Clase getById(@PathVariable Integer idclase, @PathVariable String cclase,
			@PathVariable String eclase, @PathVariable String baja,
			@PathVariable Date feini, @PathVariable String usupubli) {
		Clase clase = new Clase();
		clase.setIdclase(idclase);
		clase.setCclase(cclase);
		clase.setEclase(eclase);
		clase.setBaja(baja);
		clase.setFeini(feini);
		clase.setUsupubli(usupubli);
		clase = this.claseService.find(clase);
		ClaseController.logger.info("[GET - findBy_PK] : Obtener Clase por PK");
		return clase;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterClase
	 *            Clase
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Clase> getAll(@ModelAttribute Clase filterClase) {
		ClaseController.logger
				.info("[GET - find_ALL] : Obtener Clase por filtro");
		return this.claseService.findAll(filterClase, null);
	}

	/**
	 * Method 'obtenerClasesAlta'.
	 * 
	 * @param filterClase
	 *            Clase
	 * @return List
	 */
	@RequestMapping(value = "clasesAlta/obtenerClasesAlta", method = RequestMethod.POST)
	public @ResponseBody
	List<Clase> obtenerClasesAlta(@ModelAttribute Clase filterClase) {
		ClaseController.logger
				.info("[GET - obtenerClasesAlta] : Obtener Clases en Alta");
		return this.claseService.obtenerClasesAlta(filterClase);
	}

	/**
	 * Method 'obtenerClasesAlta'.
	 * 
	 * @param filterClase
	 *            Clase
	 * @return List
	 */
	/*
	 * @RequestMapping(value = "clasesAlta/obtenerClasesAltaYTodas", method =
	 * RequestMethod.POST) public @ResponseBody List<Clase>
	 * obtenerClasesAltaYTodas(@ModelAttribute Clase filterClase) {
	 * ClaseController.logger
	 * .info("[GET - obtenerClasesAlta] : Obtener Clases en Alta"); Clase
	 * claseTodas = new Clase(); claseTodas.setIdclase(new Integer(0));
	 * claseTodas.setCclase("[TODAS]"); claseTodas.setEclase("[GUZTIAK]");
	 * 
	 * ArrayList<Clase> lasClases = new ArrayList<Clase>();
	 * lasClases.add(claseTodas);
	 * 
	 * lasClases.addAll(this.claseService.obtenerClasesAlta(filterClase));
	 * return lasClases;
	 * 
	 * }
	 */

	/**
	 * Method 'obtenerClasesAltaServicio'.
	 * 
	 * @param filterClase
	 *            Clase
	 * @param request
	 *            HttpServletRequest
	 * @return List
	 */
	@RequestMapping(value = "clasesAlta/obtenerClasesAltaServicio", method = RequestMethod.POST)
	public @ResponseBody
	List<Clase> obtenerClasesAltaServicio(@ModelAttribute Clase filterClase,
			Integer idClase, HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		Integer idServicio = null;
		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado
		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				idServicio = usuario.getIdservicio();
			}
		}
		ClaseController.logger
				.info("[GET - obtenerClasesAlta] : Obtener Clases en Alta");

		if (idClase > 0) {
			filterClase.setIdclase(idClase);
		}

		return this.claseService.obtenerClasesAltaServicio(filterClase,
				idServicio);
	}

	/**
	 * Method 'obtenerClasesAltaUsuPubli'.
	 * 
	 * @param filterClase
	 *            Clase
	 * @return List
	 */
	@RequestMapping(value = "clasesAlta/obtenerClasesAltaUsuPubli", method = RequestMethod.POST)
	public @ResponseBody
	List<Clase> obtenerClasesAltaUsuPubli(@ModelAttribute Clase filterClase) {
		filterClase.setUsupubli("1");
		ClaseController.logger
				.info("[GET - obtenerClasesAltaUsuPubli] : Obtener Clases en Alta para el usuario publico");
		return this.claseService.obtenerClasesAlta(filterClase);
	}

	/**
	 * Method 'obtenerClasesServicio'.
	 * 
	 * @param filterClase
	 *            Clase
	 * @return List
	 */
	@RequestMapping(value = "clases/obtenerClasesServicio", method = RequestMethod.POST)
	public @ResponseBody
	List<Clase> obtenerClasesServicio(@ModelAttribute Clase filterClase,
			Integer idClase, HttpServletRequest request) {

		String sUIDUsuario = "";

		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		Boolean usuarioEsAdministrador = this.usuarioXLNETService
				.esAdministrador();

		Integer idServicio = null;
		// Si no es el usuario administrador meter el filtro para solo tener en
		// cuenta los partes asociados a servicios del usuario logueado
		if (!usuarioEsAdministrador) {
			// Obtener Servicio al que perteneceel usuario logueado
			Usuarios usuario = new Usuarios();
			usuario.setUidPer(sUIDUsuario);
			usuario.setBaja("0");
			usuario = this.usuariosService.find(usuario);
			if (usuario != null && usuario.getIdservicio() != null) {
				idServicio = usuario.getIdservicio();
			}
		}

		if (idClase > 0) {
			filterClase.setIdclase(idClase);
		}
		ClaseController.logger.info("[GET - obtenerClases] : Obtener Clases ");
		return this.claseService.obtenerClasesServicio(filterClase, idServicio);

	}

	/**
	 * Method 'obtenerClases'.
	 * 
	 * @param filterClase
	 *            Clase
	 * @return List
	 */
	@RequestMapping(value = "clases/obtenerClases", method = RequestMethod.POST)
	public @ResponseBody
	List<Clase> obtenerClases(@ModelAttribute Clase filterClase) {
		ClaseController.logger.info("[GET - obtenerClases] : Obtener Clases ");
		return this.claseService.findAll(filterClase, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Clase edit(@RequestBody Clase clase) {
		Clase claseAux = this.claseService.update(clase);
		ClaseController.logger.info("[PUT] : Clase actualizado correctamente");
		return claseAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Clase add(@RequestBody Clase clase) {
		Clase claseAux = this.claseService.add(clase);
		ClaseController.logger.info("[POST] : Clase insertado correctamente");
		return claseAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idclase
	 *            Integer
	 * @param cclase
	 *            String
	 * @param eclase
	 *            String
	 * @param baja
	 *            String
	 * @param feini
	 *            Date
	 * @param usupubli
	 *            String
	 * @return clase
	 */
	@RequestMapping(value = "/{idclase}/{cclase}/{eclase}/{baja}/{feini}/{usupubli}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Clase remove(@PathVariable Integer idclase, @PathVariable String cclase,
			@PathVariable String eclase, @PathVariable String baja,
			@PathVariable Date feini, @PathVariable String usupubli) {
		Clase clase = new Clase();
		clase.setIdclase(idclase);
		clase.setCclase(cclase);
		clase.setEclase(eclase);
		clase.setBaja(baja);
		clase.setFeini(feini);
		clase.setUsupubli(usupubli);
		this.claseService.remove(clase);
		ClaseController.logger.info("[DELETE] : Clase borrado correctamente");
		return clase;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param claseIds
	 *            List
	 * @return claseList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(@RequestBody List<List<String>> claseIds) {
		List<Clase> claseList = new ArrayList<Clase>();
		for (List<String> claseId : claseIds) {
			Iterator<String> iterator = claseId.iterator();
			Clase clase = new Clase(); // NOPMD - Objeto nuevo en la lista
										// (parametro del servicio)
			clase.setIdclase(ObjectConversionManager.convert(iterator.next(),
					java.lang.Integer.class));
			clase.setCclase(ObjectConversionManager.convert(iterator.next(),
					String.class));
			clase.setEclase(ObjectConversionManager.convert(iterator.next(),
					String.class));
			clase.setBaja(ObjectConversionManager.convert(iterator.next(),
					String.class));
			clase.setFeini(ObjectConversionManager.convert(iterator.next(),
					java.util.Date.class));
			clase.setUsupubli(ObjectConversionManager.convert(iterator.next(),
					String.class));
			claseList.add(clase);
		}
		this.claseService.removeMultiple(claseList);
		ClaseController.logger
				.info("[POST - DELETE_ALL] : Clase borrados correctamente");
		return claseIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterClase
	 *            Clase
	 * @param pagination
	 *            Pagination
	 * @param locale
	 *            Locale
	 * @param request
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Clase filterClase,
			Locale locale, @ModelAttribute Pagination pagination,
			HttpServletRequest request) {
		List<Clase> clases = this.claseService.findAllLike(filterClase,
				pagination, false);
		Long recordNum = this.claseService.findAllLikeCount(filterClase, false);
		ClaseController.logger.info("[GET - jqGrid] : Obtener Clase");

		// Meter en sesion el filtro para si edita un parte al volver cargar el
		// filtro
		if (filterClase.getFeini() != null) {
			try {
				filterClase.setStrFeini(Aa20bFecha.getFechaFormateada(
						filterClase.getFeini(), locale));
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}

		request.getSession().setAttribute("FiltroClases", filterClase);

		return new JQGridJSONModel(pagination, recordNum, clases);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idclase
	 *            Integer
	 * @return clase Clase
	 */
	@RequestMapping(value = "/{idclase}", method = RequestMethod.GET)
	public @ResponseBody
	Clase getById(@PathVariable Integer idclase) {
		Clase clase = new Clase();
		clase.setIdclase(idclase);
		clase = this.claseService.find(clase);
		ClaseController.logger.info("[GET - findBy_PK] : Obtener Clase por PK");
		return clase;
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/modificar", method = RequestMethod.GET)
	public String getCreateFormModficar(Model model, HttpServletRequest request) {
		ClaseController.logger.info("[GET - View] : modificar clase");

		Integer idClase = Integer.parseInt(request.getParameter("idClase"));

		ClaseController.logger.info("[GET - View] : modificar Clase : clase: "
				+ idClase);

		Clase clase = this.getById(idClase);

		ClaseController.logger.info("[GET - View] : modificar clase : "
				+ clase.toString());

		model.addAttribute("Clase", clase);

		request.setAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		return "editarClase";
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	@RequestMapping(value = "/modificaClase", method = RequestMethod.POST)
	public @ResponseBody
	Clase modificaClase(@RequestBody Clase clase) {

		/**
		 * GMAO Comprobaremos si el espacio no se encontraba de baja. Relleno
		 */
		boolean sincronizarTodasClasesGmao = false;
		boolean sincronizarClaseGmao = true;
		Clase claseBaja = this.getById(clase.getIdclase());
		/***/

		ClaseController.logger.info("[POST] : MODIFY : Valor de Baja : "
				+ clase.getBaja());

		if (clase.getBaja() == null) {

			/**
			 * GMAO Si estaba de baja significa que se ha puesto de alta ahora y
			 * hay que sincronizar con Gmao
			 */
			if (claseBaja.getBaja() != null && claseBaja.getBaja().equals("1")) {
				sincronizarTodasClasesGmao = true;
			}

			clase.setBaja("0");
		} else {
			/**
			 * GMAO Si no estaba de baja significa que se ha puesto de baja
			 * ahora y hay que sincronizar con Gmao
			 */
			if (claseBaja.getBaja() == null
					|| (claseBaja.getBaja() != null && claseBaja.getBaja()
							.equals("0"))) {
				sincronizarTodasClasesGmao = true;
			} else {
				// Si estaba de baja y sigue de baja no actualizamos GMAO
				sincronizarClaseGmao = false;
			}
			/***/

			clase.setBaja("1");
		}

		if (clase.getUsupubli() == null) {
			clase.setUsupubli("0");
		} else {
			clase.setUsupubli("1");
		}

		ClaseController.logger.info("[PUT] : Clase antes de modificar : "
				+ clase.toString());
		Clase claseAux = this.claseService.update(clase);
		ClaseController.logger.info("[PUT] : Clase actualizado correctamente");

		/**
		 * GMAO - Si la actualización del espacio ha ido bien, generamos un
		 * mensaje en la cola para actualizar la entidad 'estancia' en BBDD
		 * movilgmao. Si se ha puesto de baja, se deben sincronizar todas las
		 * entidades 'estancia'
		 */
		if (sincronizarTodasClasesGmao) {
			Clase claseFilter = new Clase();
			claseFilter.setBaja("0");
			List<Clase> clases = this.claseService.findAll(claseFilter, null);

			/**
			 * GMAO Sincronizacion de todos laz estancias
			 */
			String urlConfig = "";
			try {
				urlConfig = this.appConfiguration.getObject().getProperty(
						"movilgmao.path");
			} catch (Exception e) {

			}
			this.procesosJMSService.sincronizarTodasClasesGmao(clases,
					Aa20bConstantes.COLA, urlConfig);
		} else {

			if (sincronizarClaseGmao) {
				ClaseController.logger
						.info("[JMS] notificar modificación estancia movilgmao");

				this.procesosJMSService.sincronizarClaseGmao(clase);
			}

		}

		return claseAux;

	}

	/**
	 * Method 'edit'.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	@RequestMapping(value = "/modificarClaseYDescheq", method = RequestMethod.POST)
	public @ResponseBody
	Clase modificarClaseYDescheq(@RequestBody Clase clase) {

		ClaseController.logger
				.info("[POST] : modificarClaseYDescheq : Valor de Baja : "
						+ clase.getBaja());

		/**
		 * GMAO Comprobaremos si el espacio no se encontraba de baja. Relleno
		 */
		boolean sincronizarTodasClasesGmao = false;
		boolean sincronizarClaseGmao = true;
		Clase claseBaja = this.getById(clase.getIdclase());
		/***/

		if (clase.getBaja() == null) {

			/**
			 * GMAO Si estaba de baja significa que se ha puesto de alta ahora y
			 * hay que sincronizar con Gmao
			 */
			if (claseBaja.getBaja() != null && claseBaja.getBaja().equals("1")) {
				sincronizarTodasClasesGmao = true;
			}

			clase.setBaja("0");
		} else {
			/**
			 * GMAO Si no estaba de baja significa que se ha puesto de baja
			 * ahora y hay que sincronizar con Gmao
			 */
			if (claseBaja.getBaja() == null
					|| (claseBaja.getBaja() != null && claseBaja.getBaja()
							.equals("0"))) {
				sincronizarTodasClasesGmao = true;
			} else {
				// Si estaba de baja y sigue de baja no actualizamos GMAO
				sincronizarClaseGmao = false;
			}
			/***/

			clase.setBaja("1");
		}

		clase.setUsupubli("0");

		ClaseController.logger.info("[PUT] : Clase antes de modificar : "
				+ clase.toString());
		Clase claseAux = this.claseService.modificarClaseYDescheq(clase);
		ClaseController.logger.info("[PUT] : Clase actualizado correctamente");

		/**
		 * GMAO - Si la actualización del espacio ha ido bien, generamos un
		 * mensaje en la cola para actualizar la entidad 'estancia' en BBDD
		 * movilgmao. Si se ha puesto de baja, se deben sincronizar todas las
		 * entidades 'estancia'
		 */
		if (sincronizarTodasClasesGmao) {
			Clase claseFilter = new Clase();
			claseFilter.setBaja("0");
			List<Clase> clases = this.claseService.findAll(claseFilter, null);

			/**
			 * GMAO Sincronizacion de todos laz estancias
			 */
			String urlConfig = "";
			try {
				urlConfig = this.appConfiguration.getObject().getProperty(
						"movilgmao.path");
			} catch (Exception e) {

			}
			this.procesosJMSService.sincronizarTodasClasesGmao(clases,
					Aa20bConstantes.COLA, urlConfig);
		} else {

			if (sincronizarClaseGmao) {
				ClaseController.logger
						.info("[JMS] notificar modificación estancia movilgmao");

				this.procesosJMSService.sincronizarClaseGmao(clase);
			}

		}

		return claseAux;

	}

	/**
	 * Method 'edit'.
	 * 
	 * @param clase
	 *            Clase
	 * @return Clase
	 */
	@RequestMapping(value = "/modificarClaseYCheqCodigos", method = RequestMethod.POST)
	public @ResponseBody
	Clase modificarClaseYCheqCodigos(@RequestBody Clase clase) {

		ClaseController.logger
				.info("[POST] : modificarClaseYDescheq : Valor de Baja : "
						+ clase.getBaja());

		if (clase.getBaja() == null)
			clase.setBaja("0");
		else
			clase.setBaja("1");

		clase.setUsupubli("1");

		ClaseController.logger.info("[PUT] : Clase antes de modificar : "
				+ clase.toString());
		Clase claseAux = this.claseService.modificarClaseYCheqCodigos(clase);
		ClaseController.logger.info("[PUT] : Clase actualizado correctamente");
		return claseAux;

	}

	@RequestMapping(value = "/addNuevaClase", method = RequestMethod.POST)
	public @ResponseBody
	Clase addNuevaClase(@RequestBody Clase clase, Model model) {

		ClaseController.logger.info("[POST] : ENTRAMOS EN ADD clase");

		ClaseController.logger.info("[POST] : ADD : clase : "
				+ clase.toString());
		clase.setBaja("0");
		Clase claseAux = this.claseService.add(clase);
		ClaseController.logger.info("[POST] : clase insertado correctamente");

		/**
		 * GMAO Sincronizacion de todos laz estancias
		 */

		ClaseController.logger
				.info("[JMS] notificar modificación clase movilgmao");

		this.procesosJMSService.sincronizarClaseGmao(clase);

		return claseAux;
	}

	/**
	 * Method 'getCreateForm2'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "nuevo", method = RequestMethod.GET)
	public String getCreateForm2(Model model, HttpServletRequest request) {
		ClaseController.logger.info("[GET - View] : nueva clase");
		model.addAttribute("accion", Aa20bConstantes.ACCION_NUEVO);

		request.getSession(true).setAttribute("accion",
				Aa20bConstantes.ACCION_NUEVO);
		return "editarClase";
	}

	/**
	 * Method 'nuevoClase'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/nuevoClase", method = RequestMethod.GET)
	public String nuevoMaquina(Model model) {

		ClaseController.logger.info("[GET - View] : nuevo clase");
		return "nuevoClase";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idClaseBusc
	 *            String
	 * @param ventanaOrigen
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return editarClase String
	 */
	@RequestMapping(value = "/buscarClase", method = RequestMethod.POST)
	public String getById(@RequestParam String idClaseBusc,
			@RequestParam String ventanaOrigen, Model model,
			HttpServletRequest request) {

		ClaseController.logger.info("[GET - findBy_PK] : Clase");

		Integer idClase = Integer.parseInt(request.getParameter("idClaseBusc"));

		Clase clase = new Clase();

		clase = this.getById(idClase);

		ClaseController.logger.info("[GET - findBy_PK] : Clase: "
				+ clase.toString());

		model.addAttribute("Clase", clase);
		model.addAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);

		// Meto en sesión la ventana origen
		request.getSession().setAttribute("ventanaOrigen", ventanaOrigen);
		model.addAttribute("ventanaOrigen", ventanaOrigen);

		return "editarClase";
	}

	@RequestMapping(value = "claseEsUsuPubli", method = RequestMethod.POST)
	public @ResponseBody
	Boolean claseEsUsuPubli(Integer idClase) {

		Boolean esUsuPubli = this.claseService.claseEsUsuPubli(idClase);
		logger.info("[GET - View] : claseEsUsuPubli");

		return esUsuPubli;
	}

}
