package com.ejie.aa20b.control;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.aa20b.ldap.SecurityHelpperException;
import com.ejie.aa20b.model.Agenda;
import com.ejie.aa20b.model.Clase;
import com.ejie.aa20b.model.Codigo;
import com.ejie.aa20b.model.Edificios;
import com.ejie.aa20b.model.Ficha;
import com.ejie.aa20b.model.Fichatecnico;
import com.ejie.aa20b.model.Fichatecnicosgmao;
import com.ejie.aa20b.model.Gamas;
import com.ejie.aa20b.model.Maquinas;
import com.ejie.aa20b.model.Partes;
import com.ejie.aa20b.model.Partetecnicos;
import com.ejie.aa20b.model.Partetecnicosgmao;
import com.ejie.aa20b.model.Plantas;
import com.ejie.aa20b.model.Presencia;
import com.ejie.aa20b.model.Tecnicos;
import com.ejie.aa20b.model.Usuarios;
import com.ejie.aa20b.model.Usutecnicos;
import com.ejie.aa20b.model.Zonas;
import com.ejie.aa20b.service.Aa20bProcesosJMSService;
import com.ejie.aa20b.service.FichaService;
import com.ejie.aa20b.service.FichatecnicoService;
import com.ejie.aa20b.service.FichatecnicosgmaoService;
import com.ejie.aa20b.service.PartesService;
import com.ejie.aa20b.service.PartetecnicosService;
import com.ejie.aa20b.service.PartetecnicosgmaoService;
import com.ejie.aa20b.service.PresenciaService;
import com.ejie.aa20b.service.TecnicosService;
import com.ejie.aa20b.service.UsuariosService;
import com.ejie.aa20b.service.UsutecnicosService;
import com.ejie.aa20b.util.Aa20bConstantes;

/**
 * PresenciaController generated by UDA, 30-abr-2015 12:53:01.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/agenda")
public class AgendaController {

	private static final Logger logger = LoggerFactory
			.getLogger(AgendaController.class);

	@Autowired
	private PropertiesFactoryBean appConfiguration;

	@Autowired
	private PartesService partesService;

	@Autowired
	private TecnicosService tecnicosService;

	@Autowired
	private PresenciaService presenciaService;

	@Autowired
	private PartetecnicosService partetecnicosService;

	@Autowired
	private FichatecnicoService fichatecnicosService;

	@Autowired
	private PartetecnicosgmaoService partetecnicosgmaoService;

	@Autowired
	private FichatecnicosgmaoService fichatecnicosgmaoService;

	@Autowired
	private Aa20bProcesosJMSService procesosgmaoService;

	@Autowired
	private FichaService fichasService;

	@Autowired
	private UsuarioXLNETController usuarioXLNETController;

	@Autowired
	private ReloadableResourceBundleMessageSource appMessageSource;

	@Autowired
	private UsutecnicosService usutecnicosService;

	@Autowired
	private ProcesosGmaoController procesosGmaoController;

	@Autowired
	private TecnicosController tecnicosController;

	@Autowired
	private UsuariosService usuariosService;

	@RequestMapping(value = "inicioAgenda", method = RequestMethod.GET)
	public String getCreateFormAgenda(Model model, HttpServletRequest request,
			Locale locale) {

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) { // TODO Auto-generated catch
												// block
			e.printStackTrace();
		}

		model.addAttribute("idUsuario", sUIDUsuario);

		// Miramos si la fecha esta guardada en la request de anterior busqueda
		if (request.getParameter("fechaAgenda") != null
				&& !request.getParameter("fechaAgenda").equals("")) {
			model.addAttribute("fechaAgendaStr",
					request.getParameter("fechaAgenda"));

		}

		request.getSession().removeAttribute("FiltroAgendaCorrectivo");
		request.getSession().removeAttribute("FiltroAgendaPreventivo");

		return "inicioAgenda";
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model, HttpServletRequest request,
			Locale locale) {
		AgendaController.logger.info("[GET - View] : agenda");

		String sUIDUsuario = "";
		try {
			sUIDUsuario = this.usuarioXLNETController
					.obtenerUsuarioXLNET(request);
		} catch (SecurityHelpperException e) { // TODO Auto-generated catch
												// block
			e.printStackTrace();
		}

		/**
		 * Sincronizamos la información con los moviles tanto de presencia como
		 * de los partes
		 */
		try {
			this.procesosGmaoController.sincronizarTodasPresencias();
			this.procesosGmaoController.bajarTodasOTsGmao();
		} catch (Exception e) {
			AgendaController.logger.info("Error al sincronizar con GMAO");
		}

		/**
		 * Si no se ha introducido fechas Cargamos los datos por defecto de la
		 * semana actual situando el día actual en medio. Desde 3 días por
		 * detras. Por cada técnico obtenemos los partes que tenga asignados.
		 * Además cargamos los partes que estén sin asignar para cada día, tanto
		 * correctivos como preventivos
		 */
		Calendar cal = Calendar.getInstance(Locale.GERMAN);

		cal.set(Calendar.HOUR_OF_DAY, 0); // ! clear would not reset the hour of
		cal.clear(Calendar.MINUTE);
		cal.clear(Calendar.SECOND);
		cal.clear(Calendar.MILLISECOND);

		SimpleDateFormat formatterFiltro = new SimpleDateFormat("dd/MM/yyyy");
		SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");

		// Formato fechas dependiendo del idioma
		String idioma = locale.getLanguage();
		if (idioma.equals(Aa20bConstantes.IDIOMA_EUSKERA)) {
			formatterFiltro = new SimpleDateFormat("yyyy/MM/dd");
			formatter = new SimpleDateFormat("yyyy-MM-dd");
		}
		// Se comprueba si ha introducido fecha de búsqueda o tenía
		// de filtro anterior
		if (request.getParameter("fechaplanif") != null
				&& !request.getParameter("fechaplanif").equals("")) {
			try {
				String fechareDstr = request.getParameter("fechaplanif");
				Date fechaplanifDdate = formatterFiltro.parse(fechareDstr);
				cal.setTime(fechaplanifDdate);
			} catch (ParseException pe) {
				String fechareDstr = request.getParameter("fechaplanif");
				try {
					Date fechaplanifDdate = formatter.parse(fechareDstr);
					cal.setTime(fechaplanifDdate);
				} catch (ParseException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else if (request.getParameter("fechaActualStr") != null
				&& !request.getParameter("fechaActualStr").equals("")) {
			// Si no ha introducido fecha, comprobamos si tiene fecha guardada
			// de una búsqueda anterior (al cambiar de semana con los botones)
			Date fechaBusqueda = new Date();
			try {
				String fechaAgendaDesde = request
						.getParameter("fechaActualStr");
				fechaBusqueda = formatter.parse(fechaAgendaDesde);
				cal.setTime(fechaBusqueda);
			} catch (Exception e) {
				e.printStackTrace();
			}
		} else {
			cal.setTime(cal.getTime());
		}
		Date fechaBusqueda = cal.getTime();
		String fechaBusqStr = formatter.format(fechaBusqueda);
		model.addAttribute("fechaActualStr", fechaBusqStr);

		// Ponemos marcado el cuarto día, ya que siempre se quedará el día
		// de búsqueda en la posicion 4 de la tabla
		int diaMarcado = 4;
		model.addAttribute("diaSemanaActual", diaMarcado);

		int diaMes = cal.get(Calendar.DAY_OF_MONTH);
		int anio = cal.get(Calendar.YEAR);
		int numDiasBusqueda = 7;
		model.addAttribute("numDiasBusqueda", numDiasBusqueda);

		// Creación de listas y objetos
		List<Object> listaPartesDiaAsignados = new ArrayList<Object>();
		List<Partes> listaPartesDiaSinAsignar = new ArrayList<Partes>();
		List<Object> listaTotalCorrectivosDiasAsignados = new ArrayList<Object>();
		List<Object> listaTotalCorrectivosDiasSinAsignar = new ArrayList<Object>();
		List<Object> listaFichasDiaAsignados = new ArrayList<Object>();
		List<Ficha> listaFichasDiaSinAsignar = new ArrayList<Ficha>();
		List<Object> listaTotalPreventivosDiasAsignados = new ArrayList<Object>();
		List<Object> listaTotalPreventivosDiasSinAsignar = new ArrayList<Object>();
		// Inicializamos la posicion 0 con una lista vacía ya que el día 0 no
		// existe
		listaTotalCorrectivosDiasAsignados.add(0, listaPartesDiaAsignados);
		listaTotalCorrectivosDiasSinAsignar.add(0, listaPartesDiaSinAsignar);
		listaTotalPreventivosDiasAsignados.add(0, listaFichasDiaAsignados);
		listaTotalPreventivosDiasSinAsignar.add(0, listaFichasDiaSinAsignar);

		// Tabla dias números
		List<String> listaDiasSemana = new ArrayList<String>();
		listaDiasSemana.add(0, this.appMessageSource.getMessage(
				"agenda.tecnicotitulo", null, locale));

		// Obtenemos los técnicos asociados al usuario
		List<Usutecnicos> listaTecnicosAsignadosAlta = new ArrayList<Usutecnicos>();

		/**
		 * Si se ha filtrado desde la pantalla se cogen los datos del combo de
		 * técnicos. Por el contrario se obtendrán de la BBDD
		 */
		if (request.getParameter("tecnicos") != null
				&& !request.getParameter("tecnicos").equals("")) {
			String[] listaTecn = request.getParameter("tecnicos").split(",");
			for (String idTecnicoStr : listaTecn) {
				if (idTecnicoStr != null && !idTecnicoStr.equals("")) {
					Usutecnicos usutec = new Usutecnicos();
					usutec.setIdtecnico(Long.valueOf(idTecnicoStr));
					usutec.setUidPer(sUIDUsuario);
					usutec = this.usutecnicosService.findTecnicoUsuario(usutec);
					listaTecnicosAsignadosAlta.add(usutec);
				}
			}
		} else {
			listaTecnicosAsignadosAlta = this.usutecnicosService
					.obtenerTecnicosUsuarioAsignados(sUIDUsuario);
		}

		// Por cada técnico asociado, lo metemos en la lista listaTecnicosBusq,
		// que serán
		// los que se busquen los partes por día
		List<Tecnicos> listaTecnicosBusq = new ArrayList<Tecnicos>();
		for (Usutecnicos usutecAux : listaTecnicosAsignadosAlta) {

			Tecnicos tecnicoAux = new Tecnicos();
			if (usutecAux != null && usutecAux.getTecnico() != null) {
				tecnicoAux = usutecAux.getTecnico();
				if (tecnicoAux.getBaja() == null
						|| (tecnicoAux.getBaja() != null && tecnicoAux
								.getBaja().equals("0"))) {
					if (usutecAux.getIdtecnico() != null) {
						tecnicoAux.setIdtecnico(usutecAux.getIdtecnico());
						tecnicoAux = this.tecnicosService.find(tecnicoAux);
						if (tecnicoAux != null) {
							// Comprobamos la presencia
							Presencia presencia = new Presencia();
							presencia.setIdtecnico(usutecAux.getIdtecnico());
							if (this.presenciaService
									.comprobarTecnicoEstaPresente(presencia)) {
								tecnicoAux.setPresente(true);
								// Obtenemos la fecha desde la que está
								// presente
								presencia = this.presenciaService
										.obtenerFechaPresente(presencia);
								if (presencia != null) {
									tecnicoAux.setFechaPresente(presencia
											.getFhdesde());
								}

							} else {
								tecnicoAux.setPresente(false);
							}
							listaTecnicosBusq.add(tecnicoAux);
						}
					}
				}
			}
		}

		model.addAttribute("numTecnicosUsuario", listaTecnicosBusq.size());

		int mes = cal.get(Calendar.MONTH) + 1;
		int mesInicio = 0;
		int mesFin = 0;
		int anioInicio = 0;
		String fechaDelDiaStr = "";

		/**
		 * Obtenemos la información del filtro de búsqueda tanto de correctivos
		 * como de preventivos
		 */
		Partes filtroParte = new Partes();
		Ficha filtroFicha = new Ficha();
		String tipoBusqueda = "T";
		Maquinas maquinaAux = new Maquinas();
		if (request.getParameter("idedificio") != null
				&& !request.getParameter("idedificio").equals("")) {
			filtroParte.setIdedificio(request.getParameter("idedificio"));
			Edificios edifAux = new Edificios();
			edifAux.setIdedificio(request.getParameter("idedificio"));
			maquinaAux.setEdificio(edifAux);
			maquinaAux.setIdedificio(request.getParameter("idedificio"));
			filtroFicha.setMaquina(maquinaAux);
		}
		if (request.getParameter("zona") != null
				&& !request.getParameter("zona").equals("")) {
			Zonas zonaAux = new Zonas();
			zonaAux.setCzona(request.getParameter("zona"));
			filtroParte.setZona(zonaAux);
			maquinaAux.setZona(zonaAux);
			filtroFicha.setMaquina(maquinaAux);
		}
		if (request.getParameter("planta") != null
				&& !request.getParameter("planta").equals("")) {
			Plantas plantaAux = new Plantas();
			plantaAux.setCplanta(request.getParameter("planta"));
			filtroParte.setPlanta(plantaAux);
			maquinaAux.setPlanta(plantaAux);
			filtroFicha.setMaquina(maquinaAux);
		}

		if (request.getParameter("ejecutado") != null
				&& !request.getParameter("ejecutado").equals("")) {
			filtroParte.setEjecutado(request.getParameter("ejecutado"));
			filtroFicha.setEjecutado(request.getParameter("ejecutado"));
		}

		if (request.getParameter("parado") != null
				&& !request.getParameter("parado").equals("")) {
			filtroParte.setParado(request.getParameter("parado"));
			filtroFicha.setParado(request.getParameter("parado"));
		}

		// Comprobamos si solo quiere buscar los de móvil, sin móvil o todos
		Agenda agendaAux = new Agenda();
		if (request.getParameter("tipoEnvio") != null
				&& !request.getParameter("tipoEnvio").equals("")
				&& !request.getParameter("tipoEnvio").equals("2")) {
			agendaAux.setMovilgmao(request.getParameter("tipoEnvio"));
			filtroParte.setAgenda(agendaAux);
			filtroFicha.setAgenda(agendaAux);
		}
		/**
		 * Si ha introducido en el filtro un estado, no buscaremos en los partes
		 * sin asignar
		 */
		boolean buscarSinAsignar = true;
		if (request.getParameter("estado") != null
				&& !request.getParameter("estado").equals("")) {
			buscarSinAsignar = false;
			agendaAux.setEstadogmao(request.getParameter("estado"));
			filtroParte.setAgenda(agendaAux);
			filtroFicha.setAgenda(agendaAux);
		}

		if (request.getParameter("tipoBusqueda") != null
				&& !request.getParameter("tipoBusqueda").equals("")) {
			tipoBusqueda = request.getParameter("tipoBusqueda");
		}
		if (tipoBusqueda.equals("C")) {
			// Correctivos
			if (request.getParameter("nombre") != null
					&& !request.getParameter("nombre").equals("")) {
				filtroParte.setNombre(request.getParameter("nombre"));
			}
			if (request.getParameter("iddepar") != null
					&& !request.getParameter("iddepar").equals("")) {
				filtroParte.setIddepar(Long.valueOf(request
						.getParameter("iddepar")));
			}
			if (request.getParameter("iddir") != null
					&& !request.getParameter("iddir").equals("")) {
				filtroParte.setIddir(Integer.valueOf(request
						.getParameter("iddir")));
			}

			if (request.getParameter("clase") != null
					&& !request.getParameter("clase").equals("")) {
				Clase claseAux = new Clase();
				claseAux.setCclase(request.getParameter("clase"));
				filtroParte.setClase(claseAux);
			}
			if (request.getParameter("codigo") != null
					&& !request.getParameter("codigo").equals("")) {
				Codigo codigoAux = new Codigo();
				codigoAux.setCcodigo(request.getParameter("codigo"));
				filtroParte.setCodigo(codigoAux);
			}
			if (request.getParameter("strServicio") != null
					&& !request.getParameter("strServicio").equals("")) {
				filtroParte.setStrServicio(request.getParameter("strServicio"));
			}

			if (request.getParameter("urgente") != null
					&& !request.getParameter("urgente").equals("")) {
				filtroParte.setUrgente(request.getParameter("urgente"));
			}
			if (request.getParameter("vip") != null
					&& !request.getParameter("vip").equals("")) {
				filtroParte.setVip(request.getParameter("vip"));
			}
			if (request.getParameter("noProcede") != null
					&& !request.getParameter("noProcede").equals("")) {
				filtroParte.setNoProcede(request.getParameter("noProcede"));
			}
		}
		request.getSession()
				.setAttribute("FiltroAgendaCorrectivo", filtroParte);

		model.addAttribute("FiltroAgendaC", filtroParte);

		if (tipoBusqueda.equals("P")) {
			// Preventivos
			if (request.getParameter("mcodigo") != null
					&& !request.getParameter("mcodigo").equals("")) {
				maquinaAux.setMcodigo(request.getParameter("mcodigo"));
				filtroFicha.setMaquina(maquinaAux);
			}
			if (request.getParameter("maquina") != null
					&& !request.getParameter("maquina").equals("")) {
				maquinaAux.setCmaquina(request.getParameter("maquina"));
				filtroFicha.setMaquina(maquinaAux);
			}
			if (request.getParameter("gama") != null
					&& !request.getParameter("gama").equals("")) {
				Gamas gamaAux = new Gamas();
				gamaAux.setCgama(request.getParameter("gama"));
				maquinaAux.setGama(gamaAux);
				filtroFicha.setMaquina(maquinaAux);
			}
			if (request.getParameter("pendEjec") != null
					&& !request.getParameter("pendEjec").equals("")) {
				filtroFicha.setPendEjec(request.getParameter("pendEjec"));
			}
		}

		request.getSession()
				.setAttribute("FiltroAgendaPreventivo", filtroFicha);
		model.addAttribute("FiltroAgendaP", filtroFicha);

		/**
		 * Por cada día de la semana de búsqueda obtendremos los partes
		 * correctivos y preventivos de cada técnico del usuario
		 */

		// Obtener Servicio al que perteneceel usuario logueado
		Usuarios usuario = new Usuarios();
		usuario.setUidPer(sUIDUsuario);
		usuario.setBaja("0");
		usuario = this.usuariosService.find(usuario);
		// Restamos los días a la fecha actual para que se muestren los
		// anteriores (mitad de semana)
		cal.add(Calendar.DATE, -4);
		for (int i = 1; i <= numDiasBusqueda; i++) {
			int numDia = i + 1;
			cal.add(Calendar.DATE, 1);
			Date fechaInicio = new Date();
			cal.set(Calendar.HOUR_OF_DAY, 0);
			cal.set(Calendar.MINUTE, 0);
			cal.set(Calendar.SECOND, 0);
			fechaInicio = cal.getTime();
			mesInicio = cal.get(Calendar.MONTH) + 1;
			numDia = cal.get(Calendar.DAY_OF_WEEK) - 1;
			// Si el numDia da 0 significa que es domingo, le ponemos como 7
			if (numDia == 0) {
				numDia = 7;
			}
			/**
			 * Guardamos la tabla con cada día
			 */
			diaMes = cal.get(Calendar.DAY_OF_MONTH);
			String diaStr = this.appMessageSource.getMessage("agenda.dia"
					+ numDia, null, locale);
			listaDiasSemana.add(i, diaStr + " " + diaMes);

			Date fechaFin = new Date();
			fechaFin = cal.getTime();
			mesFin = cal.get(Calendar.MONTH) + 1;

			// Búsqueda por cada día
			anioInicio = cal.get(Calendar.YEAR);
			fechaDelDiaStr = anioInicio + "-" + mesInicio + "-" + diaMes;
			filtroParte.setFechaplanifD(fechaInicio);
			filtroParte.setFechaplanifH(fechaFin);
			listaPartesDiaSinAsignar = new ArrayList<Partes>();

			// En las búsquedas sin asignar tenemos en cuenta el servicio del
			// usuario
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				Gamas gama = new Gamas();
				if (filtroParte != null && filtroParte.getCodigo() != null) {
					codigo = filtroParte.getCodigo();
				}
				if (filtroFicha.getGama() != null) {
					gama = filtroFicha.getGama();
				}
				gama.setIdservicio(usuario.getIdservicio());
				codigo.setIdservicio(usuario.getIdservicio());
				filtroFicha.setGama(gama);
				filtroParte.setCodigo(codigo);
			}

			// INMA 23/06/2017 - Para que sólo muestre los partes de la clase
			// asignada
			filtroParte.setIdclase(usuario.getIdClase());

			/**
			 * Comprobamos si buscar los partes correctivos sin asignar o no. No
			 * se buscarán: -Si ha introducido en el filtro busqueda por estado
			 * (gmao) -Si se trata de una búsqueda solo de preventivos
			 */
			if (buscarSinAsignar
					&& (tipoBusqueda.equals("T") || tipoBusqueda.equals("C"))) {

				listaPartesDiaSinAsignar = this.partesService
						.obtenerDatosAgendaGrid(filtroParte, null, false,
								sUIDUsuario, false, null);
			}
			filtroFicha.setFechaplanifD(fechaInicio);
			filtroFicha.setFechaplanifH(fechaFin);
			listaFichasDiaSinAsignar = new ArrayList<Ficha>();
			/**
			 * Comprobamos si buscar los partes preventivos sin asignar o no. No
			 * se buscarán: -Si ha introducido en el filtro busqueda por estado
			 * (gmao) -Si se trata de una búsqueda solo de correctivos
			 */
			if (buscarSinAsignar
					&& (tipoBusqueda.equals("T") || tipoBusqueda.equals("P"))) {

				listaFichasDiaSinAsignar = this.fichasService
						.obtenerDatosAgendaGrid(filtroFicha, null, false,
								sUIDUsuario, false, null);
			}

			// En las búsquedas asignados NO tenemos en cuenta el servicio del
			// usuario
			if (usuario != null && usuario.getIdservicio() != null) {
				Codigo codigo = new Codigo();
				Gamas gama = new Gamas();
				if (filtroParte != null && filtroParte.getCodigo() != null) {
					codigo = filtroParte.getCodigo();
				}
				if (filtroFicha.getGama() != null) {
					gama = filtroFicha.getGama();
				}
				gama.setIdservicio(null);
				codigo.setIdservicio(null);
				filtroFicha.setGama(gama);
				filtroParte.setCodigo(codigo);
			}

			// Inicializo las listas de asignados
			listaPartesDiaAsignados = new ArrayList<Object>();
			listaFichasDiaAsignados = new ArrayList<Object>();
			// Por cada día buscamos por cada técnico de alta asociado
			List<Partes> listaPartesDiaAsignadosTecnico = new ArrayList<Partes>();
			if ((tipoBusqueda.equals("T") || tipoBusqueda.equals("C"))
					&& listaTecnicosBusq.size() > 0) {
				listaPartesDiaAsignadosTecnico = this.partesService
						.obtenerDatosAgendaGrid(filtroParte, null, false,
								sUIDUsuario, true, listaTecnicosBusq);
			}

			/*
			 * if (listaPartesDiaAsignadosTecnico.size() > 0) {
			 * listaPartesDiaAsignados.add(listaPartesDiaAsignadosTecnico); }
			 */
			/**
			 * Preventivos por cada técnico. Se buscará si la busqueda es por
			 * todos o por preventivos
			 */
			List<Ficha> listaFichasDiaAsignadoTecnico = new ArrayList<Ficha>();
			if ((tipoBusqueda.equals("T") || tipoBusqueda.equals("P"))
					&& listaTecnicosBusq.size() > 0) {
				listaFichasDiaAsignadoTecnico = this.fichasService
						.obtenerDatosAgendaGrid(filtroFicha, null, false,
								sUIDUsuario, true, listaTecnicosBusq);
			}
			/*
			 * if (listaFichasDiaAsignadoTecnico.size() > 0) {
			 * listaFichasDiaAsignados.add(listaFichasDiaAsignadoTecnico); }
			 */
			/*
			 * for (Tecnicos tecnicoAux : listaTecnicosBusq) {
			 * 
			 * if (tecnicoAux != null) { String idTecnico =
			 * tecnicoAux.getIdtecnico().toString(); /** Correctivos por cada
			 * técnico. Se buscará si la busqueda es por todos o por correctivos
			 * 
			 * List<Partes> listaPartesDiaAsignadosTecnico = new
			 * ArrayList<Partes>(); if (tipoBusqueda.equals("T") ||
			 * tipoBusqueda.equals("C")) { listaPartesDiaAsignadosTecnico =
			 * this.partesService .obtenerDatosAgendaGrid(filtroParte, null,
			 * false, sUIDUsuario, true, idTecnico); }
			 * 
			 * if (listaPartesDiaAsignadosTecnico.size() > 0) {
			 * listaPartesDiaAsignados .add(listaPartesDiaAsignadosTecnico); }
			 * /** Preventivos por cada técnico. Se buscará si la busqueda es
			 * por todos o por preventivos
			 * 
			 * List<Ficha> listaFichasDiaAsignadoTecnico = new
			 * ArrayList<Ficha>(); if (tipoBusqueda.equals("T") ||
			 * tipoBusqueda.equals("P")) { listaFichasDiaAsignadoTecnico =
			 * this.fichasService .obtenerDatosAgendaGrid(filtroFicha, null,
			 * false, sUIDUsuario, true, idTecnico); } if
			 * (listaFichasDiaAsignadoTecnico.size() > 0) {
			 * listaFichasDiaAsignados .add(listaFichasDiaAsignadoTecnico); } }
			 * }
			 */
			// Añado cada lista en el indice del día
			listaTotalCorrectivosDiasAsignados.add(i,
					listaPartesDiaAsignadosTecnico);
			listaTotalCorrectivosDiasSinAsignar
					.add(i, listaPartesDiaSinAsignar);

			listaTotalPreventivosDiasAsignados.add(i,
					listaFichasDiaAsignadoTecnico);
			listaTotalPreventivosDiasSinAsignar
					.add(i, listaFichasDiaSinAsignar);

			// Se suma uno al día para que cuadre con nuestro calendario
			model.addAttribute("dia" + i, fechaDelDiaStr);
		}
		// Si se muestran en pantalla días de meses diferentes. (TITULO MES)
		String mesStr = "";
		if (mesInicio < mes) {
			mesStr = this.appMessageSource.getMessage("agenda.mes" + (mes - 1),
					null, locale)
					+ " / "
					+ this.appMessageSource.getMessage("agenda.mes" + mes,
							null, locale);
		} else if (mesFin > mes) {
			mesStr = this.appMessageSource.getMessage("agenda.mes" + mes, null,
					locale)
					+ " / "
					+ this.appMessageSource.getMessage(
							"agenda.mes" + (mes + 1), null, locale);
		} else {
			mesStr = this.appMessageSource.getMessage("agenda.mes" + mes, null,
					locale);
		}

		// Añadimos todos los datos en el módelo para después recorrerlos en el
		// iframe del jsp
		model.addAttribute("listaTecnicosUsuario", listaTecnicosBusq);
		model.addAttribute("listaDiasSemana", listaDiasSemana);
		model.addAttribute("descripcionMesAnio", mesStr + " " + anio);
		model.addAttribute("listaTotalCorrectivosSinAsignar",
				listaTotalCorrectivosDiasSinAsignar);
		model.addAttribute("listaTotalCorrectivosAsignados",
				listaTotalCorrectivosDiasAsignados);

		model.addAttribute("listaTotalPreventivosSinAsignar",
				listaTotalPreventivosDiasSinAsignar);
		model.addAttribute("listaTotalPreventivosAsignados",
				listaTotalPreventivosDiasAsignados);

		model.addAttribute("idUsuario", sUIDUsuario);

		return "agenda";
	}

	/**
	 * Función para quitar la asignación de un parte correctivo o preventivo a
	 * un técnico Se produce cuando se arrastra un parte desde un técnico a la
	 * fila 'Sin asignar'
	 * 
	 * @param idParte
	 * @param fechaDestino
	 * @param idTecnico
	 * @param tipoParte
	 * @param compartido
	 * @param model
	 * @param request
	 * @param locale
	 */
	@RequestMapping(value = "/modificarAsignacionSinTecnico", method = RequestMethod.POST)
	public @ResponseBody
	void modificarAsignacionSinTecnico(@RequestParam Integer idParte,
			@RequestParam String fechaDestino, @RequestParam String idTecnico,
			@RequestParam String tipoParte, @RequestParam String compartido,
			Model model, HttpServletRequest request, Locale locale) {

		Partes parteAux = new Partes();
		Ficha fichaAux = new Ficha();
		if (tipoParte != null && tipoParte.equals("C")) {
			if (idParte != null) {
				parteAux.setIdparte(idParte);

				parteAux = this.partesService.find(parteAux);
				if (parteAux != null) {

					// Si el parte es compartido no actualizamos la fecha de
					// planificación
					if (compartido == null
							|| (compartido != null && compartido.equals("no"))) {
						SimpleDateFormat formatter = new SimpleDateFormat(
								"yyyy-MM-dd HH:mm:ss");
						try {
							parteAux.setFechaplanif(formatter
									.parse(fechaDestino));
						} catch (Exception e) {

						}

						parteAux = this.partesService
								.actualizarFechaPlanificacion(parteAux);
					}
					ArrayList<Long> tecnicosSeleccionados = new ArrayList<Long>();
					if (idTecnico != null && !idTecnico.equals("")) {
						tecnicosSeleccionados.add(Long.valueOf(idTecnico));

						this.tecnicosController.restaTecnicosParte(idParte,
								tecnicosSeleccionados, model, request);
					}
				}
			}
		} else if (tipoParte != null && tipoParte.equals("P")) {
			if (idParte != null) {
				fichaAux.setIdficha(idParte);
				fichaAux = this.fichasService.find(fichaAux);
				if (fichaAux != null) {
					// Si la ficha es compartida no actualizamos la fecha de
					// planificación
					if (compartido == null
							|| (compartido != null && compartido.equals("no"))) {
						SimpleDateFormat formatter = new SimpleDateFormat(
								"yyyy-MM-dd HH:mm:ss");
						try {
							fichaAux.setFechaplanif(formatter
									.parse(fechaDestino));
						} catch (Exception e) {

						}

						fichaAux = this.fichasService
								.actualizarFechaPlanificacion(fichaAux);
					}
					ArrayList<Long> tecnicosSeleccionados = new ArrayList<Long>();
					if (idTecnico != null && !idTecnico.equals("")) {
						tecnicosSeleccionados.add(Long.valueOf(idTecnico));
						this.tecnicosController.restaTecnicosFicha(
								fichaAux.getIdficha(), tecnicosSeleccionados,
								model, request);
					}
				}
			}
		}
	}

	/**
	 * Función que cambia la fecha de un parte ya sea correctivo o preventivo
	 * que está sin asignar. Se produce cuando se arrastra un parte de la fila
	 * 'Sin asignar' a la misma fila 'Sin asignar' pero diferente fecha (Fecha
	 * auto). O cuando se pulsa en el botón derecha de un parte sin asignar y se
	 * utiliza la función de cambiar fecha (Fecha que se formatea dependiendo
	 * del idioma).
	 * 
	 * @param idParte
	 * @param fechaDestino
	 * @param tipoParte
	 * @param compartido
	 * @param model
	 * @param request
	 * @param locale
	 */
	@RequestMapping(value = "/modificarFechaSinTecnico", method = RequestMethod.POST)
	public @ResponseBody
	void modificarFechaSinTecnico(@RequestParam Integer idParte,
			@RequestParam String fechaDestino, @RequestParam String tipoParte,
			@RequestParam String compartido, Model model,
			HttpServletRequest request, Locale locale) {

		Partes parteAux = new Partes();
		Ficha fichaAux = new Ficha();
		if (tipoParte != null && tipoParte.equals("C")) {
			if (idParte != null) {
				parteAux.setIdparte(idParte);

				parteAux = this.partesService.find(parteAux);
				if (parteAux != null) {
					// Primero se intenta formatear con el formato auto
					SimpleDateFormat formatter = new SimpleDateFormat(
							"yyyy-MM-dd HH:mm:ss");
					try {
						parteAux.setFechaplanif(formatter.parse(fechaDestino));
					} catch (Exception e) {
						// Si falla significa que viene de la pantalla de
						// cambiar fecha
						// y ya viene formateada. Comprobamos idioma
						if (locale.getLanguage().equals(
								Aa20bConstantes.IDIOMA_EUSKERA)) {
							formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
						} else {
							formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
						}
						try {
							parteAux.setFechaplanif(formatter
									.parse(fechaDestino));
						} catch (ParseException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					}
					parteAux = this.partesService
							.actualizarFechaPlanificacion(parteAux);

					/**
					 * Actualizamos la fecha en movilgmao si el parte está
					 * subido
					 **/
					Partetecnicosgmao partetecGmaoAux = new Partetecnicosgmao();
					partetecGmaoAux.setIdparte(idParte);

					partetecGmaoAux = this.partetecnicosgmaoService
							.findByIdParte(partetecGmaoAux);

					if (partetecGmaoAux != null
							&& partetecGmaoAux.getGuidpartetecgmao() != null) {

						String urlConfig = "";
						try {
							urlConfig = this.appConfiguration.getObject()
									.getProperty("movilgmao.path");
						} catch (Exception e) {

						}

						this.procesosgmaoService.subirOTcambioFechaPlanif(
								partetecGmaoAux.getGuidpartetecgmao(),
								parteAux.getFechaplanif(), urlConfig);
					}

				}
			}
		} else if (tipoParte != null && tipoParte.equals("P")) {
			if (idParte != null) {
				fichaAux.setIdficha(idParte);
				fichaAux = this.fichasService.find(fichaAux);
				if (fichaAux != null) {
					// Primero se intenta formatear con el formato auto
					SimpleDateFormat formatter = new SimpleDateFormat(
							"yyyy-MM-dd HH:mm:ss");
					try {
						fichaAux.setFechaplanif(formatter.parse(fechaDestino));
					} catch (Exception e) {
						// Si falla significa que viene de la pantalla de
						// cambiar fecha
						// y ya viene formateada. Comprobamos idioma
						if (locale.getLanguage().equals(
								Aa20bConstantes.IDIOMA_EUSKERA)) {
							formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
						} else {
							formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
						}
						try {
							fichaAux.setFechaplanif(formatter
									.parse(fechaDestino));
						} catch (ParseException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					}

					fichaAux = this.fichasService
							.actualizarFechaPlanificacion(fichaAux);

					/**
					 * Actualizamos la fecha en movilgmao si el parte está
					 * subido
					 **/
					Fichatecnicosgmao fichatecGmaoAux = new Fichatecnicosgmao();
					fichatecGmaoAux.setIdficha(fichaAux.getIdficha());

					fichatecGmaoAux = this.fichatecnicosgmaoService
							.findByIdFicha(fichatecGmaoAux);

					if (fichatecGmaoAux != null
							&& fichatecGmaoAux.getGuidfichatecgmao() != null) {

						String urlConfig = "";
						try {
							urlConfig = this.appConfiguration.getObject()
									.getProperty("movilgmao.path");
						} catch (Exception e) {

						}

						this.procesosgmaoService.subirOTcambioFechaPlanif(
								fichatecGmaoAux.getGuidfichatecgmao(),
								fichaAux.getFechaplanif(), urlConfig);
					}
				}
			}
		}

		// return parteAux;
	}

	/**
	 * Función para cambiar la asignación de un parte ya sea correctivo o
	 * preventivo de un técnico a otro Se produce cuando se arrastra un parte de
	 * la fila de un técnico a la fila de otro técnico
	 * 
	 * @param idParte
	 * @param fechaDestino
	 * @param idTecnico
	 * @param idTecnicoAnterior
	 * @param tipoParte
	 * @param compartido
	 * @param model
	 * @param request
	 * @param locale
	 */
	@RequestMapping(value = "/cambiarParteTecnico", method = RequestMethod.POST)
	public @ResponseBody
	void cambiarParteTecnico(@RequestParam Integer idParte,
			@RequestParam String fechaDestino, @RequestParam String idTecnico,
			@RequestParam String idTecnicoAnterior,
			@RequestParam String tipoParte, @RequestParam String compartido,
			Model model, HttpServletRequest request, Locale locale) {

		Partes parteAux = new Partes();
		Ficha fichaAux = new Ficha();
		if (tipoParte != null && tipoParte.equals("C")) {
			if (idParte != null) {
				parteAux.setIdparte(idParte);

				parteAux = this.partesService.find(parteAux);
				if (parteAux != null) {

					boolean tecYaTieneElParte = false;
					if (compartido != null && compartido.equals("si")) {
						// Al ser compartido, comprobamos si el técnico al que
						// se
						// esta asignando el parte ya lo tiene
						List<Partetecnicos> listaTecnicosParte = this.partetecnicosService
								.obtenerTecnicosParteAsociados(idParte);
						for (Partetecnicos parteTecAux : listaTecnicosParte) {
							if (parteTecAux != null
									&& parteTecAux.getIdtecnico() != null
									&& parteTecAux.getIdtecnico() != 0) {
								if (parteTecAux.getIdtecnico() == Long
										.valueOf(idTecnico)) {
									tecYaTieneElParte = true;
								}
							}
						}
					}
					SimpleDateFormat formatter = new SimpleDateFormat(
							"yyyy-MM-dd HH:mm:ss");
					try {
						parteAux.setFechaplanif(formatter.parse(fechaDestino));
					} catch (Exception e) {
						// Si falla significa que viene de la pantalla de
						// asignar a otro tecnico
						// y ya viene formateada la fecha. Comprobamos idioma
						if (locale.getLanguage().equals(
								Aa20bConstantes.IDIOMA_EUSKERA)) {
							formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
						} else {
							formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
						}
						try {
							parteAux.setFechaplanif(formatter
									.parse(fechaDestino));
						} catch (ParseException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					}
					parteAux = this.partesService
							.actualizarFechaPlanificacion(parteAux);

					ArrayList<Long> tecnicosSeleccionados = new ArrayList<Long>();

					if (idTecnico != null && !idTecnico.equals("")
							&& idTecnicoAnterior != null
							&& !idTecnicoAnterior.equals("")) {

						// Si el técnico no tiene el parte ya asignado
						// (compartido), se lo sumamos
						if (!tecYaTieneElParte) {
							tecnicosSeleccionados.add(Long.valueOf(idTecnico));
							this.tecnicosController.sumaTecnicosParte(idParte,
									tecnicosSeleccionados, model, request);
						}
						tecnicosSeleccionados = new ArrayList<Long>();
						tecnicosSeleccionados.add(Long
								.valueOf(idTecnicoAnterior));

						this.tecnicosController.restaTecnicosParte(idParte,
								tecnicosSeleccionados, model, request);
					}
				}
			}
		} else if (tipoParte != null && tipoParte.equals("P")) {
			if (idParte != null) {
				fichaAux.setIdficha(idParte);
				fichaAux = this.fichasService.find(fichaAux);
				if (fichaAux != null) {

					boolean tecYaTieneLaFicha = false;
					if (compartido != null && compartido.equals("si")) {
						// Al ser compartido, comprobamos si el técnico al que
						// se
						// esta asignando a la ficha ya la tiene
						List<Fichatecnico> listaTecnicosFicha = this.fichatecnicosService
								.obtenerTecnicosFichaAsociados(fichaAux
										.getIdficha());
						for (Fichatecnico fichaTecAux : listaTecnicosFicha) {
							if (fichaTecAux != null
									&& fichaTecAux.getIdtecnico() != null
									&& fichaTecAux.getIdtecnico() != 0) {
								if (fichaTecAux.getIdtecnico() == Long
										.valueOf(idTecnico)) {
									tecYaTieneLaFicha = true;
								}
							}
						}
					}
					SimpleDateFormat formatter = new SimpleDateFormat(
							"yyyy-MM-dd HH:mm:ss");
					try {
						fichaAux.setFechaplanif(formatter.parse(fechaDestino));
					} catch (Exception e) {
						// Si falla significa que viene de la pantalla de
						// asignar a otro tecnico
						// y ya viene formateada la fecha. Comprobamos idioma
						if (locale.getLanguage().equals(
								Aa20bConstantes.IDIOMA_EUSKERA)) {
							formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
						} else {
							formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
						}
						try {
							fichaAux.setFechaplanif(formatter
									.parse(fechaDestino));
						} catch (ParseException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					}

					fichaAux = this.fichasService
							.actualizarFechaPlanificacion(fichaAux);

					ArrayList<Long> tecnicosSeleccionados = new ArrayList<Long>();
					if (idTecnico != null && !idTecnico.equals("")
							&& idTecnicoAnterior != null
							&& !idTecnicoAnterior.equals("")) {

						// Si el técnico no tiene la ficha ya asignado
						// (compartida), se lo sumamos
						if (!tecYaTieneLaFicha) {
							tecnicosSeleccionados.add(Long.valueOf(idTecnico));
							this.tecnicosController.sumaTecnicosFicha(
									fichaAux.getIdficha(),
									tecnicosSeleccionados, model, request);
						}

						tecnicosSeleccionados = new ArrayList<Long>();
						tecnicosSeleccionados.add(Long
								.valueOf(idTecnicoAnterior));
						this.tecnicosController.restaTecnicosFicha(
								fichaAux.getIdficha(), tecnicosSeleccionados,
								model, request);
					}

				}
			}
		}

		// return parteAux;
	}

	/**
	 * Función que asigna un parte ya sea correctivo o preventivo a un técnico.
	 * Se produce cuando se arrastra un parte desde la fila 'Sin asignar' a la
	 * fila de un técnico.
	 * 
	 * @param idParte
	 * @param fechaDestino
	 * @param idTecnico
	 * @param idTecnicoAnterior
	 * @param tipoParte
	 * @param compartido
	 * @param model
	 * @param request
	 * @param locale
	 */
	@RequestMapping(value = "/asignarParteTecnico", method = RequestMethod.POST)
	public @ResponseBody
	void asignarParteTecnico(@RequestParam Integer idParte,
			@RequestParam String fechaDestino, @RequestParam String idTecnico,
			@RequestParam String idTecnicoAnterior,
			@RequestParam String tipoParte, @RequestParam String compartido,
			Model model, HttpServletRequest request, Locale locale) {

		Partes parteAux = new Partes();
		Ficha fichaAux = new Ficha();
		if (tipoParte != null && tipoParte.equals("C")) {
			if (idParte != null) {
				parteAux.setIdparte(idParte);

				parteAux = this.partesService.find(parteAux);
				if (parteAux != null) {
					// Primero se intenta formatear con el formato auto
					SimpleDateFormat formatter = new SimpleDateFormat(
							"yyyy-MM-dd HH:mm:ss");
					try {
						parteAux.setFechaplanif(formatter.parse(fechaDestino));
					} catch (Exception e) {
						// Si falla significa que viene de la pantalla de
						// cambiar fecha
						// y ya viene formateada. Comprobamos idioma
						if (locale.getLanguage().equals(
								Aa20bConstantes.IDIOMA_EUSKERA)) {
							formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
						} else {
							formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
						}
						try {
							parteAux.setFechaplanif(formatter
									.parse(fechaDestino));
						} catch (ParseException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					}

					parteAux = this.partesService
							.actualizarFechaPlanificacion(parteAux);

					ArrayList<Long> tecnicosSeleccionados = new ArrayList<Long>();
					if (idTecnico != null && !idTecnico.equals("")) {
						tecnicosSeleccionados.add(Long.valueOf(idTecnico));

						this.tecnicosController.sumaTecnicosParte(idParte,
								tecnicosSeleccionados, model, request);
					}
				}
			}
		} else if (tipoParte != null && tipoParte.equals("P")) {
			if (idParte != null) {
				fichaAux.setIdficha(idParte);
				fichaAux = this.fichasService.find(fichaAux);
				if (fichaAux != null) {
					// Primero se intenta formatear con el formato auto
					SimpleDateFormat formatter = new SimpleDateFormat(
							"yyyy-MM-dd HH:mm:ss");
					try {
						fichaAux.setFechaplanif(formatter.parse(fechaDestino));
					} catch (Exception e) {
						// Si falla significa que viene de la pantalla de
						// cambiar fecha
						// y ya viene formateada. Comprobamos idioma
						if (locale.getLanguage().equals(
								Aa20bConstantes.IDIOMA_EUSKERA)) {
							formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
						} else {
							formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
						}
						try {
							fichaAux.setFechaplanif(formatter
									.parse(fechaDestino));
						} catch (ParseException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					}

					fichaAux = this.fichasService
							.actualizarFechaPlanificacion(fichaAux);

					ArrayList<Long> tecnicosSeleccionados = new ArrayList<Long>();
					if (idTecnico != null && !idTecnico.equals("")) {

						tecnicosSeleccionados.add(Long.valueOf(idTecnico));
						this.tecnicosController.sumaTecnicosFicha(
								fichaAux.getIdficha(), tecnicosSeleccionados,
								model, request);

					}
				}
			}
		}

		// return parteAux;
	}

	/**
	 * Función que cambia la fecha de un parte ya sea correctivo o preventivo
	 * que está asignado a un técnico Se produce cuando se arrastra un parte en
	 * la misma fila de un técnico pero diferente día (fecha auto). O se produce
	 * al dar al botón derecho sobre un parte asignado y utilizar la función de
	 * 'Cambiar fecha' (Fecha que se formatea dependiendo del idioma)
	 * 
	 * @param idParte
	 * @param fechaDestino
	 * @param idTecnico
	 * @param idTecnicoAnterior
	 * @param tipoParte
	 * @param compartido
	 * @param model
	 * @param request
	 * @param locale
	 */
	@RequestMapping(value = "/modificarFechaConTecnico", method = RequestMethod.POST)
	public @ResponseBody
	void modificarFechaConTecnico(@RequestParam Integer idParte,
			@RequestParam String fechaDestino, @RequestParam String idTecnico,
			@RequestParam String idTecnicoAnterior,
			@RequestParam String tipoParte, @RequestParam String compartido,
			Model model, HttpServletRequest request, Locale locale) {

		Partes parteAux = new Partes();
		Ficha fichaAux = new Ficha();
		if (tipoParte != null && tipoParte.equals("C")) {
			if (idParte != null) {
				parteAux.setIdparte(idParte);

				parteAux = this.partesService.find(parteAux);
				if (parteAux != null) {
					// Primero se intenta formatear con el formato auto
					SimpleDateFormat formatter = new SimpleDateFormat(
							"yyyy-MM-dd HH:mm:ss");
					try {
						parteAux.setFechaplanif(formatter.parse(fechaDestino));
					} catch (Exception e) {
						// Si falla significa que viene de la pantalla de
						// cambiar fecha
						// y ya viene formateada. Comprobamos idioma
						if (locale.getLanguage().equals(
								Aa20bConstantes.IDIOMA_EUSKERA)) {
							formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
						} else {
							formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
						}
						try {
							parteAux.setFechaplanif(formatter
									.parse(fechaDestino));
						} catch (ParseException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					}
					parteAux = this.partesService
							.actualizarFechaPlanificacion(parteAux);

					/**
					 * Actualizamos la fecha en movilgmao si el parte está
					 * subido Si es parte compartido actualizaremos los de todos
					 * los técnicos en gmao
					 **/
					List<Partetecnicos> listaTecnicosParteAux = this.partetecnicosService
							.obtenerTecnicosParteAsociados(parteAux
									.getIdparte());

					for (Partetecnicos parteTecAux : listaTecnicosParteAux) {
						if (parteTecAux != null) {
							Partetecnicosgmao partetecGmaoAux = new Partetecnicosgmao();
							partetecGmaoAux.setIdparte(idParte);
							partetecGmaoAux.setIdtecnico(parteTecAux
									.getIdtecnico());

							partetecGmaoAux = this.partetecnicosgmaoService
									.find(partetecGmaoAux);

							if (partetecGmaoAux != null
									&& partetecGmaoAux.getGuidpartetecgmao() != null) {

								String urlConfig = "";
								try {
									urlConfig = this.appConfiguration
											.getObject().getProperty(
													"movilgmao.path");
								} catch (Exception e) {

								}

								this.procesosgmaoService
										.subirOTcambioFechaPlanif(
												partetecGmaoAux
														.getGuidpartetecgmao(),
												parteAux.getFechaplanif(),
												urlConfig);
							}
						}
					}

				}
			}
		} else if (tipoParte != null && tipoParte.equals("P")) {
			if (idParte != null) {
				fichaAux.setIdficha(idParte);
				fichaAux = this.fichasService.find(fichaAux);
				if (fichaAux != null) {
					SimpleDateFormat formatter = new SimpleDateFormat(
							"yyyy-MM-dd HH:mm:ss");
					try {
						fichaAux.setFechaplanif(formatter.parse(fechaDestino));
					} catch (Exception e) {
						// Si falla significa que viene de la pantalla de
						// cambiar fecha
						// y ya viene formateada. Comprobamos idioma
						if (locale.getLanguage().equals(
								Aa20bConstantes.IDIOMA_EUSKERA)) {
							formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm");
						} else {
							formatter = new SimpleDateFormat("dd/MM/yyyy HH:mm");
						}
						try {
							fichaAux.setFechaplanif(formatter
									.parse(fechaDestino));
						} catch (ParseException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					}

					fichaAux = this.fichasService
							.actualizarFechaPlanificacion(fichaAux);

					/**
					 * Actualizamos la fecha en movilgmao si el parte está
					 * subido. Si la ficha es compartida actualizaremos la fecha
					 * para todos los técnicos en gmao
					 **/
					List<Fichatecnico> listaTecnicosFichaAux = this.fichatecnicosService
							.obtenerTecnicosFichaAsociados(fichaAux
									.getIdficha());

					for (Fichatecnico fichaTecAux : listaTecnicosFichaAux) {
						if (fichaTecAux != null) {
							Fichatecnicosgmao fichatecGmaoAux = new Fichatecnicosgmao();
							fichatecGmaoAux.setIdficha(idParte);
							fichatecGmaoAux.setIdtecnico(fichaTecAux
									.getIdtecnico());

							fichatecGmaoAux = this.fichatecnicosgmaoService
									.find(fichatecGmaoAux);

							if (fichatecGmaoAux != null
									&& fichatecGmaoAux.getGuidfichatecgmao() != null) {

								String urlConfig = "";
								try {
									urlConfig = this.appConfiguration
											.getObject().getProperty(
													"movilgmao.path");
								} catch (Exception e) {

								}

								this.procesosgmaoService
										.subirOTcambioFechaPlanif(
												fichatecGmaoAux
														.getGuidfichatecgmao(),
												fichaAux.getFechaplanif(),
												urlConfig);
							}
						}
					}

				}
			}
		}

		// return parteAux;
	}

}
