package com.ejie.aa20b.control;

import com.ejie.aa20b.service.ActuacionService;
import com.ejie.aa20b.service.PartesService;
import com.ejie.aa20b.util.Aa20bConstantes;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import java.util.ArrayList;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

import com.ejie.aa20b.model.Actuacion;
import com.ejie.aa20b.model.Partes;

/**
 * ActuacionController generated by UDA, 05-mar-2015 10:57:48.
 * 
 * @author UDA
 */

@Controller
@RequestMapping(value = "/actuacion")
public class ActuacionController {

	private static final Logger logger = LoggerFactory
			.getLogger(ActuacionController.class);

	@Autowired
	private ActuacionService actuacionService;

	@Autowired
	private PartesService partesService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public String getCreateForm(Model model) {
		ActuacionController.logger.info("[GET - View] : actuacion");
		return "actuacion";
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param idactuacion
	 *            Integer
	 * @return actuacion Actuacion
	 */
	@RequestMapping(value = "/{idactuacion}", method = RequestMethod.GET)
	public @ResponseBody
	Actuacion getById(@PathVariable Integer idactuacion) {
		Actuacion actuacion = new Actuacion();
		actuacion.setIdactuacion(idactuacion);
		actuacion = this.actuacionService.find(actuacion);
		ActuacionController.logger
				.info("[GET - findBy_PK] : Obtener Actuacion por PK");
		return actuacion;
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param filterActuacion
	 *            Actuacion
	 * @return List
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	List<Actuacion> getAll(@ModelAttribute Actuacion filterActuacion) {
		ActuacionController.logger
				.info("[GET - find_ALL] : Obtener Actuacion por filtro");
		return this.actuacionService.findAll(filterActuacion, null);
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Actuacion edit(@RequestBody Actuacion actuacion) {
		Actuacion actuacionAux = this.actuacionService.update(actuacion);
		ActuacionController.logger
				.info("[PUT] : Actuacion actualizado correctamente");
		return actuacionAux;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param actuacion
	 *            Actuacion
	 * @return Actuacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Actuacion add(@RequestBody Actuacion actuacion) {
		Actuacion actuacionAux = this.actuacionService.add(actuacion);
		ActuacionController.logger
				.info("[POST] : Actuacion insertado correctamente");
		return actuacionAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idactuacion
	 *            Integer
	 * @return actuacion
	 */
	@RequestMapping(value = "/{idactuacion}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Actuacion remove(@PathVariable Integer idactuacion) {
		Actuacion actuacion = new Actuacion();
		actuacion.setIdactuacion(idactuacion);
		this.actuacionService.remove(actuacion);
		ActuacionController.logger
				.info("[DELETE] : Actuacion borrado correctamente");
		return actuacion;
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param actuacionIds
	 *            List
	 * @return actuacionList
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	List<List<String>> removeMultiple(
			@RequestBody List<List<String>> actuacionIds) {
		List<Actuacion> actuacionList = new ArrayList<Actuacion>();
		for (List<String> actuacionId : actuacionIds) {
			Iterator<String> iterator = actuacionId.iterator();
			Actuacion actuacion = new Actuacion(); // NOPMD - Objeto nuevo en la
													// lista (parametro del
													// servicio)
			actuacion.setIdactuacion(ObjectConversionManager.convert(
					iterator.next(), Integer.class));
			actuacionList.add(actuacion);
		}
		this.actuacionService.removeMultiple(actuacionList);
		ActuacionController.logger
				.info("[POST - DELETE_ALL] : Actuacion borrados correctamente");
		return actuacionIds;
	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterActuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel getAllJQGrid(@ModelAttribute Actuacion filterActuacion,
			@ModelAttribute Pagination pagination) {
		List<Actuacion> actuacions = this.actuacionService.findAll(
				filterActuacion, pagination);
		Long recordNum = this.actuacionService.findAllCount(filterActuacion);
		ActuacionController.logger.info("[GET - jqGrid] : Obtener Actuacion");
		return new JQGridJSONModel(pagination, recordNum, actuacions);
	}

	/**
	 * Method 'gridActuacionesFicha'.
	 * 
	 * @param filterActuacion
	 *            Actuacion
	 * @param pagination
	 *            Pagination
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "gridActuacionesFicha", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody
	JQGridJSONModel gridActuacionesFicha(
			@ModelAttribute Actuacion filterActuacion,
			@ModelAttribute Pagination pagination, HttpServletRequest request) {

		List<Actuacion> actuacions = this.actuacionService.obtenerActuaciones(
				filterActuacion, pagination);
		Long recordNum = this.actuacionService
				.obtenerActuacionesCount(filterActuacion);
		ActuacionController.logger.info("[GET - jqGrid] : Obtener Actuacion");
		pagination.setSidx("nroorden asc");
		return new JQGridJSONModel(pagination, recordNum, actuacions);
	}

	/**
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "/modificar", method = RequestMethod.GET)
	public String getCreateFormModficar(Model model, HttpServletRequest request) {
		ActuacionController.logger.info("[GET - View] : modificar actuacion");

		Integer idActuacion = Integer.parseInt(request
				.getParameter("idActuacion"));

		Actuacion actuacion = new Actuacion();
		actuacion.setIdactuacion(idActuacion);

		Actuacion actuacionAux = this.actuacionService
				.obtenerActuacion(actuacion);

		ActuacionController.logger.info("[GET - View] : modificar actuacion : "
				+ actuacion.toString());

		model.addAttribute("Actuacion", actuacionAux);

		request.setAttribute("accion", Aa20bConstantes.ACCION_MODIFICAR);
		return "editarActuacion";
	}

	/**
	 * Method 'modificaActuacion'.
	 * 
	 * @param actuacion
	 *            Actuaciones
	 * @return Actuaciones
	 */
	@RequestMapping(value = "/modificaActuacion", method = RequestMethod.POST)
	public @ResponseBody
	Actuacion modificaActuacion(@RequestBody Actuacion actuacion) {

		ActuacionController.logger
				.info("[PUT] : Actuaciones antes de modificar : "
						+ actuacion.toString());
		Actuacion actuacionAux = this.actuacionService
				.modificaActuacion(actuacion);

		ActuacionController.logger
				.info("[PUT] : Actuaciones actualizado correctamente");
		return actuacionAux;

	}

	@RequestMapping(value = "/addNuevoParteCorrectivo", method = RequestMethod.POST)
	public @ResponseBody
	Partes addNuevoParteCorrectivo(@RequestBody Partes parte, Model model) {

		ActuacionController.logger.info("[POST] : ENTRAMOS EN ADD parte");

		Partes parteAux = this.partesService
				.nuevoParteCorrDesdePreventivo(parte);

		return parteAux;
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param idActuacion
	 *            Integer
	 * @param idParte
	 *            Integer
	 * @return ficha
	 */
	@RequestMapping(value = "eliminarActuacion/{idActuacion}/{idParte}", method = RequestMethod.DELETE)
	@ResponseStatus(value = HttpStatus.OK)
	public @ResponseBody
	Actuacion eliminarActuacion(@PathVariable Integer idActuacion,
			@PathVariable Integer idParte) {
		Actuacion actuacion = new Actuacion();
		actuacion.setIdactuacion(idActuacion);

		this.actuacionService.eliminarActuacion(actuacion, idParte);
		ActuacionController.logger
				.info("[DELETE] : Actuación Eliminada correctamente");
		return actuacion;
	}

	/**
	 * 
	 * Method 'parteTieneActuaciones'.
	 * 
	 * 
	 * puestoIntroducido String
	 * 
	 * @return List
	 */

	@RequestMapping(value = "/parteTieneActuaciones", method = RequestMethod.POST)
	public @ResponseBody
	Boolean parteTieneActuaciones(@RequestParam Integer idParte, Model model,
			HttpServletRequest request) {

		Actuacion actuaciones = new Actuacion();

		ActuacionController.logger
				.info("[POST - parteTieneActuaciones] : Comprobando si el parte tiene actuaciones. ");

		actuaciones.setIdparte(idParte);

		List<Actuacion> lsActuaciones = this.actuacionService.findAll(
				actuaciones, null);
		if (lsActuaciones.size() > 0) {
			return true;
		} else {
			return false;
		}

	}

}
