package com.ejie.aa20b.message;

import javax.annotation.Resource;
import javax.ejb.MessageDrivenContext;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;



public class Aa20bProcessErrorMessage {
	
	private Message message;
	
	@Resource
    private MessageDrivenContext context;
	
	/**
	 * Constructor por defecto
	 * 
	 * @param message
	 *            : Objeto de tipo Message con el mensaje de evento en
	 *            Tramitagune capturado por la clase MDB
	 */
	public Aa20bProcessErrorMessage(Message message) {
		this.message = message;
	}
	
	private static final Logger logger = LoggerFactory
	.getLogger(Aa20bProcessErrorMessage.class);
	
	/**
	 * Método que contiene la lógica de procesamiento del mensaje de evento
	 */
	public void onMessage() {
		
		Aa20bProcessErrorMessage.logger.info("(onMessage) Recuperando objeto del mensaje del evento");		
		
    	try{
    		//int operacion = message.getIntProperty("operacion");
    		//Aa20bProcessErrorMessage.logger.info("Operacion JMS " + operacion);
    		
    		 if (message instanceof TextMessage) {
    			 Aa20bProcessErrorMessage.logger.info("Es mensaje texto");
    		 }
    		
    		
    		
    	/*}catch(JMSException jmse){
    		Aa20bProcessErrorMessage.logger.error("JMS Excepcion " + jmse.getMessage());
    		jmse.printStackTrace();
    		context.setRollbackOnly();
    	}*/
    	}catch(Exception e){
    		Aa20bProcessErrorMessage.logger.error("Excepcion general POST Gmao: " + e.toString());
    		e.printStackTrace();
    		context.setRollbackOnly();
    	}
    	catch(Throwable t){
    		Aa20bProcessErrorMessage.logger.error("JMS Excepcion " + t.getMessage());
    		t.printStackTrace();
    		context.setRollbackOnly();
    	}
		
		
	}
	

}
